/*!
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 *                     _            _       _           _       
 *                    | |___  __   / \   __| |_ __ ___ (_)_ __  
 *                    | __\ \/ /  / _ \ / _` | '_ ` _ \| | '_ \ 
 *                    | |_ >  <  / ___ \ (_| | | | | | | | | | |
 *                     \__/_/\_\/_/   \_\__,_|_| |_| |_|_|_| |_|
 *                                                              
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * Author: André Tabarra (https://github.com/tabarra)
 * Repository: https://github.com/tabarra/txAdmin
 * txAdmin is a free open source software provided under the license below.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * MIT License
 * 
 * Copyright (c) 2019-2024 André Tabarra <maintainer@txadmin.gg>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 * This distribution also includes third party code under their own licenses, which
 * can be found in ../THIRD-PARTY-LICENSES.txt or their respective repositories.
 * Attribution for non-code assets can be found at the bottom of ../README.md or at
 * the top of the respective file.
 * %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 */
"use strict";var __create=Object.create;var __defProp=Object.defineProperty;var __getOwnPropDesc=Object.getOwnPropertyDescriptor;var __getOwnPropNames=Object.getOwnPropertyNames;var __getProtoOf=Object.getPrototypeOf;var __hasOwnProp=Object.prototype.hasOwnProperty;var __esm=(fn2,res)=>function __init(){return fn2&&(res=(0,fn2[__getOwnPropNames(fn2)[0]])(fn2=0)),res};var __commonJS=(cb,mod3)=>function __require(){return mod3||(0,cb[__getOwnPropNames(cb)[0]])((mod3={exports:{}}).exports,mod3),mod3.exports};var __export=(target,all2)=>{for(var name in all2)__defProp(target,name,{get:all2[name],enumerable:true})};var __copyProps=(to,from,except,desc)=>{if(from&&typeof from==="object"||typeof from==="function"){for(let key of __getOwnPropNames(from))if(!__hasOwnProp.call(to,key)&&key!==except)__defProp(to,key,{get:()=>from[key],enumerable:!(desc=__getOwnPropDesc(from,key))||desc.enumerable})}return to};var __toESM=(mod3,isNodeMode,target)=>(target=mod3!=null?__create(__getProtoOf(mod3)):{},__copyProps(isNodeMode||!mod3||!mod3.__esModule?__defProp(target,"default",{value:mod3,enumerable:true}):target,mod3));var __toCommonJS=mod3=>__copyProps(__defProp({},"__esModule",{value:true}),mod3);var require_stackframe=__commonJS({"node_modules/stackframe/stackframe.js"(exports2,module2){(function(root2,factory){"use strict";if(typeof define==="function"&&define.amd){define("stackframe",[],factory)}else if(typeof exports2==="object"){module2.exports=factory()}else{root2.StackFrame=factory()}})(exports2,function(){"use strict";function _isNumber(n){return!isNaN(parseFloat(n))&&isFinite(n)}function _capitalize(str2){return str2.charAt(0).toUpperCase()+str2.substring(1)}function _getter(p){return function(){return this[p]}}var booleanProps=["isConstructor","isEval","isNative","isToplevel"];var numericProps=["columnNumber","lineNumber"];var stringProps=["fileName","functionName","source"];var arrayProps=["args"];var objectProps=["evalOrigin"];var props=booleanProps.concat(numericProps,stringProps,arrayProps,objectProps);function StackFrame(obj){if(!obj)return;for(var i2=0;i2<props.length;i2++){if(obj[props[i2]]!==void 0){this["set"+_capitalize(props[i2])](obj[props[i2]])}}}StackFrame.prototype={getArgs:function(){return this.args},setArgs:function(v){if(Object.prototype.toString.call(v)!=="[object Array]"){throw new TypeError("Args must be an Array")}this.args=v},getEvalOrigin:function(){return this.evalOrigin},setEvalOrigin:function(v){if(v instanceof StackFrame){this.evalOrigin=v}else if(v instanceof Object){this.evalOrigin=new StackFrame(v)}else{throw new TypeError("Eval Origin must be an Object or StackFrame")}},toString:function(){var fileName=this.getFileName()||"";var lineNumber=this.getLineNumber()||"";var columnNumber=this.getColumnNumber()||"";var functionName=this.getFunctionName()||"";if(this.getIsEval()){if(fileName){return"[eval] ("+fileName+":"+lineNumber+":"+columnNumber+")"}return"[eval]:"+lineNumber+":"+columnNumber}if(functionName){return functionName+" ("+fileName+":"+lineNumber+":"+columnNumber+")"}return fileName+":"+lineNumber+":"+columnNumber}};StackFrame.fromString=function StackFrame$$fromString(str2){var argsStartIndex=str2.indexOf("(");var argsEndIndex=str2.lastIndexOf(")");var functionName=str2.substring(0,argsStartIndex);var args2=str2.substring(argsStartIndex+1,argsEndIndex).split(",");var locationString=str2.substring(argsEndIndex+1);if(locationString.indexOf("@")===0){var parts=/@(.+?)(?::(\d+))?(?::(\d+))?$/.exec(locationString,"");var fileName=parts[1];var lineNumber=parts[2];var columnNumber=parts[3]}return new StackFrame({functionName,args:args2||void 0,fileName,lineNumber:lineNumber||void 0,columnNumber:columnNumber||void 0})};for(var i=0;i<booleanProps.length;i++){StackFrame.prototype["get"+_capitalize(booleanProps[i])]=_getter(booleanProps[i]);StackFrame.prototype["set"+_capitalize(booleanProps[i])]=function(p){return function(v){this[p]=Boolean(v)}}(booleanProps[i])}for(var j=0;j<numericProps.length;j++){StackFrame.prototype["get"+_capitalize(numericProps[j])]=_getter(numericProps[j]);StackFrame.prototype["set"+_capitalize(numericProps[j])]=function(p){return function(v){if(!_isNumber(v)){throw new TypeError(p+" must be a Number")}this[p]=Number(v)}}(numericProps[j])}for(var k=0;k<stringProps.length;k++){StackFrame.prototype["get"+_capitalize(stringProps[k])]=_getter(stringProps[k]);StackFrame.prototype["set"+_capitalize(stringProps[k])]=function(p){return function(v){this[p]=String(v)}}(stringProps[k])}return StackFrame})}});var require_error_stack_parser=__commonJS({"node_modules/error-stack-parser/error-stack-parser.js"(exports2,module2){(function(root2,factory){"use strict";if(typeof define==="function"&&define.amd){define("error-stack-parser",["stackframe"],factory)}else if(typeof exports2==="object"){module2.exports=factory(require_stackframe())}else{root2.ErrorStackParser=factory(root2.StackFrame)}})(exports2,function ErrorStackParser2(StackFrame){"use strict";var FIREFOX_SAFARI_STACK_REGEXP=/(^|@)\S+:\d+/;var CHROME_IE_STACK_REGEXP=/^\s*at .*(\S+:\d+|\(native\))/m;var SAFARI_NATIVE_CODE_REGEXP=/^(eval@)?(\[native code])?$/;return{parse:function ErrorStackParser$$parse(error){if(typeof error.stacktrace!=="undefined"||typeof error["opera#sourceloc"]!=="undefined"){return this.parseOpera(error)}else if(error.stack&&error.stack.match(CHROME_IE_STACK_REGEXP)){return this.parseV8OrIE(error)}else if(error.stack){return this.parseFFOrSafari(error)}else{throw new Error("Cannot parse given Error object")}},extractLocation:function ErrorStackParser$$extractLocation(urlLike){if(urlLike.indexOf(":")===-1){return[urlLike]}var regExp=/(.+?)(?::(\d+))?(?::(\d+))?$/;var parts=regExp.exec(urlLike.replace(/[()]/g,""));return[parts[1],parts[2]||void 0,parts[3]||void 0]},parseV8OrIE:function ErrorStackParser$$parseV8OrIE(error){var filtered=error.stack.split("\n").filter(function(line){return!!line.match(CHROME_IE_STACK_REGEXP)},this);return filtered.map(function(line){if(line.indexOf("(eval ")>-1){line=line.replace(/eval code/g,"eval").replace(/(\(eval at [^()]*)|(,.*$)/g,"")}var sanitizedLine=line.replace(/^\s+/,"").replace(/\(eval code/g,"(").replace(/^.*?\s+/,"");var location=sanitizedLine.match(/ (\(.+\)$)/);sanitizedLine=location?sanitizedLine.replace(location[0],""):sanitizedLine;var locationParts=this.extractLocation(location?location[1]:sanitizedLine);var functionName=location&&sanitizedLine||void 0;var fileName=["eval","<anonymous>"].indexOf(locationParts[0])>-1?void 0:locationParts[0];return new StackFrame({functionName,fileName,lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})},this)},parseFFOrSafari:function ErrorStackParser$$parseFFOrSafari(error){var filtered=error.stack.split("\n").filter(function(line){return!line.match(SAFARI_NATIVE_CODE_REGEXP)},this);return filtered.map(function(line){if(line.indexOf(" > eval")>-1){line=line.replace(/ line (\d+)(?: > eval line \d+)* > eval:\d+:\d+/g,":$1")}if(line.indexOf("@")===-1&&line.indexOf(":")===-1){return new StackFrame({functionName:line})}else{var functionNameRegex=/((.*".+"[^@]*)?[^@]*)(?:@)/;var matches2=line.match(functionNameRegex);var functionName=matches2&&matches2[1]?matches2[1]:void 0;var locationParts=this.extractLocation(line.replace(functionNameRegex,""));return new StackFrame({functionName,fileName:locationParts[0],lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})}},this)},parseOpera:function ErrorStackParser$$parseOpera(e){if(!e.stacktrace||e.message.indexOf("\n")>-1&&e.message.split("\n").length>e.stacktrace.split("\n").length){return this.parseOpera9(e)}else if(!e.stack){return this.parseOpera10(e)}else{return this.parseOpera11(e)}},parseOpera9:function ErrorStackParser$$parseOpera9(e){var lineRE=/Line (\d+).*script (?:in )?(\S+)/i;var lines=e.message.split("\n");var result2=[];for(var i=2,len=lines.length;i<len;i+=2){var match=lineRE.exec(lines[i]);if(match){result2.push(new StackFrame({fileName:match[2],lineNumber:match[1],source:lines[i]}))}}return result2},parseOpera10:function ErrorStackParser$$parseOpera10(e){var lineRE=/Line (\d+).*script (?:in )?(\S+)(?:: In function (\S+))?$/i;var lines=e.stacktrace.split("\n");var result2=[];for(var i=0,len=lines.length;i<len;i+=2){var match=lineRE.exec(lines[i]);if(match){result2.push(new StackFrame({functionName:match[3]||void 0,fileName:match[2],lineNumber:match[1],source:lines[i]}))}}return result2},parseOpera11:function ErrorStackParser$$parseOpera11(error){var filtered=error.stack.split("\n").filter(function(line){return!!line.match(FIREFOX_SAFARI_STACK_REGEXP)&&!line.match(/^Error created at/)},this);return filtered.map(function(line){var tokens=line.split("@");var locationParts=this.extractLocation(tokens.pop());var functionCall=tokens.shift()||"";var functionName=functionCall.replace(/<anonymous function(: (\w+))?>/,"$2").replace(/\([^)]*\)/g,"")||void 0;var argsRaw;if(functionCall.match(/\(([^)]*)\)/)){argsRaw=functionCall.replace(/^[^(]+\(([^)]*)\)$/,"$1")}var args2=argsRaw===void 0||argsRaw==="[arguments not available]"?void 0:argsRaw.split(",");return new StackFrame({functionName,args:args2,fileName:locationParts[0],lineNumber:locationParts[1],columnNumber:locationParts[2],source:line})},this)}}})}});var require_base64=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/base64.js"(exports2){var intToCharMap="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");exports2.encode=function(number2){if(0<=number2&&number2<intToCharMap.length){return intToCharMap[number2]}throw new TypeError("Must be between 0 and 63: "+number2)};exports2.decode=function(charCode){var bigA=65;var bigZ=90;var littleA=97;var littleZ=122;var zero=48;var nine=57;var plus=43;var slash2=47;var littleOffset=26;var numberOffset=52;if(bigA<=charCode&&charCode<=bigZ){return charCode-bigA}if(littleA<=charCode&&charCode<=littleZ){return charCode-littleA+littleOffset}if(zero<=charCode&&charCode<=nine){return charCode-zero+numberOffset}if(charCode==plus){return 62}if(charCode==slash2){return 63}return-1}}});var require_base64_vlq=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/base64-vlq.js"(exports2){var base64=require_base64();var VLQ_BASE_SHIFT=5;var VLQ_BASE=1<<VLQ_BASE_SHIFT;var VLQ_BASE_MASK=VLQ_BASE-1;var VLQ_CONTINUATION_BIT=VLQ_BASE;function toVLQSigned(aValue){return aValue<0?(-aValue<<1)+1:(aValue<<1)+0}function fromVLQSigned(aValue){var isNegative=(aValue&1)===1;var shifted=aValue>>1;return isNegative?-shifted:shifted}exports2.encode=function base64VLQ_encode(aValue){var encoded="";var digit;var vlq=toVLQSigned(aValue);do{digit=vlq&VLQ_BASE_MASK;vlq>>>=VLQ_BASE_SHIFT;if(vlq>0){digit|=VLQ_CONTINUATION_BIT}encoded+=base64.encode(digit)}while(vlq>0);return encoded};exports2.decode=function base64VLQ_decode(aStr,aIndex,aOutParam){var strLen=aStr.length;var result2=0;var shift=0;var continuation,digit;do{if(aIndex>=strLen){throw new Error("Expected more digits in base 64 VLQ value.")}digit=base64.decode(aStr.charCodeAt(aIndex++));if(digit===-1){throw new Error("Invalid base64 digit: "+aStr.charAt(aIndex-1))}continuation=!!(digit&VLQ_CONTINUATION_BIT);digit&=VLQ_BASE_MASK;result2=result2+(digit<<shift);shift+=VLQ_BASE_SHIFT}while(continuation);aOutParam.value=fromVLQSigned(result2);aOutParam.rest=aIndex}}});var require_util=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/util.js"(exports2){function getArg(aArgs,aName,aDefaultValue){if(aName in aArgs){return aArgs[aName]}else if(arguments.length===3){return aDefaultValue}else{throw new Error('"'+aName+'" is a required argument.')}}exports2.getArg=getArg;var urlRegexp=/^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;var dataUrlRegexp=/^data:.+\,.+$/;function urlParse(aUrl){var match=aUrl.match(urlRegexp);if(!match){return null}return{scheme:match[1],auth:match[2],host:match[3],port:match[4],path:match[5]}}exports2.urlParse=urlParse;function urlGenerate(aParsedUrl){var url="";if(aParsedUrl.scheme){url+=aParsedUrl.scheme+":"}url+="//";if(aParsedUrl.auth){url+=aParsedUrl.auth+"@"}if(aParsedUrl.host){url+=aParsedUrl.host}if(aParsedUrl.port){url+=":"+aParsedUrl.port}if(aParsedUrl.path){url+=aParsedUrl.path}return url}exports2.urlGenerate=urlGenerate;function normalize(aPath){var path23=aPath;var url=urlParse(aPath);if(url){if(!url.path){return aPath}path23=url.path}var isAbsolute=exports2.isAbsolute(path23);var parts=path23.split(/\/+/);for(var part,up=0,i=parts.length-1;i>=0;i--){part=parts[i];if(part==="."){parts.splice(i,1)}else if(part===".."){up++}else if(up>0){if(part===""){parts.splice(i+1,up);up=0}else{parts.splice(i,2);up--}}}path23=parts.join("/");if(path23===""){path23=isAbsolute?"/":"."}if(url){url.path=path23;return urlGenerate(url)}return path23}exports2.normalize=normalize;function join4(aRoot,aPath){if(aRoot===""){aRoot="."}if(aPath===""){aPath="."}var aPathUrl=urlParse(aPath);var aRootUrl=urlParse(aRoot);if(aRootUrl){aRoot=aRootUrl.path||"/"}if(aPathUrl&&!aPathUrl.scheme){if(aRootUrl){aPathUrl.scheme=aRootUrl.scheme}return urlGenerate(aPathUrl)}if(aPathUrl||aPath.match(dataUrlRegexp)){return aPath}if(aRootUrl&&!aRootUrl.host&&!aRootUrl.path){aRootUrl.host=aPath;return urlGenerate(aRootUrl)}var joined=aPath.charAt(0)==="/"?aPath:normalize(aRoot.replace(/\/+$/,"")+"/"+aPath);if(aRootUrl){aRootUrl.path=joined;return urlGenerate(aRootUrl)}return joined}exports2.join=join4;exports2.isAbsolute=function(aPath){return aPath.charAt(0)==="/"||urlRegexp.test(aPath)};function relative3(aRoot,aPath){if(aRoot===""){aRoot="."}aRoot=aRoot.replace(/\/$/,"");var level=0;while(aPath.indexOf(aRoot+"/")!==0){var index=aRoot.lastIndexOf("/");if(index<0){return aPath}aRoot=aRoot.slice(0,index);if(aRoot.match(/^([^\/]+:\/)?\/*$/)){return aPath}++level}return Array(level+1).join("../")+aPath.substr(aRoot.length+1)}exports2.relative=relative3;var supportsNullProto=function(){var obj=Object.create(null);return!("__proto__"in obj)}();function identity2(s){return s}function toSetString(aStr){if(isProtoString(aStr)){return"$"+aStr}return aStr}exports2.toSetString=supportsNullProto?identity2:toSetString;function fromSetString(aStr){if(isProtoString(aStr)){return aStr.slice(1)}return aStr}exports2.fromSetString=supportsNullProto?identity2:fromSetString;function isProtoString(s){if(!s){return false}var length=s.length;if(length<9){return false}if(s.charCodeAt(length-1)!==95||s.charCodeAt(length-2)!==95||s.charCodeAt(length-3)!==111||s.charCodeAt(length-4)!==116||s.charCodeAt(length-5)!==111||s.charCodeAt(length-6)!==114||s.charCodeAt(length-7)!==112||s.charCodeAt(length-8)!==95||s.charCodeAt(length-9)!==95){return false}for(var i=length-10;i>=0;i--){if(s.charCodeAt(i)!==36){return false}}return true}function compareByOriginalPositions(mappingA,mappingB,onlyCompareOriginal){var cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0||onlyCompareOriginal){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0){return cmp}cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByOriginalPositions=compareByOriginalPositions;function compareByGeneratedPositionsDeflated(mappingA,mappingB,onlyCompareGenerated){var cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0||onlyCompareGenerated){return cmp}cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByGeneratedPositionsDeflated=compareByGeneratedPositionsDeflated;function strcmp(aStr1,aStr2){if(aStr1===aStr2){return 0}if(aStr1===null){return 1}if(aStr2===null){return-1}if(aStr1>aStr2){return 1}return-1}function compareByGeneratedPositionsInflated(mappingA,mappingB){var cmp=mappingA.generatedLine-mappingB.generatedLine;if(cmp!==0){return cmp}cmp=mappingA.generatedColumn-mappingB.generatedColumn;if(cmp!==0){return cmp}cmp=strcmp(mappingA.source,mappingB.source);if(cmp!==0){return cmp}cmp=mappingA.originalLine-mappingB.originalLine;if(cmp!==0){return cmp}cmp=mappingA.originalColumn-mappingB.originalColumn;if(cmp!==0){return cmp}return strcmp(mappingA.name,mappingB.name)}exports2.compareByGeneratedPositionsInflated=compareByGeneratedPositionsInflated;function parseSourceMapInput(str2){return JSON.parse(str2.replace(/^\)]}'[^\n]*\n/,""))}exports2.parseSourceMapInput=parseSourceMapInput;function computeSourceURL(sourceRoot,sourceURL,sourceMapURL){sourceURL=sourceURL||"";if(sourceRoot){if(sourceRoot[sourceRoot.length-1]!=="/"&&sourceURL[0]!=="/"){sourceRoot+="/"}sourceURL=sourceRoot+sourceURL}if(sourceMapURL){var parsed=urlParse(sourceMapURL);if(!parsed){throw new Error("sourceMapURL could not be parsed")}if(parsed.path){var index=parsed.path.lastIndexOf("/");if(index>=0){parsed.path=parsed.path.substring(0,index+1)}}sourceURL=join4(urlGenerate(parsed),sourceURL)}return normalize(sourceURL)}exports2.computeSourceURL=computeSourceURL}});var require_array_set=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/array-set.js"(exports2){var util4=require_util();var has2=Object.prototype.hasOwnProperty;var hasNativeMap=typeof Map!=="undefined";function ArraySet(){this._array=[];this._set=hasNativeMap?new Map:Object.create(null)}ArraySet.fromArray=function ArraySet_fromArray(aArray,aAllowDuplicates){var set3=new ArraySet;for(var i=0,len=aArray.length;i<len;i++){set3.add(aArray[i],aAllowDuplicates)}return set3};ArraySet.prototype.size=function ArraySet_size(){return hasNativeMap?this._set.size:Object.getOwnPropertyNames(this._set).length};ArraySet.prototype.add=function ArraySet_add(aStr,aAllowDuplicates){var sStr=hasNativeMap?aStr:util4.toSetString(aStr);var isDuplicate=hasNativeMap?this.has(aStr):has2.call(this._set,sStr);var idx=this._array.length;if(!isDuplicate||aAllowDuplicates){this._array.push(aStr)}if(!isDuplicate){if(hasNativeMap){this._set.set(aStr,idx)}else{this._set[sStr]=idx}}};ArraySet.prototype.has=function ArraySet_has(aStr){if(hasNativeMap){return this._set.has(aStr)}else{var sStr=util4.toSetString(aStr);return has2.call(this._set,sStr)}};ArraySet.prototype.indexOf=function ArraySet_indexOf(aStr){if(hasNativeMap){var idx=this._set.get(aStr);if(idx>=0){return idx}}else{var sStr=util4.toSetString(aStr);if(has2.call(this._set,sStr)){return this._set[sStr]}}throw new Error('"'+aStr+'" is not in the set.')};ArraySet.prototype.at=function ArraySet_at(aIdx){if(aIdx>=0&&aIdx<this._array.length){return this._array[aIdx]}throw new Error("No element indexed by "+aIdx)};ArraySet.prototype.toArray=function ArraySet_toArray(){return this._array.slice()};exports2.ArraySet=ArraySet}});var require_mapping_list=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/mapping-list.js"(exports2){var util4=require_util();function generatedPositionAfter(mappingA,mappingB){var lineA=mappingA.generatedLine;var lineB=mappingB.generatedLine;var columnA=mappingA.generatedColumn;var columnB=mappingB.generatedColumn;return lineB>lineA||lineB==lineA&&columnB>=columnA||util4.compareByGeneratedPositionsInflated(mappingA,mappingB)<=0}function MappingList(){this._array=[];this._sorted=true;this._last={generatedLine:-1,generatedColumn:0}}MappingList.prototype.unsortedForEach=function MappingList_forEach(aCallback,aThisArg){this._array.forEach(aCallback,aThisArg)};MappingList.prototype.add=function MappingList_add(aMapping){if(generatedPositionAfter(this._last,aMapping)){this._last=aMapping;this._array.push(aMapping)}else{this._sorted=false;this._array.push(aMapping)}};MappingList.prototype.toArray=function MappingList_toArray(){if(!this._sorted){this._array.sort(util4.compareByGeneratedPositionsInflated);this._sorted=true}return this._array};exports2.MappingList=MappingList}});var require_source_map_generator=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-map-generator.js"(exports2){var base64VLQ=require_base64_vlq();var util4=require_util();var ArraySet=require_array_set().ArraySet;var MappingList=require_mapping_list().MappingList;function SourceMapGenerator(aArgs){if(!aArgs){aArgs={}}this._file=util4.getArg(aArgs,"file",null);this._sourceRoot=util4.getArg(aArgs,"sourceRoot",null);this._skipValidation=util4.getArg(aArgs,"skipValidation",false);this._sources=new ArraySet;this._names=new ArraySet;this._mappings=new MappingList;this._sourcesContents=null}SourceMapGenerator.prototype._version=3;SourceMapGenerator.fromSourceMap=function SourceMapGenerator_fromSourceMap(aSourceMapConsumer){var sourceRoot=aSourceMapConsumer.sourceRoot;var generator=new SourceMapGenerator({file:aSourceMapConsumer.file,sourceRoot});aSourceMapConsumer.eachMapping(function(mapping){var newMapping={generated:{line:mapping.generatedLine,column:mapping.generatedColumn}};if(mapping.source!=null){newMapping.source=mapping.source;if(sourceRoot!=null){newMapping.source=util4.relative(sourceRoot,newMapping.source)}newMapping.original={line:mapping.originalLine,column:mapping.originalColumn};if(mapping.name!=null){newMapping.name=mapping.name}}generator.addMapping(newMapping)});aSourceMapConsumer.sources.forEach(function(sourceFile){var sourceRelative=sourceFile;if(sourceRoot!==null){sourceRelative=util4.relative(sourceRoot,sourceFile)}if(!generator._sources.has(sourceRelative)){generator._sources.add(sourceRelative)}var content=aSourceMapConsumer.sourceContentFor(sourceFile);if(content!=null){generator.setSourceContent(sourceFile,content)}});return generator};SourceMapGenerator.prototype.addMapping=function SourceMapGenerator_addMapping(aArgs){var generated=util4.getArg(aArgs,"generated");var original=util4.getArg(aArgs,"original",null);var source=util4.getArg(aArgs,"source",null);var name=util4.getArg(aArgs,"name",null);if(!this._skipValidation){this._validateMapping(generated,original,source,name)}if(source!=null){source=String(source);if(!this._sources.has(source)){this._sources.add(source)}}if(name!=null){name=String(name);if(!this._names.has(name)){this._names.add(name)}}this._mappings.add({generatedLine:generated.line,generatedColumn:generated.column,originalLine:original!=null&&original.line,originalColumn:original!=null&&original.column,source,name})};SourceMapGenerator.prototype.setSourceContent=function SourceMapGenerator_setSourceContent(aSourceFile,aSourceContent){var source=aSourceFile;if(this._sourceRoot!=null){source=util4.relative(this._sourceRoot,source)}if(aSourceContent!=null){if(!this._sourcesContents){this._sourcesContents=Object.create(null)}this._sourcesContents[util4.toSetString(source)]=aSourceContent}else if(this._sourcesContents){delete this._sourcesContents[util4.toSetString(source)];if(Object.keys(this._sourcesContents).length===0){this._sourcesContents=null}}};SourceMapGenerator.prototype.applySourceMap=function SourceMapGenerator_applySourceMap(aSourceMapConsumer,aSourceFile,aSourceMapPath){var sourceFile=aSourceFile;if(aSourceFile==null){if(aSourceMapConsumer.file==null){throw new Error(`SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`)}sourceFile=aSourceMapConsumer.file}var sourceRoot=this._sourceRoot;if(sourceRoot!=null){sourceFile=util4.relative(sourceRoot,sourceFile)}var newSources=new ArraySet;var newNames=new ArraySet;this._mappings.unsortedForEach(function(mapping){if(mapping.source===sourceFile&&mapping.originalLine!=null){var original=aSourceMapConsumer.originalPositionFor({line:mapping.originalLine,column:mapping.originalColumn});if(original.source!=null){mapping.source=original.source;if(aSourceMapPath!=null){mapping.source=util4.join(aSourceMapPath,mapping.source)}if(sourceRoot!=null){mapping.source=util4.relative(sourceRoot,mapping.source)}mapping.originalLine=original.line;mapping.originalColumn=original.column;if(original.name!=null){mapping.name=original.name}}}var source=mapping.source;if(source!=null&&!newSources.has(source)){newSources.add(source)}var name=mapping.name;if(name!=null&&!newNames.has(name)){newNames.add(name)}},this);this._sources=newSources;this._names=newNames;aSourceMapConsumer.sources.forEach(function(sourceFile2){var content=aSourceMapConsumer.sourceContentFor(sourceFile2);if(content!=null){if(aSourceMapPath!=null){sourceFile2=util4.join(aSourceMapPath,sourceFile2)}if(sourceRoot!=null){sourceFile2=util4.relative(sourceRoot,sourceFile2)}this.setSourceContent(sourceFile2,content)}},this)};SourceMapGenerator.prototype._validateMapping=function SourceMapGenerator_validateMapping(aGenerated,aOriginal,aSource,aName){if(aOriginal&&typeof aOriginal.line!=="number"&&typeof aOriginal.column!=="number"){throw new Error("original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values.")}if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aGenerated.line>0&&aGenerated.column>=0&&!aOriginal&&!aSource&&!aName){return}else if(aGenerated&&"line"in aGenerated&&"column"in aGenerated&&aOriginal&&"line"in aOriginal&&"column"in aOriginal&&aGenerated.line>0&&aGenerated.column>=0&&aOriginal.line>0&&aOriginal.column>=0&&aSource){return}else{throw new Error("Invalid mapping: "+JSON.stringify({generated:aGenerated,source:aSource,original:aOriginal,name:aName}))}};SourceMapGenerator.prototype._serializeMappings=function SourceMapGenerator_serializeMappings(){var previousGeneratedColumn=0;var previousGeneratedLine=1;var previousOriginalColumn=0;var previousOriginalLine=0;var previousName=0;var previousSource=0;var result2="";var next;var mapping;var nameIdx;var sourceIdx;var mappings=this._mappings.toArray();for(var i=0,len=mappings.length;i<len;i++){mapping=mappings[i];next="";if(mapping.generatedLine!==previousGeneratedLine){previousGeneratedColumn=0;while(mapping.generatedLine!==previousGeneratedLine){next+=";";previousGeneratedLine++}}else{if(i>0){if(!util4.compareByGeneratedPositionsInflated(mapping,mappings[i-1])){continue}next+=","}}next+=base64VLQ.encode(mapping.generatedColumn-previousGeneratedColumn);previousGeneratedColumn=mapping.generatedColumn;if(mapping.source!=null){sourceIdx=this._sources.indexOf(mapping.source);next+=base64VLQ.encode(sourceIdx-previousSource);previousSource=sourceIdx;next+=base64VLQ.encode(mapping.originalLine-1-previousOriginalLine);previousOriginalLine=mapping.originalLine-1;next+=base64VLQ.encode(mapping.originalColumn-previousOriginalColumn);previousOriginalColumn=mapping.originalColumn;if(mapping.name!=null){nameIdx=this._names.indexOf(mapping.name);next+=base64VLQ.encode(nameIdx-previousName);previousName=nameIdx}}result2+=next}return result2};SourceMapGenerator.prototype._generateSourcesContent=function SourceMapGenerator_generateSourcesContent(aSources,aSourceRoot){return aSources.map(function(source){if(!this._sourcesContents){return null}if(aSourceRoot!=null){source=util4.relative(aSourceRoot,source)}var key=util4.toSetString(source);return Object.prototype.hasOwnProperty.call(this._sourcesContents,key)?this._sourcesContents[key]:null},this)};SourceMapGenerator.prototype.toJSON=function SourceMapGenerator_toJSON(){var map3={version:this._version,sources:this._sources.toArray(),names:this._names.toArray(),mappings:this._serializeMappings()};if(this._file!=null){map3.file=this._file}if(this._sourceRoot!=null){map3.sourceRoot=this._sourceRoot}if(this._sourcesContents){map3.sourcesContent=this._generateSourcesContent(map3.sources,map3.sourceRoot)}return map3};SourceMapGenerator.prototype.toString=function SourceMapGenerator_toString(){return JSON.stringify(this.toJSON())};exports2.SourceMapGenerator=SourceMapGenerator}});var require_binary_search=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/binary-search.js"(exports2){exports2.GREATEST_LOWER_BOUND=1;exports2.LEAST_UPPER_BOUND=2;function recursiveSearch(aLow,aHigh,aNeedle,aHaystack,aCompare,aBias){var mid=Math.floor((aHigh-aLow)/2)+aLow;var cmp=aCompare(aNeedle,aHaystack[mid],true);if(cmp===0){return mid}else if(cmp>0){if(aHigh-mid>1){return recursiveSearch(mid,aHigh,aNeedle,aHaystack,aCompare,aBias)}if(aBias==exports2.LEAST_UPPER_BOUND){return aHigh<aHaystack.length?aHigh:-1}else{return mid}}else{if(mid-aLow>1){return recursiveSearch(aLow,mid,aNeedle,aHaystack,aCompare,aBias)}if(aBias==exports2.LEAST_UPPER_BOUND){return mid}else{return aLow<0?-1:aLow}}}exports2.search=function search2(aNeedle,aHaystack,aCompare,aBias){if(aHaystack.length===0){return-1}var index=recursiveSearch(-1,aHaystack.length,aNeedle,aHaystack,aCompare,aBias||exports2.GREATEST_LOWER_BOUND);if(index<0){return-1}while(index-1>=0){if(aCompare(aHaystack[index],aHaystack[index-1],true)!==0){break}--index}return index}}});var require_quick_sort=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/quick-sort.js"(exports2){function swap2(ary2,x,y){var temp=ary2[x];ary2[x]=ary2[y];ary2[y]=temp}function randomIntInRange(low,high){return Math.round(low+Math.random()*(high-low))}function doQuickSort(ary2,comparator,p,r){if(p<r){var pivotIndex=randomIntInRange(p,r);var i=p-1;swap2(ary2,pivotIndex,r);var pivot=ary2[r];for(var j=p;j<r;j++){if(comparator(ary2[j],pivot)<=0){i+=1;swap2(ary2,i,j)}}swap2(ary2,i+1,j);var q=i+1;doQuickSort(ary2,comparator,p,q-1);doQuickSort(ary2,comparator,q+1,r)}}exports2.quickSort=function(ary2,comparator){doQuickSort(ary2,comparator,0,ary2.length-1)}}});var require_source_map_consumer=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-map-consumer.js"(exports2){var util4=require_util();var binarySearch=require_binary_search();var ArraySet=require_array_set().ArraySet;var base64VLQ=require_base64_vlq();var quickSort=require_quick_sort().quickSort;function SourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}return sourceMap.sections!=null?new IndexedSourceMapConsumer(sourceMap,aSourceMapURL):new BasicSourceMapConsumer(sourceMap,aSourceMapURL)}SourceMapConsumer.fromSourceMap=function(aSourceMap,aSourceMapURL){return BasicSourceMapConsumer.fromSourceMap(aSourceMap,aSourceMapURL)};SourceMapConsumer.prototype._version=3;SourceMapConsumer.prototype.__generatedMappings=null;Object.defineProperty(SourceMapConsumer.prototype,"_generatedMappings",{configurable:true,enumerable:true,get:function(){if(!this.__generatedMappings){this._parseMappings(this._mappings,this.sourceRoot)}return this.__generatedMappings}});SourceMapConsumer.prototype.__originalMappings=null;Object.defineProperty(SourceMapConsumer.prototype,"_originalMappings",{configurable:true,enumerable:true,get:function(){if(!this.__originalMappings){this._parseMappings(this._mappings,this.sourceRoot)}return this.__originalMappings}});SourceMapConsumer.prototype._charIsMappingSeparator=function SourceMapConsumer_charIsMappingSeparator(aStr,index){var c=aStr.charAt(index);return c===";"||c===","};SourceMapConsumer.prototype._parseMappings=function SourceMapConsumer_parseMappings(aStr,aSourceRoot){throw new Error("Subclasses must implement _parseMappings")};SourceMapConsumer.GENERATED_ORDER=1;SourceMapConsumer.ORIGINAL_ORDER=2;SourceMapConsumer.GREATEST_LOWER_BOUND=1;SourceMapConsumer.LEAST_UPPER_BOUND=2;SourceMapConsumer.prototype.eachMapping=function SourceMapConsumer_eachMapping(aCallback,aContext,aOrder){var context=aContext||null;var order=aOrder||SourceMapConsumer.GENERATED_ORDER;var mappings;switch(order){case SourceMapConsumer.GENERATED_ORDER:mappings=this._generatedMappings;break;case SourceMapConsumer.ORIGINAL_ORDER:mappings=this._originalMappings;break;default:throw new Error("Unknown order of iteration.")}var sourceRoot=this.sourceRoot;mappings.map(function(mapping){var source=mapping.source===null?null:this._sources.at(mapping.source);source=util4.computeSourceURL(sourceRoot,source,this._sourceMapURL);return{source,generatedLine:mapping.generatedLine,generatedColumn:mapping.generatedColumn,originalLine:mapping.originalLine,originalColumn:mapping.originalColumn,name:mapping.name===null?null:this._names.at(mapping.name)}},this).forEach(aCallback,context)};SourceMapConsumer.prototype.allGeneratedPositionsFor=function SourceMapConsumer_allGeneratedPositionsFor(aArgs){var line=util4.getArg(aArgs,"line");var needle={source:util4.getArg(aArgs,"source"),originalLine:line,originalColumn:util4.getArg(aArgs,"column",0)};needle.source=this._findSourceIndex(needle.source);if(needle.source<0){return[]}var mappings=[];var index=this._findMapping(needle,this._originalMappings,"originalLine","originalColumn",util4.compareByOriginalPositions,binarySearch.LEAST_UPPER_BOUND);if(index>=0){var mapping=this._originalMappings[index];if(aArgs.column===void 0){var originalLine=mapping.originalLine;while(mapping&&mapping.originalLine===originalLine){mappings.push({line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)});mapping=this._originalMappings[++index]}}else{var originalColumn=mapping.originalColumn;while(mapping&&mapping.originalLine===line&&mapping.originalColumn==originalColumn){mappings.push({line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)});mapping=this._originalMappings[++index]}}}return mappings};exports2.SourceMapConsumer=SourceMapConsumer;function BasicSourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}var version=util4.getArg(sourceMap,"version");var sources=util4.getArg(sourceMap,"sources");var names2=util4.getArg(sourceMap,"names",[]);var sourceRoot=util4.getArg(sourceMap,"sourceRoot",null);var sourcesContent=util4.getArg(sourceMap,"sourcesContent",null);var mappings=util4.getArg(sourceMap,"mappings");var file=util4.getArg(sourceMap,"file",null);if(version!=this._version){throw new Error("Unsupported version: "+version)}if(sourceRoot){sourceRoot=util4.normalize(sourceRoot)}sources=sources.map(String).map(util4.normalize).map(function(source){return sourceRoot&&util4.isAbsolute(sourceRoot)&&util4.isAbsolute(source)?util4.relative(sourceRoot,source):source});this._names=ArraySet.fromArray(names2.map(String),true);this._sources=ArraySet.fromArray(sources,true);this._absoluteSources=this._sources.toArray().map(function(s){return util4.computeSourceURL(sourceRoot,s,aSourceMapURL)});this.sourceRoot=sourceRoot;this.sourcesContent=sourcesContent;this._mappings=mappings;this._sourceMapURL=aSourceMapURL;this.file=file}BasicSourceMapConsumer.prototype=Object.create(SourceMapConsumer.prototype);BasicSourceMapConsumer.prototype.consumer=SourceMapConsumer;BasicSourceMapConsumer.prototype._findSourceIndex=function(aSource){var relativeSource=aSource;if(this.sourceRoot!=null){relativeSource=util4.relative(this.sourceRoot,relativeSource)}if(this._sources.has(relativeSource)){return this._sources.indexOf(relativeSource)}var i;for(i=0;i<this._absoluteSources.length;++i){if(this._absoluteSources[i]==aSource){return i}}return-1};BasicSourceMapConsumer.fromSourceMap=function SourceMapConsumer_fromSourceMap(aSourceMap,aSourceMapURL){var smc=Object.create(BasicSourceMapConsumer.prototype);var names2=smc._names=ArraySet.fromArray(aSourceMap._names.toArray(),true);var sources=smc._sources=ArraySet.fromArray(aSourceMap._sources.toArray(),true);smc.sourceRoot=aSourceMap._sourceRoot;smc.sourcesContent=aSourceMap._generateSourcesContent(smc._sources.toArray(),smc.sourceRoot);smc.file=aSourceMap._file;smc._sourceMapURL=aSourceMapURL;smc._absoluteSources=smc._sources.toArray().map(function(s){return util4.computeSourceURL(smc.sourceRoot,s,aSourceMapURL)});var generatedMappings=aSourceMap._mappings.toArray().slice();var destGeneratedMappings=smc.__generatedMappings=[];var destOriginalMappings=smc.__originalMappings=[];for(var i=0,length=generatedMappings.length;i<length;i++){var srcMapping=generatedMappings[i];var destMapping=new Mapping;destMapping.generatedLine=srcMapping.generatedLine;destMapping.generatedColumn=srcMapping.generatedColumn;if(srcMapping.source){destMapping.source=sources.indexOf(srcMapping.source);destMapping.originalLine=srcMapping.originalLine;destMapping.originalColumn=srcMapping.originalColumn;if(srcMapping.name){destMapping.name=names2.indexOf(srcMapping.name)}destOriginalMappings.push(destMapping)}destGeneratedMappings.push(destMapping)}quickSort(smc.__originalMappings,util4.compareByOriginalPositions);return smc};BasicSourceMapConsumer.prototype._version=3;Object.defineProperty(BasicSourceMapConsumer.prototype,"sources",{get:function(){return this._absoluteSources.slice()}});function Mapping(){this.generatedLine=0;this.generatedColumn=0;this.source=null;this.originalLine=null;this.originalColumn=null;this.name=null}BasicSourceMapConsumer.prototype._parseMappings=function SourceMapConsumer_parseMappings(aStr,aSourceRoot){var generatedLine=1;var previousGeneratedColumn=0;var previousOriginalLine=0;var previousOriginalColumn=0;var previousSource=0;var previousName=0;var length=aStr.length;var index=0;var cachedSegments={};var temp={};var originalMappings=[];var generatedMappings=[];var mapping,str2,segment,end,value;while(index<length){if(aStr.charAt(index)===";"){generatedLine++;index++;previousGeneratedColumn=0}else if(aStr.charAt(index)===","){index++}else{mapping=new Mapping;mapping.generatedLine=generatedLine;for(end=index;end<length;end++){if(this._charIsMappingSeparator(aStr,end)){break}}str2=aStr.slice(index,end);segment=cachedSegments[str2];if(segment){index+=str2.length}else{segment=[];while(index<end){base64VLQ.decode(aStr,index,temp);value=temp.value;index=temp.rest;segment.push(value)}if(segment.length===2){throw new Error("Found a source, but no line and column")}if(segment.length===3){throw new Error("Found a source and line, but no column")}cachedSegments[str2]=segment}mapping.generatedColumn=previousGeneratedColumn+segment[0];previousGeneratedColumn=mapping.generatedColumn;if(segment.length>1){mapping.source=previousSource+segment[1];previousSource+=segment[1];mapping.originalLine=previousOriginalLine+segment[2];previousOriginalLine=mapping.originalLine;mapping.originalLine+=1;mapping.originalColumn=previousOriginalColumn+segment[3];previousOriginalColumn=mapping.originalColumn;if(segment.length>4){mapping.name=previousName+segment[4];previousName+=segment[4]}}generatedMappings.push(mapping);if(typeof mapping.originalLine==="number"){originalMappings.push(mapping)}}}quickSort(generatedMappings,util4.compareByGeneratedPositionsDeflated);this.__generatedMappings=generatedMappings;quickSort(originalMappings,util4.compareByOriginalPositions);this.__originalMappings=originalMappings};BasicSourceMapConsumer.prototype._findMapping=function SourceMapConsumer_findMapping(aNeedle,aMappings,aLineName,aColumnName,aComparator,aBias){if(aNeedle[aLineName]<=0){throw new TypeError("Line must be greater than or equal to 1, got "+aNeedle[aLineName])}if(aNeedle[aColumnName]<0){throw new TypeError("Column must be greater than or equal to 0, got "+aNeedle[aColumnName])}return binarySearch.search(aNeedle,aMappings,aComparator,aBias)};BasicSourceMapConsumer.prototype.computeColumnSpans=function SourceMapConsumer_computeColumnSpans(){for(var index=0;index<this._generatedMappings.length;++index){var mapping=this._generatedMappings[index];if(index+1<this._generatedMappings.length){var nextMapping=this._generatedMappings[index+1];if(mapping.generatedLine===nextMapping.generatedLine){mapping.lastGeneratedColumn=nextMapping.generatedColumn-1;continue}}mapping.lastGeneratedColumn=Infinity}};BasicSourceMapConsumer.prototype.originalPositionFor=function SourceMapConsumer_originalPositionFor(aArgs){var needle={generatedLine:util4.getArg(aArgs,"line"),generatedColumn:util4.getArg(aArgs,"column")};var index=this._findMapping(needle,this._generatedMappings,"generatedLine","generatedColumn",util4.compareByGeneratedPositionsDeflated,util4.getArg(aArgs,"bias",SourceMapConsumer.GREATEST_LOWER_BOUND));if(index>=0){var mapping=this._generatedMappings[index];if(mapping.generatedLine===needle.generatedLine){var source=util4.getArg(mapping,"source",null);if(source!==null){source=this._sources.at(source);source=util4.computeSourceURL(this.sourceRoot,source,this._sourceMapURL)}var name=util4.getArg(mapping,"name",null);if(name!==null){name=this._names.at(name)}return{source,line:util4.getArg(mapping,"originalLine",null),column:util4.getArg(mapping,"originalColumn",null),name}}}return{source:null,line:null,column:null,name:null}};BasicSourceMapConsumer.prototype.hasContentsOfAllSources=function BasicSourceMapConsumer_hasContentsOfAllSources(){if(!this.sourcesContent){return false}return this.sourcesContent.length>=this._sources.size()&&!this.sourcesContent.some(function(sc){return sc==null})};BasicSourceMapConsumer.prototype.sourceContentFor=function SourceMapConsumer_sourceContentFor(aSource,nullOnMissing){if(!this.sourcesContent){return null}var index=this._findSourceIndex(aSource);if(index>=0){return this.sourcesContent[index]}var relativeSource=aSource;if(this.sourceRoot!=null){relativeSource=util4.relative(this.sourceRoot,relativeSource)}var url;if(this.sourceRoot!=null&&(url=util4.urlParse(this.sourceRoot))){var fileUriAbsPath=relativeSource.replace(/^file:\/\//,"");if(url.scheme=="file"&&this._sources.has(fileUriAbsPath)){return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]}if((!url.path||url.path=="/")&&this._sources.has("/"+relativeSource)){return this.sourcesContent[this._sources.indexOf("/"+relativeSource)]}}if(nullOnMissing){return null}else{throw new Error('"'+relativeSource+'" is not in the SourceMap.')}};BasicSourceMapConsumer.prototype.generatedPositionFor=function SourceMapConsumer_generatedPositionFor(aArgs){var source=util4.getArg(aArgs,"source");source=this._findSourceIndex(source);if(source<0){return{line:null,column:null,lastColumn:null}}var needle={source,originalLine:util4.getArg(aArgs,"line"),originalColumn:util4.getArg(aArgs,"column")};var index=this._findMapping(needle,this._originalMappings,"originalLine","originalColumn",util4.compareByOriginalPositions,util4.getArg(aArgs,"bias",SourceMapConsumer.GREATEST_LOWER_BOUND));if(index>=0){var mapping=this._originalMappings[index];if(mapping.source===needle.source){return{line:util4.getArg(mapping,"generatedLine",null),column:util4.getArg(mapping,"generatedColumn",null),lastColumn:util4.getArg(mapping,"lastGeneratedColumn",null)}}}return{line:null,column:null,lastColumn:null}};exports2.BasicSourceMapConsumer=BasicSourceMapConsumer;function IndexedSourceMapConsumer(aSourceMap,aSourceMapURL){var sourceMap=aSourceMap;if(typeof aSourceMap==="string"){sourceMap=util4.parseSourceMapInput(aSourceMap)}var version=util4.getArg(sourceMap,"version");var sections=util4.getArg(sourceMap,"sections");if(version!=this._version){throw new Error("Unsupported version: "+version)}this._sources=new ArraySet;this._names=new ArraySet;var lastOffset={line:-1,column:0};this._sections=sections.map(function(s){if(s.url){throw new Error("Support for url field in sections not implemented.")}var offset=util4.getArg(s,"offset");var offsetLine=util4.getArg(offset,"line");var offsetColumn=util4.getArg(offset,"column");if(offsetLine<lastOffset.line||offsetLine===lastOffset.line&&offsetColumn<lastOffset.column){throw new Error("Section offsets must be ordered and non-overlapping.")}lastOffset=offset;return{generatedOffset:{generatedLine:offsetLine+1,generatedColumn:offsetColumn+1},consumer:new SourceMapConsumer(util4.getArg(s,"map"),aSourceMapURL)}})}IndexedSourceMapConsumer.prototype=Object.create(SourceMapConsumer.prototype);IndexedSourceMapConsumer.prototype.constructor=SourceMapConsumer;IndexedSourceMapConsumer.prototype._version=3;Object.defineProperty(IndexedSourceMapConsumer.prototype,"sources",{get:function(){var sources=[];for(var i=0;i<this._sections.length;i++){for(var j=0;j<this._sections[i].consumer.sources.length;j++){sources.push(this._sections[i].consumer.sources[j])}}return sources}});IndexedSourceMapConsumer.prototype.originalPositionFor=function IndexedSourceMapConsumer_originalPositionFor(aArgs){var needle={generatedLine:util4.getArg(aArgs,"line"),generatedColumn:util4.getArg(aArgs,"column")};var sectionIndex=binarySearch.search(needle,this._sections,function(needle2,section2){var cmp=needle2.generatedLine-section2.generatedOffset.generatedLine;if(cmp){return cmp}return needle2.generatedColumn-section2.generatedOffset.generatedColumn});var section=this._sections[sectionIndex];if(!section){return{source:null,line:null,column:null,name:null}}return section.consumer.originalPositionFor({line:needle.generatedLine-(section.generatedOffset.generatedLine-1),column:needle.generatedColumn-(section.generatedOffset.generatedLine===needle.generatedLine?section.generatedOffset.generatedColumn-1:0),bias:aArgs.bias})};IndexedSourceMapConsumer.prototype.hasContentsOfAllSources=function IndexedSourceMapConsumer_hasContentsOfAllSources(){return this._sections.every(function(s){return s.consumer.hasContentsOfAllSources()})};IndexedSourceMapConsumer.prototype.sourceContentFor=function IndexedSourceMapConsumer_sourceContentFor(aSource,nullOnMissing){for(var i=0;i<this._sections.length;i++){var section=this._sections[i];var content=section.consumer.sourceContentFor(aSource,true);if(content){return content}}if(nullOnMissing){return null}else{throw new Error('"'+aSource+'" is not in the SourceMap.')}};IndexedSourceMapConsumer.prototype.generatedPositionFor=function IndexedSourceMapConsumer_generatedPositionFor(aArgs){for(var i=0;i<this._sections.length;i++){var section=this._sections[i];if(section.consumer._findSourceIndex(util4.getArg(aArgs,"source"))===-1){continue}var generatedPosition=section.consumer.generatedPositionFor(aArgs);if(generatedPosition){var ret={line:generatedPosition.line+(section.generatedOffset.generatedLine-1),column:generatedPosition.column+(section.generatedOffset.generatedLine===generatedPosition.line?section.generatedOffset.generatedColumn-1:0)};return ret}}return{line:null,column:null}};IndexedSourceMapConsumer.prototype._parseMappings=function IndexedSourceMapConsumer_parseMappings(aStr,aSourceRoot){this.__generatedMappings=[];this.__originalMappings=[];for(var i=0;i<this._sections.length;i++){var section=this._sections[i];var sectionMappings=section.consumer._generatedMappings;for(var j=0;j<sectionMappings.length;j++){var mapping=sectionMappings[j];var source=section.consumer._sources.at(mapping.source);source=util4.computeSourceURL(section.consumer.sourceRoot,source,this._sourceMapURL);this._sources.add(source);source=this._sources.indexOf(source);var name=null;if(mapping.name){name=section.consumer._names.at(mapping.name);this._names.add(name);name=this._names.indexOf(name)}var adjustedMapping={source,generatedLine:mapping.generatedLine+(section.generatedOffset.generatedLine-1),generatedColumn:mapping.generatedColumn+(section.generatedOffset.generatedLine===mapping.generatedLine?section.generatedOffset.generatedColumn-1:0),originalLine:mapping.originalLine,originalColumn:mapping.originalColumn,name};this.__generatedMappings.push(adjustedMapping);if(typeof adjustedMapping.originalLine==="number"){this.__originalMappings.push(adjustedMapping)}}}quickSort(this.__generatedMappings,util4.compareByGeneratedPositionsDeflated);quickSort(this.__originalMappings,util4.compareByOriginalPositions)};exports2.IndexedSourceMapConsumer=IndexedSourceMapConsumer}});var require_source_node=__commonJS({"node_modules/source-map-support/node_modules/source-map/lib/source-node.js"(exports2){var SourceMapGenerator=require_source_map_generator().SourceMapGenerator;var util4=require_util();var REGEX_NEWLINE=/(\r?\n)/;var NEWLINE_CODE=10;var isSourceNode="$$$isSourceNode$$$";function SourceNode(aLine,aColumn,aSource,aChunks,aName){this.children=[];this.sourceContents={};this.line=aLine==null?null:aLine;this.column=aColumn==null?null:aColumn;this.source=aSource==null?null:aSource;this.name=aName==null?null:aName;this[isSourceNode]=true;if(aChunks!=null)this.add(aChunks)}SourceNode.fromStringWithSourceMap=function SourceNode_fromStringWithSourceMap(aGeneratedCode,aSourceMapConsumer,aRelativePath){var node=new SourceNode;var remainingLines=aGeneratedCode.split(REGEX_NEWLINE);var remainingLinesIndex=0;var shiftNextLine=function(){var lineContents=getNextLine();var newLine=getNextLine()||"";return lineContents+newLine;function getNextLine(){return remainingLinesIndex<remainingLines.length?remainingLines[remainingLinesIndex++]:void 0}};var lastGeneratedLine=1,lastGeneratedColumn=0;var lastMapping=null;aSourceMapConsumer.eachMapping(function(mapping){if(lastMapping!==null){if(lastGeneratedLine<mapping.generatedLine){addMappingWithCode(lastMapping,shiftNextLine());lastGeneratedLine++;lastGeneratedColumn=0}else{var nextLine=remainingLines[remainingLinesIndex]||"";var code=nextLine.substr(0,mapping.generatedColumn-lastGeneratedColumn);remainingLines[remainingLinesIndex]=nextLine.substr(mapping.generatedColumn-lastGeneratedColumn);lastGeneratedColumn=mapping.generatedColumn;addMappingWithCode(lastMapping,code);lastMapping=mapping;return}}while(lastGeneratedLine<mapping.generatedLine){node.add(shiftNextLine());lastGeneratedLine++}if(lastGeneratedColumn<mapping.generatedColumn){var nextLine=remainingLines[remainingLinesIndex]||"";node.add(nextLine.substr(0,mapping.generatedColumn));remainingLines[remainingLinesIndex]=nextLine.substr(mapping.generatedColumn);lastGeneratedColumn=mapping.generatedColumn}lastMapping=mapping},this);if(remainingLinesIndex<remainingLines.length){if(lastMapping){addMappingWithCode(lastMapping,shiftNextLine())}node.add(remainingLines.splice(remainingLinesIndex).join(""))}aSourceMapConsumer.sources.forEach(function(sourceFile){var content=aSourceMapConsumer.sourceContentFor(sourceFile);if(content!=null){if(aRelativePath!=null){sourceFile=util4.join(aRelativePath,sourceFile)}node.setSourceContent(sourceFile,content)}});return node;function addMappingWithCode(mapping,code){if(mapping===null||mapping.source===void 0){node.add(code)}else{var source=aRelativePath?util4.join(aRelativePath,mapping.source):mapping.source;node.add(new SourceNode(mapping.originalLine,mapping.originalColumn,source,code,mapping.name))}}};SourceNode.prototype.add=function SourceNode_add(aChunk){if(Array.isArray(aChunk)){aChunk.forEach(function(chunk2){this.add(chunk2)},this)}else if(aChunk[isSourceNode]||typeof aChunk==="string"){if(aChunk){this.children.push(aChunk)}}else{throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+aChunk)}return this};SourceNode.prototype.prepend=function SourceNode_prepend(aChunk){if(Array.isArray(aChunk)){for(var i=aChunk.length-1;i>=0;i--){this.prepend(aChunk[i])}}else if(aChunk[isSourceNode]||typeof aChunk==="string"){this.children.unshift(aChunk)}else{throw new TypeError("Expected a SourceNode, string, or an array of SourceNodes and strings. Got "+aChunk)}return this};SourceNode.prototype.walk=function SourceNode_walk(aFn){var chunk2;for(var i=0,len=this.children.length;i<len;i++){chunk2=this.children[i];if(chunk2[isSourceNode]){chunk2.walk(aFn)}else{if(chunk2!==""){aFn(chunk2,{source:this.source,line:this.line,column:this.column,name:this.name})}}}};SourceNode.prototype.join=function SourceNode_join(aSep){var newChildren;var i;var len=this.children.length;if(len>0){newChildren=[];for(i=0;i<len-1;i++){newChildren.push(this.children[i]);newChildren.push(aSep)}newChildren.push(this.children[i]);this.children=newChildren}return this};SourceNode.prototype.replaceRight=function SourceNode_replaceRight(aPattern,aReplacement){var lastChild=this.children[this.children.length-1];if(lastChild[isSourceNode]){lastChild.replaceRight(aPattern,aReplacement)}else if(typeof lastChild==="string"){this.children[this.children.length-1]=lastChild.replace(aPattern,aReplacement)}else{this.children.push("".replace(aPattern,aReplacement))}return this};SourceNode.prototype.setSourceContent=function SourceNode_setSourceContent(aSourceFile,aSourceContent){this.sourceContents[util4.toSetString(aSourceFile)]=aSourceContent};SourceNode.prototype.walkSourceContents=function SourceNode_walkSourceContents(aFn){for(var i=0,len=this.children.length;i<len;i++){if(this.children[i][isSourceNode]){this.children[i].walkSourceContents(aFn)}}var sources=Object.keys(this.sourceContents);for(var i=0,len=sources.length;i<len;i++){aFn(util4.fromSetString(sources[i]),this.sourceContents[sources[i]])}};SourceNode.prototype.toString=function SourceNode_toString(){var str2="";this.walk(function(chunk2){str2+=chunk2});return str2};SourceNode.prototype.toStringWithSourceMap=function SourceNode_toStringWithSourceMap(aArgs){var generated={code:"",line:1,column:0};var map3=new SourceMapGenerator(aArgs);var sourceMappingActive=false;var lastOriginalSource=null;var lastOriginalLine=null;var lastOriginalColumn=null;var lastOriginalName=null;this.walk(function(chunk2,original){generated.code+=chunk2;if(original.source!==null&&original.line!==null&&original.column!==null){if(lastOriginalSource!==original.source||lastOriginalLine!==original.line||lastOriginalColumn!==original.column||lastOriginalName!==original.name){map3.addMapping({source:original.source,original:{line:original.line,column:original.column},generated:{line:generated.line,column:generated.column},name:original.name})}lastOriginalSource=original.source;lastOriginalLine=original.line;lastOriginalColumn=original.column;lastOriginalName=original.name;sourceMappingActive=true}else if(sourceMappingActive){map3.addMapping({generated:{line:generated.line,column:generated.column}});lastOriginalSource=null;sourceMappingActive=false}for(var idx=0,length=chunk2.length;idx<length;idx++){if(chunk2.charCodeAt(idx)===NEWLINE_CODE){generated.line++;generated.column=0;if(idx+1===length){lastOriginalSource=null;sourceMappingActive=false}else if(sourceMappingActive){map3.addMapping({source:original.source,original:{line:original.line,column:original.column},generated:{line:generated.line,column:generated.column},name:original.name})}}else{generated.column++}}});this.walkSourceContents(function(sourceFile,sourceContent){map3.setSourceContent(sourceFile,sourceContent)});return{code:generated.code,map:map3}};exports2.SourceNode=SourceNode}});var require_source_map=__commonJS({"node_modules/source-map-support/node_modules/source-map/source-map.js"(exports2){exports2.SourceMapGenerator=require_source_map_generator().SourceMapGenerator;exports2.SourceMapConsumer=require_source_map_consumer().SourceMapConsumer;exports2.SourceNode=require_source_node().SourceNode}});var require_buffer_from=__commonJS({"node_modules/buffer-from/index.js"(exports2,module2){var toString5=Object.prototype.toString;var isModern=typeof Buffer!=="undefined"&&typeof Buffer.alloc==="function"&&typeof Buffer.allocUnsafe==="function"&&typeof Buffer.from==="function";function isArrayBuffer2(input){return toString5.call(input).slice(8,-1)==="ArrayBuffer"}function fromArrayBuffer(obj,byteOffset,length){byteOffset>>>=0;var maxLength=obj.byteLength-byteOffset;if(maxLength<0){throw new RangeError("'offset' is out of bounds")}if(length===void 0){length=maxLength}else{length>>>=0;if(length>maxLength){throw new RangeError("'length' is out of bounds")}}return isModern?Buffer.from(obj.slice(byteOffset,byteOffset+length)):new Buffer(new Uint8Array(obj.slice(byteOffset,byteOffset+length)))}function fromString(string,encoding){if(typeof encoding!=="string"||encoding===""){encoding="utf8"}if(!Buffer.isEncoding(encoding)){throw new TypeError('"encoding" must be a valid string encoding')}return isModern?Buffer.from(string,encoding):new Buffer(string,encoding)}function bufferFrom(value,encodingOrOffset,length){if(typeof value==="number"){throw new TypeError('"value" argument must not be a number')}if(isArrayBuffer2(value)){return fromArrayBuffer(value,encodingOrOffset,length)}if(typeof value==="string"){return fromString(value,encodingOrOffset)}return isModern?Buffer.from(value):new Buffer(value)}module2.exports=bufferFrom}});var require_source_map_support=__commonJS({"node_modules/source-map-support/source-map-support.js"(exports2,module2){var SourceMapConsumer=require_source_map().SourceMapConsumer;var path23=require("path");var fs11;try{fs11=require("fs");if(!fs11.existsSync||!fs11.readFileSync){fs11=null}}catch(err){}var bufferFrom=require_buffer_from();function dynamicRequire(mod3,request){return mod3.require(request)}var errorFormatterInstalled=false;var uncaughtShimInstalled=false;var emptyCacheBetweenOperations=false;var environment="auto";var fileContentsCache={};var sourceMapCache={};var reSourceMap=/^data:application\/json[^,]+base64,/;var retrieveFileHandlers=[];var retrieveMapHandlers=[];function isInBrowser(){if(environment==="browser")return true;if(environment==="node")return false;return typeof window!=="undefined"&&typeof XMLHttpRequest==="function"&&!(window.require&&window.module&&window.process&&window.process.type==="renderer")}function hasGlobalProcessEventEmitter(){return typeof process==="object"&&process!==null&&typeof process.on==="function"}function globalProcessVersion(){if(typeof process==="object"&&process!==null){return process.version}else{return""}}function globalProcessStderr(){if(typeof process==="object"&&process!==null){return process.stderr}}function globalProcessExit(code){if(typeof process==="object"&&process!==null&&typeof process.exit==="function"){return process.exit(code)}}function handlerExec(list){return function(arg){for(var i=0;i<list.length;i++){var ret=list[i](arg);if(ret){return ret}}return null}}var retrieveFile=handlerExec(retrieveFileHandlers);retrieveFileHandlers.push(function(path24){path24=path24.trim();if(/^file:/.test(path24)){path24=path24.replace(/file:\/\/\/(\w:)?/,function(protocol,drive){return drive?"":"/"})}if(path24 in fileContentsCache){return fileContentsCache[path24]}var contents="";try{if(!fs11){var xhr=new XMLHttpRequest;xhr.open("GET",path24,false);xhr.send(null);if(xhr.readyState===4&&xhr.status===200){contents=xhr.responseText}}else if(fs11.existsSync(path24)){contents=fs11.readFileSync(path24,"utf8")}}catch(er){}return fileContentsCache[path24]=contents});function supportRelativeURL(file,url){if(!file)return url;var dir=path23.dirname(file);var match=/^\w+:\/\/[^\/]*/.exec(dir);var protocol=match?match[0]:"";var startPath=dir.slice(protocol.length);if(protocol&&/^\/\w\:/.test(startPath)){protocol+="/";return protocol+path23.resolve(dir.slice(protocol.length),url).replace(/\\/g,"/")}return protocol+path23.resolve(dir.slice(protocol.length),url)}function retrieveSourceMapURL(source){var fileData;if(isInBrowser()){try{var xhr=new XMLHttpRequest;xhr.open("GET",source,false);xhr.send(null);fileData=xhr.readyState===4?xhr.responseText:null;var sourceMapHeader=xhr.getResponseHeader("SourceMap")||xhr.getResponseHeader("X-SourceMap");if(sourceMapHeader){return sourceMapHeader}}catch(e){}}fileData=retrieveFile(source);var re=/(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;var lastMatch,match;while(match=re.exec(fileData))lastMatch=match;if(!lastMatch)return null;return lastMatch[1]}var retrieveSourceMap=handlerExec(retrieveMapHandlers);retrieveMapHandlers.push(function(source){var sourceMappingURL=retrieveSourceMapURL(source);if(!sourceMappingURL)return null;var sourceMapData;if(reSourceMap.test(sourceMappingURL)){var rawData=sourceMappingURL.slice(sourceMappingURL.indexOf(",")+1);sourceMapData=bufferFrom(rawData,"base64").toString();sourceMappingURL=source}else{sourceMappingURL=supportRelativeURL(source,sourceMappingURL);sourceMapData=retrieveFile(sourceMappingURL)}if(!sourceMapData){return null}return{url:sourceMappingURL,map:sourceMapData}});function mapSourcePosition(position){var sourceMap=sourceMapCache[position.source];if(!sourceMap){var urlAndMap=retrieveSourceMap(position.source);if(urlAndMap){sourceMap=sourceMapCache[position.source]={url:urlAndMap.url,map:new SourceMapConsumer(urlAndMap.map)};if(sourceMap.map.sourcesContent){sourceMap.map.sources.forEach(function(source,i){var contents=sourceMap.map.sourcesContent[i];if(contents){var url=supportRelativeURL(sourceMap.url,source);fileContentsCache[url]=contents}})}}else{sourceMap=sourceMapCache[position.source]={url:null,map:null}}}if(sourceMap&&sourceMap.map&&typeof sourceMap.map.originalPositionFor==="function"){var originalPosition=sourceMap.map.originalPositionFor(position);if(originalPosition.source!==null){originalPosition.source=supportRelativeURL(sourceMap.url,originalPosition.source);return originalPosition}}return position}function mapEvalOrigin(origin){var match=/^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);if(match){var position=mapSourcePosition({source:match[2],line:+match[3],column:match[4]-1});return"eval at "+match[1]+" ("+position.source+":"+position.line+":"+(position.column+1)+")"}match=/^eval at ([^(]+) \((.+)\)$/.exec(origin);if(match){return"eval at "+match[1]+" ("+mapEvalOrigin(match[2])+")"}return origin}function CallSiteToString(){var fileName;var fileLocation="";if(this.isNative()){fileLocation="native"}else{fileName=this.getScriptNameOrSourceURL();if(!fileName&&this.isEval()){fileLocation=this.getEvalOrigin();fileLocation+=", "}if(fileName){fileLocation+=fileName}else{fileLocation+="<anonymous>"}var lineNumber=this.getLineNumber();if(lineNumber!=null){fileLocation+=":"+lineNumber;var columnNumber=this.getColumnNumber();if(columnNumber){fileLocation+=":"+columnNumber}}}var line="";var functionName=this.getFunctionName();var addSuffix=true;var isConstructor=this.isConstructor();var isMethodCall=!(this.isToplevel()||isConstructor);if(isMethodCall){var typeName=this.getTypeName();if(typeName==="[object Object]"){typeName="null"}var methodName=this.getMethodName();if(functionName){if(typeName&&functionName.indexOf(typeName)!=0){line+=typeName+"."}line+=functionName;if(methodName&&functionName.indexOf("."+methodName)!=functionName.length-methodName.length-1){line+=" [as "+methodName+"]"}}else{line+=typeName+"."+(methodName||"<anonymous>")}}else if(isConstructor){line+="new "+(functionName||"<anonymous>")}else if(functionName){line+=functionName}else{line+=fileLocation;addSuffix=false}if(addSuffix){line+=" ("+fileLocation+")"}return line}function cloneCallSite(frame){var object={};Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name){object[name]=/^(?:is|get)/.test(name)?function(){return frame[name].call(frame)}:frame[name]});object.toString=CallSiteToString;return object}function wrapCallSite(frame,state){if(state===void 0){state={nextPosition:null,curPosition:null}}if(frame.isNative()){state.curPosition=null;return frame}var source=frame.getFileName()||frame.getScriptNameOrSourceURL();if(source){var line=frame.getLineNumber();var column=frame.getColumnNumber()-1;var noHeader=/^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;var headerLength=noHeader.test(globalProcessVersion())?0:62;if(line===1&&column>headerLength&&!isInBrowser()&&!frame.isEval()){column-=headerLength}var position=mapSourcePosition({source,line,column});state.curPosition=position;frame=cloneCallSite(frame);var originalFunctionName=frame.getFunctionName;frame.getFunctionName=function(){if(state.nextPosition==null){return originalFunctionName()}return state.nextPosition.name||originalFunctionName()};frame.getFileName=function(){return position.source};frame.getLineNumber=function(){return position.line};frame.getColumnNumber=function(){return position.column+1};frame.getScriptNameOrSourceURL=function(){return position.source};return frame}var origin=frame.isEval()&&frame.getEvalOrigin();if(origin){origin=mapEvalOrigin(origin);frame=cloneCallSite(frame);frame.getEvalOrigin=function(){return origin};return frame}return frame}function prepareStackTrace(error,stack2){if(emptyCacheBetweenOperations){fileContentsCache={};sourceMapCache={}}var name=error.name||"Error";var message3=error.message||"";var errorString=name+": "+message3;var state={nextPosition:null,curPosition:null};var processedStack=[];for(var i=stack2.length-1;i>=0;i--){processedStack.push("\n    at "+wrapCallSite(stack2[i],state));state.nextPosition=state.curPosition}state.curPosition=state.nextPosition=null;return errorString+processedStack.reverse().join("")}function getErrorSource(error){var match=/\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error.stack);if(match){var source=match[1];var line=+match[2];var column=+match[3];var contents=fileContentsCache[source];if(!contents&&fs11&&fs11.existsSync(source)){try{contents=fs11.readFileSync(source,"utf8")}catch(er){contents=""}}if(contents){var code=contents.split(/(?:\r\n|\r|\n)/)[line-1];if(code){return source+":"+line+"\n"+code+"\n"+new Array(column).join(" ")+"^"}}}return null}function printErrorAndExit(error){var source=getErrorSource(error);var stderr=globalProcessStderr();if(stderr&&stderr._handle&&stderr._handle.setBlocking){stderr._handle.setBlocking(true)}if(source){console.error();console.error(source)}console.error(error.stack);globalProcessExit(1)}function shimEmitUncaughtException(){var origEmit=process.emit;process.emit=function(type2){if(type2==="uncaughtException"){var hasStack=arguments[1]&&arguments[1].stack;var hasListeners=this.listeners(type2).length>0;if(hasStack&&!hasListeners){return printErrorAndExit(arguments[1])}}return origEmit.apply(this,arguments)}}var originalRetrieveFileHandlers=retrieveFileHandlers.slice(0);var originalRetrieveMapHandlers=retrieveMapHandlers.slice(0);exports2.wrapCallSite=wrapCallSite;exports2.getErrorSource=getErrorSource;exports2.mapSourcePosition=mapSourcePosition;exports2.retrieveSourceMap=retrieveSourceMap;exports2.install=function(options){options=options||{};if(options.environment){environment=options.environment;if(["node","browser","auto"].indexOf(environment)===-1){throw new Error("environment "+environment+" was unknown. Available options are {auto, browser, node}")}}if(options.retrieveFile){if(options.overrideRetrieveFile){retrieveFileHandlers.length=0}retrieveFileHandlers.unshift(options.retrieveFile)}if(options.retrieveSourceMap){if(options.overrideRetrieveSourceMap){retrieveMapHandlers.length=0}retrieveMapHandlers.unshift(options.retrieveSourceMap)}if(options.hookRequire&&!isInBrowser()){var Module=dynamicRequire(module2,"module");var $compile=Module.prototype._compile;if(!$compile.__sourceMapSupport){Module.prototype._compile=function(content,filename){fileContentsCache[filename]=content;sourceMapCache[filename]=void 0;return $compile.call(this,content,filename)};Module.prototype._compile.__sourceMapSupport=true}}if(!emptyCacheBetweenOperations){emptyCacheBetweenOperations="emptyCacheBetweenOperations"in options?options.emptyCacheBetweenOperations:false}if(!errorFormatterInstalled){errorFormatterInstalled=true;Error.prepareStackTrace=prepareStackTrace}if(!uncaughtShimInstalled){var installHandler="handleUncaughtExceptions"in options?options.handleUncaughtExceptions:true;try{var worker_threads=dynamicRequire(module2,"worker_threads");if(worker_threads.isMainThread===false){installHandler=false}}catch(e){}if(installHandler&&hasGlobalProcessEventEmitter()){uncaughtShimInstalled=true;shimEmitUncaughtException()}}};exports2.resetRetrieveHandlers=function(){retrieveFileHandlers.length=0;retrieveMapHandlers.length=0;retrieveFileHandlers=originalRetrieveFileHandlers.slice(0);retrieveMapHandlers=originalRetrieveMapHandlers.slice(0);retrieveSourceMap=handlerExec(retrieveMapHandlers);retrieveFile=handlerExec(retrieveFileHandlers)}}});var require_eastasianwidth=__commonJS({"node_modules/eastasianwidth/eastasianwidth.js"(exports2,module2){var eaw={};if("undefined"==typeof module2){window.eastasianwidth=eaw}else{module2.exports=eaw}eaw.eastAsianWidth=function(character){var x=character.charCodeAt(0);var y=character.length==2?character.charCodeAt(1):0;var codePoint=x;if(55296<=x&&x<=56319&&(56320<=y&&y<=57343)){x&=1023;y&=1023;codePoint=x<<10|y;codePoint+=65536}if(12288==codePoint||65281<=codePoint&&codePoint<=65376||65504<=codePoint&&codePoint<=65510){return"F"}if(8361==codePoint||65377<=codePoint&&codePoint<=65470||65474<=codePoint&&codePoint<=65479||65482<=codePoint&&codePoint<=65487||65490<=codePoint&&codePoint<=65495||65498<=codePoint&&codePoint<=65500||65512<=codePoint&&codePoint<=65518){return"H"}if(4352<=codePoint&&codePoint<=4447||4515<=codePoint&&codePoint<=4519||4602<=codePoint&&codePoint<=4607||9001<=codePoint&&codePoint<=9002||11904<=codePoint&&codePoint<=11929||11931<=codePoint&&codePoint<=12019||12032<=codePoint&&codePoint<=12245||12272<=codePoint&&codePoint<=12283||12289<=codePoint&&codePoint<=12350||12353<=codePoint&&codePoint<=12438||12441<=codePoint&&codePoint<=12543||12549<=codePoint&&codePoint<=12589||12593<=codePoint&&codePoint<=12686||12688<=codePoint&&codePoint<=12730||12736<=codePoint&&codePoint<=12771||12784<=codePoint&&codePoint<=12830||12832<=codePoint&&codePoint<=12871||12880<=codePoint&&codePoint<=13054||13056<=codePoint&&codePoint<=19903||19968<=codePoint&&codePoint<=42124||42128<=codePoint&&codePoint<=42182||43360<=codePoint&&codePoint<=43388||44032<=codePoint&&codePoint<=55203||55216<=codePoint&&codePoint<=55238||55243<=codePoint&&codePoint<=55291||63744<=codePoint&&codePoint<=64255||65040<=codePoint&&codePoint<=65049||65072<=codePoint&&codePoint<=65106||65108<=codePoint&&codePoint<=65126||65128<=codePoint&&codePoint<=65131||110592<=codePoint&&codePoint<=110593||127488<=codePoint&&codePoint<=127490||127504<=codePoint&&codePoint<=127546||127552<=codePoint&&codePoint<=127560||127568<=codePoint&&codePoint<=127569||131072<=codePoint&&codePoint<=194367||177984<=codePoint&&codePoint<=196605||196608<=codePoint&&codePoint<=262141){return"W"}if(32<=codePoint&&codePoint<=126||162<=codePoint&&codePoint<=163||165<=codePoint&&codePoint<=166||172==codePoint||175==codePoint||10214<=codePoint&&codePoint<=10221||10629<=codePoint&&codePoint<=10630){return"Na"}if(161==codePoint||164==codePoint||167<=codePoint&&codePoint<=168||170==codePoint||173<=codePoint&&codePoint<=174||176<=codePoint&&codePoint<=180||182<=codePoint&&codePoint<=186||188<=codePoint&&codePoint<=191||198==codePoint||208==codePoint||215<=codePoint&&codePoint<=216||222<=codePoint&&codePoint<=225||230==codePoint||232<=codePoint&&codePoint<=234||236<=codePoint&&codePoint<=237||240==codePoint||242<=codePoint&&codePoint<=243||247<=codePoint&&codePoint<=250||252==codePoint||254==codePoint||257==codePoint||273==codePoint||275==codePoint||283==codePoint||294<=codePoint&&codePoint<=295||299==codePoint||305<=codePoint&&codePoint<=307||312==codePoint||319<=codePoint&&codePoint<=322||324==codePoint||328<=codePoint&&codePoint<=331||333==codePoint||338<=codePoint&&codePoint<=339||358<=codePoint&&codePoint<=359||363==codePoint||462==codePoint||464==codePoint||466==codePoint||468==codePoint||470==codePoint||472==codePoint||474==codePoint||476==codePoint||593==codePoint||609==codePoint||708==codePoint||711==codePoint||713<=codePoint&&codePoint<=715||717==codePoint||720==codePoint||728<=codePoint&&codePoint<=731||733==codePoint||735==codePoint||768<=codePoint&&codePoint<=879||913<=codePoint&&codePoint<=929||931<=codePoint&&codePoint<=937||945<=codePoint&&codePoint<=961||963<=codePoint&&codePoint<=969||1025==codePoint||1040<=codePoint&&codePoint<=1103||1105==codePoint||8208==codePoint||8211<=codePoint&&codePoint<=8214||8216<=codePoint&&codePoint<=8217||8220<=codePoint&&codePoint<=8221||8224<=codePoint&&codePoint<=8226||8228<=codePoint&&codePoint<=8231||8240==codePoint||8242<=codePoint&&codePoint<=8243||8245==codePoint||8251==codePoint||8254==codePoint||8308==codePoint||8319==codePoint||8321<=codePoint&&codePoint<=8324||8364==codePoint||8451==codePoint||8453==codePoint||8457==codePoint||8467==codePoint||8470==codePoint||8481<=codePoint&&codePoint<=8482||8486==codePoint||8491==codePoint||8531<=codePoint&&codePoint<=8532||8539<=codePoint&&codePoint<=8542||8544<=codePoint&&codePoint<=8555||8560<=codePoint&&codePoint<=8569||8585==codePoint||8592<=codePoint&&codePoint<=8601||8632<=codePoint&&codePoint<=8633||8658==codePoint||8660==codePoint||8679==codePoint||8704==codePoint||8706<=codePoint&&codePoint<=8707||8711<=codePoint&&codePoint<=8712||8715==codePoint||8719==codePoint||8721==codePoint||8725==codePoint||8730==codePoint||8733<=codePoint&&codePoint<=8736||8739==codePoint||8741==codePoint||8743<=codePoint&&codePoint<=8748||8750==codePoint||8756<=codePoint&&codePoint<=8759||8764<=codePoint&&codePoint<=8765||8776==codePoint||8780==codePoint||8786==codePoint||8800<=codePoint&&codePoint<=8801||8804<=codePoint&&codePoint<=8807||8810<=codePoint&&codePoint<=8811||8814<=codePoint&&codePoint<=8815||8834<=codePoint&&codePoint<=8835||8838<=codePoint&&codePoint<=8839||8853==codePoint||8857==codePoint||8869==codePoint||8895==codePoint||8978==codePoint||9312<=codePoint&&codePoint<=9449||9451<=codePoint&&codePoint<=9547||9552<=codePoint&&codePoint<=9587||9600<=codePoint&&codePoint<=9615||9618<=codePoint&&codePoint<=9621||9632<=codePoint&&codePoint<=9633||9635<=codePoint&&codePoint<=9641||9650<=codePoint&&codePoint<=9651||9654<=codePoint&&codePoint<=9655||9660<=codePoint&&codePoint<=9661||9664<=codePoint&&codePoint<=9665||9670<=codePoint&&codePoint<=9672||9675==codePoint||9678<=codePoint&&codePoint<=9681||9698<=codePoint&&codePoint<=9701||9711==codePoint||9733<=codePoint&&codePoint<=9734||9737==codePoint||9742<=codePoint&&codePoint<=9743||9748<=codePoint&&codePoint<=9749||9756==codePoint||9758==codePoint||9792==codePoint||9794==codePoint||9824<=codePoint&&codePoint<=9825||9827<=codePoint&&codePoint<=9829||9831<=codePoint&&codePoint<=9834||9836<=codePoint&&codePoint<=9837||9839==codePoint||9886<=codePoint&&codePoint<=9887||9918<=codePoint&&codePoint<=9919||9924<=codePoint&&codePoint<=9933||9935<=codePoint&&codePoint<=9953||9955==codePoint||9960<=codePoint&&codePoint<=9983||10045==codePoint||10071==codePoint||10102<=codePoint&&codePoint<=10111||11093<=codePoint&&codePoint<=11097||12872<=codePoint&&codePoint<=12879||57344<=codePoint&&codePoint<=63743||65024<=codePoint&&codePoint<=65039||65533==codePoint||127232<=codePoint&&codePoint<=127242||127248<=codePoint&&codePoint<=127277||127280<=codePoint&&codePoint<=127337||127344<=codePoint&&codePoint<=127386||917760<=codePoint&&codePoint<=917999||983040<=codePoint&&codePoint<=1048573||1048576<=codePoint&&codePoint<=1114109){return"A"}return"N"};eaw.characterLength=function(character){var code=this.eastAsianWidth(character);if(code=="F"||code=="W"||code=="A"){return 2}else{return 1}};function stringToArray2(string){return string.match(/[\uD800-\uDBFF][\uDC00-\uDFFF]|[^\uD800-\uDFFF]/g)||[]}eaw.length=function(string){var characters=stringToArray2(string);var len=0;for(var i=0;i<characters.length;i++){len=len+this.characterLength(characters[i])}return len};eaw.slice=function(text,start,end){textLen=eaw.length(text);start=start?start:0;end=end?end:1;if(start<0){start=textLen+start}if(end<0){end=textLen+end}var result2="";var eawLen=0;var chars=stringToArray2(text);for(var i=0;i<chars.length;i++){var char=chars[i];var charLen=eaw.length(char);if(eawLen>=start-(charLen==2?1:0)){if(eawLen+charLen<=end){result2+=char}else{break}}eawLen+=charLen}return result2}}});var require_emoji_regex=__commonJS({"node_modules/emoji-regex/index.js"(exports2,module2){"use strict";module2.exports=function(){return/\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67)\uDB40\uDC7F|(?:\uD83E\uDDD1\uD83C\uDFFF\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFC-\uDFFF])|\uD83D\uDC68(?:\uD83C\uDFFB(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|[\u2695\u2696\u2708]\uFE0F|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))?|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFF]))|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])\uFE0F|\u200D(?:(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D[\uDC66\uDC67])|\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC)?|(?:\uD83D\uDC69(?:\uD83C\uDFFB\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|(?:\uD83C[\uDFFC-\uDFFF])\u200D\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69]))|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC69(?:\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83E\uDDD1(?:\u200D(?:\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF7C\uDF84\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|\uD83D\uDE36\u200D\uD83C\uDF2B|\uD83C\uDFF3\uFE0F\u200D\u26A7|\uD83D\uDC3B\u200D\u2744|(?:(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\uD83C\uDFF4\u200D\u2620|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])\u200D[\u2640\u2642]|[\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u2328\u23CF\u23ED-\u23EF\u23F1\u23F2\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB\u25FC\u2600-\u2604\u260E\u2611\u2618\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u2692\u2694-\u2697\u2699\u269B\u269C\u26A0\u26A7\u26B0\u26B1\u26C8\u26CF\u26D1\u26D3\u26E9\u26F0\u26F1\u26F4\u26F7\u26F8\u2702\u2708\u2709\u270F\u2712\u2714\u2716\u271D\u2721\u2733\u2734\u2744\u2747\u2763\u27A1\u2934\u2935\u2B05-\u2B07\u3030\u303D\u3297\u3299]|\uD83C[\uDD70\uDD71\uDD7E\uDD7F\uDE02\uDE37\uDF21\uDF24-\uDF2C\uDF36\uDF7D\uDF96\uDF97\uDF99-\uDF9B\uDF9E\uDF9F\uDFCD\uDFCE\uDFD4-\uDFDF\uDFF5\uDFF7]|\uD83D[\uDC3F\uDCFD\uDD49\uDD4A\uDD6F\uDD70\uDD73\uDD76-\uDD79\uDD87\uDD8A-\uDD8D\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA\uDECB\uDECD-\uDECF\uDEE0-\uDEE5\uDEE9\uDEF0\uDEF3])\uFE0F|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDE35\u200D\uD83D\uDCAB|\uD83D\uDE2E\u200D\uD83D\uDCA8|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83E\uDDD1(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83D\uDC69(?:\uD83C\uDFFF|\uD83C\uDFFE|\uD83C\uDFFD|\uD83C\uDFFC|\uD83C\uDFFB)?|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF6\uD83C\uDDE6|\uD83C\uDDF4\uD83C\uDDF2|\uD83D\uDC08\u200D\u2B1B|\u2764\uFE0F\u200D(?:\uD83D\uDD25|\uD83E\uDE79)|\uD83D\uDC41\uFE0F|\uD83C\uDFF3\uFE0F|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|[#\*0-9]\uFE0F\u20E3|\u2764\uFE0F|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|\uD83C\uDFF4|(?:[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270C\u270D]|\uD83D[\uDD74\uDD90])(?:\uFE0F|\uD83C[\uDFFB-\uDFFF])|[\u270A\u270B]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC08\uDC15\uDC3B\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDC8F\uDC91\uDCAA\uDD7A\uDD95\uDD96\uDE2E\uDE35\uDE36\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD34\uDD36\uDD77\uDDB5\uDDB6\uDDBB\uDDD2\uDDD3\uDDD5]|\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC70\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD35\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD4\uDDD6-\uDDDD]|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF]|[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF84\uDF86-\uDF93\uDFA0-\uDFC1\uDFC5\uDFC6\uDFC8\uDFC9\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC07\uDC09-\uDC14\uDC16-\uDC3A\uDC3C-\uDC3E\uDC40\uDC44\uDC45\uDC51-\uDC65\uDC6A\uDC79-\uDC7B\uDC7D-\uDC80\uDC84\uDC88-\uDC8E\uDC90\uDC92-\uDCA9\uDCAB-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDDA4\uDDFB-\uDE2D\uDE2F-\uDE34\uDE37-\uDE44\uDE48-\uDE4A\uDE80-\uDEA2\uDEA4-\uDEB3\uDEB7-\uDEBF\uDEC1-\uDEC5\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0D\uDD0E\uDD10-\uDD17\uDD1D\uDD20-\uDD25\uDD27-\uDD2F\uDD3A\uDD3F-\uDD45\uDD47-\uDD76\uDD78\uDD7A-\uDDB4\uDDB7\uDDBA\uDDBC-\uDDCB\uDDD0\uDDE0-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6]|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5-\uDED7\uDEEB\uDEEC\uDEF4-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26A7\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5-\uDED7\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD0C-\uDD3A\uDD3C-\uDD45\uDD47-\uDD78\uDD7A-\uDDCB\uDDCD-\uDDFF\uDE70-\uDE74\uDE78-\uDE7A\uDE80-\uDE86\uDE90-\uDEA8\uDEB0-\uDEB6\uDEC0-\uDEC2\uDED0-\uDED6])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0C\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDD77\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g}}});var require_boxes=__commonJS({"node_modules/cli-boxes/boxes.json"(exports2,module2){module2.exports={single:{topLeft:"┌",top:"─",topRight:"┐",right:"│",bottomRight:"┘",bottom:"─",bottomLeft:"└",left:"│"},double:{topLeft:"╔",top:"═",topRight:"╗",right:"║",bottomRight:"╝",bottom:"═",bottomLeft:"╚",left:"║"},round:{topLeft:"╭",top:"─",topRight:"╮",right:"│",bottomRight:"╯",bottom:"─",bottomLeft:"╰",left:"│"},bold:{topLeft:"┏",top:"━",topRight:"┓",right:"┃",bottomRight:"┛",bottom:"━",bottomLeft:"┗",left:"┃"},singleDouble:{topLeft:"╓",top:"─",topRight:"╖",right:"║",bottomRight:"╜",bottom:"─",bottomLeft:"╙",left:"║"},doubleSingle:{topLeft:"╒",top:"═",topRight:"╕",right:"│",bottomRight:"╛",bottom:"═",bottomLeft:"╘",left:"│"},classic:{topLeft:"+",top:"-",topRight:"+",right:"|",bottomRight:"+",bottom:"-",bottomLeft:"+",left:"|"},arrow:{topLeft:"↘",top:"↓",topRight:"↙",right:"←",bottomRight:"↖",bottom:"↑",bottomLeft:"↗",left:"→"}}}});var require_cli_boxes=__commonJS({"node_modules/cli-boxes/index.js"(exports2,module2){"use strict";var cliBoxes2=require_boxes();module2.exports=cliBoxes2;module2.exports.default=cliBoxes2}});var require_ansi_regex=__commonJS({"node_modules/ansi-regex/index.js"(exports2,module2){"use strict";module2.exports=({onlyFirst=false}={})=>{const pattern=["[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]+)*|[a-zA-Z\\d]+(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)","(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))"].join("|");return new RegExp(pattern,onlyFirst?void 0:"g")}}});var require_strip_ansi=__commonJS({"node_modules/strip-ansi/index.js"(exports2,module2){"use strict";var ansiRegex3=require_ansi_regex();module2.exports=string=>typeof string==="string"?string.replace(ansiRegex3(),""):string}});var require_is_fullwidth_code_point=__commonJS({"node_modules/is-fullwidth-code-point/index.js"(exports2,module2){"use strict";var isFullwidthCodePoint=codePoint=>{if(Number.isNaN(codePoint)){return false}if(codePoint>=4352&&(codePoint<=4447||codePoint===9001||codePoint===9002||11904<=codePoint&&codePoint<=12871&&codePoint!==12351||12880<=codePoint&&codePoint<=19903||19968<=codePoint&&codePoint<=42182||43360<=codePoint&&codePoint<=43388||44032<=codePoint&&codePoint<=55203||63744<=codePoint&&codePoint<=64255||65040<=codePoint&&codePoint<=65049||65072<=codePoint&&codePoint<=65131||65281<=codePoint&&codePoint<=65376||65504<=codePoint&&codePoint<=65510||110592<=codePoint&&codePoint<=110593||127488<=codePoint&&codePoint<=127569||131072<=codePoint&&codePoint<=262141)){return true}return false};module2.exports=isFullwidthCodePoint;module2.exports.default=isFullwidthCodePoint}});var require_emoji_regex2=__commonJS({"node_modules/ansi-align/node_modules/string-width/node_modules/emoji-regex/index.js"(exports2,module2){"use strict";module2.exports=function(){return/\uD83C\uDFF4\uDB40\uDC67\uDB40\uDC62(?:\uDB40\uDC65\uDB40\uDC6E\uDB40\uDC67|\uDB40\uDC73\uDB40\uDC63\uDB40\uDC74|\uDB40\uDC77\uDB40\uDC6C\uDB40\uDC73)\uDB40\uDC7F|\uD83D\uDC68(?:\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68\uD83C\uDFFB|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFE])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D)?\uD83D\uDC68|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D[\uDC68\uDC69])\u200D(?:\uD83D[\uDC66\uDC67])|[\u2695\u2696\u2708]\uFE0F|\uD83D[\uDC66\uDC67]|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|(?:\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708])\uFE0F|\uD83C\uDFFB\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C[\uDFFB-\uDFFF])|(?:\uD83E\uDDD1\uD83C\uDFFB\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)\uD83C\uDFFB|\uD83E\uDDD1(?:\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1)|(?:\uD83E\uDDD1\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFF\u200D\uD83E\uDD1D\u200D(?:\uD83D[\uDC68\uDC69]))(?:\uD83C[\uDFFB-\uDFFE])|(?:\uD83E\uDDD1\uD83C\uDFFC\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB\uDFFC])|\uD83D\uDC69(?:\uD83C\uDFFE\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB-\uDFFD\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFC\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFD-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFB\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFC-\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFD\u200D(?:\uD83E\uDD1D\u200D\uD83D\uDC68(?:\uD83C[\uDFFB\uDFFC\uDFFE\uDFFF])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\u200D(?:\u2764\uFE0F\u200D(?:\uD83D\uDC8B\u200D(?:\uD83D[\uDC68\uDC69])|\uD83D[\uDC68\uDC69])|\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD])|\uD83C\uDFFF\u200D(?:\uD83C[\uDF3E\uDF73\uDF93\uDFA4\uDFA8\uDFEB\uDFED]|\uD83D[\uDCBB\uDCBC\uDD27\uDD2C\uDE80\uDE92]|\uD83E[\uDDAF-\uDDB3\uDDBC\uDDBD]))|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67]))|(?:\uD83E\uDDD1\uD83C\uDFFD\u200D\uD83E\uDD1D\u200D\uD83E\uDDD1|\uD83D\uDC69\uD83C\uDFFE\u200D\uD83E\uDD1D\u200D\uD83D\uDC69)(?:\uD83C[\uDFFB-\uDFFD])|\uD83D\uDC69\u200D\uD83D\uDC66\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC69\u200D(?:\uD83D[\uDC66\uDC67])|(?:\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8|\uD83D\uDC69(?:\uD83C\uDFFF\u200D[\u2695\u2696\u2708]|\uD83C\uDFFE\u200D[\u2695\u2696\u2708]|\uD83C\uDFFC\u200D[\u2695\u2696\u2708]|\uD83C\uDFFB\u200D[\u2695\u2696\u2708]|\uD83C\uDFFD\u200D[\u2695\u2696\u2708]|\u200D[\u2695\u2696\u2708])|(?:(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)\uFE0F|\uD83D\uDC6F|\uD83E[\uDD3C\uDDDE\uDDDF])\u200D[\u2640\u2642]|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:(?:\uD83C[\uDFFB-\uDFFF])\u200D[\u2640\u2642]|\u200D[\u2640\u2642])|\uD83C\uDFF4\u200D\u2620)\uFE0F|\uD83D\uDC69\u200D\uD83D\uDC67\u200D(?:\uD83D[\uDC66\uDC67])|\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08|\uD83D\uDC15\u200D\uD83E\uDDBA|\uD83D\uDC69\u200D\uD83D\uDC66|\uD83D\uDC69\u200D\uD83D\uDC67|\uD83C\uDDFD\uD83C\uDDF0|\uD83C\uDDF4\uD83C\uDDF2|\uD83C\uDDF6\uD83C\uDDE6|[#\*0-9]\uFE0F\u20E3|\uD83C\uDDE7(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEF\uDDF1-\uDDF4\uDDF6-\uDDF9\uDDFB\uDDFC\uDDFE\uDDFF])|\uD83C\uDDF9(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDED\uDDEF-\uDDF4\uDDF7\uDDF9\uDDFB\uDDFC\uDDFF])|\uD83C\uDDEA(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDED\uDDF7-\uDDFA])|\uD83E\uDDD1(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF7(?:\uD83C[\uDDEA\uDDF4\uDDF8\uDDFA\uDDFC])|\uD83D\uDC69(?:\uD83C[\uDFFB-\uDFFF])|\uD83C\uDDF2(?:\uD83C[\uDDE6\uDDE8-\uDDED\uDDF0-\uDDFF])|\uD83C\uDDE6(?:\uD83C[\uDDE8-\uDDEC\uDDEE\uDDF1\uDDF2\uDDF4\uDDF6-\uDDFA\uDDFC\uDDFD\uDDFF])|\uD83C\uDDF0(?:\uD83C[\uDDEA\uDDEC-\uDDEE\uDDF2\uDDF3\uDDF5\uDDF7\uDDFC\uDDFE\uDDFF])|\uD83C\uDDED(?:\uD83C[\uDDF0\uDDF2\uDDF3\uDDF7\uDDF9\uDDFA])|\uD83C\uDDE9(?:\uD83C[\uDDEA\uDDEC\uDDEF\uDDF0\uDDF2\uDDF4\uDDFF])|\uD83C\uDDFE(?:\uD83C[\uDDEA\uDDF9])|\uD83C\uDDEC(?:\uD83C[\uDDE6\uDDE7\uDDE9-\uDDEE\uDDF1-\uDDF3\uDDF5-\uDDFA\uDDFC\uDDFE])|\uD83C\uDDF8(?:\uD83C[\uDDE6-\uDDEA\uDDEC-\uDDF4\uDDF7-\uDDF9\uDDFB\uDDFD-\uDDFF])|\uD83C\uDDEB(?:\uD83C[\uDDEE-\uDDF0\uDDF2\uDDF4\uDDF7])|\uD83C\uDDF5(?:\uD83C[\uDDE6\uDDEA-\uDDED\uDDF0-\uDDF3\uDDF7-\uDDF9\uDDFC\uDDFE])|\uD83C\uDDFB(?:\uD83C[\uDDE6\uDDE8\uDDEA\uDDEC\uDDEE\uDDF3\uDDFA])|\uD83C\uDDF3(?:\uD83C[\uDDE6\uDDE8\uDDEA-\uDDEC\uDDEE\uDDF1\uDDF4\uDDF5\uDDF7\uDDFA\uDDFF])|\uD83C\uDDE8(?:\uD83C[\uDDE6\uDDE8\uDDE9\uDDEB-\uDDEE\uDDF0-\uDDF5\uDDF7\uDDFA-\uDDFF])|\uD83C\uDDF1(?:\uD83C[\uDDE6-\uDDE8\uDDEE\uDDF0\uDDF7-\uDDFB\uDDFE])|\uD83C\uDDFF(?:\uD83C[\uDDE6\uDDF2\uDDFC])|\uD83C\uDDFC(?:\uD83C[\uDDEB\uDDF8])|\uD83C\uDDFA(?:\uD83C[\uDDE6\uDDEC\uDDF2\uDDF3\uDDF8\uDDFE\uDDFF])|\uD83C\uDDEE(?:\uD83C[\uDDE8-\uDDEA\uDDF1-\uDDF4\uDDF6-\uDDF9])|\uD83C\uDDEF(?:\uD83C[\uDDEA\uDDF2\uDDF4\uDDF5])|(?:\uD83C[\uDFC3\uDFC4\uDFCA]|\uD83D[\uDC6E\uDC71\uDC73\uDC77\uDC81\uDC82\uDC86\uDC87\uDE45-\uDE47\uDE4B\uDE4D\uDE4E\uDEA3\uDEB4-\uDEB6]|\uD83E[\uDD26\uDD37-\uDD39\uDD3D\uDD3E\uDDB8\uDDB9\uDDCD-\uDDCF\uDDD6-\uDDDD])(?:\uD83C[\uDFFB-\uDFFF])|(?:\u26F9|\uD83C[\uDFCB\uDFCC]|\uD83D\uDD75)(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u261D\u270A-\u270D]|\uD83C[\uDF85\uDFC2\uDFC7]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66\uDC67\uDC6B-\uDC6D\uDC70\uDC72\uDC74-\uDC76\uDC78\uDC7C\uDC83\uDC85\uDCAA\uDD74\uDD7A\uDD90\uDD95\uDD96\uDE4C\uDE4F\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1C\uDD1E\uDD1F\uDD30-\uDD36\uDDB5\uDDB6\uDDBB\uDDD2-\uDDD5])(?:\uD83C[\uDFFB-\uDFFF])|(?:[\u231A\u231B\u23E9-\u23EC\u23F0\u23F3\u25FD\u25FE\u2614\u2615\u2648-\u2653\u267F\u2693\u26A1\u26AA\u26AB\u26BD\u26BE\u26C4\u26C5\u26CE\u26D4\u26EA\u26F2\u26F3\u26F5\u26FA\u26FD\u2705\u270A\u270B\u2728\u274C\u274E\u2753-\u2755\u2757\u2795-\u2797\u27B0\u27BF\u2B1B\u2B1C\u2B50\u2B55]|\uD83C[\uDC04\uDCCF\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE1A\uDE2F\uDE32-\uDE36\uDE38-\uDE3A\uDE50\uDE51\uDF00-\uDF20\uDF2D-\uDF35\uDF37-\uDF7C\uDF7E-\uDF93\uDFA0-\uDFCA\uDFCF-\uDFD3\uDFE0-\uDFF0\uDFF4\uDFF8-\uDFFF]|\uD83D[\uDC00-\uDC3E\uDC40\uDC42-\uDCFC\uDCFF-\uDD3D\uDD4B-\uDD4E\uDD50-\uDD67\uDD7A\uDD95\uDD96\uDDA4\uDDFB-\uDE4F\uDE80-\uDEC5\uDECC\uDED0-\uDED2\uDED5\uDEEB\uDEEC\uDEF4-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])|(?:[#\*0-9\xA9\xAE\u203C\u2049\u2122\u2139\u2194-\u2199\u21A9\u21AA\u231A\u231B\u2328\u23CF\u23E9-\u23F3\u23F8-\u23FA\u24C2\u25AA\u25AB\u25B6\u25C0\u25FB-\u25FE\u2600-\u2604\u260E\u2611\u2614\u2615\u2618\u261D\u2620\u2622\u2623\u2626\u262A\u262E\u262F\u2638-\u263A\u2640\u2642\u2648-\u2653\u265F\u2660\u2663\u2665\u2666\u2668\u267B\u267E\u267F\u2692-\u2697\u2699\u269B\u269C\u26A0\u26A1\u26AA\u26AB\u26B0\u26B1\u26BD\u26BE\u26C4\u26C5\u26C8\u26CE\u26CF\u26D1\u26D3\u26D4\u26E9\u26EA\u26F0-\u26F5\u26F7-\u26FA\u26FD\u2702\u2705\u2708-\u270D\u270F\u2712\u2714\u2716\u271D\u2721\u2728\u2733\u2734\u2744\u2747\u274C\u274E\u2753-\u2755\u2757\u2763\u2764\u2795-\u2797\u27A1\u27B0\u27BF\u2934\u2935\u2B05-\u2B07\u2B1B\u2B1C\u2B50\u2B55\u3030\u303D\u3297\u3299]|\uD83C[\uDC04\uDCCF\uDD70\uDD71\uDD7E\uDD7F\uDD8E\uDD91-\uDD9A\uDDE6-\uDDFF\uDE01\uDE02\uDE1A\uDE2F\uDE32-\uDE3A\uDE50\uDE51\uDF00-\uDF21\uDF24-\uDF93\uDF96\uDF97\uDF99-\uDF9B\uDF9E-\uDFF0\uDFF3-\uDFF5\uDFF7-\uDFFF]|\uD83D[\uDC00-\uDCFD\uDCFF-\uDD3D\uDD49-\uDD4E\uDD50-\uDD67\uDD6F\uDD70\uDD73-\uDD7A\uDD87\uDD8A-\uDD8D\uDD90\uDD95\uDD96\uDDA4\uDDA5\uDDA8\uDDB1\uDDB2\uDDBC\uDDC2-\uDDC4\uDDD1-\uDDD3\uDDDC-\uDDDE\uDDE1\uDDE3\uDDE8\uDDEF\uDDF3\uDDFA-\uDE4F\uDE80-\uDEC5\uDECB-\uDED2\uDED5\uDEE0-\uDEE5\uDEE9\uDEEB\uDEEC\uDEF0\uDEF3-\uDEFA\uDFE0-\uDFEB]|\uD83E[\uDD0D-\uDD3A\uDD3C-\uDD45\uDD47-\uDD71\uDD73-\uDD76\uDD7A-\uDDA2\uDDA5-\uDDAA\uDDAE-\uDDCA\uDDCD-\uDDFF\uDE70-\uDE73\uDE78-\uDE7A\uDE80-\uDE82\uDE90-\uDE95])\uFE0F|(?:[\u261D\u26F9\u270A-\u270D]|\uD83C[\uDF85\uDFC2-\uDFC4\uDFC7\uDFCA-\uDFCC]|\uD83D[\uDC42\uDC43\uDC46-\uDC50\uDC66-\uDC78\uDC7C\uDC81-\uDC83\uDC85-\uDC87\uDC8F\uDC91\uDCAA\uDD74\uDD75\uDD7A\uDD90\uDD95\uDD96\uDE45-\uDE47\uDE4B-\uDE4F\uDEA3\uDEB4-\uDEB6\uDEC0\uDECC]|\uD83E[\uDD0F\uDD18-\uDD1F\uDD26\uDD30-\uDD39\uDD3C-\uDD3E\uDDB5\uDDB6\uDDB8\uDDB9\uDDBB\uDDCD-\uDDCF\uDDD1-\uDDDD])/g}}});var require_string_width=__commonJS({"node_modules/ansi-align/node_modules/string-width/index.js"(exports2,module2){"use strict";var stripAnsi3=require_strip_ansi();var isFullwidthCodePoint=require_is_fullwidth_code_point();var emojiRegex3=require_emoji_regex2();var stringWidth2=string=>{if(typeof string!=="string"||string.length===0){return 0}string=stripAnsi3(string);if(string.length===0){return 0}string=string.replace(emojiRegex3(),"  ");let width=0;for(let i=0;i<string.length;i++){const code=string.codePointAt(i);if(code<=31||code>=127&&code<=159){continue}if(code>=768&&code<=879){continue}if(code>65535){i++}width+=isFullwidthCodePoint(code)?2:1}return width};module2.exports=stringWidth2;module2.exports.default=stringWidth2}});var require_ansi_align=__commonJS({"node_modules/ansi-align/index.js"(exports2,module2){"use strict";var stringWidth2=require_string_width();function ansiAlign2(text,opts){if(!text)return text;opts=opts||{};const align=opts.align||"center";if(align==="left")return text;const split2=opts.split||"\n";const pad4=opts.pad||" ";const widthDiffFn=align!=="right"?halfDiff:fullDiff;let returnString=false;if(!Array.isArray(text)){returnString=true;text=String(text).split(split2)}let width;let maxWidth=0;text=text.map(function(str2){str2=String(str2);width=stringWidth2(str2);maxWidth=Math.max(width,maxWidth);return{str:str2,width}}).map(function(obj){return new Array(widthDiffFn(maxWidth,obj.width)+1).join(pad4)+obj.str});return returnString?text.join(split2):text}ansiAlign2.left=function left(text){return ansiAlign2(text,{align:"left"})};ansiAlign2.center=function center(text){return ansiAlign2(text,{align:"center"})};ansiAlign2.right=function right(text){return ansiAlign2(text,{align:"right"})};module2.exports=ansiAlign2;function halfDiff(maxWidth,curWidth){return Math.floor((maxWidth-curWidth)/2)}function fullDiff(maxWidth,curWidth){return maxWidth-curWidth}}});var require_is_docker=__commonJS({"node_modules/is-docker/index.js"(exports2,module2){"use strict";var fs11=require("fs");var isDocker;function hasDockerEnv(){try{fs11.statSync("/.dockerenv");return true}catch(_){return false}}function hasDockerCGroup(){try{return fs11.readFileSync("/proc/self/cgroup","utf8").includes("docker")}catch(_){return false}}module2.exports=()=>{if(isDocker===void 0){isDocker=hasDockerEnv()||hasDockerCGroup()}return isDocker}}});var require_is_wsl=__commonJS({"node_modules/is-wsl/index.js"(exports2,module2){"use strict";var os7=require("os");var fs11=require("fs");var isDocker=require_is_docker();var isWsl=()=>{if(process.platform!=="linux"){return false}if(os7.release().toLowerCase().includes("microsoft")){if(isDocker()){return false}return true}try{return fs11.readFileSync("/proc/version","utf8").toLowerCase().includes("microsoft")?!isDocker():false}catch(_){return false}};if(process.env.__IS_WSL_TEST__){module2.exports=isWsl}else{module2.exports=isWsl()}}});var require_open=__commonJS({"node_modules/open/index.js"(exports2,module2){"use strict";var{promisify:promisify8}=require("util");var path23=require("path");var childProcess=require("child_process");var fs11=require("fs");var url=require("url");var isWsl=require_is_wsl();var isDocker=require_is_docker();var pAccess=promisify8(fs11.access);var pExecFile=promisify8(childProcess.execFile);var localXdgOpenPath=path23.join(__dirname,"xdg-open");var wslToWindowsPath=async path24=>{const{stdout}=await pExecFile("wslpath",["-w",path24]);return stdout.trim()};module2.exports=async(target,options)=>{if(typeof target!=="string"){throw new TypeError("Expected a `target`")}options={wait:false,background:false,url:false,allowNonzeroExitCode:false,...options};let command;let appArguments=[];const cliArguments=[];const childProcessOptions={};if(Array.isArray(options.app)){appArguments=options.app.slice(1);options.app=options.app[0]}if(options.url){target=new url.URL(target).href;if(isWsl){target=target.replace(/&/g,"^&")}}if(process.platform==="darwin"){command="open";if(options.wait){cliArguments.push("--wait-apps")}if(options.background){cliArguments.push("--background")}if(options.app){cliArguments.push("-a",options.app)}}else if(process.platform==="win32"||isWsl&&!isDocker()){command="cmd"+(isWsl?".exe":"");cliArguments.push("/s","/c","start",'""',"/b");if(!isWsl){target=`"${target}"`;childProcessOptions.windowsVerbatimArguments=true;if(options.app){options.app=`"${options.app}"`}}if(options.wait){cliArguments.push("/wait")}if(options.app){if(isWsl&&options.app.startsWith("/mnt/")){const windowsPath=await wslToWindowsPath(options.app);options.app=windowsPath}cliArguments.push(options.app)}if(appArguments.length>0){cliArguments.push(...appArguments)}}else{if(options.app){command=options.app}else{const isBundled=!__dirname||__dirname==="/";let exeLocalXdgOpen=false;try{await pAccess(localXdgOpenPath,fs11.constants.X_OK);exeLocalXdgOpen=true}catch(_){}const useSystemXdgOpen=process.versions.electron||process.platform==="android"||isBundled||!exeLocalXdgOpen;command=useSystemXdgOpen?"xdg-open":localXdgOpenPath}if(appArguments.length>0){cliArguments.push(...appArguments)}if(!options.wait){childProcessOptions.stdio="ignore";childProcessOptions.detached=true}}cliArguments.push(target);if(process.platform==="darwin"&&appArguments.length>0){cliArguments.push("--args",...appArguments)}const subprocess=childProcess.spawn(command,cliArguments,childProcessOptions);if(options.wait){return new Promise((resolve,reject2)=>{subprocess.once("error",reject2);subprocess.once("close",exitCode=>{if(options.allowNonzeroExitCode&&exitCode>0){reject2(new Error(`Exited with code ${exitCode}`));return}resolve(subprocess)})})}subprocess.unref();return subprocess}}});var require_source=__commonJS({"node_modules/defer-to-connect/dist/source/index.js"(exports2,module2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});function isTLSSocket(socket){return socket.encrypted}var deferToConnect2=(socket,fn2)=>{let listeners;if(typeof fn2==="function"){const connect=fn2;listeners={connect}}else{listeners=fn2}const hasConnectListener=typeof listeners.connect==="function";const hasSecureConnectListener=typeof listeners.secureConnect==="function";const hasCloseListener=typeof listeners.close==="function";const onConnect=()=>{if(hasConnectListener){listeners.connect()}if(isTLSSocket(socket)&&hasSecureConnectListener){if(socket.authorized){listeners.secureConnect()}else if(!socket.authorizationError){socket.once("secureConnect",listeners.secureConnect)}}if(hasCloseListener){socket.once("close",listeners.close)}};if(socket.writable&&!socket.connecting){onConnect()}else if(socket.connecting){socket.once("connect",onConnect)}else if(socket.destroyed&&hasCloseListener){listeners.close(socket._hadError)}};exports2.default=deferToConnect2;module2.exports=deferToConnect2;module2.exports.default=deferToConnect2}});var require_buffer_stream=__commonJS({"node_modules/get-stream/buffer-stream.js"(exports2,module2){"use strict";var{PassThrough:PassThroughStream2}=require("stream");module2.exports=options=>{options={...options};const{array}=options;let{encoding}=options;const isBuffer2=encoding==="buffer";let objectMode=false;if(array){objectMode=!(encoding||isBuffer2)}else{encoding=encoding||"utf8"}if(isBuffer2){encoding=null}const stream3=new PassThroughStream2({objectMode});if(encoding){stream3.setEncoding(encoding)}let length=0;const chunks=[];stream3.on("data",chunk2=>{chunks.push(chunk2);if(objectMode){length=chunks.length}else{length+=chunk2.length}});stream3.getBufferedValue=()=>{if(array){return chunks}return isBuffer2?Buffer.concat(chunks,length):chunks.join("")};stream3.getBufferedLength=()=>length;return stream3}}});var require_get_stream=__commonJS({"node_modules/get-stream/index.js"(exports2,module2){"use strict";var{constants:BufferConstants}=require("buffer");var stream3=require("stream");var{promisify:promisify8}=require("util");var bufferStream=require_buffer_stream();var streamPipelinePromisified=promisify8(stream3.pipeline);var MaxBufferError=class extends Error{constructor(){super("maxBuffer exceeded");this.name="MaxBufferError"}};async function getStream3(inputStream,options){if(!inputStream){throw new Error("Expected a stream")}options={maxBuffer:Infinity,...options};const{maxBuffer}=options;const stream4=bufferStream(options);await new Promise((resolve,reject2)=>{const rejectPromise=error=>{if(error&&stream4.getBufferedLength()<=BufferConstants.MAX_LENGTH){error.bufferedData=stream4.getBufferedValue()}reject2(error)};(async()=>{try{await streamPipelinePromisified(inputStream,stream4);resolve()}catch(error){rejectPromise(error)}})();stream4.on("data",()=>{if(stream4.getBufferedLength()>maxBuffer){rejectPromise(new MaxBufferError)}})});return stream4.getBufferedValue()}module2.exports=getStream3;module2.exports.buffer=(stream4,options)=>getStream3(stream4,{...options,encoding:"buffer"});module2.exports.array=(stream4,options)=>getStream3(stream4,{...options,array:true});module2.exports.MaxBufferError=MaxBufferError}});var require_http_cache_semantics=__commonJS({"node_modules/http-cache-semantics/index.js"(exports2,module2){"use strict";var statusCodeCacheableByDefault=new Set([200,203,204,206,300,301,308,404,405,410,414,501]);var understoodStatuses=new Set([200,203,204,300,301,302,303,307,308,404,405,410,414,501]);var errorStatusCodes=new Set([500,502,503,504]);var hopByHopHeaders={date:true,connection:true,"keep-alive":true,"proxy-authenticate":true,"proxy-authorization":true,te:true,trailer:true,"transfer-encoding":true,upgrade:true};var excludedFromRevalidationUpdate={"content-length":true,"content-encoding":true,"transfer-encoding":true,"content-range":true};function toNumberOrZero(s){const n=parseInt(s,10);return isFinite(n)?n:0}function isErrorResponse(response){if(!response){return true}return errorStatusCodes.has(response.status)}function parseCacheControl(header2){const cc={};if(!header2)return cc;const parts=header2.trim().split(/,/);for(const part of parts){const[k,v]=part.split(/=/,2);cc[k.trim()]=v===void 0?true:v.trim().replace(/^"|"$/g,"")}return cc}function formatCacheControl(cc){let parts=[];for(const k in cc){const v=cc[k];parts.push(v===true?k:k+"="+v)}if(!parts.length){return void 0}return parts.join(", ")}module2.exports=class CachePolicy{constructor(req,res,{shared,cacheHeuristic,immutableMinTimeToLive,ignoreCargoCult,_fromObject}={}){if(_fromObject){this._fromObject(_fromObject);return}if(!res||!res.headers){throw Error("Response headers missing")}this._assertRequestHasHeaders(req);this._responseTime=this.now();this._isShared=shared!==false;this._cacheHeuristic=void 0!==cacheHeuristic?cacheHeuristic:.1;this._immutableMinTtl=void 0!==immutableMinTimeToLive?immutableMinTimeToLive:24*3600*1e3;this._status="status"in res?res.status:200;this._resHeaders=res.headers;this._rescc=parseCacheControl(res.headers["cache-control"]);this._method="method"in req?req.method:"GET";this._url=req.url;this._host=req.headers.host;this._noAuthorization=!req.headers.authorization;this._reqHeaders=res.headers.vary?req.headers:null;this._reqcc=parseCacheControl(req.headers["cache-control"]);if(ignoreCargoCult&&"pre-check"in this._rescc&&"post-check"in this._rescc){delete this._rescc["pre-check"];delete this._rescc["post-check"];delete this._rescc["no-cache"];delete this._rescc["no-store"];delete this._rescc["must-revalidate"];this._resHeaders=Object.assign({},this._resHeaders,{"cache-control":formatCacheControl(this._rescc)});delete this._resHeaders.expires;delete this._resHeaders.pragma}if(res.headers["cache-control"]==null&&/no-cache/.test(res.headers.pragma)){this._rescc["no-cache"]=true}}now(){return Date.now()}storable(){return!!(!this._reqcc["no-store"]&&("GET"===this._method||"HEAD"===this._method||"POST"===this._method&&this._hasExplicitExpiration())&&understoodStatuses.has(this._status)&&!this._rescc["no-store"]&&(!this._isShared||!this._rescc.private)&&(!this._isShared||this._noAuthorization||this._allowsStoringAuthenticated())&&(this._resHeaders.expires||this._rescc["max-age"]||this._isShared&&this._rescc["s-maxage"]||this._rescc.public||statusCodeCacheableByDefault.has(this._status)))}_hasExplicitExpiration(){return this._isShared&&this._rescc["s-maxage"]||this._rescc["max-age"]||this._resHeaders.expires}_assertRequestHasHeaders(req){if(!req||!req.headers){throw Error("Request headers missing")}}satisfiesWithoutRevalidation(req){this._assertRequestHasHeaders(req);const requestCC=parseCacheControl(req.headers["cache-control"]);if(requestCC["no-cache"]||/no-cache/.test(req.headers.pragma)){return false}if(requestCC["max-age"]&&this.age()>requestCC["max-age"]){return false}if(requestCC["min-fresh"]&&this.timeToLive()<1e3*requestCC["min-fresh"]){return false}if(this.stale()){const allowsStale=requestCC["max-stale"]&&!this._rescc["must-revalidate"]&&(true===requestCC["max-stale"]||requestCC["max-stale"]>this.age()-this.maxAge());if(!allowsStale){return false}}return this._requestMatches(req,false)}_requestMatches(req,allowHeadMethod){return(!this._url||this._url===req.url)&&this._host===req.headers.host&&(!req.method||this._method===req.method||allowHeadMethod&&"HEAD"===req.method)&&this._varyMatches(req)}_allowsStoringAuthenticated(){return this._rescc["must-revalidate"]||this._rescc.public||this._rescc["s-maxage"]}_varyMatches(req){if(!this._resHeaders.vary){return true}if(this._resHeaders.vary==="*"){return false}const fields=this._resHeaders.vary.trim().toLowerCase().split(/\s*,\s*/);for(const name of fields){if(req.headers[name]!==this._reqHeaders[name])return false}return true}_copyWithoutHopByHopHeaders(inHeaders){const headers={};for(const name in inHeaders){if(hopByHopHeaders[name])continue;headers[name]=inHeaders[name]}if(inHeaders.connection){const tokens=inHeaders.connection.trim().split(/\s*,\s*/);for(const name of tokens){delete headers[name]}}if(headers.warning){const warnings=headers.warning.split(/,/).filter(warning=>{return!/^\s*1[0-9][0-9]/.test(warning)});if(!warnings.length){delete headers.warning}else{headers.warning=warnings.join(",").trim()}}return headers}responseHeaders(){const headers=this._copyWithoutHopByHopHeaders(this._resHeaders);const age=this.age();if(age>3600*24&&!this._hasExplicitExpiration()&&this.maxAge()>3600*24){headers.warning=(headers.warning?`${headers.warning}, `:"")+'113 - "rfc7234 5.5.4"'}headers.age=`${Math.round(age)}`;headers.date=new Date(this.now()).toUTCString();return headers}date(){const serverDate=Date.parse(this._resHeaders.date);if(isFinite(serverDate)){return serverDate}return this._responseTime}age(){let age=this._ageValue();const residentTime=(this.now()-this._responseTime)/1e3;return age+residentTime}_ageValue(){return toNumberOrZero(this._resHeaders.age)}maxAge(){if(!this.storable()||this._rescc["no-cache"]){return 0}if(this._isShared&&(this._resHeaders["set-cookie"]&&!this._rescc.public&&!this._rescc.immutable)){return 0}if(this._resHeaders.vary==="*"){return 0}if(this._isShared){if(this._rescc["proxy-revalidate"]){return 0}if(this._rescc["s-maxage"]){return toNumberOrZero(this._rescc["s-maxage"])}}if(this._rescc["max-age"]){return toNumberOrZero(this._rescc["max-age"])}const defaultMinTtl=this._rescc.immutable?this._immutableMinTtl:0;const serverDate=this.date();if(this._resHeaders.expires){const expires=Date.parse(this._resHeaders.expires);if(Number.isNaN(expires)||expires<serverDate){return 0}return Math.max(defaultMinTtl,(expires-serverDate)/1e3)}if(this._resHeaders["last-modified"]){const lastModified=Date.parse(this._resHeaders["last-modified"]);if(isFinite(lastModified)&&serverDate>lastModified){return Math.max(defaultMinTtl,(serverDate-lastModified)/1e3*this._cacheHeuristic)}}return defaultMinTtl}timeToLive(){const age=this.maxAge()-this.age();const staleIfErrorAge=age+toNumberOrZero(this._rescc["stale-if-error"]);const staleWhileRevalidateAge=age+toNumberOrZero(this._rescc["stale-while-revalidate"]);return Math.max(0,age,staleIfErrorAge,staleWhileRevalidateAge)*1e3}stale(){return this.maxAge()<=this.age()}_useStaleIfError(){return this.maxAge()+toNumberOrZero(this._rescc["stale-if-error"])>this.age()}useStaleWhileRevalidate(){return this.maxAge()+toNumberOrZero(this._rescc["stale-while-revalidate"])>this.age()}static fromObject(obj){return new this(void 0,void 0,{_fromObject:obj})}_fromObject(obj){if(this._responseTime)throw Error("Reinitialized");if(!obj||obj.v!==1)throw Error("Invalid serialization");this._responseTime=obj.t;this._isShared=obj.sh;this._cacheHeuristic=obj.ch;this._immutableMinTtl=obj.imm!==void 0?obj.imm:24*3600*1e3;this._status=obj.st;this._resHeaders=obj.resh;this._rescc=obj.rescc;this._method=obj.m;this._url=obj.u;this._host=obj.h;this._noAuthorization=obj.a;this._reqHeaders=obj.reqh;this._reqcc=obj.reqcc}toObject(){return{v:1,t:this._responseTime,sh:this._isShared,ch:this._cacheHeuristic,imm:this._immutableMinTtl,st:this._status,resh:this._resHeaders,rescc:this._rescc,m:this._method,u:this._url,h:this._host,a:this._noAuthorization,reqh:this._reqHeaders,reqcc:this._reqcc}}revalidationHeaders(incomingReq){this._assertRequestHasHeaders(incomingReq);const headers=this._copyWithoutHopByHopHeaders(incomingReq.headers);delete headers["if-range"];if(!this._requestMatches(incomingReq,true)||!this.storable()){delete headers["if-none-match"];delete headers["if-modified-since"];return headers}if(this._resHeaders.etag){headers["if-none-match"]=headers["if-none-match"]?`${headers["if-none-match"]}, ${this._resHeaders.etag}`:this._resHeaders.etag}const forbidsWeakValidators=headers["accept-ranges"]||headers["if-match"]||headers["if-unmodified-since"]||this._method&&this._method!="GET";if(forbidsWeakValidators){delete headers["if-modified-since"];if(headers["if-none-match"]){const etags=headers["if-none-match"].split(/,/).filter(etag=>{return!/^\s*W\//.test(etag)});if(!etags.length){delete headers["if-none-match"]}else{headers["if-none-match"]=etags.join(",").trim()}}}else if(this._resHeaders["last-modified"]&&!headers["if-modified-since"]){headers["if-modified-since"]=this._resHeaders["last-modified"]}return headers}revalidatedPolicy(request,response){this._assertRequestHasHeaders(request);if(this._useStaleIfError()&&isErrorResponse(response)){return{modified:false,matches:false,policy:this}}if(!response||!response.headers){throw Error("Response headers missing")}let matches2=false;if(response.status!==void 0&&response.status!=304){matches2=false}else if(response.headers.etag&&!/^\s*W\//.test(response.headers.etag)){matches2=this._resHeaders.etag&&this._resHeaders.etag.replace(/^\s*W\//,"")===response.headers.etag}else if(this._resHeaders.etag&&response.headers.etag){matches2=this._resHeaders.etag.replace(/^\s*W\//,"")===response.headers.etag.replace(/^\s*W\//,"")}else if(this._resHeaders["last-modified"]){matches2=this._resHeaders["last-modified"]===response.headers["last-modified"]}else{if(!this._resHeaders.etag&&!this._resHeaders["last-modified"]&&!response.headers.etag&&!response.headers["last-modified"]){matches2=true}}if(!matches2){return{policy:new this.constructor(request,response),modified:response.status!=304,matches:false}}const headers={};for(const k in this._resHeaders){headers[k]=k in response.headers&&!excludedFromRevalidationUpdate[k]?response.headers[k]:this._resHeaders[k]}const newResponse=Object.assign({},response,{status:this._status,method:this._method,headers});return{policy:new this.constructor(request,newResponse,{shared:this._isShared,cacheHeuristic:this._cacheHeuristic,immutableMinTimeToLive:this._immutableMinTtl}),modified:false,matches:true}}}}});var require_json_buffer=__commonJS({"node_modules/json-buffer/index.js"(exports2){exports2.stringify=function stringify(o){if("undefined"==typeof o)return o;if(o&&Buffer.isBuffer(o))return JSON.stringify(":base64:"+o.toString("base64"));if(o&&o.toJSON)o=o.toJSON();if(o&&"object"===typeof o){var s="";var array=Array.isArray(o);s=array?"[":"{";var first=true;for(var k in o){var ignore="function"==typeof o[k]||!array&&"undefined"===typeof o[k];if(Object.hasOwnProperty.call(o,k)&&!ignore){if(!first)s+=",";first=false;if(array){if(o[k]==void 0)s+="null";else s+=stringify(o[k])}else if(o[k]!==void 0){s+=stringify(k)+":"+stringify(o[k])}}}s+=array?"]":"}";return s}else if("string"===typeof o){return JSON.stringify(/^:/.test(o)?":"+o:o)}else if("undefined"===typeof o){return"null"}else return JSON.stringify(o)};exports2.parse=function(s){return JSON.parse(s,function(key,value){if("string"===typeof value){if(/^:base64:/.test(value))return Buffer.from(value.substring(8),"base64");else return/^:/.test(value)?value.substring(1):value}return value})}}});var require_src=__commonJS({"node_modules/keyv/src/index.js"(exports2,module2){"use strict";var EventEmitter3=require("events");var JSONB=require_json_buffer();var loadStore=options=>{const adapters={redis:"@keyv/redis",rediss:"@keyv/redis",mongodb:"@keyv/mongo",mongo:"@keyv/mongo",sqlite:"@keyv/sqlite",postgresql:"@keyv/postgres",postgres:"@keyv/postgres",mysql:"@keyv/mysql",etcd:"@keyv/etcd",offline:"@keyv/offline",tiered:"@keyv/tiered"};if(options.adapter||options.uri){const adapter=options.adapter||/^[^:+]*/.exec(options.uri)[0];return new(require(adapters[adapter]))(options)}return new Map};var iterableAdapters=["sqlite","postgres","mysql","mongo","redis","tiered"];var Keyv2=class extends EventEmitter3{constructor(uri,{emitErrors=true,...options}={}){super();this.opts={namespace:"keyv",serialize:JSONB.stringify,deserialize:JSONB.parse,...typeof uri==="string"?{uri}:uri,...options};if(!this.opts.store){const adapterOptions={...this.opts};this.opts.store=loadStore(adapterOptions)}if(this.opts.compression){const compression=this.opts.compression;this.opts.serialize=compression.serialize.bind(compression);this.opts.deserialize=compression.deserialize.bind(compression)}if(typeof this.opts.store.on==="function"&&emitErrors){this.opts.store.on("error",error=>this.emit("error",error))}this.opts.store.namespace=this.opts.namespace;const generateIterator=iterator=>async function*(){for await(const[key,raw]of typeof iterator==="function"?iterator(this.opts.store.namespace):iterator){const data=await this.opts.deserialize(raw);if(this.opts.store.namespace&&!key.includes(this.opts.store.namespace)){continue}if(typeof data.expires==="number"&&Date.now()>data.expires){this.delete(key);continue}yield[this._getKeyUnprefix(key),data.value]}};if(typeof this.opts.store[Symbol.iterator]==="function"&&this.opts.store instanceof Map){this.iterator=generateIterator(this.opts.store)}else if(typeof this.opts.store.iterator==="function"&&this.opts.store.opts&&this._checkIterableAdaptar()){this.iterator=generateIterator(this.opts.store.iterator.bind(this.opts.store))}}_checkIterableAdaptar(){return iterableAdapters.includes(this.opts.store.opts.dialect)||iterableAdapters.findIndex(element=>this.opts.store.opts.url.includes(element))>=0}_getKeyPrefix(key){return`${this.opts.namespace}:${key}`}_getKeyPrefixArray(keys2){return keys2.map(key=>`${this.opts.namespace}:${key}`)}_getKeyUnprefix(key){return key.split(":").splice(1).join(":")}get(key,options){const{store}=this.opts;const isArray3=Array.isArray(key);const keyPrefixed=isArray3?this._getKeyPrefixArray(key):this._getKeyPrefix(key);if(isArray3&&store.getMany===void 0){const promises=[];for(const key2 of keyPrefixed){promises.push(Promise.resolve().then(()=>store.get(key2)).then(data=>typeof data==="string"?this.opts.deserialize(data):this.opts.compression?this.opts.deserialize(data):data).then(data=>{if(data===void 0||data===null){return void 0}if(typeof data.expires==="number"&&Date.now()>data.expires){return this.delete(key2).then(()=>void 0)}return options&&options.raw?data:data.value}))}return Promise.allSettled(promises).then(values2=>{const data=[];for(const value of values2){data.push(value.value)}return data})}return Promise.resolve().then(()=>isArray3?store.getMany(keyPrefixed):store.get(keyPrefixed)).then(data=>typeof data==="string"?this.opts.deserialize(data):this.opts.compression?this.opts.deserialize(data):data).then(data=>{if(data===void 0||data===null){return void 0}if(isArray3){return data.map((row,index)=>{if(typeof row==="string"){row=this.opts.deserialize(row)}if(row===void 0||row===null){return void 0}if(typeof row.expires==="number"&&Date.now()>row.expires){this.delete(key[index]).then(()=>void 0);return void 0}return options&&options.raw?row:row.value})}if(typeof data.expires==="number"&&Date.now()>data.expires){return this.delete(key).then(()=>void 0)}return options&&options.raw?data:data.value})}set(key,value,ttl2){const keyPrefixed=this._getKeyPrefix(key);if(typeof ttl2==="undefined"){ttl2=this.opts.ttl}if(ttl2===0){ttl2=void 0}const{store}=this.opts;return Promise.resolve().then(()=>{const expires=typeof ttl2==="number"?Date.now()+ttl2:null;if(typeof value==="symbol"){this.emit("error","symbol cannot be serialized")}value={value,expires};return this.opts.serialize(value)}).then(value2=>store.set(keyPrefixed,value2,ttl2)).then(()=>true)}delete(key){const{store}=this.opts;if(Array.isArray(key)){const keyPrefixed2=this._getKeyPrefixArray(key);if(store.deleteMany===void 0){const promises=[];for(const key2 of keyPrefixed2){promises.push(store.delete(key2))}return Promise.allSettled(promises).then(values2=>values2.every(x=>x.value===true))}return Promise.resolve().then(()=>store.deleteMany(keyPrefixed2))}const keyPrefixed=this._getKeyPrefix(key);return Promise.resolve().then(()=>store.delete(keyPrefixed))}clear(){const{store}=this.opts;return Promise.resolve().then(()=>store.clear())}has(key){const keyPrefixed=this._getKeyPrefix(key);const{store}=this.opts;return Promise.resolve().then(async()=>{if(typeof store.has==="function"){return store.has(keyPrefixed)}const value=await store.get(keyPrefixed);return value!==void 0})}disconnect(){const{store}=this.opts;if(typeof store.disconnect==="function"){return store.disconnect()}}};module2.exports=Keyv2}});var require_mimic_response=__commonJS({"node_modules/decompress-response/node_modules/mimic-response/index.js"(exports2,module2){"use strict";var knownProperties2=["aborted","complete","headers","httpVersion","httpVersionMinor","httpVersionMajor","method","rawHeaders","rawTrailers","setTimeout","socket","statusCode","statusMessage","trailers","url"];module2.exports=(fromStream2,toStream)=>{if(toStream._readableState.autoDestroy){throw new Error("The second stream must have the `autoDestroy` option set to `false`")}const fromProperties=new Set(Object.keys(fromStream2).concat(knownProperties2));const properties={};for(const property2 of fromProperties){if(property2 in toStream){continue}properties[property2]={get(){const value=fromStream2[property2];const isFunction3=typeof value==="function";return isFunction3?value.bind(fromStream2):value},set(value){fromStream2[property2]=value},enumerable:true,configurable:false}}Object.defineProperties(toStream,properties);fromStream2.once("aborted",()=>{toStream.destroy();toStream.emit("aborted")});fromStream2.once("close",()=>{if(fromStream2.complete){if(toStream.readable){toStream.once("end",()=>{toStream.emit("close")})}else{toStream.emit("close")}}else{toStream.emit("close")}});return toStream}}});var require_decompress_response=__commonJS({"node_modules/decompress-response/index.js"(exports2,module2){"use strict";var{Transform,PassThrough}=require("stream");var zlib=require("zlib");var mimicResponse2=require_mimic_response();module2.exports=response=>{const contentEncoding=(response.headers["content-encoding"]||"").toLowerCase();if(!["gzip","deflate","br"].includes(contentEncoding)){return response}const isBrotli=contentEncoding==="br";if(isBrotli&&typeof zlib.createBrotliDecompress!=="function"){response.destroy(new Error("Brotli is not supported on Node.js < 12"));return response}let isEmpty2=true;const checker=new Transform({transform(data,_encoding,callback){isEmpty2=false;callback(null,data)},flush(callback){callback()}});const finalStream=new PassThrough({autoDestroy:false,destroy(error,callback){response.destroy();callback(error)}});const decompressStream=isBrotli?zlib.createBrotliDecompress():zlib.createUnzip();decompressStream.once("error",error=>{if(isEmpty2&&!response.readable){finalStream.end();return}finalStream.destroy(error)});mimicResponse2(response,finalStream);response.pipe(checker).pipe(decompressStream).pipe(finalStream);return finalStream}}});var require_quick_lru=__commonJS({"node_modules/quick-lru/index.js"(exports2,module2){"use strict";var QuickLRU=class{constructor(options={}){if(!(options.maxSize&&options.maxSize>0)){throw new TypeError("`maxSize` must be a number greater than 0")}this.maxSize=options.maxSize;this.onEviction=options.onEviction;this.cache=new Map;this.oldCache=new Map;this._size=0}_set(key,value){this.cache.set(key,value);this._size++;if(this._size>=this.maxSize){this._size=0;if(typeof this.onEviction==="function"){for(const[key2,value2]of this.oldCache.entries()){this.onEviction(key2,value2)}}this.oldCache=this.cache;this.cache=new Map}}get(key){if(this.cache.has(key)){return this.cache.get(key)}if(this.oldCache.has(key)){const value=this.oldCache.get(key);this.oldCache.delete(key);this._set(key,value);return value}}set(key,value){if(this.cache.has(key)){this.cache.set(key,value)}else{this._set(key,value)}return this}has(key){return this.cache.has(key)||this.oldCache.has(key)}peek(key){if(this.cache.has(key)){return this.cache.get(key)}if(this.oldCache.has(key)){return this.oldCache.get(key)}}delete(key){const deleted=this.cache.delete(key);if(deleted){this._size--}return this.oldCache.delete(key)||deleted}clear(){this.cache.clear();this.oldCache.clear();this._size=0}*keys(){for(const[key]of this){yield key}}*values(){for(const[,value]of this){yield value}}*[Symbol.iterator](){for(const item of this.cache){yield item}for(const item of this.oldCache){const[key]=item;if(!this.cache.has(key)){yield item}}}get size(){let oldCacheSize=0;for(const key of this.oldCache.keys()){if(!this.cache.has(key)){oldCacheSize++}}return Math.min(this._size+oldCacheSize,this.maxSize)}};module2.exports=QuickLRU}});var require_delay_async_destroy=__commonJS({"node_modules/http2-wrapper/source/utils/delay-async-destroy.js"(exports2,module2){"use strict";module2.exports=stream3=>{if(stream3.listenerCount("error")!==0){return stream3}stream3.__destroy=stream3._destroy;stream3._destroy=(...args2)=>{const callback=args2.pop();stream3.__destroy(...args2,async error=>{await Promise.resolve();callback(error)})};const onError=error=>{Promise.resolve().then(()=>{stream3.emit("error",error)})};stream3.once("error",onError);Promise.resolve().then(()=>{stream3.off("error",onError)});return stream3}}});var require_agent=__commonJS({"node_modules/http2-wrapper/source/agent.js"(exports2,module2){"use strict";var{URL:URL3}=require("url");var EventEmitter3=require("events");var tls=require("tls");var http22=require("http2");var QuickLRU=require_quick_lru();var delayAsyncDestroy=require_delay_async_destroy();var kCurrentStreamCount=Symbol("currentStreamCount");var kRequest=Symbol("request");var kOriginSet=Symbol("cachedOriginSet");var kGracefullyClosing=Symbol("gracefullyClosing");var kLength=Symbol("length");var nameKeys=["createConnection","maxDeflateDynamicTableSize","maxSettings","maxSessionMemory","maxHeaderListPairs","maxOutstandingPings","maxReservedRemoteStreams","maxSendHeaderBlockLength","paddingStrategy","peerMaxConcurrentStreams","settings","family","localAddress","rejectUnauthorized","pskCallback","minDHSize","path","socket","ca","cert","sigalgs","ciphers","clientCertEngine","crl","dhparam","ecdhCurve","honorCipherOrder","key","privateKeyEngine","privateKeyIdentifier","maxVersion","minVersion","pfx","secureOptions","secureProtocol","sessionIdContext","ticketKeys"];var getSortedIndex=(array,value,compare)=>{let low=0;let high=array.length;while(low<high){const mid=low+high>>>1;if(compare(array[mid],value)){low=mid+1}else{high=mid}}return low};var compareSessions=(a,b)=>a.remoteSettings.maxConcurrentStreams>b.remoteSettings.maxConcurrentStreams;var closeCoveredSessions=(where,session)=>{for(let index=0;index<where.length;index++){const coveredSession=where[index];if(coveredSession[kOriginSet].length>0&&coveredSession[kOriginSet].length<session[kOriginSet].length&&coveredSession[kOriginSet].every(origin=>session[kOriginSet].includes(origin))&&coveredSession[kCurrentStreamCount]+session[kCurrentStreamCount]<=session.remoteSettings.maxConcurrentStreams){gracefullyClose(coveredSession)}}};var closeSessionIfCovered=(where,coveredSession)=>{for(let index=0;index<where.length;index++){const session=where[index];if(coveredSession[kOriginSet].length>0&&coveredSession[kOriginSet].length<session[kOriginSet].length&&coveredSession[kOriginSet].every(origin=>session[kOriginSet].includes(origin))&&coveredSession[kCurrentStreamCount]+session[kCurrentStreamCount]<=session.remoteSettings.maxConcurrentStreams){gracefullyClose(coveredSession);return true}}return false};var gracefullyClose=session=>{session[kGracefullyClosing]=true;if(session[kCurrentStreamCount]===0){session.close()}};var Agent=class _Agent extends EventEmitter3{constructor({timeout=0,maxSessions=Number.POSITIVE_INFINITY,maxEmptySessions=10,maxCachedTlsSessions=100}={}){super();this.sessions={};this.queue={};this.timeout=timeout;this.maxSessions=maxSessions;this.maxEmptySessions=maxEmptySessions;this._emptySessionCount=0;this._sessionCount=0;this.settings={enablePush:false,initialWindowSize:1024*1024*32};this.tlsSessionCache=new QuickLRU({maxSize:maxCachedTlsSessions})}get protocol(){return"https:"}normalizeOptions(options){let normalized="";for(let index=0;index<nameKeys.length;index++){const key=nameKeys[index];normalized+=":";if(options&&options[key]!==void 0){normalized+=options[key]}}return normalized}_processQueue(){if(this._sessionCount>=this.maxSessions){this.closeEmptySessions(this.maxSessions-this._sessionCount+1);return}for(const normalizedOptions in this.queue){for(const normalizedOrigin in this.queue[normalizedOptions]){const item=this.queue[normalizedOptions][normalizedOrigin];if(!item.completed){item.completed=true;item()}}}}_isBetterSession(thisStreamCount,thatStreamCount){return thisStreamCount>thatStreamCount}_accept(session,listeners,normalizedOrigin,options){let index=0;while(index<listeners.length&&session[kCurrentStreamCount]<session.remoteSettings.maxConcurrentStreams){listeners[index].resolve(session);index++}listeners.splice(0,index);if(listeners.length>0){this.getSession(normalizedOrigin,options,listeners);listeners.length=0}}getSession(origin,options,listeners){return new Promise((resolve,reject2)=>{if(Array.isArray(listeners)&&listeners.length>0){listeners=[...listeners];resolve()}else{listeners=[{resolve,reject:reject2}]}try{if(typeof origin==="string"){origin=new URL3(origin)}else if(!(origin instanceof URL3)){throw new TypeError("The `origin` argument needs to be a string or an URL object")}if(options){const{servername}=options;const{hostname}=origin;if(servername&&hostname!==servername){throw new Error(`Origin ${hostname} differs from servername ${servername}`)}}}catch(error){for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}return}const normalizedOptions=this.normalizeOptions(options);const normalizedOrigin=origin.origin;if(normalizedOptions in this.sessions){const sessions=this.sessions[normalizedOptions];let maxConcurrentStreams=-1;let currentStreamsCount=-1;let optimalSession;for(let index=0;index<sessions.length;index++){const session=sessions[index];const sessionMaxConcurrentStreams=session.remoteSettings.maxConcurrentStreams;if(sessionMaxConcurrentStreams<maxConcurrentStreams){break}if(!session[kOriginSet].includes(normalizedOrigin)){continue}const sessionCurrentStreamsCount=session[kCurrentStreamCount];if(sessionCurrentStreamsCount>=sessionMaxConcurrentStreams||session[kGracefullyClosing]||session.destroyed){continue}if(!optimalSession){maxConcurrentStreams=sessionMaxConcurrentStreams}if(this._isBetterSession(sessionCurrentStreamsCount,currentStreamsCount)){optimalSession=session;currentStreamsCount=sessionCurrentStreamsCount}}if(optimalSession){this._accept(optimalSession,listeners,normalizedOrigin,options);return}}if(normalizedOptions in this.queue){if(normalizedOrigin in this.queue[normalizedOptions]){this.queue[normalizedOptions][normalizedOrigin].listeners.push(...listeners);return}}else{this.queue[normalizedOptions]={[kLength]:0}}const removeFromQueue=()=>{if(normalizedOptions in this.queue&&this.queue[normalizedOptions][normalizedOrigin]===entry){delete this.queue[normalizedOptions][normalizedOrigin];if(--this.queue[normalizedOptions][kLength]===0){delete this.queue[normalizedOptions]}}};const entry=async()=>{this._sessionCount++;const name=`${normalizedOrigin}:${normalizedOptions}`;let receivedSettings=false;let socket;try{const computedOptions={...options};if(computedOptions.settings===void 0){computedOptions.settings=this.settings}if(computedOptions.session===void 0){computedOptions.session=this.tlsSessionCache.get(name)}const createConnection=computedOptions.createConnection||this.createConnection;socket=await createConnection.call(this,origin,computedOptions);computedOptions.createConnection=()=>socket;const session=http22.connect(origin,computedOptions);session[kCurrentStreamCount]=0;session[kGracefullyClosing]=false;const getOriginSet=()=>{const{socket:socket2}=session;let originSet;if(socket2.servername===false){socket2.servername=socket2.remoteAddress;originSet=session.originSet;socket2.servername=false}else{originSet=session.originSet}return originSet};const isFree=()=>session[kCurrentStreamCount]<session.remoteSettings.maxConcurrentStreams;session.socket.once("session",tlsSession=>{this.tlsSessionCache.set(name,tlsSession)});session.once("error",error=>{for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}this.tlsSessionCache.delete(name)});session.setTimeout(this.timeout,()=>{session.destroy()});session.once("close",()=>{this._sessionCount--;if(receivedSettings){this._emptySessionCount--;const where=this.sessions[normalizedOptions];if(where.length===1){delete this.sessions[normalizedOptions]}else{where.splice(where.indexOf(session),1)}}else{removeFromQueue();const error=new Error("Session closed without receiving a SETTINGS frame");error.code="HTTP2WRAPPER_NOSETTINGS";for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}}this._processQueue()});const processListeners=()=>{const queue=this.queue[normalizedOptions];if(!queue){return}const originSet=session[kOriginSet];for(let index=0;index<originSet.length;index++){const origin2=originSet[index];if(origin2 in queue){const{listeners:listeners2,completed}=queue[origin2];let index2=0;while(index2<listeners2.length&&isFree()){listeners2[index2].resolve(session);index2++}queue[origin2].listeners.splice(0,index2);if(queue[origin2].listeners.length===0&&!completed){delete queue[origin2];if(--queue[kLength]===0){delete this.queue[normalizedOptions];break}}if(!isFree()){break}}}};session.on("origin",()=>{session[kOriginSet]=getOriginSet()||[];session[kGracefullyClosing]=false;closeSessionIfCovered(this.sessions[normalizedOptions],session);if(session[kGracefullyClosing]||!isFree()){return}processListeners();if(!isFree()){return}closeCoveredSessions(this.sessions[normalizedOptions],session)});session.once("remoteSettings",()=>{if(entry.destroyed){const error=new Error("Agent has been destroyed");for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}session.destroy();return}if(session.setLocalWindowSize){session.setLocalWindowSize(1024*1024*4)}session[kOriginSet]=getOriginSet()||[];if(session.socket.encrypted){const mainOrigin=session[kOriginSet][0];if(mainOrigin!==normalizedOrigin){const error=new Error(`Requested origin ${normalizedOrigin} does not match server ${mainOrigin}`);for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}session.destroy();return}}removeFromQueue();{const where=this.sessions;if(normalizedOptions in where){const sessions=where[normalizedOptions];sessions.splice(getSortedIndex(sessions,session,compareSessions),0,session)}else{where[normalizedOptions]=[session]}}receivedSettings=true;this._emptySessionCount++;this.emit("session",session);this._accept(session,listeners,normalizedOrigin,options);if(session[kCurrentStreamCount]===0&&this._emptySessionCount>this.maxEmptySessions){this.closeEmptySessions(this._emptySessionCount-this.maxEmptySessions)}session.on("remoteSettings",()=>{if(!isFree()){return}processListeners();if(!isFree()){return}closeCoveredSessions(this.sessions[normalizedOptions],session)})});session[kRequest]=session.request;session.request=(headers,streamOptions)=>{if(session[kGracefullyClosing]){throw new Error("The session is gracefully closing. No new streams are allowed.")}const stream3=session[kRequest](headers,streamOptions);session.ref();if(session[kCurrentStreamCount]++===0){this._emptySessionCount--}stream3.once("close",()=>{if(--session[kCurrentStreamCount]===0){this._emptySessionCount++;session.unref();if(this._emptySessionCount>this.maxEmptySessions||session[kGracefullyClosing]){session.close();return}}if(session.destroyed||session.closed){return}if(isFree()&&!closeSessionIfCovered(this.sessions[normalizedOptions],session)){closeCoveredSessions(this.sessions[normalizedOptions],session);processListeners();if(session[kCurrentStreamCount]===0){this._processQueue()}}});return stream3}}catch(error){removeFromQueue();this._sessionCount--;for(let index=0;index<listeners.length;index++){listeners[index].reject(error)}}};entry.listeners=listeners;entry.completed=false;entry.destroyed=false;this.queue[normalizedOptions][normalizedOrigin]=entry;this.queue[normalizedOptions][kLength]++;this._processQueue()})}request(origin,options,headers,streamOptions){return new Promise((resolve,reject2)=>{this.getSession(origin,options,[{reject:reject2,resolve:session=>{try{const stream3=session.request(headers,streamOptions);delayAsyncDestroy(stream3);resolve(stream3)}catch(error){reject2(error)}}}])})}async createConnection(origin,options){return _Agent.connect(origin,options)}static connect(origin,options){options.ALPNProtocols=["h2"];const port=origin.port||443;const host=origin.hostname;if(typeof options.servername==="undefined"){options.servername=host}const socket=tls.connect(port,host,options);if(options.socket){socket._peername={family:void 0,address:void 0,port}}return socket}closeEmptySessions(maxCount=Number.POSITIVE_INFINITY){let closedCount=0;const{sessions}=this;for(const key in sessions){const thisSessions=sessions[key];for(let index=0;index<thisSessions.length;index++){const session=thisSessions[index];if(session[kCurrentStreamCount]===0){closedCount++;session.close();if(closedCount>=maxCount){return closedCount}}}}return closedCount}destroy(reason){const{sessions,queue}=this;for(const key in sessions){const thisSessions=sessions[key];for(let index=0;index<thisSessions.length;index++){thisSessions[index].destroy(reason)}}for(const normalizedOptions in queue){const entries2=queue[normalizedOptions];for(const normalizedOrigin in entries2){entries2[normalizedOrigin].destroyed=true}}this.queue={};this.tlsSessionCache.clear()}get emptySessionCount(){return this._emptySessionCount}get pendingSessionCount(){return this._sessionCount-this._emptySessionCount}get sessionCount(){return this._sessionCount}};Agent.kCurrentStreamCount=kCurrentStreamCount;Agent.kGracefullyClosing=kGracefullyClosing;module2.exports={Agent,globalAgent:new Agent}}});var require_incoming_message=__commonJS({"node_modules/http2-wrapper/source/incoming-message.js"(exports2,module2){"use strict";var{Readable}=require("stream");var IncomingMessage=class extends Readable{constructor(socket,highWaterMark){super({emitClose:false,autoDestroy:true,highWaterMark});this.statusCode=null;this.statusMessage="";this.httpVersion="2.0";this.httpVersionMajor=2;this.httpVersionMinor=0;this.headers={};this.trailers={};this.req=null;this.aborted=false;this.complete=false;this.upgrade=null;this.rawHeaders=[];this.rawTrailers=[];this.socket=socket;this._dumped=false}get connection(){return this.socket}set connection(value){this.socket=value}_destroy(error,callback){if(!this.readableEnded){this.aborted=true}callback();this.req._request.destroy(error)}setTimeout(ms,callback){this.req.setTimeout(ms,callback);return this}_dump(){if(!this._dumped){this._dumped=true;this.removeAllListeners("data");this.resume()}}_read(){if(this.req){this.req._request.resume()}}};module2.exports=IncomingMessage}});var require_proxy_events=__commonJS({"node_modules/http2-wrapper/source/utils/proxy-events.js"(exports2,module2){"use strict";module2.exports=(from,to,events)=>{for(const event of events){from.on(event,(...args2)=>to.emit(event,...args2))}}}});var require_errors=__commonJS({"node_modules/http2-wrapper/source/utils/errors.js"(exports2,module2){"use strict";var makeError=(Base,key,getMessage)=>{module2.exports[key]=class NodeError extends Base{constructor(...args2){super(typeof getMessage==="string"?getMessage:getMessage(args2));this.name=`${super.name} [${key}]`;this.code=key}}};makeError(TypeError,"ERR_INVALID_ARG_TYPE",args2=>{const type2=args2[0].includes(".")?"property":"argument";let valid=args2[1];const isManyTypes=Array.isArray(valid);if(isManyTypes){valid=`${valid.slice(0,-1).join(", ")} or ${valid.slice(-1)}`}return`The "${args2[0]}" ${type2} must be ${isManyTypes?"one of":"of"} type ${valid}. Received ${typeof args2[2]}`});makeError(TypeError,"ERR_INVALID_PROTOCOL",args2=>`Protocol "${args2[0]}" not supported. Expected "${args2[1]}"`);makeError(Error,"ERR_HTTP_HEADERS_SENT",args2=>`Cannot ${args2[0]} headers after they are sent to the client`);makeError(TypeError,"ERR_INVALID_HTTP_TOKEN",args2=>`${args2[0]} must be a valid HTTP token [${args2[1]}]`);makeError(TypeError,"ERR_HTTP_INVALID_HEADER_VALUE",args2=>`Invalid value "${args2[0]} for header "${args2[1]}"`);makeError(TypeError,"ERR_INVALID_CHAR",args2=>`Invalid character in ${args2[0]} [${args2[1]}]`);makeError(Error,"ERR_HTTP2_NO_SOCKET_MANIPULATION","HTTP/2 sockets should not be directly manipulated (e.g. read and written)")}});var require_is_request_pseudo_header=__commonJS({"node_modules/http2-wrapper/source/utils/is-request-pseudo-header.js"(exports2,module2){"use strict";module2.exports=header2=>{switch(header2){case":method":case":scheme":case":authority":case":path":return true;default:return false}}}});var require_validate_header_name=__commonJS({"node_modules/http2-wrapper/source/utils/validate-header-name.js"(exports2,module2){"use strict";var{ERR_INVALID_HTTP_TOKEN}=require_errors();var isRequestPseudoHeader=require_is_request_pseudo_header();var isValidHttpToken=/^[\^`\-\w!#$%&*+.|~]+$/;module2.exports=name=>{if(typeof name!=="string"||!isValidHttpToken.test(name)&&!isRequestPseudoHeader(name)){throw new ERR_INVALID_HTTP_TOKEN("Header name",name)}}}});var require_validate_header_value=__commonJS({"node_modules/http2-wrapper/source/utils/validate-header-value.js"(exports2,module2){"use strict";var{ERR_HTTP_INVALID_HEADER_VALUE,ERR_INVALID_CHAR}=require_errors();var isInvalidHeaderValue=/[^\t\u0020-\u007E\u0080-\u00FF]/;module2.exports=(name,value)=>{if(typeof value==="undefined"){throw new ERR_HTTP_INVALID_HEADER_VALUE(value,name)}if(isInvalidHeaderValue.test(value)){throw new ERR_INVALID_CHAR("header content",name)}}}});var require_proxy_socket_handler=__commonJS({"node_modules/http2-wrapper/source/utils/proxy-socket-handler.js"(exports2,module2){"use strict";var{ERR_HTTP2_NO_SOCKET_MANIPULATION}=require_errors();var proxySocketHandler={has(stream3,property2){const reference=stream3.session===void 0?stream3:stream3.session.socket;return property2 in stream3||property2 in reference},get(stream3,property2){switch(property2){case"on":case"once":case"end":case"emit":case"destroy":return stream3[property2].bind(stream3);case"writable":case"destroyed":return stream3[property2];case"readable":if(stream3.destroyed){return false}return stream3.readable;case"setTimeout":{const{session}=stream3;if(session!==void 0){return session.setTimeout.bind(session)}return stream3.setTimeout.bind(stream3)}case"write":case"read":case"pause":case"resume":throw new ERR_HTTP2_NO_SOCKET_MANIPULATION;default:{const reference=stream3.session===void 0?stream3:stream3.session.socket;const value=reference[property2];return typeof value==="function"?value.bind(reference):value}}},getPrototypeOf(stream3){if(stream3.session!==void 0){return Reflect.getPrototypeOf(stream3.session.socket)}return Reflect.getPrototypeOf(stream3)},set(stream3,property2,value){switch(property2){case"writable":case"readable":case"destroyed":case"on":case"once":case"end":case"emit":case"destroy":stream3[property2]=value;return true;case"setTimeout":{const{session}=stream3;if(session===void 0){stream3.setTimeout=value}else{session.setTimeout=value}return true}case"write":case"read":case"pause":case"resume":throw new ERR_HTTP2_NO_SOCKET_MANIPULATION;default:{const reference=stream3.session===void 0?stream3:stream3.session.socket;reference[property2]=value;return true}}}};module2.exports=proxySocketHandler}});var require_client_request=__commonJS({"node_modules/http2-wrapper/source/client-request.js"(exports2,module2){"use strict";var{URL:URL3,urlToHttpOptions}=require("url");var http22=require("http2");var{Writable:Writable3}=require("stream");var{Agent,globalAgent}=require_agent();var IncomingMessage=require_incoming_message();var proxyEvents2=require_proxy_events();var{ERR_INVALID_ARG_TYPE,ERR_INVALID_PROTOCOL,ERR_HTTP_HEADERS_SENT}=require_errors();var validateHeaderName=require_validate_header_name();var validateHeaderValue=require_validate_header_value();var proxySocketHandler=require_proxy_socket_handler();var{HTTP2_HEADER_STATUS,HTTP2_HEADER_METHOD,HTTP2_HEADER_PATH,HTTP2_HEADER_AUTHORITY,HTTP2_METHOD_CONNECT}=http22.constants;var kHeaders=Symbol("headers");var kOrigin=Symbol("origin");var kSession=Symbol("session");var kOptions=Symbol("options");var kFlushedHeaders=Symbol("flushedHeaders");var kJobs=Symbol("jobs");var kPendingAgentPromise=Symbol("pendingAgentPromise");var ClientRequest=class extends Writable3{constructor(input,options,callback){super({autoDestroy:false,emitClose:false});if(typeof input==="string"){input=urlToHttpOptions(new URL3(input))}else if(input instanceof URL3){input=urlToHttpOptions(input)}else{input={...input}}if(typeof options==="function"||options===void 0){callback=options;options=input}else{options=Object.assign(input,options)}if(options.h2session){this[kSession]=options.h2session;if(this[kSession].destroyed){throw new Error("The session has been closed already")}this.protocol=this[kSession].socket.encrypted?"https:":"http:"}else if(options.agent===false){this.agent=new Agent({maxEmptySessions:0})}else if(typeof options.agent==="undefined"||options.agent===null){this.agent=globalAgent}else if(typeof options.agent.request==="function"){this.agent=options.agent}else{throw new ERR_INVALID_ARG_TYPE("options.agent",["http2wrapper.Agent-like Object","undefined","false"],options.agent)}if(this.agent){this.protocol=this.agent.protocol}if(options.protocol&&options.protocol!==this.protocol){throw new ERR_INVALID_PROTOCOL(options.protocol,this.protocol)}if(!options.port){options.port=options.defaultPort||this.agent&&this.agent.defaultPort||443}options.host=options.hostname||options.host||"localhost";delete options.hostname;const{timeout}=options;options.timeout=void 0;this[kHeaders]=Object.create(null);this[kJobs]=[];this[kPendingAgentPromise]=void 0;this.socket=null;this.connection=null;this.method=options.method||"GET";if(!(this.method==="CONNECT"&&(options.path==="/"||options.path===void 0))){this.path=options.path}this.res=null;this.aborted=false;this.reusedSocket=false;const{headers}=options;if(headers){for(const header2 in headers){this.setHeader(header2,headers[header2])}}if(options.auth&&!("authorization"in this[kHeaders])){this[kHeaders].authorization="Basic "+Buffer.from(options.auth).toString("base64")}options.session=options.tlsSession;options.path=options.socketPath;this[kOptions]=options;this[kOrigin]=new URL3(`${this.protocol}//${options.servername||options.host}:${options.port}`);const reuseSocket=options._reuseSocket;if(reuseSocket){options.createConnection=(...args2)=>{if(reuseSocket.destroyed){return this.agent.createConnection(...args2)}return reuseSocket};this.agent.getSession(this[kOrigin],this[kOptions]).catch(()=>{})}if(timeout){this.setTimeout(timeout)}if(callback){this.once("response",callback)}this[kFlushedHeaders]=false}get method(){return this[kHeaders][HTTP2_HEADER_METHOD]}set method(value){if(value){this[kHeaders][HTTP2_HEADER_METHOD]=value.toUpperCase()}}get path(){const header2=this.method==="CONNECT"?HTTP2_HEADER_AUTHORITY:HTTP2_HEADER_PATH;return this[kHeaders][header2]}set path(value){if(value){const header2=this.method==="CONNECT"?HTTP2_HEADER_AUTHORITY:HTTP2_HEADER_PATH;this[kHeaders][header2]=value}}get host(){return this[kOrigin].hostname}set host(_value){}get _mustNotHaveABody(){return this.method==="GET"||this.method==="HEAD"||this.method==="DELETE"}_write(chunk2,encoding,callback){if(this._mustNotHaveABody){callback(new Error("The GET, HEAD and DELETE methods must NOT have a body"));return}this.flushHeaders();const callWrite=()=>this._request.write(chunk2,encoding,callback);if(this._request){callWrite()}else{this[kJobs].push(callWrite)}}_final(callback){this.flushHeaders();const callEnd=()=>{if(this._mustNotHaveABody||this.method==="CONNECT"){callback();return}this._request.end(callback)};if(this._request){callEnd()}else{this[kJobs].push(callEnd)}}abort(){if(this.res&&this.res.complete){return}if(!this.aborted){process.nextTick(()=>this.emit("abort"))}this.aborted=true;this.destroy()}async _destroy(error,callback){if(this.res){this.res._dump()}if(this._request){this._request.destroy()}else{process.nextTick(()=>{this.emit("close")})}try{await this[kPendingAgentPromise]}catch(internalError){if(this.aborted){error=internalError}}callback(error)}async flushHeaders(){if(this[kFlushedHeaders]||this.destroyed){return}this[kFlushedHeaders]=true;const isConnectMethod=this.method===HTTP2_METHOD_CONNECT;const onStream=stream3=>{this._request=stream3;if(this.destroyed){stream3.destroy();return}if(!isConnectMethod){proxyEvents2(stream3,this,["timeout","continue"])}stream3.once("error",error=>{this.destroy(error)});stream3.once("aborted",()=>{const{res}=this;if(res){res.aborted=true;res.emit("aborted");res.destroy()}else{this.destroy(new Error("The server aborted the HTTP/2 stream"))}});const onResponse=(headers,flags,rawHeaders)=>{const response=new IncomingMessage(this.socket,stream3.readableHighWaterMark);this.res=response;response.url=`${this[kOrigin].origin}${this.path}`;response.req=this;response.statusCode=headers[HTTP2_HEADER_STATUS];response.headers=headers;response.rawHeaders=rawHeaders;response.once("end",()=>{response.complete=true;response.socket=null;response.connection=null});if(isConnectMethod){response.upgrade=true;if(this.emit("connect",response,stream3,Buffer.alloc(0))){this.emit("close")}else{stream3.destroy()}}else{stream3.on("data",chunk2=>{if(!response._dumped&&!response.push(chunk2)){stream3.pause()}});stream3.once("end",()=>{if(!this.aborted){response.push(null)}});if(!this.emit("response",response)){response._dump()}}};stream3.once("response",onResponse);stream3.once("headers",headers=>this.emit("information",{statusCode:headers[HTTP2_HEADER_STATUS]}));stream3.once("trailers",(trailers,flags,rawTrailers)=>{const{res}=this;if(res===null){onResponse(trailers,flags,rawTrailers);return}res.trailers=trailers;res.rawTrailers=rawTrailers});stream3.once("close",()=>{const{aborted,res}=this;if(res){if(aborted){res.aborted=true;res.emit("aborted");res.destroy()}const finish=()=>{res.emit("close");this.destroy();this.emit("close")};if(res.readable){res.once("end",finish)}else{finish()}return}if(!this.destroyed){this.destroy(new Error("The HTTP/2 stream has been early terminated"));this.emit("close");return}this.destroy();this.emit("close")});this.socket=new Proxy(stream3,proxySocketHandler);for(const job of this[kJobs]){job()}this[kJobs].length=0;this.emit("socket",this.socket)};if(!(HTTP2_HEADER_AUTHORITY in this[kHeaders])&&!isConnectMethod){this[kHeaders][HTTP2_HEADER_AUTHORITY]=this[kOrigin].host}if(this[kSession]){try{onStream(this[kSession].request(this[kHeaders]))}catch(error){this.destroy(error)}}else{this.reusedSocket=true;try{const promise=this.agent.request(this[kOrigin],this[kOptions],this[kHeaders]);this[kPendingAgentPromise]=promise;onStream(await promise);this[kPendingAgentPromise]=false}catch(error){this[kPendingAgentPromise]=false;this.destroy(error)}}}get connection(){return this.socket}set connection(value){this.socket=value}getHeaderNames(){return Object.keys(this[kHeaders])}hasHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}return Boolean(this[kHeaders][name.toLowerCase()])}getHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}return this[kHeaders][name.toLowerCase()]}get headersSent(){return this[kFlushedHeaders]}removeHeader(name){if(typeof name!=="string"){throw new ERR_INVALID_ARG_TYPE("name","string",name)}if(this.headersSent){throw new ERR_HTTP_HEADERS_SENT("remove")}delete this[kHeaders][name.toLowerCase()]}setHeader(name,value){if(this.headersSent){throw new ERR_HTTP_HEADERS_SENT("set")}validateHeaderName(name);validateHeaderValue(name,value);const lowercased=name.toLowerCase();if(lowercased==="connection"){if(value.toLowerCase()==="keep-alive"){return}throw new Error(`Invalid 'connection' header: ${value}`)}if(lowercased==="host"&&this.method==="CONNECT"){this[kHeaders][HTTP2_HEADER_AUTHORITY]=value}else{this[kHeaders][lowercased]=value}}setNoDelay(){}setSocketKeepAlive(){}setTimeout(ms,callback){const applyTimeout=()=>this._request.setTimeout(ms,callback);if(this._request){applyTimeout()}else{this[kJobs].push(applyTimeout)}return this}get maxHeadersCount(){if(!this.destroyed&&this._request){return this._request.session.localSettings.maxHeaderListSize}return void 0}set maxHeadersCount(_value){}};module2.exports=ClientRequest}});var require_resolve_alpn=__commonJS({"node_modules/resolve-alpn/index.js"(exports2,module2){"use strict";var tls=require("tls");module2.exports=(options={},connect=tls.connect)=>new Promise((resolve,reject2)=>{let timeout=false;let socket;const callback=async()=>{await socketPromise;socket.off("timeout",onTimeout);socket.off("error",reject2);if(options.resolveSocket){resolve({alpnProtocol:socket.alpnProtocol,socket,timeout});if(timeout){await Promise.resolve();socket.emit("timeout")}}else{socket.destroy();resolve({alpnProtocol:socket.alpnProtocol,timeout})}};const onTimeout=async()=>{timeout=true;callback()};const socketPromise=(async()=>{try{socket=await connect(options,callback);socket.on("error",reject2);socket.once("timeout",onTimeout)}catch(error){reject2(error)}})()})}});var require_calculate_server_name=__commonJS({"node_modules/http2-wrapper/source/utils/calculate-server-name.js"(exports2,module2){"use strict";var{isIP}=require("net");var assert2=require("assert");var getHost=host=>{if(host[0]==="["){const idx2=host.indexOf("]");assert2(idx2!==-1);return host.slice(1,idx2)}const idx=host.indexOf(":");if(idx===-1){return host}return host.slice(0,idx)};module2.exports=host=>{const servername=getHost(host);if(isIP(servername)){return""}return servername}}});var require_auto=__commonJS({"node_modules/http2-wrapper/source/auto.js"(exports2,module2){"use strict";var{URL:URL3,urlToHttpOptions}=require("url");var http3=require("http");var https2=require("https");var resolveALPN=require_resolve_alpn();var QuickLRU=require_quick_lru();var{Agent,globalAgent}=require_agent();var Http2ClientRequest=require_client_request();var calculateServerName=require_calculate_server_name();var delayAsyncDestroy=require_delay_async_destroy();var cache2=new QuickLRU({maxSize:100});var queue=new Map;var installSocket=(agent,socket,options)=>{socket._httpMessage={shouldKeepAlive:true};const onFree=()=>{agent.emit("free",socket,options)};socket.on("free",onFree);const onClose=()=>{agent.removeSocket(socket,options)};socket.on("close",onClose);const onTimeout=()=>{const{freeSockets}=agent;for(const sockets of Object.values(freeSockets)){if(sockets.includes(socket)){socket.destroy();return}}};socket.on("timeout",onTimeout);const onRemove=()=>{agent.removeSocket(socket,options);socket.off("close",onClose);socket.off("free",onFree);socket.off("timeout",onTimeout);socket.off("agentRemove",onRemove)};socket.on("agentRemove",onRemove);agent.emit("free",socket,options)};var createResolveProtocol=(cache3,queue2=new Map,connect=void 0)=>{return async options=>{const name=`${options.host}:${options.port}:${options.ALPNProtocols.sort()}`;if(!cache3.has(name)){if(queue2.has(name)){const result2=await queue2.get(name);return{alpnProtocol:result2.alpnProtocol}}const{path:path23}=options;options.path=options.socketPath;const resultPromise=resolveALPN(options,connect);queue2.set(name,resultPromise);try{const result2=await resultPromise;cache3.set(name,result2.alpnProtocol);queue2.delete(name);options.path=path23;return result2}catch(error){queue2.delete(name);options.path=path23;throw error}}return{alpnProtocol:cache3.get(name)}}};var defaultResolveProtocol=createResolveProtocol(cache2,queue);module2.exports=async(input,options,callback)=>{if(typeof input==="string"){input=urlToHttpOptions(new URL3(input))}else if(input instanceof URL3){input=urlToHttpOptions(input)}else{input={...input}}if(typeof options==="function"||options===void 0){callback=options;options=input}else{options=Object.assign(input,options)}options.ALPNProtocols=options.ALPNProtocols||["h2","http/1.1"];if(!Array.isArray(options.ALPNProtocols)||options.ALPNProtocols.length===0){throw new Error("The `ALPNProtocols` option must be an Array with at least one entry")}options.protocol=options.protocol||"https:";const isHttps=options.protocol==="https:";options.host=options.hostname||options.host||"localhost";options.session=options.tlsSession;options.servername=options.servername||calculateServerName(options.headers&&options.headers.host||options.host);options.port=options.port||(isHttps?443:80);options._defaultAgent=isHttps?https2.globalAgent:http3.globalAgent;const resolveProtocol=options.resolveProtocol||defaultResolveProtocol;let{agent}=options;if(agent!==void 0&&agent!==false&&agent.constructor.name!=="Object"){throw new Error("The `options.agent` can be only an object `http`, `https` or `http2` properties")}if(isHttps){options.resolveSocket=true;let{socket,alpnProtocol,timeout}=await resolveProtocol(options);if(timeout){if(socket){socket.destroy()}const error=new Error(`Timed out resolving ALPN: ${options.timeout} ms`);error.code="ETIMEDOUT";error.ms=options.timeout;throw error}if(socket&&options.createConnection){socket.destroy();socket=void 0}delete options.resolveSocket;const isHttp2=alpnProtocol==="h2";if(agent){agent=isHttp2?agent.http2:agent.https;options.agent=agent}if(agent===void 0){agent=isHttp2?globalAgent:https2.globalAgent}if(socket){if(agent===false){socket.destroy()}else{const defaultCreateConnection=(isHttp2?Agent:https2.Agent).prototype.createConnection;if(agent.createConnection===defaultCreateConnection){if(isHttp2){options._reuseSocket=socket}else{installSocket(agent,socket,options)}}else{socket.destroy()}}}if(isHttp2){return delayAsyncDestroy(new Http2ClientRequest(options,callback))}}else if(agent){options.agent=agent.http}return delayAsyncDestroy(http3.request(options,callback))};module2.exports.protocolCache=cache2;module2.exports.resolveProtocol=defaultResolveProtocol;module2.exports.createResolveProtocol=createResolveProtocol}});var require_js_stream_socket=__commonJS({"node_modules/http2-wrapper/source/utils/js-stream-socket.js"(exports2,module2){"use strict";var stream3=require("stream");var tls=require("tls");var JSStreamSocket=new tls.TLSSocket(new stream3.PassThrough)._handle._parentWrap.constructor;module2.exports=JSStreamSocket}});var require_unexpected_status_code_error=__commonJS({"node_modules/http2-wrapper/source/proxies/unexpected-status-code-error.js"(exports2,module2){"use strict";var UnexpectedStatusCodeError=class extends Error{constructor(statusCode,statusMessage=""){super(`The proxy server rejected the request with status code ${statusCode} (${statusMessage||"empty status message"})`);this.statusCode=statusCode;this.statusMessage=statusMessage}};module2.exports=UnexpectedStatusCodeError}});var require_check_type=__commonJS({"node_modules/http2-wrapper/source/utils/check-type.js"(exports2,module2){"use strict";var checkType=(name,value,types6)=>{const valid=types6.some(type2=>{const typeofType=typeof type2;if(typeofType==="string"){return typeof value===type2}return value instanceof type2});if(!valid){const names2=types6.map(type2=>typeof type2==="string"?type2:type2.name);throw new TypeError(`Expected '${name}' to be a type of ${names2.join(" or ")}, got ${typeof value}`)}};module2.exports=checkType}});var require_initialize=__commonJS({"node_modules/http2-wrapper/source/proxies/initialize.js"(exports2,module2){"use strict";var{URL:URL3}=require("url");var checkType=require_check_type();module2.exports=(self2,proxyOptions)=>{checkType("proxyOptions",proxyOptions,["object"]);checkType("proxyOptions.headers",proxyOptions.headers,["object","undefined"]);checkType("proxyOptions.raw",proxyOptions.raw,["boolean","undefined"]);checkType("proxyOptions.url",proxyOptions.url,[URL3,"string"]);const url=new URL3(proxyOptions.url);self2.proxyOptions={raw:true,...proxyOptions,headers:{...proxyOptions.headers},url}}}});var require_get_auth_headers=__commonJS({"node_modules/http2-wrapper/source/proxies/get-auth-headers.js"(exports2,module2){"use strict";module2.exports=self2=>{const{username,password}=self2.proxyOptions.url;if(username||password){const data=`${username}:${password}`;const authorization=`Basic ${Buffer.from(data).toString("base64")}`;return{"proxy-authorization":authorization,authorization}}return{}}}});var require_h1_over_h2=__commonJS({"node_modules/http2-wrapper/source/proxies/h1-over-h2.js"(exports2,module2){"use strict";var tls=require("tls");var http3=require("http");var https2=require("https");var JSStreamSocket=require_js_stream_socket();var{globalAgent}=require_agent();var UnexpectedStatusCodeError=require_unexpected_status_code_error();var initialize=require_initialize();var getAuthorizationHeaders=require_get_auth_headers();var createConnection=(self2,options,callback)=>{(async()=>{try{const{proxyOptions}=self2;const{url,headers,raw}=proxyOptions;const stream3=await globalAgent.request(url,proxyOptions,{...getAuthorizationHeaders(self2),...headers,":method":"CONNECT",":authority":`${options.host}:${options.port}`});stream3.once("error",callback);stream3.once("response",headers2=>{const statusCode=headers2[":status"];if(statusCode!==200){callback(new UnexpectedStatusCodeError(statusCode,""));return}const encrypted=self2 instanceof https2.Agent;if(raw&&encrypted){options.socket=stream3;const secureStream=tls.connect(options);secureStream.once("close",()=>{stream3.destroy()});callback(null,secureStream);return}const socket=new JSStreamSocket(stream3);socket.encrypted=false;socket._handle.getpeername=out=>{out.family=void 0;out.address=void 0;out.port=void 0};callback(null,socket)})}catch(error){callback(error)}})()};var HttpOverHttp2=class extends http3.Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}createConnection(options,callback){createConnection(this,options,callback)}};var HttpsOverHttp2=class extends https2.Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}createConnection(options,callback){createConnection(this,options,callback)}};module2.exports={HttpOverHttp2,HttpsOverHttp2}}});var require_h2_over_hx=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-hx.js"(exports2,module2){"use strict";var{Agent}=require_agent();var JSStreamSocket=require_js_stream_socket();var UnexpectedStatusCodeError=require_unexpected_status_code_error();var initialize=require_initialize();var Http2OverHttpX=class extends Agent{constructor(options){super(options);initialize(this,options.proxyOptions)}async createConnection(origin,options){const authority=`${origin.hostname}:${origin.port||443}`;const[stream3,statusCode,statusMessage]=await this._getProxyStream(authority);if(statusCode!==200){throw new UnexpectedStatusCodeError(statusCode,statusMessage)}if(this.proxyOptions.raw){options.socket=stream3}else{const socket=new JSStreamSocket(stream3);socket.encrypted=false;socket._handle.getpeername=out=>{out.family=void 0;out.address=void 0;out.port=void 0};return socket}return super.createConnection(origin,options)}};module2.exports=Http2OverHttpX}});var require_h2_over_h2=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-h2.js"(exports2,module2){"use strict";var{globalAgent}=require_agent();var Http2OverHttpX=require_h2_over_hx();var getAuthorizationHeaders=require_get_auth_headers();var getStatusCode=stream3=>new Promise((resolve,reject2)=>{stream3.once("error",reject2);stream3.once("response",headers=>{stream3.off("error",reject2);resolve(headers[":status"])})});var Http2OverHttp2=class extends Http2OverHttpX{async _getProxyStream(authority){const{proxyOptions}=this;const headers={...getAuthorizationHeaders(this),...proxyOptions.headers,":method":"CONNECT",":authority":authority};const stream3=await globalAgent.request(proxyOptions.url,proxyOptions,headers);const statusCode=await getStatusCode(stream3);return[stream3,statusCode,""]}};module2.exports=Http2OverHttp2}});var require_h2_over_h1=__commonJS({"node_modules/http2-wrapper/source/proxies/h2-over-h1.js"(exports2,module2){"use strict";var http3=require("http");var https2=require("https");var Http2OverHttpX=require_h2_over_hx();var getAuthorizationHeaders=require_get_auth_headers();var getStream3=request=>new Promise((resolve,reject2)=>{const onConnect=(response,socket,head2)=>{socket.unshift(head2);request.off("error",reject2);resolve([socket,response.statusCode,response.statusMessage])};request.once("error",reject2);request.once("connect",onConnect)});var Http2OverHttp=class extends Http2OverHttpX{async _getProxyStream(authority){const{proxyOptions}=this;const{url,headers}=this.proxyOptions;const network=url.protocol==="https:"?https2:http3;const request=network.request({...proxyOptions,hostname:url.hostname,port:url.port,path:authority,headers:{...getAuthorizationHeaders(this),...headers,host:authority},method:"CONNECT"}).end();return getStream3(request)}};module2.exports={Http2OverHttp,Http2OverHttps:Http2OverHttp}}});var require_source2=__commonJS({"node_modules/http2-wrapper/source/index.js"(exports2,module2){"use strict";var http22=require("http2");var{Agent,globalAgent}=require_agent();var ClientRequest=require_client_request();var IncomingMessage=require_incoming_message();var auto=require_auto();var{HttpOverHttp2,HttpsOverHttp2}=require_h1_over_h2();var Http2OverHttp2=require_h2_over_h2();var{Http2OverHttp,Http2OverHttps}=require_h2_over_h1();var validateHeaderName=require_validate_header_name();var validateHeaderValue=require_validate_header_value();var request=(url,options,callback)=>new ClientRequest(url,options,callback);var get4=(url,options,callback)=>{const req=new ClientRequest(url,options,callback);req.end();return req};module2.exports={...http22,ClientRequest,IncomingMessage,Agent,globalAgent,request,get:get4,auto,proxies:{HttpOverHttp2,HttpsOverHttp2,Http2OverHttp2,Http2OverHttp,Http2OverHttps},validateHeaderName,validateHeaderValue}}});var require_windows=__commonJS({"node_modules/isexe/windows.js"(exports2,module2){module2.exports=isexe;isexe.sync=sync;var fs11=require("fs");function checkPathExt(path23,options){var pathext=options.pathExt!==void 0?options.pathExt:process.env.PATHEXT;if(!pathext){return true}pathext=pathext.split(";");if(pathext.indexOf("")!==-1){return true}for(var i=0;i<pathext.length;i++){var p=pathext[i].toLowerCase();if(p&&path23.substr(-p.length).toLowerCase()===p){return true}}return false}function checkStat(stat3,path23,options){if(!stat3.isSymbolicLink()&&!stat3.isFile()){return false}return checkPathExt(path23,options)}function isexe(path23,options,cb){fs11.stat(path23,function(er,stat3){cb(er,er?false:checkStat(stat3,path23,options))})}function sync(path23,options){return checkStat(fs11.statSync(path23),path23,options)}}});var require_mode=__commonJS({"node_modules/isexe/mode.js"(exports2,module2){module2.exports=isexe;isexe.sync=sync;var fs11=require("fs");function isexe(path23,options,cb){fs11.stat(path23,function(er,stat3){cb(er,er?false:checkStat(stat3,options))})}function sync(path23,options){return checkStat(fs11.statSync(path23),options)}function checkStat(stat3,options){return stat3.isFile()&&checkMode(stat3,options)}function checkMode(stat3,options){var mod3=stat3.mode;var uid=stat3.uid;var gid=stat3.gid;var myUid=options.uid!==void 0?options.uid:process.getuid&&process.getuid();var myGid=options.gid!==void 0?options.gid:process.getgid&&process.getgid();var u=parseInt("100",8);var g=parseInt("010",8);var o=parseInt("001",8);var ug=u|g;var ret=mod3&o||mod3&g&&gid===myGid||mod3&u&&uid===myUid||mod3&ug&&myUid===0;return ret}}});var require_isexe=__commonJS({"node_modules/isexe/index.js"(exports2,module2){var fs11=require("fs");var core2;if(process.platform==="win32"||global.TESTING_WINDOWS){core2=require_windows()}else{core2=require_mode()}module2.exports=isexe;isexe.sync=sync;function isexe(path23,options,cb){if(typeof options==="function"){cb=options;options={}}if(!cb){if(typeof Promise!=="function"){throw new TypeError("callback not provided")}return new Promise(function(resolve,reject2){isexe(path23,options||{},function(er,is2){if(er){reject2(er)}else{resolve(is2)}})})}core2(path23,options||{},function(er,is2){if(er){if(er.code==="EACCES"||options&&options.ignoreErrors){er=null;is2=false}}cb(er,is2)})}function sync(path23,options){try{return core2.sync(path23,options||{})}catch(er){if(options&&options.ignoreErrors||er.code==="EACCES"){return false}else{throw er}}}}});var require_which=__commonJS({"node_modules/which/which.js"(exports2,module2){var isWindows2=process.platform==="win32"||process.env.OSTYPE==="cygwin"||process.env.OSTYPE==="msys";var path23=require("path");var COLON=isWindows2?";":":";var isexe=require_isexe();var getNotFoundError=cmd=>Object.assign(new Error(`not found: ${cmd}`),{code:"ENOENT"});var getPathInfo=(cmd,opt)=>{const colon=opt.colon||COLON;const pathEnv=cmd.match(/\//)||isWindows2&&cmd.match(/\\/)?[""]:[...isWindows2?[process.cwd()]:[],...(opt.path||process.env.PATH||"").split(colon)];const pathExtExe=isWindows2?opt.pathExt||process.env.PATHEXT||".EXE;.CMD;.BAT;.COM":"";const pathExt=isWindows2?pathExtExe.split(colon):[""];if(isWindows2){if(cmd.indexOf(".")!==-1&&pathExt[0]!=="")pathExt.unshift("")}return{pathEnv,pathExt,pathExtExe}};var which=(cmd,opt,cb)=>{if(typeof opt==="function"){cb=opt;opt={}}if(!opt)opt={};const{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt);const found=[];const step=i=>new Promise((resolve,reject2)=>{if(i===pathEnv.length)return opt.all&&found.length?resolve(found):reject2(getNotFoundError(cmd));const ppRaw=pathEnv[i];const pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw;const pCmd=path23.join(pathPart,cmd);const p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;resolve(subStep(p,i,0))});const subStep=(p,i,ii)=>new Promise((resolve,reject2)=>{if(ii===pathExt.length)return resolve(step(i+1));const ext=pathExt[ii];isexe(p+ext,{pathExt:pathExtExe},(er,is2)=>{if(!er&&is2){if(opt.all)found.push(p+ext);else return resolve(p+ext)}return resolve(subStep(p,i,ii+1))})});return cb?step(0).then(res=>cb(null,res),cb):step(0)};var whichSync=(cmd,opt)=>{opt=opt||{};const{pathEnv,pathExt,pathExtExe}=getPathInfo(cmd,opt);const found=[];for(let i=0;i<pathEnv.length;i++){const ppRaw=pathEnv[i];const pathPart=/^".*"$/.test(ppRaw)?ppRaw.slice(1,-1):ppRaw;const pCmd=path23.join(pathPart,cmd);const p=!pathPart&&/^\.[\\\/]/.test(cmd)?cmd.slice(0,2)+pCmd:pCmd;for(let j=0;j<pathExt.length;j++){const cur=p+pathExt[j];try{const is2=isexe.sync(cur,{pathExt:pathExtExe});if(is2){if(opt.all)found.push(cur);else return cur}}catch(ex){}}}if(opt.all&&found.length)return found;if(opt.nothrow)return null;throw getNotFoundError(cmd)};module2.exports=which;which.sync=whichSync}});var require_path_key=__commonJS({"node_modules/path-key/index.js"(exports2,module2){"use strict";var pathKey=(options={})=>{const environment=options.env||process.env;const platform=options.platform||process.platform;if(platform!=="win32"){return"PATH"}return Object.keys(environment).reverse().find(key=>key.toUpperCase()==="PATH")||"Path"};module2.exports=pathKey;module2.exports.default=pathKey}});var require_resolveCommand=__commonJS({"node_modules/cross-spawn/lib/util/resolveCommand.js"(exports2,module2){"use strict";var path23=require("path");var which=require_which();var getPathKey=require_path_key();function resolveCommandAttempt(parsed,withoutPathExt){const env2=parsed.options.env||process.env;const cwd=process.cwd();const hasCustomCwd=parsed.options.cwd!=null;const shouldSwitchCwd=hasCustomCwd&&process.chdir!==void 0&&!process.chdir.disabled;if(shouldSwitchCwd){try{process.chdir(parsed.options.cwd)}catch(err){}}let resolved;try{resolved=which.sync(parsed.command,{path:env2[getPathKey({env:env2})],pathExt:withoutPathExt?path23.delimiter:void 0})}catch(e){}finally{if(shouldSwitchCwd){process.chdir(cwd)}}if(resolved){resolved=path23.resolve(hasCustomCwd?parsed.options.cwd:"",resolved)}return resolved}function resolveCommand(parsed){return resolveCommandAttempt(parsed)||resolveCommandAttempt(parsed,true)}module2.exports=resolveCommand}});var require_escape=__commonJS({"node_modules/cross-spawn/lib/util/escape.js"(exports2,module2){"use strict";var metaCharsRegExp=/([()\][%!^"`<>&|;, *?])/g;function escapeCommand(arg){arg=arg.replace(metaCharsRegExp,"^$1");return arg}function escapeArgument(arg,doubleEscapeMetaChars){arg=`${arg}`;arg=arg.replace(/(\\*)"/g,'$1$1\\"');arg=arg.replace(/(\\*)$/,"$1$1");arg=`"${arg}"`;arg=arg.replace(metaCharsRegExp,"^$1");if(doubleEscapeMetaChars){arg=arg.replace(metaCharsRegExp,"^$1")}return arg}module2.exports.command=escapeCommand;module2.exports.argument=escapeArgument}});var require_shebang_regex=__commonJS({"node_modules/shebang-regex/index.js"(exports2,module2){"use strict";module2.exports=/^#!(.*)/}});var require_shebang_command=__commonJS({"node_modules/shebang-command/index.js"(exports2,module2){"use strict";var shebangRegex=require_shebang_regex();module2.exports=(string="")=>{const match=string.match(shebangRegex);if(!match){return null}const[path23,argument]=match[0].replace(/#! ?/,"").split(" ");const binary2=path23.split("/").pop();if(binary2==="env"){return argument}return argument?`${binary2} ${argument}`:binary2}}});var require_readShebang=__commonJS({"node_modules/cross-spawn/lib/util/readShebang.js"(exports2,module2){"use strict";var fs11=require("fs");var shebangCommand=require_shebang_command();function readShebang(command){const size2=150;const buffer=Buffer.alloc(size2);let fd;try{fd=fs11.openSync(command,"r");fs11.readSync(fd,buffer,0,size2,0);fs11.closeSync(fd)}catch(e){}return shebangCommand(buffer.toString())}module2.exports=readShebang}});var require_parse=__commonJS({"node_modules/cross-spawn/lib/parse.js"(exports2,module2){"use strict";var path23=require("path");var resolveCommand=require_resolveCommand();var escape5=require_escape();var readShebang=require_readShebang();var isWin=process.platform==="win32";var isExecutableRegExp=/\.(?:com|exe)$/i;var isCmdShimRegExp=/node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;function detectShebang(parsed){parsed.file=resolveCommand(parsed);const shebang=parsed.file&&readShebang(parsed.file);if(shebang){parsed.args.unshift(parsed.file);parsed.command=shebang;return resolveCommand(parsed)}return parsed.file}function parseNonShell(parsed){if(!isWin){return parsed}const commandFile=detectShebang(parsed);const needsShell=!isExecutableRegExp.test(commandFile);if(parsed.options.forceShell||needsShell){const needsDoubleEscapeMetaChars=isCmdShimRegExp.test(commandFile);parsed.command=path23.normalize(parsed.command);parsed.command=escape5.command(parsed.command);parsed.args=parsed.args.map(arg=>escape5.argument(arg,needsDoubleEscapeMetaChars));const shellCommand=[parsed.command].concat(parsed.args).join(" ");parsed.args=["/d","/s","/c",`"${shellCommand}"`];parsed.command=process.env.comspec||"cmd.exe";parsed.options.windowsVerbatimArguments=true}return parsed}function parse3(command,args2,options){if(args2&&!Array.isArray(args2)){options=args2;args2=null}args2=args2?args2.slice(0):[];options=Object.assign({},options);const parsed={command,args:args2,options,file:void 0,original:{command,args:args2}};return options.shell?parsed:parseNonShell(parsed)}module2.exports=parse3}});var require_enoent=__commonJS({"node_modules/cross-spawn/lib/enoent.js"(exports2,module2){"use strict";var isWin=process.platform==="win32";function notFoundError(original,syscall){return Object.assign(new Error(`${syscall} ${original.command} ENOENT`),{code:"ENOENT",errno:"ENOENT",syscall:`${syscall} ${original.command}`,path:original.command,spawnargs:original.args})}function hookChildProcess(cp,parsed){if(!isWin){return}const originalEmit=cp.emit;cp.emit=function(name,arg1){if(name==="exit"){const err=verifyENOENT(arg1,parsed,"spawn");if(err){return originalEmit.call(cp,"error",err)}}return originalEmit.apply(cp,arguments)}}function verifyENOENT(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawn")}return null}function verifyENOENTSync(status,parsed){if(isWin&&status===1&&!parsed.file){return notFoundError(parsed.original,"spawnSync")}return null}module2.exports={hookChildProcess,verifyENOENT,verifyENOENTSync,notFoundError}}});var require_cross_spawn=__commonJS({"node_modules/cross-spawn/index.js"(exports2,module2){"use strict";var cp=require("child_process");var parse3=require_parse();var enoent=require_enoent();function spawn2(command,args2,options){const parsed=parse3(command,args2,options);const spawned=cp.spawn(parsed.command,parsed.args,parsed.options);enoent.hookChildProcess(spawned,parsed);return spawned}function spawnSync(command,args2,options){const parsed=parse3(command,args2,options);const result2=cp.spawnSync(parsed.command,parsed.args,parsed.options);result2.error=result2.error||enoent.verifyENOENTSync(result2.status,parsed);return result2}module2.exports=spawn2;module2.exports.spawn=spawn2;module2.exports.sync=spawnSync;module2.exports._parse=parse3;module2.exports._enoent=enoent}});var require_strip_final_newline=__commonJS({"node_modules/strip-final-newline/index.js"(exports2,module2){"use strict";module2.exports=input=>{const LF=typeof input==="string"?"\n":"\n".charCodeAt();const CR=typeof input==="string"?"\r":"\r".charCodeAt();if(input[input.length-1]===LF){input=input.slice(0,input.length-1)}if(input[input.length-1]===CR){input=input.slice(0,input.length-1)}return input}}});var require_npm_run_path=__commonJS({"node_modules/npm-run-path/index.js"(exports2,module2){"use strict";var path23=require("path");var pathKey=require_path_key();var npmRunPath=options=>{options={cwd:process.cwd(),path:process.env[pathKey()],execPath:process.execPath,...options};let previous;let cwdPath=path23.resolve(options.cwd);const result2=[];while(previous!==cwdPath){result2.push(path23.join(cwdPath,"node_modules/.bin"));previous=cwdPath;cwdPath=path23.resolve(cwdPath,"..")}const execPathDir=path23.resolve(options.cwd,options.execPath,"..");result2.push(execPathDir);return result2.concat(options.path).join(path23.delimiter)};module2.exports=npmRunPath;module2.exports.default=npmRunPath;module2.exports.env=options=>{options={env:process.env,...options};const env2={...options.env};const path24=pathKey({env:env2});options.path=env2[path24];env2[path24]=module2.exports(options);return env2}}});var require_mimic_fn=__commonJS({"node_modules/mimic-fn/index.js"(exports2,module2){"use strict";var mimicFn=(to,from)=>{for(const prop of Reflect.ownKeys(from)){Object.defineProperty(to,prop,Object.getOwnPropertyDescriptor(from,prop))}return to};module2.exports=mimicFn;module2.exports.default=mimicFn}});var require_onetime=__commonJS({"node_modules/onetime/index.js"(exports2,module2){"use strict";var mimicFn=require_mimic_fn();var calledFunctions=new WeakMap;var onetime=(function_,options={})=>{if(typeof function_!=="function"){throw new TypeError("Expected a function")}let returnValue;let callCount=0;const functionName=function_.displayName||function_.name||"<anonymous>";const onetime2=function(...arguments_){calledFunctions.set(onetime2,++callCount);if(callCount===1){returnValue=function_.apply(this,arguments_);function_=null}else if(options.throw===true){throw new Error(`Function \`${functionName}\` can only be called once`)}return returnValue};mimicFn(onetime2,function_);calledFunctions.set(onetime2,callCount);return onetime2};module2.exports=onetime;module2.exports.default=onetime;module2.exports.callCount=function_=>{if(!calledFunctions.has(function_)){throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`)}return calledFunctions.get(function_)}}});var require_core=__commonJS({"node_modules/human-signals/build/src/core.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SIGNALS=void 0;var SIGNALS=[{name:"SIGHUP",number:1,action:"terminate",description:"Terminal closed",standard:"posix"},{name:"SIGINT",number:2,action:"terminate",description:"User interruption with CTRL-C",standard:"ansi"},{name:"SIGQUIT",number:3,action:"core",description:"User interruption with CTRL-\\",standard:"posix"},{name:"SIGILL",number:4,action:"core",description:"Invalid machine instruction",standard:"ansi"},{name:"SIGTRAP",number:5,action:"core",description:"Debugger breakpoint",standard:"posix"},{name:"SIGABRT",number:6,action:"core",description:"Aborted",standard:"ansi"},{name:"SIGIOT",number:6,action:"core",description:"Aborted",standard:"bsd"},{name:"SIGBUS",number:7,action:"core",description:"Bus error due to misaligned, non-existing address or paging error",standard:"bsd"},{name:"SIGEMT",number:7,action:"terminate",description:"Command should be emulated but is not implemented",standard:"other"},{name:"SIGFPE",number:8,action:"core",description:"Floating point arithmetic error",standard:"ansi"},{name:"SIGKILL",number:9,action:"terminate",description:"Forced termination",standard:"posix",forced:true},{name:"SIGUSR1",number:10,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGSEGV",number:11,action:"core",description:"Segmentation fault",standard:"ansi"},{name:"SIGUSR2",number:12,action:"terminate",description:"Application-specific signal",standard:"posix"},{name:"SIGPIPE",number:13,action:"terminate",description:"Broken pipe or socket",standard:"posix"},{name:"SIGALRM",number:14,action:"terminate",description:"Timeout or timer",standard:"posix"},{name:"SIGTERM",number:15,action:"terminate",description:"Termination",standard:"ansi"},{name:"SIGSTKFLT",number:16,action:"terminate",description:"Stack is empty or overflowed",standard:"other"},{name:"SIGCHLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"posix"},{name:"SIGCLD",number:17,action:"ignore",description:"Child process terminated, paused or unpaused",standard:"other"},{name:"SIGCONT",number:18,action:"unpause",description:"Unpaused",standard:"posix",forced:true},{name:"SIGSTOP",number:19,action:"pause",description:"Paused",standard:"posix",forced:true},{name:"SIGTSTP",number:20,action:"pause",description:'Paused using CTRL-Z or "suspend"',standard:"posix"},{name:"SIGTTIN",number:21,action:"pause",description:"Background process cannot read terminal input",standard:"posix"},{name:"SIGBREAK",number:21,action:"terminate",description:"User interruption with CTRL-BREAK",standard:"other"},{name:"SIGTTOU",number:22,action:"pause",description:"Background process cannot write to terminal output",standard:"posix"},{name:"SIGURG",number:23,action:"ignore",description:"Socket received out-of-band data",standard:"bsd"},{name:"SIGXCPU",number:24,action:"core",description:"Process timed out",standard:"bsd"},{name:"SIGXFSZ",number:25,action:"core",description:"File too big",standard:"bsd"},{name:"SIGVTALRM",number:26,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGPROF",number:27,action:"terminate",description:"Timeout or timer",standard:"bsd"},{name:"SIGWINCH",number:28,action:"ignore",description:"Terminal window size changed",standard:"bsd"},{name:"SIGIO",number:29,action:"terminate",description:"I/O is available",standard:"other"},{name:"SIGPOLL",number:29,action:"terminate",description:"Watched event",standard:"other"},{name:"SIGINFO",number:29,action:"ignore",description:"Request for process information",standard:"other"},{name:"SIGPWR",number:30,action:"terminate",description:"Device running out of power",standard:"systemv"},{name:"SIGSYS",number:31,action:"core",description:"Invalid system call",standard:"other"},{name:"SIGUNUSED",number:31,action:"terminate",description:"Invalid system call",standard:"other"}];exports2.SIGNALS=SIGNALS}});var require_realtime=__commonJS({"node_modules/human-signals/build/src/realtime.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SIGRTMAX=exports2.getRealtimeSignals=void 0;var getRealtimeSignals=function(){const length=SIGRTMAX-SIGRTMIN+1;return Array.from({length},getRealtimeSignal)};exports2.getRealtimeSignals=getRealtimeSignals;var getRealtimeSignal=function(value,index){return{name:`SIGRT${index+1}`,number:SIGRTMIN+index,action:"terminate",description:"Application-specific signal (realtime)",standard:"posix"}};var SIGRTMIN=34;var SIGRTMAX=64;exports2.SIGRTMAX=SIGRTMAX}});var require_signals=__commonJS({"node_modules/human-signals/build/src/signals.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.getSignals=void 0;var _os=require("os");var _core=require_core();var _realtime=require_realtime();var getSignals=function(){const realtimeSignals=(0,_realtime.getRealtimeSignals)();const signals=[..._core.SIGNALS,...realtimeSignals].map(normalizeSignal);return signals};exports2.getSignals=getSignals;var normalizeSignal=function({name,number:defaultNumber,description,action,forced=false,standard}){const{signals:{[name]:constantSignal}}=_os.constants;const supported=constantSignal!==void 0;const number2=supported?constantSignal:defaultNumber;return{name,number:number2,description,supported,action,forced,standard}}}});var require_main=__commonJS({"node_modules/human-signals/build/src/main.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.signalsByNumber=exports2.signalsByName=void 0;var _os=require("os");var _signals=require_signals();var _realtime=require_realtime();var getSignalsByName=function(){const signals=(0,_signals.getSignals)();return signals.reduce(getSignalByName,{})};var getSignalByName=function(signalByNameMemo,{name,number:number2,description,supported,action,forced,standard}){return{...signalByNameMemo,[name]:{name,number:number2,description,supported,action,forced,standard}}};var signalsByName=getSignalsByName();exports2.signalsByName=signalsByName;var getSignalsByNumber=function(){const signals=(0,_signals.getSignals)();const length=_realtime.SIGRTMAX+1;const signalsA=Array.from({length},(value,number2)=>getSignalByNumber(number2,signals));return Object.assign({},...signalsA)};var getSignalByNumber=function(number2,signals){const signal=findSignalByNumber(number2,signals);if(signal===void 0){return{}}const{name,description,supported,action,forced,standard}=signal;return{[number2]:{name,number:number2,description,supported,action,forced,standard}}};var findSignalByNumber=function(number2,signals){const signal=signals.find(({name})=>_os.constants.signals[name]===number2);if(signal!==void 0){return signal}return signals.find(signalA=>signalA.number===number2)};var signalsByNumber=getSignalsByNumber();exports2.signalsByNumber=signalsByNumber}});var require_error=__commonJS({"node_modules/execa/lib/error.js"(exports2,module2){"use strict";var{signalsByName}=require_main();var getErrorPrefix=({timedOut:timedOut2,timeout,errorCode,signal,signalDescription,exitCode,isCanceled})=>{if(timedOut2){return`timed out after ${timeout} milliseconds`}if(isCanceled){return"was canceled"}if(errorCode!==void 0){return`failed with ${errorCode}`}if(signal!==void 0){return`was killed with ${signal} (${signalDescription})`}if(exitCode!==void 0){return`failed with exit code ${exitCode}`}return"failed"};var makeError=({stdout,stderr,all:all2,error,signal,exitCode,command,escapedCommand,timedOut:timedOut2,isCanceled,killed,parsed:{options:{timeout}}})=>{exitCode=exitCode===null?void 0:exitCode;signal=signal===null?void 0:signal;const signalDescription=signal===void 0?void 0:signalsByName[signal].description;const errorCode=error&&error.code;const prefix=getErrorPrefix({timedOut:timedOut2,timeout,errorCode,signal,signalDescription,exitCode,isCanceled});const execaMessage=`Command ${prefix}: ${command}`;const isError2=Object.prototype.toString.call(error)==="[object Error]";const shortMessage=isError2?`${execaMessage}
${error.message}`:execaMessage;const message3=[shortMessage,stderr,stdout].filter(Boolean).join("\n");if(isError2){error.originalMessage=error.message;error.message=message3}else{error=new Error(message3)}error.shortMessage=shortMessage;error.command=command;error.escapedCommand=escapedCommand;error.exitCode=exitCode;error.signal=signal;error.signalDescription=signalDescription;error.stdout=stdout;error.stderr=stderr;if(all2!==void 0){error.all=all2}if("bufferedData"in error){delete error.bufferedData}error.failed=true;error.timedOut=Boolean(timedOut2);error.isCanceled=isCanceled;error.killed=killed&&!timedOut2;return error};module2.exports=makeError}});var require_stdio=__commonJS({"node_modules/execa/lib/stdio.js"(exports2,module2){"use strict";var aliases2=["stdin","stdout","stderr"];var hasAlias=options=>aliases2.some(alias=>options[alias]!==void 0);var normalizeStdio=options=>{if(!options){return}const{stdio}=options;if(stdio===void 0){return aliases2.map(alias=>options[alias])}if(hasAlias(options)){throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases2.map(alias=>`\`${alias}\``).join(", ")}`)}if(typeof stdio==="string"){return stdio}if(!Array.isArray(stdio)){throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``)}const length=Math.max(stdio.length,aliases2.length);return Array.from({length},(value,index)=>stdio[index])};module2.exports=normalizeStdio;module2.exports.node=options=>{const stdio=normalizeStdio(options);if(stdio==="ipc"){return"ipc"}if(stdio===void 0||typeof stdio==="string"){return[stdio,stdio,stdio,"ipc"]}if(stdio.includes("ipc")){return stdio}return[...stdio,"ipc"]}}});var require_signals2=__commonJS({"node_modules/signal-exit/signals.js"(exports2,module2){module2.exports=["SIGABRT","SIGALRM","SIGHUP","SIGINT","SIGTERM"];if(process.platform!=="win32"){module2.exports.push("SIGVTALRM","SIGXCPU","SIGXFSZ","SIGUSR2","SIGTRAP","SIGSYS","SIGQUIT","SIGIOT")}if(process.platform==="linux"){module2.exports.push("SIGIO","SIGPOLL","SIGPWR","SIGSTKFLT","SIGUNUSED")}}});var require_signal_exit=__commonJS({"node_modules/signal-exit/index.js"(exports2,module2){var process6=global.process;var processOk=function(process7){return process7&&typeof process7==="object"&&typeof process7.removeListener==="function"&&typeof process7.emit==="function"&&typeof process7.reallyExit==="function"&&typeof process7.listeners==="function"&&typeof process7.kill==="function"&&typeof process7.pid==="number"&&typeof process7.on==="function"};if(!processOk(process6)){module2.exports=function(){return function(){}}}else{assert2=require("assert");signals=require_signals2();isWin=/^win/i.test(process6.platform);EE=require("events");if(typeof EE!=="function"){EE=EE.EventEmitter}if(process6.__signal_exit_emitter__){emitter=process6.__signal_exit_emitter__}else{emitter=process6.__signal_exit_emitter__=new EE;emitter.count=0;emitter.emitted={}}if(!emitter.infinite){emitter.setMaxListeners(Infinity);emitter.infinite=true}module2.exports=function(cb,opts){if(!processOk(global.process)){return function(){}}assert2.equal(typeof cb,"function","a callback must be provided for exit handler");if(loaded===false){load2()}var ev="exit";if(opts&&opts.alwaysLast){ev="afterexit"}var remove2=function(){emitter.removeListener(ev,cb);if(emitter.listeners("exit").length===0&&emitter.listeners("afterexit").length===0){unload()}};emitter.on(ev,cb);return remove2};unload=function unload2(){if(!loaded||!processOk(global.process)){return}loaded=false;signals.forEach(function(sig){try{process6.removeListener(sig,sigListeners[sig])}catch(er){}});process6.emit=originalProcessEmit;process6.reallyExit=originalProcessReallyExit;emitter.count-=1};module2.exports.unload=unload;emit=function emit2(event,code,signal){if(emitter.emitted[event]){return}emitter.emitted[event]=true;emitter.emit(event,code,signal)};sigListeners={};signals.forEach(function(sig){sigListeners[sig]=function listener(){if(!processOk(global.process)){return}var listeners=process6.listeners(sig);if(listeners.length===emitter.count){unload();emit("exit",null,sig);emit("afterexit",null,sig);if(isWin&&sig==="SIGHUP"){sig="SIGINT"}process6.kill(process6.pid,sig)}}});module2.exports.signals=function(){return signals};loaded=false;load2=function load3(){if(loaded||!processOk(global.process)){return}loaded=true;emitter.count+=1;signals=signals.filter(function(sig){try{process6.on(sig,sigListeners[sig]);return true}catch(er){return false}});process6.emit=processEmit;process6.reallyExit=processReallyExit};module2.exports.load=load2;originalProcessReallyExit=process6.reallyExit;processReallyExit=function processReallyExit2(code){if(!processOk(global.process)){return}process6.exitCode=code||0;emit("exit",process6.exitCode,null);emit("afterexit",process6.exitCode,null);originalProcessReallyExit.call(process6,process6.exitCode)};originalProcessEmit=process6.emit;processEmit=function processEmit2(ev,arg){if(ev==="exit"&&processOk(global.process)){if(arg!==void 0){process6.exitCode=arg}var ret=originalProcessEmit.apply(this,arguments);emit("exit",process6.exitCode,null);emit("afterexit",process6.exitCode,null);return ret}else{return originalProcessEmit.apply(this,arguments)}}}var assert2;var signals;var isWin;var EE;var emitter;var unload;var emit;var sigListeners;var loaded;var load2;var originalProcessReallyExit;var processReallyExit;var originalProcessEmit;var processEmit}});var require_kill=__commonJS({"node_modules/execa/lib/kill.js"(exports2,module2){"use strict";var os7=require("os");var onExit=require_signal_exit();var DEFAULT_FORCE_KILL_TIMEOUT=1e3*5;var spawnedKill=(kill,signal="SIGTERM",options={})=>{const killResult=kill(signal);setKillTimeout(kill,signal,options,killResult);return killResult};var setKillTimeout=(kill,signal,options,killResult)=>{if(!shouldForceKill(signal,options,killResult)){return}const timeout=getForceKillAfterTimeout(options);const t=setTimeout(()=>{kill("SIGKILL")},timeout);if(t.unref){t.unref()}};var shouldForceKill=(signal,{forceKillAfterTimeout},killResult)=>{return isSigterm(signal)&&forceKillAfterTimeout!==false&&killResult};var isSigterm=signal=>{return signal===os7.constants.signals.SIGTERM||typeof signal==="string"&&signal.toUpperCase()==="SIGTERM"};var getForceKillAfterTimeout=({forceKillAfterTimeout=true})=>{if(forceKillAfterTimeout===true){return DEFAULT_FORCE_KILL_TIMEOUT}if(!Number.isFinite(forceKillAfterTimeout)||forceKillAfterTimeout<0){throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`)}return forceKillAfterTimeout};var spawnedCancel=(spawned,context)=>{const killResult=spawned.kill();if(killResult){context.isCanceled=true}};var timeoutKill=(spawned,signal,reject2)=>{spawned.kill(signal);reject2(Object.assign(new Error("Timed out"),{timedOut:true,signal}))};var setupTimeout=(spawned,{timeout,killSignal="SIGTERM"},spawnedPromise)=>{if(timeout===0||timeout===void 0){return spawnedPromise}let timeoutId;const timeoutPromise=new Promise((resolve,reject2)=>{timeoutId=setTimeout(()=>{timeoutKill(spawned,killSignal,reject2)},timeout)});const safeSpawnedPromise=spawnedPromise.finally(()=>{clearTimeout(timeoutId)});return Promise.race([timeoutPromise,safeSpawnedPromise])};var validateTimeout=({timeout})=>{if(timeout!==void 0&&(!Number.isFinite(timeout)||timeout<0)){throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`)}};var setExitHandler=async(spawned,{cleanup,detached},timedPromise)=>{if(!cleanup||detached){return timedPromise}const removeExitHandler=onExit(()=>{spawned.kill()});return timedPromise.finally(()=>{removeExitHandler()})};module2.exports={spawnedKill,spawnedCancel,setupTimeout,validateTimeout,setExitHandler}}});var require_is_stream=__commonJS({"node_modules/is-stream/index.js"(exports2,module2){"use strict";var isStream=stream3=>stream3!==null&&typeof stream3==="object"&&typeof stream3.pipe==="function";isStream.writable=stream3=>isStream(stream3)&&stream3.writable!==false&&typeof stream3._write==="function"&&typeof stream3._writableState==="object";isStream.readable=stream3=>isStream(stream3)&&stream3.readable!==false&&typeof stream3._read==="function"&&typeof stream3._readableState==="object";isStream.duplex=stream3=>isStream.writable(stream3)&&isStream.readable(stream3);isStream.transform=stream3=>isStream.duplex(stream3)&&typeof stream3._transform==="function";module2.exports=isStream}});var require_merge_stream=__commonJS({"node_modules/merge-stream/index.js"(exports2,module2){"use strict";var{PassThrough}=require("stream");module2.exports=function(){var sources=[];var output=new PassThrough({objectMode:true});output.setMaxListeners(0);output.add=add2;output.isEmpty=isEmpty2;output.on("unpipe",remove2);Array.prototype.slice.call(arguments).forEach(add2);return output;function add2(source){if(Array.isArray(source)){source.forEach(add2);return this}sources.push(source);source.once("end",remove2.bind(null,source));source.once("error",output.emit.bind(output,"error"));source.pipe(output,{end:false});return this}function isEmpty2(){return sources.length==0}function remove2(source){sources=sources.filter(function(it){return it!==source});if(!sources.length&&output.readable){output.end()}}}}});var require_stream=__commonJS({"node_modules/execa/lib/stream.js"(exports2,module2){"use strict";var isStream=require_is_stream();var getStream3=require_get_stream();var mergeStream=require_merge_stream();var handleInput=(spawned,input)=>{if(input===void 0||spawned.stdin===void 0){return}if(isStream(input)){input.pipe(spawned.stdin)}else{spawned.stdin.end(input)}};var makeAllStream=(spawned,{all:all2})=>{if(!all2||!spawned.stdout&&!spawned.stderr){return}const mixed=mergeStream();if(spawned.stdout){mixed.add(spawned.stdout)}if(spawned.stderr){mixed.add(spawned.stderr)}return mixed};var getBufferedData=async(stream3,streamPromise)=>{if(!stream3){return}stream3.destroy();try{return await streamPromise}catch(error){return error.bufferedData}};var getStreamPromise=(stream3,{encoding,buffer,maxBuffer})=>{if(!stream3||!buffer){return}if(encoding){return getStream3(stream3,{encoding,maxBuffer})}return getStream3.buffer(stream3,{maxBuffer})};var getSpawnedResult=async({stdout,stderr,all:all2},{encoding,buffer,maxBuffer},processDone)=>{const stdoutPromise=getStreamPromise(stdout,{encoding,buffer,maxBuffer});const stderrPromise=getStreamPromise(stderr,{encoding,buffer,maxBuffer});const allPromise=getStreamPromise(all2,{encoding,buffer,maxBuffer:maxBuffer*2});try{return await Promise.all([processDone,stdoutPromise,stderrPromise,allPromise])}catch(error){return Promise.all([{error,signal:error.signal,timedOut:error.timedOut},getBufferedData(stdout,stdoutPromise),getBufferedData(stderr,stderrPromise),getBufferedData(all2,allPromise)])}};var validateInputSync=({input})=>{if(isStream(input)){throw new TypeError("The `input` option cannot be a stream in sync mode")}};module2.exports={handleInput,makeAllStream,getSpawnedResult,validateInputSync}}});var require_promise=__commonJS({"node_modules/execa/lib/promise.js"(exports2,module2){"use strict";var nativePromisePrototype=(async()=>{})().constructor.prototype;var descriptors=["then","catch","finally"].map(property2=>[property2,Reflect.getOwnPropertyDescriptor(nativePromisePrototype,property2)]);var mergePromise=(spawned,promise)=>{for(const[property2,descriptor]of descriptors){const value=typeof promise==="function"?(...args2)=>Reflect.apply(descriptor.value,promise(),args2):descriptor.value.bind(promise);Reflect.defineProperty(spawned,property2,{...descriptor,value})}return spawned};var getSpawnedPromise=spawned=>{return new Promise((resolve,reject2)=>{spawned.on("exit",(exitCode,signal)=>{resolve({exitCode,signal})});spawned.on("error",error=>{reject2(error)});if(spawned.stdin){spawned.stdin.on("error",error=>{reject2(error)})}})};module2.exports={mergePromise,getSpawnedPromise}}});var require_command=__commonJS({"node_modules/execa/lib/command.js"(exports2,module2){"use strict";var normalizeArgs=(file,args2=[])=>{if(!Array.isArray(args2)){return[file]}return[file,...args2]};var NO_ESCAPE_REGEXP=/^[\w.-]+$/;var DOUBLE_QUOTES_REGEXP=/"/g;var escapeArg=arg=>{if(typeof arg!=="string"||NO_ESCAPE_REGEXP.test(arg)){return arg}return`"${arg.replace(DOUBLE_QUOTES_REGEXP,'\\"')}"`};var joinCommand=(file,args2)=>{return normalizeArgs(file,args2).join(" ")};var getEscapedCommand=(file,args2)=>{return normalizeArgs(file,args2).map(arg=>escapeArg(arg)).join(" ")};var SPACES_REGEXP=/ +/g;var parseCommand=command=>{const tokens=[];for(const token2 of command.trim().split(SPACES_REGEXP)){const previousToken=tokens[tokens.length-1];if(previousToken&&previousToken.endsWith("\\")){tokens[tokens.length-1]=`${previousToken.slice(0,-1)} ${token2}`}else{tokens.push(token2)}}return tokens};module2.exports={joinCommand,getEscapedCommand,parseCommand}}});var require_execa=__commonJS({"node_modules/execa/index.js"(exports2,module2){"use strict";var path23=require("path");var childProcess=require("child_process");var crossSpawn=require_cross_spawn();var stripFinalNewline=require_strip_final_newline();var npmRunPath=require_npm_run_path();var onetime=require_onetime();var makeError=require_error();var normalizeStdio=require_stdio();var{spawnedKill,spawnedCancel,setupTimeout,validateTimeout,setExitHandler}=require_kill();var{handleInput,getSpawnedResult,makeAllStream,validateInputSync}=require_stream();var{mergePromise,getSpawnedPromise}=require_promise();var{joinCommand,parseCommand,getEscapedCommand}=require_command();var DEFAULT_MAX_BUFFER=1e3*1e3*100;var getEnv=({env:envOption,extendEnv,preferLocal,localDir,execPath})=>{const env2=extendEnv?{...process.env,...envOption}:envOption;if(preferLocal){return npmRunPath.env({env:env2,cwd:localDir,execPath})}return env2};var handleArguments=(file,args2,options={})=>{const parsed=crossSpawn._parse(file,args2,options);file=parsed.command;args2=parsed.args;options=parsed.options;options={maxBuffer:DEFAULT_MAX_BUFFER,buffer:true,stripFinalNewline:true,extendEnv:true,preferLocal:false,localDir:options.cwd||process.cwd(),execPath:process.execPath,encoding:"utf8",reject:true,cleanup:true,all:false,windowsHide:true,...options};options.env=getEnv(options);options.stdio=normalizeStdio(options);if(process.platform==="win32"&&path23.basename(file,".exe")==="cmd"){args2.unshift("/q")}return{file,args:args2,options,parsed}};var handleOutput=(options,value,error)=>{if(typeof value!=="string"&&!Buffer.isBuffer(value)){return error===void 0?void 0:""}if(options.stripFinalNewline){return stripFinalNewline(value)}return value};var execa2=(file,args2,options)=>{const parsed=handleArguments(file,args2,options);const command=joinCommand(file,args2);const escapedCommand=getEscapedCommand(file,args2);validateTimeout(parsed.options);let spawned;try{spawned=childProcess.spawn(parsed.file,parsed.args,parsed.options)}catch(error){const dummySpawned=new childProcess.ChildProcess;const errorPromise=Promise.reject(makeError({error,stdout:"",stderr:"",all:"",command,escapedCommand,parsed,timedOut:false,isCanceled:false,killed:false}));return mergePromise(dummySpawned,errorPromise)}const spawnedPromise=getSpawnedPromise(spawned);const timedPromise=setupTimeout(spawned,parsed.options,spawnedPromise);const processDone=setExitHandler(spawned,parsed.options,timedPromise);const context={isCanceled:false};spawned.kill=spawnedKill.bind(null,spawned.kill.bind(spawned));spawned.cancel=spawnedCancel.bind(null,spawned,context);const handlePromise=async()=>{const[{error,exitCode,signal,timedOut:timedOut2},stdoutResult,stderrResult,allResult]=await getSpawnedResult(spawned,parsed.options,processDone);const stdout=handleOutput(parsed.options,stdoutResult);const stderr=handleOutput(parsed.options,stderrResult);const all2=handleOutput(parsed.options,allResult);if(error||exitCode!==0||signal!==null){const returnedError=makeError({error,exitCode,signal,stdout,stderr,all:all2,command,escapedCommand,parsed,timedOut:timedOut2,isCanceled:context.isCanceled,killed:spawned.killed});if(!parsed.options.reject){return returnedError}throw returnedError}return{command,escapedCommand,exitCode:0,stdout,stderr,all:all2,failed:false,timedOut:false,isCanceled:false,killed:false}};const handlePromiseOnce=onetime(handlePromise);handleInput(spawned,parsed.options.input);spawned.all=makeAllStream(spawned,parsed.options);return mergePromise(spawned,handlePromiseOnce)};module2.exports=execa2;module2.exports.sync=(file,args2,options)=>{const parsed=handleArguments(file,args2,options);const command=joinCommand(file,args2);const escapedCommand=getEscapedCommand(file,args2);validateInputSync(parsed.options);let result2;try{result2=childProcess.spawnSync(parsed.file,parsed.args,parsed.options)}catch(error){throw makeError({error,stdout:"",stderr:"",all:"",command,escapedCommand,parsed,timedOut:false,isCanceled:false,killed:false})}const stdout=handleOutput(parsed.options,result2.stdout,result2.error);const stderr=handleOutput(parsed.options,result2.stderr,result2.error);if(result2.error||result2.status!==0||result2.signal!==null){const error=makeError({stdout,stderr,error:result2.error,signal:result2.signal,exitCode:result2.status,command,escapedCommand,parsed,timedOut:result2.error&&result2.error.code==="ETIMEDOUT",isCanceled:false,killed:result2.signal!==null});if(!parsed.options.reject){return error}throw error}return{command,escapedCommand,exitCode:0,stdout,stderr,failed:false,timedOut:false,isCanceled:false,killed:false}};module2.exports.command=(command,options)=>{const[file,...args2]=parseCommand(command);return execa2(file,args2,options)};module2.exports.commandSync=(command,options)=>{const[file,...args2]=parseCommand(command);return execa2.sync(file,args2,options)};module2.exports.node=(scriptPath,args2,options={})=>{if(args2&&!Array.isArray(args2)&&typeof args2==="object"){options=args2;args2=[]}const stdio=normalizeStdio.node(options);const defaultExecArgv=process.execArgv.filter(arg=>!arg.startsWith("--inspect"));const{nodePath=process.execPath,nodeOptions=defaultExecArgv}=options;return execa2(nodePath,[...nodeOptions,scriptPath,...Array.isArray(args2)?args2:[]],{...options,stdin:void 0,stdout:void 0,stderr:void 0,stdio,shell:false})}}});var require_universalify=__commonJS({"node_modules/universalify/index.js"(exports2){"use strict";exports2.fromCallback=function(fn2){return Object.defineProperty(function(...args2){if(typeof args2[args2.length-1]==="function")fn2.apply(this,args2);else{return new Promise((resolve,reject2)=>{fn2.call(this,...args2,(err,res)=>err!=null?reject2(err):resolve(res))})}},"name",{value:fn2.name})};exports2.fromPromise=function(fn2){return Object.defineProperty(function(...args2){const cb=args2[args2.length-1];if(typeof cb!=="function")return fn2.apply(this,args2);else fn2.apply(this,args2.slice(0,-1)).then(r=>cb(null,r),cb)},"name",{value:fn2.name})}}});var require_polyfills=__commonJS({"node_modules/graceful-fs/polyfills.js"(exports2,module2){var constants3=require("constants");var origCwd=process.cwd;var cwd=null;var platform=process.env.GRACEFUL_FS_PLATFORM||process.platform;process.cwd=function(){if(!cwd)cwd=origCwd.call(process);return cwd};try{process.cwd()}catch(er){}if(typeof process.chdir==="function"){chdir=process.chdir;process.chdir=function(d){cwd=null;chdir.call(process,d)};if(Object.setPrototypeOf)Object.setPrototypeOf(process.chdir,chdir)}var chdir;module2.exports=patch;function patch(fs11){if(constants3.hasOwnProperty("O_SYMLINK")&&process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)){patchLchmod(fs11)}if(!fs11.lutimes){patchLutimes(fs11)}fs11.chown=chownFix(fs11.chown);fs11.fchown=chownFix(fs11.fchown);fs11.lchown=chownFix(fs11.lchown);fs11.chmod=chmodFix(fs11.chmod);fs11.fchmod=chmodFix(fs11.fchmod);fs11.lchmod=chmodFix(fs11.lchmod);fs11.chownSync=chownFixSync(fs11.chownSync);fs11.fchownSync=chownFixSync(fs11.fchownSync);fs11.lchownSync=chownFixSync(fs11.lchownSync);fs11.chmodSync=chmodFixSync(fs11.chmodSync);fs11.fchmodSync=chmodFixSync(fs11.fchmodSync);fs11.lchmodSync=chmodFixSync(fs11.lchmodSync);fs11.stat=statFix(fs11.stat);fs11.fstat=statFix(fs11.fstat);fs11.lstat=statFix(fs11.lstat);fs11.statSync=statFixSync(fs11.statSync);fs11.fstatSync=statFixSync(fs11.fstatSync);fs11.lstatSync=statFixSync(fs11.lstatSync);if(fs11.chmod&&!fs11.lchmod){fs11.lchmod=function(path23,mode,cb){if(cb)process.nextTick(cb)};fs11.lchmodSync=function(){}}if(fs11.chown&&!fs11.lchown){fs11.lchown=function(path23,uid,gid,cb){if(cb)process.nextTick(cb)};fs11.lchownSync=function(){}}if(platform==="win32"){fs11.rename=typeof fs11.rename!=="function"?fs11.rename:function(fs$rename){function rename3(from,to,cb){var start=Date.now();var backoff=0;fs$rename(from,to,function CB(er){if(er&&(er.code==="EACCES"||er.code==="EPERM"||er.code==="EBUSY")&&Date.now()-start<6e4){setTimeout(function(){fs11.stat(to,function(stater,st){if(stater&&stater.code==="ENOENT")fs$rename(from,to,CB);else cb(er)})},backoff);if(backoff<100)backoff+=10;return}if(cb)cb(er)})}if(Object.setPrototypeOf)Object.setPrototypeOf(rename3,fs$rename);return rename3}(fs11.rename)}fs11.read=typeof fs11.read!=="function"?fs11.read:function(fs$read){function read2(fd,buffer,offset,length,position,callback_){var callback;if(callback_&&typeof callback_==="function"){var eagCounter=0;callback=function(er,_,__){if(er&&er.code==="EAGAIN"&&eagCounter<10){eagCounter++;return fs$read.call(fs11,fd,buffer,offset,length,position,callback)}callback_.apply(this,arguments)}}return fs$read.call(fs11,fd,buffer,offset,length,position,callback)}if(Object.setPrototypeOf)Object.setPrototypeOf(read2,fs$read);return read2}(fs11.read);fs11.readSync=typeof fs11.readSync!=="function"?fs11.readSync:function(fs$readSync){return function(fd,buffer,offset,length,position){var eagCounter=0;while(true){try{return fs$readSync.call(fs11,fd,buffer,offset,length,position)}catch(er){if(er.code==="EAGAIN"&&eagCounter<10){eagCounter++;continue}throw er}}}}(fs11.readSync);function patchLchmod(fs12){fs12.lchmod=function(path23,mode,callback){fs12.open(path23,constants3.O_WRONLY|constants3.O_SYMLINK,mode,function(err,fd){if(err){if(callback)callback(err);return}fs12.fchmod(fd,mode,function(err2){fs12.close(fd,function(err22){if(callback)callback(err2||err22)})})})};fs12.lchmodSync=function(path23,mode){var fd=fs12.openSync(path23,constants3.O_WRONLY|constants3.O_SYMLINK,mode);var threw=true;var ret;try{ret=fs12.fchmodSync(fd,mode);threw=false}finally{if(threw){try{fs12.closeSync(fd)}catch(er){}}else{fs12.closeSync(fd)}}return ret}}function patchLutimes(fs12){if(constants3.hasOwnProperty("O_SYMLINK")&&fs12.futimes){fs12.lutimes=function(path23,at2,mt,cb){fs12.open(path23,constants3.O_SYMLINK,function(er,fd){if(er){if(cb)cb(er);return}fs12.futimes(fd,at2,mt,function(er2){fs12.close(fd,function(er22){if(cb)cb(er2||er22)})})})};fs12.lutimesSync=function(path23,at2,mt){var fd=fs12.openSync(path23,constants3.O_SYMLINK);var ret;var threw=true;try{ret=fs12.futimesSync(fd,at2,mt);threw=false}finally{if(threw){try{fs12.closeSync(fd)}catch(er){}}else{fs12.closeSync(fd)}}return ret}}else if(fs12.futimes){fs12.lutimes=function(_a2,_b,_c,cb){if(cb)process.nextTick(cb)};fs12.lutimesSync=function(){}}}function chmodFix(orig){if(!orig)return orig;return function(target,mode,cb){return orig.call(fs11,target,mode,function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)})}}function chmodFixSync(orig){if(!orig)return orig;return function(target,mode){try{return orig.call(fs11,target,mode)}catch(er){if(!chownErOk(er))throw er}}}function chownFix(orig){if(!orig)return orig;return function(target,uid,gid,cb){return orig.call(fs11,target,uid,gid,function(er){if(chownErOk(er))er=null;if(cb)cb.apply(this,arguments)})}}function chownFixSync(orig){if(!orig)return orig;return function(target,uid,gid){try{return orig.call(fs11,target,uid,gid)}catch(er){if(!chownErOk(er))throw er}}}function statFix(orig){if(!orig)return orig;return function(target,options,cb){if(typeof options==="function"){cb=options;options=null}function callback(er,stats){if(stats){if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296}if(cb)cb.apply(this,arguments)}return options?orig.call(fs11,target,options,callback):orig.call(fs11,target,callback)}}function statFixSync(orig){if(!orig)return orig;return function(target,options){var stats=options?orig.call(fs11,target,options):orig.call(fs11,target);if(stats){if(stats.uid<0)stats.uid+=4294967296;if(stats.gid<0)stats.gid+=4294967296}return stats}}function chownErOk(er){if(!er)return true;if(er.code==="ENOSYS")return true;var nonroot=!process.getuid||process.getuid()!==0;if(nonroot){if(er.code==="EINVAL"||er.code==="EPERM")return true}return false}}}});var require_legacy_streams=__commonJS({"node_modules/graceful-fs/legacy-streams.js"(exports2,module2){var Stream=require("stream").Stream;module2.exports=legacy;function legacy(fs11){return{ReadStream,WriteStream};function ReadStream(path23,options){if(!(this instanceof ReadStream))return new ReadStream(path23,options);Stream.call(this);var self2=this;this.path=path23;this.fd=null;this.readable=true;this.paused=false;this.flags="r";this.mode=438;this.bufferSize=64*1024;options=options||{};var keys2=Object.keys(options);for(var index=0,length=keys2.length;index<length;index++){var key=keys2[index];this[key]=options[key]}if(this.encoding)this.setEncoding(this.encoding);if(this.start!==void 0){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.end===void 0){this.end=Infinity}else if("number"!==typeof this.end){throw TypeError("end must be a Number")}if(this.start>this.end){throw new Error("start must be <= end")}this.pos=this.start}if(this.fd!==null){process.nextTick(function(){self2._read()});return}fs11.open(this.path,this.flags,this.mode,function(err,fd){if(err){self2.emit("error",err);self2.readable=false;return}self2.fd=fd;self2.emit("open",fd);self2._read()})}function WriteStream(path23,options){if(!(this instanceof WriteStream))return new WriteStream(path23,options);Stream.call(this);this.path=path23;this.fd=null;this.writable=true;this.flags="w";this.encoding="binary";this.mode=438;this.bytesWritten=0;options=options||{};var keys2=Object.keys(options);for(var index=0,length=keys2.length;index<length;index++){var key=keys2[index];this[key]=options[key]}if(this.start!==void 0){if("number"!==typeof this.start){throw TypeError("start must be a Number")}if(this.start<0){throw new Error("start must be >= zero")}this.pos=this.start}this.busy=false;this._queue=[];if(this.fd===null){this._open=fs11.open;this._queue.push([this._open,this.path,this.flags,this.mode,void 0]);this.flush()}}}}});var require_clone=__commonJS({"node_modules/graceful-fs/clone.js"(exports2,module2){"use strict";module2.exports=clone2;var getPrototypeOf=Object.getPrototypeOf||function(obj){return obj.__proto__};function clone2(obj){if(obj===null||typeof obj!=="object")return obj;if(obj instanceof Object)var copy={__proto__:getPrototypeOf(obj)};else var copy=Object.create(null);Object.getOwnPropertyNames(obj).forEach(function(key){Object.defineProperty(copy,key,Object.getOwnPropertyDescriptor(obj,key))});return copy}}});var require_graceful_fs=__commonJS({"node_modules/graceful-fs/graceful-fs.js"(exports2,module2){var fs11=require("fs");var polyfills=require_polyfills();var legacy=require_legacy_streams();var clone2=require_clone();var util4=require("util");var gracefulQueue;var previousSymbol;if(typeof Symbol==="function"&&typeof Symbol.for==="function"){gracefulQueue=Symbol.for("graceful-fs.queue");previousSymbol=Symbol.for("graceful-fs.previous")}else{gracefulQueue="___graceful-fs.queue";previousSymbol="___graceful-fs.previous"}function noop4(){}function publishQueue(context,queue2){Object.defineProperty(context,gracefulQueue,{get:function(){return queue2}})}var debug=noop4;if(util4.debuglog)debug=util4.debuglog("gfs4");else if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||""))debug=function(){var m=util4.format.apply(util4,arguments);m="GFS4: "+m.split(/\n/).join("\nGFS4: ");console.error(m)};if(!fs11[gracefulQueue]){queue=global[gracefulQueue]||[];publishQueue(fs11,queue);fs11.close=function(fs$close){function close(fd,cb){return fs$close.call(fs11,fd,function(err){if(!err){resetQueue()}if(typeof cb==="function")cb.apply(this,arguments)})}Object.defineProperty(close,previousSymbol,{value:fs$close});return close}(fs11.close);fs11.closeSync=function(fs$closeSync){function closeSync(fd){fs$closeSync.apply(fs11,arguments);resetQueue()}Object.defineProperty(closeSync,previousSymbol,{value:fs$closeSync});return closeSync}(fs11.closeSync);if(/\bgfs4\b/i.test(process.env.NODE_DEBUG||"")){process.on("exit",function(){debug(fs11[gracefulQueue]);require("assert").equal(fs11[gracefulQueue].length,0)})}}var queue;if(!global[gracefulQueue]){publishQueue(global,fs11[gracefulQueue])}module2.exports=patch(clone2(fs11));if(process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH&&!fs11.__patched){module2.exports=patch(fs11);fs11.__patched=true}function patch(fs12){polyfills(fs12);fs12.gracefulify=patch;fs12.createReadStream=createReadStream2;fs12.createWriteStream=createWriteStream2;var fs$readFile=fs12.readFile;fs12.readFile=readFile4;function readFile4(path23,options,cb){if(typeof options==="function")cb=options,options=null;return go$readFile(path23,options,cb);function go$readFile(path24,options2,cb2,startTime){return fs$readFile(path24,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readFile,[path24,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$writeFile=fs12.writeFile;fs12.writeFile=writeFile3;function writeFile3(path23,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$writeFile(path23,data,options,cb);function go$writeFile(path24,data2,options2,cb2,startTime){return fs$writeFile(path24,data2,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$writeFile,[path24,data2,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$appendFile=fs12.appendFile;if(fs$appendFile)fs12.appendFile=appendFile;function appendFile(path23,data,options,cb){if(typeof options==="function")cb=options,options=null;return go$appendFile(path23,data,options,cb);function go$appendFile(path24,data2,options2,cb2,startTime){return fs$appendFile(path24,data2,options2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$appendFile,[path24,data2,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$copyFile=fs12.copyFile;if(fs$copyFile)fs12.copyFile=copyFile;function copyFile(src,dest,flags,cb){if(typeof flags==="function"){cb=flags;flags=0}return go$copyFile(src,dest,flags,cb);function go$copyFile(src2,dest2,flags2,cb2,startTime){return fs$copyFile(src2,dest2,flags2,function(err){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$copyFile,[src2,dest2,flags2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}var fs$readdir=fs12.readdir;fs12.readdir=readdir2;var noReaddirOptionVersions=/^v[0-5]\./;function readdir2(path23,options,cb){if(typeof options==="function")cb=options,options=null;var go$readdir=noReaddirOptionVersions.test(process.version)?function go$readdir2(path24,options2,cb2,startTime){return fs$readdir(path24,fs$readdirCallback(path24,options2,cb2,startTime))}:function go$readdir2(path24,options2,cb2,startTime){return fs$readdir(path24,options2,fs$readdirCallback(path24,options2,cb2,startTime))};return go$readdir(path23,options,cb);function fs$readdirCallback(path24,options2,cb2,startTime){return function(err,files){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$readdir,[path24,options2,cb2],err,startTime||Date.now(),Date.now()]);else{if(files&&files.sort)files.sort();if(typeof cb2==="function")cb2.call(this,err,files)}}}}if(process.version.substr(0,4)==="v0.8"){var legStreams=legacy(fs12);ReadStream=legStreams.ReadStream;WriteStream=legStreams.WriteStream}var fs$ReadStream=fs12.ReadStream;if(fs$ReadStream){ReadStream.prototype=Object.create(fs$ReadStream.prototype);ReadStream.prototype.open=ReadStream$open}var fs$WriteStream=fs12.WriteStream;if(fs$WriteStream){WriteStream.prototype=Object.create(fs$WriteStream.prototype);WriteStream.prototype.open=WriteStream$open}Object.defineProperty(fs12,"ReadStream",{get:function(){return ReadStream},set:function(val){ReadStream=val},enumerable:true,configurable:true});Object.defineProperty(fs12,"WriteStream",{get:function(){return WriteStream},set:function(val){WriteStream=val},enumerable:true,configurable:true});var FileReadStream=ReadStream;Object.defineProperty(fs12,"FileReadStream",{get:function(){return FileReadStream},set:function(val){FileReadStream=val},enumerable:true,configurable:true});var FileWriteStream=WriteStream;Object.defineProperty(fs12,"FileWriteStream",{get:function(){return FileWriteStream},set:function(val){FileWriteStream=val},enumerable:true,configurable:true});function ReadStream(path23,options){if(this instanceof ReadStream)return fs$ReadStream.apply(this,arguments),this;else return ReadStream.apply(Object.create(ReadStream.prototype),arguments)}function ReadStream$open(){var that=this;open4(that.path,that.flags,that.mode,function(err,fd){if(err){if(that.autoClose)that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd);that.read()}})}function WriteStream(path23,options){if(this instanceof WriteStream)return fs$WriteStream.apply(this,arguments),this;else return WriteStream.apply(Object.create(WriteStream.prototype),arguments)}function WriteStream$open(){var that=this;open4(that.path,that.flags,that.mode,function(err,fd){if(err){that.destroy();that.emit("error",err)}else{that.fd=fd;that.emit("open",fd)}})}function createReadStream2(path23,options){return new fs12.ReadStream(path23,options)}function createWriteStream2(path23,options){return new fs12.WriteStream(path23,options)}var fs$open=fs12.open;fs12.open=open4;function open4(path23,flags,mode,cb){if(typeof mode==="function")cb=mode,mode=null;return go$open(path23,flags,mode,cb);function go$open(path24,flags2,mode2,cb2,startTime){return fs$open(path24,flags2,mode2,function(err,fd){if(err&&(err.code==="EMFILE"||err.code==="ENFILE"))enqueue([go$open,[path24,flags2,mode2,cb2],err,startTime||Date.now(),Date.now()]);else{if(typeof cb2==="function")cb2.apply(this,arguments)}})}}return fs12}function enqueue(elem){debug("ENQUEUE",elem[0].name,elem[1]);fs11[gracefulQueue].push(elem);retry()}var retryTimer;function resetQueue(){var now3=Date.now();for(var i=0;i<fs11[gracefulQueue].length;++i){if(fs11[gracefulQueue][i].length>2){fs11[gracefulQueue][i][3]=now3;fs11[gracefulQueue][i][4]=now3}}retry()}function retry(){clearTimeout(retryTimer);retryTimer=void 0;if(fs11[gracefulQueue].length===0)return;var elem=fs11[gracefulQueue].shift();var fn2=elem[0];var args2=elem[1];var err=elem[2];var startTime=elem[3];var lastTime=elem[4];if(startTime===void 0){debug("RETRY",fn2.name,args2);fn2.apply(null,args2)}else if(Date.now()-startTime>=6e4){debug("TIMEOUT",fn2.name,args2);var cb=args2.pop();if(typeof cb==="function")cb.call(null,err)}else{var sinceAttempt=Date.now()-lastTime;var sinceStart=Math.max(lastTime-startTime,1);var desiredDelay=Math.min(sinceStart*1.2,100);if(sinceAttempt>=desiredDelay){debug("RETRY",fn2.name,args2);fn2.apply(null,args2.concat([startTime]))}else{fs11[gracefulQueue].push(elem)}}if(retryTimer===void 0){retryTimer=setTimeout(retry,0)}}}});var require_fs=__commonJS({"node_modules/fs-extra/lib/fs/index.js"(exports2){"use strict";var u=require_universalify().fromCallback;var fs11=require_graceful_fs();var api=["access","appendFile","chmod","chown","close","copyFile","fchmod","fchown","fdatasync","fstat","fsync","ftruncate","futimes","lchmod","lchown","link","lstat","mkdir","mkdtemp","open","opendir","readdir","readFile","readlink","realpath","rename","rm","rmdir","stat","symlink","truncate","unlink","utimes","writeFile"].filter(key=>{return typeof fs11[key]==="function"});Object.keys(fs11).forEach(key=>{if(key==="promises"){return}exports2[key]=fs11[key]});api.forEach(method2=>{exports2[method2]=u(fs11[method2])});exports2.exists=function(filename,callback){if(typeof callback==="function"){return fs11.exists(filename,callback)}return new Promise(resolve=>{return fs11.exists(filename,resolve)})};exports2.read=function(fd,buffer,offset,length,position,callback){if(typeof callback==="function"){return fs11.read(fd,buffer,offset,length,position,callback)}return new Promise((resolve,reject2)=>{fs11.read(fd,buffer,offset,length,position,(err,bytesRead,buffer2)=>{if(err)return reject2(err);resolve({bytesRead,buffer:buffer2})})})};exports2.write=function(fd,buffer,...args2){if(typeof args2[args2.length-1]==="function"){return fs11.write(fd,buffer,...args2)}return new Promise((resolve,reject2)=>{fs11.write(fd,buffer,...args2,(err,bytesWritten,buffer2)=>{if(err)return reject2(err);resolve({bytesWritten,buffer:buffer2})})})};if(typeof fs11.writev==="function"){exports2.writev=function(fd,buffers,...args2){if(typeof args2[args2.length-1]==="function"){return fs11.writev(fd,buffers,...args2)}return new Promise((resolve,reject2)=>{fs11.writev(fd,buffers,...args2,(err,bytesWritten,buffers2)=>{if(err)return reject2(err);resolve({bytesWritten,buffers:buffers2})})})}}if(typeof fs11.realpath.native==="function"){exports2.realpath.native=u(fs11.realpath.native)}}});var require_at_least_node=__commonJS({"node_modules/at-least-node/index.js"(exports2,module2){module2.exports=r=>{const n=process.versions.node.split(".").map(x=>parseInt(x,10));r=r.split(".").map(x=>parseInt(x,10));return n[0]>r[0]||n[0]===r[0]&&(n[1]>r[1]||n[1]===r[1]&&n[2]>=r[2])}}});var require_make_dir=__commonJS({"node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports2,module2){"use strict";var fs11=require_fs();var path23=require("path");var atLeastNode=require_at_least_node();var useNativeRecursiveOption=atLeastNode("10.12.0");var checkPath=pth=>{if(process.platform==="win32"){const pathHasInvalidWinCharacters=/[<>:"|?*]/.test(pth.replace(path23.parse(pth).root,""));if(pathHasInvalidWinCharacters){const error=new Error(`Path contains invalid characters: ${pth}`);error.code="EINVAL";throw error}}};var processOptions=options=>{const defaults3={mode:511};if(typeof options==="number")options={mode:options};return{...defaults3,...options}};var permissionError=pth=>{const error=new Error(`operation not permitted, mkdir '${pth}'`);error.code="EPERM";error.errno=-4048;error.path=pth;error.syscall="mkdir";return error};module2.exports.makeDir=async(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path23.resolve(input);return fs11.mkdir(pth,{mode:options.mode,recursive:true})}const make=async pth=>{try{await fs11.mkdir(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path23.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}await make(path23.dirname(pth));return make(pth)}try{const stats=await fs11.stat(pth);if(!stats.isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path23.resolve(input))};module2.exports.makeDirSync=(input,options)=>{checkPath(input);options=processOptions(options);if(useNativeRecursiveOption){const pth=path23.resolve(input);return fs11.mkdirSync(pth,{mode:options.mode,recursive:true})}const make=pth=>{try{fs11.mkdirSync(pth,options.mode)}catch(error){if(error.code==="EPERM"){throw error}if(error.code==="ENOENT"){if(path23.dirname(pth)===pth){throw permissionError(pth)}if(error.message.includes("null bytes")){throw error}make(path23.dirname(pth));return make(pth)}try{if(!fs11.statSync(pth).isDirectory()){throw new Error("The path is not a directory")}}catch{throw error}}};return make(path23.resolve(input))}}});var require_mkdirs=__commonJS({"node_modules/fs-extra/lib/mkdirs/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var{makeDir:_makeDir,makeDirSync}=require_make_dir();var makeDir=u(_makeDir);module2.exports={mkdirs:makeDir,mkdirsSync:makeDirSync,mkdirp:makeDir,mkdirpSync:makeDirSync,ensureDir:makeDir,ensureDirSync:makeDirSync}}});var require_utimes=__commonJS({"node_modules/fs-extra/lib/util/utimes.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();function utimesMillis(path23,atime,mtime,callback){fs11.open(path23,"r+",(err,fd)=>{if(err)return callback(err);fs11.futimes(fd,atime,mtime,futimesErr=>{fs11.close(fd,closeErr=>{if(callback)callback(futimesErr||closeErr)})})})}function utimesMillisSync(path23,atime,mtime){const fd=fs11.openSync(path23,"r+");fs11.futimesSync(fd,atime,mtime);return fs11.closeSync(fd)}module2.exports={utimesMillis,utimesMillisSync}}});var require_stat=__commonJS({"node_modules/fs-extra/lib/util/stat.js"(exports2,module2){"use strict";var fs11=require_fs();var path23=require("path");var util4=require("util");var atLeastNode=require_at_least_node();var nodeSupportsBigInt=atLeastNode("10.5.0");var stat3=file=>nodeSupportsBigInt?fs11.stat(file,{bigint:true}):fs11.stat(file);var statSync=file=>nodeSupportsBigInt?fs11.statSync(file,{bigint:true}):fs11.statSync(file);function getStats(src,dest){return Promise.all([stat3(src),stat3(dest).catch(err=>{if(err.code==="ENOENT")return null;throw err})]).then(([srcStat,destStat])=>({srcStat,destStat}))}function getStatsSync(src,dest){let destStat;const srcStat=statSync(src);try{destStat=statSync(dest)}catch(err){if(err.code==="ENOENT")return{srcStat,destStat:null};throw err}return{srcStat,destStat}}function checkPaths(src,dest,funcName,cb){util4.callbackify(getStats)(src,dest,(err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;if(destStat&&areIdentical(srcStat,destStat)){return cb(new Error("Source and destination must not be the same."))}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){return cb(new Error(errMsg(src,dest,funcName)))}return cb(null,{srcStat,destStat})})}function checkPathsSync(src,dest,funcName){const{srcStat,destStat}=getStatsSync(src,dest);if(destStat&&areIdentical(srcStat,destStat)){throw new Error("Source and destination must not be the same.")}if(srcStat.isDirectory()&&isSrcSubdir(src,dest)){throw new Error(errMsg(src,dest,funcName))}return{srcStat,destStat}}function checkParentPaths(src,srcStat,dest,funcName,cb){const srcParent=path23.resolve(path23.dirname(src));const destParent=path23.resolve(path23.dirname(dest));if(destParent===srcParent||destParent===path23.parse(destParent).root)return cb();const callback=(err,destStat)=>{if(err){if(err.code==="ENOENT")return cb();return cb(err)}if(areIdentical(srcStat,destStat)){return cb(new Error(errMsg(src,dest,funcName)))}return checkParentPaths(src,srcStat,destParent,funcName,cb)};if(nodeSupportsBigInt)fs11.stat(destParent,{bigint:true},callback);else fs11.stat(destParent,callback)}function checkParentPathsSync(src,srcStat,dest,funcName){const srcParent=path23.resolve(path23.dirname(src));const destParent=path23.resolve(path23.dirname(dest));if(destParent===srcParent||destParent===path23.parse(destParent).root)return;let destStat;try{destStat=statSync(destParent)}catch(err){if(err.code==="ENOENT")return;throw err}if(areIdentical(srcStat,destStat)){throw new Error(errMsg(src,dest,funcName))}return checkParentPathsSync(src,srcStat,destParent,funcName)}function areIdentical(srcStat,destStat){if(destStat.ino&&destStat.dev&&destStat.ino===srcStat.ino&&destStat.dev===srcStat.dev){if(nodeSupportsBigInt||destStat.ino<Number.MAX_SAFE_INTEGER){return true}if(destStat.size===srcStat.size&&destStat.mode===srcStat.mode&&destStat.nlink===srcStat.nlink&&destStat.atimeMs===srcStat.atimeMs&&destStat.mtimeMs===srcStat.mtimeMs&&destStat.ctimeMs===srcStat.ctimeMs&&destStat.birthtimeMs===srcStat.birthtimeMs){return true}}return false}function isSrcSubdir(src,dest){const srcArr=path23.resolve(src).split(path23.sep).filter(i=>i);const destArr=path23.resolve(dest).split(path23.sep).filter(i=>i);return srcArr.reduce((acc,cur,i)=>acc&&destArr[i]===cur,true)}function errMsg(src,dest,funcName){return`Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`}module2.exports={checkPaths,checkPathsSync,checkParentPaths,checkParentPathsSync,isSrcSubdir}}});var require_copy_sync=__commonJS({"node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();var path23=require("path");var mkdirsSync=require_mkdirs().mkdirsSync;var utimesMillisSync=require_utimes().utimesMillisSync;var stat3=require_stat();function copySync(src,dest,opts){if(typeof opts==="function"){opts={filter:opts}}opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`)}const{srcStat,destStat}=stat3.checkPathsSync(src,dest,"copy");stat3.checkParentPathsSync(src,srcStat,dest,"copy");return handleFilterAndCopy(destStat,src,dest,opts)}function handleFilterAndCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;const destParent=path23.dirname(dest);if(!fs11.existsSync(destParent))mkdirsSync(destParent);return startCopy(destStat,src,dest,opts)}function startCopy(destStat,src,dest,opts){if(opts.filter&&!opts.filter(src,dest))return;return getStats(destStat,src,dest,opts)}function getStats(destStat,src,dest,opts){const statSync=opts.dereference?fs11.statSync:fs11.lstatSync;const srcStat=statSync(src);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts)}function onFile(srcStat,destStat,src,dest,opts){if(!destStat)return copyFile(srcStat,src,dest,opts);return mayCopyFile(srcStat,src,dest,opts)}function mayCopyFile(srcStat,src,dest,opts){if(opts.overwrite){fs11.unlinkSync(dest);return copyFile(srcStat,src,dest,opts)}else if(opts.errorOnExist){throw new Error(`'${dest}' already exists`)}}function copyFile(srcStat,src,dest,opts){fs11.copyFileSync(src,dest);if(opts.preserveTimestamps)handleTimestamps(srcStat.mode,src,dest);return setDestMode(dest,srcStat.mode)}function handleTimestamps(srcMode,src,dest){if(fileIsNotWritable(srcMode))makeFileWritable(dest,srcMode);return setDestTimestamps(src,dest)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode){return setDestMode(dest,srcMode|128)}function setDestMode(dest,srcMode){return fs11.chmodSync(dest,srcMode)}function setDestTimestamps(src,dest){const updatedSrcStat=fs11.statSync(src);return utimesMillisSync(dest,updatedSrcStat.atime,updatedSrcStat.mtime)}function onDir(srcStat,destStat,src,dest,opts){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts);if(destStat&&!destStat.isDirectory()){throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`)}return copyDir(src,dest,opts)}function mkDirAndCopy(srcMode,src,dest,opts){fs11.mkdirSync(dest);copyDir(src,dest,opts);return setDestMode(dest,srcMode)}function copyDir(src,dest,opts){fs11.readdirSync(src).forEach(item=>copyDirItem(item,src,dest,opts))}function copyDirItem(item,src,dest,opts){const srcItem=path23.join(src,item);const destItem=path23.join(dest,item);const{destStat}=stat3.checkPathsSync(srcItem,destItem,"copy");return startCopy(destStat,srcItem,destItem,opts)}function onLink(destStat,src,dest,opts){let resolvedSrc=fs11.readlinkSync(src);if(opts.dereference){resolvedSrc=path23.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs11.symlinkSync(resolvedSrc,dest)}else{let resolvedDest;try{resolvedDest=fs11.readlinkSync(dest)}catch(err){if(err.code==="EINVAL"||err.code==="UNKNOWN")return fs11.symlinkSync(resolvedSrc,dest);throw err}if(opts.dereference){resolvedDest=path23.resolve(process.cwd(),resolvedDest)}if(stat3.isSrcSubdir(resolvedSrc,resolvedDest)){throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`)}if(fs11.statSync(dest).isDirectory()&&stat3.isSrcSubdir(resolvedDest,resolvedSrc)){throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`)}return copyLink(resolvedSrc,dest)}}function copyLink(resolvedSrc,dest){fs11.unlinkSync(dest);return fs11.symlinkSync(resolvedSrc,dest)}module2.exports=copySync}});var require_copy_sync2=__commonJS({"node_modules/fs-extra/lib/copy-sync/index.js"(exports2,module2){"use strict";module2.exports={copySync:require_copy_sync()}}});var require_path_exists=__commonJS({"node_modules/fs-extra/lib/path-exists/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var fs11=require_fs();function pathExists(path23){return fs11.access(path23).then(()=>true).catch(()=>false)}module2.exports={pathExists:u(pathExists),pathExistsSync:fs11.existsSync}}});var require_copy=__commonJS({"node_modules/fs-extra/lib/copy/copy.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();var path23=require("path");var mkdirs=require_mkdirs().mkdirs;var pathExists=require_path_exists().pathExists;var utimesMillis=require_utimes().utimesMillis;var stat3=require_stat();function copy(src,dest,opts,cb){if(typeof opts==="function"&&!cb){cb=opts;opts={}}else if(typeof opts==="function"){opts={filter:opts}}cb=cb||function(){};opts=opts||{};opts.clobber="clobber"in opts?!!opts.clobber:true;opts.overwrite="overwrite"in opts?!!opts.overwrite:opts.clobber;if(opts.preserveTimestamps&&process.arch==="ia32"){console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`)}stat3.checkPaths(src,dest,"copy",(err,stats)=>{if(err)return cb(err);const{srcStat,destStat}=stats;stat3.checkParentPaths(src,srcStat,dest,"copy",err2=>{if(err2)return cb(err2);if(opts.filter)return handleFilter(checkParentDir,destStat,src,dest,opts,cb);return checkParentDir(destStat,src,dest,opts,cb)})})}function checkParentDir(destStat,src,dest,opts,cb){const destParent=path23.dirname(dest);pathExists(destParent,(err,dirExists)=>{if(err)return cb(err);if(dirExists)return startCopy(destStat,src,dest,opts,cb);mkdirs(destParent,err2=>{if(err2)return cb(err2);return startCopy(destStat,src,dest,opts,cb)})})}function handleFilter(onInclude,destStat,src,dest,opts,cb){Promise.resolve(opts.filter(src,dest)).then(include=>{if(include)return onInclude(destStat,src,dest,opts,cb);return cb()},error=>cb(error))}function startCopy(destStat,src,dest,opts,cb){if(opts.filter)return handleFilter(getStats,destStat,src,dest,opts,cb);return getStats(destStat,src,dest,opts,cb)}function getStats(destStat,src,dest,opts,cb){const stat4=opts.dereference?fs11.stat:fs11.lstat;stat4(src,(err,srcStat)=>{if(err)return cb(err);if(srcStat.isDirectory())return onDir(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isFile()||srcStat.isCharacterDevice()||srcStat.isBlockDevice())return onFile(srcStat,destStat,src,dest,opts,cb);else if(srcStat.isSymbolicLink())return onLink(destStat,src,dest,opts,cb)})}function onFile(srcStat,destStat,src,dest,opts,cb){if(!destStat)return copyFile(srcStat,src,dest,opts,cb);return mayCopyFile(srcStat,src,dest,opts,cb)}function mayCopyFile(srcStat,src,dest,opts,cb){if(opts.overwrite){fs11.unlink(dest,err=>{if(err)return cb(err);return copyFile(srcStat,src,dest,opts,cb)})}else if(opts.errorOnExist){return cb(new Error(`'${dest}' already exists`))}else return cb()}function copyFile(srcStat,src,dest,opts,cb){fs11.copyFile(src,dest,err=>{if(err)return cb(err);if(opts.preserveTimestamps)return handleTimestampsAndMode(srcStat.mode,src,dest,cb);return setDestMode(dest,srcStat.mode,cb)})}function handleTimestampsAndMode(srcMode,src,dest,cb){if(fileIsNotWritable(srcMode)){return makeFileWritable(dest,srcMode,err=>{if(err)return cb(err);return setDestTimestampsAndMode(srcMode,src,dest,cb)})}return setDestTimestampsAndMode(srcMode,src,dest,cb)}function fileIsNotWritable(srcMode){return(srcMode&128)===0}function makeFileWritable(dest,srcMode,cb){return setDestMode(dest,srcMode|128,cb)}function setDestTimestampsAndMode(srcMode,src,dest,cb){setDestTimestamps(src,dest,err=>{if(err)return cb(err);return setDestMode(dest,srcMode,cb)})}function setDestMode(dest,srcMode,cb){return fs11.chmod(dest,srcMode,cb)}function setDestTimestamps(src,dest,cb){fs11.stat(src,(err,updatedSrcStat)=>{if(err)return cb(err);return utimesMillis(dest,updatedSrcStat.atime,updatedSrcStat.mtime,cb)})}function onDir(srcStat,destStat,src,dest,opts,cb){if(!destStat)return mkDirAndCopy(srcStat.mode,src,dest,opts,cb);if(destStat&&!destStat.isDirectory()){return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`))}return copyDir(src,dest,opts,cb)}function mkDirAndCopy(srcMode,src,dest,opts,cb){fs11.mkdir(dest,err=>{if(err)return cb(err);copyDir(src,dest,opts,err2=>{if(err2)return cb(err2);return setDestMode(dest,srcMode,cb)})})}function copyDir(src,dest,opts,cb){fs11.readdir(src,(err,items)=>{if(err)return cb(err);return copyDirItems(items,src,dest,opts,cb)})}function copyDirItems(items,src,dest,opts,cb){const item=items.pop();if(!item)return cb();return copyDirItem(items,item,src,dest,opts,cb)}function copyDirItem(items,item,src,dest,opts,cb){const srcItem=path23.join(src,item);const destItem=path23.join(dest,item);stat3.checkPaths(srcItem,destItem,"copy",(err,stats)=>{if(err)return cb(err);const{destStat}=stats;startCopy(destStat,srcItem,destItem,opts,err2=>{if(err2)return cb(err2);return copyDirItems(items,src,dest,opts,cb)})})}function onLink(destStat,src,dest,opts,cb){fs11.readlink(src,(err,resolvedSrc)=>{if(err)return cb(err);if(opts.dereference){resolvedSrc=path23.resolve(process.cwd(),resolvedSrc)}if(!destStat){return fs11.symlink(resolvedSrc,dest,cb)}else{fs11.readlink(dest,(err2,resolvedDest)=>{if(err2){if(err2.code==="EINVAL"||err2.code==="UNKNOWN")return fs11.symlink(resolvedSrc,dest,cb);return cb(err2)}if(opts.dereference){resolvedDest=path23.resolve(process.cwd(),resolvedDest)}if(stat3.isSrcSubdir(resolvedSrc,resolvedDest)){return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`))}if(destStat.isDirectory()&&stat3.isSrcSubdir(resolvedDest,resolvedSrc)){return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`))}return copyLink(resolvedSrc,dest,cb)})}})}function copyLink(resolvedSrc,dest,cb){fs11.unlink(dest,err=>{if(err)return cb(err);return fs11.symlink(resolvedSrc,dest,cb)})}module2.exports=copy}});var require_copy2=__commonJS({"node_modules/fs-extra/lib/copy/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;module2.exports={copy:u(require_copy())}}});var require_rimraf=__commonJS({"node_modules/fs-extra/lib/remove/rimraf.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();var path23=require("path");var assert2=require("assert");var isWindows2=process.platform==="win32";function defaults3(options){const methods=["unlink","chmod","stat","lstat","rmdir","readdir"];methods.forEach(m=>{options[m]=options[m]||fs11[m];m=m+"Sync";options[m]=options[m]||fs11[m]});options.maxBusyTries=options.maxBusyTries||3}function rimraf(p,options,cb){let busyTries=0;if(typeof options==="function"){cb=options;options={}}assert2(p,"rimraf: missing path");assert2.strictEqual(typeof p,"string","rimraf: path should be a string");assert2.strictEqual(typeof cb,"function","rimraf: callback function required");assert2(options,"rimraf: invalid options argument provided");assert2.strictEqual(typeof options,"object","rimraf: options should be object");defaults3(options);rimraf_(p,options,function CB(er){if(er){if((er.code==="EBUSY"||er.code==="ENOTEMPTY"||er.code==="EPERM")&&busyTries<options.maxBusyTries){busyTries++;const time=busyTries*100;return setTimeout(()=>rimraf_(p,options,CB),time)}if(er.code==="ENOENT")er=null}cb(er)})}function rimraf_(p,options,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.lstat(p,(er,st)=>{if(er&&er.code==="ENOENT"){return cb(null)}if(er&&er.code==="EPERM"&&isWindows2){return fixWinEPERM(p,options,er,cb)}if(st&&st.isDirectory()){return rmdir(p,options,er,cb)}options.unlink(p,er2=>{if(er2){if(er2.code==="ENOENT"){return cb(null)}if(er2.code==="EPERM"){return isWindows2?fixWinEPERM(p,options,er2,cb):rmdir(p,options,er2,cb)}if(er2.code==="EISDIR"){return rmdir(p,options,er2,cb)}}return cb(er2)})})}function fixWinEPERM(p,options,er,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.chmod(p,438,er2=>{if(er2){cb(er2.code==="ENOENT"?null:er)}else{options.stat(p,(er3,stats)=>{if(er3){cb(er3.code==="ENOENT"?null:er)}else if(stats.isDirectory()){rmdir(p,options,er,cb)}else{options.unlink(p,cb)}})}})}function fixWinEPERMSync(p,options,er){let stats;assert2(p);assert2(options);try{options.chmodSync(p,438)}catch(er2){if(er2.code==="ENOENT"){return}else{throw er}}try{stats=options.statSync(p)}catch(er3){if(er3.code==="ENOENT"){return}else{throw er}}if(stats.isDirectory()){rmdirSync(p,options,er)}else{options.unlinkSync(p)}}function rmdir(p,options,originalEr,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.rmdir(p,er=>{if(er&&(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM")){rmkids(p,options,cb)}else if(er&&er.code==="ENOTDIR"){cb(originalEr)}else{cb(er)}})}function rmkids(p,options,cb){assert2(p);assert2(options);assert2(typeof cb==="function");options.readdir(p,(er,files)=>{if(er)return cb(er);let n=files.length;let errState;if(n===0)return options.rmdir(p,cb);files.forEach(f=>{rimraf(path23.join(p,f),options,er2=>{if(errState){return}if(er2)return cb(errState=er2);if(--n===0){options.rmdir(p,cb)}})})})}function rimrafSync(p,options){let st;options=options||{};defaults3(options);assert2(p,"rimraf: missing path");assert2.strictEqual(typeof p,"string","rimraf: path should be a string");assert2(options,"rimraf: missing options");assert2.strictEqual(typeof options,"object","rimraf: options should be object");try{st=options.lstatSync(p)}catch(er){if(er.code==="ENOENT"){return}if(er.code==="EPERM"&&isWindows2){fixWinEPERMSync(p,options,er)}}try{if(st&&st.isDirectory()){rmdirSync(p,options,null)}else{options.unlinkSync(p)}}catch(er){if(er.code==="ENOENT"){return}else if(er.code==="EPERM"){return isWindows2?fixWinEPERMSync(p,options,er):rmdirSync(p,options,er)}else if(er.code!=="EISDIR"){throw er}rmdirSync(p,options,er)}}function rmdirSync(p,options,originalEr){assert2(p);assert2(options);try{options.rmdirSync(p)}catch(er){if(er.code==="ENOTDIR"){throw originalEr}else if(er.code==="ENOTEMPTY"||er.code==="EEXIST"||er.code==="EPERM"){rmkidsSync(p,options)}else if(er.code!=="ENOENT"){throw er}}}function rmkidsSync(p,options){assert2(p);assert2(options);options.readdirSync(p).forEach(f=>rimrafSync(path23.join(p,f),options));if(isWindows2){const startTime=Date.now();do{try{const ret=options.rmdirSync(p,options);return ret}catch{}}while(Date.now()-startTime<500)}else{const ret=options.rmdirSync(p,options);return ret}}module2.exports=rimraf;rimraf.sync=rimrafSync}});var require_remove=__commonJS({"node_modules/fs-extra/lib/remove/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var rimraf=require_rimraf();module2.exports={remove:u(rimraf),removeSync:rimraf.sync}}});var require_empty=__commonJS({"node_modules/fs-extra/lib/empty/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var fs11=require_graceful_fs();var path23=require("path");var mkdir2=require_mkdirs();var remove2=require_remove();var emptyDir=u(function emptyDir2(dir,callback){callback=callback||function(){};fs11.readdir(dir,(err,items)=>{if(err)return mkdir2.mkdirs(dir,callback);items=items.map(item=>path23.join(dir,item));deleteItem();function deleteItem(){const item=items.pop();if(!item)return callback();remove2.remove(item,err2=>{if(err2)return callback(err2);deleteItem()})}})});function emptyDirSync(dir){let items;try{items=fs11.readdirSync(dir)}catch{return mkdir2.mkdirsSync(dir)}items.forEach(item=>{item=path23.join(dir,item);remove2.removeSync(item)})}module2.exports={emptyDirSync,emptydirSync:emptyDirSync,emptyDir,emptydir:emptyDir}}});var require_file=__commonJS({"node_modules/fs-extra/lib/ensure/file.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path23=require("path");var fs11=require_graceful_fs();var mkdir2=require_mkdirs();function createFile(file,callback){function makeFile(){fs11.writeFile(file,"",err=>{if(err)return callback(err);callback()})}fs11.stat(file,(err,stats)=>{if(!err&&stats.isFile())return callback();const dir=path23.dirname(file);fs11.stat(dir,(err2,stats2)=>{if(err2){if(err2.code==="ENOENT"){return mkdir2.mkdirs(dir,err3=>{if(err3)return callback(err3);makeFile()})}return callback(err2)}if(stats2.isDirectory())makeFile();else{fs11.readdir(dir,err3=>{if(err3)return callback(err3)})}})})}function createFileSync(file){let stats;try{stats=fs11.statSync(file)}catch{}if(stats&&stats.isFile())return;const dir=path23.dirname(file);try{if(!fs11.statSync(dir).isDirectory()){fs11.readdirSync(dir)}}catch(err){if(err&&err.code==="ENOENT")mkdir2.mkdirsSync(dir);else throw err}fs11.writeFileSync(file,"")}module2.exports={createFile:u(createFile),createFileSync}}});var require_link=__commonJS({"node_modules/fs-extra/lib/ensure/link.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path23=require("path");var fs11=require_graceful_fs();var mkdir2=require_mkdirs();var pathExists=require_path_exists().pathExists;function createLink(srcpath,dstpath,callback){function makeLink(srcpath2,dstpath2){fs11.link(srcpath2,dstpath2,err=>{if(err)return callback(err);callback(null)})}pathExists(dstpath,(err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);fs11.lstat(srcpath,err2=>{if(err2){err2.message=err2.message.replace("lstat","ensureLink");return callback(err2)}const dir=path23.dirname(dstpath);pathExists(dir,(err3,dirExists)=>{if(err3)return callback(err3);if(dirExists)return makeLink(srcpath,dstpath);mkdir2.mkdirs(dir,err4=>{if(err4)return callback(err4);makeLink(srcpath,dstpath)})})})})}function createLinkSync(srcpath,dstpath){const destinationExists=fs11.existsSync(dstpath);if(destinationExists)return void 0;try{fs11.lstatSync(srcpath)}catch(err){err.message=err.message.replace("lstat","ensureLink");throw err}const dir=path23.dirname(dstpath);const dirExists=fs11.existsSync(dir);if(dirExists)return fs11.linkSync(srcpath,dstpath);mkdir2.mkdirsSync(dir);return fs11.linkSync(srcpath,dstpath)}module2.exports={createLink:u(createLink),createLinkSync}}});var require_symlink_paths=__commonJS({"node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports2,module2){"use strict";var path23=require("path");var fs11=require_graceful_fs();var pathExists=require_path_exists().pathExists;function symlinkPaths(srcpath,dstpath,callback){if(path23.isAbsolute(srcpath)){return fs11.lstat(srcpath,err=>{if(err){err.message=err.message.replace("lstat","ensureSymlink");return callback(err)}return callback(null,{toCwd:srcpath,toDst:srcpath})})}else{const dstdir=path23.dirname(dstpath);const relativeToDst=path23.join(dstdir,srcpath);return pathExists(relativeToDst,(err,exists2)=>{if(err)return callback(err);if(exists2){return callback(null,{toCwd:relativeToDst,toDst:srcpath})}else{return fs11.lstat(srcpath,err2=>{if(err2){err2.message=err2.message.replace("lstat","ensureSymlink");return callback(err2)}return callback(null,{toCwd:srcpath,toDst:path23.relative(dstdir,srcpath)})})}})}}function symlinkPathsSync(srcpath,dstpath){let exists2;if(path23.isAbsolute(srcpath)){exists2=fs11.existsSync(srcpath);if(!exists2)throw new Error("absolute srcpath does not exist");return{toCwd:srcpath,toDst:srcpath}}else{const dstdir=path23.dirname(dstpath);const relativeToDst=path23.join(dstdir,srcpath);exists2=fs11.existsSync(relativeToDst);if(exists2){return{toCwd:relativeToDst,toDst:srcpath}}else{exists2=fs11.existsSync(srcpath);if(!exists2)throw new Error("relative srcpath does not exist");return{toCwd:srcpath,toDst:path23.relative(dstdir,srcpath)}}}}module2.exports={symlinkPaths,symlinkPathsSync}}});var require_symlink_type=__commonJS({"node_modules/fs-extra/lib/ensure/symlink-type.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();function symlinkType(srcpath,type2,callback){callback=typeof type2==="function"?type2:callback;type2=typeof type2==="function"?false:type2;if(type2)return callback(null,type2);fs11.lstat(srcpath,(err,stats)=>{if(err)return callback(null,"file");type2=stats&&stats.isDirectory()?"dir":"file";callback(null,type2)})}function symlinkTypeSync(srcpath,type2){let stats;if(type2)return type2;try{stats=fs11.lstatSync(srcpath)}catch{return"file"}return stats&&stats.isDirectory()?"dir":"file"}module2.exports={symlinkType,symlinkTypeSync}}});var require_symlink=__commonJS({"node_modules/fs-extra/lib/ensure/symlink.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var path23=require("path");var fs11=require_graceful_fs();var _mkdirs=require_mkdirs();var mkdirs=_mkdirs.mkdirs;var mkdirsSync=_mkdirs.mkdirsSync;var _symlinkPaths=require_symlink_paths();var symlinkPaths=_symlinkPaths.symlinkPaths;var symlinkPathsSync=_symlinkPaths.symlinkPathsSync;var _symlinkType=require_symlink_type();var symlinkType=_symlinkType.symlinkType;var symlinkTypeSync=_symlinkType.symlinkTypeSync;var pathExists=require_path_exists().pathExists;function createSymlink(srcpath,dstpath,type2,callback){callback=typeof type2==="function"?type2:callback;type2=typeof type2==="function"?false:type2;pathExists(dstpath,(err,destinationExists)=>{if(err)return callback(err);if(destinationExists)return callback(null);symlinkPaths(srcpath,dstpath,(err2,relative3)=>{if(err2)return callback(err2);srcpath=relative3.toDst;symlinkType(relative3.toCwd,type2,(err3,type3)=>{if(err3)return callback(err3);const dir=path23.dirname(dstpath);pathExists(dir,(err4,dirExists)=>{if(err4)return callback(err4);if(dirExists)return fs11.symlink(srcpath,dstpath,type3,callback);mkdirs(dir,err5=>{if(err5)return callback(err5);fs11.symlink(srcpath,dstpath,type3,callback)})})})})})}function createSymlinkSync(srcpath,dstpath,type2){const destinationExists=fs11.existsSync(dstpath);if(destinationExists)return void 0;const relative3=symlinkPathsSync(srcpath,dstpath);srcpath=relative3.toDst;type2=symlinkTypeSync(relative3.toCwd,type2);const dir=path23.dirname(dstpath);const exists2=fs11.existsSync(dir);if(exists2)return fs11.symlinkSync(srcpath,dstpath,type2);mkdirsSync(dir);return fs11.symlinkSync(srcpath,dstpath,type2)}module2.exports={createSymlink:u(createSymlink),createSymlinkSync}}});var require_ensure=__commonJS({"node_modules/fs-extra/lib/ensure/index.js"(exports2,module2){"use strict";var file=require_file();var link=require_link();var symlink=require_symlink();module2.exports={createFile:file.createFile,createFileSync:file.createFileSync,ensureFile:file.createFile,ensureFileSync:file.createFileSync,createLink:link.createLink,createLinkSync:link.createLinkSync,ensureLink:link.createLink,ensureLinkSync:link.createLinkSync,createSymlink:symlink.createSymlink,createSymlinkSync:symlink.createSymlinkSync,ensureSymlink:symlink.createSymlink,ensureSymlinkSync:symlink.createSymlinkSync}}});var require_utils=__commonJS({"node_modules/jsonfile/utils.js"(exports2,module2){function stringify(obj,{EOL="\n",finalEOL=true,replacer=null,spaces}={}){const EOF=finalEOL?EOL:"";const str2=JSON.stringify(obj,replacer,spaces);return str2.replace(/\n/g,EOL)+EOF}function stripBom(content){if(Buffer.isBuffer(content))content=content.toString("utf8");return content.replace(/^\uFEFF/,"")}module2.exports={stringify,stripBom}}});var require_jsonfile=__commonJS({"node_modules/jsonfile/index.js"(exports2,module2){var _fs;try{_fs=require_graceful_fs()}catch(_){_fs=require("fs")}var universalify=require_universalify();var{stringify,stripBom}=require_utils();async function _readFile(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs11=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;let data=await universalify.fromCallback(fs11.readFile)(file,options);data=stripBom(data);let obj;try{obj=JSON.parse(data,options?options.reviver:null)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}return obj}var readFile4=universalify.fromPromise(_readFile);function readFileSync(file,options={}){if(typeof options==="string"){options={encoding:options}}const fs11=options.fs||_fs;const shouldThrow="throws"in options?options.throws:true;try{let content=fs11.readFileSync(file,options);content=stripBom(content);return JSON.parse(content,options.reviver)}catch(err){if(shouldThrow){err.message=`${file}: ${err.message}`;throw err}else{return null}}}async function _writeFile(file,obj,options={}){const fs11=options.fs||_fs;const str2=stringify(obj,options);await universalify.fromCallback(fs11.writeFile)(file,str2,options)}var writeFile3=universalify.fromPromise(_writeFile);function writeFileSync(file,obj,options={}){const fs11=options.fs||_fs;const str2=stringify(obj,options);return fs11.writeFileSync(file,str2,options)}var jsonfile={readFile:readFile4,readFileSync,writeFile:writeFile3,writeFileSync};module2.exports=jsonfile}});var require_jsonfile2=__commonJS({"node_modules/fs-extra/lib/json/jsonfile.js"(exports2,module2){"use strict";var jsonFile=require_jsonfile();module2.exports={readJson:jsonFile.readFile,readJsonSync:jsonFile.readFileSync,writeJson:jsonFile.writeFile,writeJsonSync:jsonFile.writeFileSync}}});var require_output=__commonJS({"node_modules/fs-extra/lib/output/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;var fs11=require_graceful_fs();var path23=require("path");var mkdir2=require_mkdirs();var pathExists=require_path_exists().pathExists;function outputFile(file,data,encoding,callback){if(typeof encoding==="function"){callback=encoding;encoding="utf8"}const dir=path23.dirname(file);pathExists(dir,(err,itDoes)=>{if(err)return callback(err);if(itDoes)return fs11.writeFile(file,data,encoding,callback);mkdir2.mkdirs(dir,err2=>{if(err2)return callback(err2);fs11.writeFile(file,data,encoding,callback)})})}function outputFileSync(file,...args2){const dir=path23.dirname(file);if(fs11.existsSync(dir)){return fs11.writeFileSync(file,...args2)}mkdir2.mkdirsSync(dir);fs11.writeFileSync(file,...args2)}module2.exports={outputFile:u(outputFile),outputFileSync}}});var require_output_json=__commonJS({"node_modules/fs-extra/lib/json/output-json.js"(exports2,module2){"use strict";var{stringify}=require_utils();var{outputFile}=require_output();async function outputJson(file,data,options={}){const str2=stringify(data,options);await outputFile(file,str2,options)}module2.exports=outputJson}});var require_output_json_sync=__commonJS({"node_modules/fs-extra/lib/json/output-json-sync.js"(exports2,module2){"use strict";var{stringify}=require_utils();var{outputFileSync}=require_output();function outputJsonSync(file,data,options){const str2=stringify(data,options);outputFileSync(file,str2,options)}module2.exports=outputJsonSync}});var require_json=__commonJS({"node_modules/fs-extra/lib/json/index.js"(exports2,module2){"use strict";var u=require_universalify().fromPromise;var jsonFile=require_jsonfile2();jsonFile.outputJson=u(require_output_json());jsonFile.outputJsonSync=require_output_json_sync();jsonFile.outputJSON=jsonFile.outputJson;jsonFile.outputJSONSync=jsonFile.outputJsonSync;jsonFile.writeJSON=jsonFile.writeJson;jsonFile.writeJSONSync=jsonFile.writeJsonSync;jsonFile.readJSON=jsonFile.readJson;jsonFile.readJSONSync=jsonFile.readJsonSync;module2.exports=jsonFile}});var require_move_sync=__commonJS({"node_modules/fs-extra/lib/move-sync/move-sync.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();var path23=require("path");var copySync=require_copy_sync2().copySync;var removeSync=require_remove().removeSync;var mkdirpSync=require_mkdirs().mkdirpSync;var stat3=require_stat();function moveSync(src,dest,opts){opts=opts||{};const overwrite=opts.overwrite||opts.clobber||false;const{srcStat}=stat3.checkPathsSync(src,dest,"move");stat3.checkParentPathsSync(src,srcStat,dest,"move");mkdirpSync(path23.dirname(dest));return doRename(src,dest,overwrite)}function doRename(src,dest,overwrite){if(overwrite){removeSync(dest);return rename3(src,dest,overwrite)}if(fs11.existsSync(dest))throw new Error("dest already exists.");return rename3(src,dest,overwrite)}function rename3(src,dest,overwrite){try{fs11.renameSync(src,dest)}catch(err){if(err.code!=="EXDEV")throw err;return moveAcrossDevice(src,dest,overwrite)}}function moveAcrossDevice(src,dest,overwrite){const opts={overwrite,errorOnExist:true};copySync(src,dest,opts);return removeSync(src)}module2.exports=moveSync}});var require_move_sync2=__commonJS({"node_modules/fs-extra/lib/move-sync/index.js"(exports2,module2){"use strict";module2.exports={moveSync:require_move_sync()}}});var require_move=__commonJS({"node_modules/fs-extra/lib/move/move.js"(exports2,module2){"use strict";var fs11=require_graceful_fs();var path23=require("path");var copy=require_copy2().copy;var remove2=require_remove().remove;var mkdirp=require_mkdirs().mkdirp;var pathExists=require_path_exists().pathExists;var stat3=require_stat();function move(src,dest,opts,cb){if(typeof opts==="function"){cb=opts;opts={}}const overwrite=opts.overwrite||opts.clobber||false;stat3.checkPaths(src,dest,"move",(err,stats)=>{if(err)return cb(err);const{srcStat}=stats;stat3.checkParentPaths(src,srcStat,dest,"move",err2=>{if(err2)return cb(err2);mkdirp(path23.dirname(dest),err3=>{if(err3)return cb(err3);return doRename(src,dest,overwrite,cb)})})})}function doRename(src,dest,overwrite,cb){if(overwrite){return remove2(dest,err=>{if(err)return cb(err);return rename3(src,dest,overwrite,cb)})}pathExists(dest,(err,destExists)=>{if(err)return cb(err);if(destExists)return cb(new Error("dest already exists."));return rename3(src,dest,overwrite,cb)})}function rename3(src,dest,overwrite,cb){fs11.rename(src,dest,err=>{if(!err)return cb();if(err.code!=="EXDEV")return cb(err);return moveAcrossDevice(src,dest,overwrite,cb)})}function moveAcrossDevice(src,dest,overwrite,cb){const opts={overwrite,errorOnExist:true};copy(src,dest,opts,err=>{if(err)return cb(err);return remove2(src,cb)})}module2.exports=move}});var require_move2=__commonJS({"node_modules/fs-extra/lib/move/index.js"(exports2,module2){"use strict";var u=require_universalify().fromCallback;module2.exports={move:u(require_move())}}});var require_lib=__commonJS({"node_modules/fs-extra/lib/index.js"(exports2,module2){"use strict";module2.exports={...require_fs(),...require_copy_sync2(),...require_copy2(),...require_empty(),...require_ensure(),...require_json(),...require_mkdirs(),...require_move_sync2(),...require_move2(),...require_output(),...require_path_exists(),...require_remove()};var fs11=require("fs");if(Object.getOwnPropertyDescriptor(fs11,"promises")){Object.defineProperty(module2.exports,"promises",{get(){return fs11.promises}})}}});var require_errors2=__commonJS({"node_modules/openid-client/lib/errors.js"(exports2,module2){var{format:format2}=require("util");var OPError=class extends Error{constructor({error_description,error,error_uri,session_state,state,scope},response){super(!error_description?error:`${error} (${error_description})`);Object.assign(this,{error},error_description&&{error_description},error_uri&&{error_uri},state&&{state},scope&&{scope},session_state&&{session_state});if(response){Object.defineProperty(this,"response",{value:response})}this.name=this.constructor.name;Error.captureStackTrace(this,this.constructor)}};var RPError=class extends Error{constructor(...args2){if(typeof args2[0]==="string"){super(format2(...args2))}else{const{message:message3,printf,response,...rest2}=args2[0];if(printf){super(format2(...printf))}else{super(message3)}Object.assign(this,rest2);if(response){Object.defineProperty(this,"response",{value:response})}}this.name=this.constructor.name;Error.captureStackTrace(this,this.constructor)}};module2.exports={OPError,RPError}}});var require_digest=__commonJS({"node_modules/jose/dist/node/cjs/runtime/digest.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var digest2=(algorithm,data)=>(0,crypto_1.createHash)(algorithm).update(data).digest();exports2.default=digest2}});var require_buffer_utils=__commonJS({"node_modules/jose/dist/node/cjs/lib/buffer_utils.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.concatKdf=exports2.lengthAndInput=exports2.uint32be=exports2.uint64be=exports2.p2s=exports2.concat=exports2.decoder=exports2.encoder=void 0;var digest_js_1=require_digest();exports2.encoder=new TextEncoder;exports2.decoder=new TextDecoder;var MAX_INT322=2**32;function concat3(...buffers){const size2=buffers.reduce((acc,{length})=>acc+length,0);const buf=new Uint8Array(size2);let i=0;buffers.forEach(buffer=>{buf.set(buffer,i);i+=buffer.length});return buf}exports2.concat=concat3;function p2s2(alg,p2sInput){return concat3(exports2.encoder.encode(alg),new Uint8Array([0]),p2sInput)}exports2.p2s=p2s2;function writeUInt32BE2(buf,value,offset){if(value<0||value>=MAX_INT322){throw new RangeError(`value must be >= 0 and <= ${MAX_INT322-1}. Received ${value}`)}buf.set([value>>>24,value>>>16,value>>>8,value&255],offset)}function uint64be2(value){const high=Math.floor(value/MAX_INT322);const low=value%MAX_INT322;const buf=new Uint8Array(8);writeUInt32BE2(buf,high,0);writeUInt32BE2(buf,low,4);return buf}exports2.uint64be=uint64be2;function uint32be2(value){const buf=new Uint8Array(4);writeUInt32BE2(buf,value);return buf}exports2.uint32be=uint32be2;function lengthAndInput2(input){return concat3(uint32be2(input.length),input)}exports2.lengthAndInput=lengthAndInput2;async function concatKdf2(secret,bits,value){const iterations=Math.ceil((bits>>3)/32);const res=new Uint8Array(iterations*32);for(let iter=0;iter<iterations;iter++){const buf=new Uint8Array(4+secret.length+value.length);buf.set(uint32be2(iter+1));buf.set(secret,4);buf.set(value,4+secret.length);res.set(await(0,digest_js_1.default)("sha256",buf),iter*32)}return res.slice(0,bits>>3)}exports2.concatKdf=concatKdf2}});var require_base64url=__commonJS({"node_modules/jose/dist/node/cjs/runtime/base64url.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decode=exports2.encode=exports2.encodeBase64=exports2.decodeBase64=void 0;var buffer_1=require("buffer");var buffer_utils_js_1=require_buffer_utils();var encode2;function normalize(input){let encoded=input;if(encoded instanceof Uint8Array){encoded=buffer_utils_js_1.decoder.decode(encoded)}return encoded}if(buffer_1.Buffer.isEncoding("base64url")){exports2.encode=encode2=input=>buffer_1.Buffer.from(input).toString("base64url")}else{exports2.encode=encode2=input=>buffer_1.Buffer.from(input).toString("base64").replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_")}var decodeBase64=input=>buffer_1.Buffer.from(input,"base64");exports2.decodeBase64=decodeBase64;var encodeBase64=input=>buffer_1.Buffer.from(input).toString("base64");exports2.encodeBase64=encodeBase64;var decode=input=>buffer_1.Buffer.from(normalize(input),"base64");exports2.decode=decode}});var require_errors3=__commonJS({"node_modules/jose/dist/node/cjs/util/errors.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.JWSSignatureVerificationFailed=exports2.JWKSTimeout=exports2.JWKSMultipleMatchingKeys=exports2.JWKSNoMatchingKey=exports2.JWKSInvalid=exports2.JWKInvalid=exports2.JWTInvalid=exports2.JWSInvalid=exports2.JWEInvalid=exports2.JWEDecompressionFailed=exports2.JWEDecryptionFailed=exports2.JOSENotSupported=exports2.JOSEAlgNotAllowed=exports2.JWTExpired=exports2.JWTClaimValidationFailed=exports2.JOSEError=void 0;var JOSEError2=class extends Error{static get code(){return"ERR_JOSE_GENERIC"}constructor(message3){var _a2;super(message3);this.code="ERR_JOSE_GENERIC";this.name=this.constructor.name;(_a2=Error.captureStackTrace)===null||_a2===void 0?void 0:_a2.call(Error,this,this.constructor)}};exports2.JOSEError=JOSEError2;var JWTClaimValidationFailed=class extends JOSEError2{static get code(){return"ERR_JWT_CLAIM_VALIDATION_FAILED"}constructor(message3,claim="unspecified",reason="unspecified"){super(message3);this.code="ERR_JWT_CLAIM_VALIDATION_FAILED";this.claim=claim;this.reason=reason}};exports2.JWTClaimValidationFailed=JWTClaimValidationFailed;var JWTExpired=class extends JOSEError2{static get code(){return"ERR_JWT_EXPIRED"}constructor(message3,claim="unspecified",reason="unspecified"){super(message3);this.code="ERR_JWT_EXPIRED";this.claim=claim;this.reason=reason}};exports2.JWTExpired=JWTExpired;var JOSEAlgNotAllowed=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JOSE_ALG_NOT_ALLOWED"}static get code(){return"ERR_JOSE_ALG_NOT_ALLOWED"}};exports2.JOSEAlgNotAllowed=JOSEAlgNotAllowed;var JOSENotSupported2=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JOSE_NOT_SUPPORTED"}static get code(){return"ERR_JOSE_NOT_SUPPORTED"}};exports2.JOSENotSupported=JOSENotSupported2;var JWEDecryptionFailed=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWE_DECRYPTION_FAILED";this.message="decryption operation failed"}static get code(){return"ERR_JWE_DECRYPTION_FAILED"}};exports2.JWEDecryptionFailed=JWEDecryptionFailed;var JWEDecompressionFailed=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWE_DECOMPRESSION_FAILED";this.message="decompression operation failed"}static get code(){return"ERR_JWE_DECOMPRESSION_FAILED"}};exports2.JWEDecompressionFailed=JWEDecompressionFailed;var JWEInvalid2=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWE_INVALID"}static get code(){return"ERR_JWE_INVALID"}};exports2.JWEInvalid=JWEInvalid2;var JWSInvalid=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWS_INVALID"}static get code(){return"ERR_JWS_INVALID"}};exports2.JWSInvalid=JWSInvalid;var JWTInvalid=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWT_INVALID"}static get code(){return"ERR_JWT_INVALID"}};exports2.JWTInvalid=JWTInvalid;var JWKInvalid=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWK_INVALID"}static get code(){return"ERR_JWK_INVALID"}};exports2.JWKInvalid=JWKInvalid;var JWKSInvalid=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWKS_INVALID"}static get code(){return"ERR_JWKS_INVALID"}};exports2.JWKSInvalid=JWKSInvalid;var JWKSNoMatchingKey=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWKS_NO_MATCHING_KEY";this.message="no applicable key found in the JSON Web Key Set"}static get code(){return"ERR_JWKS_NO_MATCHING_KEY"}};exports2.JWKSNoMatchingKey=JWKSNoMatchingKey;var JWKSMultipleMatchingKeys=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWKS_MULTIPLE_MATCHING_KEYS";this.message="multiple matching keys found in the JSON Web Key Set"}static get code(){return"ERR_JWKS_MULTIPLE_MATCHING_KEYS"}};exports2.JWKSMultipleMatchingKeys=JWKSMultipleMatchingKeys;var JWKSTimeout=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWKS_TIMEOUT";this.message="request timed out"}static get code(){return"ERR_JWKS_TIMEOUT"}};exports2.JWKSTimeout=JWKSTimeout;var JWSSignatureVerificationFailed=class extends JOSEError2{constructor(){super(...arguments);this.code="ERR_JWS_SIGNATURE_VERIFICATION_FAILED";this.message="signature verification failed"}static get code(){return"ERR_JWS_SIGNATURE_VERIFICATION_FAILED"}};exports2.JWSSignatureVerificationFailed=JWSSignatureVerificationFailed}});var require_random=__commonJS({"node_modules/jose/dist/node/cjs/runtime/random.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.default=void 0;var crypto_1=require("crypto");Object.defineProperty(exports2,"default",{enumerable:true,get:function(){return crypto_1.randomFillSync}})}});var require_iv=__commonJS({"node_modules/jose/dist/node/cjs/lib/iv.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.bitLength=void 0;var errors_js_1=require_errors3();var random_js_1=require_random();function bitLength3(alg){switch(alg){case"A128GCM":case"A128GCMKW":case"A192GCM":case"A192GCMKW":case"A256GCM":case"A256GCMKW":return 96;case"A128CBC-HS256":case"A192CBC-HS384":case"A256CBC-HS512":return 128;default:throw new errors_js_1.JOSENotSupported(`Unsupported JWE Algorithm: ${alg}`)}}exports2.bitLength=bitLength3;exports2.default=alg=>(0,random_js_1.default)(new Uint8Array(bitLength3(alg)>>3))}});var require_check_iv_length=__commonJS({"node_modules/jose/dist/node/cjs/lib/check_iv_length.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();var iv_js_1=require_iv();var checkIvLength2=(enc,iv)=>{if(iv.length<<3!==(0,iv_js_1.bitLength)(enc)){throw new errors_js_1.JWEInvalid("Invalid Initialization Vector length")}};exports2.default=checkIvLength2}});var require_is_key_object=__commonJS({"node_modules/jose/dist/node/cjs/runtime/is_key_object.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var util4=require("util");exports2.default=util4.types.isKeyObject?obj=>util4.types.isKeyObject(obj):obj=>obj!=null&&obj instanceof crypto_1.KeyObject}});var require_check_cek_length=__commonJS({"node_modules/jose/dist/node/cjs/runtime/check_cek_length.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();var is_key_object_js_1=require_is_key_object();var checkCekLength2=(enc,cek)=>{let expected;switch(enc){case"A128CBC-HS256":case"A192CBC-HS384":case"A256CBC-HS512":expected=parseInt(enc.slice(-3),10);break;case"A128GCM":case"A192GCM":case"A256GCM":expected=parseInt(enc.slice(1,4),10);break;default:throw new errors_js_1.JOSENotSupported(`Content Encryption Algorithm ${enc} is not supported either by JOSE or your javascript runtime`)}if(cek instanceof Uint8Array){const actual=cek.byteLength<<3;if(actual!==expected){throw new errors_js_1.JWEInvalid(`Invalid Content Encryption Key length. Expected ${expected} bits, got ${actual} bits`)}return}if((0,is_key_object_js_1.default)(cek)&&cek.type==="secret"){const actual=cek.symmetricKeySize<<3;if(actual!==expected){throw new errors_js_1.JWEInvalid(`Invalid Content Encryption Key length. Expected ${expected} bits, got ${actual} bits`)}return}throw new TypeError("Invalid Content Encryption Key type")};exports2.default=checkCekLength2}});var require_timing_safe_equal=__commonJS({"node_modules/jose/dist/node/cjs/runtime/timing_safe_equal.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var timingSafeEqual=crypto_1.timingSafeEqual;exports2.default=timingSafeEqual}});var require_cbc_tag=__commonJS({"node_modules/jose/dist/node/cjs/runtime/cbc_tag.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var buffer_utils_js_1=require_buffer_utils();function cbcTag2(aad,iv,ciphertext,macSize,macKey,keySize){const macData=(0,buffer_utils_js_1.concat)(aad,iv,ciphertext,(0,buffer_utils_js_1.uint64be)(aad.length<<3));const hmac=(0,crypto_1.createHmac)(`sha${macSize}`,macKey);hmac.update(macData);return hmac.digest().slice(0,keySize>>3)}exports2.default=cbcTag2}});var require_webcrypto=__commonJS({"node_modules/jose/dist/node/cjs/runtime/webcrypto.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.isCryptoKey=void 0;var crypto5=require("crypto");var util4=require("util");var webcrypto3=crypto5.webcrypto;exports2.default=webcrypto3;exports2.isCryptoKey=util4.types.isCryptoKey?key=>util4.types.isCryptoKey(key):key=>false}});var require_crypto_key=__commonJS({"node_modules/jose/dist/node/cjs/lib/crypto_key.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.checkEncCryptoKey=exports2.checkSigCryptoKey=void 0;function unusable2(name,prop="algorithm.name"){return new TypeError(`CryptoKey does not support this operation, its ${prop} must be ${name}`)}function isAlgorithm2(algorithm,name){return algorithm.name===name}function getHashLength2(hash){return parseInt(hash.name.slice(4),10)}function getNamedCurve2(alg){switch(alg){case"ES256":return"P-256";case"ES384":return"P-384";case"ES512":return"P-521";default:throw new Error("unreachable")}}function checkUsage2(key,usages){if(usages.length&&!usages.some(expected=>key.usages.includes(expected))){let msg="CryptoKey does not support this operation, its usages must include ";if(usages.length>2){const last2=usages.pop();msg+=`one of ${usages.join(", ")}, or ${last2}.`}else if(usages.length===2){msg+=`one of ${usages[0]} or ${usages[1]}.`}else{msg+=`${usages[0]}.`}throw new TypeError(msg)}}function checkSigCryptoKey(key,alg,...usages){switch(alg){case"HS256":case"HS384":case"HS512":{if(!isAlgorithm2(key.algorithm,"HMAC"))throw unusable2("HMAC");const expected=parseInt(alg.slice(2),10);const actual=getHashLength2(key.algorithm.hash);if(actual!==expected)throw unusable2(`SHA-${expected}`,"algorithm.hash");break}case"RS256":case"RS384":case"RS512":{if(!isAlgorithm2(key.algorithm,"RSASSA-PKCS1-v1_5"))throw unusable2("RSASSA-PKCS1-v1_5");const expected=parseInt(alg.slice(2),10);const actual=getHashLength2(key.algorithm.hash);if(actual!==expected)throw unusable2(`SHA-${expected}`,"algorithm.hash");break}case"PS256":case"PS384":case"PS512":{if(!isAlgorithm2(key.algorithm,"RSA-PSS"))throw unusable2("RSA-PSS");const expected=parseInt(alg.slice(2),10);const actual=getHashLength2(key.algorithm.hash);if(actual!==expected)throw unusable2(`SHA-${expected}`,"algorithm.hash");break}case"EdDSA":{if(key.algorithm.name!=="Ed25519"&&key.algorithm.name!=="Ed448"){throw unusable2("Ed25519 or Ed448")}break}case"ES256":case"ES384":case"ES512":{if(!isAlgorithm2(key.algorithm,"ECDSA"))throw unusable2("ECDSA");const expected=getNamedCurve2(alg);const actual=key.algorithm.namedCurve;if(actual!==expected)throw unusable2(expected,"algorithm.namedCurve");break}default:throw new TypeError("CryptoKey does not support this operation")}checkUsage2(key,usages)}exports2.checkSigCryptoKey=checkSigCryptoKey;function checkEncCryptoKey2(key,alg,...usages){switch(alg){case"A128GCM":case"A192GCM":case"A256GCM":{if(!isAlgorithm2(key.algorithm,"AES-GCM"))throw unusable2("AES-GCM");const expected=parseInt(alg.slice(1,4),10);const actual=key.algorithm.length;if(actual!==expected)throw unusable2(expected,"algorithm.length");break}case"A128KW":case"A192KW":case"A256KW":{if(!isAlgorithm2(key.algorithm,"AES-KW"))throw unusable2("AES-KW");const expected=parseInt(alg.slice(1,4),10);const actual=key.algorithm.length;if(actual!==expected)throw unusable2(expected,"algorithm.length");break}case"ECDH":{switch(key.algorithm.name){case"ECDH":case"X25519":case"X448":break;default:throw unusable2("ECDH, X25519, or X448")}break}case"PBES2-HS256+A128KW":case"PBES2-HS384+A192KW":case"PBES2-HS512+A256KW":if(!isAlgorithm2(key.algorithm,"PBKDF2"))throw unusable2("PBKDF2");break;case"RSA-OAEP":case"RSA-OAEP-256":case"RSA-OAEP-384":case"RSA-OAEP-512":{if(!isAlgorithm2(key.algorithm,"RSA-OAEP"))throw unusable2("RSA-OAEP");const expected=parseInt(alg.slice(9),10)||1;const actual=getHashLength2(key.algorithm.hash);if(actual!==expected)throw unusable2(`SHA-${expected}`,"algorithm.hash");break}default:throw new TypeError("CryptoKey does not support this operation")}checkUsage2(key,usages)}exports2.checkEncCryptoKey=checkEncCryptoKey2}});var require_invalid_key_input=__commonJS({"node_modules/jose/dist/node/cjs/lib/invalid_key_input.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.withAlg=void 0;function message3(msg,actual,...types6){if(types6.length>2){const last2=types6.pop();msg+=`one of type ${types6.join(", ")}, or ${last2}.`}else if(types6.length===2){msg+=`one of type ${types6[0]} or ${types6[1]}.`}else{msg+=`of type ${types6[0]}.`}if(actual==null){msg+=` Received ${actual}`}else if(typeof actual==="function"&&actual.name){msg+=` Received function ${actual.name}`}else if(typeof actual==="object"&&actual!=null){if(actual.constructor&&actual.constructor.name){msg+=` Received an instance of ${actual.constructor.name}`}}return msg}exports2.default=(actual,...types6)=>{return message3("Key must be ",actual,...types6)};function withAlg2(alg,actual,...types6){return message3(`Key for the ${alg} algorithm must be `,actual,...types6)}exports2.withAlg=withAlg2}});var require_ciphers=__commonJS({"node_modules/jose/dist/node/cjs/runtime/ciphers.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var ciphers2;exports2.default=algorithm=>{ciphers2||(ciphers2=new Set((0,crypto_1.getCiphers)()));return ciphers2.has(algorithm)}}});var require_is_key_like=__commonJS({"node_modules/jose/dist/node/cjs/runtime/is_key_like.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.types=void 0;var webcrypto_js_1=require_webcrypto();var is_key_object_js_1=require_is_key_object();exports2.default=key=>(0,is_key_object_js_1.default)(key)||(0,webcrypto_js_1.isCryptoKey)(key);var types6=["KeyObject"];exports2.types=types6;if(globalThis.CryptoKey||(webcrypto_js_1.default===null||webcrypto_js_1.default===void 0?void 0:webcrypto_js_1.default.CryptoKey)){types6.push("CryptoKey")}}});var require_decrypt=__commonJS({"node_modules/jose/dist/node/cjs/runtime/decrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var check_iv_length_js_1=require_check_iv_length();var check_cek_length_js_1=require_check_cek_length();var buffer_utils_js_1=require_buffer_utils();var errors_js_1=require_errors3();var timing_safe_equal_js_1=require_timing_safe_equal();var cbc_tag_js_1=require_cbc_tag();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var ciphers_js_1=require_ciphers();var is_key_like_js_1=require_is_key_like();function cbcDecrypt(enc,cek,ciphertext,iv,tag,aad){const keySize=parseInt(enc.slice(1,4),10);if((0,is_key_object_js_1.default)(cek)){cek=cek.export()}const encKey=cek.subarray(keySize>>3);const macKey=cek.subarray(0,keySize>>3);const macSize=parseInt(enc.slice(-3),10);const algorithm=`aes-${keySize}-cbc`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`)}const expectedTag=(0,cbc_tag_js_1.default)(aad,iv,ciphertext,macSize,macKey,keySize);let macCheckPassed;try{macCheckPassed=(0,timing_safe_equal_js_1.default)(tag,expectedTag)}catch{}if(!macCheckPassed){throw new errors_js_1.JWEDecryptionFailed}let plaintext;try{const decipher=(0,crypto_1.createDecipheriv)(algorithm,encKey,iv);plaintext=(0,buffer_utils_js_1.concat)(decipher.update(ciphertext),decipher.final())}catch{}if(!plaintext){throw new errors_js_1.JWEDecryptionFailed}return plaintext}function gcmDecrypt(enc,cek,ciphertext,iv,tag,aad){const keySize=parseInt(enc.slice(1,4),10);const algorithm=`aes-${keySize}-gcm`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`)}try{const decipher=(0,crypto_1.createDecipheriv)(algorithm,cek,iv,{authTagLength:16});decipher.setAuthTag(tag);if(aad.byteLength){decipher.setAAD(aad,{plaintextLength:ciphertext.length})}const plaintext=decipher.update(ciphertext);decipher.final();return plaintext}catch{throw new errors_js_1.JWEDecryptionFailed}}var decrypt=(enc,cek,ciphertext,iv,tag,aad)=>{let key;if((0,webcrypto_js_1.isCryptoKey)(cek)){(0,crypto_key_js_1.checkEncCryptoKey)(cek,enc,"decrypt");key=crypto_1.KeyObject.from(cek)}else if(cek instanceof Uint8Array||(0,is_key_object_js_1.default)(cek)){key=cek}else{throw new TypeError((0,invalid_key_input_js_1.default)(cek,...is_key_like_js_1.types,"Uint8Array"))}(0,check_cek_length_js_1.default)(enc,key);(0,check_iv_length_js_1.default)(enc,iv);switch(enc){case"A128CBC-HS256":case"A192CBC-HS384":case"A256CBC-HS512":return cbcDecrypt(enc,key,ciphertext,iv,tag,aad);case"A128GCM":case"A192GCM":case"A256GCM":return gcmDecrypt(enc,key,ciphertext,iv,tag,aad);default:throw new errors_js_1.JOSENotSupported("Unsupported JWE Content Encryption Algorithm")}};exports2.default=decrypt}});var require_zlib=__commonJS({"node_modules/jose/dist/node/cjs/runtime/zlib.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.deflate=exports2.inflate=void 0;var util_1=require("util");var zlib_1=require("zlib");var errors_js_1=require_errors3();var inflateRaw2=(0,util_1.promisify)(zlib_1.inflateRaw);var deflateRaw2=(0,util_1.promisify)(zlib_1.deflateRaw);var inflate=input=>inflateRaw2(input,{maxOutputLength:25e4}).catch(()=>{throw new errors_js_1.JWEDecompressionFailed});exports2.inflate=inflate;var deflate2=input=>deflateRaw2(input);exports2.deflate=deflate2}});var require_is_disjoint=__commonJS({"node_modules/jose/dist/node/cjs/lib/is_disjoint.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var isDisjoint2=(...headers)=>{const sources=headers.filter(Boolean);if(sources.length===0||sources.length===1){return true}let acc;for(const header2 of sources){const parameters=Object.keys(header2);if(!acc||acc.size===0){acc=new Set(parameters);continue}for(const parameter of parameters){if(acc.has(parameter)){return false}acc.add(parameter)}}return true};exports2.default=isDisjoint2}});var require_is_object=__commonJS({"node_modules/jose/dist/node/cjs/lib/is_object.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});function isObjectLike3(value){return typeof value==="object"&&value!==null}function isObject4(input){if(!isObjectLike3(input)||Object.prototype.toString.call(input)!=="[object Object]"){return false}if(Object.getPrototypeOf(input)===null){return true}let proto2=input;while(Object.getPrototypeOf(proto2)!==null){proto2=Object.getPrototypeOf(proto2)}return Object.getPrototypeOf(input)===proto2}exports2.default=isObject4}});var require_aeskw=__commonJS({"node_modules/jose/dist/node/cjs/runtime/aeskw.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.unwrap=exports2.wrap=void 0;var buffer_1=require("buffer");var crypto_1=require("crypto");var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var ciphers_js_1=require_ciphers();var is_key_like_js_1=require_is_key_like();function checkKeySize2(key,alg){if(key.symmetricKeySize<<3!==parseInt(alg.slice(1,4),10)){throw new TypeError(`Invalid key size for alg: ${alg}`)}}function ensureKeyObject3(key,alg,usage){if((0,is_key_object_js_1.default)(key)){return key}if(key instanceof Uint8Array){return(0,crypto_1.createSecretKey)(key)}if((0,webcrypto_js_1.isCryptoKey)(key)){(0,crypto_key_js_1.checkEncCryptoKey)(key,alg,usage);return crypto_1.KeyObject.from(key)}throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types,"Uint8Array"))}var wrap4=(alg,key,cek)=>{const size2=parseInt(alg.slice(1,4),10);const algorithm=`aes${size2}-wrap`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`)}const keyObject=ensureKeyObject3(key,alg,"wrapKey");checkKeySize2(keyObject,alg);const cipher=(0,crypto_1.createCipheriv)(algorithm,keyObject,buffer_1.Buffer.alloc(8,166));return(0,buffer_utils_js_1.concat)(cipher.update(cek),cipher.final())};exports2.wrap=wrap4;var unwrap2=(alg,key,encryptedKey)=>{const size2=parseInt(alg.slice(1,4),10);const algorithm=`aes${size2}-wrap`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`)}const keyObject=ensureKeyObject3(key,alg,"unwrapKey");checkKeySize2(keyObject,alg);const cipher=(0,crypto_1.createDecipheriv)(algorithm,keyObject,buffer_1.Buffer.alloc(8,166));return(0,buffer_utils_js_1.concat)(cipher.update(encryptedKey),cipher.final())};exports2.unwrap=unwrap2}});var require_get_named_curve=__commonJS({"node_modules/jose/dist/node/cjs/runtime/get_named_curve.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.setCurve=exports2.weakMap=void 0;var buffer_1=require("buffer");var crypto_1=require("crypto");var errors_js_1=require_errors3();var webcrypto_js_1=require_webcrypto();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var p2562=buffer_1.Buffer.from([42,134,72,206,61,3,1,7]);var p3842=buffer_1.Buffer.from([43,129,4,0,34]);var p5212=buffer_1.Buffer.from([43,129,4,0,35]);var secp256k12=buffer_1.Buffer.from([43,129,4,0,10]);exports2.weakMap=new WeakMap;var namedCurveToJOSE2=namedCurve=>{switch(namedCurve){case"prime256v1":return"P-256";case"secp384r1":return"P-384";case"secp521r1":return"P-521";case"secp256k1":return"secp256k1";default:throw new errors_js_1.JOSENotSupported("Unsupported key curve for this operation")}};var getNamedCurve2=(kee,raw)=>{var _a2;let key;if((0,webcrypto_js_1.isCryptoKey)(kee)){key=crypto_1.KeyObject.from(kee)}else if((0,is_key_object_js_1.default)(kee)){key=kee}else{throw new TypeError((0,invalid_key_input_js_1.default)(kee,...is_key_like_js_1.types))}if(key.type==="secret"){throw new TypeError('only "private" or "public" type keys can be used for this operation')}switch(key.asymmetricKeyType){case"ed25519":case"ed448":return`Ed${key.asymmetricKeyType.slice(2)}`;case"x25519":case"x448":return`X${key.asymmetricKeyType.slice(1)}`;case"ec":{if(exports2.weakMap.has(key)){return exports2.weakMap.get(key)}let namedCurve=(_a2=key.asymmetricKeyDetails)===null||_a2===void 0?void 0:_a2.namedCurve;if(!namedCurve&&key.type==="private"){namedCurve=getNamedCurve2((0,crypto_1.createPublicKey)(key),true)}else if(!namedCurve){const buf=key.export({format:"der",type:"spki"});const i=buf[1]<128?14:15;const len=buf[i];const curveOid=buf.slice(i+1,i+1+len);if(curveOid.equals(p2562)){namedCurve="prime256v1"}else if(curveOid.equals(p3842)){namedCurve="secp384r1"}else if(curveOid.equals(p5212)){namedCurve="secp521r1"}else if(curveOid.equals(secp256k12)){namedCurve="secp256k1"}else{throw new errors_js_1.JOSENotSupported("Unsupported key curve for this operation")}}if(raw)return namedCurve;const curve=namedCurveToJOSE2(namedCurve);exports2.weakMap.set(key,curve);return curve}default:throw new TypeError("Invalid asymmetric key type for this operation")}};function setCurve(keyObject,curve){exports2.weakMap.set(keyObject,curve)}exports2.setCurve=setCurve;exports2.default=getNamedCurve2}});var require_ecdhes=__commonJS({"node_modules/jose/dist/node/cjs/runtime/ecdhes.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ecdhAllowed=exports2.generateEpk=exports2.deriveKey=void 0;var crypto_1=require("crypto");var util_1=require("util");var get_named_curve_js_1=require_get_named_curve();var buffer_utils_js_1=require_buffer_utils();var errors_js_1=require_errors3();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var generateKeyPair2=(0,util_1.promisify)(crypto_1.generateKeyPair);async function deriveKey2(publicKee,privateKee,algorithm,keyLength,apu=new Uint8Array(0),apv=new Uint8Array(0)){let publicKey;if((0,webcrypto_js_1.isCryptoKey)(publicKee)){(0,crypto_key_js_1.checkEncCryptoKey)(publicKee,"ECDH");publicKey=crypto_1.KeyObject.from(publicKee)}else if((0,is_key_object_js_1.default)(publicKee)){publicKey=publicKee}else{throw new TypeError((0,invalid_key_input_js_1.default)(publicKee,...is_key_like_js_1.types))}let privateKey;if((0,webcrypto_js_1.isCryptoKey)(privateKee)){(0,crypto_key_js_1.checkEncCryptoKey)(privateKee,"ECDH","deriveBits");privateKey=crypto_1.KeyObject.from(privateKee)}else if((0,is_key_object_js_1.default)(privateKee)){privateKey=privateKee}else{throw new TypeError((0,invalid_key_input_js_1.default)(privateKee,...is_key_like_js_1.types))}const value=(0,buffer_utils_js_1.concat)((0,buffer_utils_js_1.lengthAndInput)(buffer_utils_js_1.encoder.encode(algorithm)),(0,buffer_utils_js_1.lengthAndInput)(apu),(0,buffer_utils_js_1.lengthAndInput)(apv),(0,buffer_utils_js_1.uint32be)(keyLength));const sharedSecret=(0,crypto_1.diffieHellman)({privateKey,publicKey});return(0,buffer_utils_js_1.concatKdf)(sharedSecret,keyLength,value)}exports2.deriveKey=deriveKey2;async function generateEpk2(kee){let key;if((0,webcrypto_js_1.isCryptoKey)(kee)){key=crypto_1.KeyObject.from(kee)}else if((0,is_key_object_js_1.default)(kee)){key=kee}else{throw new TypeError((0,invalid_key_input_js_1.default)(kee,...is_key_like_js_1.types))}switch(key.asymmetricKeyType){case"x25519":return generateKeyPair2("x25519");case"x448":{return generateKeyPair2("x448")}case"ec":{const namedCurve=(0,get_named_curve_js_1.default)(key);return generateKeyPair2("ec",{namedCurve})}default:throw new errors_js_1.JOSENotSupported("Invalid or unsupported EPK")}}exports2.generateEpk=generateEpk2;var ecdhAllowed2=key=>["P-256","P-384","P-521","X25519","X448"].includes((0,get_named_curve_js_1.default)(key));exports2.ecdhAllowed=ecdhAllowed2}});var require_check_p2s=__commonJS({"node_modules/jose/dist/node/cjs/lib/check_p2s.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();function checkP2s2(p2s2){if(!(p2s2 instanceof Uint8Array)||p2s2.length<8){throw new errors_js_1.JWEInvalid("PBES2 Salt Input must be 8 or more octets")}}exports2.default=checkP2s2}});var require_pbes2kw=__commonJS({"node_modules/jose/dist/node/cjs/runtime/pbes2kw.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decrypt=exports2.encrypt=void 0;var util_1=require("util");var crypto_1=require("crypto");var random_js_1=require_random();var buffer_utils_js_1=require_buffer_utils();var base64url_js_1=require_base64url();var aeskw_js_1=require_aeskw();var check_p2s_js_1=require_check_p2s();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var pbkdf22=(0,util_1.promisify)(crypto_1.pbkdf2);function getPassword2(key,alg){if((0,is_key_object_js_1.default)(key)){return key.export()}if(key instanceof Uint8Array){return key}if((0,webcrypto_js_1.isCryptoKey)(key)){(0,crypto_key_js_1.checkEncCryptoKey)(key,alg,"deriveBits","deriveKey");return crypto_1.KeyObject.from(key).export()}throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types,"Uint8Array"))}var encrypt4=async(alg,key,cek,p2c=2048,p2s2=(0,random_js_1.default)(new Uint8Array(16)))=>{(0,check_p2s_js_1.default)(p2s2);const salt=(0,buffer_utils_js_1.p2s)(alg,p2s2);const keylen=parseInt(alg.slice(13,16),10)>>3;const password=getPassword2(key,alg);const derivedKey=await pbkdf22(password,salt,p2c,keylen,`sha${alg.slice(8,11)}`);const encryptedKey=await(0,aeskw_js_1.wrap)(alg.slice(-6),derivedKey,cek);return{encryptedKey,p2c,p2s:(0,base64url_js_1.encode)(p2s2)}};exports2.encrypt=encrypt4;var decrypt=async(alg,key,encryptedKey,p2c,p2s2)=>{(0,check_p2s_js_1.default)(p2s2);const salt=(0,buffer_utils_js_1.p2s)(alg,p2s2);const keylen=parseInt(alg.slice(13,16),10)>>3;const password=getPassword2(key,alg);const derivedKey=await pbkdf22(password,salt,p2c,keylen,`sha${alg.slice(8,11)}`);return(0,aeskw_js_1.unwrap)(alg.slice(-6),derivedKey,encryptedKey)};exports2.decrypt=decrypt}});var require_check_modulus_length=__commonJS({"node_modules/jose/dist/node/cjs/runtime/check_modulus_length.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.setModulusLength=exports2.weakMap=void 0;exports2.weakMap=new WeakMap;var getLength2=(buf,index)=>{let len=buf.readUInt8(1);if((len&128)===0){if(index===0){return len}return getLength2(buf.subarray(2+len),index-1)}const num=len&127;len=0;for(let i=0;i<num;i++){len<<=8;const j=buf.readUInt8(2+i);len|=j}if(index===0){return len}return getLength2(buf.subarray(2+len),index-1)};var getLengthOfSeqIndex2=(sequence,index)=>{const len=sequence.readUInt8(1);if((len&128)===0){return getLength2(sequence.subarray(2),index)}const num=len&127;return getLength2(sequence.subarray(2+num),index)};var getModulusLength2=key=>{var _a2,_b;if(exports2.weakMap.has(key)){return exports2.weakMap.get(key)}const modulusLength=(_b=(_a2=key.asymmetricKeyDetails)===null||_a2===void 0?void 0:_a2.modulusLength)!==null&&_b!==void 0?_b:getLengthOfSeqIndex2(key.export({format:"der",type:"pkcs1"}),key.type==="private"?1:0)-1<<3;exports2.weakMap.set(key,modulusLength);return modulusLength};var setModulusLength=(keyObject,modulusLength)=>{exports2.weakMap.set(keyObject,modulusLength)};exports2.setModulusLength=setModulusLength;exports2.default=(key,alg)=>{if(getModulusLength2(key)<2048){throw new TypeError(`${alg} requires key modulusLength to be 2048 bits or larger`)}}}});var require_rsaes=__commonJS({"node_modules/jose/dist/node/cjs/runtime/rsaes.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decrypt=exports2.encrypt=void 0;var crypto_1=require("crypto");var check_modulus_length_js_1=require_check_modulus_length();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var checkKey2=(key,alg)=>{if(key.asymmetricKeyType!=="rsa"){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be rsa")}(0,check_modulus_length_js_1.default)(key,alg)};var resolvePadding2=alg=>{switch(alg){case"RSA-OAEP":case"RSA-OAEP-256":case"RSA-OAEP-384":case"RSA-OAEP-512":return crypto_1.constants.RSA_PKCS1_OAEP_PADDING;case"RSA1_5":return crypto_1.constants.RSA_PKCS1_PADDING;default:return void 0}};var resolveOaepHash2=alg=>{switch(alg){case"RSA-OAEP":return"sha1";case"RSA-OAEP-256":return"sha256";case"RSA-OAEP-384":return"sha384";case"RSA-OAEP-512":return"sha512";default:return void 0}};function ensureKeyObject3(key,alg,...usages){if((0,is_key_object_js_1.default)(key)){return key}if((0,webcrypto_js_1.isCryptoKey)(key)){(0,crypto_key_js_1.checkEncCryptoKey)(key,alg,...usages);return crypto_1.KeyObject.from(key)}throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types))}var encrypt4=(alg,key,cek)=>{const padding=resolvePadding2(alg);const oaepHash=resolveOaepHash2(alg);const keyObject=ensureKeyObject3(key,alg,"wrapKey","encrypt");checkKey2(keyObject,alg);return(0,crypto_1.publicEncrypt)({key:keyObject,oaepHash,padding},cek)};exports2.encrypt=encrypt4;var decrypt=(alg,key,encryptedKey)=>{const padding=resolvePadding2(alg);const oaepHash=resolveOaepHash2(alg);const keyObject=ensureKeyObject3(key,alg,"unwrapKey","decrypt");checkKey2(keyObject,alg);return(0,crypto_1.privateDecrypt)({key:keyObject,oaepHash,padding},encryptedKey)};exports2.decrypt=decrypt}});var require_cek=__commonJS({"node_modules/jose/dist/node/cjs/lib/cek.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.bitLength=void 0;var errors_js_1=require_errors3();var random_js_1=require_random();function bitLength3(alg){switch(alg){case"A128GCM":return 128;case"A192GCM":return 192;case"A256GCM":case"A128CBC-HS256":return 256;case"A192CBC-HS384":return 384;case"A256CBC-HS512":return 512;default:throw new errors_js_1.JOSENotSupported(`Unsupported JWE Algorithm: ${alg}`)}}exports2.bitLength=bitLength3;exports2.default=alg=>(0,random_js_1.default)(new Uint8Array(bitLength3(alg)>>3))}});var require_asn1=__commonJS({"node_modules/jose/dist/node/cjs/runtime/asn1.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.fromX509=exports2.fromSPKI=exports2.fromPKCS8=exports2.toPKCS8=exports2.toSPKI=void 0;var crypto_1=require("crypto");var buffer_1=require("buffer");var webcrypto_js_1=require_webcrypto();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var genericExport=(keyType,keyFormat,key)=>{let keyObject;if((0,webcrypto_js_1.isCryptoKey)(key)){if(!key.extractable){throw new TypeError("CryptoKey is not extractable")}keyObject=crypto_1.KeyObject.from(key)}else if((0,is_key_object_js_1.default)(key)){keyObject=key}else{throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types))}if(keyObject.type!==keyType){throw new TypeError(`key is not a ${keyType} key`)}return keyObject.export({format:"pem",type:keyFormat})};var toSPKI=key=>{return genericExport("public","spki",key)};exports2.toSPKI=toSPKI;var toPKCS8=key=>{return genericExport("private","pkcs8",key)};exports2.toPKCS8=toPKCS8;var fromPKCS82=pem=>(0,crypto_1.createPrivateKey)({key:buffer_1.Buffer.from(pem.replace(/(?:-----(?:BEGIN|END) PRIVATE KEY-----|\s)/g,""),"base64"),type:"pkcs8",format:"der"});exports2.fromPKCS8=fromPKCS82;var fromSPKI2=pem=>(0,crypto_1.createPublicKey)({key:buffer_1.Buffer.from(pem.replace(/(?:-----(?:BEGIN|END) PUBLIC KEY-----|\s)/g,""),"base64"),type:"spki",format:"der"});exports2.fromSPKI=fromSPKI2;var fromX5092=pem=>(0,crypto_1.createPublicKey)({key:pem,type:"spki",format:"pem"});exports2.fromX509=fromX5092}});var require_asn1_sequence_encoder=__commonJS({"node_modules/jose/dist/node/cjs/runtime/asn1_sequence_encoder.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var buffer_1=require("buffer");var errors_js_1=require_errors3();var tagInteger2=2;var tagBitStr=3;var tagOctStr=4;var tagSequence2=48;var bZero=buffer_1.Buffer.from([0]);var bTagInteger=buffer_1.Buffer.from([tagInteger2]);var bTagBitStr=buffer_1.Buffer.from([tagBitStr]);var bTagSequence=buffer_1.Buffer.from([tagSequence2]);var bTagOctStr=buffer_1.Buffer.from([tagOctStr]);var encodeLength=len=>{if(len<128)return buffer_1.Buffer.from([len]);const buffer=buffer_1.Buffer.alloc(5);buffer.writeUInt32BE(len,1);let offset=1;while(buffer[offset]===0)offset++;buffer[offset-1]=128|5-offset;return buffer.slice(offset-1)};var oids=new Map([["P-256",buffer_1.Buffer.from("06 08 2A 86 48 CE 3D 03 01 07".replace(/ /g,""),"hex")],["secp256k1",buffer_1.Buffer.from("06 05 2B 81 04 00 0A".replace(/ /g,""),"hex")],["P-384",buffer_1.Buffer.from("06 05 2B 81 04 00 22".replace(/ /g,""),"hex")],["P-521",buffer_1.Buffer.from("06 05 2B 81 04 00 23".replace(/ /g,""),"hex")],["ecPublicKey",buffer_1.Buffer.from("06 07 2A 86 48 CE 3D 02 01".replace(/ /g,""),"hex")],["X25519",buffer_1.Buffer.from("06 03 2B 65 6E".replace(/ /g,""),"hex")],["X448",buffer_1.Buffer.from("06 03 2B 65 6F".replace(/ /g,""),"hex")],["Ed25519",buffer_1.Buffer.from("06 03 2B 65 70".replace(/ /g,""),"hex")],["Ed448",buffer_1.Buffer.from("06 03 2B 65 71".replace(/ /g,""),"hex")]]);var DumbAsn1Encoder=class{constructor(){this.length=0;this.elements=[]}oidFor(oid){const bOid=oids.get(oid);if(!bOid){throw new errors_js_1.JOSENotSupported("Invalid or unsupported OID")}this.elements.push(bOid);this.length+=bOid.length}zero(){this.elements.push(bTagInteger,buffer_1.Buffer.from([1]),bZero);this.length+=3}one(){this.elements.push(bTagInteger,buffer_1.Buffer.from([1]),buffer_1.Buffer.from([1]));this.length+=3}unsignedInteger(integer){if(integer[0]&128){const len=encodeLength(integer.length+1);this.elements.push(bTagInteger,len,bZero,integer);this.length+=2+len.length+integer.length}else{let i=0;while(integer[i]===0&&(integer[i+1]&128)===0)i++;const len=encodeLength(integer.length-i);this.elements.push(bTagInteger,encodeLength(integer.length-i),integer.slice(i));this.length+=1+len.length+integer.length-i}}octStr(octStr){const len=encodeLength(octStr.length);this.elements.push(bTagOctStr,encodeLength(octStr.length),octStr);this.length+=1+len.length+octStr.length}bitStr(bitS){const len=encodeLength(bitS.length+1);this.elements.push(bTagBitStr,encodeLength(bitS.length+1),bZero,bitS);this.length+=1+len.length+bitS.length+1}add(seq2){this.elements.push(seq2);this.length+=seq2.length}end(tag=bTagSequence){const len=encodeLength(this.length);return buffer_1.Buffer.concat([tag,len,...this.elements],1+len.length+this.length)}};exports2.default=DumbAsn1Encoder}});var require_flags=__commonJS({"node_modules/jose/dist/node/cjs/runtime/flags.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.jwkImport=exports2.jwkExport=exports2.rsaPssParams=exports2.oneShotCallback=void 0;var[major3,minor3]=process.versions.node.split(".").map(str2=>parseInt(str2,10));exports2.oneShotCallback=major3>=16||major3===15&&minor3>=13;exports2.rsaPssParams=!("electron"in process.versions)&&(major3>=17||major3===16&&minor3>=9);exports2.jwkExport=major3>=16||major3===15&&minor3>=9;exports2.jwkImport=major3>=16||major3===15&&minor3>=12}});var require_jwk_to_key=__commonJS({"node_modules/jose/dist/node/cjs/runtime/jwk_to_key.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var buffer_1=require("buffer");var crypto_1=require("crypto");var base64url_js_1=require_base64url();var errors_js_1=require_errors3();var get_named_curve_js_1=require_get_named_curve();var check_modulus_length_js_1=require_check_modulus_length();var asn1_sequence_encoder_js_1=require_asn1_sequence_encoder();var flags_js_1=require_flags();var parse3=jwk=>{if(flags_js_1.jwkImport&&jwk.kty!=="oct"){return jwk.d?(0,crypto_1.createPrivateKey)({format:"jwk",key:jwk}):(0,crypto_1.createPublicKey)({format:"jwk",key:jwk})}switch(jwk.kty){case"oct":{return(0,crypto_1.createSecretKey)((0,base64url_js_1.decode)(jwk.k))}case"RSA":{const enc=new asn1_sequence_encoder_js_1.default;const isPrivate=jwk.d!==void 0;const modulus=buffer_1.Buffer.from(jwk.n,"base64");const exponent=buffer_1.Buffer.from(jwk.e,"base64");if(isPrivate){enc.zero();enc.unsignedInteger(modulus);enc.unsignedInteger(exponent);enc.unsignedInteger(buffer_1.Buffer.from(jwk.d,"base64"));enc.unsignedInteger(buffer_1.Buffer.from(jwk.p,"base64"));enc.unsignedInteger(buffer_1.Buffer.from(jwk.q,"base64"));enc.unsignedInteger(buffer_1.Buffer.from(jwk.dp,"base64"));enc.unsignedInteger(buffer_1.Buffer.from(jwk.dq,"base64"));enc.unsignedInteger(buffer_1.Buffer.from(jwk.qi,"base64"))}else{enc.unsignedInteger(modulus);enc.unsignedInteger(exponent)}const der=enc.end();const createInput={key:der,format:"der",type:"pkcs1"};const keyObject=isPrivate?(0,crypto_1.createPrivateKey)(createInput):(0,crypto_1.createPublicKey)(createInput);(0,check_modulus_length_js_1.setModulusLength)(keyObject,modulus.length<<3);return keyObject}case"EC":{const enc=new asn1_sequence_encoder_js_1.default;const isPrivate=jwk.d!==void 0;const pub=buffer_1.Buffer.concat([buffer_1.Buffer.alloc(1,4),buffer_1.Buffer.from(jwk.x,"base64"),buffer_1.Buffer.from(jwk.y,"base64")]);if(isPrivate){enc.zero();const enc$12=new asn1_sequence_encoder_js_1.default;enc$12.oidFor("ecPublicKey");enc$12.oidFor(jwk.crv);enc.add(enc$12.end());const enc$2=new asn1_sequence_encoder_js_1.default;enc$2.one();enc$2.octStr(buffer_1.Buffer.from(jwk.d,"base64"));const enc$3=new asn1_sequence_encoder_js_1.default;enc$3.bitStr(pub);const f2=enc$3.end(buffer_1.Buffer.from([161]));enc$2.add(f2);const f=enc$2.end();const enc$4=new asn1_sequence_encoder_js_1.default;enc$4.add(f);const f3=enc$4.end(buffer_1.Buffer.from([4]));enc.add(f3);const der2=enc.end();const keyObject2=(0,crypto_1.createPrivateKey)({key:der2,format:"der",type:"pkcs8"});(0,get_named_curve_js_1.setCurve)(keyObject2,jwk.crv);return keyObject2}const enc$1=new asn1_sequence_encoder_js_1.default;enc$1.oidFor("ecPublicKey");enc$1.oidFor(jwk.crv);enc.add(enc$1.end());enc.bitStr(pub);const der=enc.end();const keyObject=(0,crypto_1.createPublicKey)({key:der,format:"der",type:"spki"});(0,get_named_curve_js_1.setCurve)(keyObject,jwk.crv);return keyObject}case"OKP":{const enc=new asn1_sequence_encoder_js_1.default;const isPrivate=jwk.d!==void 0;if(isPrivate){enc.zero();const enc$12=new asn1_sequence_encoder_js_1.default;enc$12.oidFor(jwk.crv);enc.add(enc$12.end());const enc$2=new asn1_sequence_encoder_js_1.default;enc$2.octStr(buffer_1.Buffer.from(jwk.d,"base64"));const f=enc$2.end(buffer_1.Buffer.from([4]));enc.add(f);const der2=enc.end();return(0,crypto_1.createPrivateKey)({key:der2,format:"der",type:"pkcs8"})}const enc$1=new asn1_sequence_encoder_js_1.default;enc$1.oidFor(jwk.crv);enc.add(enc$1.end());enc.bitStr(buffer_1.Buffer.from(jwk.x,"base64"));const der=enc.end();return(0,crypto_1.createPublicKey)({key:der,format:"der",type:"spki"})}default:throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK "kty" (Key Type) Parameter value')}};exports2.default=parse3}});var require_import=__commonJS({"node_modules/jose/dist/node/cjs/key/import.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.importJWK=exports2.importPKCS8=exports2.importX509=exports2.importSPKI=void 0;var base64url_js_1=require_base64url();var asn1_js_1=require_asn1();var jwk_to_key_js_1=require_jwk_to_key();var errors_js_1=require_errors3();var is_object_js_1=require_is_object();async function importSPKI2(spki,alg,options){if(typeof spki!=="string"||spki.indexOf("-----BEGIN PUBLIC KEY-----")!==0){throw new TypeError('"spki" must be SPKI formatted string')}return(0,asn1_js_1.fromSPKI)(spki,alg,options)}exports2.importSPKI=importSPKI2;async function importX5092(x509,alg,options){if(typeof x509!=="string"||x509.indexOf("-----BEGIN CERTIFICATE-----")!==0){throw new TypeError('"x509" must be X.509 formatted string')}return(0,asn1_js_1.fromX509)(x509,alg,options)}exports2.importX509=importX5092;async function importPKCS82(pkcs8,alg,options){if(typeof pkcs8!=="string"||pkcs8.indexOf("-----BEGIN PRIVATE KEY-----")!==0){throw new TypeError('"pkcs8" must be PKCS#8 formatted string')}return(0,asn1_js_1.fromPKCS8)(pkcs8,alg,options)}exports2.importPKCS8=importPKCS82;async function importJWK2(jwk,alg,octAsKeyObject){var _a2;if(!(0,is_object_js_1.default)(jwk)){throw new TypeError("JWK must be an object")}alg||(alg=jwk.alg);switch(jwk.kty){case"oct":if(typeof jwk.k!=="string"||!jwk.k){throw new TypeError('missing "k" (Key Value) Parameter value')}octAsKeyObject!==null&&octAsKeyObject!==void 0?octAsKeyObject:octAsKeyObject=jwk.ext!==true;if(octAsKeyObject){return(0,jwk_to_key_js_1.default)({...jwk,alg,ext:(_a2=jwk.ext)!==null&&_a2!==void 0?_a2:false})}return(0,base64url_js_1.decode)(jwk.k);case"RSA":if(jwk.oth!==void 0){throw new errors_js_1.JOSENotSupported('RSA JWK "oth" (Other Primes Info) Parameter value is not supported')}case"EC":case"OKP":return(0,jwk_to_key_js_1.default)({...jwk,alg});default:throw new errors_js_1.JOSENotSupported('Unsupported "kty" (Key Type) Parameter value')}}exports2.importJWK=importJWK2}});var require_check_key_type=__commonJS({"node_modules/jose/dist/node/cjs/lib/check_key_type.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var symmetricTypeCheck2=(alg,key)=>{if(key instanceof Uint8Array)return;if(!(0,is_key_like_js_1.default)(key)){throw new TypeError((0,invalid_key_input_js_1.withAlg)(alg,key,...is_key_like_js_1.types,"Uint8Array"))}if(key.type!=="secret"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for symmetric algorithms must be of type "secret"`)}};var asymmetricTypeCheck2=(alg,key,usage)=>{if(!(0,is_key_like_js_1.default)(key)){throw new TypeError((0,invalid_key_input_js_1.withAlg)(alg,key,...is_key_like_js_1.types))}if(key.type==="secret"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for asymmetric algorithms must not be of type "secret"`)}if(usage==="sign"&&key.type==="public"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for asymmetric algorithm signing must be of type "private"`)}if(usage==="decrypt"&&key.type==="public"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for asymmetric algorithm decryption must be of type "private"`)}if(key.algorithm&&usage==="verify"&&key.type==="private"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for asymmetric algorithm verifying must be of type "public"`)}if(key.algorithm&&usage==="encrypt"&&key.type==="private"){throw new TypeError(`${is_key_like_js_1.types.join(" or ")} instances for asymmetric algorithm encryption must be of type "public"`)}};var checkKeyType2=(alg,key,usage)=>{const symmetric=alg.startsWith("HS")||alg==="dir"||alg.startsWith("PBES2")||/^A\d{3}(?:GCM)?KW$/.test(alg);if(symmetric){symmetricTypeCheck2(alg,key)}else{asymmetricTypeCheck2(alg,key,usage)}};exports2.default=checkKeyType2}});var require_encrypt=__commonJS({"node_modules/jose/dist/node/cjs/runtime/encrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var check_iv_length_js_1=require_check_iv_length();var check_cek_length_js_1=require_check_cek_length();var buffer_utils_js_1=require_buffer_utils();var cbc_tag_js_1=require_cbc_tag();var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var errors_js_1=require_errors3();var ciphers_js_1=require_ciphers();var is_key_like_js_1=require_is_key_like();function cbcEncrypt2(enc,plaintext,cek,iv,aad){const keySize=parseInt(enc.slice(1,4),10);if((0,is_key_object_js_1.default)(cek)){cek=cek.export()}const encKey=cek.subarray(keySize>>3);const macKey=cek.subarray(0,keySize>>3);const algorithm=`aes-${keySize}-cbc`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`)}const cipher=(0,crypto_1.createCipheriv)(algorithm,encKey,iv);const ciphertext=(0,buffer_utils_js_1.concat)(cipher.update(plaintext),cipher.final());const macSize=parseInt(enc.slice(-3),10);const tag=(0,cbc_tag_js_1.default)(aad,iv,ciphertext,macSize,macKey,keySize);return{ciphertext,tag}}function gcmEncrypt2(enc,plaintext,cek,iv,aad){const keySize=parseInt(enc.slice(1,4),10);const algorithm=`aes-${keySize}-gcm`;if(!(0,ciphers_js_1.default)(algorithm)){throw new errors_js_1.JOSENotSupported(`alg ${enc} is not supported by your javascript runtime`)}const cipher=(0,crypto_1.createCipheriv)(algorithm,cek,iv,{authTagLength:16});if(aad.byteLength){cipher.setAAD(aad,{plaintextLength:plaintext.length})}const ciphertext=cipher.update(plaintext);cipher.final();const tag=cipher.getAuthTag();return{ciphertext,tag}}var encrypt4=(enc,plaintext,cek,iv,aad)=>{let key;if((0,webcrypto_js_1.isCryptoKey)(cek)){(0,crypto_key_js_1.checkEncCryptoKey)(cek,enc,"encrypt");key=crypto_1.KeyObject.from(cek)}else if(cek instanceof Uint8Array||(0,is_key_object_js_1.default)(cek)){key=cek}else{throw new TypeError((0,invalid_key_input_js_1.default)(cek,...is_key_like_js_1.types,"Uint8Array"))}(0,check_cek_length_js_1.default)(enc,key);(0,check_iv_length_js_1.default)(enc,iv);switch(enc){case"A128CBC-HS256":case"A192CBC-HS384":case"A256CBC-HS512":return cbcEncrypt2(enc,plaintext,key,iv,aad);case"A128GCM":case"A192GCM":case"A256GCM":return gcmEncrypt2(enc,plaintext,key,iv,aad);default:throw new errors_js_1.JOSENotSupported("Unsupported JWE Content Encryption Algorithm")}};exports2.default=encrypt4}});var require_aesgcmkw=__commonJS({"node_modules/jose/dist/node/cjs/lib/aesgcmkw.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.unwrap=exports2.wrap=void 0;var encrypt_js_1=require_encrypt();var decrypt_js_1=require_decrypt();var iv_js_1=require_iv();var base64url_js_1=require_base64url();async function wrap4(alg,key,cek,iv){const jweAlgorithm=alg.slice(0,7);iv||(iv=(0,iv_js_1.default)(jweAlgorithm));const{ciphertext:encryptedKey,tag}=await(0,encrypt_js_1.default)(jweAlgorithm,cek,key,iv,new Uint8Array(0));return{encryptedKey,iv:(0,base64url_js_1.encode)(iv),tag:(0,base64url_js_1.encode)(tag)}}exports2.wrap=wrap4;async function unwrap2(alg,key,encryptedKey,iv,tag){const jweAlgorithm=alg.slice(0,7);return(0,decrypt_js_1.default)(jweAlgorithm,key,encryptedKey,iv,tag,new Uint8Array(0))}exports2.unwrap=unwrap2}});var require_decrypt_key_management=__commonJS({"node_modules/jose/dist/node/cjs/lib/decrypt_key_management.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var aeskw_js_1=require_aeskw();var ECDH=require_ecdhes();var pbes2kw_js_1=require_pbes2kw();var rsaes_js_1=require_rsaes();var base64url_js_1=require_base64url();var errors_js_1=require_errors3();var cek_js_1=require_cek();var import_js_1=require_import();var check_key_type_js_1=require_check_key_type();var is_object_js_1=require_is_object();var aesgcmkw_js_1=require_aesgcmkw();async function decryptKeyManagement(alg,key,encryptedKey,joseHeader,options){(0,check_key_type_js_1.default)(alg,key,"decrypt");switch(alg){case"dir":{if(encryptedKey!==void 0)throw new errors_js_1.JWEInvalid("Encountered unexpected JWE Encrypted Key");return key}case"ECDH-ES":if(encryptedKey!==void 0)throw new errors_js_1.JWEInvalid("Encountered unexpected JWE Encrypted Key");case"ECDH-ES+A128KW":case"ECDH-ES+A192KW":case"ECDH-ES+A256KW":{if(!(0,is_object_js_1.default)(joseHeader.epk))throw new errors_js_1.JWEInvalid(`JOSE Header "epk" (Ephemeral Public Key) missing or invalid`);if(!ECDH.ecdhAllowed(key))throw new errors_js_1.JOSENotSupported("ECDH with the provided key is not allowed or not supported by your javascript runtime");const epk=await(0,import_js_1.importJWK)(joseHeader.epk,alg);let partyUInfo;let partyVInfo;if(joseHeader.apu!==void 0){if(typeof joseHeader.apu!=="string")throw new errors_js_1.JWEInvalid(`JOSE Header "apu" (Agreement PartyUInfo) invalid`);try{partyUInfo=(0,base64url_js_1.decode)(joseHeader.apu)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the apu")}}if(joseHeader.apv!==void 0){if(typeof joseHeader.apv!=="string")throw new errors_js_1.JWEInvalid(`JOSE Header "apv" (Agreement PartyVInfo) invalid`);try{partyVInfo=(0,base64url_js_1.decode)(joseHeader.apv)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the apv")}}const sharedSecret=await ECDH.deriveKey(epk,key,alg==="ECDH-ES"?joseHeader.enc:alg,alg==="ECDH-ES"?(0,cek_js_1.bitLength)(joseHeader.enc):parseInt(alg.slice(-5,-2),10),partyUInfo,partyVInfo);if(alg==="ECDH-ES")return sharedSecret;if(encryptedKey===void 0)throw new errors_js_1.JWEInvalid("JWE Encrypted Key missing");return(0,aeskw_js_1.unwrap)(alg.slice(-6),sharedSecret,encryptedKey)}case"RSA1_5":case"RSA-OAEP":case"RSA-OAEP-256":case"RSA-OAEP-384":case"RSA-OAEP-512":{if(encryptedKey===void 0)throw new errors_js_1.JWEInvalid("JWE Encrypted Key missing");return(0,rsaes_js_1.decrypt)(alg,key,encryptedKey)}case"PBES2-HS256+A128KW":case"PBES2-HS384+A192KW":case"PBES2-HS512+A256KW":{if(encryptedKey===void 0)throw new errors_js_1.JWEInvalid("JWE Encrypted Key missing");if(typeof joseHeader.p2c!=="number")throw new errors_js_1.JWEInvalid(`JOSE Header "p2c" (PBES2 Count) missing or invalid`);const p2cLimit=(options===null||options===void 0?void 0:options.maxPBES2Count)||1e4;if(joseHeader.p2c>p2cLimit)throw new errors_js_1.JWEInvalid(`JOSE Header "p2c" (PBES2 Count) out is of acceptable bounds`);if(typeof joseHeader.p2s!=="string")throw new errors_js_1.JWEInvalid(`JOSE Header "p2s" (PBES2 Salt) missing or invalid`);let p2s2;try{p2s2=(0,base64url_js_1.decode)(joseHeader.p2s)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the p2s")}return(0,pbes2kw_js_1.decrypt)(alg,key,encryptedKey,joseHeader.p2c,p2s2)}case"A128KW":case"A192KW":case"A256KW":{if(encryptedKey===void 0)throw new errors_js_1.JWEInvalid("JWE Encrypted Key missing");return(0,aeskw_js_1.unwrap)(alg,key,encryptedKey)}case"A128GCMKW":case"A192GCMKW":case"A256GCMKW":{if(encryptedKey===void 0)throw new errors_js_1.JWEInvalid("JWE Encrypted Key missing");if(typeof joseHeader.iv!=="string")throw new errors_js_1.JWEInvalid(`JOSE Header "iv" (Initialization Vector) missing or invalid`);if(typeof joseHeader.tag!=="string")throw new errors_js_1.JWEInvalid(`JOSE Header "tag" (Authentication Tag) missing or invalid`);let iv;try{iv=(0,base64url_js_1.decode)(joseHeader.iv)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the iv")}let tag;try{tag=(0,base64url_js_1.decode)(joseHeader.tag)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the tag")}return(0,aesgcmkw_js_1.unwrap)(alg,key,encryptedKey,iv,tag)}default:{throw new errors_js_1.JOSENotSupported('Invalid or unsupported "alg" (JWE Algorithm) header value')}}}exports2.default=decryptKeyManagement}});var require_validate_crit=__commonJS({"node_modules/jose/dist/node/cjs/lib/validate_crit.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();function validateCrit2(Err,recognizedDefault,recognizedOption,protectedHeader,joseHeader){if(joseHeader.crit!==void 0&&protectedHeader.crit===void 0){throw new Err('"crit" (Critical) Header Parameter MUST be integrity protected')}if(!protectedHeader||protectedHeader.crit===void 0){return new Set}if(!Array.isArray(protectedHeader.crit)||protectedHeader.crit.length===0||protectedHeader.crit.some(input=>typeof input!=="string"||input.length===0)){throw new Err('"crit" (Critical) Header Parameter MUST be an array of non-empty strings when present')}let recognized;if(recognizedOption!==void 0){recognized=new Map([...Object.entries(recognizedOption),...recognizedDefault.entries()])}else{recognized=recognizedDefault}for(const parameter of protectedHeader.crit){if(!recognized.has(parameter)){throw new errors_js_1.JOSENotSupported(`Extension Header Parameter "${parameter}" is not recognized`)}if(joseHeader[parameter]===void 0){throw new Err(`Extension Header Parameter "${parameter}" is missing`)}else if(recognized.get(parameter)&&protectedHeader[parameter]===void 0){throw new Err(`Extension Header Parameter "${parameter}" MUST be integrity protected`)}}return new Set(protectedHeader.crit)}exports2.default=validateCrit2}});var require_validate_algorithms=__commonJS({"node_modules/jose/dist/node/cjs/lib/validate_algorithms.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var validateAlgorithms=(option,algorithms)=>{if(algorithms!==void 0&&(!Array.isArray(algorithms)||algorithms.some(s=>typeof s!=="string"))){throw new TypeError(`"${option}" option must be an array of strings`)}if(!algorithms){return void 0}return new Set(algorithms)};exports2.default=validateAlgorithms}});var require_decrypt2=__commonJS({"node_modules/jose/dist/node/cjs/jwe/flattened/decrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.flattenedDecrypt=void 0;var base64url_js_1=require_base64url();var decrypt_js_1=require_decrypt();var zlib_js_1=require_zlib();var errors_js_1=require_errors3();var is_disjoint_js_1=require_is_disjoint();var is_object_js_1=require_is_object();var decrypt_key_management_js_1=require_decrypt_key_management();var buffer_utils_js_1=require_buffer_utils();var cek_js_1=require_cek();var validate_crit_js_1=require_validate_crit();var validate_algorithms_js_1=require_validate_algorithms();async function flattenedDecrypt(jwe,key,options){var _a2;if(!(0,is_object_js_1.default)(jwe)){throw new errors_js_1.JWEInvalid("Flattened JWE must be an object")}if(jwe.protected===void 0&&jwe.header===void 0&&jwe.unprotected===void 0){throw new errors_js_1.JWEInvalid("JOSE Header missing")}if(typeof jwe.iv!=="string"){throw new errors_js_1.JWEInvalid("JWE Initialization Vector missing or incorrect type")}if(typeof jwe.ciphertext!=="string"){throw new errors_js_1.JWEInvalid("JWE Ciphertext missing or incorrect type")}if(typeof jwe.tag!=="string"){throw new errors_js_1.JWEInvalid("JWE Authentication Tag missing or incorrect type")}if(jwe.protected!==void 0&&typeof jwe.protected!=="string"){throw new errors_js_1.JWEInvalid("JWE Protected Header incorrect type")}if(jwe.encrypted_key!==void 0&&typeof jwe.encrypted_key!=="string"){throw new errors_js_1.JWEInvalid("JWE Encrypted Key incorrect type")}if(jwe.aad!==void 0&&typeof jwe.aad!=="string"){throw new errors_js_1.JWEInvalid("JWE AAD incorrect type")}if(jwe.header!==void 0&&!(0,is_object_js_1.default)(jwe.header)){throw new errors_js_1.JWEInvalid("JWE Shared Unprotected Header incorrect type")}if(jwe.unprotected!==void 0&&!(0,is_object_js_1.default)(jwe.unprotected)){throw new errors_js_1.JWEInvalid("JWE Per-Recipient Unprotected Header incorrect type")}let parsedProt;if(jwe.protected){try{const protectedHeader2=(0,base64url_js_1.decode)(jwe.protected);parsedProt=JSON.parse(buffer_utils_js_1.decoder.decode(protectedHeader2))}catch{throw new errors_js_1.JWEInvalid("JWE Protected Header is invalid")}}if(!(0,is_disjoint_js_1.default)(parsedProt,jwe.header,jwe.unprotected)){throw new errors_js_1.JWEInvalid("JWE Protected, JWE Unprotected Header, and JWE Per-Recipient Unprotected Header Parameter names must be disjoint")}const joseHeader={...parsedProt,...jwe.header,...jwe.unprotected};(0,validate_crit_js_1.default)(errors_js_1.JWEInvalid,new Map,options===null||options===void 0?void 0:options.crit,parsedProt,joseHeader);if(joseHeader.zip!==void 0){if(!parsedProt||!parsedProt.zip){throw new errors_js_1.JWEInvalid('JWE "zip" (Compression Algorithm) Header MUST be integrity protected')}if(joseHeader.zip!=="DEF"){throw new errors_js_1.JOSENotSupported('Unsupported JWE "zip" (Compression Algorithm) Header Parameter value')}}const{alg,enc}=joseHeader;if(typeof alg!=="string"||!alg){throw new errors_js_1.JWEInvalid("missing JWE Algorithm (alg) in JWE Header")}if(typeof enc!=="string"||!enc){throw new errors_js_1.JWEInvalid("missing JWE Encryption Algorithm (enc) in JWE Header")}const keyManagementAlgorithms=options&&(0,validate_algorithms_js_1.default)("keyManagementAlgorithms",options.keyManagementAlgorithms);const contentEncryptionAlgorithms=options&&(0,validate_algorithms_js_1.default)("contentEncryptionAlgorithms",options.contentEncryptionAlgorithms);if(keyManagementAlgorithms&&!keyManagementAlgorithms.has(alg)){throw new errors_js_1.JOSEAlgNotAllowed('"alg" (Algorithm) Header Parameter not allowed')}if(contentEncryptionAlgorithms&&!contentEncryptionAlgorithms.has(enc)){throw new errors_js_1.JOSEAlgNotAllowed('"enc" (Encryption Algorithm) Header Parameter not allowed')}let encryptedKey;if(jwe.encrypted_key!==void 0){try{encryptedKey=(0,base64url_js_1.decode)(jwe.encrypted_key)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the encrypted_key")}}let resolvedKey=false;if(typeof key==="function"){key=await key(parsedProt,jwe);resolvedKey=true}let cek;try{cek=await(0,decrypt_key_management_js_1.default)(alg,key,encryptedKey,joseHeader,options)}catch(err){if(err instanceof TypeError||err instanceof errors_js_1.JWEInvalid||err instanceof errors_js_1.JOSENotSupported){throw err}cek=(0,cek_js_1.default)(enc)}let iv;let tag;try{iv=(0,base64url_js_1.decode)(jwe.iv)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the iv")}try{tag=(0,base64url_js_1.decode)(jwe.tag)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the tag")}const protectedHeader=buffer_utils_js_1.encoder.encode((_a2=jwe.protected)!==null&&_a2!==void 0?_a2:"");let additionalData;if(jwe.aad!==void 0){additionalData=(0,buffer_utils_js_1.concat)(protectedHeader,buffer_utils_js_1.encoder.encode("."),buffer_utils_js_1.encoder.encode(jwe.aad))}else{additionalData=protectedHeader}let ciphertext;try{ciphertext=(0,base64url_js_1.decode)(jwe.ciphertext)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the ciphertext")}let plaintext=await(0,decrypt_js_1.default)(enc,cek,ciphertext,iv,tag,additionalData);if(joseHeader.zip==="DEF"){plaintext=await((options===null||options===void 0?void 0:options.inflateRaw)||zlib_js_1.inflate)(plaintext)}const result2={plaintext};if(jwe.protected!==void 0){result2.protectedHeader=parsedProt}if(jwe.aad!==void 0){try{result2.additionalAuthenticatedData=(0,base64url_js_1.decode)(jwe.aad)}catch{throw new errors_js_1.JWEInvalid("Failed to base64url decode the aad")}}if(jwe.unprotected!==void 0){result2.sharedUnprotectedHeader=jwe.unprotected}if(jwe.header!==void 0){result2.unprotectedHeader=jwe.header}if(resolvedKey){return{...result2,key}}return result2}exports2.flattenedDecrypt=flattenedDecrypt}});var require_decrypt3=__commonJS({"node_modules/jose/dist/node/cjs/jwe/compact/decrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.compactDecrypt=void 0;var decrypt_js_1=require_decrypt2();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();async function compactDecrypt(jwe,key,options){if(jwe instanceof Uint8Array){jwe=buffer_utils_js_1.decoder.decode(jwe)}if(typeof jwe!=="string"){throw new errors_js_1.JWEInvalid("Compact JWE must be a string or Uint8Array")}const{0:protectedHeader,1:encryptedKey,2:iv,3:ciphertext,4:tag,length}=jwe.split(".");if(length!==5){throw new errors_js_1.JWEInvalid("Invalid Compact JWE")}const decrypted=await(0,decrypt_js_1.flattenedDecrypt)({ciphertext,iv:iv||void 0,protected:protectedHeader||void 0,tag:tag||void 0,encrypted_key:encryptedKey||void 0},key,options);const result2={plaintext:decrypted.plaintext,protectedHeader:decrypted.protectedHeader};if(typeof key==="function"){return{...result2,key:decrypted.key}}return result2}exports2.compactDecrypt=compactDecrypt}});var require_decrypt4=__commonJS({"node_modules/jose/dist/node/cjs/jwe/general/decrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.generalDecrypt=void 0;var decrypt_js_1=require_decrypt2();var errors_js_1=require_errors3();var is_object_js_1=require_is_object();async function generalDecrypt(jwe,key,options){if(!(0,is_object_js_1.default)(jwe)){throw new errors_js_1.JWEInvalid("General JWE must be an object")}if(!Array.isArray(jwe.recipients)||!jwe.recipients.every(is_object_js_1.default)){throw new errors_js_1.JWEInvalid("JWE Recipients missing or incorrect type")}if(!jwe.recipients.length){throw new errors_js_1.JWEInvalid("JWE Recipients has no members")}for(const recipient of jwe.recipients){try{return await(0,decrypt_js_1.flattenedDecrypt)({aad:jwe.aad,ciphertext:jwe.ciphertext,encrypted_key:recipient.encrypted_key,header:recipient.header,iv:jwe.iv,protected:jwe.protected,tag:jwe.tag,unprotected:jwe.unprotected},key,options)}catch{}}throw new errors_js_1.JWEDecryptionFailed}exports2.generalDecrypt=generalDecrypt}});var require_asn1_sequence_decoder=__commonJS({"node_modules/jose/dist/node/cjs/runtime/asn1_sequence_decoder.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var tagInteger2=2;var tagSequence2=48;var Asn1SequenceDecoder2=class{constructor(buffer){if(buffer[0]!==tagSequence2){throw new TypeError}this.buffer=buffer;this.offset=1;const len=this.decodeLength();if(len!==buffer.length-this.offset){throw new TypeError}}decodeLength(){let length=this.buffer[this.offset++];if(length&128){const nBytes=length&~128;length=0;for(let i=0;i<nBytes;i++)length=length<<8|this.buffer[this.offset+i];this.offset+=nBytes}return length}unsignedInteger(){if(this.buffer[this.offset++]!==tagInteger2){throw new TypeError}let length=this.decodeLength();if(this.buffer[this.offset]===0){this.offset++;length--}const result2=this.buffer.slice(this.offset,this.offset+length);this.offset+=length;return result2}end(){if(this.offset!==this.buffer.length){throw new TypeError}}};exports2.default=Asn1SequenceDecoder2}});var require_key_to_jwk=__commonJS({"node_modules/jose/dist/node/cjs/runtime/key_to_jwk.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var base64url_js_1=require_base64url();var asn1_sequence_decoder_js_1=require_asn1_sequence_decoder();var errors_js_1=require_errors3();var get_named_curve_js_1=require_get_named_curve();var webcrypto_js_1=require_webcrypto();var is_key_object_js_1=require_is_key_object();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();var flags_js_1=require_flags();var keyToJWK2=key=>{let keyObject;if((0,webcrypto_js_1.isCryptoKey)(key)){if(!key.extractable){throw new TypeError("CryptoKey is not extractable")}keyObject=crypto_1.KeyObject.from(key)}else if((0,is_key_object_js_1.default)(key)){keyObject=key}else if(key instanceof Uint8Array){return{kty:"oct",k:(0,base64url_js_1.encode)(key)}}else{throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types,"Uint8Array"))}if(flags_js_1.jwkExport){if(keyObject.type!=="secret"&&!["rsa","ec","ed25519","x25519","ed448","x448"].includes(keyObject.asymmetricKeyType)){throw new errors_js_1.JOSENotSupported("Unsupported key asymmetricKeyType")}return keyObject.export({format:"jwk"})}switch(keyObject.type){case"secret":return{kty:"oct",k:(0,base64url_js_1.encode)(keyObject.export())};case"private":case"public":{switch(keyObject.asymmetricKeyType){case"rsa":{const der=keyObject.export({format:"der",type:"pkcs1"});const dec=new asn1_sequence_decoder_js_1.default(der);if(keyObject.type==="private"){dec.unsignedInteger()}const n=(0,base64url_js_1.encode)(dec.unsignedInteger());const e=(0,base64url_js_1.encode)(dec.unsignedInteger());let jwk;if(keyObject.type==="private"){jwk={d:(0,base64url_js_1.encode)(dec.unsignedInteger()),p:(0,base64url_js_1.encode)(dec.unsignedInteger()),q:(0,base64url_js_1.encode)(dec.unsignedInteger()),dp:(0,base64url_js_1.encode)(dec.unsignedInteger()),dq:(0,base64url_js_1.encode)(dec.unsignedInteger()),qi:(0,base64url_js_1.encode)(dec.unsignedInteger())}}dec.end();return{kty:"RSA",n,e,...jwk}}case"ec":{const crv=(0,get_named_curve_js_1.default)(keyObject);let len;let offset;let correction;switch(crv){case"secp256k1":len=64;offset=31+2;correction=-1;break;case"P-256":len=64;offset=34+2;correction=-1;break;case"P-384":len=96;offset=33+2;correction=-3;break;case"P-521":len=132;offset=33+2;correction=-3;break;default:throw new errors_js_1.JOSENotSupported("Unsupported curve")}if(keyObject.type==="public"){const der2=keyObject.export({type:"spki",format:"der"});return{kty:"EC",crv,x:(0,base64url_js_1.encode)(der2.subarray(-len,-len/2)),y:(0,base64url_js_1.encode)(der2.subarray(-len/2))}}const der=keyObject.export({type:"pkcs8",format:"der"});if(der.length<100){offset+=correction}return{...keyToJWK2((0,crypto_1.createPublicKey)(keyObject)),d:(0,base64url_js_1.encode)(der.subarray(offset,offset+len/2))}}case"ed25519":case"x25519":{const crv=(0,get_named_curve_js_1.default)(keyObject);if(keyObject.type==="public"){const der2=keyObject.export({type:"spki",format:"der"});return{kty:"OKP",crv,x:(0,base64url_js_1.encode)(der2.subarray(-32))}}const der=keyObject.export({type:"pkcs8",format:"der"});return{...keyToJWK2((0,crypto_1.createPublicKey)(keyObject)),d:(0,base64url_js_1.encode)(der.subarray(-32))}}case"ed448":case"x448":{const crv=(0,get_named_curve_js_1.default)(keyObject);if(keyObject.type==="public"){const der2=keyObject.export({type:"spki",format:"der"});return{kty:"OKP",crv,x:(0,base64url_js_1.encode)(der2.subarray(crv==="Ed448"?-57:-56))}}const der=keyObject.export({type:"pkcs8",format:"der"});return{...keyToJWK2((0,crypto_1.createPublicKey)(keyObject)),d:(0,base64url_js_1.encode)(der.subarray(crv==="Ed448"?-57:-56))}}default:throw new errors_js_1.JOSENotSupported("Unsupported key asymmetricKeyType")}}default:throw new errors_js_1.JOSENotSupported("Unsupported key type")}};exports2.default=keyToJWK2}});var require_export=__commonJS({"node_modules/jose/dist/node/cjs/key/export.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.exportJWK=exports2.exportPKCS8=exports2.exportSPKI=void 0;var asn1_js_1=require_asn1();var asn1_js_2=require_asn1();var key_to_jwk_js_1=require_key_to_jwk();async function exportSPKI(key){return(0,asn1_js_1.toSPKI)(key)}exports2.exportSPKI=exportSPKI;async function exportPKCS8(key){return(0,asn1_js_2.toPKCS8)(key)}exports2.exportPKCS8=exportPKCS8;async function exportJWK2(key){return(0,key_to_jwk_js_1.default)(key)}exports2.exportJWK=exportJWK2}});var require_encrypt_key_management=__commonJS({"node_modules/jose/dist/node/cjs/lib/encrypt_key_management.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var aeskw_js_1=require_aeskw();var ECDH=require_ecdhes();var pbes2kw_js_1=require_pbes2kw();var rsaes_js_1=require_rsaes();var base64url_js_1=require_base64url();var cek_js_1=require_cek();var errors_js_1=require_errors3();var export_js_1=require_export();var check_key_type_js_1=require_check_key_type();var aesgcmkw_js_1=require_aesgcmkw();async function encryptKeyManagement2(alg,enc,key,providedCek,providedParameters={}){let encryptedKey;let parameters;let cek;(0,check_key_type_js_1.default)(alg,key,"encrypt");switch(alg){case"dir":{cek=key;break}case"ECDH-ES":case"ECDH-ES+A128KW":case"ECDH-ES+A192KW":case"ECDH-ES+A256KW":{if(!ECDH.ecdhAllowed(key)){throw new errors_js_1.JOSENotSupported("ECDH with the provided key is not allowed or not supported by your javascript runtime")}const{apu,apv}=providedParameters;let{epk:ephemeralKey}=providedParameters;ephemeralKey||(ephemeralKey=(await ECDH.generateEpk(key)).privateKey);const{x,y,crv,kty}=await(0,export_js_1.exportJWK)(ephemeralKey);const sharedSecret=await ECDH.deriveKey(key,ephemeralKey,alg==="ECDH-ES"?enc:alg,alg==="ECDH-ES"?(0,cek_js_1.bitLength)(enc):parseInt(alg.slice(-5,-2),10),apu,apv);parameters={epk:{x,crv,kty}};if(kty==="EC")parameters.epk.y=y;if(apu)parameters.apu=(0,base64url_js_1.encode)(apu);if(apv)parameters.apv=(0,base64url_js_1.encode)(apv);if(alg==="ECDH-ES"){cek=sharedSecret;break}cek=providedCek||(0,cek_js_1.default)(enc);const kwAlg=alg.slice(-6);encryptedKey=await(0,aeskw_js_1.wrap)(kwAlg,sharedSecret,cek);break}case"RSA1_5":case"RSA-OAEP":case"RSA-OAEP-256":case"RSA-OAEP-384":case"RSA-OAEP-512":{cek=providedCek||(0,cek_js_1.default)(enc);encryptedKey=await(0,rsaes_js_1.encrypt)(alg,key,cek);break}case"PBES2-HS256+A128KW":case"PBES2-HS384+A192KW":case"PBES2-HS512+A256KW":{cek=providedCek||(0,cek_js_1.default)(enc);const{p2c,p2s:p2s2}=providedParameters;({encryptedKey,...parameters}=await(0,pbes2kw_js_1.encrypt)(alg,key,cek,p2c,p2s2));break}case"A128KW":case"A192KW":case"A256KW":{cek=providedCek||(0,cek_js_1.default)(enc);encryptedKey=await(0,aeskw_js_1.wrap)(alg,key,cek);break}case"A128GCMKW":case"A192GCMKW":case"A256GCMKW":{cek=providedCek||(0,cek_js_1.default)(enc);const{iv}=providedParameters;({encryptedKey,...parameters}=await(0,aesgcmkw_js_1.wrap)(alg,key,cek,iv));break}default:{throw new errors_js_1.JOSENotSupported('Invalid or unsupported "alg" (JWE Algorithm) header value')}}return{cek,encryptedKey,parameters}}exports2.default=encryptKeyManagement2}});var require_encrypt2=__commonJS({"node_modules/jose/dist/node/cjs/jwe/flattened/encrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.FlattenedEncrypt=exports2.unprotected=void 0;var base64url_js_1=require_base64url();var encrypt_js_1=require_encrypt();var zlib_js_1=require_zlib();var iv_js_1=require_iv();var encrypt_key_management_js_1=require_encrypt_key_management();var errors_js_1=require_errors3();var is_disjoint_js_1=require_is_disjoint();var buffer_utils_js_1=require_buffer_utils();var validate_crit_js_1=require_validate_crit();exports2.unprotected=Symbol();var FlattenedEncrypt2=class{constructor(plaintext){if(!(plaintext instanceof Uint8Array)){throw new TypeError("plaintext must be an instance of Uint8Array")}this._plaintext=plaintext}setKeyManagementParameters(parameters){if(this._keyManagementParameters){throw new TypeError("setKeyManagementParameters can only be called once")}this._keyManagementParameters=parameters;return this}setProtectedHeader(protectedHeader){if(this._protectedHeader){throw new TypeError("setProtectedHeader can only be called once")}this._protectedHeader=protectedHeader;return this}setSharedUnprotectedHeader(sharedUnprotectedHeader){if(this._sharedUnprotectedHeader){throw new TypeError("setSharedUnprotectedHeader can only be called once")}this._sharedUnprotectedHeader=sharedUnprotectedHeader;return this}setUnprotectedHeader(unprotectedHeader){if(this._unprotectedHeader){throw new TypeError("setUnprotectedHeader can only be called once")}this._unprotectedHeader=unprotectedHeader;return this}setAdditionalAuthenticatedData(aad){this._aad=aad;return this}setContentEncryptionKey(cek){if(this._cek){throw new TypeError("setContentEncryptionKey can only be called once")}this._cek=cek;return this}setInitializationVector(iv){if(this._iv){throw new TypeError("setInitializationVector can only be called once")}this._iv=iv;return this}async encrypt(key,options){if(!this._protectedHeader&&!this._unprotectedHeader&&!this._sharedUnprotectedHeader){throw new errors_js_1.JWEInvalid("either setProtectedHeader, setUnprotectedHeader, or sharedUnprotectedHeader must be called before #encrypt()")}if(!(0,is_disjoint_js_1.default)(this._protectedHeader,this._unprotectedHeader,this._sharedUnprotectedHeader)){throw new errors_js_1.JWEInvalid("JWE Protected, JWE Shared Unprotected and JWE Per-Recipient Header Parameter names must be disjoint")}const joseHeader={...this._protectedHeader,...this._unprotectedHeader,...this._sharedUnprotectedHeader};(0,validate_crit_js_1.default)(errors_js_1.JWEInvalid,new Map,options===null||options===void 0?void 0:options.crit,this._protectedHeader,joseHeader);if(joseHeader.zip!==void 0){if(!this._protectedHeader||!this._protectedHeader.zip){throw new errors_js_1.JWEInvalid('JWE "zip" (Compression Algorithm) Header MUST be integrity protected')}if(joseHeader.zip!=="DEF"){throw new errors_js_1.JOSENotSupported('Unsupported JWE "zip" (Compression Algorithm) Header Parameter value')}}const{alg,enc}=joseHeader;if(typeof alg!=="string"||!alg){throw new errors_js_1.JWEInvalid('JWE "alg" (Algorithm) Header Parameter missing or invalid')}if(typeof enc!=="string"||!enc){throw new errors_js_1.JWEInvalid('JWE "enc" (Encryption Algorithm) Header Parameter missing or invalid')}let encryptedKey;if(alg==="dir"){if(this._cek){throw new TypeError("setContentEncryptionKey cannot be called when using Direct Encryption")}}else if(alg==="ECDH-ES"){if(this._cek){throw new TypeError("setContentEncryptionKey cannot be called when using Direct Key Agreement")}}let cek;{let parameters;({cek,encryptedKey,parameters}=await(0,encrypt_key_management_js_1.default)(alg,enc,key,this._cek,this._keyManagementParameters));if(parameters){if(options&&exports2.unprotected in options){if(!this._unprotectedHeader){this.setUnprotectedHeader(parameters)}else{this._unprotectedHeader={...this._unprotectedHeader,...parameters}}}else{if(!this._protectedHeader){this.setProtectedHeader(parameters)}else{this._protectedHeader={...this._protectedHeader,...parameters}}}}}this._iv||(this._iv=(0,iv_js_1.default)(enc));let additionalData;let protectedHeader;let aadMember;if(this._protectedHeader){protectedHeader=buffer_utils_js_1.encoder.encode((0,base64url_js_1.encode)(JSON.stringify(this._protectedHeader)))}else{protectedHeader=buffer_utils_js_1.encoder.encode("")}if(this._aad){aadMember=(0,base64url_js_1.encode)(this._aad);additionalData=(0,buffer_utils_js_1.concat)(protectedHeader,buffer_utils_js_1.encoder.encode("."),buffer_utils_js_1.encoder.encode(aadMember))}else{additionalData=protectedHeader}let ciphertext;let tag;if(joseHeader.zip==="DEF"){const deflated=await((options===null||options===void 0?void 0:options.deflateRaw)||zlib_js_1.deflate)(this._plaintext);({ciphertext,tag}=await(0,encrypt_js_1.default)(enc,deflated,cek,this._iv,additionalData))}else{;({ciphertext,tag}=await(0,encrypt_js_1.default)(enc,this._plaintext,cek,this._iv,additionalData))}const jwe={ciphertext:(0,base64url_js_1.encode)(ciphertext),iv:(0,base64url_js_1.encode)(this._iv),tag:(0,base64url_js_1.encode)(tag)};if(encryptedKey){jwe.encrypted_key=(0,base64url_js_1.encode)(encryptedKey)}if(aadMember){jwe.aad=aadMember}if(this._protectedHeader){jwe.protected=buffer_utils_js_1.decoder.decode(protectedHeader)}if(this._sharedUnprotectedHeader){jwe.unprotected=this._sharedUnprotectedHeader}if(this._unprotectedHeader){jwe.header=this._unprotectedHeader}return jwe}};exports2.FlattenedEncrypt=FlattenedEncrypt2}});var require_encrypt3=__commonJS({"node_modules/jose/dist/node/cjs/jwe/general/encrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.GeneralEncrypt=void 0;var encrypt_js_1=require_encrypt2();var errors_js_1=require_errors3();var cek_js_1=require_cek();var is_disjoint_js_1=require_is_disjoint();var encrypt_key_management_js_1=require_encrypt_key_management();var base64url_js_1=require_base64url();var validate_crit_js_1=require_validate_crit();var IndividualRecipient=class{constructor(enc,key,options){this.parent=enc;this.key=key;this.options=options}setUnprotectedHeader(unprotectedHeader){if(this.unprotectedHeader){throw new TypeError("setUnprotectedHeader can only be called once")}this.unprotectedHeader=unprotectedHeader;return this}addRecipient(...args2){return this.parent.addRecipient(...args2)}encrypt(...args2){return this.parent.encrypt(...args2)}done(){return this.parent}};var GeneralEncrypt=class{constructor(plaintext){this._recipients=[];this._plaintext=plaintext}addRecipient(key,options){const recipient=new IndividualRecipient(this,key,{crit:options===null||options===void 0?void 0:options.crit});this._recipients.push(recipient);return recipient}setProtectedHeader(protectedHeader){if(this._protectedHeader){throw new TypeError("setProtectedHeader can only be called once")}this._protectedHeader=protectedHeader;return this}setSharedUnprotectedHeader(sharedUnprotectedHeader){if(this._unprotectedHeader){throw new TypeError("setSharedUnprotectedHeader can only be called once")}this._unprotectedHeader=sharedUnprotectedHeader;return this}setAdditionalAuthenticatedData(aad){this._aad=aad;return this}async encrypt(options){var _a2,_b,_c;if(!this._recipients.length){throw new errors_js_1.JWEInvalid("at least one recipient must be added")}options={deflateRaw:options===null||options===void 0?void 0:options.deflateRaw};if(this._recipients.length===1){const[recipient]=this._recipients;const flattened=await new encrypt_js_1.FlattenedEncrypt(this._plaintext).setAdditionalAuthenticatedData(this._aad).setProtectedHeader(this._protectedHeader).setSharedUnprotectedHeader(this._unprotectedHeader).setUnprotectedHeader(recipient.unprotectedHeader).encrypt(recipient.key,{...recipient.options,...options});let jwe2={ciphertext:flattened.ciphertext,iv:flattened.iv,recipients:[{}],tag:flattened.tag};if(flattened.aad)jwe2.aad=flattened.aad;if(flattened.protected)jwe2.protected=flattened.protected;if(flattened.unprotected)jwe2.unprotected=flattened.unprotected;if(flattened.encrypted_key)jwe2.recipients[0].encrypted_key=flattened.encrypted_key;if(flattened.header)jwe2.recipients[0].header=flattened.header;return jwe2}let enc;for(let i=0;i<this._recipients.length;i++){const recipient=this._recipients[i];if(!(0,is_disjoint_js_1.default)(this._protectedHeader,this._unprotectedHeader,recipient.unprotectedHeader)){throw new errors_js_1.JWEInvalid("JWE Protected, JWE Shared Unprotected and JWE Per-Recipient Header Parameter names must be disjoint")}const joseHeader={...this._protectedHeader,...this._unprotectedHeader,...recipient.unprotectedHeader};const{alg}=joseHeader;if(typeof alg!=="string"||!alg){throw new errors_js_1.JWEInvalid('JWE "alg" (Algorithm) Header Parameter missing or invalid')}if(alg==="dir"||alg==="ECDH-ES"){throw new errors_js_1.JWEInvalid('"dir" and "ECDH-ES" alg may only be used with a single recipient')}if(typeof joseHeader.enc!=="string"||!joseHeader.enc){throw new errors_js_1.JWEInvalid('JWE "enc" (Encryption Algorithm) Header Parameter missing or invalid')}if(!enc){enc=joseHeader.enc}else if(enc!==joseHeader.enc){throw new errors_js_1.JWEInvalid('JWE "enc" (Encryption Algorithm) Header Parameter must be the same for all recipients')}(0,validate_crit_js_1.default)(errors_js_1.JWEInvalid,new Map,recipient.options.crit,this._protectedHeader,joseHeader);if(joseHeader.zip!==void 0){if(!this._protectedHeader||!this._protectedHeader.zip){throw new errors_js_1.JWEInvalid('JWE "zip" (Compression Algorithm) Header MUST be integrity protected')}}}const cek=(0,cek_js_1.default)(enc);let jwe={ciphertext:"",iv:"",recipients:[],tag:""};for(let i=0;i<this._recipients.length;i++){const recipient=this._recipients[i];const target={};jwe.recipients.push(target);const joseHeader={...this._protectedHeader,...this._unprotectedHeader,...recipient.unprotectedHeader};const p2c=joseHeader.alg.startsWith("PBES2")?2048+i:void 0;if(i===0){const flattened=await new encrypt_js_1.FlattenedEncrypt(this._plaintext).setAdditionalAuthenticatedData(this._aad).setContentEncryptionKey(cek).setProtectedHeader(this._protectedHeader).setSharedUnprotectedHeader(this._unprotectedHeader).setUnprotectedHeader(recipient.unprotectedHeader).setKeyManagementParameters({p2c}).encrypt(recipient.key,{...recipient.options,...options,[encrypt_js_1.unprotected]:true});jwe.ciphertext=flattened.ciphertext;jwe.iv=flattened.iv;jwe.tag=flattened.tag;if(flattened.aad)jwe.aad=flattened.aad;if(flattened.protected)jwe.protected=flattened.protected;if(flattened.unprotected)jwe.unprotected=flattened.unprotected;target.encrypted_key=flattened.encrypted_key;if(flattened.header)target.header=flattened.header;continue}const{encryptedKey,parameters}=await(0,encrypt_key_management_js_1.default)(((_a2=recipient.unprotectedHeader)===null||_a2===void 0?void 0:_a2.alg)||((_b=this._protectedHeader)===null||_b===void 0?void 0:_b.alg)||((_c=this._unprotectedHeader)===null||_c===void 0?void 0:_c.alg),enc,recipient.key,cek,{p2c});target.encrypted_key=(0,base64url_js_1.encode)(encryptedKey);if(recipient.unprotectedHeader||parameters)target.header={...recipient.unprotectedHeader,...parameters}}return jwe}};exports2.GeneralEncrypt=GeneralEncrypt}});var require_dsa_digest=__commonJS({"node_modules/jose/dist/node/cjs/runtime/dsa_digest.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();function dsaDigest(alg){switch(alg){case"PS256":case"RS256":case"ES256":case"ES256K":return"sha256";case"PS384":case"RS384":case"ES384":return"sha384";case"PS512":case"RS512":case"ES512":return"sha512";case"EdDSA":return void 0;default:throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`)}}exports2.default=dsaDigest}});var require_node_key=__commonJS({"node_modules/jose/dist/node/cjs/runtime/node_key.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var get_named_curve_js_1=require_get_named_curve();var errors_js_1=require_errors3();var check_modulus_length_js_1=require_check_modulus_length();var flags_js_1=require_flags();var PSS={padding:crypto_1.constants.RSA_PKCS1_PSS_PADDING,saltLength:crypto_1.constants.RSA_PSS_SALTLEN_DIGEST};var ecCurveAlgMap=new Map([["ES256","P-256"],["ES256K","secp256k1"],["ES384","P-384"],["ES512","P-521"]]);function keyForCrypto(alg,key){switch(alg){case"EdDSA":if(!["ed25519","ed448"].includes(key.asymmetricKeyType)){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be ed25519 or ed448")}return key;case"RS256":case"RS384":case"RS512":if(key.asymmetricKeyType!=="rsa"){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be rsa")}(0,check_modulus_length_js_1.default)(key,alg);return key;case(flags_js_1.rsaPssParams&&"PS256"):case(flags_js_1.rsaPssParams&&"PS384"):case(flags_js_1.rsaPssParams&&"PS512"):if(key.asymmetricKeyType==="rsa-pss"){const{hashAlgorithm,mgf1HashAlgorithm,saltLength}=key.asymmetricKeyDetails;const length=parseInt(alg.slice(-3),10);if(hashAlgorithm!==void 0&&(hashAlgorithm!==`sha${length}`||mgf1HashAlgorithm!==hashAlgorithm)){throw new TypeError(`Invalid key for this operation, its RSA-PSS parameters do not meet the requirements of "alg" ${alg}`)}if(saltLength!==void 0&&saltLength>length>>3){throw new TypeError(`Invalid key for this operation, its RSA-PSS parameter saltLength does not meet the requirements of "alg" ${alg}`)}}else if(key.asymmetricKeyType!=="rsa"){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be rsa or rsa-pss")}(0,check_modulus_length_js_1.default)(key,alg);return{key,...PSS};case(!flags_js_1.rsaPssParams&&"PS256"):case(!flags_js_1.rsaPssParams&&"PS384"):case(!flags_js_1.rsaPssParams&&"PS512"):if(key.asymmetricKeyType!=="rsa"){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be rsa")}(0,check_modulus_length_js_1.default)(key,alg);return{key,...PSS};case"ES256":case"ES256K":case"ES384":case"ES512":{if(key.asymmetricKeyType!=="ec"){throw new TypeError("Invalid key for this operation, its asymmetricKeyType must be ec")}const actual=(0,get_named_curve_js_1.default)(key);const expected=ecCurveAlgMap.get(alg);if(actual!==expected){throw new TypeError(`Invalid key curve for the algorithm, its curve must be ${expected}, got ${actual}`)}return{dsaEncoding:"ieee-p1363",key}}default:throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`)}}exports2.default=keyForCrypto}});var require_hmac_digest=__commonJS({"node_modules/jose/dist/node/cjs/runtime/hmac_digest.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();function hmacDigest(alg){switch(alg){case"HS256":return"sha256";case"HS384":return"sha384";case"HS512":return"sha512";default:throw new errors_js_1.JOSENotSupported(`alg ${alg} is not supported either by JOSE or your javascript runtime`)}}exports2.default=hmacDigest}});var require_get_sign_verify_key=__commonJS({"node_modules/jose/dist/node/cjs/runtime/get_sign_verify_key.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto_1=require("crypto");var webcrypto_js_1=require_webcrypto();var crypto_key_js_1=require_crypto_key();var invalid_key_input_js_1=require_invalid_key_input();var is_key_like_js_1=require_is_key_like();function getSignVerifyKey(alg,key,usage){if(key instanceof Uint8Array){if(!alg.startsWith("HS")){throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types))}return(0,crypto_1.createSecretKey)(key)}if(key instanceof crypto_1.KeyObject){return key}if((0,webcrypto_js_1.isCryptoKey)(key)){(0,crypto_key_js_1.checkSigCryptoKey)(key,alg,usage);return crypto_1.KeyObject.from(key)}throw new TypeError((0,invalid_key_input_js_1.default)(key,...is_key_like_js_1.types,"Uint8Array"))}exports2.default=getSignVerifyKey}});var require_sign=__commonJS({"node_modules/jose/dist/node/cjs/runtime/sign.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto5=require("crypto");var util_1=require("util");var dsa_digest_js_1=require_dsa_digest();var hmac_digest_js_1=require_hmac_digest();var node_key_js_1=require_node_key();var get_sign_verify_key_js_1=require_get_sign_verify_key();var oneShotSign;if(crypto5.sign.length>3){oneShotSign=(0,util_1.promisify)(crypto5.sign)}else{oneShotSign=crypto5.sign}var sign=async(alg,key,data)=>{const keyObject=(0,get_sign_verify_key_js_1.default)(alg,key,"sign");if(alg.startsWith("HS")){const hmac=crypto5.createHmac((0,hmac_digest_js_1.default)(alg),keyObject);hmac.update(data);return hmac.digest()}return oneShotSign((0,dsa_digest_js_1.default)(alg),data,(0,node_key_js_1.default)(alg,keyObject))};exports2.default=sign}});var require_verify=__commonJS({"node_modules/jose/dist/node/cjs/runtime/verify.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var crypto5=require("crypto");var util_1=require("util");var dsa_digest_js_1=require_dsa_digest();var node_key_js_1=require_node_key();var sign_js_1=require_sign();var get_sign_verify_key_js_1=require_get_sign_verify_key();var flags_js_1=require_flags();var oneShotVerify;if(crypto5.verify.length>4&&flags_js_1.oneShotCallback){oneShotVerify=(0,util_1.promisify)(crypto5.verify)}else{oneShotVerify=crypto5.verify}var verify=async(alg,key,signature,data)=>{const keyObject=(0,get_sign_verify_key_js_1.default)(alg,key,"verify");if(alg.startsWith("HS")){const expected=await(0,sign_js_1.default)(alg,keyObject,data);const actual=signature;try{return crypto5.timingSafeEqual(actual,expected)}catch{return false}}const algorithm=(0,dsa_digest_js_1.default)(alg);const keyInput=(0,node_key_js_1.default)(alg,keyObject);try{return await oneShotVerify(algorithm,data,keyInput,signature)}catch{return false}};exports2.default=verify}});var require_verify2=__commonJS({"node_modules/jose/dist/node/cjs/jws/flattened/verify.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.flattenedVerify=void 0;var base64url_js_1=require_base64url();var verify_js_1=require_verify();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var is_disjoint_js_1=require_is_disjoint();var is_object_js_1=require_is_object();var check_key_type_js_1=require_check_key_type();var validate_crit_js_1=require_validate_crit();var validate_algorithms_js_1=require_validate_algorithms();async function flattenedVerify(jws,key,options){var _a2;if(!(0,is_object_js_1.default)(jws)){throw new errors_js_1.JWSInvalid("Flattened JWS must be an object")}if(jws.protected===void 0&&jws.header===void 0){throw new errors_js_1.JWSInvalid('Flattened JWS must have either of the "protected" or "header" members')}if(jws.protected!==void 0&&typeof jws.protected!=="string"){throw new errors_js_1.JWSInvalid("JWS Protected Header incorrect type")}if(jws.payload===void 0){throw new errors_js_1.JWSInvalid("JWS Payload missing")}if(typeof jws.signature!=="string"){throw new errors_js_1.JWSInvalid("JWS Signature missing or incorrect type")}if(jws.header!==void 0&&!(0,is_object_js_1.default)(jws.header)){throw new errors_js_1.JWSInvalid("JWS Unprotected Header incorrect type")}let parsedProt={};if(jws.protected){try{const protectedHeader=(0,base64url_js_1.decode)(jws.protected);parsedProt=JSON.parse(buffer_utils_js_1.decoder.decode(protectedHeader))}catch{throw new errors_js_1.JWSInvalid("JWS Protected Header is invalid")}}if(!(0,is_disjoint_js_1.default)(parsedProt,jws.header)){throw new errors_js_1.JWSInvalid("JWS Protected and JWS Unprotected Header Parameter names must be disjoint")}const joseHeader={...parsedProt,...jws.header};const extensions2=(0,validate_crit_js_1.default)(errors_js_1.JWSInvalid,new Map([["b64",true]]),options===null||options===void 0?void 0:options.crit,parsedProt,joseHeader);let b64=true;if(extensions2.has("b64")){b64=parsedProt.b64;if(typeof b64!=="boolean"){throw new errors_js_1.JWSInvalid('The "b64" (base64url-encode payload) Header Parameter must be a boolean')}}const{alg}=joseHeader;if(typeof alg!=="string"||!alg){throw new errors_js_1.JWSInvalid('JWS "alg" (Algorithm) Header Parameter missing or invalid')}const algorithms=options&&(0,validate_algorithms_js_1.default)("algorithms",options.algorithms);if(algorithms&&!algorithms.has(alg)){throw new errors_js_1.JOSEAlgNotAllowed('"alg" (Algorithm) Header Parameter not allowed')}if(b64){if(typeof jws.payload!=="string"){throw new errors_js_1.JWSInvalid("JWS Payload must be a string")}}else if(typeof jws.payload!=="string"&&!(jws.payload instanceof Uint8Array)){throw new errors_js_1.JWSInvalid("JWS Payload must be a string or an Uint8Array instance")}let resolvedKey=false;if(typeof key==="function"){key=await key(parsedProt,jws);resolvedKey=true}(0,check_key_type_js_1.default)(alg,key,"verify");const data=(0,buffer_utils_js_1.concat)(buffer_utils_js_1.encoder.encode((_a2=jws.protected)!==null&&_a2!==void 0?_a2:""),buffer_utils_js_1.encoder.encode("."),typeof jws.payload==="string"?buffer_utils_js_1.encoder.encode(jws.payload):jws.payload);let signature;try{signature=(0,base64url_js_1.decode)(jws.signature)}catch{throw new errors_js_1.JWSInvalid("Failed to base64url decode the signature")}const verified=await(0,verify_js_1.default)(alg,key,signature,data);if(!verified){throw new errors_js_1.JWSSignatureVerificationFailed}let payload;if(b64){try{payload=(0,base64url_js_1.decode)(jws.payload)}catch{throw new errors_js_1.JWSInvalid("Failed to base64url decode the payload")}}else if(typeof jws.payload==="string"){payload=buffer_utils_js_1.encoder.encode(jws.payload)}else{payload=jws.payload}const result2={payload};if(jws.protected!==void 0){result2.protectedHeader=parsedProt}if(jws.header!==void 0){result2.unprotectedHeader=jws.header}if(resolvedKey){return{...result2,key}}return result2}exports2.flattenedVerify=flattenedVerify}});var require_verify3=__commonJS({"node_modules/jose/dist/node/cjs/jws/compact/verify.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.compactVerify=void 0;var verify_js_1=require_verify2();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();async function compactVerify(jws,key,options){if(jws instanceof Uint8Array){jws=buffer_utils_js_1.decoder.decode(jws)}if(typeof jws!=="string"){throw new errors_js_1.JWSInvalid("Compact JWS must be a string or Uint8Array")}const{0:protectedHeader,1:payload,2:signature,length}=jws.split(".");if(length!==3){throw new errors_js_1.JWSInvalid("Invalid Compact JWS")}const verified=await(0,verify_js_1.flattenedVerify)({payload,protected:protectedHeader,signature},key,options);const result2={payload:verified.payload,protectedHeader:verified.protectedHeader};if(typeof key==="function"){return{...result2,key:verified.key}}return result2}exports2.compactVerify=compactVerify}});var require_verify4=__commonJS({"node_modules/jose/dist/node/cjs/jws/general/verify.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.generalVerify=void 0;var verify_js_1=require_verify2();var errors_js_1=require_errors3();var is_object_js_1=require_is_object();async function generalVerify(jws,key,options){if(!(0,is_object_js_1.default)(jws)){throw new errors_js_1.JWSInvalid("General JWS must be an object")}if(!Array.isArray(jws.signatures)||!jws.signatures.every(is_object_js_1.default)){throw new errors_js_1.JWSInvalid("JWS Signatures missing or incorrect type")}for(const signature of jws.signatures){try{return await(0,verify_js_1.flattenedVerify)({header:signature.header,payload:jws.payload,protected:signature.protected,signature:signature.signature},key,options)}catch{}}throw new errors_js_1.JWSSignatureVerificationFailed}exports2.generalVerify=generalVerify}});var require_epoch=__commonJS({"node_modules/jose/dist/node/cjs/lib/epoch.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.default=date=>Math.floor(date.getTime()/1e3)}});var require_secs=__commonJS({"node_modules/jose/dist/node/cjs/lib/secs.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var minute=60;var hour=minute*60;var day=hour*24;var week=day*7;var year=day*365.25;var REGEX=/^(\d+|\d+\.\d+) ?(seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)$/i;exports2.default=str2=>{const matched=REGEX.exec(str2);if(!matched){throw new TypeError("Invalid time period format")}const value=parseFloat(matched[1]);const unit=matched[2].toLowerCase();switch(unit){case"sec":case"secs":case"second":case"seconds":case"s":return Math.round(value);case"minute":case"minutes":case"min":case"mins":case"m":return Math.round(value*minute);case"hour":case"hours":case"hr":case"hrs":case"h":return Math.round(value*hour);case"day":case"days":case"d":return Math.round(value*day);case"week":case"weeks":case"w":return Math.round(value*week);default:return Math.round(value*year)}}}});var require_jwt_claims_set=__commonJS({"node_modules/jose/dist/node/cjs/lib/jwt_claims_set.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var epoch_js_1=require_epoch();var secs_js_1=require_secs();var is_object_js_1=require_is_object();var normalizeTyp=value=>value.toLowerCase().replace(/^application\//,"");var checkAudiencePresence=(audPayload,audOption)=>{if(typeof audPayload==="string"){return audOption.includes(audPayload)}if(Array.isArray(audPayload)){return audOption.some(Set.prototype.has.bind(new Set(audPayload)))}return false};exports2.default=(protectedHeader,encodedPayload,options={})=>{const{typ}=options;if(typ&&(typeof protectedHeader.typ!=="string"||normalizeTyp(protectedHeader.typ)!==normalizeTyp(typ))){throw new errors_js_1.JWTClaimValidationFailed('unexpected "typ" JWT header value',"typ","check_failed")}let payload;try{payload=JSON.parse(buffer_utils_js_1.decoder.decode(encodedPayload))}catch{}if(!(0,is_object_js_1.default)(payload)){throw new errors_js_1.JWTInvalid("JWT Claims Set must be a top-level JSON object")}const{requiredClaims=[],issuer,subject,audience,maxTokenAge}=options;if(maxTokenAge!==void 0)requiredClaims.push("iat");if(audience!==void 0)requiredClaims.push("aud");if(subject!==void 0)requiredClaims.push("sub");if(issuer!==void 0)requiredClaims.push("iss");for(const claim of new Set(requiredClaims.reverse())){if(!(claim in payload)){throw new errors_js_1.JWTClaimValidationFailed(`missing required "${claim}" claim`,claim,"missing")}}if(issuer&&!(Array.isArray(issuer)?issuer:[issuer]).includes(payload.iss)){throw new errors_js_1.JWTClaimValidationFailed('unexpected "iss" claim value',"iss","check_failed")}if(subject&&payload.sub!==subject){throw new errors_js_1.JWTClaimValidationFailed('unexpected "sub" claim value',"sub","check_failed")}if(audience&&!checkAudiencePresence(payload.aud,typeof audience==="string"?[audience]:audience)){throw new errors_js_1.JWTClaimValidationFailed('unexpected "aud" claim value',"aud","check_failed")}let tolerance;switch(typeof options.clockTolerance){case"string":tolerance=(0,secs_js_1.default)(options.clockTolerance);break;case"number":tolerance=options.clockTolerance;break;case"undefined":tolerance=0;break;default:throw new TypeError("Invalid clockTolerance option type")}const{currentDate}=options;const now3=(0,epoch_js_1.default)(currentDate||new Date);if((payload.iat!==void 0||maxTokenAge)&&typeof payload.iat!=="number"){throw new errors_js_1.JWTClaimValidationFailed('"iat" claim must be a number',"iat","invalid")}if(payload.nbf!==void 0){if(typeof payload.nbf!=="number"){throw new errors_js_1.JWTClaimValidationFailed('"nbf" claim must be a number',"nbf","invalid")}if(payload.nbf>now3+tolerance){throw new errors_js_1.JWTClaimValidationFailed('"nbf" claim timestamp check failed',"nbf","check_failed")}}if(payload.exp!==void 0){if(typeof payload.exp!=="number"){throw new errors_js_1.JWTClaimValidationFailed('"exp" claim must be a number',"exp","invalid")}if(payload.exp<=now3-tolerance){throw new errors_js_1.JWTExpired('"exp" claim timestamp check failed',"exp","check_failed")}}if(maxTokenAge){const age=now3-payload.iat;const max3=typeof maxTokenAge==="number"?maxTokenAge:(0,secs_js_1.default)(maxTokenAge);if(age-tolerance>max3){throw new errors_js_1.JWTExpired('"iat" claim timestamp check failed (too far in the past)',"iat","check_failed")}if(age<0-tolerance){throw new errors_js_1.JWTClaimValidationFailed('"iat" claim timestamp check failed (it should be in the past)',"iat","check_failed")}}return payload}}});var require_verify5=__commonJS({"node_modules/jose/dist/node/cjs/jwt/verify.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.jwtVerify=void 0;var verify_js_1=require_verify3();var jwt_claims_set_js_1=require_jwt_claims_set();var errors_js_1=require_errors3();async function jwtVerify(jwt,key,options){var _a2;const verified=await(0,verify_js_1.compactVerify)(jwt,key,options);if(((_a2=verified.protectedHeader.crit)===null||_a2===void 0?void 0:_a2.includes("b64"))&&verified.protectedHeader.b64===false){throw new errors_js_1.JWTInvalid("JWTs MUST NOT use unencoded payload")}const payload=(0,jwt_claims_set_js_1.default)(verified.protectedHeader,verified.payload,options);const result2={payload,protectedHeader:verified.protectedHeader};if(typeof key==="function"){return{...result2,key:verified.key}}return result2}exports2.jwtVerify=jwtVerify}});var require_decrypt5=__commonJS({"node_modules/jose/dist/node/cjs/jwt/decrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.jwtDecrypt=void 0;var decrypt_js_1=require_decrypt3();var jwt_claims_set_js_1=require_jwt_claims_set();var errors_js_1=require_errors3();async function jwtDecrypt(jwt,key,options){const decrypted=await(0,decrypt_js_1.compactDecrypt)(jwt,key,options);const payload=(0,jwt_claims_set_js_1.default)(decrypted.protectedHeader,decrypted.plaintext,options);const{protectedHeader}=decrypted;if(protectedHeader.iss!==void 0&&protectedHeader.iss!==payload.iss){throw new errors_js_1.JWTClaimValidationFailed('replicated "iss" claim header parameter mismatch',"iss","mismatch")}if(protectedHeader.sub!==void 0&&protectedHeader.sub!==payload.sub){throw new errors_js_1.JWTClaimValidationFailed('replicated "sub" claim header parameter mismatch',"sub","mismatch")}if(protectedHeader.aud!==void 0&&JSON.stringify(protectedHeader.aud)!==JSON.stringify(payload.aud)){throw new errors_js_1.JWTClaimValidationFailed('replicated "aud" claim header parameter mismatch',"aud","mismatch")}const result2={payload,protectedHeader};if(typeof key==="function"){return{...result2,key:decrypted.key}}return result2}exports2.jwtDecrypt=jwtDecrypt}});var require_encrypt4=__commonJS({"node_modules/jose/dist/node/cjs/jwe/compact/encrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.CompactEncrypt=void 0;var encrypt_js_1=require_encrypt2();var CompactEncrypt2=class{constructor(plaintext){this._flattened=new encrypt_js_1.FlattenedEncrypt(plaintext)}setContentEncryptionKey(cek){this._flattened.setContentEncryptionKey(cek);return this}setInitializationVector(iv){this._flattened.setInitializationVector(iv);return this}setProtectedHeader(protectedHeader){this._flattened.setProtectedHeader(protectedHeader);return this}setKeyManagementParameters(parameters){this._flattened.setKeyManagementParameters(parameters);return this}async encrypt(key,options){const jwe=await this._flattened.encrypt(key,options);return[jwe.protected,jwe.encrypted_key,jwe.iv,jwe.ciphertext,jwe.tag].join(".")}};exports2.CompactEncrypt=CompactEncrypt2}});var require_sign2=__commonJS({"node_modules/jose/dist/node/cjs/jws/flattened/sign.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.FlattenedSign=void 0;var base64url_js_1=require_base64url();var sign_js_1=require_sign();var is_disjoint_js_1=require_is_disjoint();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var check_key_type_js_1=require_check_key_type();var validate_crit_js_1=require_validate_crit();var FlattenedSign=class{constructor(payload){if(!(payload instanceof Uint8Array)){throw new TypeError("payload must be an instance of Uint8Array")}this._payload=payload}setProtectedHeader(protectedHeader){if(this._protectedHeader){throw new TypeError("setProtectedHeader can only be called once")}this._protectedHeader=protectedHeader;return this}setUnprotectedHeader(unprotectedHeader){if(this._unprotectedHeader){throw new TypeError("setUnprotectedHeader can only be called once")}this._unprotectedHeader=unprotectedHeader;return this}async sign(key,options){if(!this._protectedHeader&&!this._unprotectedHeader){throw new errors_js_1.JWSInvalid("either setProtectedHeader or setUnprotectedHeader must be called before #sign()")}if(!(0,is_disjoint_js_1.default)(this._protectedHeader,this._unprotectedHeader)){throw new errors_js_1.JWSInvalid("JWS Protected and JWS Unprotected Header Parameter names must be disjoint")}const joseHeader={...this._protectedHeader,...this._unprotectedHeader};const extensions2=(0,validate_crit_js_1.default)(errors_js_1.JWSInvalid,new Map([["b64",true]]),options===null||options===void 0?void 0:options.crit,this._protectedHeader,joseHeader);let b64=true;if(extensions2.has("b64")){b64=this._protectedHeader.b64;if(typeof b64!=="boolean"){throw new errors_js_1.JWSInvalid('The "b64" (base64url-encode payload) Header Parameter must be a boolean')}}const{alg}=joseHeader;if(typeof alg!=="string"||!alg){throw new errors_js_1.JWSInvalid('JWS "alg" (Algorithm) Header Parameter missing or invalid')}(0,check_key_type_js_1.default)(alg,key,"sign");let payload=this._payload;if(b64){payload=buffer_utils_js_1.encoder.encode((0,base64url_js_1.encode)(payload))}let protectedHeader;if(this._protectedHeader){protectedHeader=buffer_utils_js_1.encoder.encode((0,base64url_js_1.encode)(JSON.stringify(this._protectedHeader)))}else{protectedHeader=buffer_utils_js_1.encoder.encode("")}const data=(0,buffer_utils_js_1.concat)(protectedHeader,buffer_utils_js_1.encoder.encode("."),payload);const signature=await(0,sign_js_1.default)(alg,key,data);const jws={signature:(0,base64url_js_1.encode)(signature),payload:""};if(b64){jws.payload=buffer_utils_js_1.decoder.decode(payload)}if(this._unprotectedHeader){jws.header=this._unprotectedHeader}if(this._protectedHeader){jws.protected=buffer_utils_js_1.decoder.decode(protectedHeader)}return jws}};exports2.FlattenedSign=FlattenedSign}});var require_sign3=__commonJS({"node_modules/jose/dist/node/cjs/jws/compact/sign.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.CompactSign=void 0;var sign_js_1=require_sign2();var CompactSign=class{constructor(payload){this._flattened=new sign_js_1.FlattenedSign(payload)}setProtectedHeader(protectedHeader){this._flattened.setProtectedHeader(protectedHeader);return this}async sign(key,options){const jws=await this._flattened.sign(key,options);if(jws.payload===void 0){throw new TypeError("use the flattened module for creating JWS with b64: false")}return`${jws.protected}.${jws.payload}.${jws.signature}`}};exports2.CompactSign=CompactSign}});var require_sign4=__commonJS({"node_modules/jose/dist/node/cjs/jws/general/sign.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.GeneralSign=void 0;var sign_js_1=require_sign2();var errors_js_1=require_errors3();var IndividualSignature=class{constructor(sig,key,options){this.parent=sig;this.key=key;this.options=options}setProtectedHeader(protectedHeader){if(this.protectedHeader){throw new TypeError("setProtectedHeader can only be called once")}this.protectedHeader=protectedHeader;return this}setUnprotectedHeader(unprotectedHeader){if(this.unprotectedHeader){throw new TypeError("setUnprotectedHeader can only be called once")}this.unprotectedHeader=unprotectedHeader;return this}addSignature(...args2){return this.parent.addSignature(...args2)}sign(...args2){return this.parent.sign(...args2)}done(){return this.parent}};var GeneralSign=class{constructor(payload){this._signatures=[];this._payload=payload}addSignature(key,options){const signature=new IndividualSignature(this,key,options);this._signatures.push(signature);return signature}async sign(){if(!this._signatures.length){throw new errors_js_1.JWSInvalid("at least one signature must be added")}const jws={signatures:[],payload:""};for(let i=0;i<this._signatures.length;i++){const signature=this._signatures[i];const flattened=new sign_js_1.FlattenedSign(this._payload);flattened.setProtectedHeader(signature.protectedHeader);flattened.setUnprotectedHeader(signature.unprotectedHeader);const{payload,...rest2}=await flattened.sign(signature.key,signature.options);if(i===0){jws.payload=payload}else if(jws.payload!==payload){throw new errors_js_1.JWSInvalid("inconsistent use of JWS Unencoded Payload (RFC7797)")}jws.signatures.push(rest2)}return jws}};exports2.GeneralSign=GeneralSign}});var require_produce=__commonJS({"node_modules/jose/dist/node/cjs/jwt/produce.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ProduceJWT=void 0;var epoch_js_1=require_epoch();var is_object_js_1=require_is_object();var secs_js_1=require_secs();var ProduceJWT=class{constructor(payload){if(!(0,is_object_js_1.default)(payload)){throw new TypeError("JWT Claims Set MUST be an object")}this._payload=payload}setIssuer(issuer){this._payload={...this._payload,iss:issuer};return this}setSubject(subject){this._payload={...this._payload,sub:subject};return this}setAudience(audience){this._payload={...this._payload,aud:audience};return this}setJti(jwtId){this._payload={...this._payload,jti:jwtId};return this}setNotBefore(input){if(typeof input==="number"){this._payload={...this._payload,nbf:input}}else{this._payload={...this._payload,nbf:(0,epoch_js_1.default)(new Date)+(0,secs_js_1.default)(input)}}return this}setExpirationTime(input){if(typeof input==="number"){this._payload={...this._payload,exp:input}}else{this._payload={...this._payload,exp:(0,epoch_js_1.default)(new Date)+(0,secs_js_1.default)(input)}}return this}setIssuedAt(input){if(typeof input==="undefined"){this._payload={...this._payload,iat:(0,epoch_js_1.default)(new Date)}}else{this._payload={...this._payload,iat:input}}return this}};exports2.ProduceJWT=ProduceJWT}});var require_sign5=__commonJS({"node_modules/jose/dist/node/cjs/jwt/sign.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SignJWT=void 0;var sign_js_1=require_sign3();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var produce_js_1=require_produce();var SignJWT=class extends produce_js_1.ProduceJWT{setProtectedHeader(protectedHeader){this._protectedHeader=protectedHeader;return this}async sign(key,options){var _a2;const sig=new sign_js_1.CompactSign(buffer_utils_js_1.encoder.encode(JSON.stringify(this._payload)));sig.setProtectedHeader(this._protectedHeader);if(Array.isArray((_a2=this._protectedHeader)===null||_a2===void 0?void 0:_a2.crit)&&this._protectedHeader.crit.includes("b64")&&this._protectedHeader.b64===false){throw new errors_js_1.JWTInvalid("JWTs MUST NOT use unencoded payload")}return sig.sign(key,options)}};exports2.SignJWT=SignJWT}});var require_encrypt5=__commonJS({"node_modules/jose/dist/node/cjs/jwt/encrypt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.EncryptJWT=void 0;var encrypt_js_1=require_encrypt4();var buffer_utils_js_1=require_buffer_utils();var produce_js_1=require_produce();var EncryptJWT=class extends produce_js_1.ProduceJWT{setProtectedHeader(protectedHeader){if(this._protectedHeader){throw new TypeError("setProtectedHeader can only be called once")}this._protectedHeader=protectedHeader;return this}setKeyManagementParameters(parameters){if(this._keyManagementParameters){throw new TypeError("setKeyManagementParameters can only be called once")}this._keyManagementParameters=parameters;return this}setContentEncryptionKey(cek){if(this._cek){throw new TypeError("setContentEncryptionKey can only be called once")}this._cek=cek;return this}setInitializationVector(iv){if(this._iv){throw new TypeError("setInitializationVector can only be called once")}this._iv=iv;return this}replicateIssuerAsHeader(){this._replicateIssuerAsHeader=true;return this}replicateSubjectAsHeader(){this._replicateSubjectAsHeader=true;return this}replicateAudienceAsHeader(){this._replicateAudienceAsHeader=true;return this}async encrypt(key,options){const enc=new encrypt_js_1.CompactEncrypt(buffer_utils_js_1.encoder.encode(JSON.stringify(this._payload)));if(this._replicateIssuerAsHeader){this._protectedHeader={...this._protectedHeader,iss:this._payload.iss}}if(this._replicateSubjectAsHeader){this._protectedHeader={...this._protectedHeader,sub:this._payload.sub}}if(this._replicateAudienceAsHeader){this._protectedHeader={...this._protectedHeader,aud:this._payload.aud}}enc.setProtectedHeader(this._protectedHeader);if(this._iv){enc.setInitializationVector(this._iv)}if(this._cek){enc.setContentEncryptionKey(this._cek)}if(this._keyManagementParameters){enc.setKeyManagementParameters(this._keyManagementParameters)}return enc.encrypt(key,options)}};exports2.EncryptJWT=EncryptJWT}});var require_thumbprint=__commonJS({"node_modules/jose/dist/node/cjs/jwk/thumbprint.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.calculateJwkThumbprintUri=exports2.calculateJwkThumbprint=void 0;var digest_js_1=require_digest();var base64url_js_1=require_base64url();var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var is_object_js_1=require_is_object();var check=(value,description)=>{if(typeof value!=="string"||!value){throw new errors_js_1.JWKInvalid(`${description} missing or invalid`)}};async function calculateJwkThumbprint(jwk,digestAlgorithm){if(!(0,is_object_js_1.default)(jwk)){throw new TypeError("JWK must be an object")}digestAlgorithm!==null&&digestAlgorithm!==void 0?digestAlgorithm:digestAlgorithm="sha256";if(digestAlgorithm!=="sha256"&&digestAlgorithm!=="sha384"&&digestAlgorithm!=="sha512"){throw new TypeError('digestAlgorithm must one of "sha256", "sha384", or "sha512"')}let components;switch(jwk.kty){case"EC":check(jwk.crv,'"crv" (Curve) Parameter');check(jwk.x,'"x" (X Coordinate) Parameter');check(jwk.y,'"y" (Y Coordinate) Parameter');components={crv:jwk.crv,kty:jwk.kty,x:jwk.x,y:jwk.y};break;case"OKP":check(jwk.crv,'"crv" (Subtype of Key Pair) Parameter');check(jwk.x,'"x" (Public Key) Parameter');components={crv:jwk.crv,kty:jwk.kty,x:jwk.x};break;case"RSA":check(jwk.e,'"e" (Exponent) Parameter');check(jwk.n,'"n" (Modulus) Parameter');components={e:jwk.e,kty:jwk.kty,n:jwk.n};break;case"oct":check(jwk.k,'"k" (Key Value) Parameter');components={k:jwk.k,kty:jwk.kty};break;default:throw new errors_js_1.JOSENotSupported('"kty" (Key Type) Parameter missing or unsupported')}const data=buffer_utils_js_1.encoder.encode(JSON.stringify(components));return(0,base64url_js_1.encode)(await(0,digest_js_1.default)(digestAlgorithm,data))}exports2.calculateJwkThumbprint=calculateJwkThumbprint;async function calculateJwkThumbprintUri(jwk,digestAlgorithm){digestAlgorithm!==null&&digestAlgorithm!==void 0?digestAlgorithm:digestAlgorithm="sha256";const thumbprint=await calculateJwkThumbprint(jwk,digestAlgorithm);return`urn:ietf:params:oauth:jwk-thumbprint:sha-${digestAlgorithm.slice(-3)}:${thumbprint}`}exports2.calculateJwkThumbprintUri=calculateJwkThumbprintUri}});var require_embedded=__commonJS({"node_modules/jose/dist/node/cjs/jwk/embedded.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.EmbeddedJWK=void 0;var import_js_1=require_import();var is_object_js_1=require_is_object();var errors_js_1=require_errors3();async function EmbeddedJWK(protectedHeader,token2){const joseHeader={...protectedHeader,...token2===null||token2===void 0?void 0:token2.header};if(!(0,is_object_js_1.default)(joseHeader.jwk)){throw new errors_js_1.JWSInvalid('"jwk" (JSON Web Key) Header Parameter must be a JSON object')}const key=await(0,import_js_1.importJWK)({...joseHeader.jwk,ext:true},joseHeader.alg,true);if(key instanceof Uint8Array||key.type!=="public"){throw new errors_js_1.JWSInvalid('"jwk" (JSON Web Key) Header Parameter must be a public key')}return key}exports2.EmbeddedJWK=EmbeddedJWK}});var require_local=__commonJS({"node_modules/jose/dist/node/cjs/jwks/local.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.createLocalJWKSet=exports2.LocalJWKSet=exports2.isJWKSLike=void 0;var import_js_1=require_import();var errors_js_1=require_errors3();var is_object_js_1=require_is_object();function getKtyFromAlg(alg){switch(typeof alg==="string"&&alg.slice(0,2)){case"RS":case"PS":return"RSA";case"ES":return"EC";case"Ed":return"OKP";default:throw new errors_js_1.JOSENotSupported('Unsupported "alg" value for a JSON Web Key Set')}}function isJWKSLike(jwks){return jwks&&typeof jwks==="object"&&Array.isArray(jwks.keys)&&jwks.keys.every(isJWKLike)}exports2.isJWKSLike=isJWKSLike;function isJWKLike(key){return(0,is_object_js_1.default)(key)}function clone2(obj){if(typeof structuredClone==="function"){return structuredClone(obj)}return JSON.parse(JSON.stringify(obj))}var LocalJWKSet=class{constructor(jwks){this._cached=new WeakMap;if(!isJWKSLike(jwks)){throw new errors_js_1.JWKSInvalid("JSON Web Key Set malformed")}this._jwks=clone2(jwks)}async getKey(protectedHeader,token2){const{alg,kid}={...protectedHeader,...token2===null||token2===void 0?void 0:token2.header};const kty=getKtyFromAlg(alg);const candidates=this._jwks.keys.filter(jwk2=>{let candidate=kty===jwk2.kty;if(candidate&&typeof kid==="string"){candidate=kid===jwk2.kid}if(candidate&&typeof jwk2.alg==="string"){candidate=alg===jwk2.alg}if(candidate&&typeof jwk2.use==="string"){candidate=jwk2.use==="sig"}if(candidate&&Array.isArray(jwk2.key_ops)){candidate=jwk2.key_ops.includes("verify")}if(candidate&&alg==="EdDSA"){candidate=jwk2.crv==="Ed25519"||jwk2.crv==="Ed448"}if(candidate){switch(alg){case"ES256":candidate=jwk2.crv==="P-256";break;case"ES256K":candidate=jwk2.crv==="secp256k1";break;case"ES384":candidate=jwk2.crv==="P-384";break;case"ES512":candidate=jwk2.crv==="P-521";break}}return candidate});const{0:jwk,length}=candidates;if(length===0){throw new errors_js_1.JWKSNoMatchingKey}else if(length!==1){const error=new errors_js_1.JWKSMultipleMatchingKeys;const{_cached}=this;error[Symbol.asyncIterator]=async function*(){for(const jwk2 of candidates){try{yield await importWithAlgCache(_cached,jwk2,alg)}catch{continue}}};throw error}return importWithAlgCache(this._cached,jwk,alg)}};exports2.LocalJWKSet=LocalJWKSet;async function importWithAlgCache(cache2,jwk,alg){const cached=cache2.get(jwk)||cache2.set(jwk,{}).get(jwk);if(cached[alg]===void 0){const key=await(0,import_js_1.importJWK)({...jwk,ext:true},alg);if(key instanceof Uint8Array||key.type!=="public"){throw new errors_js_1.JWKSInvalid("JSON Web Key Set members must be public keys")}cached[alg]=key}return cached[alg]}function createLocalJWKSet(jwks){const set3=new LocalJWKSet(jwks);return async function(protectedHeader,token2){return set3.getKey(protectedHeader,token2)}}exports2.createLocalJWKSet=createLocalJWKSet}});var require_fetch_jwks=__commonJS({"node_modules/jose/dist/node/cjs/runtime/fetch_jwks.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var http3=require("http");var https2=require("https");var events_1=require("events");var errors_js_1=require_errors3();var buffer_utils_js_1=require_buffer_utils();var fetchJwks=async(url,timeout,options)=>{let get4;switch(url.protocol){case"https:":get4=https2.get;break;case"http:":get4=http3.get;break;default:throw new TypeError("Unsupported URL protocol.")}const{agent,headers}=options;const req=get4(url.href,{agent,timeout,headers});const[response]=await Promise.race([(0,events_1.once)(req,"response"),(0,events_1.once)(req,"timeout")]);if(!response){req.destroy();throw new errors_js_1.JWKSTimeout}if(response.statusCode!==200){throw new errors_js_1.JOSEError("Expected 200 OK from the JSON Web Key Set HTTP response")}const parts=[];for await(const part of response){parts.push(part)}try{return JSON.parse(buffer_utils_js_1.decoder.decode((0,buffer_utils_js_1.concat)(...parts)))}catch{throw new errors_js_1.JOSEError("Failed to parse the JSON Web Key Set HTTP response as JSON")}};exports2.default=fetchJwks}});var require_remote=__commonJS({"node_modules/jose/dist/node/cjs/jwks/remote.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.createRemoteJWKSet=void 0;var fetch_jwks_js_1=require_fetch_jwks();var errors_js_1=require_errors3();var local_js_1=require_local();function isCloudflareWorkers(){return typeof WebSocketPair!=="undefined"||typeof navigator!=="undefined"&&navigator.userAgent==="Cloudflare-Workers"||typeof EdgeRuntime!=="undefined"&&EdgeRuntime==="vercel"}var RemoteJWKSet=class extends local_js_1.LocalJWKSet{constructor(url,options){super({keys:[]});this._jwks=void 0;if(!(url instanceof URL)){throw new TypeError("url must be an instance of URL")}this._url=new URL(url.href);this._options={agent:options===null||options===void 0?void 0:options.agent,headers:options===null||options===void 0?void 0:options.headers};this._timeoutDuration=typeof(options===null||options===void 0?void 0:options.timeoutDuration)==="number"?options===null||options===void 0?void 0:options.timeoutDuration:5e3;this._cooldownDuration=typeof(options===null||options===void 0?void 0:options.cooldownDuration)==="number"?options===null||options===void 0?void 0:options.cooldownDuration:3e4;this._cacheMaxAge=typeof(options===null||options===void 0?void 0:options.cacheMaxAge)==="number"?options===null||options===void 0?void 0:options.cacheMaxAge:6e5}coolingDown(){return typeof this._jwksTimestamp==="number"?Date.now()<this._jwksTimestamp+this._cooldownDuration:false}fresh(){return typeof this._jwksTimestamp==="number"?Date.now()<this._jwksTimestamp+this._cacheMaxAge:false}async getKey(protectedHeader,token2){if(!this._jwks||!this.fresh()){await this.reload()}try{return await super.getKey(protectedHeader,token2)}catch(err){if(err instanceof errors_js_1.JWKSNoMatchingKey){if(this.coolingDown()===false){await this.reload();return super.getKey(protectedHeader,token2)}}throw err}}async reload(){if(this._pendingFetch&&isCloudflareWorkers()){this._pendingFetch=void 0}this._pendingFetch||(this._pendingFetch=(0,fetch_jwks_js_1.default)(this._url,this._timeoutDuration,this._options).then(json2=>{if(!(0,local_js_1.isJWKSLike)(json2)){throw new errors_js_1.JWKSInvalid("JSON Web Key Set malformed")}this._jwks={keys:json2.keys};this._jwksTimestamp=Date.now();this._pendingFetch=void 0}).catch(err=>{this._pendingFetch=void 0;throw err}));await this._pendingFetch}};function createRemoteJWKSet(url,options){const set3=new RemoteJWKSet(url,options);return async function(protectedHeader,token2){return set3.getKey(protectedHeader,token2)}}exports2.createRemoteJWKSet=createRemoteJWKSet}});var require_unsecured=__commonJS({"node_modules/jose/dist/node/cjs/jwt/unsecured.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.UnsecuredJWT=void 0;var base64url=require_base64url();var buffer_utils_js_1=require_buffer_utils();var errors_js_1=require_errors3();var jwt_claims_set_js_1=require_jwt_claims_set();var produce_js_1=require_produce();var UnsecuredJWT=class extends produce_js_1.ProduceJWT{encode(){const header2=base64url.encode(JSON.stringify({alg:"none"}));const payload=base64url.encode(JSON.stringify(this._payload));return`${header2}.${payload}.`}static decode(jwt,options){if(typeof jwt!=="string"){throw new errors_js_1.JWTInvalid("Unsecured JWT must be a string")}const{0:encodedHeader,1:encodedPayload,2:signature,length}=jwt.split(".");if(length!==3||signature!==""){throw new errors_js_1.JWTInvalid("Invalid Unsecured JWT")}let header2;try{header2=JSON.parse(buffer_utils_js_1.decoder.decode(base64url.decode(encodedHeader)));if(header2.alg!=="none")throw new Error}catch{throw new errors_js_1.JWTInvalid("Invalid Unsecured JWT")}const payload=(0,jwt_claims_set_js_1.default)(header2,base64url.decode(encodedPayload),options);return{payload,header:header2}}};exports2.UnsecuredJWT=UnsecuredJWT}});var require_base64url2=__commonJS({"node_modules/jose/dist/node/cjs/util/base64url.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decode=exports2.encode=void 0;var base64url=require_base64url();exports2.encode=base64url.encode;exports2.decode=base64url.decode}});var require_decode_protected_header=__commonJS({"node_modules/jose/dist/node/cjs/util/decode_protected_header.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decodeProtectedHeader=void 0;var base64url_js_1=require_base64url2();var buffer_utils_js_1=require_buffer_utils();var is_object_js_1=require_is_object();function decodeProtectedHeader(token2){let protectedB64u;if(typeof token2==="string"){const parts=token2.split(".");if(parts.length===3||parts.length===5){;[protectedB64u]=parts}}else if(typeof token2==="object"&&token2){if("protected"in token2){protectedB64u=token2.protected}else{throw new TypeError("Token does not contain a Protected Header")}}try{if(typeof protectedB64u!=="string"||!protectedB64u){throw new Error}const result2=JSON.parse(buffer_utils_js_1.decoder.decode((0,base64url_js_1.decode)(protectedB64u)));if(!(0,is_object_js_1.default)(result2)){throw new Error}return result2}catch{throw new TypeError("Invalid Token or Protected Header formatting")}}exports2.decodeProtectedHeader=decodeProtectedHeader}});var require_decode_jwt=__commonJS({"node_modules/jose/dist/node/cjs/util/decode_jwt.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.decodeJwt=void 0;var base64url_js_1=require_base64url2();var buffer_utils_js_1=require_buffer_utils();var is_object_js_1=require_is_object();var errors_js_1=require_errors3();function decodeJwt(jwt){if(typeof jwt!=="string")throw new errors_js_1.JWTInvalid("JWTs must use Compact JWS serialization, JWT must be a string");const{1:payload,length}=jwt.split(".");if(length===5)throw new errors_js_1.JWTInvalid("Only JWTs using Compact JWS serialization can be decoded");if(length!==3)throw new errors_js_1.JWTInvalid("Invalid JWT");if(!payload)throw new errors_js_1.JWTInvalid("JWTs must contain a payload");let decoded;try{decoded=(0,base64url_js_1.decode)(payload)}catch{throw new errors_js_1.JWTInvalid("Failed to base64url decode the payload")}let result2;try{result2=JSON.parse(buffer_utils_js_1.decoder.decode(decoded))}catch{throw new errors_js_1.JWTInvalid("Failed to parse the decoded payload as JSON")}if(!(0,is_object_js_1.default)(result2))throw new errors_js_1.JWTInvalid("Invalid JWT Claims Set");return result2}exports2.decodeJwt=decodeJwt}});var require_generate=__commonJS({"node_modules/jose/dist/node/cjs/runtime/generate.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.generateKeyPair=exports2.generateSecret=void 0;var crypto_1=require("crypto");var util_1=require("util");var random_js_1=require_random();var check_modulus_length_js_1=require_check_modulus_length();var errors_js_1=require_errors3();var generate=(0,util_1.promisify)(crypto_1.generateKeyPair);async function generateSecret(alg,options){let length;switch(alg){case"HS256":case"HS384":case"HS512":case"A128CBC-HS256":case"A192CBC-HS384":case"A256CBC-HS512":length=parseInt(alg.slice(-3),10);break;case"A128KW":case"A192KW":case"A256KW":case"A128GCMKW":case"A192GCMKW":case"A256GCMKW":case"A128GCM":case"A192GCM":case"A256GCM":length=parseInt(alg.slice(1,4),10);break;default:throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK "alg" (Algorithm) Parameter value')}return(0,crypto_1.createSecretKey)((0,random_js_1.default)(new Uint8Array(length>>3)))}exports2.generateSecret=generateSecret;async function generateKeyPair2(alg,options){var _a2,_b;switch(alg){case"RS256":case"RS384":case"RS512":case"PS256":case"PS384":case"PS512":case"RSA-OAEP":case"RSA-OAEP-256":case"RSA-OAEP-384":case"RSA-OAEP-512":case"RSA1_5":{const modulusLength=(_a2=options===null||options===void 0?void 0:options.modulusLength)!==null&&_a2!==void 0?_a2:2048;if(typeof modulusLength!=="number"||modulusLength<2048){throw new errors_js_1.JOSENotSupported("Invalid or unsupported modulusLength option provided, 2048 bits or larger keys must be used")}const keypair=await generate("rsa",{modulusLength,publicExponent:65537});(0,check_modulus_length_js_1.setModulusLength)(keypair.privateKey,modulusLength);(0,check_modulus_length_js_1.setModulusLength)(keypair.publicKey,modulusLength);return keypair}case"ES256":return generate("ec",{namedCurve:"P-256"});case"ES256K":return generate("ec",{namedCurve:"secp256k1"});case"ES384":return generate("ec",{namedCurve:"P-384"});case"ES512":return generate("ec",{namedCurve:"P-521"});case"EdDSA":{switch(options===null||options===void 0?void 0:options.crv){case void 0:case"Ed25519":return generate("ed25519");case"Ed448":return generate("ed448");default:throw new errors_js_1.JOSENotSupported("Invalid or unsupported crv option provided, supported values are Ed25519 and Ed448")}}case"ECDH-ES":case"ECDH-ES+A128KW":case"ECDH-ES+A192KW":case"ECDH-ES+A256KW":const crv=(_b=options===null||options===void 0?void 0:options.crv)!==null&&_b!==void 0?_b:"P-256";switch(crv){case void 0:case"P-256":case"P-384":case"P-521":return generate("ec",{namedCurve:crv});case"X25519":return generate("x25519");case"X448":return generate("x448");default:throw new errors_js_1.JOSENotSupported("Invalid or unsupported crv option provided, supported values are P-256, P-384, P-521, X25519, and X448")}default:throw new errors_js_1.JOSENotSupported('Invalid or unsupported JWK "alg" (Algorithm) Parameter value')}}exports2.generateKeyPair=generateKeyPair2}});var require_generate_key_pair=__commonJS({"node_modules/jose/dist/node/cjs/key/generate_key_pair.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.generateKeyPair=void 0;var generate_js_1=require_generate();async function generateKeyPair2(alg,options){return(0,generate_js_1.generateKeyPair)(alg,options)}exports2.generateKeyPair=generateKeyPair2}});var require_generate_secret=__commonJS({"node_modules/jose/dist/node/cjs/key/generate_secret.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.generateSecret=void 0;var generate_js_1=require_generate();async function generateSecret(alg,options){return(0,generate_js_1.generateSecret)(alg,options)}exports2.generateSecret=generateSecret}});var require_runtime=__commonJS({"node_modules/jose/dist/node/cjs/runtime/runtime.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.default="node:crypto"}});var require_runtime2=__commonJS({"node_modules/jose/dist/node/cjs/util/runtime.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});var runtime_js_1=require_runtime();exports2.default=runtime_js_1.default}});var require_cjs=__commonJS({"node_modules/jose/dist/node/cjs/index.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.cryptoRuntime=exports2.base64url=exports2.generateSecret=exports2.generateKeyPair=exports2.errors=exports2.decodeJwt=exports2.decodeProtectedHeader=exports2.importJWK=exports2.importX509=exports2.importPKCS8=exports2.importSPKI=exports2.exportJWK=exports2.exportSPKI=exports2.exportPKCS8=exports2.UnsecuredJWT=exports2.createRemoteJWKSet=exports2.createLocalJWKSet=exports2.EmbeddedJWK=exports2.calculateJwkThumbprintUri=exports2.calculateJwkThumbprint=exports2.EncryptJWT=exports2.SignJWT=exports2.GeneralSign=exports2.FlattenedSign=exports2.CompactSign=exports2.FlattenedEncrypt=exports2.CompactEncrypt=exports2.jwtDecrypt=exports2.jwtVerify=exports2.generalVerify=exports2.flattenedVerify=exports2.compactVerify=exports2.GeneralEncrypt=exports2.generalDecrypt=exports2.flattenedDecrypt=exports2.compactDecrypt=void 0;var decrypt_js_1=require_decrypt3();Object.defineProperty(exports2,"compactDecrypt",{enumerable:true,get:function(){return decrypt_js_1.compactDecrypt}});var decrypt_js_2=require_decrypt2();Object.defineProperty(exports2,"flattenedDecrypt",{enumerable:true,get:function(){return decrypt_js_2.flattenedDecrypt}});var decrypt_js_3=require_decrypt4();Object.defineProperty(exports2,"generalDecrypt",{enumerable:true,get:function(){return decrypt_js_3.generalDecrypt}});var encrypt_js_1=require_encrypt3();Object.defineProperty(exports2,"GeneralEncrypt",{enumerable:true,get:function(){return encrypt_js_1.GeneralEncrypt}});var verify_js_1=require_verify3();Object.defineProperty(exports2,"compactVerify",{enumerable:true,get:function(){return verify_js_1.compactVerify}});var verify_js_2=require_verify2();Object.defineProperty(exports2,"flattenedVerify",{enumerable:true,get:function(){return verify_js_2.flattenedVerify}});var verify_js_3=require_verify4();Object.defineProperty(exports2,"generalVerify",{enumerable:true,get:function(){return verify_js_3.generalVerify}});var verify_js_4=require_verify5();Object.defineProperty(exports2,"jwtVerify",{enumerable:true,get:function(){return verify_js_4.jwtVerify}});var decrypt_js_4=require_decrypt5();Object.defineProperty(exports2,"jwtDecrypt",{enumerable:true,get:function(){return decrypt_js_4.jwtDecrypt}});var encrypt_js_2=require_encrypt4();Object.defineProperty(exports2,"CompactEncrypt",{enumerable:true,get:function(){return encrypt_js_2.CompactEncrypt}});var encrypt_js_3=require_encrypt2();Object.defineProperty(exports2,"FlattenedEncrypt",{enumerable:true,get:function(){return encrypt_js_3.FlattenedEncrypt}});var sign_js_1=require_sign3();Object.defineProperty(exports2,"CompactSign",{enumerable:true,get:function(){return sign_js_1.CompactSign}});var sign_js_2=require_sign2();Object.defineProperty(exports2,"FlattenedSign",{enumerable:true,get:function(){return sign_js_2.FlattenedSign}});var sign_js_3=require_sign4();Object.defineProperty(exports2,"GeneralSign",{enumerable:true,get:function(){return sign_js_3.GeneralSign}});var sign_js_4=require_sign5();Object.defineProperty(exports2,"SignJWT",{enumerable:true,get:function(){return sign_js_4.SignJWT}});var encrypt_js_4=require_encrypt5();Object.defineProperty(exports2,"EncryptJWT",{enumerable:true,get:function(){return encrypt_js_4.EncryptJWT}});var thumbprint_js_1=require_thumbprint();Object.defineProperty(exports2,"calculateJwkThumbprint",{enumerable:true,get:function(){return thumbprint_js_1.calculateJwkThumbprint}});Object.defineProperty(exports2,"calculateJwkThumbprintUri",{enumerable:true,get:function(){return thumbprint_js_1.calculateJwkThumbprintUri}});var embedded_js_1=require_embedded();Object.defineProperty(exports2,"EmbeddedJWK",{enumerable:true,get:function(){return embedded_js_1.EmbeddedJWK}});var local_js_1=require_local();Object.defineProperty(exports2,"createLocalJWKSet",{enumerable:true,get:function(){return local_js_1.createLocalJWKSet}});var remote_js_1=require_remote();Object.defineProperty(exports2,"createRemoteJWKSet",{enumerable:true,get:function(){return remote_js_1.createRemoteJWKSet}});var unsecured_js_1=require_unsecured();Object.defineProperty(exports2,"UnsecuredJWT",{enumerable:true,get:function(){return unsecured_js_1.UnsecuredJWT}});var export_js_1=require_export();Object.defineProperty(exports2,"exportPKCS8",{enumerable:true,get:function(){return export_js_1.exportPKCS8}});Object.defineProperty(exports2,"exportSPKI",{enumerable:true,get:function(){return export_js_1.exportSPKI}});Object.defineProperty(exports2,"exportJWK",{enumerable:true,get:function(){return export_js_1.exportJWK}});var import_js_1=require_import();Object.defineProperty(exports2,"importSPKI",{enumerable:true,get:function(){return import_js_1.importSPKI}});Object.defineProperty(exports2,"importPKCS8",{enumerable:true,get:function(){return import_js_1.importPKCS8}});Object.defineProperty(exports2,"importX509",{enumerable:true,get:function(){return import_js_1.importX509}});Object.defineProperty(exports2,"importJWK",{enumerable:true,get:function(){return import_js_1.importJWK}});var decode_protected_header_js_1=require_decode_protected_header();Object.defineProperty(exports2,"decodeProtectedHeader",{enumerable:true,get:function(){return decode_protected_header_js_1.decodeProtectedHeader}});var decode_jwt_js_1=require_decode_jwt();Object.defineProperty(exports2,"decodeJwt",{enumerable:true,get:function(){return decode_jwt_js_1.decodeJwt}});exports2.errors=require_errors3();var generate_key_pair_js_1=require_generate_key_pair();Object.defineProperty(exports2,"generateKeyPair",{enumerable:true,get:function(){return generate_key_pair_js_1.generateKeyPair}});var generate_secret_js_1=require_generate_secret();Object.defineProperty(exports2,"generateSecret",{enumerable:true,get:function(){return generate_secret_js_1.generateSecret}});exports2.base64url=require_base64url2();var runtime_js_1=require_runtime2();Object.defineProperty(exports2,"cryptoRuntime",{enumerable:true,get:function(){return runtime_js_1.default}})}});var require_shake256=__commonJS({"node_modules/oidc-token-hash/lib/shake256.js"(exports2,module2){var crypto5=require("crypto");var[major3,minor3]=process.version.substring(1).split(".").map(x=>parseInt(x,10));var xofOutputLength=major3>12||major3===12&&minor3>=8;var shake256=xofOutputLength&&crypto5.getHashes().includes("shake256");module2.exports=shake256}});var require_lib2=__commonJS({"node_modules/oidc-token-hash/lib/index.js"(exports2,module2){var{strict:assert2}=require("assert");var{createHash:createHash4}=require("crypto");var{format:format2}=require("util");var shake256=require_shake256();var encode2;if(Buffer.isEncoding("base64url")){encode2=input=>input.toString("base64url")}else{const fromBase64=base64=>base64.replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_");encode2=input=>fromBase64(input.toString("base64"))}function getHash(alg,crv){switch(alg){case"HS256":case"RS256":case"PS256":case"ES256":case"ES256K":return createHash4("sha256");case"HS384":case"RS384":case"PS384":case"ES384":return createHash4("sha384");case"HS512":case"RS512":case"PS512":case"ES512":return createHash4("sha512");case"EdDSA":switch(crv){case"Ed25519":return createHash4("sha512");case"Ed448":if(!shake256){throw new TypeError("Ed448 *_hash calculation is not supported in your Node.js runtime version")}return createHash4("shake256",{outputLength:114});default:throw new TypeError("unrecognized or invalid EdDSA curve provided")}default:throw new TypeError("unrecognized or invalid JWS algorithm provided")}}function generate(token2,alg,crv){const digest2=getHash(alg,crv).update(token2).digest();return encode2(digest2.slice(0,digest2.length/2))}function validate(names2,actual,source,alg,crv){if(typeof names2.claim!=="string"||!names2.claim){throw new TypeError("names.claim must be a non-empty string")}if(typeof names2.source!=="string"||!names2.source){throw new TypeError("names.source must be a non-empty string")}assert2(typeof actual==="string"&&actual,`${names2.claim} must be a non-empty string`);assert2(typeof source==="string"&&source,`${names2.source} must be a non-empty string`);let expected;let msg;try{expected=generate(source,alg,crv)}catch(err){msg=format2("%s could not be validated (%s)",names2.claim,err.message)}msg=msg||format2("%s mismatch, expected %s, got: %s",names2.claim,expected,actual);assert2.equal(expected,actual,msg)}module2.exports={validate,generate}}});var require_is_key_object2=__commonJS({"node_modules/openid-client/lib/helpers/is_key_object.js"(exports2,module2){var util4=require("util");var crypto5=require("crypto");module2.exports=util4.types.isKeyObject||(obj=>obj&&obj instanceof crypto5.KeyObject)}});var require_base64url3=__commonJS({"node_modules/openid-client/lib/helpers/base64url.js"(exports2,module2){var encode2;if(Buffer.isEncoding("base64url")){encode2=(input,encoding="utf8")=>Buffer.from(input,encoding).toString("base64url")}else{const fromBase64=base64=>base64.replace(/=/g,"").replace(/\+/g,"-").replace(/\//g,"_");encode2=(input,encoding="utf8")=>fromBase64(Buffer.from(input,encoding).toString("base64"))}var decode=input=>Buffer.from(input,"base64");module2.exports.decode=decode;module2.exports.encode=encode2}});var require_decode_jwt2=__commonJS({"node_modules/openid-client/lib/helpers/decode_jwt.js"(exports2,module2){var base64url=require_base64url3();module2.exports=token2=>{if(typeof token2!=="string"||!token2){throw new TypeError("JWT must be a string")}const{0:header2,1:payload,2:signature,length}=token2.split(".");if(length===5){throw new TypeError("encrypted JWTs cannot be decoded")}if(length!==3){throw new Error("JWTs must have three components")}try{return{header:JSON.parse(base64url.decode(header2)),payload:JSON.parse(base64url.decode(payload)),signature}}catch(err){throw new Error("JWT is malformed")}}}});var require_is_plain_object=__commonJS({"node_modules/openid-client/lib/helpers/is_plain_object.js"(exports2,module2){module2.exports=a=>!!a&&a.constructor===Object}});var require_defaults=__commonJS({"node_modules/openid-client/lib/helpers/defaults.js"(exports2,module2){var isPlainObject3=require_is_plain_object();function defaults3(deep,target,...sources){for(const source of sources){if(!isPlainObject3(source)){continue}for(const[key,value]of Object.entries(source)){if(key==="__proto__"||key==="constructor"){continue}if(typeof target[key]==="undefined"&&typeof value!=="undefined"){target[key]=value}if(deep&&isPlainObject3(target[key])&&isPlainObject3(value)){defaults3(true,target[key],value)}}}return target}module2.exports=defaults3.bind(void 0,false);module2.exports.deep=defaults3.bind(void 0,true)}});var require_www_authenticate_parser=__commonJS({"node_modules/openid-client/lib/helpers/www_authenticate_parser.js"(exports2,module2){var REGEXP=/(\w+)=("[^"]*")/g;module2.exports=wwwAuthenticate=>{const params={};try{while(REGEXP.exec(wwwAuthenticate)!==null){if(RegExp.$1&&RegExp.$2){params[RegExp.$1]=RegExp.$2.slice(1,-1)}}}catch(err){}return params}}});var require_assert=__commonJS({"node_modules/openid-client/lib/helpers/assert.js"(exports2,module2){function assertSigningAlgValuesSupport(endpoint,issuer,properties){if(!issuer[`${endpoint}_endpoint`])return;const eam=`${endpoint}_endpoint_auth_method`;const easa=`${endpoint}_endpoint_auth_signing_alg`;const easavs=`${endpoint}_endpoint_auth_signing_alg_values_supported`;if(properties[eam]&&properties[eam].endsWith("_jwt")&&!properties[easa]&&!issuer[easavs]){throw new TypeError(`${easavs} must be configured on the issuer if ${easa} is not defined on a client`)}}function assertIssuerConfiguration(issuer,endpoint){if(!issuer[endpoint]){throw new TypeError(`${endpoint} must be configured on the issuer`)}}module2.exports={assertSigningAlgValuesSupport,assertIssuerConfiguration}}});var require_pick=__commonJS({"node_modules/openid-client/lib/helpers/pick.js"(exports2,module2){module2.exports=function pick2(object,...paths){const obj={};for(const path23 of paths){if(object[path23]!==void 0){obj[path23]=object[path23]}}return obj}}});var require_process_response=__commonJS({"node_modules/openid-client/lib/helpers/process_response.js"(exports2,module2){var{STATUS_CODES}=require("http");var{format:format2}=require("util");var{OPError}=require_errors2();var parseWwwAuthenticate=require_www_authenticate_parser();var throwAuthenticateErrors=response=>{const params=parseWwwAuthenticate(response.headers["www-authenticate"]);if(params.error){throw new OPError(params,response)}};var isStandardBodyError=response=>{let result2=false;try{let jsonbody;if(typeof response.body!=="object"||Buffer.isBuffer(response.body)){jsonbody=JSON.parse(response.body)}else{jsonbody=response.body}result2=typeof jsonbody.error==="string"&&jsonbody.error.length;if(result2)Object.defineProperty(response,"body",{value:jsonbody,configurable:true})}catch(err){}return result2};function processResponse(response,{statusCode=200,body=true,bearer=false}={}){if(response.statusCode!==statusCode){if(bearer){throwAuthenticateErrors(response)}if(isStandardBodyError(response)){throw new OPError(response.body,response)}throw new OPError({error:format2("expected %i %s, got: %i %s",statusCode,STATUS_CODES[statusCode],response.statusCode,STATUS_CODES[response.statusCode])},response)}if(body&&!response.body){throw new OPError({error:format2("expected %i %s with body but no body was returned",statusCode,STATUS_CODES[statusCode])},response)}return response.body}module2.exports=processResponse}});var require_unix_timestamp=__commonJS({"node_modules/openid-client/lib/helpers/unix_timestamp.js"(exports2,module2){module2.exports=()=>Math.floor(Date.now()/1e3)}});var require_token_set=__commonJS({"node_modules/openid-client/lib/token_set.js"(exports2,module2){var base64url=require_base64url3();var now3=require_unix_timestamp();var TokenSet2=class{constructor(values2){Object.assign(this,values2);const{constructor,...properties}=Object.getOwnPropertyDescriptors(this.constructor.prototype);Object.defineProperties(this,properties)}set expires_in(value){this.expires_at=now3()+Number(value)}get expires_in(){return Math.max.apply(null,[this.expires_at-now3(),0])}expired(){return this.expires_in===0}claims(){if(!this.id_token){throw new TypeError("id_token not present in TokenSet")}return JSON.parse(base64url.decode(this.id_token.split(".")[1]))}};module2.exports=TokenSet2}});var require_generators=__commonJS({"node_modules/openid-client/lib/helpers/generators.js"(exports2,module2){var{createHash:createHash4,randomBytes}=require("crypto");var base64url=require_base64url3();var random3=(bytes8=32)=>base64url.encode(randomBytes(bytes8));module2.exports={random:random3,state:random3,nonce:random3,codeVerifier:random3,codeChallenge:codeVerifier=>base64url.encode(createHash4("sha256").update(codeVerifier).digest())}}});var require_iterator=__commonJS({"node_modules/yallist/iterator.js"(exports2,module2){"use strict";module2.exports=function(Yallist){Yallist.prototype[Symbol.iterator]=function*(){for(let walker=this.head;walker;walker=walker.next){yield walker.value}}}}});var require_yallist=__commonJS({"node_modules/yallist/yallist.js"(exports2,module2){"use strict";module2.exports=Yallist;Yallist.Node=Node;Yallist.create=Yallist;function Yallist(list){var self2=this;if(!(self2 instanceof Yallist)){self2=new Yallist}self2.tail=null;self2.head=null;self2.length=0;if(list&&typeof list.forEach==="function"){list.forEach(function(item){self2.push(item)})}else if(arguments.length>0){for(var i=0,l=arguments.length;i<l;i++){self2.push(arguments[i])}}return self2}Yallist.prototype.removeNode=function(node){if(node.list!==this){throw new Error("removing node which does not belong to this list")}var next=node.next;var prev=node.prev;if(next){next.prev=prev}if(prev){prev.next=next}if(node===this.head){this.head=next}if(node===this.tail){this.tail=prev}node.list.length--;node.next=null;node.prev=null;node.list=null;return next};Yallist.prototype.unshiftNode=function(node){if(node===this.head){return}if(node.list){node.list.removeNode(node)}var head2=this.head;node.list=this;node.next=head2;if(head2){head2.prev=node}this.head=node;if(!this.tail){this.tail=node}this.length++};Yallist.prototype.pushNode=function(node){if(node===this.tail){return}if(node.list){node.list.removeNode(node)}var tail2=this.tail;node.list=this;node.prev=tail2;if(tail2){tail2.next=node}this.tail=node;if(!this.head){this.head=node}this.length++};Yallist.prototype.push=function(){for(var i=0,l=arguments.length;i<l;i++){push(this,arguments[i])}return this.length};Yallist.prototype.unshift=function(){for(var i=0,l=arguments.length;i<l;i++){unshift(this,arguments[i])}return this.length};Yallist.prototype.pop=function(){if(!this.tail){return void 0}var res=this.tail.value;this.tail=this.tail.prev;if(this.tail){this.tail.next=null}else{this.head=null}this.length--;return res};Yallist.prototype.shift=function(){if(!this.head){return void 0}var res=this.head.value;this.head=this.head.next;if(this.head){this.head.prev=null}else{this.tail=null}this.length--;return res};Yallist.prototype.forEach=function(fn2,thisp){thisp=thisp||this;for(var walker=this.head,i=0;walker!==null;i++){fn2.call(thisp,walker.value,i,this);walker=walker.next}};Yallist.prototype.forEachReverse=function(fn2,thisp){thisp=thisp||this;for(var walker=this.tail,i=this.length-1;walker!==null;i--){fn2.call(thisp,walker.value,i,this);walker=walker.prev}};Yallist.prototype.get=function(n){for(var i=0,walker=this.head;walker!==null&&i<n;i++){walker=walker.next}if(i===n&&walker!==null){return walker.value}};Yallist.prototype.getReverse=function(n){for(var i=0,walker=this.tail;walker!==null&&i<n;i++){walker=walker.prev}if(i===n&&walker!==null){return walker.value}};Yallist.prototype.map=function(fn2,thisp){thisp=thisp||this;var res=new Yallist;for(var walker=this.head;walker!==null;){res.push(fn2.call(thisp,walker.value,this));walker=walker.next}return res};Yallist.prototype.mapReverse=function(fn2,thisp){thisp=thisp||this;var res=new Yallist;for(var walker=this.tail;walker!==null;){res.push(fn2.call(thisp,walker.value,this));walker=walker.prev}return res};Yallist.prototype.reduce=function(fn2,initial2){var acc;var walker=this.head;if(arguments.length>1){acc=initial2}else if(this.head){walker=this.head.next;acc=this.head.value}else{throw new TypeError("Reduce of empty list with no initial value")}for(var i=0;walker!==null;i++){acc=fn2(acc,walker.value,i);walker=walker.next}return acc};Yallist.prototype.reduceReverse=function(fn2,initial2){var acc;var walker=this.tail;if(arguments.length>1){acc=initial2}else if(this.tail){walker=this.tail.prev;acc=this.tail.value}else{throw new TypeError("Reduce of empty list with no initial value")}for(var i=this.length-1;walker!==null;i--){acc=fn2(acc,walker.value,i);walker=walker.prev}return acc};Yallist.prototype.toArray=function(){var arr=new Array(this.length);for(var i=0,walker=this.head;walker!==null;i++){arr[i]=walker.value;walker=walker.next}return arr};Yallist.prototype.toArrayReverse=function(){var arr=new Array(this.length);for(var i=0,walker=this.tail;walker!==null;i++){arr[i]=walker.value;walker=walker.prev}return arr};Yallist.prototype.slice=function(from,to){to=to||this.length;if(to<0){to+=this.length}from=from||0;if(from<0){from+=this.length}var ret=new Yallist;if(to<from||to<0){return ret}if(from<0){from=0}if(to>this.length){to=this.length}for(var i=0,walker=this.head;walker!==null&&i<from;i++){walker=walker.next}for(;walker!==null&&i<to;i++,walker=walker.next){ret.push(walker.value)}return ret};Yallist.prototype.sliceReverse=function(from,to){to=to||this.length;if(to<0){to+=this.length}from=from||0;if(from<0){from+=this.length}var ret=new Yallist;if(to<from||to<0){return ret}if(from<0){from=0}if(to>this.length){to=this.length}for(var i=this.length,walker=this.tail;walker!==null&&i>to;i--){walker=walker.prev}for(;walker!==null&&i>from;i--,walker=walker.prev){ret.push(walker.value)}return ret};Yallist.prototype.splice=function(start,deleteCount,...nodes){if(start>this.length){start=this.length-1}if(start<0){start=this.length+start}for(var i=0,walker=this.head;walker!==null&&i<start;i++){walker=walker.next}var ret=[];for(var i=0;walker&&i<deleteCount;i++){ret.push(walker.value);walker=this.removeNode(walker)}if(walker===null){walker=this.tail}if(walker!==this.head&&walker!==this.tail){walker=walker.prev}for(var i=0;i<nodes.length;i++){walker=insert(this,walker,nodes[i])}return ret};Yallist.prototype.reverse=function(){var head2=this.head;var tail2=this.tail;for(var walker=head2;walker!==null;walker=walker.prev){var p=walker.prev;walker.prev=walker.next;walker.next=p}this.head=tail2;this.tail=head2;return this};function insert(self2,node,value){var inserted=node===self2.head?new Node(value,null,node,self2):new Node(value,node,node.next,self2);if(inserted.next===null){self2.tail=inserted}if(inserted.prev===null){self2.head=inserted}self2.length++;return inserted}function push(self2,item){self2.tail=new Node(item,self2.tail,null,self2);if(!self2.head){self2.head=self2.tail}self2.length++}function unshift(self2,item){self2.head=new Node(item,null,self2.head,self2);if(!self2.tail){self2.tail=self2.head}self2.length++}function Node(value,prev,next,list){if(!(this instanceof Node)){return new Node(value,prev,next,list)}this.list=list;this.value=value;if(prev){prev.next=this;this.prev=prev}else{this.prev=null}if(next){next.prev=this;this.next=next}else{this.next=null}}try{require_iterator()(Yallist)}catch(er){}}});var require_lru_cache=__commonJS({"node_modules/lru-cache/index.js"(exports2,module2){"use strict";var Yallist=require_yallist();var MAX=Symbol("max");var LENGTH=Symbol("length");var LENGTH_CALCULATOR=Symbol("lengthCalculator");var ALLOW_STALE=Symbol("allowStale");var MAX_AGE=Symbol("maxAge");var DISPOSE=Symbol("dispose");var NO_DISPOSE_ON_SET=Symbol("noDisposeOnSet");var LRU_LIST=Symbol("lruList");var CACHE=Symbol("cache");var UPDATE_AGE_ON_GET=Symbol("updateAgeOnGet");var naiveLength=()=>1;var LRUCache=class{constructor(options){if(typeof options==="number")options={max:options};if(!options)options={};if(options.max&&(typeof options.max!=="number"||options.max<0))throw new TypeError("max must be a non-negative number");const max3=this[MAX]=options.max||Infinity;const lc=options.length||naiveLength;this[LENGTH_CALCULATOR]=typeof lc!=="function"?naiveLength:lc;this[ALLOW_STALE]=options.stale||false;if(options.maxAge&&typeof options.maxAge!=="number")throw new TypeError("maxAge must be a number");this[MAX_AGE]=options.maxAge||0;this[DISPOSE]=options.dispose;this[NO_DISPOSE_ON_SET]=options.noDisposeOnSet||false;this[UPDATE_AGE_ON_GET]=options.updateAgeOnGet||false;this.reset()}set max(mL){if(typeof mL!=="number"||mL<0)throw new TypeError("max must be a non-negative number");this[MAX]=mL||Infinity;trim2(this)}get max(){return this[MAX]}set allowStale(allowStale){this[ALLOW_STALE]=!!allowStale}get allowStale(){return this[ALLOW_STALE]}set maxAge(mA){if(typeof mA!=="number")throw new TypeError("maxAge must be a non-negative number");this[MAX_AGE]=mA;trim2(this)}get maxAge(){return this[MAX_AGE]}set lengthCalculator(lC){if(typeof lC!=="function")lC=naiveLength;if(lC!==this[LENGTH_CALCULATOR]){this[LENGTH_CALCULATOR]=lC;this[LENGTH]=0;this[LRU_LIST].forEach(hit=>{hit.length=this[LENGTH_CALCULATOR](hit.value,hit.key);this[LENGTH]+=hit.length})}trim2(this)}get lengthCalculator(){return this[LENGTH_CALCULATOR]}get length(){return this[LENGTH]}get itemCount(){return this[LRU_LIST].length}rforEach(fn2,thisp){thisp=thisp||this;for(let walker=this[LRU_LIST].tail;walker!==null;){const prev=walker.prev;forEachStep(this,fn2,walker,thisp);walker=prev}}forEach(fn2,thisp){thisp=thisp||this;for(let walker=this[LRU_LIST].head;walker!==null;){const next=walker.next;forEachStep(this,fn2,walker,thisp);walker=next}}keys(){return this[LRU_LIST].toArray().map(k=>k.key)}values(){return this[LRU_LIST].toArray().map(k=>k.value)}reset(){if(this[DISPOSE]&&this[LRU_LIST]&&this[LRU_LIST].length){this[LRU_LIST].forEach(hit=>this[DISPOSE](hit.key,hit.value))}this[CACHE]=new Map;this[LRU_LIST]=new Yallist;this[LENGTH]=0}dump(){return this[LRU_LIST].map(hit=>isStale(this,hit)?false:{k:hit.key,v:hit.value,e:hit.now+(hit.maxAge||0)}).toArray().filter(h=>h)}dumpLru(){return this[LRU_LIST]}set(key,value,maxAge){maxAge=maxAge||this[MAX_AGE];if(maxAge&&typeof maxAge!=="number")throw new TypeError("maxAge must be a number");const now3=maxAge?Date.now():0;const len=this[LENGTH_CALCULATOR](value,key);if(this[CACHE].has(key)){if(len>this[MAX]){del(this,this[CACHE].get(key));return false}const node=this[CACHE].get(key);const item=node.value;if(this[DISPOSE]){if(!this[NO_DISPOSE_ON_SET])this[DISPOSE](key,item.value)}item.now=now3;item.maxAge=maxAge;item.value=value;this[LENGTH]+=len-item.length;item.length=len;this.get(key);trim2(this);return true}const hit=new Entry(key,value,len,now3,maxAge);if(hit.length>this[MAX]){if(this[DISPOSE])this[DISPOSE](key,value);return false}this[LENGTH]+=hit.length;this[LRU_LIST].unshift(hit);this[CACHE].set(key,this[LRU_LIST].head);trim2(this);return true}has(key){if(!this[CACHE].has(key))return false;const hit=this[CACHE].get(key).value;return!isStale(this,hit)}get(key){return get4(this,key,true)}peek(key){return get4(this,key,false)}pop(){const node=this[LRU_LIST].tail;if(!node)return null;del(this,node);return node.value}del(key){del(this,this[CACHE].get(key))}load(arr){this.reset();const now3=Date.now();for(let l=arr.length-1;l>=0;l--){const hit=arr[l];const expiresAt=hit.e||0;if(expiresAt===0)this.set(hit.k,hit.v);else{const maxAge=expiresAt-now3;if(maxAge>0){this.set(hit.k,hit.v,maxAge)}}}}prune(){this[CACHE].forEach((value,key)=>get4(this,key,false))}};var get4=(self2,key,doUse)=>{const node=self2[CACHE].get(key);if(node){const hit=node.value;if(isStale(self2,hit)){del(self2,node);if(!self2[ALLOW_STALE])return void 0}else{if(doUse){if(self2[UPDATE_AGE_ON_GET])node.value.now=Date.now();self2[LRU_LIST].unshiftNode(node)}}return hit.value}};var isStale=(self2,hit)=>{if(!hit||!hit.maxAge&&!self2[MAX_AGE])return false;const diff=Date.now()-hit.now;return hit.maxAge?diff>hit.maxAge:self2[MAX_AGE]&&diff>self2[MAX_AGE]};var trim2=self2=>{if(self2[LENGTH]>self2[MAX]){for(let walker=self2[LRU_LIST].tail;self2[LENGTH]>self2[MAX]&&walker!==null;){const prev=walker.prev;del(self2,walker);walker=prev}}};var del=(self2,node)=>{if(node){const hit=node.value;if(self2[DISPOSE])self2[DISPOSE](hit.key,hit.value);self2[LENGTH]-=hit.length;self2[CACHE].delete(hit.key);self2[LRU_LIST].removeNode(node)}};var Entry=class{constructor(key,value,length,now3,maxAge){this.key=key;this.value=value;this.length=length;this.now=now3;this.maxAge=maxAge||0}};var forEachStep=(self2,fn2,node,thisp)=>{let hit=node.value;if(isStale(self2,hit)){del(self2,node);if(!self2[ALLOW_STALE])hit=void 0}if(hit)fn2.call(thisp,hit.value,hit.key,self2)};module2.exports=LRUCache}});var require_package=__commonJS({"node_modules/openid-client/package.json"(exports2,module2){module2.exports={name:"openid-client",version:"5.7.0",description:"OpenID Connect Relying Party (RP, Client) implementation for Node.js runtime, supports passportjs",keywords:["auth","authentication","basic","certified","client","connect","dynamic","electron","hybrid","identity","implicit","oauth","oauth2","oidc","openid","passport","relying party","strategy"],homepage:"https://github.com/panva/node-openid-client",repository:"panva/node-openid-client",funding:{url:"https://github.com/sponsors/panva"},license:"MIT",author:"Filip Skokan <panva.ip@gmail.com>",exports:{types:"./types/index.d.ts",import:"./lib/index.mjs",require:"./lib/index.js"},main:"./lib/index.js",types:"./types/index.d.ts",files:["lib","types/index.d.ts"],scripts:{format:"npx prettier --loglevel silent --write ./lib ./test ./certification ./types",test:"mocha test/**/*.test.js"},dependencies:{jose:"^4.15.9","lru-cache":"^6.0.0","object-hash":"^2.2.0","oidc-token-hash":"^5.0.3"},devDependencies:{"@types/node":"^16.18.106","@types/passport":"^1.0.16",base64url:"^3.0.1",chai:"^4.5.0",mocha:"^10.7.3",nock:"^13.5.5",prettier:"^2.8.8","readable-mock-req":"^0.2.2",sinon:"^9.2.4",timekeeper:"^2.3.1"},"standard-version":{scripts:{postchangelog:"sed -i '' -e 's/### \\[/## [/g' CHANGELOG.md"},types:[{type:"feat",section:"Features"},{type:"fix",section:"Fixes"},{type:"chore",hidden:true},{type:"docs",hidden:true},{type:"style",hidden:true},{type:"refactor",section:"Refactor",hidden:false},{type:"perf",section:"Performance",hidden:false},{type:"test",hidden:true}]}}}});var require_consts=__commonJS({"node_modules/openid-client/lib/helpers/consts.js"(exports2,module2){var HTTP_OPTIONS=Symbol();var CLOCK_TOLERANCE=Symbol();module2.exports={CLOCK_TOLERANCE,HTTP_OPTIONS}}});var require_request=__commonJS({"node_modules/openid-client/lib/helpers/request.js"(exports2,module2){var assert2=require("assert");var querystring=require("querystring");var http3=require("http");var https2=require("https");var{once:once2}=require("events");var{URL:URL3}=require("url");var LRU=require_lru_cache();var pkg=require_package();var{RPError}=require_errors2();var pick2=require_pick();var{deep:defaultsDeep2}=require_defaults();var{HTTP_OPTIONS}=require_consts();var DEFAULT_HTTP_OPTIONS;var NQCHAR=/^[\x21\x23-\x5B\x5D-\x7E]+$/;var allowed=["agent","ca","cert","crl","headers","key","lookup","passphrase","pfx","timeout"];var setDefaults=(props,options)=>{DEFAULT_HTTP_OPTIONS=defaultsDeep2({},props.length?pick2(options,...props):options,DEFAULT_HTTP_OPTIONS)};setDefaults([],{headers:{"User-Agent":`${pkg.name}/${pkg.version} (${pkg.homepage})`,"Accept-Encoding":"identity"},timeout:3500});function send(req,body,contentType){if(contentType){req.removeHeader("content-type");req.setHeader("content-type",contentType)}if(body){req.removeHeader("content-length");req.setHeader("content-length",Buffer.byteLength(body));req.write(body)}req.end()}var nonces=new LRU({max:100});module2.exports=async function request(options,{accessToken,mTLS=false,DPoP}={}){let url;try{url=new URL3(options.url);delete options.url;assert2(/^(https?:)$/.test(url.protocol))}catch(err){throw new TypeError("only valid absolute URLs can be requested")}const optsFn=this[HTTP_OPTIONS];let opts=options;const nonceKey=`${url.origin}${url.pathname}`;if(DPoP&&"dpopProof"in this){opts.headers=opts.headers||{};opts.headers.DPoP=await this.dpopProof({htu:`${url.origin}${url.pathname}`,htm:options.method||"GET",nonce:nonces.get(nonceKey)},DPoP,accessToken)}let userOptions;if(optsFn){userOptions=pick2(optsFn.call(this,url,defaultsDeep2({},opts,DEFAULT_HTTP_OPTIONS)),...allowed)}opts=defaultsDeep2({},userOptions,opts,DEFAULT_HTTP_OPTIONS);if(mTLS&&!opts.pfx&&!(opts.key&&opts.cert)){throw new TypeError("mutual-TLS certificate and key not set")}if(opts.searchParams){for(const[key,value]of Object.entries(opts.searchParams)){url.searchParams.delete(key);url.searchParams.set(key,value)}}let responseType;let form;let json2;let body;({form,responseType,json:json2,body,...opts}=opts);for(const[key,value]of Object.entries(opts.headers||{})){if(value===void 0){delete opts.headers[key]}}let response;const req=(url.protocol==="https:"?https2.request:http3.request)(url.href,opts);return(async()=>{if(json2){send(req,JSON.stringify(json2),"application/json")}else if(form){send(req,querystring.stringify(form),"application/x-www-form-urlencoded")}else if(body){send(req,body)}else{send(req)}[response]=await Promise.race([once2(req,"response"),once2(req,"timeout")]);if(!response){req.destroy();throw new RPError(`outgoing request timed out after ${opts.timeout}ms`)}const parts=[];for await(const part of response){parts.push(part)}if(parts.length){switch(responseType){case"json":{Object.defineProperty(response,"body",{get(){let value=Buffer.concat(parts);try{value=JSON.parse(value)}catch(err){Object.defineProperty(err,"response",{value:response});throw err}finally{Object.defineProperty(response,"body",{value,configurable:true})}return value},configurable:true});break}case void 0:case"buffer":{Object.defineProperty(response,"body",{get(){const value=Buffer.concat(parts);Object.defineProperty(response,"body",{value,configurable:true});return value},configurable:true});break}default:throw new TypeError("unsupported responseType request option")}}return response})().catch(err=>{if(response)Object.defineProperty(err,"response",{value:response});throw err}).finally(()=>{const dpopNonce=response&&response.headers["dpop-nonce"];if(dpopNonce&&NQCHAR.test(dpopNonce)){nonces.set(nonceKey,dpopNonce)}})};module2.exports.setDefaults=setDefaults.bind(void 0,allowed)}});var require_weak_cache=__commonJS({"node_modules/openid-client/lib/helpers/weak_cache.js"(exports2,module2){module2.exports.keystores=new WeakMap}});var require_deep_clone=__commonJS({"node_modules/openid-client/lib/helpers/deep_clone.js"(exports2,module2){module2.exports=globalThis.structuredClone||(obj=>JSON.parse(JSON.stringify(obj)))}});var require_keystore=__commonJS({"node_modules/openid-client/lib/helpers/keystore.js"(exports2,module2){var jose=require_cjs();var clone2=require_deep_clone();var isPlainObject3=require_is_plain_object();var internal=Symbol();var keyscore=(key,{alg,use})=>{let score=0;if(alg&&key.alg){score++}if(use&&key.use){score++}return score};function getKtyFromAlg(alg){switch(typeof alg==="string"&&alg.slice(0,2)){case"RS":case"PS":return"RSA";case"ES":return"EC";case"Ed":return"OKP";default:return void 0}}function getAlgorithms(use,alg,kty,crv){if(alg){return new Set([alg])}switch(kty){case"EC":{let algs=[];if(use==="enc"||use===void 0){algs=algs.concat(["ECDH-ES","ECDH-ES+A128KW","ECDH-ES+A192KW","ECDH-ES+A256KW"])}if(use==="sig"||use===void 0){switch(crv){case"P-256":case"P-384":algs=algs.concat([`ES${crv.slice(-3)}`]);break;case"P-521":algs=algs.concat(["ES512"]);break;case"secp256k1":if(jose.cryptoRuntime==="node:crypto"){algs=algs.concat(["ES256K"])}break}}return new Set(algs)}case"OKP":{return new Set(["ECDH-ES","ECDH-ES+A128KW","ECDH-ES+A192KW","ECDH-ES+A256KW"])}case"RSA":{let algs=[];if(use==="enc"||use===void 0){algs=algs.concat(["RSA-OAEP","RSA-OAEP-256","RSA-OAEP-384","RSA-OAEP-512"]);if(jose.cryptoRuntime==="node:crypto"){algs=algs.concat(["RSA1_5"])}}if(use==="sig"||use===void 0){algs=algs.concat(["PS256","PS384","PS512","RS256","RS384","RS512"])}return new Set(algs)}default:throw new Error("unreachable")}}module2.exports=class KeyStore{#keys;constructor(i,keys2){if(i!==internal)throw new Error("invalid constructor call");this.#keys=keys2}toJWKS(){return{keys:this.map(({jwk:{d,p,q,dp,dq,qi,...jwk}})=>jwk)}}all({alg,kid,use}={}){if(!use||!alg){throw new Error}const kty=getKtyFromAlg(alg);const search2={alg,use};return this.filter(key=>{let candidate=true;if(candidate&&kty!==void 0&&key.jwk.kty!==kty){candidate=false}if(candidate&&kid!==void 0&&key.jwk.kid!==kid){candidate=false}if(candidate&&use!==void 0&&key.jwk.use!==void 0&&key.jwk.use!==use){candidate=false}if(candidate&&key.jwk.alg&&key.jwk.alg!==alg){candidate=false}else if(!key.algorithms.has(alg)){candidate=false}return candidate}).sort((first,second)=>keyscore(second,search2)-keyscore(first,search2))}get(...args2){return this.all(...args2)[0]}static async fromJWKS(jwks,{onlyPublic=false,onlyPrivate=false}={}){if(!isPlainObject3(jwks)||!Array.isArray(jwks.keys)||jwks.keys.some(k=>!isPlainObject3(k)||!("kty"in k))){throw new TypeError("jwks must be a JSON Web Key Set formatted object")}const keys2=[];for(let jwk of jwks.keys){jwk=clone2(jwk);const{kty,kid,crv}=jwk;let{alg,use}=jwk;if(typeof kty!=="string"||!kty){continue}if(use!==void 0&&use!=="sig"&&use!=="enc"){continue}if(typeof alg!=="string"&&alg!==void 0){continue}if(typeof kid!=="string"&&kid!==void 0){continue}if(kty==="EC"&&use==="sig"){switch(crv){case"P-256":alg="ES256";break;case"P-384":alg="ES384";break;case"P-521":alg="ES512";break;default:break}}if(crv==="secp256k1"){use="sig";alg="ES256K"}if(kty==="OKP"){switch(crv){case"Ed25519":case"Ed448":use="sig";alg="EdDSA";break;case"X25519":case"X448":use="enc";break;default:break}}if(alg&&!use){switch(true){case alg.startsWith("ECDH"):use="enc";break;case alg.startsWith("RSA"):use="enc";break;default:break}}if(onlyPrivate&&(jwk.kty==="oct"||!jwk.d)){throw new Error("jwks must only contain private keys")}if(onlyPublic&&(jwk.d||jwk.k)){continue}keys2.push({jwk:{...jwk,alg,use},async keyObject(alg2){if(this[alg2]){return this[alg2]}const keyObject=await jose.importJWK(this.jwk,alg2);this[alg2]=keyObject;return keyObject},get algorithms(){Object.defineProperty(this,"algorithms",{value:getAlgorithms(this.jwk.use,this.jwk.alg,this.jwk.kty,this.jwk.crv),enumerable:true,configurable:false});return this.algorithms}})}return new this(internal,keys2)}filter(...args2){return this.#keys.filter(...args2)}find(...args2){return this.#keys.find(...args2)}every(...args2){return this.#keys.every(...args2)}some(...args2){return this.#keys.some(...args2)}map(...args2){return this.#keys.map(...args2)}forEach(...args2){return this.#keys.forEach(...args2)}reduce(...args2){return this.#keys.reduce(...args2)}sort(...args2){return this.#keys.sort(...args2)}*[Symbol.iterator](){for(const key of this.#keys){yield key}}}}});var require_merge=__commonJS({"node_modules/openid-client/lib/helpers/merge.js"(exports2,module2){var isPlainObject3=require_is_plain_object();function merge3(target,...sources){for(const source of sources){if(!isPlainObject3(source)){continue}for(const[key,value]of Object.entries(source)){if(key==="__proto__"||key==="constructor"){continue}if(isPlainObject3(target[key])&&isPlainObject3(value)){target[key]=merge3(target[key],value)}else if(typeof value!=="undefined"){target[key]=value}}}return target}module2.exports=merge3}});var require_client=__commonJS({"node_modules/openid-client/lib/helpers/client.js"(exports2,module2){var jose=require_cjs();var{RPError}=require_errors2();var{assertIssuerConfiguration}=require_assert();var{random:random3}=require_generators();var now3=require_unix_timestamp();var request=require_request();var{keystores}=require_weak_cache();var merge3=require_merge();var formUrlEncode=value=>encodeURIComponent(value).replace(/%20/g,"+");async function clientAssertion(endpoint,payload){let alg=this[`${endpoint}_endpoint_auth_signing_alg`];if(!alg){assertIssuerConfiguration(this.issuer,`${endpoint}_endpoint_auth_signing_alg_values_supported`)}if(this[`${endpoint}_endpoint_auth_method`]==="client_secret_jwt"){if(!alg){const supported=this.issuer[`${endpoint}_endpoint_auth_signing_alg_values_supported`];alg=Array.isArray(supported)&&supported.find(signAlg=>/^HS(?:256|384|512)/.test(signAlg))}if(!alg){throw new RPError(`failed to determine a JWS Algorithm to use for ${this[`${endpoint}_endpoint_auth_method`]} Client Assertion`)}return new jose.CompactSign(Buffer.from(JSON.stringify(payload))).setProtectedHeader({alg}).sign(this.secretForAlg(alg))}const keystore=await keystores.get(this);if(!keystore){throw new TypeError("no client jwks provided for signing a client assertion with")}if(!alg){const supported=this.issuer[`${endpoint}_endpoint_auth_signing_alg_values_supported`];alg=Array.isArray(supported)&&supported.find(signAlg=>keystore.get({alg:signAlg,use:"sig"}))}if(!alg){throw new RPError(`failed to determine a JWS Algorithm to use for ${this[`${endpoint}_endpoint_auth_method`]} Client Assertion`)}const key=keystore.get({alg,use:"sig"});if(!key){throw new RPError(`no key found in client jwks to sign a client assertion with using alg ${alg}`)}return new jose.CompactSign(Buffer.from(JSON.stringify(payload))).setProtectedHeader({alg,kid:key.jwk&&key.jwk.kid}).sign(await key.keyObject(alg))}async function authFor(endpoint,{clientAssertionPayload}={}){const authMethod=this[`${endpoint}_endpoint_auth_method`];switch(authMethod){case"self_signed_tls_client_auth":case"tls_client_auth":case"none":return{form:{client_id:this.client_id}};case"client_secret_post":if(typeof this.client_secret!=="string"){throw new TypeError("client_secret_post client authentication method requires a client_secret")}return{form:{client_id:this.client_id,client_secret:this.client_secret}};case"private_key_jwt":case"client_secret_jwt":{const timestamp2=now3();const audience=[...new Set([this.issuer.issuer,this.issuer.token_endpoint].filter(Boolean))];const assertion=await clientAssertion.call(this,endpoint,{iat:timestamp2,exp:timestamp2+60,jti:random3(),iss:this.client_id,sub:this.client_id,aud:audience,...clientAssertionPayload});return{form:{client_id:this.client_id,client_assertion:assertion,client_assertion_type:"urn:ietf:params:oauth:client-assertion-type:jwt-bearer"}}}case"client_secret_basic":{if(typeof this.client_secret!=="string"){throw new TypeError("client_secret_basic client authentication method requires a client_secret")}const encoded=`${formUrlEncode(this.client_id)}:${formUrlEncode(this.client_secret)}`;const value=Buffer.from(encoded).toString("base64");return{headers:{Authorization:`Basic ${value}`}}}default:{throw new TypeError(`missing, or unsupported, ${endpoint}_endpoint_auth_method`)}}}function resolveResponseType(){const{length,0:value}=this.response_types;if(length===1){return value}return void 0}function resolveRedirectUri(){const{length,0:value}=this.redirect_uris||[];if(length===1){return value}return void 0}async function authenticatedPost(endpoint,opts,{clientAssertionPayload,endpointAuthMethod=endpoint,DPoP}={}){const auth=await authFor.call(this,endpointAuthMethod,{clientAssertionPayload});const requestOpts=merge3(opts,auth);const mTLS=this[`${endpointAuthMethod}_endpoint_auth_method`].includes("tls_client_auth")||endpoint==="token"&&this.tls_client_certificate_bound_access_tokens;let targetUrl;if(mTLS&&this.issuer.mtls_endpoint_aliases){targetUrl=this.issuer.mtls_endpoint_aliases[`${endpoint}_endpoint`]}targetUrl=targetUrl||this.issuer[`${endpoint}_endpoint`];if("form"in requestOpts){for(const[key,value]of Object.entries(requestOpts.form)){if(typeof value==="undefined"){delete requestOpts.form[key]}}}return request.call(this,{...requestOpts,method:"POST",url:targetUrl,headers:{...endpoint!=="revocation"?{Accept:"application/json"}:void 0,...requestOpts.headers}},{mTLS,DPoP})}module2.exports={resolveResponseType,resolveRedirectUri,authFor,authenticatedPost}}});var require_object_hash=__commonJS({"node_modules/object-hash/index.js"(exports2,module2){"use strict";var crypto5=require("crypto");exports2=module2.exports=objectHash;function objectHash(object,options){options=applyDefaults(object,options);return hash(object,options)}exports2.sha1=function(object){return objectHash(object)};exports2.keys=function(object){return objectHash(object,{excludeValues:true,algorithm:"sha1",encoding:"hex"})};exports2.MD5=function(object){return objectHash(object,{algorithm:"md5",encoding:"hex"})};exports2.keysMD5=function(object){return objectHash(object,{algorithm:"md5",encoding:"hex",excludeValues:true})};var hashes=crypto5.getHashes?crypto5.getHashes().slice():["sha1","md5"];hashes.push("passthrough");var encodings=["buffer","hex","binary","base64"];function applyDefaults(object,sourceOptions){sourceOptions=sourceOptions||{};var options={};options.algorithm=sourceOptions.algorithm||"sha1";options.encoding=sourceOptions.encoding||"hex";options.excludeValues=sourceOptions.excludeValues?true:false;options.algorithm=options.algorithm.toLowerCase();options.encoding=options.encoding.toLowerCase();options.ignoreUnknown=sourceOptions.ignoreUnknown!==true?false:true;options.respectType=sourceOptions.respectType===false?false:true;options.respectFunctionNames=sourceOptions.respectFunctionNames===false?false:true;options.respectFunctionProperties=sourceOptions.respectFunctionProperties===false?false:true;options.unorderedArrays=sourceOptions.unorderedArrays!==true?false:true;options.unorderedSets=sourceOptions.unorderedSets===false?false:true;options.unorderedObjects=sourceOptions.unorderedObjects===false?false:true;options.replacer=sourceOptions.replacer||void 0;options.excludeKeys=sourceOptions.excludeKeys||void 0;if(typeof object==="undefined"){throw new Error("Object argument required.")}for(var i=0;i<hashes.length;++i){if(hashes[i].toLowerCase()===options.algorithm.toLowerCase()){options.algorithm=hashes[i]}}if(hashes.indexOf(options.algorithm)===-1){throw new Error('Algorithm "'+options.algorithm+'"  not supported. supported values: '+hashes.join(", "))}if(encodings.indexOf(options.encoding)===-1&&options.algorithm!=="passthrough"){throw new Error('Encoding "'+options.encoding+'"  not supported. supported values: '+encodings.join(", "))}return options}function isNativeFunction(f){if(typeof f!=="function"){return false}var exp=/^function\s+\w*\s*\(\s*\)\s*{\s+\[native code\]\s+}$/i;return exp.exec(Function.prototype.toString.call(f))!=null}function hash(object,options){var hashingStream;if(options.algorithm!=="passthrough"){hashingStream=crypto5.createHash(options.algorithm)}else{hashingStream=new PassThrough}if(typeof hashingStream.write==="undefined"){hashingStream.write=hashingStream.update;hashingStream.end=hashingStream.update}var hasher=typeHasher(options,hashingStream);hasher.dispatch(object);if(!hashingStream.update){hashingStream.end("")}if(hashingStream.digest){return hashingStream.digest(options.encoding==="buffer"?void 0:options.encoding)}var buf=hashingStream.read();if(options.encoding==="buffer"){return buf}return buf.toString(options.encoding)}exports2.writeToStream=function(object,options,stream3){if(typeof stream3==="undefined"){stream3=options;options={}}options=applyDefaults(object,options);return typeHasher(options,stream3).dispatch(object)};function typeHasher(options,writeTo,context){context=context||[];var write2=function(str2){if(writeTo.update){return writeTo.update(str2,"utf8")}else{return writeTo.write(str2,"utf8")}};return{dispatch:function(value){if(options.replacer){value=options.replacer(value)}var type2=typeof value;if(value===null){type2="null"}return this["_"+type2](value)},_object:function(object){var pattern=/\[object (.*)\]/i;var objString=Object.prototype.toString.call(object);var objType=pattern.exec(objString);if(!objType){objType="unknown:["+objString+"]"}else{objType=objType[1]}objType=objType.toLowerCase();var objectNumber=null;if((objectNumber=context.indexOf(object))>=0){return this.dispatch("[CIRCULAR:"+objectNumber+"]")}else{context.push(object)}if(typeof Buffer!=="undefined"&&Buffer.isBuffer&&Buffer.isBuffer(object)){write2("buffer:");return write2(object)}if(objType!=="object"&&objType!=="function"&&objType!=="asyncfunction"){if(this["_"+objType]){this["_"+objType](object)}else if(options.ignoreUnknown){return write2("["+objType+"]")}else{throw new Error('Unknown object type "'+objType+'"')}}else{var keys2=Object.keys(object);if(options.unorderedObjects){keys2=keys2.sort()}if(options.respectType!==false&&!isNativeFunction(object)){keys2.splice(0,0,"prototype","__proto__","constructor")}if(options.excludeKeys){keys2=keys2.filter(function(key){return!options.excludeKeys(key)})}write2("object:"+keys2.length+":");var self2=this;return keys2.forEach(function(key){self2.dispatch(key);write2(":");if(!options.excludeValues){self2.dispatch(object[key])}write2(",")})}},_array:function(arr,unordered){unordered=typeof unordered!=="undefined"?unordered:options.unorderedArrays!==false;var self2=this;write2("array:"+arr.length+":");if(!unordered||arr.length<=1){return arr.forEach(function(entry){return self2.dispatch(entry)})}var contextAdditions=[];var entries2=arr.map(function(entry){var strm=new PassThrough;var localContext=context.slice();var hasher=typeHasher(options,strm,localContext);hasher.dispatch(entry);contextAdditions=contextAdditions.concat(localContext.slice(context.length));return strm.read().toString()});context=context.concat(contextAdditions);entries2.sort();return this._array(entries2,false)},_date:function(date){return write2("date:"+date.toJSON())},_symbol:function(sym){return write2("symbol:"+sym.toString())},_error:function(err){return write2("error:"+err.toString())},_boolean:function(bool2){return write2("bool:"+bool2.toString())},_string:function(string){write2("string:"+string.length+":");write2(string.toString())},_function:function(fn2){write2("fn:");if(isNativeFunction(fn2)){this.dispatch("[native]")}else{this.dispatch(fn2.toString())}if(options.respectFunctionNames!==false){this.dispatch("function-name:"+String(fn2.name))}if(options.respectFunctionProperties){this._object(fn2)}},_number:function(number2){return write2("number:"+number2.toString())},_xml:function(xml){return write2("xml:"+xml.toString())},_null:function(){return write2("Null")},_undefined:function(){return write2("Undefined")},_regexp:function(regex3){return write2("regex:"+regex3.toString())},_uint8array:function(arr){write2("uint8array:");return this.dispatch(Array.prototype.slice.call(arr))},_uint8clampedarray:function(arr){write2("uint8clampedarray:");return this.dispatch(Array.prototype.slice.call(arr))},_int8array:function(arr){write2("uint8array:");return this.dispatch(Array.prototype.slice.call(arr))},_uint16array:function(arr){write2("uint16array:");return this.dispatch(Array.prototype.slice.call(arr))},_int16array:function(arr){write2("uint16array:");return this.dispatch(Array.prototype.slice.call(arr))},_uint32array:function(arr){write2("uint32array:");return this.dispatch(Array.prototype.slice.call(arr))},_int32array:function(arr){write2("uint32array:");return this.dispatch(Array.prototype.slice.call(arr))},_float32array:function(arr){write2("float32array:");return this.dispatch(Array.prototype.slice.call(arr))},_float64array:function(arr){write2("float64array:");return this.dispatch(Array.prototype.slice.call(arr))},_arraybuffer:function(arr){write2("arraybuffer:");return this.dispatch(new Uint8Array(arr))},_url:function(url){return write2("url:"+url.toString(),"utf8")},_map:function(map3){write2("map:");var arr=Array.from(map3);return this._array(arr,options.unorderedSets!==false)},_set:function(set3){write2("set:");var arr=Array.from(set3);return this._array(arr,options.unorderedSets!==false)},_file:function(file){write2("file:");return this.dispatch([file.name,file.size,file.type,file.lastModfied])},_blob:function(){if(options.ignoreUnknown){return write2("[blob]")}throw Error('Hashing Blob objects is currently not supported\n(see https://github.com/puleos/object-hash/issues/26)\nUse "options.replacer" or "options.ignoreUnknown"\n')},_domwindow:function(){return write2("domwindow")},_bigint:function(number2){return write2("bigint:"+number2.toString())},_process:function(){return write2("process")},_timer:function(){return write2("timer")},_pipe:function(){return write2("pipe")},_tcp:function(){return write2("tcp")},_udp:function(){return write2("udp")},_tty:function(){return write2("tty")},_statwatcher:function(){return write2("statwatcher")},_securecontext:function(){return write2("securecontext")},_connection:function(){return write2("connection")},_zlib:function(){return write2("zlib")},_context:function(){return write2("context")},_nodescript:function(){return write2("nodescript")},_httpparser:function(){return write2("httpparser")},_dataview:function(){return write2("dataview")},_signal:function(){return write2("signal")},_fsevent:function(){return write2("fsevent")},_tlswrap:function(){return write2("tlswrap")}}}function PassThrough(){return{buf:"",write:function(b){this.buf+=b},end:function(b){this.buf+=b},read:function(){return this.buf}}}}});var require_issuer=__commonJS({"node_modules/openid-client/lib/helpers/issuer.js"(exports2,module2){var objectHash=require_object_hash();var LRU=require_lru_cache();var{RPError}=require_errors2();var{assertIssuerConfiguration}=require_assert();var KeyStore2=require_keystore();var{keystores}=require_weak_cache();var processResponse=require_process_response();var request=require_request();var inFlight=new WeakMap;var caches=new WeakMap;var lrus=ctx=>{if(!caches.has(ctx)){caches.set(ctx,new LRU({max:100}))}return caches.get(ctx)};async function getKeyStore(reload=false){assertIssuerConfiguration(this,"jwks_uri");const keystore=keystores.get(this);const cache2=lrus(this);if(reload||!keystore){if(inFlight.has(this)){return inFlight.get(this)}cache2.reset();inFlight.set(this,(async()=>{const response=await request.call(this,{method:"GET",responseType:"json",url:this.jwks_uri,headers:{Accept:"application/json, application/jwk-set+json"}}).finally(()=>{inFlight.delete(this)});const jwks=processResponse(response);const joseKeyStore=KeyStore2.fromJWKS(jwks,{onlyPublic:true});cache2.set("throttle",true,60*1e3);keystores.set(this,joseKeyStore);return joseKeyStore})());return inFlight.get(this)}return keystore}async function queryKeyStore({kid,kty,alg,use},{allowMulti=false}={}){const cache2=lrus(this);const def={kid,kty,alg,use};const defHash=objectHash(def,{algorithm:"sha256",ignoreUnknown:true,unorderedArrays:true,unorderedSets:true,respectType:false});const freshJwksUri=cache2.get(defHash)||cache2.get("throttle");const keystore=await getKeyStore.call(this,!freshJwksUri);const keys2=keystore.all(def);delete def.use;if(keys2.length===0){throw new RPError({printf:["no valid key found in issuer's jwks_uri for key parameters %j",def],jwks:keystore})}if(!allowMulti&&keys2.length>1&&!kid){throw new RPError({printf:["multiple matching keys found in issuer's jwks_uri for key parameters %j, kid must be provided in this case",def],jwks:keystore})}cache2.set(defHash,true);return keys2}module2.exports.queryKeyStore=queryKeyStore;module2.exports.keystore=getKeyStore}});var require_device_flow_handle=__commonJS({"node_modules/openid-client/lib/device_flow_handle.js"(exports2,module2){var{inspect:inspect3}=require("util");var{RPError,OPError}=require_errors2();var now3=require_unix_timestamp();var DeviceFlowHandle=class{#aborted;#client;#clientAssertionPayload;#DPoP;#exchangeBody;#expires_at;#interval;#maxAge;#response;constructor({client,exchangeBody,clientAssertionPayload,response,maxAge,DPoP}){["verification_uri","user_code","device_code"].forEach(prop=>{if(typeof response[prop]!=="string"||!response[prop]){throw new RPError(`expected ${prop} string to be returned by Device Authorization Response, got %j`,response[prop])}});if(!Number.isSafeInteger(response.expires_in)){throw new RPError("expected expires_in number to be returned by Device Authorization Response, got %j",response.expires_in)}this.#expires_at=now3()+response.expires_in;this.#client=client;this.#DPoP=DPoP;this.#maxAge=maxAge;this.#exchangeBody=exchangeBody;this.#clientAssertionPayload=clientAssertionPayload;this.#response=response;this.#interval=response.interval*1e3||5e3}abort(){this.#aborted=true}async poll({signal}={}){if(signal&&signal.aborted||this.#aborted){throw new RPError("polling aborted")}if(this.expired()){throw new RPError("the device code %j has expired and the device authorization session has concluded",this.device_code)}await new Promise(resolve=>setTimeout(resolve,this.#interval));let tokenset;try{tokenset=await this.#client.grant({...this.#exchangeBody,grant_type:"urn:ietf:params:oauth:grant-type:device_code",device_code:this.device_code},{clientAssertionPayload:this.#clientAssertionPayload,DPoP:this.#DPoP})}catch(err){switch(err instanceof OPError&&err.error){case"slow_down":this.#interval+=5e3;case"authorization_pending":return this.poll({signal});default:throw err}}if("id_token"in tokenset){await this.#client.decryptIdToken(tokenset);await this.#client.validateIdToken(tokenset,void 0,"token",this.#maxAge)}return tokenset}get device_code(){return this.#response.device_code}get user_code(){return this.#response.user_code}get verification_uri(){return this.#response.verification_uri}get verification_uri_complete(){return this.#response.verification_uri_complete}get expires_in(){return Math.max.apply(null,[this.#expires_at-now3(),0])}expired(){return this.expires_in===0}[inspect3.custom](){return`${this.constructor.name} ${inspect3(this.#response,{depth:Infinity,colors:process.stdout.isTTY,compact:false,sorted:true})}`}};module2.exports=DeviceFlowHandle}});var require_client2=__commonJS({"node_modules/openid-client/lib/client.js"(exports2,module2){var{inspect:inspect3}=require("util");var stdhttp=require("http");var crypto5=require("crypto");var{strict:assert2}=require("assert");var querystring=require("querystring");var url=require("url");var{URL:URL3,URLSearchParams:URLSearchParams2}=require("url");var jose=require_cjs();var tokenHash=require_lib2();var isKeyObject=require_is_key_object2();var decodeJWT=require_decode_jwt2();var base64url=require_base64url3();var defaults3=require_defaults();var parseWwwAuthenticate=require_www_authenticate_parser();var{assertSigningAlgValuesSupport,assertIssuerConfiguration}=require_assert();var pick2=require_pick();var isPlainObject3=require_is_plain_object();var processResponse=require_process_response();var TokenSet2=require_token_set();var{OPError,RPError}=require_errors2();var now3=require_unix_timestamp();var{random:random3}=require_generators();var request=require_request();var{CLOCK_TOLERANCE}=require_consts();var{keystores}=require_weak_cache();var KeyStore2=require_keystore();var clone2=require_deep_clone();var{authenticatedPost,resolveResponseType,resolveRedirectUri}=require_client();var{queryKeyStore}=require_issuer();var DeviceFlowHandle=require_device_flow_handle();var[major3,minor3]=process.version.slice(1).split(".").map(str2=>parseInt(str2,10));var rsaPssParams2=major3>=17||major3===16&&minor3>=9;var retryAttempt=Symbol();var skipNonceCheck=Symbol();var skipMaxAgeCheck=Symbol();function pickCb(input){return pick2(input,"access_token","code","error_description","error_uri","error","expires_in","id_token","iss","response","session_state","state","token_type")}function authorizationHeaderValue(token2,tokenType="Bearer"){return`${tokenType} ${token2}`}function getSearchParams(input){const parsed=url.parse(input);if(!parsed.search)return{};return querystring.parse(parsed.search.substring(1))}function verifyPresence(payload,jwt,prop){if(payload[prop]===void 0){throw new RPError({message:`missing required JWT property ${prop}`,jwt})}}function authorizationParams(params){const authParams={client_id:this.client_id,scope:"openid",response_type:resolveResponseType.call(this),redirect_uri:resolveRedirectUri.call(this),...params};Object.entries(authParams).forEach(([key,value])=>{if(value===null||value===void 0){delete authParams[key]}else if(key==="claims"&&typeof value==="object"){authParams[key]=JSON.stringify(value)}else if(key==="resource"&&Array.isArray(value)){authParams[key]=value}else if(typeof value!=="string"){authParams[key]=String(value)}});return authParams}function getKeystore(jwks){if(!isPlainObject3(jwks)||!Array.isArray(jwks.keys)||jwks.keys.some(k=>!isPlainObject3(k)||!("kty"in k))){throw new TypeError("jwks must be a JSON Web Key Set formatted object")}return KeyStore2.fromJWKS(jwks,{onlyPrivate:true})}function checkBasicSupport(client,properties){try{const supported=client.issuer.token_endpoint_auth_methods_supported;if(!supported.includes(properties.token_endpoint_auth_method)){if(supported.includes("client_secret_post")){properties.token_endpoint_auth_method="client_secret_post"}}}catch(err){}}function handleCommonMistakes(client,metadata,properties){if(!metadata.token_endpoint_auth_method){checkBasicSupport(client,properties)}if(metadata.redirect_uri){if(metadata.redirect_uris){throw new TypeError("provide a redirect_uri or redirect_uris, not both")}properties.redirect_uris=[metadata.redirect_uri];delete properties.redirect_uri}if(metadata.response_type){if(metadata.response_types){throw new TypeError("provide a response_type or response_types, not both")}properties.response_types=[metadata.response_type];delete properties.response_type}}function getDefaultsForEndpoint(endpoint,issuer,properties){if(!issuer[`${endpoint}_endpoint`])return;const tokenEndpointAuthMethod=properties.token_endpoint_auth_method;const tokenEndpointAuthSigningAlg=properties.token_endpoint_auth_signing_alg;const eam=`${endpoint}_endpoint_auth_method`;const easa=`${endpoint}_endpoint_auth_signing_alg`;if(properties[eam]===void 0&&properties[easa]===void 0){if(tokenEndpointAuthMethod!==void 0){properties[eam]=tokenEndpointAuthMethod}if(tokenEndpointAuthSigningAlg!==void 0){properties[easa]=tokenEndpointAuthSigningAlg}}}var BaseClient3=class{#metadata;#issuer;#aadIssValidation;#additionalAuthorizedParties;constructor(issuer,aadIssValidation,metadata={},jwks,options){this.#metadata=new Map;this.#issuer=issuer;this.#aadIssValidation=aadIssValidation;if(typeof metadata.client_id!=="string"||!metadata.client_id){throw new TypeError("client_id is required")}const properties={grant_types:["authorization_code"],id_token_signed_response_alg:"RS256",authorization_signed_response_alg:"RS256",response_types:["code"],token_endpoint_auth_method:"client_secret_basic",...this.fapi1()?{grant_types:["authorization_code","implicit"],id_token_signed_response_alg:"PS256",authorization_signed_response_alg:"PS256",response_types:["code id_token"],tls_client_certificate_bound_access_tokens:true,token_endpoint_auth_method:void 0}:void 0,...this.fapi2()?{id_token_signed_response_alg:"PS256",authorization_signed_response_alg:"PS256",token_endpoint_auth_method:void 0}:void 0,...metadata};if(this.fapi()){switch(properties.token_endpoint_auth_method){case"self_signed_tls_client_auth":case"tls_client_auth":break;case"private_key_jwt":if(!jwks){throw new TypeError("jwks is required")}break;case void 0:throw new TypeError("token_endpoint_auth_method is required");default:throw new TypeError("invalid or unsupported token_endpoint_auth_method")}}if(this.fapi2()){if(properties.tls_client_certificate_bound_access_tokens&&properties.dpop_bound_access_tokens){throw new TypeError("either tls_client_certificate_bound_access_tokens or dpop_bound_access_tokens must be set to true")}if(!properties.tls_client_certificate_bound_access_tokens&&!properties.dpop_bound_access_tokens){throw new TypeError("either tls_client_certificate_bound_access_tokens or dpop_bound_access_tokens must be set to true")}}handleCommonMistakes(this,metadata,properties);assertSigningAlgValuesSupport("token",this.issuer,properties);["introspection","revocation"].forEach(endpoint=>{getDefaultsForEndpoint(endpoint,this.issuer,properties);assertSigningAlgValuesSupport(endpoint,this.issuer,properties)});Object.entries(properties).forEach(([key,value])=>{this.#metadata.set(key,value);if(!this[key]){Object.defineProperty(this,key,{get(){return this.#metadata.get(key)},enumerable:true})}});if(jwks!==void 0){const keystore=getKeystore.call(this,jwks);keystores.set(this,keystore)}if(options!=null&&options.additionalAuthorizedParties){this.#additionalAuthorizedParties=clone2(options.additionalAuthorizedParties)}this[CLOCK_TOLERANCE]=0}authorizationUrl(params={}){if(!isPlainObject3(params)){throw new TypeError("params must be a plain object")}assertIssuerConfiguration(this.issuer,"authorization_endpoint");const target=new URL3(this.issuer.authorization_endpoint);for(const[name,value]of Object.entries(authorizationParams.call(this,params))){if(Array.isArray(value)){target.searchParams.delete(name);for(const member of value){target.searchParams.append(name,member)}}else{target.searchParams.set(name,value)}}return target.href.replace(/\+/g,"%20")}authorizationPost(params={}){if(!isPlainObject3(params)){throw new TypeError("params must be a plain object")}const inputs=authorizationParams.call(this,params);const formInputs=Object.keys(inputs).map(name=>`<input type="hidden" name="${name}" value="${inputs[name]}"/>`).join("\n");return`<!DOCTYPE html>
<head>
<title>Requesting Authorization</title>
</head>
<body onload="javascript:document.forms[0].submit()">
<form method="post" action="${this.issuer.authorization_endpoint}">
  ${formInputs}
</form>
</body>
</html>`}endSessionUrl(params={}){assertIssuerConfiguration(this.issuer,"end_session_endpoint");const{0:postLogout,length}=this.post_logout_redirect_uris||[];const{post_logout_redirect_uri=length===1?postLogout:void 0}=params;let id_token_hint;({id_token_hint,...params}=params);if(id_token_hint instanceof TokenSet2){if(!id_token_hint.id_token){throw new TypeError("id_token not present in TokenSet")}id_token_hint=id_token_hint.id_token}const target=url.parse(this.issuer.end_session_endpoint);const query=defaults3(getSearchParams(this.issuer.end_session_endpoint),params,{post_logout_redirect_uri,client_id:this.client_id},{id_token_hint});Object.entries(query).forEach(([key,value])=>{if(value===null||value===void 0){delete query[key]}});target.search=null;target.query=query;return url.format(target)}callbackParams(input){const isIncomingMessage=input instanceof stdhttp.IncomingMessage||input&&input.method&&input.url;const isString3=typeof input==="string";if(!isString3&&!isIncomingMessage){throw new TypeError("#callbackParams only accepts string urls, http.IncomingMessage or a lookalike")}if(isIncomingMessage){switch(input.method){case"GET":return pickCb(getSearchParams(input.url));case"POST":if(input.body===void 0){throw new TypeError("incoming message body missing, include a body parser prior to this method call")}switch(typeof input.body){case"object":case"string":if(Buffer.isBuffer(input.body)){return pickCb(querystring.parse(input.body.toString("utf-8")))}if(typeof input.body==="string"){return pickCb(querystring.parse(input.body))}return pickCb(input.body);default:throw new TypeError("invalid IncomingMessage body object")}default:throw new TypeError("invalid IncomingMessage method")}}else{return pickCb(getSearchParams(input))}}async callback(redirectUri,parameters,checks2={},{exchangeBody,clientAssertionPayload,DPoP}={}){let params=pickCb(parameters);if(checks2.jarm&&!("response"in parameters)){throw new RPError({message:"expected a JARM response",checks:checks2,params})}else if("response"in parameters){const decrypted=await this.decryptJARM(params.response);params=await this.validateJARM(decrypted)}if(this.default_max_age&&!checks2.max_age){checks2.max_age=this.default_max_age}if(params.state&&!checks2.state){throw new TypeError("checks.state argument is missing")}if(!params.state&&checks2.state){throw new RPError({message:"state missing from the response",checks:checks2,params})}if(checks2.state!==params.state){throw new RPError({printf:["state mismatch, expected %s, got: %s",checks2.state,params.state],checks:checks2,params})}if("iss"in params){assertIssuerConfiguration(this.issuer,"issuer");if(params.iss!==this.issuer.issuer){throw new RPError({printf:["iss mismatch, expected %s, got: %s",this.issuer.issuer,params.iss],params})}}else if(this.issuer.authorization_response_iss_parameter_supported&&!("id_token"in params)&&!("response"in parameters)){throw new RPError({message:"iss missing from the response",params})}if(params.error){throw new OPError(params)}const RESPONSE_TYPE_REQUIRED_PARAMS={code:["code"],id_token:["id_token"],token:["access_token","token_type"]};if(checks2.response_type){for(const type2 of checks2.response_type.split(" ")){if(type2==="none"){if(params.code||params.id_token||params.access_token){throw new RPError({message:'unexpected params encountered for "none" response',checks:checks2,params})}}else{for(const param of RESPONSE_TYPE_REQUIRED_PARAMS[type2]){if(!params[param]){throw new RPError({message:`${param} missing from response`,checks:checks2,params})}}}}}if(params.id_token){const tokenset=new TokenSet2(params);await this.decryptIdToken(tokenset);await this.validateIdToken(tokenset,checks2.nonce,"authorization",checks2.max_age,checks2.state);if(!params.code){return tokenset}}if(params.code){const tokenset=await this.grant({...exchangeBody,grant_type:"authorization_code",code:params.code,redirect_uri:redirectUri,code_verifier:checks2.code_verifier},{clientAssertionPayload,DPoP});await this.decryptIdToken(tokenset);await this.validateIdToken(tokenset,checks2.nonce,"token",checks2.max_age);if(params.session_state){tokenset.session_state=params.session_state}return tokenset}return new TokenSet2(params)}async oauthCallback(redirectUri,parameters,checks2={},{exchangeBody,clientAssertionPayload,DPoP}={}){let params=pickCb(parameters);if(checks2.jarm&&!("response"in parameters)){throw new RPError({message:"expected a JARM response",checks:checks2,params})}else if("response"in parameters){const decrypted=await this.decryptJARM(params.response);params=await this.validateJARM(decrypted)}if(params.state&&!checks2.state){throw new TypeError("checks.state argument is missing")}if(!params.state&&checks2.state){throw new RPError({message:"state missing from the response",checks:checks2,params})}if(checks2.state!==params.state){throw new RPError({printf:["state mismatch, expected %s, got: %s",checks2.state,params.state],checks:checks2,params})}if("iss"in params){assertIssuerConfiguration(this.issuer,"issuer");if(params.iss!==this.issuer.issuer){throw new RPError({printf:["iss mismatch, expected %s, got: %s",this.issuer.issuer,params.iss],params})}}else if(this.issuer.authorization_response_iss_parameter_supported&&!("id_token"in params)&&!("response"in parameters)){throw new RPError({message:"iss missing from the response",params})}if(params.error){throw new OPError(params)}if(typeof params.id_token==="string"&&params.id_token.length){throw new RPError({message:"id_token detected in the response, you must use client.callback() instead of client.oauthCallback()",params})}delete params.id_token;const RESPONSE_TYPE_REQUIRED_PARAMS={code:["code"],token:["access_token","token_type"]};if(checks2.response_type){for(const type2 of checks2.response_type.split(" ")){if(type2==="none"){if(params.code||params.id_token||params.access_token){throw new RPError({message:'unexpected params encountered for "none" response',checks:checks2,params})}}if(RESPONSE_TYPE_REQUIRED_PARAMS[type2]){for(const param of RESPONSE_TYPE_REQUIRED_PARAMS[type2]){if(!params[param]){throw new RPError({message:`${param} missing from response`,checks:checks2,params})}}}}}if(params.code){const tokenset=await this.grant({...exchangeBody,grant_type:"authorization_code",code:params.code,redirect_uri:redirectUri,code_verifier:checks2.code_verifier},{clientAssertionPayload,DPoP});if(typeof tokenset.id_token==="string"&&tokenset.id_token.length){throw new RPError({message:"id_token detected in the response, you must use client.callback() instead of client.oauthCallback()",params})}delete tokenset.id_token;return tokenset}return new TokenSet2(params)}async decryptIdToken(token2){if(!this.id_token_encrypted_response_alg){return token2}let idToken=token2;if(idToken instanceof TokenSet2){if(!idToken.id_token){throw new TypeError("id_token not present in TokenSet")}idToken=idToken.id_token}const expectedAlg=this.id_token_encrypted_response_alg;const expectedEnc=this.id_token_encrypted_response_enc;const result2=await this.decryptJWE(idToken,expectedAlg,expectedEnc);if(token2 instanceof TokenSet2){token2.id_token=result2;return token2}return result2}async validateJWTUserinfo(body){const expectedAlg=this.userinfo_signed_response_alg;return this.validateJWT(body,expectedAlg,[])}async decryptJARM(response){if(!this.authorization_encrypted_response_alg){return response}const expectedAlg=this.authorization_encrypted_response_alg;const expectedEnc=this.authorization_encrypted_response_enc;return this.decryptJWE(response,expectedAlg,expectedEnc)}async decryptJWTUserinfo(body){if(!this.userinfo_encrypted_response_alg){return body}const expectedAlg=this.userinfo_encrypted_response_alg;const expectedEnc=this.userinfo_encrypted_response_enc;return this.decryptJWE(body,expectedAlg,expectedEnc)}async decryptJWE(jwe,expectedAlg,expectedEnc="A128CBC-HS256"){const header2=JSON.parse(base64url.decode(jwe.split(".")[0]));if(header2.alg!==expectedAlg){throw new RPError({printf:["unexpected JWE alg received, expected %s, got: %s",expectedAlg,header2.alg],jwt:jwe})}if(header2.enc!==expectedEnc){throw new RPError({printf:["unexpected JWE enc received, expected %s, got: %s",expectedEnc,header2.enc],jwt:jwe})}const getPlaintext=result2=>new TextDecoder().decode(result2.plaintext);let plaintext;if(expectedAlg.match(/^(?:RSA|ECDH)/)){const keystore=await keystores.get(this);const protectedHeader=jose.decodeProtectedHeader(jwe);for(const key of keystore.all({...protectedHeader,use:"enc"})){plaintext=await jose.compactDecrypt(jwe,await key.keyObject(protectedHeader.alg)).then(getPlaintext,()=>{});if(plaintext)break}}else{plaintext=await jose.compactDecrypt(jwe,this.secretForAlg(expectedAlg==="dir"?expectedEnc:expectedAlg)).then(getPlaintext,()=>{})}if(!plaintext){throw new RPError({message:"failed to decrypt JWE",jwt:jwe})}return plaintext}async validateIdToken(tokenSet,nonce,returnedBy,maxAge,state){let idToken=tokenSet;const expectedAlg=this.id_token_signed_response_alg;const isTokenSet=idToken instanceof TokenSet2;if(isTokenSet){if(!idToken.id_token){throw new TypeError("id_token not present in TokenSet")}idToken=idToken.id_token}idToken=String(idToken);const timestamp2=now3();const{protected:header2,payload,key}=await this.validateJWT(idToken,expectedAlg);if(typeof maxAge==="number"||maxAge!==skipMaxAgeCheck&&this.require_auth_time){if(!payload.auth_time){throw new RPError({message:"missing required JWT property auth_time",jwt:idToken})}if(typeof payload.auth_time!=="number"){throw new RPError({message:"JWT auth_time claim must be a JSON numeric value",jwt:idToken})}}if(typeof maxAge==="number"&&payload.auth_time+maxAge<timestamp2-this[CLOCK_TOLERANCE]){throw new RPError({printf:["too much time has elapsed since the last End-User authentication, max_age %i, auth_time: %i, now %i",maxAge,payload.auth_time,timestamp2-this[CLOCK_TOLERANCE]],now:timestamp2,tolerance:this[CLOCK_TOLERANCE],auth_time:payload.auth_time,jwt:idToken})}if(nonce!==skipNonceCheck&&(payload.nonce||nonce!==void 0)&&payload.nonce!==nonce){throw new RPError({printf:["nonce mismatch, expected %s, got: %s",nonce,payload.nonce],jwt:idToken})}if(returnedBy==="authorization"){if(!payload.at_hash&&tokenSet.access_token){throw new RPError({message:"missing required property at_hash",jwt:idToken})}if(!payload.c_hash&&tokenSet.code){throw new RPError({message:"missing required property c_hash",jwt:idToken})}if(this.fapi1()){if(!payload.s_hash&&(tokenSet.state||state)){throw new RPError({message:"missing required property s_hash",jwt:idToken})}}if(payload.s_hash){if(!state){throw new TypeError('cannot verify s_hash, "checks.state" property not provided')}try{tokenHash.validate({claim:"s_hash",source:"state"},payload.s_hash,state,header2.alg,key.jwk&&key.jwk.crv)}catch(err){throw new RPError({message:err.message,jwt:idToken})}}}if(this.fapi()&&payload.iat<timestamp2-3600){throw new RPError({printf:["JWT issued too far in the past, now %i, iat %i",timestamp2,payload.iat],now:timestamp2,tolerance:this[CLOCK_TOLERANCE],iat:payload.iat,jwt:idToken})}if(tokenSet.access_token&&payload.at_hash!==void 0){try{tokenHash.validate({claim:"at_hash",source:"access_token"},payload.at_hash,tokenSet.access_token,header2.alg,key.jwk&&key.jwk.crv)}catch(err){throw new RPError({message:err.message,jwt:idToken})}}if(tokenSet.code&&payload.c_hash!==void 0){try{tokenHash.validate({claim:"c_hash",source:"code"},payload.c_hash,tokenSet.code,header2.alg,key.jwk&&key.jwk.crv)}catch(err){throw new RPError({message:err.message,jwt:idToken})}}return tokenSet}async validateJWT(jwt,expectedAlg,required=["iss","sub","aud","exp","iat"]){const isSelfIssued=this.issuer.issuer==="https://self-issued.me";const timestamp2=now3();let header2;let payload;try{({header:header2,payload}=decodeJWT(jwt,{complete:true}))}catch(err){throw new RPError({printf:["failed to decode JWT (%s: %s)",err.name,err.message],jwt})}if(header2.alg!==expectedAlg){throw new RPError({printf:["unexpected JWT alg received, expected %s, got: %s",expectedAlg,header2.alg],jwt})}if(isSelfIssued){required=[...required,"sub_jwk"]}required.forEach(verifyPresence.bind(void 0,payload,jwt));if(payload.iss!==void 0){let expectedIss=this.issuer.issuer;if(this.#aadIssValidation){expectedIss=this.issuer.issuer.replace("{tenantid}",payload.tid)}if(payload.iss!==expectedIss){throw new RPError({printf:["unexpected iss value, expected %s, got: %s",expectedIss,payload.iss],jwt})}}if(payload.iat!==void 0){if(typeof payload.iat!=="number"){throw new RPError({message:"JWT iat claim must be a JSON numeric value",jwt})}}if(payload.nbf!==void 0){if(typeof payload.nbf!=="number"){throw new RPError({message:"JWT nbf claim must be a JSON numeric value",jwt})}if(payload.nbf>timestamp2+this[CLOCK_TOLERANCE]){throw new RPError({printf:["JWT not active yet, now %i, nbf %i",timestamp2+this[CLOCK_TOLERANCE],payload.nbf],now:timestamp2,tolerance:this[CLOCK_TOLERANCE],nbf:payload.nbf,jwt})}}if(payload.exp!==void 0){if(typeof payload.exp!=="number"){throw new RPError({message:"JWT exp claim must be a JSON numeric value",jwt})}if(timestamp2-this[CLOCK_TOLERANCE]>=payload.exp){throw new RPError({printf:["JWT expired, now %i, exp %i",timestamp2-this[CLOCK_TOLERANCE],payload.exp],now:timestamp2,tolerance:this[CLOCK_TOLERANCE],exp:payload.exp,jwt})}}if(payload.aud!==void 0){if(Array.isArray(payload.aud)){if(payload.aud.length>1&&!payload.azp){throw new RPError({message:"missing required JWT property azp",jwt})}if(!payload.aud.includes(this.client_id)){throw new RPError({printf:["aud is missing the client_id, expected %s to be included in %j",this.client_id,payload.aud],jwt})}}else if(payload.aud!==this.client_id){throw new RPError({printf:["aud mismatch, expected %s, got: %s",this.client_id,payload.aud],jwt})}}if(payload.azp!==void 0){let additionalAuthorizedParties=this.#additionalAuthorizedParties;if(typeof additionalAuthorizedParties==="string"){additionalAuthorizedParties=[this.client_id,additionalAuthorizedParties]}else if(Array.isArray(additionalAuthorizedParties)){additionalAuthorizedParties=[this.client_id,...additionalAuthorizedParties]}else{additionalAuthorizedParties=[this.client_id]}if(!additionalAuthorizedParties.includes(payload.azp)){throw new RPError({printf:["azp mismatch, got: %s",payload.azp],jwt})}}let keys2;if(isSelfIssued){try{assert2(isPlainObject3(payload.sub_jwk));const key=await jose.importJWK(payload.sub_jwk,header2.alg);assert2.equal(key.type,"public");keys2=[{keyObject(){return key}}]}catch(err){throw new RPError({message:"failed to use sub_jwk claim as an asymmetric JSON Web Key",jwt})}if(await jose.calculateJwkThumbprint(payload.sub_jwk)!==payload.sub){throw new RPError({message:"failed to match the subject with sub_jwk",jwt})}}else if(header2.alg.startsWith("HS")){keys2=[this.secretForAlg(header2.alg)]}else if(header2.alg!=="none"){keys2=await queryKeyStore.call(this.issuer,{...header2,use:"sig"})}if(!keys2&&header2.alg==="none"){return{protected:header2,payload}}for(const key of keys2){const verified=await jose.compactVerify(jwt,key instanceof Uint8Array?key:await key.keyObject(header2.alg)).catch(()=>{});if(verified){return{payload,protected:verified.protectedHeader,key}}}throw new RPError({message:"failed to validate JWT signature",jwt})}async refresh(refreshToken,{exchangeBody,clientAssertionPayload,DPoP}={}){let token2=refreshToken;if(token2 instanceof TokenSet2){if(!token2.refresh_token){throw new TypeError("refresh_token not present in TokenSet")}token2=token2.refresh_token}const tokenset=await this.grant({...exchangeBody,grant_type:"refresh_token",refresh_token:String(token2)},{clientAssertionPayload,DPoP});if(tokenset.id_token){await this.decryptIdToken(tokenset);await this.validateIdToken(tokenset,skipNonceCheck,"token",skipMaxAgeCheck);if(refreshToken instanceof TokenSet2&&refreshToken.id_token){const expectedSub=refreshToken.claims().sub;const actualSub=tokenset.claims().sub;if(actualSub!==expectedSub){throw new RPError({printf:["sub mismatch, expected %s, got: %s",expectedSub,actualSub],jwt:tokenset.id_token})}}}return tokenset}async requestResource(resourceUrl,accessToken,{method:method2,headers,body,DPoP,tokenType=DPoP?"DPoP":accessToken instanceof TokenSet2?accessToken.token_type:"Bearer"}={},retry){if(accessToken instanceof TokenSet2){if(!accessToken.access_token){throw new TypeError("access_token not present in TokenSet")}accessToken=accessToken.access_token}if(!accessToken){throw new TypeError("no access token provided")}else if(typeof accessToken!=="string"){throw new TypeError("invalid access token provided")}const requestOpts={headers:{Authorization:authorizationHeaderValue(accessToken,tokenType),...headers},body};const mTLS=!!this.tls_client_certificate_bound_access_tokens;const response=await request.call(this,{...requestOpts,responseType:"buffer",method:method2,url:resourceUrl},{accessToken,mTLS,DPoP});const wwwAuthenticate=response.headers["www-authenticate"];if(retry!==retryAttempt&&wwwAuthenticate&&wwwAuthenticate.toLowerCase().startsWith("dpop ")&&parseWwwAuthenticate(wwwAuthenticate).error==="use_dpop_nonce"){return this.requestResource(resourceUrl,accessToken,{method:method2,headers,body,DPoP,tokenType})}return response}async userinfo(accessToken,{method:method2="GET",via="header",tokenType,params,DPoP}={}){assertIssuerConfiguration(this.issuer,"userinfo_endpoint");const options={tokenType,method:String(method2).toUpperCase(),DPoP};if(options.method!=="GET"&&options.method!=="POST"){throw new TypeError("#userinfo() method can only be POST or a GET")}if(via==="body"&&options.method!=="POST"){throw new TypeError("can only send body on POST")}const jwt=!!(this.userinfo_signed_response_alg||this.userinfo_encrypted_response_alg);if(jwt){options.headers={Accept:"application/jwt"}}else{options.headers={Accept:"application/json"}}const mTLS=!!this.tls_client_certificate_bound_access_tokens;let targetUrl;if(mTLS&&this.issuer.mtls_endpoint_aliases){targetUrl=this.issuer.mtls_endpoint_aliases.userinfo_endpoint}targetUrl=new URL3(targetUrl||this.issuer.userinfo_endpoint);if(via==="body"){options.headers.Authorization=void 0;options.headers["Content-Type"]="application/x-www-form-urlencoded";options.body=new URLSearchParams2;options.body.append("access_token",accessToken instanceof TokenSet2?accessToken.access_token:accessToken)}if(params){if(options.method==="GET"){Object.entries(params).forEach(([key,value])=>{targetUrl.searchParams.append(key,value)})}else if(options.body){Object.entries(params).forEach(([key,value])=>{options.body.append(key,value)})}else{options.body=new URLSearchParams2;options.headers["Content-Type"]="application/x-www-form-urlencoded";Object.entries(params).forEach(([key,value])=>{options.body.append(key,value)})}}if(options.body){options.body=options.body.toString()}const response=await this.requestResource(targetUrl,accessToken,options);let parsed=processResponse(response,{bearer:true});if(jwt){if(!/^application\/jwt/.test(response.headers["content-type"])){throw new RPError({message:"expected application/jwt response from the userinfo_endpoint",response})}const body=response.body.toString();const userinfo=await this.decryptJWTUserinfo(body);if(!this.userinfo_signed_response_alg){try{parsed=JSON.parse(userinfo);assert2(isPlainObject3(parsed))}catch(err){throw new RPError({message:"failed to parse userinfo JWE payload as JSON",jwt:userinfo})}}else{({payload:parsed}=await this.validateJWTUserinfo(userinfo))}}else{try{parsed=JSON.parse(response.body)}catch(err){Object.defineProperty(err,"response",{value:response});throw err}}if(accessToken instanceof TokenSet2&&accessToken.id_token){const expectedSub=accessToken.claims().sub;if(parsed.sub!==expectedSub){throw new RPError({printf:["userinfo sub mismatch, expected %s, got: %s",expectedSub,parsed.sub],body:parsed,jwt:accessToken.id_token})}}return parsed}encryptionSecret(len){const hash=len<=256?"sha256":len<=384?"sha384":len<=512?"sha512":false;if(!hash){throw new Error("unsupported symmetric encryption key derivation")}return crypto5.createHash(hash).update(this.client_secret).digest().slice(0,len/8)}secretForAlg(alg){if(!this.client_secret){throw new TypeError("client_secret is required")}if(/^A(\d{3})(?:GCM)?KW$/.test(alg)){return this.encryptionSecret(parseInt(RegExp.$1,10))}if(/^A(\d{3})(?:GCM|CBC-HS(\d{3}))$/.test(alg)){return this.encryptionSecret(parseInt(RegExp.$2||RegExp.$1,10))}return new TextEncoder().encode(this.client_secret)}async grant(body,{clientAssertionPayload,DPoP}={},retry){assertIssuerConfiguration(this.issuer,"token_endpoint");const response=await authenticatedPost.call(this,"token",{form:body,responseType:"json"},{clientAssertionPayload,DPoP});let responseBody;try{responseBody=processResponse(response)}catch(err){if(retry!==retryAttempt&&err instanceof OPError&&err.error==="use_dpop_nonce"){return this.grant(body,{clientAssertionPayload,DPoP},retryAttempt)}throw err}return new TokenSet2(responseBody)}async deviceAuthorization(params={},{exchangeBody,clientAssertionPayload,DPoP}={}){assertIssuerConfiguration(this.issuer,"device_authorization_endpoint");assertIssuerConfiguration(this.issuer,"token_endpoint");const body=authorizationParams.call(this,{client_id:this.client_id,redirect_uri:null,response_type:null,...params});const response=await authenticatedPost.call(this,"device_authorization",{responseType:"json",form:body},{clientAssertionPayload,endpointAuthMethod:"token"});const responseBody=processResponse(response);return new DeviceFlowHandle({client:this,exchangeBody,clientAssertionPayload,response:responseBody,maxAge:params.max_age,DPoP})}async revoke(token2,hint,{revokeBody,clientAssertionPayload}={}){assertIssuerConfiguration(this.issuer,"revocation_endpoint");if(hint!==void 0&&typeof hint!=="string"){throw new TypeError("hint must be a string")}const form={...revokeBody,token:token2};if(hint){form.token_type_hint=hint}const response=await authenticatedPost.call(this,"revocation",{form},{clientAssertionPayload});processResponse(response,{body:false})}async introspect(token2,hint,{introspectBody,clientAssertionPayload}={}){assertIssuerConfiguration(this.issuer,"introspection_endpoint");if(hint!==void 0&&typeof hint!=="string"){throw new TypeError("hint must be a string")}const form={...introspectBody,token:token2};if(hint){form.token_type_hint=hint}const response=await authenticatedPost.call(this,"introspection",{form,responseType:"json"},{clientAssertionPayload});const responseBody=processResponse(response);return responseBody}static async register(metadata,options={}){const{initialAccessToken,jwks,...clientOptions}=options;assertIssuerConfiguration(this.issuer,"registration_endpoint");if(jwks!==void 0&&!(metadata.jwks||metadata.jwks_uri)){const keystore=await getKeystore.call(this,jwks);metadata.jwks=keystore.toJWKS()}const response=await request.call(this,{headers:{Accept:"application/json",...initialAccessToken?{Authorization:authorizationHeaderValue(initialAccessToken)}:void 0},responseType:"json",json:metadata,url:this.issuer.registration_endpoint,method:"POST"});const responseBody=processResponse(response,{statusCode:201,bearer:true});return new this(responseBody,jwks,clientOptions)}get metadata(){return clone2(Object.fromEntries(this.#metadata.entries()))}static async fromUri(registrationClientUri,registrationAccessToken,jwks,clientOptions){const response=await request.call(this,{method:"GET",url:registrationClientUri,responseType:"json",headers:{Authorization:authorizationHeaderValue(registrationAccessToken),Accept:"application/json"}});const responseBody=processResponse(response,{bearer:true});return new this(responseBody,jwks,clientOptions)}async requestObject(requestObject={},{sign:signingAlgorithm=this.request_object_signing_alg||"none",encrypt:{alg:eKeyManagement=this.request_object_encryption_alg,enc:eContentEncryption=this.request_object_encryption_enc||"A128CBC-HS256"}={}}={}){if(!isPlainObject3(requestObject)){throw new TypeError("requestObject must be a plain object")}let signed;let key;const unix=now3();const header2={alg:signingAlgorithm,typ:"oauth-authz-req+jwt"};const payload=JSON.stringify(defaults3({},requestObject,{iss:this.client_id,aud:this.issuer.issuer,client_id:this.client_id,jti:random3(),iat:unix,exp:unix+300,...this.fapi()?{nbf:unix}:void 0}));if(signingAlgorithm==="none"){signed=[base64url.encode(JSON.stringify(header2)),base64url.encode(payload),""].join(".")}else{const symmetric=signingAlgorithm.startsWith("HS");if(symmetric){key=this.secretForAlg(signingAlgorithm)}else{const keystore=await keystores.get(this);if(!keystore){throw new TypeError(`no keystore present for client, cannot sign using alg ${signingAlgorithm}`)}key=keystore.get({alg:signingAlgorithm,use:"sig"});if(!key){throw new TypeError(`no key to sign with found for alg ${signingAlgorithm}`)}}signed=await new jose.CompactSign(new TextEncoder().encode(payload)).setProtectedHeader({...header2,kid:symmetric?void 0:key.jwk.kid}).sign(symmetric?key:await key.keyObject(signingAlgorithm))}if(!eKeyManagement){return signed}const fields={alg:eKeyManagement,enc:eContentEncryption,cty:"oauth-authz-req+jwt"};if(fields.alg.match(/^(RSA|ECDH)/)){[key]=await queryKeyStore.call(this.issuer,{alg:fields.alg,use:"enc"},{allowMulti:true})}else{key=this.secretForAlg(fields.alg==="dir"?fields.enc:fields.alg)}return new jose.CompactEncrypt(new TextEncoder().encode(signed)).setProtectedHeader({...fields,kid:key instanceof Uint8Array?void 0:key.jwk.kid}).encrypt(key instanceof Uint8Array?key:await key.keyObject(fields.alg))}async pushedAuthorizationRequest(params={},{clientAssertionPayload}={}){assertIssuerConfiguration(this.issuer,"pushed_authorization_request_endpoint");const body={..."request"in params?params:authorizationParams.call(this,params),client_id:this.client_id};const response=await authenticatedPost.call(this,"pushed_authorization_request",{responseType:"json",form:body},{clientAssertionPayload,endpointAuthMethod:"token"});const responseBody=processResponse(response,{statusCode:201});if(!("expires_in"in responseBody)){throw new RPError({message:"expected expires_in in Pushed Authorization Successful Response",response})}if(typeof responseBody.expires_in!=="number"){throw new RPError({message:"invalid expires_in value in Pushed Authorization Successful Response",response})}if(!("request_uri"in responseBody)){throw new RPError({message:"expected request_uri in Pushed Authorization Successful Response",response})}if(typeof responseBody.request_uri!=="string"){throw new RPError({message:"invalid request_uri value in Pushed Authorization Successful Response",response})}return responseBody}get issuer(){return this.#issuer}[inspect3.custom](){return`${this.constructor.name} ${inspect3(this.metadata,{depth:Infinity,colors:process.stdout.isTTY,compact:false,sorted:true})}`}fapi(){return this.fapi1()||this.fapi2()}fapi1(){return this.constructor.name==="FAPI1Client"}fapi2(){return this.constructor.name==="FAPI2Client"}async validateJARM(response){const expectedAlg=this.authorization_signed_response_alg;const{payload}=await this.validateJWT(response,expectedAlg,["iss","exp","aud"]);return pickCb(payload)}async dpopProof(payload,privateKeyInput,accessToken){if(!isPlainObject3(payload)){throw new TypeError("payload must be a plain object")}let privateKey;if(isKeyObject(privateKeyInput)){privateKey=privateKeyInput}else if(privateKeyInput[Symbol.toStringTag]==="CryptoKey"){privateKey=privateKeyInput}else if(jose.cryptoRuntime==="node:crypto"){privateKey=crypto5.createPrivateKey(privateKeyInput)}else{throw new TypeError("unrecognized crypto runtime")}if(privateKey.type!=="private"){throw new TypeError('"DPoP" option must be a private key')}let alg=determineDPoPAlgorithm.call(this,privateKey,privateKeyInput);if(!alg){throw new TypeError("could not determine DPoP JWS Algorithm")}return new jose.SignJWT({ath:accessToken?base64url.encode(crypto5.createHash("sha256").update(accessToken).digest()):void 0,...payload}).setProtectedHeader({alg,typ:"dpop+jwt",jwk:await getJwk(privateKey,privateKeyInput)}).setIssuedAt().setJti(random3()).sign(privateKey)}};function determineDPoPAlgorithmFromCryptoKey(cryptoKey){switch(cryptoKey.algorithm.name){case"Ed25519":case"Ed448":return"EdDSA";case"ECDSA":{switch(cryptoKey.algorithm.namedCurve){case"P-256":return"ES256";case"P-384":return"ES384";case"P-521":return"ES512";default:break}break}case"RSASSA-PKCS1-v1_5":return`RS${cryptoKey.algorithm.hash.name.slice(4)}`;case"RSA-PSS":return`PS${cryptoKey.algorithm.hash.name.slice(4)}`;default:throw new TypeError("unsupported DPoP private key")}}var determineDPoPAlgorithm;if(jose.cryptoRuntime==="node:crypto"){let determineRsaAlgorithm2=function(privateKey,privateKeyInput,valuesSupported){if(typeof privateKeyInput==="object"&&privateKeyInput.format==="jwk"&&privateKeyInput.key&&privateKeyInput.key.alg){return privateKeyInput.key.alg}if(Array.isArray(valuesSupported)){let candidates=valuesSupported.filter(RegExp.prototype.test.bind(RSPS));if(privateKey.asymmetricKeyType==="rsa-pss"){candidates=candidates.filter(value=>value.startsWith("PS"))}return["PS256","PS384","PS512","RS256","RS384","RS384"].find(preferred=>candidates.includes(preferred))}return"PS256"},determineEcAlgorithm2=function(privateKey,privateKeyInput){switch(typeof privateKeyInput==="object"&&typeof privateKeyInput.key==="object"&&privateKeyInput.key.crv){case"P-256":return"ES256";case"secp256k1":return"ES256K";case"P-384":return"ES384";case"P-512":return"ES512";default:break}const buf=privateKey.export({format:"der",type:"pkcs8"});const i=buf[1]<128?17:18;const len=buf[i];const curveOid=buf.slice(i+1,i+1+len);if(curveOid.equals(p2562)){return"ES256"}if(curveOid.equals(p3842)){return"ES384"}if(curveOid.equals(p5212)){return"ES512"}if(curveOid.equals(secp256k12)){return"ES256K"}throw new TypeError("unsupported DPoP private key curve")};determineRsaAlgorithm=determineRsaAlgorithm2,determineEcAlgorithm=determineEcAlgorithm2;determineDPoPAlgorithm=function(privateKey,privateKeyInput){if(privateKeyInput[Symbol.toStringTag]==="CryptoKey"){return determineDPoPAlgorithmFromCryptoKey(privateKey)}switch(privateKey.asymmetricKeyType){case"ed25519":case"ed448":return"EdDSA";case"ec":return determineEcAlgorithm2(privateKey,privateKeyInput);case"rsa":case(rsaPssParams2&&"rsa-pss"):return determineRsaAlgorithm2(privateKey,privateKeyInput,this.issuer.dpop_signing_alg_values_supported);default:throw new TypeError("unsupported DPoP private key")}};const RSPS=/^(?:RS|PS)(?:256|384|512)$/;const p2562=Buffer.from([42,134,72,206,61,3,1,7]);const p3842=Buffer.from([43,129,4,0,34]);const p5212=Buffer.from([43,129,4,0,35]);const secp256k12=Buffer.from([43,129,4,0,10])}else{determineDPoPAlgorithm=determineDPoPAlgorithmFromCryptoKey}var determineRsaAlgorithm;var determineEcAlgorithm;var jwkCache=new WeakMap;async function getJwk(keyObject,privateKeyInput){if(jose.cryptoRuntime==="node:crypto"&&typeof privateKeyInput==="object"&&typeof privateKeyInput.key==="object"&&privateKeyInput.format==="jwk"){return pick2(privateKeyInput.key,"kty","crv","x","y","e","n")}if(jwkCache.has(privateKeyInput)){return jwkCache.get(privateKeyInput)}const jwk=pick2(await jose.exportJWK(keyObject),"kty","crv","x","y","e","n");if(isKeyObject(privateKeyInput)||jose.cryptoRuntime==="WebCryptoAPI"){jwkCache.set(privateKeyInput,jwk)}return jwk}module2.exports=(issuer,aadIssValidation=false)=>class Client extends BaseClient3{constructor(...args2){super(issuer,aadIssValidation,...args2)}static get issuer(){return issuer}};module2.exports.BaseClient=BaseClient3}});var require_issuer_registry=__commonJS({"node_modules/openid-client/lib/issuer_registry.js"(exports2,module2){var LRU=require_lru_cache();module2.exports=new LRU({max:100})}});var require_webfinger_normalize=__commonJS({"node_modules/openid-client/lib/helpers/webfinger_normalize.js"(exports2,module2){var PORT=/^\d+$/;function hasScheme(input){if(input.includes("://"))return true;const authority=input.replace(/(\/|\?)/g,"#").split("#")[0];if(authority.includes(":")){const index=authority.indexOf(":");const hostOrPort=authority.slice(index+1);if(!PORT.test(hostOrPort)){return true}}return false}function acctSchemeAssumed(input){if(!input.includes("@"))return false;const parts=input.split("@");const host=parts[parts.length-1];return!(host.includes(":")||host.includes("/")||host.includes("?"))}function normalize(input){if(typeof input!=="string"){throw new TypeError("input must be a string")}let output;if(hasScheme(input)){output=input}else if(acctSchemeAssumed(input)){output=`acct:${input}`}else{output=`https://${input}`}return output.split("#")[0]}module2.exports=normalize}});var require_issuer2=__commonJS({"node_modules/openid-client/lib/issuer.js"(exports2,module2){var{inspect:inspect3}=require("util");var url=require("url");var{RPError}=require_errors2();var getClient=require_client2();var registry=require_issuer_registry();var processResponse=require_process_response();var webfingerNormalize=require_webfinger_normalize();var request=require_request();var clone2=require_deep_clone();var{keystore}=require_issuer();var AAD_MULTITENANT_DISCOVERY=["https://login.microsoftonline.com/common/.well-known/openid-configuration","https://login.microsoftonline.com/common/v2.0/.well-known/openid-configuration","https://login.microsoftonline.com/organizations/v2.0/.well-known/openid-configuration","https://login.microsoftonline.com/consumers/v2.0/.well-known/openid-configuration"];var AAD_MULTITENANT=Symbol();var ISSUER_DEFAULTS={claim_types_supported:["normal"],claims_parameter_supported:false,grant_types_supported:["authorization_code","implicit"],request_parameter_supported:false,request_uri_parameter_supported:true,require_request_uri_registration:false,response_modes_supported:["query","fragment"],token_endpoint_auth_methods_supported:["client_secret_basic"]};var Issuer2=class _Issuer{#metadata;constructor(meta={}){const aadIssValidation=meta[AAD_MULTITENANT];delete meta[AAD_MULTITENANT];["introspection","revocation"].forEach(endpoint=>{if(meta[`${endpoint}_endpoint`]&&meta[`${endpoint}_endpoint_auth_methods_supported`]===void 0&&meta[`${endpoint}_endpoint_auth_signing_alg_values_supported`]===void 0){if(meta.token_endpoint_auth_methods_supported){meta[`${endpoint}_endpoint_auth_methods_supported`]=meta.token_endpoint_auth_methods_supported}if(meta.token_endpoint_auth_signing_alg_values_supported){meta[`${endpoint}_endpoint_auth_signing_alg_values_supported`]=meta.token_endpoint_auth_signing_alg_values_supported}}});this.#metadata=new Map;Object.entries(meta).forEach(([key,value])=>{this.#metadata.set(key,value);if(!this[key]){Object.defineProperty(this,key,{get(){return this.#metadata.get(key)},enumerable:true})}});registry.set(this.issuer,this);const Client3=getClient(this,aadIssValidation);Object.defineProperties(this,{Client:{value:Client3,enumerable:true},FAPI1Client:{value:class FAPI1Client extends Client3{},enumerable:true},FAPI2Client:{value:class FAPI2Client extends Client3{},enumerable:true}})}get metadata(){return clone2(Object.fromEntries(this.#metadata.entries()))}static async webfinger(input){const resource=webfingerNormalize(input);const{host}=url.parse(resource);const webfingerUrl=`https://${host}/.well-known/webfinger`;const response=await request.call(this,{method:"GET",url:webfingerUrl,responseType:"json",searchParams:{resource,rel:"http://openid.net/specs/connect/1.0/issuer"},headers:{Accept:"application/json"}});const body=processResponse(response);const location=Array.isArray(body.links)&&body.links.find(link=>typeof link==="object"&&link.rel==="http://openid.net/specs/connect/1.0/issuer"&&link.href);if(!location){throw new RPError({message:"no issuer found in webfinger response",body})}if(typeof location.href!=="string"||!location.href.startsWith("https://")){throw new RPError({printf:["invalid issuer location %s",location.href],body})}const expectedIssuer=location.href;if(registry.has(expectedIssuer)){return registry.get(expectedIssuer)}const issuer=await this.discover(expectedIssuer);if(issuer.issuer!==expectedIssuer){registry.del(issuer.issuer);throw new RPError("discovered issuer mismatch, expected %s, got: %s",expectedIssuer,issuer.issuer)}return issuer}static async discover(uri){const wellKnownUri=resolveWellKnownUri(uri);const response=await request.call(this,{method:"GET",responseType:"json",url:wellKnownUri,headers:{Accept:"application/json"}});const body=processResponse(response);return new _Issuer({...ISSUER_DEFAULTS,...body,[AAD_MULTITENANT]:!!AAD_MULTITENANT_DISCOVERY.find(discoveryURL=>wellKnownUri.startsWith(discoveryURL))})}async reloadJwksUri(){await keystore.call(this,true)}[inspect3.custom](){return`${this.constructor.name} ${inspect3(this.metadata,{depth:Infinity,colors:process.stdout.isTTY,compact:false,sorted:true})}`}};function resolveWellKnownUri(uri){const parsed=url.parse(uri);if(parsed.pathname.includes("/.well-known/")){return uri}else{let pathname;if(parsed.pathname.endsWith("/")){pathname=`${parsed.pathname}.well-known/openid-configuration`}else{pathname=`${parsed.pathname}/.well-known/openid-configuration`}return url.format({...parsed,pathname})}}module2.exports=Issuer2}});var require_passport_strategy=__commonJS({"node_modules/openid-client/lib/passport_strategy.js"(exports2,module2){var url=require("url");var{format:format2}=require("util");var cloneDeep2=require_deep_clone();var{RPError,OPError}=require_errors2();var{BaseClient:BaseClient3}=require_client2();var{random:random3,codeChallenge}=require_generators();var pick2=require_pick();var{resolveResponseType,resolveRedirectUri}=require_client();function verified(err,user,info={}){if(err){this.error(err)}else if(!user){this.fail(info)}else{this.success(user,info)}}function OpenIDConnectStrategy({client,params={},passReqToCallback=false,sessionKey,usePKCE=true,extras={}}={},verify){if(!(client instanceof BaseClient3)){throw new TypeError("client must be an instance of openid-client Client")}if(typeof verify!=="function"){throw new TypeError("verify callback must be a function")}if(!client.issuer||!client.issuer.issuer){throw new TypeError("client must have an issuer with an identifier")}this._client=client;this._issuer=client.issuer;this._verify=verify;this._passReqToCallback=passReqToCallback;this._usePKCE=usePKCE;this._key=sessionKey||`oidc:${url.parse(this._issuer.issuer).hostname}`;this._params=cloneDeep2(params);delete this._params.state;delete this._params.nonce;this._extras=cloneDeep2(extras);if(!this._params.response_type)this._params.response_type=resolveResponseType.call(client);if(!this._params.redirect_uri)this._params.redirect_uri=resolveRedirectUri.call(client);if(!this._params.scope)this._params.scope="openid";if(this._usePKCE===true){const supportedMethods=Array.isArray(this._issuer.code_challenge_methods_supported)?this._issuer.code_challenge_methods_supported:false;if(supportedMethods&&supportedMethods.includes("S256")){this._usePKCE="S256"}else if(supportedMethods&&supportedMethods.includes("plain")){this._usePKCE="plain"}else if(supportedMethods){throw new TypeError("neither code_challenge_method supported by the client is supported by the issuer")}else{this._usePKCE="S256"}}else if(typeof this._usePKCE==="string"&&!["plain","S256"].includes(this._usePKCE)){throw new TypeError(`${this._usePKCE} is not valid/implemented PKCE code_challenge_method`)}this.name=url.parse(client.issuer.issuer).hostname}OpenIDConnectStrategy.prototype.authenticate=function authenticate(req,options){(async()=>{const client=this._client;if(!req.session){throw new TypeError("authentication requires session support")}const reqParams=client.callbackParams(req);const sessionKey=this._key;const{0:parameter,length}=Object.keys(reqParams);if(length===0||length===1&&parameter==="iss"){const params={state:random3(),...this._params,...options};if(!params.nonce&&params.response_type.includes("id_token")){params.nonce=random3()}req.session[sessionKey]=pick2(params,"nonce","state","max_age","response_type");if(this._usePKCE&&params.response_type.includes("code")){const verifier=random3();req.session[sessionKey].code_verifier=verifier;switch(this._usePKCE){case"S256":params.code_challenge=codeChallenge(verifier);params.code_challenge_method="S256";break;case"plain":params.code_challenge=verifier;break}}this.redirect(client.authorizationUrl(params));return}const session=req.session[sessionKey];if(Object.keys(session||{}).length===0){throw new Error(format2('did not find expected authorization request details in session, req.session["%s"] is %j',sessionKey,session))}const{state,nonce,max_age:maxAge,code_verifier:codeVerifier,response_type:responseType}=session;try{delete req.session[sessionKey]}catch(err){}const opts={redirect_uri:this._params.redirect_uri,...options};const checks2={state,nonce,max_age:maxAge,code_verifier:codeVerifier,response_type:responseType};const tokenset=await client.callback(opts.redirect_uri,reqParams,checks2,this._extras);const passReq=this._passReqToCallback;const loadUserinfo=this._verify.length>(passReq?3:2)&&client.issuer.userinfo_endpoint;const args2=[tokenset,verified.bind(this)];if(loadUserinfo){if(!tokenset.access_token){throw new RPError({message:"expected access_token to be returned when asking for userinfo in verify callback",tokenset})}const userinfo=await client.userinfo(tokenset);args2.splice(1,0,userinfo)}if(passReq){args2.unshift(req)}this._verify(...args2)})().catch(error=>{if(error instanceof OPError&&error.error!=="server_error"&&!error.error.startsWith("invalid")||error instanceof RPError){this.fail(error)}else{this.error(error)}})};module2.exports=OpenIDConnectStrategy}});var require_lib3=__commonJS({"node_modules/openid-client/lib/index.js"(exports2,module2){var Issuer2=require_issuer2();var{OPError,RPError}=require_errors2();var Strategy2=require_passport_strategy();var TokenSet2=require_token_set();var{CLOCK_TOLERANCE,HTTP_OPTIONS}=require_consts();var generators2=require_generators();var{setDefaults}=require_request();module2.exports={Issuer:Issuer2,Strategy:Strategy2,TokenSet:TokenSet2,errors:{OPError,RPError},custom:{setHttpOptionsDefaults:setDefaults,http_options:HTTP_OPTIONS,clock_tolerance:CLOCK_TOLERANCE},generators:generators2}}});var tslib_es6_exports={};__export(tslib_es6_exports,{__addDisposableResource:()=>__addDisposableResource,__assign:()=>__assign,__asyncDelegator:()=>__asyncDelegator,__asyncGenerator:()=>__asyncGenerator,__asyncValues:()=>__asyncValues,__await:()=>__await,__awaiter:()=>__awaiter,__classPrivateFieldGet:()=>__classPrivateFieldGet3,__classPrivateFieldIn:()=>__classPrivateFieldIn,__classPrivateFieldSet:()=>__classPrivateFieldSet3,__createBinding:()=>__createBinding,__decorate:()=>__decorate,__disposeResources:()=>__disposeResources,__esDecorate:()=>__esDecorate,__exportStar:()=>__exportStar,__extends:()=>__extends,__generator:()=>__generator,__importDefault:()=>__importDefault,__importStar:()=>__importStar,__makeTemplateObject:()=>__makeTemplateObject,__metadata:()=>__metadata,__param:()=>__param,__propKey:()=>__propKey,__read:()=>__read,__rest:()=>__rest,__runInitializers:()=>__runInitializers,__setFunctionName:()=>__setFunctionName,__spread:()=>__spread,__spreadArray:()=>__spreadArray,__spreadArrays:()=>__spreadArrays,__values:()=>__values,default:()=>tslib_es6_default});function __extends(d,b){if(typeof b!=="function"&&b!==null)throw new TypeError("Class extends value "+String(b)+" is not a constructor or null");extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}function __rest(s,e){var t={};for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p)&&e.indexOf(p)<0)t[p]=s[p];if(s!=null&&typeof Object.getOwnPropertySymbols==="function")for(var i=0,p=Object.getOwnPropertySymbols(s);i<p.length;i++){if(e.indexOf(p[i])<0&&Object.prototype.propertyIsEnumerable.call(s,p[i]))t[p[i]]=s[p[i]]}return t}function __decorate(decorators,target,key,desc){var c=arguments.length,r=c<3?target:desc===null?desc=Object.getOwnPropertyDescriptor(target,key):desc,d;if(typeof Reflect==="object"&&typeof Reflect.decorate==="function")r=Reflect.decorate(decorators,target,key,desc);else for(var i=decorators.length-1;i>=0;i--)if(d=decorators[i])r=(c<3?d(r):c>3?d(target,key,r):d(target,key))||r;return c>3&&r&&Object.defineProperty(target,key,r),r}function __param(paramIndex,decorator){return function(target,key){decorator(target,key,paramIndex)}}function __esDecorate(ctor,descriptorIn,decorators,contextIn,initializers,extraInitializers){function accept(f){if(f!==void 0&&typeof f!=="function")throw new TypeError("Function expected");return f}var kind=contextIn.kind,key=kind==="getter"?"get":kind==="setter"?"set":"value";var target=!descriptorIn&&ctor?contextIn["static"]?ctor:ctor.prototype:null;var descriptor=descriptorIn||(target?Object.getOwnPropertyDescriptor(target,contextIn.name):{});var _,done=false;for(var i=decorators.length-1;i>=0;i--){var context={};for(var p in contextIn)context[p]=p==="access"?{}:contextIn[p];for(var p in contextIn.access)context.access[p]=contextIn.access[p];context.addInitializer=function(f){if(done)throw new TypeError("Cannot add initializers after decoration has completed");extraInitializers.push(accept(f||null))};var result2=(0,decorators[i])(kind==="accessor"?{get:descriptor.get,set:descriptor.set}:descriptor[key],context);if(kind==="accessor"){if(result2===void 0)continue;if(result2===null||typeof result2!=="object")throw new TypeError("Object expected");if(_=accept(result2.get))descriptor.get=_;if(_=accept(result2.set))descriptor.set=_;if(_=accept(result2.init))initializers.unshift(_)}else if(_=accept(result2)){if(kind==="field")initializers.unshift(_);else descriptor[key]=_}}if(target)Object.defineProperty(target,contextIn.name,descriptor);done=true}function __runInitializers(thisArg,initializers,value){var useValue=arguments.length>2;for(var i=0;i<initializers.length;i++){value=useValue?initializers[i].call(thisArg,value):initializers[i].call(thisArg)}return useValue?value:void 0}function __propKey(x){return typeof x==="symbol"?x:"".concat(x)}function __setFunctionName(f,name,prefix){if(typeof name==="symbol")name=name.description?"[".concat(name.description,"]"):"";return Object.defineProperty(f,"name",{configurable:true,value:prefix?"".concat(prefix," ",name):name})}function __metadata(metadataKey,metadataValue){if(typeof Reflect==="object"&&typeof Reflect.metadata==="function")return Reflect.metadata(metadataKey,metadataValue)}function __awaiter(thisArg,_arguments,P,generator){function adopt(value){return value instanceof P?value:new P(function(resolve){resolve(value)})}return new(P||(P=Promise))(function(resolve,reject2){function fulfilled(value){try{step(generator.next(value))}catch(e){reject2(e)}}function rejected(value){try{step(generator["throw"](value))}catch(e){reject2(e)}}function step(result2){result2.done?resolve(result2.value):adopt(result2.value).then(fulfilled,rejected)}step((generator=generator.apply(thisArg,_arguments||[])).next())})}function __generator(thisArg,body){var _={label:0,sent:function(){if(t[0]&1)throw t[1];return t[1]},trys:[],ops:[]},f,y,t,g=Object.create((typeof Iterator==="function"?Iterator:Object).prototype);return g.next=verb(0),g["throw"]=verb(1),g["return"]=verb(2),typeof Symbol==="function"&&(g[Symbol.iterator]=function(){return this}),g;function verb(n){return function(v){return step([n,v])}}function step(op){if(f)throw new TypeError("Generator is already executing.");while(g&&(g=0,op[0]&&(_=0)),_)try{if(f=1,y&&(t=op[0]&2?y["return"]:op[0]?y["throw"]||((t=y["return"])&&t.call(y),0):y.next)&&!(t=t.call(y,op[1])).done)return t;if(y=0,t)op=[op[0]&2,t.value];switch(op[0]){case 0:case 1:t=op;break;case 4:_.label++;return{value:op[1],done:false};case 5:_.label++;y=op[1];op=[0];continue;case 7:op=_.ops.pop();_.trys.pop();continue;default:if(!(t=_.trys,t=t.length>0&&t[t.length-1])&&(op[0]===6||op[0]===2)){_=0;continue}if(op[0]===3&&(!t||op[1]>t[0]&&op[1]<t[3])){_.label=op[1];break}if(op[0]===6&&_.label<t[1]){_.label=t[1];t=op;break}if(t&&_.label<t[2]){_.label=t[2];_.ops.push(op);break}if(t[2])_.ops.pop();_.trys.pop();continue}op=body.call(thisArg,_)}catch(e){op=[6,e];y=0}finally{f=t=0}if(op[0]&5)throw op[1];return{value:op[0]?op[1]:void 0,done:true}}}function __exportStar(m,o){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(o,p))__createBinding(o,m,p)}function __values(o){var s=typeof Symbol==="function"&&Symbol.iterator,m=s&&o[s],i=0;if(m)return m.call(o);if(o&&typeof o.length==="number")return{next:function(){if(o&&i>=o.length)o=void 0;return{value:o&&o[i++],done:!o}}};throw new TypeError(s?"Object is not iterable.":"Symbol.iterator is not defined.")}function __read(o,n){var m=typeof Symbol==="function"&&o[Symbol.iterator];if(!m)return o;var i=m.call(o),r,ar=[],e;try{while((n===void 0||n-- >0)&&!(r=i.next()).done)ar.push(r.value)}catch(error){e={error}}finally{try{if(r&&!r.done&&(m=i["return"]))m.call(i)}finally{if(e)throw e.error}}return ar}function __spread(){for(var ar=[],i=0;i<arguments.length;i++)ar=ar.concat(__read(arguments[i]));return ar}function __spreadArrays(){for(var s=0,i=0,il=arguments.length;i<il;i++)s+=arguments[i].length;for(var r=Array(s),k=0,i=0;i<il;i++)for(var a=arguments[i],j=0,jl=a.length;j<jl;j++,k++)r[k]=a[j];return r}function __spreadArray(to,from,pack){if(pack||arguments.length===2)for(var i=0,l=from.length,ar;i<l;i++){if(ar||!(i in from)){if(!ar)ar=Array.prototype.slice.call(from,0,i);ar[i]=from[i]}}return to.concat(ar||Array.prototype.slice.call(from))}function __await(v){return this instanceof __await?(this.v=v,this):new __await(v)}function __asyncGenerator(thisArg,_arguments,generator){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var g=generator.apply(thisArg,_arguments||[]),i,q=[];return i=Object.create((typeof AsyncIterator==="function"?AsyncIterator:Object).prototype),verb("next"),verb("throw"),verb("return",awaitReturn),i[Symbol.asyncIterator]=function(){return this},i;function awaitReturn(f){return function(v){return Promise.resolve(v).then(f,reject2)}}function verb(n,f){if(g[n]){i[n]=function(v){return new Promise(function(a,b){q.push([n,v,a,b])>1||resume(n,v)})};if(f)i[n]=f(i[n])}}function resume(n,v){try{step(g[n](v))}catch(e){settle(q[0][3],e)}}function step(r){r.value instanceof __await?Promise.resolve(r.value.v).then(fulfill,reject2):settle(q[0][2],r)}function fulfill(value){resume("next",value)}function reject2(value){resume("throw",value)}function settle(f,v){if(f(v),q.shift(),q.length)resume(q[0][0],q[0][1])}}function __asyncDelegator(o){var i,p;return i={},verb("next"),verb("throw",function(e){throw e}),verb("return"),i[Symbol.iterator]=function(){return this},i;function verb(n,f){i[n]=o[n]?function(v){return(p=!p)?{value:__await(o[n](v)),done:false}:f?f(v):v}:f}}function __asyncValues(o){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var m=o[Symbol.asyncIterator],i;return m?m.call(o):(o=typeof __values==="function"?__values(o):o[Symbol.iterator](),i={},verb("next"),verb("throw"),verb("return"),i[Symbol.asyncIterator]=function(){return this},i);function verb(n){i[n]=o[n]&&function(v){return new Promise(function(resolve,reject2){v=o[n](v),settle(resolve,reject2,v.done,v.value)})}}function settle(resolve,reject2,d,v){Promise.resolve(v).then(function(v2){resolve({value:v2,done:d})},reject2)}}function __makeTemplateObject(cooked,raw){if(Object.defineProperty){Object.defineProperty(cooked,"raw",{value:raw})}else{cooked.raw=raw}return cooked}function __importStar(mod3){if(mod3&&mod3.__esModule)return mod3;var result2={};if(mod3!=null){for(var k in mod3)if(k!=="default"&&Object.prototype.hasOwnProperty.call(mod3,k))__createBinding(result2,mod3,k)}__setModuleDefault(result2,mod3);return result2}function __importDefault(mod3){return mod3&&mod3.__esModule?mod3:{default:mod3}}function __classPrivateFieldGet3(receiver,state,kind,f){if(kind==="a"&&!f)throw new TypeError("Private accessor was defined without a getter");if(typeof state==="function"?receiver!==state||!f:!state.has(receiver))throw new TypeError("Cannot read private member from an object whose class did not declare it");return kind==="m"?f:kind==="a"?f.call(receiver):f?f.value:state.get(receiver)}function __classPrivateFieldSet3(receiver,state,value,kind,f){if(kind==="m")throw new TypeError("Private method is not writable");if(kind==="a"&&!f)throw new TypeError("Private accessor was defined without a setter");if(typeof state==="function"?receiver!==state||!f:!state.has(receiver))throw new TypeError("Cannot write private member to an object whose class did not declare it");return kind==="a"?f.call(receiver,value):f?f.value=value:state.set(receiver,value),value}function __classPrivateFieldIn(state,receiver){if(receiver===null||typeof receiver!=="object"&&typeof receiver!=="function")throw new TypeError("Cannot use 'in' operator on non-object");return typeof state==="function"?receiver===state:state.has(receiver)}function __addDisposableResource(env2,value,async){if(value!==null&&value!==void 0){if(typeof value!=="object"&&typeof value!=="function")throw new TypeError("Object expected.");var dispose,inner;if(async){if(!Symbol.asyncDispose)throw new TypeError("Symbol.asyncDispose is not defined.");dispose=value[Symbol.asyncDispose]}if(dispose===void 0){if(!Symbol.dispose)throw new TypeError("Symbol.dispose is not defined.");dispose=value[Symbol.dispose];if(async)inner=dispose}if(typeof dispose!=="function")throw new TypeError("Object not disposable.");if(inner)dispose=function(){try{inner.call(this)}catch(e){return Promise.reject(e)}};env2.stack.push({value,dispose,async})}else if(async){env2.stack.push({async:true})}return value}function __disposeResources(env2){function fail(e){env2.error=env2.hasError?new _SuppressedError(e,env2.error,"An error was suppressed during disposal."):e;env2.hasError=true}var r,s=0;function next(){while(r=env2.stack.pop()){try{if(!r.async&&s===1)return s=0,env2.stack.push(r),Promise.resolve().then(next);if(r.dispose){var result2=r.dispose.call(r.value);if(r.async)return s|=2,Promise.resolve(result2).then(next,function(e){fail(e);return next()})}else s|=1}catch(e){fail(e)}}if(s===1)return env2.hasError?Promise.reject(env2.error):Promise.resolve();if(env2.hasError)throw env2.error}return next()}var extendStatics,__assign,__createBinding,__setModuleDefault,_SuppressedError,tslib_es6_default;var init_tslib_es6=__esm({"node_modules/tslib/tslib.es6.mjs"(){extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d2,b2){d2.__proto__=b2}||function(d2,b2){for(var p in b2)if(Object.prototype.hasOwnProperty.call(b2,p))d2[p]=b2[p]};return extendStatics(d,b)};__assign=function(){__assign=Object.assign||function __assign2(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};return __assign.apply(this,arguments)};__createBinding=Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]};__setModuleDefault=Object.create?function(o,v){Object.defineProperty(o,"default",{enumerable:true,value:v})}:function(o,v){o["default"]=v};_SuppressedError=typeof SuppressedError==="function"?SuppressedError:function(error,suppressed,message3){var e=new Error(message3);return e.name="SuppressedError",e.error=error,e.suppressed=suppressed,e};tslib_es6_default={__extends,__assign,__rest,__decorate,__param,__metadata,__awaiter,__generator,__createBinding,__exportStar,__values,__read,__spread,__spreadArrays,__spreadArray,__await,__asyncGenerator,__asyncDelegator,__asyncValues,__makeTemplateObject,__importStar,__importDefault,__classPrivateFieldGet:__classPrivateFieldGet3,__classPrivateFieldSet:__classPrivateFieldSet3,__classPrivateFieldIn,__addDisposableResource,__disposeResources}}});var require_common=__commonJS({"node_modules/discord-api-types/gateway/common.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_v10=__commonJS({"node_modules/discord-api-types/gateway/v10.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});exports2.VoiceChannelEffectSendAnimationType=exports2.GatewayDispatchEvents=exports2.GatewayIntentBits=exports2.GatewayCloseCodes=exports2.GatewayOpcodes=exports2.GatewayVersion=void 0;__exportStar2(require_common(),exports2);exports2.GatewayVersion="10";var GatewayOpcodes;(function(GatewayOpcodes2){GatewayOpcodes2[GatewayOpcodes2["Dispatch"]=0]="Dispatch";GatewayOpcodes2[GatewayOpcodes2["Heartbeat"]=1]="Heartbeat";GatewayOpcodes2[GatewayOpcodes2["Identify"]=2]="Identify";GatewayOpcodes2[GatewayOpcodes2["PresenceUpdate"]=3]="PresenceUpdate";GatewayOpcodes2[GatewayOpcodes2["VoiceStateUpdate"]=4]="VoiceStateUpdate";GatewayOpcodes2[GatewayOpcodes2["Resume"]=6]="Resume";GatewayOpcodes2[GatewayOpcodes2["Reconnect"]=7]="Reconnect";GatewayOpcodes2[GatewayOpcodes2["RequestGuildMembers"]=8]="RequestGuildMembers";GatewayOpcodes2[GatewayOpcodes2["InvalidSession"]=9]="InvalidSession";GatewayOpcodes2[GatewayOpcodes2["Hello"]=10]="Hello";GatewayOpcodes2[GatewayOpcodes2["HeartbeatAck"]=11]="HeartbeatAck"})(GatewayOpcodes||(exports2.GatewayOpcodes=GatewayOpcodes={}));var GatewayCloseCodes;(function(GatewayCloseCodes2){GatewayCloseCodes2[GatewayCloseCodes2["UnknownError"]=4e3]="UnknownError";GatewayCloseCodes2[GatewayCloseCodes2["UnknownOpcode"]=4001]="UnknownOpcode";GatewayCloseCodes2[GatewayCloseCodes2["DecodeError"]=4002]="DecodeError";GatewayCloseCodes2[GatewayCloseCodes2["NotAuthenticated"]=4003]="NotAuthenticated";GatewayCloseCodes2[GatewayCloseCodes2["AuthenticationFailed"]=4004]="AuthenticationFailed";GatewayCloseCodes2[GatewayCloseCodes2["AlreadyAuthenticated"]=4005]="AlreadyAuthenticated";GatewayCloseCodes2[GatewayCloseCodes2["InvalidSeq"]=4007]="InvalidSeq";GatewayCloseCodes2[GatewayCloseCodes2["RateLimited"]=4008]="RateLimited";GatewayCloseCodes2[GatewayCloseCodes2["SessionTimedOut"]=4009]="SessionTimedOut";GatewayCloseCodes2[GatewayCloseCodes2["InvalidShard"]=4010]="InvalidShard";GatewayCloseCodes2[GatewayCloseCodes2["ShardingRequired"]=4011]="ShardingRequired";GatewayCloseCodes2[GatewayCloseCodes2["InvalidAPIVersion"]=4012]="InvalidAPIVersion";GatewayCloseCodes2[GatewayCloseCodes2["InvalidIntents"]=4013]="InvalidIntents";GatewayCloseCodes2[GatewayCloseCodes2["DisallowedIntents"]=4014]="DisallowedIntents"})(GatewayCloseCodes||(exports2.GatewayCloseCodes=GatewayCloseCodes={}));var GatewayIntentBits2;(function(GatewayIntentBits3){GatewayIntentBits3[GatewayIntentBits3["Guilds"]=1]="Guilds";GatewayIntentBits3[GatewayIntentBits3["GuildMembers"]=2]="GuildMembers";GatewayIntentBits3[GatewayIntentBits3["GuildModeration"]=4]="GuildModeration";GatewayIntentBits3[GatewayIntentBits3["GuildBans"]=4]="GuildBans";GatewayIntentBits3[GatewayIntentBits3["GuildEmojisAndStickers"]=8]="GuildEmojisAndStickers";GatewayIntentBits3[GatewayIntentBits3["GuildIntegrations"]=16]="GuildIntegrations";GatewayIntentBits3[GatewayIntentBits3["GuildWebhooks"]=32]="GuildWebhooks";GatewayIntentBits3[GatewayIntentBits3["GuildInvites"]=64]="GuildInvites";GatewayIntentBits3[GatewayIntentBits3["GuildVoiceStates"]=128]="GuildVoiceStates";GatewayIntentBits3[GatewayIntentBits3["GuildPresences"]=256]="GuildPresences";GatewayIntentBits3[GatewayIntentBits3["GuildMessages"]=512]="GuildMessages";GatewayIntentBits3[GatewayIntentBits3["GuildMessageReactions"]=1024]="GuildMessageReactions";GatewayIntentBits3[GatewayIntentBits3["GuildMessageTyping"]=2048]="GuildMessageTyping";GatewayIntentBits3[GatewayIntentBits3["DirectMessages"]=4096]="DirectMessages";GatewayIntentBits3[GatewayIntentBits3["DirectMessageReactions"]=8192]="DirectMessageReactions";GatewayIntentBits3[GatewayIntentBits3["DirectMessageTyping"]=16384]="DirectMessageTyping";GatewayIntentBits3[GatewayIntentBits3["MessageContent"]=32768]="MessageContent";GatewayIntentBits3[GatewayIntentBits3["GuildScheduledEvents"]=65536]="GuildScheduledEvents";GatewayIntentBits3[GatewayIntentBits3["AutoModerationConfiguration"]=1048576]="AutoModerationConfiguration";GatewayIntentBits3[GatewayIntentBits3["AutoModerationExecution"]=2097152]="AutoModerationExecution";GatewayIntentBits3[GatewayIntentBits3["GuildMessagePolls"]=16777216]="GuildMessagePolls";GatewayIntentBits3[GatewayIntentBits3["DirectMessagePolls"]=33554432]="DirectMessagePolls"})(GatewayIntentBits2||(exports2.GatewayIntentBits=GatewayIntentBits2={}));var GatewayDispatchEvents;(function(GatewayDispatchEvents2){GatewayDispatchEvents2["ApplicationCommandPermissionsUpdate"]="APPLICATION_COMMAND_PERMISSIONS_UPDATE";GatewayDispatchEvents2["ChannelCreate"]="CHANNEL_CREATE";GatewayDispatchEvents2["ChannelDelete"]="CHANNEL_DELETE";GatewayDispatchEvents2["ChannelPinsUpdate"]="CHANNEL_PINS_UPDATE";GatewayDispatchEvents2["ChannelUpdate"]="CHANNEL_UPDATE";GatewayDispatchEvents2["GuildBanAdd"]="GUILD_BAN_ADD";GatewayDispatchEvents2["GuildBanRemove"]="GUILD_BAN_REMOVE";GatewayDispatchEvents2["GuildCreate"]="GUILD_CREATE";GatewayDispatchEvents2["GuildDelete"]="GUILD_DELETE";GatewayDispatchEvents2["GuildEmojisUpdate"]="GUILD_EMOJIS_UPDATE";GatewayDispatchEvents2["GuildIntegrationsUpdate"]="GUILD_INTEGRATIONS_UPDATE";GatewayDispatchEvents2["GuildMemberAdd"]="GUILD_MEMBER_ADD";GatewayDispatchEvents2["GuildMemberRemove"]="GUILD_MEMBER_REMOVE";GatewayDispatchEvents2["GuildMembersChunk"]="GUILD_MEMBERS_CHUNK";GatewayDispatchEvents2["GuildMemberUpdate"]="GUILD_MEMBER_UPDATE";GatewayDispatchEvents2["GuildRoleCreate"]="GUILD_ROLE_CREATE";GatewayDispatchEvents2["GuildRoleDelete"]="GUILD_ROLE_DELETE";GatewayDispatchEvents2["GuildRoleUpdate"]="GUILD_ROLE_UPDATE";GatewayDispatchEvents2["GuildStickersUpdate"]="GUILD_STICKERS_UPDATE";GatewayDispatchEvents2["GuildUpdate"]="GUILD_UPDATE";GatewayDispatchEvents2["IntegrationCreate"]="INTEGRATION_CREATE";GatewayDispatchEvents2["IntegrationDelete"]="INTEGRATION_DELETE";GatewayDispatchEvents2["IntegrationUpdate"]="INTEGRATION_UPDATE";GatewayDispatchEvents2["InteractionCreate"]="INTERACTION_CREATE";GatewayDispatchEvents2["InviteCreate"]="INVITE_CREATE";GatewayDispatchEvents2["InviteDelete"]="INVITE_DELETE";GatewayDispatchEvents2["MessageCreate"]="MESSAGE_CREATE";GatewayDispatchEvents2["MessageDelete"]="MESSAGE_DELETE";GatewayDispatchEvents2["MessageDeleteBulk"]="MESSAGE_DELETE_BULK";GatewayDispatchEvents2["MessageReactionAdd"]="MESSAGE_REACTION_ADD";GatewayDispatchEvents2["MessageReactionRemove"]="MESSAGE_REACTION_REMOVE";GatewayDispatchEvents2["MessageReactionRemoveAll"]="MESSAGE_REACTION_REMOVE_ALL";GatewayDispatchEvents2["MessageReactionRemoveEmoji"]="MESSAGE_REACTION_REMOVE_EMOJI";GatewayDispatchEvents2["MessageUpdate"]="MESSAGE_UPDATE";GatewayDispatchEvents2["PresenceUpdate"]="PRESENCE_UPDATE";GatewayDispatchEvents2["StageInstanceCreate"]="STAGE_INSTANCE_CREATE";GatewayDispatchEvents2["StageInstanceDelete"]="STAGE_INSTANCE_DELETE";GatewayDispatchEvents2["StageInstanceUpdate"]="STAGE_INSTANCE_UPDATE";GatewayDispatchEvents2["Ready"]="READY";GatewayDispatchEvents2["Resumed"]="RESUMED";GatewayDispatchEvents2["ThreadCreate"]="THREAD_CREATE";GatewayDispatchEvents2["ThreadDelete"]="THREAD_DELETE";GatewayDispatchEvents2["ThreadListSync"]="THREAD_LIST_SYNC";GatewayDispatchEvents2["ThreadMembersUpdate"]="THREAD_MEMBERS_UPDATE";GatewayDispatchEvents2["ThreadMemberUpdate"]="THREAD_MEMBER_UPDATE";GatewayDispatchEvents2["ThreadUpdate"]="THREAD_UPDATE";GatewayDispatchEvents2["TypingStart"]="TYPING_START";GatewayDispatchEvents2["UserUpdate"]="USER_UPDATE";GatewayDispatchEvents2["VoiceChannelEffectSend"]="VOICE_CHANNEL_EFFECT_SEND";GatewayDispatchEvents2["VoiceServerUpdate"]="VOICE_SERVER_UPDATE";GatewayDispatchEvents2["VoiceStateUpdate"]="VOICE_STATE_UPDATE";GatewayDispatchEvents2["WebhooksUpdate"]="WEBHOOKS_UPDATE";GatewayDispatchEvents2["MessagePollVoteAdd"]="MESSAGE_POLL_VOTE_ADD";GatewayDispatchEvents2["MessagePollVoteRemove"]="MESSAGE_POLL_VOTE_REMOVE";GatewayDispatchEvents2["GuildScheduledEventCreate"]="GUILD_SCHEDULED_EVENT_CREATE";GatewayDispatchEvents2["GuildScheduledEventUpdate"]="GUILD_SCHEDULED_EVENT_UPDATE";GatewayDispatchEvents2["GuildScheduledEventDelete"]="GUILD_SCHEDULED_EVENT_DELETE";GatewayDispatchEvents2["GuildScheduledEventUserAdd"]="GUILD_SCHEDULED_EVENT_USER_ADD";GatewayDispatchEvents2["GuildScheduledEventUserRemove"]="GUILD_SCHEDULED_EVENT_USER_REMOVE";GatewayDispatchEvents2["AutoModerationRuleCreate"]="AUTO_MODERATION_RULE_CREATE";GatewayDispatchEvents2["AutoModerationRuleUpdate"]="AUTO_MODERATION_RULE_UPDATE";GatewayDispatchEvents2["AutoModerationRuleDelete"]="AUTO_MODERATION_RULE_DELETE";GatewayDispatchEvents2["AutoModerationActionExecution"]="AUTO_MODERATION_ACTION_EXECUTION";GatewayDispatchEvents2["GuildAuditLogEntryCreate"]="GUILD_AUDIT_LOG_ENTRY_CREATE";GatewayDispatchEvents2["EntitlementCreate"]="ENTITLEMENT_CREATE";GatewayDispatchEvents2["EntitlementUpdate"]="ENTITLEMENT_UPDATE";GatewayDispatchEvents2["EntitlementDelete"]="ENTITLEMENT_DELETE";GatewayDispatchEvents2["SubscriptionCreate"]="SUBSCRIPTION_CREATE";GatewayDispatchEvents2["SubscriptionUpdate"]="SUBSCRIPTION_UPDATE";GatewayDispatchEvents2["SubscriptionDelete"]="SUBSCRIPTION_DELETE"})(GatewayDispatchEvents||(exports2.GatewayDispatchEvents=GatewayDispatchEvents={}));var VoiceChannelEffectSendAnimationType;(function(VoiceChannelEffectSendAnimationType2){VoiceChannelEffectSendAnimationType2[VoiceChannelEffectSendAnimationType2["Premium"]=0]="Premium";VoiceChannelEffectSendAnimationType2[VoiceChannelEffectSendAnimationType2["Basic"]=1]="Basic"})(VoiceChannelEffectSendAnimationType||(exports2.VoiceChannelEffectSendAnimationType=VoiceChannelEffectSendAnimationType={}))}});var require_globals=__commonJS({"node_modules/discord-api-types/globals.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.FormattingPatterns=void 0;exports2.FormattingPatterns={User:/<@(?<id>\d{17,20})>/,UserWithNickname:/<@!(?<id>\d{17,20})>/,UserWithOptionalNickname:/<@!?(?<id>\d{17,20})>/,Channel:/<#(?<id>\d{17,20})>/,Role:/<@&(?<id>\d{17,20})>/,SlashCommand:/<\/(?<fullName>(?<name>[-_\p{Letter}\p{Number}\p{sc=Deva}\p{sc=Thai}]{1,32})(?: (?<subcommandOrGroup>[-_\p{Letter}\p{Number}\p{sc=Deva}\p{sc=Thai}]{1,32}))?(?: (?<subcommand>[-_\p{Letter}\p{Number}\p{sc=Deva}\p{sc=Thai}]{1,32}))?):(?<id>\d{17,20})>/u,Emoji:/<(?<animated>a)?:(?<name>\w{2,32}):(?<id>\d{17,20})>/,AnimatedEmoji:/<(?<animated>a):(?<name>\w{2,32}):(?<id>\d{17,20})>/,StaticEmoji:/<:(?<name>\w{2,32}):(?<id>\d{17,20})>/,Timestamp:/<t:(?<timestamp>-?\d{1,13})(:(?<style>[DFRTdft]))?>/,DefaultStyledTimestamp:/<t:(?<timestamp>-?\d{1,13})>/,StyledTimestamp:/<t:(?<timestamp>-?\d{1,13}):(?<style>[DFRTdft])>/,GuildNavigation:/<id:(?<type>customize|browse|guide|linked-roles)>/,LinkedRole:/<id:linked-roles:(?<id>\d{17,20})>/};Object.freeze(exports2.FormattingPatterns)}});var require_common2=__commonJS({"node_modules/discord-api-types/payloads/common.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.PermissionFlagsBits=void 0;exports2.PermissionFlagsBits={CreateInstantInvite:1n<<0n,KickMembers:1n<<1n,BanMembers:1n<<2n,Administrator:1n<<3n,ManageChannels:1n<<4n,ManageGuild:1n<<5n,AddReactions:1n<<6n,ViewAuditLog:1n<<7n,PrioritySpeaker:1n<<8n,Stream:1n<<9n,ViewChannel:1n<<10n,SendMessages:1n<<11n,SendTTSMessages:1n<<12n,ManageMessages:1n<<13n,EmbedLinks:1n<<14n,AttachFiles:1n<<15n,ReadMessageHistory:1n<<16n,MentionEveryone:1n<<17n,UseExternalEmojis:1n<<18n,ViewGuildInsights:1n<<19n,Connect:1n<<20n,Speak:1n<<21n,MuteMembers:1n<<22n,DeafenMembers:1n<<23n,MoveMembers:1n<<24n,UseVAD:1n<<25n,ChangeNickname:1n<<26n,ManageNicknames:1n<<27n,ManageRoles:1n<<28n,ManageWebhooks:1n<<29n,ManageEmojisAndStickers:1n<<30n,ManageGuildExpressions:1n<<30n,UseApplicationCommands:1n<<31n,RequestToSpeak:1n<<32n,ManageEvents:1n<<33n,ManageThreads:1n<<34n,CreatePublicThreads:1n<<35n,CreatePrivateThreads:1n<<36n,UseExternalStickers:1n<<37n,SendMessagesInThreads:1n<<38n,UseEmbeddedActivities:1n<<39n,ModerateMembers:1n<<40n,ViewCreatorMonetizationAnalytics:1n<<41n,UseSoundboard:1n<<42n,CreateGuildExpressions:1n<<43n,CreateEvents:1n<<44n,UseExternalSounds:1n<<45n,SendVoiceMessages:1n<<46n,SendPolls:1n<<49n,UseExternalApps:1n<<50n};Object.freeze(exports2.PermissionFlagsBits)}});var require_application=__commonJS({"node_modules/discord-api-types/payloads/v10/application.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ApplicationRoleConnectionMetadataType=exports2.ApplicationFlags=void 0;var ApplicationFlags;(function(ApplicationFlags2){ApplicationFlags2[ApplicationFlags2["EmbeddedReleased"]=2]="EmbeddedReleased";ApplicationFlags2[ApplicationFlags2["ManagedEmoji"]=4]="ManagedEmoji";ApplicationFlags2[ApplicationFlags2["EmbeddedIAP"]=8]="EmbeddedIAP";ApplicationFlags2[ApplicationFlags2["GroupDMCreate"]=16]="GroupDMCreate";ApplicationFlags2[ApplicationFlags2["ApplicationAutoModerationRuleCreateBadge"]=64]="ApplicationAutoModerationRuleCreateBadge";ApplicationFlags2[ApplicationFlags2["RPCHasConnected"]=2048]="RPCHasConnected";ApplicationFlags2[ApplicationFlags2["GatewayPresence"]=4096]="GatewayPresence";ApplicationFlags2[ApplicationFlags2["GatewayPresenceLimited"]=8192]="GatewayPresenceLimited";ApplicationFlags2[ApplicationFlags2["GatewayGuildMembers"]=16384]="GatewayGuildMembers";ApplicationFlags2[ApplicationFlags2["GatewayGuildMembersLimited"]=32768]="GatewayGuildMembersLimited";ApplicationFlags2[ApplicationFlags2["VerificationPendingGuildLimit"]=65536]="VerificationPendingGuildLimit";ApplicationFlags2[ApplicationFlags2["Embedded"]=131072]="Embedded";ApplicationFlags2[ApplicationFlags2["GatewayMessageContent"]=262144]="GatewayMessageContent";ApplicationFlags2[ApplicationFlags2["GatewayMessageContentLimited"]=524288]="GatewayMessageContentLimited";ApplicationFlags2[ApplicationFlags2["EmbeddedFirstParty"]=1048576]="EmbeddedFirstParty";ApplicationFlags2[ApplicationFlags2["ApplicationCommandBadge"]=8388608]="ApplicationCommandBadge"})(ApplicationFlags||(exports2.ApplicationFlags=ApplicationFlags={}));var ApplicationRoleConnectionMetadataType;(function(ApplicationRoleConnectionMetadataType2){ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["IntegerLessThanOrEqual"]=1]="IntegerLessThanOrEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["IntegerGreaterThanOrEqual"]=2]="IntegerGreaterThanOrEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["IntegerEqual"]=3]="IntegerEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["IntegerNotEqual"]=4]="IntegerNotEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["DatetimeLessThanOrEqual"]=5]="DatetimeLessThanOrEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["DatetimeGreaterThanOrEqual"]=6]="DatetimeGreaterThanOrEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["BooleanEqual"]=7]="BooleanEqual";ApplicationRoleConnectionMetadataType2[ApplicationRoleConnectionMetadataType2["BooleanNotEqual"]=8]="BooleanNotEqual"})(ApplicationRoleConnectionMetadataType||(exports2.ApplicationRoleConnectionMetadataType=ApplicationRoleConnectionMetadataType={}))}});var require_auditLog=__commonJS({"node_modules/discord-api-types/payloads/v10/auditLog.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.AuditLogOptionsType=exports2.AuditLogEvent=void 0;var AuditLogEvent;(function(AuditLogEvent2){AuditLogEvent2[AuditLogEvent2["GuildUpdate"]=1]="GuildUpdate";AuditLogEvent2[AuditLogEvent2["ChannelCreate"]=10]="ChannelCreate";AuditLogEvent2[AuditLogEvent2["ChannelUpdate"]=11]="ChannelUpdate";AuditLogEvent2[AuditLogEvent2["ChannelDelete"]=12]="ChannelDelete";AuditLogEvent2[AuditLogEvent2["ChannelOverwriteCreate"]=13]="ChannelOverwriteCreate";AuditLogEvent2[AuditLogEvent2["ChannelOverwriteUpdate"]=14]="ChannelOverwriteUpdate";AuditLogEvent2[AuditLogEvent2["ChannelOverwriteDelete"]=15]="ChannelOverwriteDelete";AuditLogEvent2[AuditLogEvent2["MemberKick"]=20]="MemberKick";AuditLogEvent2[AuditLogEvent2["MemberPrune"]=21]="MemberPrune";AuditLogEvent2[AuditLogEvent2["MemberBanAdd"]=22]="MemberBanAdd";AuditLogEvent2[AuditLogEvent2["MemberBanRemove"]=23]="MemberBanRemove";AuditLogEvent2[AuditLogEvent2["MemberUpdate"]=24]="MemberUpdate";AuditLogEvent2[AuditLogEvent2["MemberRoleUpdate"]=25]="MemberRoleUpdate";AuditLogEvent2[AuditLogEvent2["MemberMove"]=26]="MemberMove";AuditLogEvent2[AuditLogEvent2["MemberDisconnect"]=27]="MemberDisconnect";AuditLogEvent2[AuditLogEvent2["BotAdd"]=28]="BotAdd";AuditLogEvent2[AuditLogEvent2["RoleCreate"]=30]="RoleCreate";AuditLogEvent2[AuditLogEvent2["RoleUpdate"]=31]="RoleUpdate";AuditLogEvent2[AuditLogEvent2["RoleDelete"]=32]="RoleDelete";AuditLogEvent2[AuditLogEvent2["InviteCreate"]=40]="InviteCreate";AuditLogEvent2[AuditLogEvent2["InviteUpdate"]=41]="InviteUpdate";AuditLogEvent2[AuditLogEvent2["InviteDelete"]=42]="InviteDelete";AuditLogEvent2[AuditLogEvent2["WebhookCreate"]=50]="WebhookCreate";AuditLogEvent2[AuditLogEvent2["WebhookUpdate"]=51]="WebhookUpdate";AuditLogEvent2[AuditLogEvent2["WebhookDelete"]=52]="WebhookDelete";AuditLogEvent2[AuditLogEvent2["EmojiCreate"]=60]="EmojiCreate";AuditLogEvent2[AuditLogEvent2["EmojiUpdate"]=61]="EmojiUpdate";AuditLogEvent2[AuditLogEvent2["EmojiDelete"]=62]="EmojiDelete";AuditLogEvent2[AuditLogEvent2["MessageDelete"]=72]="MessageDelete";AuditLogEvent2[AuditLogEvent2["MessageBulkDelete"]=73]="MessageBulkDelete";AuditLogEvent2[AuditLogEvent2["MessagePin"]=74]="MessagePin";AuditLogEvent2[AuditLogEvent2["MessageUnpin"]=75]="MessageUnpin";AuditLogEvent2[AuditLogEvent2["IntegrationCreate"]=80]="IntegrationCreate";AuditLogEvent2[AuditLogEvent2["IntegrationUpdate"]=81]="IntegrationUpdate";AuditLogEvent2[AuditLogEvent2["IntegrationDelete"]=82]="IntegrationDelete";AuditLogEvent2[AuditLogEvent2["StageInstanceCreate"]=83]="StageInstanceCreate";AuditLogEvent2[AuditLogEvent2["StageInstanceUpdate"]=84]="StageInstanceUpdate";AuditLogEvent2[AuditLogEvent2["StageInstanceDelete"]=85]="StageInstanceDelete";AuditLogEvent2[AuditLogEvent2["StickerCreate"]=90]="StickerCreate";AuditLogEvent2[AuditLogEvent2["StickerUpdate"]=91]="StickerUpdate";AuditLogEvent2[AuditLogEvent2["StickerDelete"]=92]="StickerDelete";AuditLogEvent2[AuditLogEvent2["GuildScheduledEventCreate"]=100]="GuildScheduledEventCreate";AuditLogEvent2[AuditLogEvent2["GuildScheduledEventUpdate"]=101]="GuildScheduledEventUpdate";AuditLogEvent2[AuditLogEvent2["GuildScheduledEventDelete"]=102]="GuildScheduledEventDelete";AuditLogEvent2[AuditLogEvent2["ThreadCreate"]=110]="ThreadCreate";AuditLogEvent2[AuditLogEvent2["ThreadUpdate"]=111]="ThreadUpdate";AuditLogEvent2[AuditLogEvent2["ThreadDelete"]=112]="ThreadDelete";AuditLogEvent2[AuditLogEvent2["ApplicationCommandPermissionUpdate"]=121]="ApplicationCommandPermissionUpdate";AuditLogEvent2[AuditLogEvent2["AutoModerationRuleCreate"]=140]="AutoModerationRuleCreate";AuditLogEvent2[AuditLogEvent2["AutoModerationRuleUpdate"]=141]="AutoModerationRuleUpdate";AuditLogEvent2[AuditLogEvent2["AutoModerationRuleDelete"]=142]="AutoModerationRuleDelete";AuditLogEvent2[AuditLogEvent2["AutoModerationBlockMessage"]=143]="AutoModerationBlockMessage";AuditLogEvent2[AuditLogEvent2["AutoModerationFlagToChannel"]=144]="AutoModerationFlagToChannel";AuditLogEvent2[AuditLogEvent2["AutoModerationUserCommunicationDisabled"]=145]="AutoModerationUserCommunicationDisabled";AuditLogEvent2[AuditLogEvent2["CreatorMonetizationRequestCreated"]=150]="CreatorMonetizationRequestCreated";AuditLogEvent2[AuditLogEvent2["CreatorMonetizationTermsAccepted"]=151]="CreatorMonetizationTermsAccepted";AuditLogEvent2[AuditLogEvent2["OnboardingPromptCreate"]=163]="OnboardingPromptCreate";AuditLogEvent2[AuditLogEvent2["OnboardingPromptUpdate"]=164]="OnboardingPromptUpdate";AuditLogEvent2[AuditLogEvent2["OnboardingPromptDelete"]=165]="OnboardingPromptDelete";AuditLogEvent2[AuditLogEvent2["OnboardingCreate"]=166]="OnboardingCreate";AuditLogEvent2[AuditLogEvent2["OnboardingUpdate"]=167]="OnboardingUpdate";AuditLogEvent2[AuditLogEvent2["HomeSettingsCreate"]=190]="HomeSettingsCreate";AuditLogEvent2[AuditLogEvent2["HomeSettingsUpdate"]=191]="HomeSettingsUpdate"})(AuditLogEvent||(exports2.AuditLogEvent=AuditLogEvent={}));var AuditLogOptionsType;(function(AuditLogOptionsType2){AuditLogOptionsType2["Role"]="0";AuditLogOptionsType2["Member"]="1"})(AuditLogOptionsType||(exports2.AuditLogOptionsType=AuditLogOptionsType={}))}});var require_autoModeration=__commonJS({"node_modules/discord-api-types/payloads/v10/autoModeration.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.AutoModerationActionType=exports2.AutoModerationRuleEventType=exports2.AutoModerationRuleKeywordPresetType=exports2.AutoModerationRuleTriggerType=void 0;var AutoModerationRuleTriggerType;(function(AutoModerationRuleTriggerType2){AutoModerationRuleTriggerType2[AutoModerationRuleTriggerType2["Keyword"]=1]="Keyword";AutoModerationRuleTriggerType2[AutoModerationRuleTriggerType2["Spam"]=3]="Spam";AutoModerationRuleTriggerType2[AutoModerationRuleTriggerType2["KeywordPreset"]=4]="KeywordPreset";AutoModerationRuleTriggerType2[AutoModerationRuleTriggerType2["MentionSpam"]=5]="MentionSpam";AutoModerationRuleTriggerType2[AutoModerationRuleTriggerType2["MemberProfile"]=6]="MemberProfile"})(AutoModerationRuleTriggerType||(exports2.AutoModerationRuleTriggerType=AutoModerationRuleTriggerType={}));var AutoModerationRuleKeywordPresetType;(function(AutoModerationRuleKeywordPresetType2){AutoModerationRuleKeywordPresetType2[AutoModerationRuleKeywordPresetType2["Profanity"]=1]="Profanity";AutoModerationRuleKeywordPresetType2[AutoModerationRuleKeywordPresetType2["SexualContent"]=2]="SexualContent";AutoModerationRuleKeywordPresetType2[AutoModerationRuleKeywordPresetType2["Slurs"]=3]="Slurs"})(AutoModerationRuleKeywordPresetType||(exports2.AutoModerationRuleKeywordPresetType=AutoModerationRuleKeywordPresetType={}));var AutoModerationRuleEventType;(function(AutoModerationRuleEventType2){AutoModerationRuleEventType2[AutoModerationRuleEventType2["MessageSend"]=1]="MessageSend";AutoModerationRuleEventType2[AutoModerationRuleEventType2["MemberUpdate"]=2]="MemberUpdate"})(AutoModerationRuleEventType||(exports2.AutoModerationRuleEventType=AutoModerationRuleEventType={}));var AutoModerationActionType;(function(AutoModerationActionType2){AutoModerationActionType2[AutoModerationActionType2["BlockMessage"]=1]="BlockMessage";AutoModerationActionType2[AutoModerationActionType2["SendAlertMessage"]=2]="SendAlertMessage";AutoModerationActionType2[AutoModerationActionType2["Timeout"]=3]="Timeout";AutoModerationActionType2[AutoModerationActionType2["BlockMemberInteraction"]=4]="BlockMemberInteraction"})(AutoModerationActionType||(exports2.AutoModerationActionType=AutoModerationActionType={}))}});var require_channel=__commonJS({"node_modules/discord-api-types/payloads/v10/channel.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ChannelFlags=exports2.SelectMenuDefaultValueType=exports2.TextInputStyle=exports2.ButtonStyle=exports2.ComponentType=exports2.AllowedMentionsTypes=exports2.AttachmentFlags=exports2.EmbedType=exports2.ThreadMemberFlags=exports2.ThreadAutoArchiveDuration=exports2.OverwriteType=exports2.MessageFlags=exports2.MessageReferenceType=exports2.MessageActivityType=exports2.MessageType=exports2.VideoQualityMode=exports2.ChannelType=exports2.ForumLayoutType=exports2.SortOrderType=void 0;var SortOrderType;(function(SortOrderType2){SortOrderType2[SortOrderType2["LatestActivity"]=0]="LatestActivity";SortOrderType2[SortOrderType2["CreationDate"]=1]="CreationDate"})(SortOrderType||(exports2.SortOrderType=SortOrderType={}));var ForumLayoutType;(function(ForumLayoutType2){ForumLayoutType2[ForumLayoutType2["NotSet"]=0]="NotSet";ForumLayoutType2[ForumLayoutType2["ListView"]=1]="ListView";ForumLayoutType2[ForumLayoutType2["GalleryView"]=2]="GalleryView"})(ForumLayoutType||(exports2.ForumLayoutType=ForumLayoutType={}));var ChannelType3;(function(ChannelType4){ChannelType4[ChannelType4["GuildText"]=0]="GuildText";ChannelType4[ChannelType4["DM"]=1]="DM";ChannelType4[ChannelType4["GuildVoice"]=2]="GuildVoice";ChannelType4[ChannelType4["GroupDM"]=3]="GroupDM";ChannelType4[ChannelType4["GuildCategory"]=4]="GuildCategory";ChannelType4[ChannelType4["GuildAnnouncement"]=5]="GuildAnnouncement";ChannelType4[ChannelType4["AnnouncementThread"]=10]="AnnouncementThread";ChannelType4[ChannelType4["PublicThread"]=11]="PublicThread";ChannelType4[ChannelType4["PrivateThread"]=12]="PrivateThread";ChannelType4[ChannelType4["GuildStageVoice"]=13]="GuildStageVoice";ChannelType4[ChannelType4["GuildDirectory"]=14]="GuildDirectory";ChannelType4[ChannelType4["GuildForum"]=15]="GuildForum";ChannelType4[ChannelType4["GuildMedia"]=16]="GuildMedia";ChannelType4[ChannelType4["GuildNews"]=5]="GuildNews";ChannelType4[ChannelType4["GuildNewsThread"]=10]="GuildNewsThread";ChannelType4[ChannelType4["GuildPublicThread"]=11]="GuildPublicThread";ChannelType4[ChannelType4["GuildPrivateThread"]=12]="GuildPrivateThread"})(ChannelType3||(exports2.ChannelType=ChannelType3={}));var VideoQualityMode;(function(VideoQualityMode2){VideoQualityMode2[VideoQualityMode2["Auto"]=1]="Auto";VideoQualityMode2[VideoQualityMode2["Full"]=2]="Full"})(VideoQualityMode||(exports2.VideoQualityMode=VideoQualityMode={}));var MessageType;(function(MessageType2){MessageType2[MessageType2["Default"]=0]="Default";MessageType2[MessageType2["RecipientAdd"]=1]="RecipientAdd";MessageType2[MessageType2["RecipientRemove"]=2]="RecipientRemove";MessageType2[MessageType2["Call"]=3]="Call";MessageType2[MessageType2["ChannelNameChange"]=4]="ChannelNameChange";MessageType2[MessageType2["ChannelIconChange"]=5]="ChannelIconChange";MessageType2[MessageType2["ChannelPinnedMessage"]=6]="ChannelPinnedMessage";MessageType2[MessageType2["UserJoin"]=7]="UserJoin";MessageType2[MessageType2["GuildBoost"]=8]="GuildBoost";MessageType2[MessageType2["GuildBoostTier1"]=9]="GuildBoostTier1";MessageType2[MessageType2["GuildBoostTier2"]=10]="GuildBoostTier2";MessageType2[MessageType2["GuildBoostTier3"]=11]="GuildBoostTier3";MessageType2[MessageType2["ChannelFollowAdd"]=12]="ChannelFollowAdd";MessageType2[MessageType2["GuildDiscoveryDisqualified"]=14]="GuildDiscoveryDisqualified";MessageType2[MessageType2["GuildDiscoveryRequalified"]=15]="GuildDiscoveryRequalified";MessageType2[MessageType2["GuildDiscoveryGracePeriodInitialWarning"]=16]="GuildDiscoveryGracePeriodInitialWarning";MessageType2[MessageType2["GuildDiscoveryGracePeriodFinalWarning"]=17]="GuildDiscoveryGracePeriodFinalWarning";MessageType2[MessageType2["ThreadCreated"]=18]="ThreadCreated";MessageType2[MessageType2["Reply"]=19]="Reply";MessageType2[MessageType2["ChatInputCommand"]=20]="ChatInputCommand";MessageType2[MessageType2["ThreadStarterMessage"]=21]="ThreadStarterMessage";MessageType2[MessageType2["GuildInviteReminder"]=22]="GuildInviteReminder";MessageType2[MessageType2["ContextMenuCommand"]=23]="ContextMenuCommand";MessageType2[MessageType2["AutoModerationAction"]=24]="AutoModerationAction";MessageType2[MessageType2["RoleSubscriptionPurchase"]=25]="RoleSubscriptionPurchase";MessageType2[MessageType2["InteractionPremiumUpsell"]=26]="InteractionPremiumUpsell";MessageType2[MessageType2["StageStart"]=27]="StageStart";MessageType2[MessageType2["StageEnd"]=28]="StageEnd";MessageType2[MessageType2["StageSpeaker"]=29]="StageSpeaker";MessageType2[MessageType2["StageRaiseHand"]=30]="StageRaiseHand";MessageType2[MessageType2["StageTopic"]=31]="StageTopic";MessageType2[MessageType2["GuildApplicationPremiumSubscription"]=32]="GuildApplicationPremiumSubscription";MessageType2[MessageType2["GuildIncidentAlertModeEnabled"]=36]="GuildIncidentAlertModeEnabled";MessageType2[MessageType2["GuildIncidentAlertModeDisabled"]=37]="GuildIncidentAlertModeDisabled";MessageType2[MessageType2["GuildIncidentReportRaid"]=38]="GuildIncidentReportRaid";MessageType2[MessageType2["GuildIncidentReportFalseAlarm"]=39]="GuildIncidentReportFalseAlarm";MessageType2[MessageType2["PurchaseNotification"]=44]="PurchaseNotification";MessageType2[MessageType2["PollResult"]=46]="PollResult"})(MessageType||(exports2.MessageType=MessageType={}));var MessageActivityType;(function(MessageActivityType2){MessageActivityType2[MessageActivityType2["Join"]=1]="Join";MessageActivityType2[MessageActivityType2["Spectate"]=2]="Spectate";MessageActivityType2[MessageActivityType2["Listen"]=3]="Listen";MessageActivityType2[MessageActivityType2["JoinRequest"]=5]="JoinRequest"})(MessageActivityType||(exports2.MessageActivityType=MessageActivityType={}));var MessageReferenceType;(function(MessageReferenceType2){MessageReferenceType2[MessageReferenceType2["Default"]=0]="Default";MessageReferenceType2[MessageReferenceType2["Forward"]=1]="Forward"})(MessageReferenceType||(exports2.MessageReferenceType=MessageReferenceType={}));var MessageFlags;(function(MessageFlags2){MessageFlags2[MessageFlags2["Crossposted"]=1]="Crossposted";MessageFlags2[MessageFlags2["IsCrosspost"]=2]="IsCrosspost";MessageFlags2[MessageFlags2["SuppressEmbeds"]=4]="SuppressEmbeds";MessageFlags2[MessageFlags2["SourceMessageDeleted"]=8]="SourceMessageDeleted";MessageFlags2[MessageFlags2["Urgent"]=16]="Urgent";MessageFlags2[MessageFlags2["HasThread"]=32]="HasThread";MessageFlags2[MessageFlags2["Ephemeral"]=64]="Ephemeral";MessageFlags2[MessageFlags2["Loading"]=128]="Loading";MessageFlags2[MessageFlags2["FailedToMentionSomeRolesInThread"]=256]="FailedToMentionSomeRolesInThread";MessageFlags2[MessageFlags2["ShouldShowLinkNotDiscordWarning"]=1024]="ShouldShowLinkNotDiscordWarning";MessageFlags2[MessageFlags2["SuppressNotifications"]=4096]="SuppressNotifications";MessageFlags2[MessageFlags2["IsVoiceMessage"]=8192]="IsVoiceMessage"})(MessageFlags||(exports2.MessageFlags=MessageFlags={}));var OverwriteType;(function(OverwriteType2){OverwriteType2[OverwriteType2["Role"]=0]="Role";OverwriteType2[OverwriteType2["Member"]=1]="Member"})(OverwriteType||(exports2.OverwriteType=OverwriteType={}));var ThreadAutoArchiveDuration;(function(ThreadAutoArchiveDuration2){ThreadAutoArchiveDuration2[ThreadAutoArchiveDuration2["OneHour"]=60]="OneHour";ThreadAutoArchiveDuration2[ThreadAutoArchiveDuration2["OneDay"]=1440]="OneDay";ThreadAutoArchiveDuration2[ThreadAutoArchiveDuration2["ThreeDays"]=4320]="ThreeDays";ThreadAutoArchiveDuration2[ThreadAutoArchiveDuration2["OneWeek"]=10080]="OneWeek"})(ThreadAutoArchiveDuration||(exports2.ThreadAutoArchiveDuration=ThreadAutoArchiveDuration={}));var ThreadMemberFlags;(function(ThreadMemberFlags2){ThreadMemberFlags2[ThreadMemberFlags2["HasInteracted"]=1]="HasInteracted";ThreadMemberFlags2[ThreadMemberFlags2["AllMessages"]=2]="AllMessages";ThreadMemberFlags2[ThreadMemberFlags2["OnlyMentions"]=4]="OnlyMentions";ThreadMemberFlags2[ThreadMemberFlags2["NoMessages"]=8]="NoMessages"})(ThreadMemberFlags||(exports2.ThreadMemberFlags=ThreadMemberFlags={}));var EmbedType;(function(EmbedType2){EmbedType2["Rich"]="rich";EmbedType2["Image"]="image";EmbedType2["Video"]="video";EmbedType2["GIFV"]="gifv";EmbedType2["Article"]="article";EmbedType2["Link"]="link";EmbedType2["AutoModerationMessage"]="auto_moderation_message";EmbedType2["PollResult"]="poll_result"})(EmbedType||(exports2.EmbedType=EmbedType={}));var AttachmentFlags;(function(AttachmentFlags2){AttachmentFlags2[AttachmentFlags2["IsRemix"]=4]="IsRemix"})(AttachmentFlags||(exports2.AttachmentFlags=AttachmentFlags={}));var AllowedMentionsTypes;(function(AllowedMentionsTypes2){AllowedMentionsTypes2["Everyone"]="everyone";AllowedMentionsTypes2["Role"]="roles";AllowedMentionsTypes2["User"]="users"})(AllowedMentionsTypes||(exports2.AllowedMentionsTypes=AllowedMentionsTypes={}));var ComponentType;(function(ComponentType2){ComponentType2[ComponentType2["ActionRow"]=1]="ActionRow";ComponentType2[ComponentType2["Button"]=2]="Button";ComponentType2[ComponentType2["StringSelect"]=3]="StringSelect";ComponentType2[ComponentType2["TextInput"]=4]="TextInput";ComponentType2[ComponentType2["UserSelect"]=5]="UserSelect";ComponentType2[ComponentType2["RoleSelect"]=6]="RoleSelect";ComponentType2[ComponentType2["MentionableSelect"]=7]="MentionableSelect";ComponentType2[ComponentType2["ChannelSelect"]=8]="ChannelSelect";ComponentType2[ComponentType2["SelectMenu"]=3]="SelectMenu"})(ComponentType||(exports2.ComponentType=ComponentType={}));var ButtonStyle2;(function(ButtonStyle3){ButtonStyle3[ButtonStyle3["Primary"]=1]="Primary";ButtonStyle3[ButtonStyle3["Secondary"]=2]="Secondary";ButtonStyle3[ButtonStyle3["Success"]=3]="Success";ButtonStyle3[ButtonStyle3["Danger"]=4]="Danger";ButtonStyle3[ButtonStyle3["Link"]=5]="Link";ButtonStyle3[ButtonStyle3["Premium"]=6]="Premium"})(ButtonStyle2||(exports2.ButtonStyle=ButtonStyle2={}));var TextInputStyle;(function(TextInputStyle2){TextInputStyle2[TextInputStyle2["Short"]=1]="Short";TextInputStyle2[TextInputStyle2["Paragraph"]=2]="Paragraph"})(TextInputStyle||(exports2.TextInputStyle=TextInputStyle={}));var SelectMenuDefaultValueType;(function(SelectMenuDefaultValueType2){SelectMenuDefaultValueType2["Channel"]="channel";SelectMenuDefaultValueType2["Role"]="role";SelectMenuDefaultValueType2["User"]="user"})(SelectMenuDefaultValueType||(exports2.SelectMenuDefaultValueType=SelectMenuDefaultValueType={}));var ChannelFlags;(function(ChannelFlags2){ChannelFlags2[ChannelFlags2["GuildFeedRemoved"]=1]="GuildFeedRemoved";ChannelFlags2[ChannelFlags2["Pinned"]=2]="Pinned";ChannelFlags2[ChannelFlags2["ActiveChannelsRemoved"]=4]="ActiveChannelsRemoved";ChannelFlags2[ChannelFlags2["RequireTag"]=16]="RequireTag";ChannelFlags2[ChannelFlags2["IsSpam"]=32]="IsSpam";ChannelFlags2[ChannelFlags2["IsGuildResourceChannel"]=128]="IsGuildResourceChannel";ChannelFlags2[ChannelFlags2["ClydeAI"]=256]="ClydeAI";ChannelFlags2[ChannelFlags2["IsScheduledForDeletion"]=512]="IsScheduledForDeletion";ChannelFlags2[ChannelFlags2["HideMediaDownloadOptions"]=32768]="HideMediaDownloadOptions"})(ChannelFlags||(exports2.ChannelFlags=ChannelFlags={}))}});var require_emoji=__commonJS({"node_modules/discord-api-types/payloads/v10/emoji.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_gateway=__commonJS({"node_modules/discord-api-types/payloads/v10/gateway.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ActivityFlags=exports2.ActivityType=exports2.ActivityPlatform=exports2.PresenceUpdateStatus=void 0;var PresenceUpdateStatus;(function(PresenceUpdateStatus2){PresenceUpdateStatus2["Online"]="online";PresenceUpdateStatus2["DoNotDisturb"]="dnd";PresenceUpdateStatus2["Idle"]="idle";PresenceUpdateStatus2["Invisible"]="invisible";PresenceUpdateStatus2["Offline"]="offline"})(PresenceUpdateStatus||(exports2.PresenceUpdateStatus=PresenceUpdateStatus={}));var ActivityPlatform;(function(ActivityPlatform2){ActivityPlatform2["Desktop"]="desktop";ActivityPlatform2["Xbox"]="xbox";ActivityPlatform2["Samsung"]="samsung";ActivityPlatform2["IOS"]="ios";ActivityPlatform2["Android"]="android";ActivityPlatform2["Embedded"]="embedded";ActivityPlatform2["PS4"]="ps4";ActivityPlatform2["PS5"]="ps5"})(ActivityPlatform||(exports2.ActivityPlatform=ActivityPlatform={}));var ActivityType2;(function(ActivityType3){ActivityType3[ActivityType3["Playing"]=0]="Playing";ActivityType3[ActivityType3["Streaming"]=1]="Streaming";ActivityType3[ActivityType3["Listening"]=2]="Listening";ActivityType3[ActivityType3["Watching"]=3]="Watching";ActivityType3[ActivityType3["Custom"]=4]="Custom";ActivityType3[ActivityType3["Competing"]=5]="Competing"})(ActivityType2||(exports2.ActivityType=ActivityType2={}));var ActivityFlags;(function(ActivityFlags2){ActivityFlags2[ActivityFlags2["Instance"]=1]="Instance";ActivityFlags2[ActivityFlags2["Join"]=2]="Join";ActivityFlags2[ActivityFlags2["Spectate"]=4]="Spectate";ActivityFlags2[ActivityFlags2["JoinRequest"]=8]="JoinRequest";ActivityFlags2[ActivityFlags2["Sync"]=16]="Sync";ActivityFlags2[ActivityFlags2["Play"]=32]="Play";ActivityFlags2[ActivityFlags2["PartyPrivacyFriends"]=64]="PartyPrivacyFriends";ActivityFlags2[ActivityFlags2["PartyPrivacyVoiceChannel"]=128]="PartyPrivacyVoiceChannel";ActivityFlags2[ActivityFlags2["Embedded"]=256]="Embedded"})(ActivityFlags||(exports2.ActivityFlags=ActivityFlags={}))}});var require_guild=__commonJS({"node_modules/discord-api-types/payloads/v10/guild.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.GuildOnboardingPromptType=exports2.GuildOnboardingMode=exports2.MembershipScreeningFieldType=exports2.GuildWidgetStyle=exports2.IntegrationExpireBehavior=exports2.GuildMemberFlags=exports2.GuildFeature=exports2.GuildSystemChannelFlags=exports2.GuildHubType=exports2.GuildPremiumTier=exports2.GuildVerificationLevel=exports2.GuildNSFWLevel=exports2.GuildMFALevel=exports2.GuildExplicitContentFilter=exports2.GuildDefaultMessageNotifications=void 0;var GuildDefaultMessageNotifications;(function(GuildDefaultMessageNotifications2){GuildDefaultMessageNotifications2[GuildDefaultMessageNotifications2["AllMessages"]=0]="AllMessages";GuildDefaultMessageNotifications2[GuildDefaultMessageNotifications2["OnlyMentions"]=1]="OnlyMentions"})(GuildDefaultMessageNotifications||(exports2.GuildDefaultMessageNotifications=GuildDefaultMessageNotifications={}));var GuildExplicitContentFilter;(function(GuildExplicitContentFilter2){GuildExplicitContentFilter2[GuildExplicitContentFilter2["Disabled"]=0]="Disabled";GuildExplicitContentFilter2[GuildExplicitContentFilter2["MembersWithoutRoles"]=1]="MembersWithoutRoles";GuildExplicitContentFilter2[GuildExplicitContentFilter2["AllMembers"]=2]="AllMembers"})(GuildExplicitContentFilter||(exports2.GuildExplicitContentFilter=GuildExplicitContentFilter={}));var GuildMFALevel;(function(GuildMFALevel2){GuildMFALevel2[GuildMFALevel2["None"]=0]="None";GuildMFALevel2[GuildMFALevel2["Elevated"]=1]="Elevated"})(GuildMFALevel||(exports2.GuildMFALevel=GuildMFALevel={}));var GuildNSFWLevel;(function(GuildNSFWLevel2){GuildNSFWLevel2[GuildNSFWLevel2["Default"]=0]="Default";GuildNSFWLevel2[GuildNSFWLevel2["Explicit"]=1]="Explicit";GuildNSFWLevel2[GuildNSFWLevel2["Safe"]=2]="Safe";GuildNSFWLevel2[GuildNSFWLevel2["AgeRestricted"]=3]="AgeRestricted"})(GuildNSFWLevel||(exports2.GuildNSFWLevel=GuildNSFWLevel={}));var GuildVerificationLevel;(function(GuildVerificationLevel2){GuildVerificationLevel2[GuildVerificationLevel2["None"]=0]="None";GuildVerificationLevel2[GuildVerificationLevel2["Low"]=1]="Low";GuildVerificationLevel2[GuildVerificationLevel2["Medium"]=2]="Medium";GuildVerificationLevel2[GuildVerificationLevel2["High"]=3]="High";GuildVerificationLevel2[GuildVerificationLevel2["VeryHigh"]=4]="VeryHigh"})(GuildVerificationLevel||(exports2.GuildVerificationLevel=GuildVerificationLevel={}));var GuildPremiumTier;(function(GuildPremiumTier2){GuildPremiumTier2[GuildPremiumTier2["None"]=0]="None";GuildPremiumTier2[GuildPremiumTier2["Tier1"]=1]="Tier1";GuildPremiumTier2[GuildPremiumTier2["Tier2"]=2]="Tier2";GuildPremiumTier2[GuildPremiumTier2["Tier3"]=3]="Tier3"})(GuildPremiumTier||(exports2.GuildPremiumTier=GuildPremiumTier={}));var GuildHubType;(function(GuildHubType2){GuildHubType2[GuildHubType2["Default"]=0]="Default";GuildHubType2[GuildHubType2["HighSchool"]=1]="HighSchool";GuildHubType2[GuildHubType2["College"]=2]="College"})(GuildHubType||(exports2.GuildHubType=GuildHubType={}));var GuildSystemChannelFlags;(function(GuildSystemChannelFlags2){GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressJoinNotifications"]=1]="SuppressJoinNotifications";GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressPremiumSubscriptions"]=2]="SuppressPremiumSubscriptions";GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressGuildReminderNotifications"]=4]="SuppressGuildReminderNotifications";GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressJoinNotificationReplies"]=8]="SuppressJoinNotificationReplies";GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressRoleSubscriptionPurchaseNotifications"]=16]="SuppressRoleSubscriptionPurchaseNotifications";GuildSystemChannelFlags2[GuildSystemChannelFlags2["SuppressRoleSubscriptionPurchaseNotificationReplies"]=32]="SuppressRoleSubscriptionPurchaseNotificationReplies"})(GuildSystemChannelFlags||(exports2.GuildSystemChannelFlags=GuildSystemChannelFlags={}));var GuildFeature;(function(GuildFeature2){GuildFeature2["AnimatedBanner"]="ANIMATED_BANNER";GuildFeature2["AnimatedIcon"]="ANIMATED_ICON";GuildFeature2["ApplicationCommandPermissionsV2"]="APPLICATION_COMMAND_PERMISSIONS_V2";GuildFeature2["AutoModeration"]="AUTO_MODERATION";GuildFeature2["Banner"]="BANNER";GuildFeature2["Community"]="COMMUNITY";GuildFeature2["CreatorMonetizableProvisional"]="CREATOR_MONETIZABLE_PROVISIONAL";GuildFeature2["CreatorStorePage"]="CREATOR_STORE_PAGE";GuildFeature2["DeveloperSupportServer"]="DEVELOPER_SUPPORT_SERVER";GuildFeature2["Discoverable"]="DISCOVERABLE";GuildFeature2["Featurable"]="FEATURABLE";GuildFeature2["HasDirectoryEntry"]="HAS_DIRECTORY_ENTRY";GuildFeature2["Hub"]="HUB";GuildFeature2["InvitesDisabled"]="INVITES_DISABLED";GuildFeature2["InviteSplash"]="INVITE_SPLASH";GuildFeature2["LinkedToHub"]="LINKED_TO_HUB";GuildFeature2["MemberVerificationGateEnabled"]="MEMBER_VERIFICATION_GATE_ENABLED";GuildFeature2["MonetizationEnabled"]="MONETIZATION_ENABLED";GuildFeature2["MoreStickers"]="MORE_STICKERS";GuildFeature2["News"]="NEWS";GuildFeature2["Partnered"]="PARTNERED";GuildFeature2["PreviewEnabled"]="PREVIEW_ENABLED";GuildFeature2["PrivateThreads"]="PRIVATE_THREADS";GuildFeature2["RaidAlertsDisabled"]="RAID_ALERTS_DISABLED";GuildFeature2["RelayEnabled"]="RELAY_ENABLED";GuildFeature2["RoleIcons"]="ROLE_ICONS";GuildFeature2["RoleSubscriptionsAvailableForPurchase"]="ROLE_SUBSCRIPTIONS_AVAILABLE_FOR_PURCHASE";GuildFeature2["RoleSubscriptionsEnabled"]="ROLE_SUBSCRIPTIONS_ENABLED";GuildFeature2["TicketedEventsEnabled"]="TICKETED_EVENTS_ENABLED";GuildFeature2["VanityURL"]="VANITY_URL";GuildFeature2["Verified"]="VERIFIED";GuildFeature2["VIPRegions"]="VIP_REGIONS";GuildFeature2["WelcomeScreenEnabled"]="WELCOME_SCREEN_ENABLED"})(GuildFeature||(exports2.GuildFeature=GuildFeature={}));var GuildMemberFlags;(function(GuildMemberFlags2){GuildMemberFlags2[GuildMemberFlags2["DidRejoin"]=1]="DidRejoin";GuildMemberFlags2[GuildMemberFlags2["CompletedOnboarding"]=2]="CompletedOnboarding";GuildMemberFlags2[GuildMemberFlags2["BypassesVerification"]=4]="BypassesVerification";GuildMemberFlags2[GuildMemberFlags2["StartedOnboarding"]=8]="StartedOnboarding";GuildMemberFlags2[GuildMemberFlags2["IsGuest"]=16]="IsGuest";GuildMemberFlags2[GuildMemberFlags2["StartedHomeActions"]=32]="StartedHomeActions";GuildMemberFlags2[GuildMemberFlags2["CompletedHomeActions"]=64]="CompletedHomeActions";GuildMemberFlags2[GuildMemberFlags2["AutomodQuarantinedUsernameOrGuildNickname"]=128]="AutomodQuarantinedUsernameOrGuildNickname";GuildMemberFlags2[GuildMemberFlags2["AutomodQuarantinedBio"]=256]="AutomodQuarantinedBio";GuildMemberFlags2[GuildMemberFlags2["DmSettingsUpsellAcknowledged"]=512]="DmSettingsUpsellAcknowledged"})(GuildMemberFlags||(exports2.GuildMemberFlags=GuildMemberFlags={}));var IntegrationExpireBehavior;(function(IntegrationExpireBehavior2){IntegrationExpireBehavior2[IntegrationExpireBehavior2["RemoveRole"]=0]="RemoveRole";IntegrationExpireBehavior2[IntegrationExpireBehavior2["Kick"]=1]="Kick"})(IntegrationExpireBehavior||(exports2.IntegrationExpireBehavior=IntegrationExpireBehavior={}));var GuildWidgetStyle;(function(GuildWidgetStyle2){GuildWidgetStyle2["Shield"]="shield";GuildWidgetStyle2["Banner1"]="banner1";GuildWidgetStyle2["Banner2"]="banner2";GuildWidgetStyle2["Banner3"]="banner3";GuildWidgetStyle2["Banner4"]="banner4"})(GuildWidgetStyle||(exports2.GuildWidgetStyle=GuildWidgetStyle={}));var MembershipScreeningFieldType;(function(MembershipScreeningFieldType2){MembershipScreeningFieldType2["Terms"]="TERMS"})(MembershipScreeningFieldType||(exports2.MembershipScreeningFieldType=MembershipScreeningFieldType={}));var GuildOnboardingMode;(function(GuildOnboardingMode2){GuildOnboardingMode2[GuildOnboardingMode2["OnboardingDefault"]=0]="OnboardingDefault";GuildOnboardingMode2[GuildOnboardingMode2["OnboardingAdvanced"]=1]="OnboardingAdvanced"})(GuildOnboardingMode||(exports2.GuildOnboardingMode=GuildOnboardingMode={}));var GuildOnboardingPromptType;(function(GuildOnboardingPromptType2){GuildOnboardingPromptType2[GuildOnboardingPromptType2["MultipleChoice"]=0]="MultipleChoice";GuildOnboardingPromptType2[GuildOnboardingPromptType2["Dropdown"]=1]="Dropdown"})(GuildOnboardingPromptType||(exports2.GuildOnboardingPromptType=GuildOnboardingPromptType={}))}});var require_guildScheduledEvent=__commonJS({"node_modules/discord-api-types/payloads/v10/guildScheduledEvent.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.GuildScheduledEventPrivacyLevel=exports2.GuildScheduledEventStatus=exports2.GuildScheduledEventEntityType=exports2.GuildScheduledEventRecurrenceRuleMonth=exports2.GuildScheduledEventRecurrenceRuleWeekday=exports2.GuildScheduledEventRecurrenceRuleFrequency=void 0;var GuildScheduledEventRecurrenceRuleFrequency;(function(GuildScheduledEventRecurrenceRuleFrequency2){GuildScheduledEventRecurrenceRuleFrequency2[GuildScheduledEventRecurrenceRuleFrequency2["Yearly"]=0]="Yearly";GuildScheduledEventRecurrenceRuleFrequency2[GuildScheduledEventRecurrenceRuleFrequency2["Monthly"]=1]="Monthly";GuildScheduledEventRecurrenceRuleFrequency2[GuildScheduledEventRecurrenceRuleFrequency2["Weekly"]=2]="Weekly";GuildScheduledEventRecurrenceRuleFrequency2[GuildScheduledEventRecurrenceRuleFrequency2["Daily"]=3]="Daily"})(GuildScheduledEventRecurrenceRuleFrequency||(exports2.GuildScheduledEventRecurrenceRuleFrequency=GuildScheduledEventRecurrenceRuleFrequency={}));var GuildScheduledEventRecurrenceRuleWeekday;(function(GuildScheduledEventRecurrenceRuleWeekday2){GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Monday"]=0]="Monday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Tuesday"]=1]="Tuesday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Wednesday"]=2]="Wednesday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Thursday"]=3]="Thursday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Friday"]=4]="Friday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Saturday"]=5]="Saturday";GuildScheduledEventRecurrenceRuleWeekday2[GuildScheduledEventRecurrenceRuleWeekday2["Sunday"]=6]="Sunday"})(GuildScheduledEventRecurrenceRuleWeekday||(exports2.GuildScheduledEventRecurrenceRuleWeekday=GuildScheduledEventRecurrenceRuleWeekday={}));var GuildScheduledEventRecurrenceRuleMonth;(function(GuildScheduledEventRecurrenceRuleMonth2){GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["January"]=1]="January";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["February"]=2]="February";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["March"]=3]="March";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["April"]=4]="April";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["May"]=5]="May";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["June"]=6]="June";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["July"]=7]="July";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["August"]=8]="August";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["September"]=9]="September";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["October"]=10]="October";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["November"]=11]="November";GuildScheduledEventRecurrenceRuleMonth2[GuildScheduledEventRecurrenceRuleMonth2["December"]=12]="December"})(GuildScheduledEventRecurrenceRuleMonth||(exports2.GuildScheduledEventRecurrenceRuleMonth=GuildScheduledEventRecurrenceRuleMonth={}));var GuildScheduledEventEntityType;(function(GuildScheduledEventEntityType2){GuildScheduledEventEntityType2[GuildScheduledEventEntityType2["StageInstance"]=1]="StageInstance";GuildScheduledEventEntityType2[GuildScheduledEventEntityType2["Voice"]=2]="Voice";GuildScheduledEventEntityType2[GuildScheduledEventEntityType2["External"]=3]="External"})(GuildScheduledEventEntityType||(exports2.GuildScheduledEventEntityType=GuildScheduledEventEntityType={}));var GuildScheduledEventStatus;(function(GuildScheduledEventStatus2){GuildScheduledEventStatus2[GuildScheduledEventStatus2["Scheduled"]=1]="Scheduled";GuildScheduledEventStatus2[GuildScheduledEventStatus2["Active"]=2]="Active";GuildScheduledEventStatus2[GuildScheduledEventStatus2["Completed"]=3]="Completed";GuildScheduledEventStatus2[GuildScheduledEventStatus2["Canceled"]=4]="Canceled"})(GuildScheduledEventStatus||(exports2.GuildScheduledEventStatus=GuildScheduledEventStatus={}));var GuildScheduledEventPrivacyLevel;(function(GuildScheduledEventPrivacyLevel2){GuildScheduledEventPrivacyLevel2[GuildScheduledEventPrivacyLevel2["GuildOnly"]=2]="GuildOnly"})(GuildScheduledEventPrivacyLevel||(exports2.GuildScheduledEventPrivacyLevel=GuildScheduledEventPrivacyLevel={}))}});var require_attachment=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/attachment.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_base=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/base.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_boolean=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/boolean.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_channel2=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/channel.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_integer=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/integer.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_mentionable=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/mentionable.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_number=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/number.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_role=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/role.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_shared=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/shared.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ApplicationCommandOptionType=void 0;var ApplicationCommandOptionType2;(function(ApplicationCommandOptionType3){ApplicationCommandOptionType3[ApplicationCommandOptionType3["Subcommand"]=1]="Subcommand";ApplicationCommandOptionType3[ApplicationCommandOptionType3["SubcommandGroup"]=2]="SubcommandGroup";ApplicationCommandOptionType3[ApplicationCommandOptionType3["String"]=3]="String";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Integer"]=4]="Integer";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Boolean"]=5]="Boolean";ApplicationCommandOptionType3[ApplicationCommandOptionType3["User"]=6]="User";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Channel"]=7]="Channel";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Role"]=8]="Role";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Mentionable"]=9]="Mentionable";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Number"]=10]="Number";ApplicationCommandOptionType3[ApplicationCommandOptionType3["Attachment"]=11]="Attachment"})(ApplicationCommandOptionType2||(exports2.ApplicationCommandOptionType=ApplicationCommandOptionType2={}))}});var require_string=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/string.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_subcommand=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/subcommand.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_subcommandGroup=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/subcommandGroup.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_user=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/_chatInput/user.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_chatInput=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/chatInput.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});__exportStar2(require_attachment(),exports2);__exportStar2(require_base(),exports2);__exportStar2(require_boolean(),exports2);__exportStar2(require_channel2(),exports2);__exportStar2(require_integer(),exports2);__exportStar2(require_mentionable(),exports2);__exportStar2(require_number(),exports2);__exportStar2(require_role(),exports2);__exportStar2(require_shared(),exports2);__exportStar2(require_string(),exports2);__exportStar2(require_subcommand(),exports2);__exportStar2(require_subcommandGroup(),exports2);__exportStar2(require_user(),exports2)}});var require_contextMenu=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/contextMenu.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_permissions=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/_applicationCommands/permissions.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.APIApplicationCommandPermissionsConstant=exports2.ApplicationCommandPermissionType=void 0;var ApplicationCommandPermissionType;(function(ApplicationCommandPermissionType2){ApplicationCommandPermissionType2[ApplicationCommandPermissionType2["Role"]=1]="Role";ApplicationCommandPermissionType2[ApplicationCommandPermissionType2["User"]=2]="User";ApplicationCommandPermissionType2[ApplicationCommandPermissionType2["Channel"]=3]="Channel"})(ApplicationCommandPermissionType||(exports2.ApplicationCommandPermissionType=ApplicationCommandPermissionType={}));exports2.APIApplicationCommandPermissionsConstant={Everyone:guildId=>String(guildId),AllChannels:guildId=>String(BigInt(guildId)-1n)}}});var require_applicationCommands=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/applicationCommands.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});exports2.EntryPointCommandHandlerType=exports2.InteractionContextType=exports2.ApplicationIntegrationType=exports2.ApplicationCommandType=void 0;__exportStar2(require_chatInput(),exports2);__exportStar2(require_contextMenu(),exports2);__exportStar2(require_permissions(),exports2);var ApplicationCommandType2;(function(ApplicationCommandType3){ApplicationCommandType3[ApplicationCommandType3["ChatInput"]=1]="ChatInput";ApplicationCommandType3[ApplicationCommandType3["User"]=2]="User";ApplicationCommandType3[ApplicationCommandType3["Message"]=3]="Message";ApplicationCommandType3[ApplicationCommandType3["PrimaryEntryPoint"]=4]="PrimaryEntryPoint"})(ApplicationCommandType2||(exports2.ApplicationCommandType=ApplicationCommandType2={}));var ApplicationIntegrationType;(function(ApplicationIntegrationType2){ApplicationIntegrationType2[ApplicationIntegrationType2["GuildInstall"]=0]="GuildInstall";ApplicationIntegrationType2[ApplicationIntegrationType2["UserInstall"]=1]="UserInstall"})(ApplicationIntegrationType||(exports2.ApplicationIntegrationType=ApplicationIntegrationType={}));var InteractionContextType;(function(InteractionContextType2){InteractionContextType2[InteractionContextType2["Guild"]=0]="Guild";InteractionContextType2[InteractionContextType2["BotDM"]=1]="BotDM";InteractionContextType2[InteractionContextType2["PrivateChannel"]=2]="PrivateChannel"})(InteractionContextType||(exports2.InteractionContextType=InteractionContextType={}));var EntryPointCommandHandlerType;(function(EntryPointCommandHandlerType2){EntryPointCommandHandlerType2[EntryPointCommandHandlerType2["AppHandler"]=1]="AppHandler";EntryPointCommandHandlerType2[EntryPointCommandHandlerType2["DiscordLaunchActivity"]=2]="DiscordLaunchActivity"})(EntryPointCommandHandlerType||(exports2.EntryPointCommandHandlerType=EntryPointCommandHandlerType={}))}});var require_autocomplete=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/autocomplete.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_base2=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/base.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_messageComponents=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/messageComponents.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_modalSubmit=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/modalSubmit.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_ping=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/ping.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_responses=__commonJS({"node_modules/discord-api-types/payloads/v10/_interactions/responses.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.InteractionResponseType=exports2.InteractionType=void 0;var InteractionType2;(function(InteractionType3){InteractionType3[InteractionType3["Ping"]=1]="Ping";InteractionType3[InteractionType3["ApplicationCommand"]=2]="ApplicationCommand";InteractionType3[InteractionType3["MessageComponent"]=3]="MessageComponent";InteractionType3[InteractionType3["ApplicationCommandAutocomplete"]=4]="ApplicationCommandAutocomplete";InteractionType3[InteractionType3["ModalSubmit"]=5]="ModalSubmit"})(InteractionType2||(exports2.InteractionType=InteractionType2={}));var InteractionResponseType;(function(InteractionResponseType2){InteractionResponseType2[InteractionResponseType2["Pong"]=1]="Pong";InteractionResponseType2[InteractionResponseType2["ChannelMessageWithSource"]=4]="ChannelMessageWithSource";InteractionResponseType2[InteractionResponseType2["DeferredChannelMessageWithSource"]=5]="DeferredChannelMessageWithSource";InteractionResponseType2[InteractionResponseType2["DeferredMessageUpdate"]=6]="DeferredMessageUpdate";InteractionResponseType2[InteractionResponseType2["UpdateMessage"]=7]="UpdateMessage";InteractionResponseType2[InteractionResponseType2["ApplicationCommandAutocompleteResult"]=8]="ApplicationCommandAutocompleteResult";InteractionResponseType2[InteractionResponseType2["Modal"]=9]="Modal";InteractionResponseType2[InteractionResponseType2["PremiumRequired"]=10]="PremiumRequired";InteractionResponseType2[InteractionResponseType2["LaunchActivity"]=12]="LaunchActivity"})(InteractionResponseType||(exports2.InteractionResponseType=InteractionResponseType={}))}});var require_interactions=__commonJS({"node_modules/discord-api-types/payloads/v10/interactions.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});__exportStar2(require_applicationCommands(),exports2);__exportStar2(require_autocomplete(),exports2);__exportStar2(require_base2(),exports2);__exportStar2(require_messageComponents(),exports2);__exportStar2(require_modalSubmit(),exports2);__exportStar2(require_ping(),exports2);__exportStar2(require_responses(),exports2)}});var require_invite=__commonJS({"node_modules/discord-api-types/payloads/v10/invite.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.InviteTargetType=exports2.InviteType=void 0;var InviteType;(function(InviteType2){InviteType2[InviteType2["Guild"]=0]="Guild";InviteType2[InviteType2["GroupDM"]=1]="GroupDM";InviteType2[InviteType2["Friend"]=2]="Friend"})(InviteType||(exports2.InviteType=InviteType={}));var InviteTargetType;(function(InviteTargetType2){InviteTargetType2[InviteTargetType2["Stream"]=1]="Stream";InviteTargetType2[InviteTargetType2["EmbeddedApplication"]=2]="EmbeddedApplication"})(InviteTargetType||(exports2.InviteTargetType=InviteTargetType={}))}});var require_oauth2=__commonJS({"node_modules/discord-api-types/payloads/v10/oauth2.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.OAuth2Scopes=void 0;var OAuth2Scopes2;(function(OAuth2Scopes3){OAuth2Scopes3["Bot"]="bot";OAuth2Scopes3["Connections"]="connections";OAuth2Scopes3["DMChannelsRead"]="dm_channels.read";OAuth2Scopes3["Email"]="email";OAuth2Scopes3["Identify"]="identify";OAuth2Scopes3["Guilds"]="guilds";OAuth2Scopes3["GuildsJoin"]="guilds.join";OAuth2Scopes3["GuildsMembersRead"]="guilds.members.read";OAuth2Scopes3["GroupDMJoins"]="gdm.join";OAuth2Scopes3["MessagesRead"]="messages.read";OAuth2Scopes3["RoleConnectionsWrite"]="role_connections.write";OAuth2Scopes3["RPC"]="rpc";OAuth2Scopes3["RPCNotificationsRead"]="rpc.notifications.read";OAuth2Scopes3["WebhookIncoming"]="webhook.incoming";OAuth2Scopes3["Voice"]="voice";OAuth2Scopes3["ApplicationsBuildsUpload"]="applications.builds.upload";OAuth2Scopes3["ApplicationsBuildsRead"]="applications.builds.read";OAuth2Scopes3["ApplicationsStoreUpdate"]="applications.store.update";OAuth2Scopes3["ApplicationsEntitlements"]="applications.entitlements";OAuth2Scopes3["RelationshipsRead"]="relationships.read";OAuth2Scopes3["ActivitiesRead"]="activities.read";OAuth2Scopes3["ActivitiesWrite"]="activities.write";OAuth2Scopes3["ApplicationsCommands"]="applications.commands";OAuth2Scopes3["ApplicationsCommandsUpdate"]="applications.commands.update";OAuth2Scopes3["ApplicationCommandsPermissionsUpdate"]="applications.commands.permissions.update"})(OAuth2Scopes2||(exports2.OAuth2Scopes=OAuth2Scopes2={}))}});var require_poll=__commonJS({"node_modules/discord-api-types/payloads/v10/poll.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.PollLayoutType=void 0;var PollLayoutType;(function(PollLayoutType2){PollLayoutType2[PollLayoutType2["Default"]=1]="Default"})(PollLayoutType||(exports2.PollLayoutType=PollLayoutType={}))}});var require_permissions2=__commonJS({"node_modules/discord-api-types/payloads/v10/permissions.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.RoleFlags=void 0;var RoleFlags;(function(RoleFlags2){RoleFlags2[RoleFlags2["InPrompt"]=1]="InPrompt"})(RoleFlags||(exports2.RoleFlags=RoleFlags={}))}});var require_stageInstance=__commonJS({"node_modules/discord-api-types/payloads/v10/stageInstance.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.StageInstancePrivacyLevel=void 0;var StageInstancePrivacyLevel;(function(StageInstancePrivacyLevel2){StageInstancePrivacyLevel2[StageInstancePrivacyLevel2["Public"]=1]="Public";StageInstancePrivacyLevel2[StageInstancePrivacyLevel2["GuildOnly"]=2]="GuildOnly"})(StageInstancePrivacyLevel||(exports2.StageInstancePrivacyLevel=StageInstancePrivacyLevel={}))}});var require_sticker=__commonJS({"node_modules/discord-api-types/payloads/v10/sticker.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.StickerFormatType=exports2.StickerType=void 0;var StickerType;(function(StickerType2){StickerType2[StickerType2["Standard"]=1]="Standard";StickerType2[StickerType2["Guild"]=2]="Guild"})(StickerType||(exports2.StickerType=StickerType={}));var StickerFormatType;(function(StickerFormatType2){StickerFormatType2[StickerFormatType2["PNG"]=1]="PNG";StickerFormatType2[StickerFormatType2["APNG"]=2]="APNG";StickerFormatType2[StickerFormatType2["Lottie"]=3]="Lottie";StickerFormatType2[StickerFormatType2["GIF"]=4]="GIF"})(StickerFormatType||(exports2.StickerFormatType=StickerFormatType={}))}});var require_teams=__commonJS({"node_modules/discord-api-types/payloads/v10/teams.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.TeamMemberRole=exports2.TeamMemberMembershipState=void 0;var TeamMemberMembershipState;(function(TeamMemberMembershipState2){TeamMemberMembershipState2[TeamMemberMembershipState2["Invited"]=1]="Invited";TeamMemberMembershipState2[TeamMemberMembershipState2["Accepted"]=2]="Accepted"})(TeamMemberMembershipState||(exports2.TeamMemberMembershipState=TeamMemberMembershipState={}));var TeamMemberRole;(function(TeamMemberRole2){TeamMemberRole2["Admin"]="admin";TeamMemberRole2["Developer"]="developer";TeamMemberRole2["ReadOnly"]="read_only"})(TeamMemberRole||(exports2.TeamMemberRole=TeamMemberRole={}))}});var require_template=__commonJS({"node_modules/discord-api-types/payloads/v10/template.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_user2=__commonJS({"node_modules/discord-api-types/payloads/v10/user.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ConnectionVisibility=exports2.ConnectionService=exports2.UserPremiumType=exports2.UserFlags=void 0;var UserFlags;(function(UserFlags2){UserFlags2[UserFlags2["Staff"]=1]="Staff";UserFlags2[UserFlags2["Partner"]=2]="Partner";UserFlags2[UserFlags2["Hypesquad"]=4]="Hypesquad";UserFlags2[UserFlags2["BugHunterLevel1"]=8]="BugHunterLevel1";UserFlags2[UserFlags2["MFASMS"]=16]="MFASMS";UserFlags2[UserFlags2["PremiumPromoDismissed"]=32]="PremiumPromoDismissed";UserFlags2[UserFlags2["HypeSquadOnlineHouse1"]=64]="HypeSquadOnlineHouse1";UserFlags2[UserFlags2["HypeSquadOnlineHouse2"]=128]="HypeSquadOnlineHouse2";UserFlags2[UserFlags2["HypeSquadOnlineHouse3"]=256]="HypeSquadOnlineHouse3";UserFlags2[UserFlags2["PremiumEarlySupporter"]=512]="PremiumEarlySupporter";UserFlags2[UserFlags2["TeamPseudoUser"]=1024]="TeamPseudoUser";UserFlags2[UserFlags2["HasUnreadUrgentMessages"]=8192]="HasUnreadUrgentMessages";UserFlags2[UserFlags2["BugHunterLevel2"]=16384]="BugHunterLevel2";UserFlags2[UserFlags2["VerifiedBot"]=65536]="VerifiedBot";UserFlags2[UserFlags2["VerifiedDeveloper"]=131072]="VerifiedDeveloper";UserFlags2[UserFlags2["CertifiedModerator"]=262144]="CertifiedModerator";UserFlags2[UserFlags2["BotHTTPInteractions"]=524288]="BotHTTPInteractions";UserFlags2[UserFlags2["Spammer"]=1048576]="Spammer";UserFlags2[UserFlags2["DisablePremium"]=2097152]="DisablePremium";UserFlags2[UserFlags2["ActiveDeveloper"]=4194304]="ActiveDeveloper";UserFlags2[UserFlags2["Quarantined"]=17592186044416]="Quarantined";UserFlags2[UserFlags2["Collaborator"]=0x4000000000000]="Collaborator";UserFlags2[UserFlags2["RestrictedCollaborator"]=0x8000000000000]="RestrictedCollaborator"})(UserFlags||(exports2.UserFlags=UserFlags={}));var UserPremiumType;(function(UserPremiumType2){UserPremiumType2[UserPremiumType2["None"]=0]="None";UserPremiumType2[UserPremiumType2["NitroClassic"]=1]="NitroClassic";UserPremiumType2[UserPremiumType2["Nitro"]=2]="Nitro";UserPremiumType2[UserPremiumType2["NitroBasic"]=3]="NitroBasic"})(UserPremiumType||(exports2.UserPremiumType=UserPremiumType={}));var ConnectionService;(function(ConnectionService2){ConnectionService2["AmazonMusic"]="amazon-music";ConnectionService2["BattleNet"]="battlenet";ConnectionService2["BungieNet"]="bungie";ConnectionService2["Domain"]="domain";ConnectionService2["eBay"]="ebay";ConnectionService2["EpicGames"]="epicgames";ConnectionService2["Facebook"]="facebook";ConnectionService2["GitHub"]="github";ConnectionService2["Instagram"]="instagram";ConnectionService2["LeagueOfLegends"]="leagueoflegends";ConnectionService2["PayPal"]="paypal";ConnectionService2["PlayStationNetwork"]="playstation";ConnectionService2["Reddit"]="reddit";ConnectionService2["RiotGames"]="riotgames";ConnectionService2["Roblox"]="roblox";ConnectionService2["Spotify"]="spotify";ConnectionService2["Skype"]="skype";ConnectionService2["Steam"]="steam";ConnectionService2["TikTok"]="tiktok";ConnectionService2["Twitch"]="twitch";ConnectionService2["X"]="twitter";ConnectionService2["Twitter"]="twitter";ConnectionService2["Xbox"]="xbox";ConnectionService2["YouTube"]="youtube"})(ConnectionService||(exports2.ConnectionService=ConnectionService={}));var ConnectionVisibility;(function(ConnectionVisibility2){ConnectionVisibility2[ConnectionVisibility2["None"]=0]="None";ConnectionVisibility2[ConnectionVisibility2["Everyone"]=1]="Everyone"})(ConnectionVisibility||(exports2.ConnectionVisibility=ConnectionVisibility={}))}});var require_voice=__commonJS({"node_modules/discord-api-types/payloads/v10/voice.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_webhook=__commonJS({"node_modules/discord-api-types/payloads/v10/webhook.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.WebhookType=void 0;var WebhookType;(function(WebhookType2){WebhookType2[WebhookType2["Incoming"]=1]="Incoming";WebhookType2[WebhookType2["ChannelFollower"]=2]="ChannelFollower";WebhookType2[WebhookType2["Application"]=3]="Application"})(WebhookType||(exports2.WebhookType=WebhookType={}))}});var require_monetization=__commonJS({"node_modules/discord-api-types/payloads/v10/monetization.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SubscriptionStatus=exports2.SKUType=exports2.SKUFlags=exports2.EntitlementType=void 0;var EntitlementType;(function(EntitlementType2){EntitlementType2[EntitlementType2["Purchase"]=1]="Purchase";EntitlementType2[EntitlementType2["PremiumSubscription"]=2]="PremiumSubscription";EntitlementType2[EntitlementType2["DeveloperGift"]=3]="DeveloperGift";EntitlementType2[EntitlementType2["TestModePurchase"]=4]="TestModePurchase";EntitlementType2[EntitlementType2["FreePurchase"]=5]="FreePurchase";EntitlementType2[EntitlementType2["UserGift"]=6]="UserGift";EntitlementType2[EntitlementType2["PremiumPurchase"]=7]="PremiumPurchase";EntitlementType2[EntitlementType2["ApplicationSubscription"]=8]="ApplicationSubscription"})(EntitlementType||(exports2.EntitlementType=EntitlementType={}));var SKUFlags;(function(SKUFlags2){SKUFlags2[SKUFlags2["Available"]=4]="Available";SKUFlags2[SKUFlags2["GuildSubscription"]=128]="GuildSubscription";SKUFlags2[SKUFlags2["UserSubscription"]=256]="UserSubscription"})(SKUFlags||(exports2.SKUFlags=SKUFlags={}));var SKUType;(function(SKUType2){SKUType2[SKUType2["Durable"]=2]="Durable";SKUType2[SKUType2["Consumable"]=3]="Consumable";SKUType2[SKUType2["Subscription"]=5]="Subscription";SKUType2[SKUType2["SubscriptionGroup"]=6]="SubscriptionGroup"})(SKUType||(exports2.SKUType=SKUType={}));var SubscriptionStatus;(function(SubscriptionStatus2){SubscriptionStatus2[SubscriptionStatus2["Active"]=0]="Active";SubscriptionStatus2[SubscriptionStatus2["Ending"]=1]="Ending";SubscriptionStatus2[SubscriptionStatus2["Inactive"]=2]="Inactive"})(SubscriptionStatus||(exports2.SubscriptionStatus=SubscriptionStatus={}))}});var require_v102=__commonJS({"node_modules/discord-api-types/payloads/v10/index.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});__exportStar2(require_common2(),exports2);__exportStar2(require_application(),exports2);__exportStar2(require_auditLog(),exports2);__exportStar2(require_autoModeration(),exports2);__exportStar2(require_channel(),exports2);__exportStar2(require_emoji(),exports2);__exportStar2(require_gateway(),exports2);__exportStar2(require_guild(),exports2);__exportStar2(require_guildScheduledEvent(),exports2);__exportStar2(require_interactions(),exports2);__exportStar2(require_invite(),exports2);__exportStar2(require_oauth2(),exports2);__exportStar2(require_poll(),exports2);__exportStar2(require_permissions2(),exports2);__exportStar2(require_stageInstance(),exports2);__exportStar2(require_sticker(),exports2);__exportStar2(require_teams(),exports2);__exportStar2(require_template(),exports2);__exportStar2(require_user2(),exports2);__exportStar2(require_voice(),exports2);__exportStar2(require_webhook(),exports2);__exportStar2(require_monetization(),exports2)}});var require_common3=__commonJS({"node_modules/discord-api-types/rest/common.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.Locale=exports2.RESTJSONErrorCodes=void 0;var RESTJSONErrorCodes;(function(RESTJSONErrorCodes2){RESTJSONErrorCodes2[RESTJSONErrorCodes2["GeneralError"]=0]="GeneralError";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownAccount"]=10001]="UnknownAccount";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownApplication"]=10002]="UnknownApplication";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownChannel"]=10003]="UnknownChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuild"]=10004]="UnknownGuild";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownIntegration"]=10005]="UnknownIntegration";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownInvite"]=10006]="UnknownInvite";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownMember"]=10007]="UnknownMember";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownMessage"]=10008]="UnknownMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownPermissionOverwrite"]=10009]="UnknownPermissionOverwrite";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownProvider"]=10010]="UnknownProvider";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownRole"]=10011]="UnknownRole";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownToken"]=10012]="UnknownToken";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownUser"]=10013]="UnknownUser";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownEmoji"]=10014]="UnknownEmoji";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownWebhook"]=10015]="UnknownWebhook";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownWebhookService"]=10016]="UnknownWebhookService";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownSession"]=10020]="UnknownSession";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownBan"]=10026]="UnknownBan";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownSKU"]=10027]="UnknownSKU";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownStoreListing"]=10028]="UnknownStoreListing";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownEntitlement"]=10029]="UnknownEntitlement";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownBuild"]=10030]="UnknownBuild";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownLobby"]=10031]="UnknownLobby";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownBranch"]=10032]="UnknownBranch";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownStoreDirectoryLayout"]=10033]="UnknownStoreDirectoryLayout";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownRedistributable"]=10036]="UnknownRedistributable";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGiftCode"]=10038]="UnknownGiftCode";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownStream"]=10049]="UnknownStream";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownPremiumServerSubscribeCooldown"]=10050]="UnknownPremiumServerSubscribeCooldown";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuildTemplate"]=10057]="UnknownGuildTemplate";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownDiscoverableServerCategory"]=10059]="UnknownDiscoverableServerCategory";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownSticker"]=10060]="UnknownSticker";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownStickerPack"]=10061]="UnknownStickerPack";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownInteraction"]=10062]="UnknownInteraction";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownApplicationCommand"]=10063]="UnknownApplicationCommand";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownVoiceState"]=10065]="UnknownVoiceState";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownApplicationCommandPermissions"]=10066]="UnknownApplicationCommandPermissions";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownStageInstance"]=10067]="UnknownStageInstance";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuildMemberVerificationForm"]=10068]="UnknownGuildMemberVerificationForm";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuildWelcomeScreen"]=10069]="UnknownGuildWelcomeScreen";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuildScheduledEvent"]=10070]="UnknownGuildScheduledEvent";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownGuildScheduledEventUser"]=10071]="UnknownGuildScheduledEventUser";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnknownTag"]=10087]="UnknownTag";RESTJSONErrorCodes2[RESTJSONErrorCodes2["BotsCannotUseThisEndpoint"]=20001]="BotsCannotUseThisEndpoint";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OnlyBotsCanUseThisEndpoint"]=20002]="OnlyBotsCanUseThisEndpoint";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ExplicitContentCannotBeSentToTheDesiredRecipient"]=20009]="ExplicitContentCannotBeSentToTheDesiredRecipient";RESTJSONErrorCodes2[RESTJSONErrorCodes2["NotAuthorizedToPerformThisActionOnThisApplication"]=20012]="NotAuthorizedToPerformThisActionOnThisApplication";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ActionCannotBePerformedDueToSlowmodeRateLimit"]=20016]="ActionCannotBePerformedDueToSlowmodeRateLimit";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TheMazeIsntMeantForYou"]=20017]="TheMazeIsntMeantForYou";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OnlyTheOwnerOfThisAccountCanPerformThisAction"]=20018]="OnlyTheOwnerOfThisAccountCanPerformThisAction";RESTJSONErrorCodes2[RESTJSONErrorCodes2["AnnouncementEditLimitExceeded"]=20022]="AnnouncementEditLimitExceeded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UnderMinimumAge"]=20024]="UnderMinimumAge";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ChannelSendRateLimit"]=20028]="ChannelSendRateLimit";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ServerSendRateLimit"]=20029]="ServerSendRateLimit";RESTJSONErrorCodes2[RESTJSONErrorCodes2["StageTopicServerNameServerDescriptionOrChannelNamesContainDisallowedWords"]=20031]="StageTopicServerNameServerDescriptionOrChannelNamesContainDisallowedWords";RESTJSONErrorCodes2[RESTJSONErrorCodes2["GuildPremiumSubscriptionLevelTooLow"]=20035]="GuildPremiumSubscriptionLevelTooLow";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfGuildsReached"]=30001]="MaximumNumberOfGuildsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfFriendsReached"]=30002]="MaximumNumberOfFriendsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfPinsReachedForTheChannel"]=30003]="MaximumNumberOfPinsReachedForTheChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfRecipientsReached"]=30004]="MaximumNumberOfRecipientsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfGuildRolesReached"]=30005]="MaximumNumberOfGuildRolesReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfWebhooksReached"]=30007]="MaximumNumberOfWebhooksReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfEmojisReached"]=30008]="MaximumNumberOfEmojisReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfReactionsReached"]=30010]="MaximumNumberOfReactionsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfGroupDMsReached"]=30011]="MaximumNumberOfGroupDMsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfGuildChannelsReached"]=30013]="MaximumNumberOfGuildChannelsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfAttachmentsInAMessageReached"]=30015]="MaximumNumberOfAttachmentsInAMessageReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfInvitesReached"]=30016]="MaximumNumberOfInvitesReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfAnimatedEmojisReached"]=30018]="MaximumNumberOfAnimatedEmojisReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfServerMembersReached"]=30019]="MaximumNumberOfServerMembersReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfServerCategoriesReached"]=30030]="MaximumNumberOfServerCategoriesReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["GuildAlreadyHasTemplate"]=30031]="GuildAlreadyHasTemplate";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfApplicationCommandsReached"]=30032]="MaximumNumberOfApplicationCommandsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumThreadParticipantsReached"]=30033]="MaximumThreadParticipantsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumDailyApplicationCommandCreatesReached"]=30034]="MaximumDailyApplicationCommandCreatesReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfNonGuildMemberBansHasBeenExceeded"]=30035]="MaximumNumberOfNonGuildMemberBansHasBeenExceeded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfBanFetchesHasBeenReached"]=30037]="MaximumNumberOfBanFetchesHasBeenReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfUncompletedGuildScheduledEventsReached"]=30038]="MaximumNumberOfUncompletedGuildScheduledEventsReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfStickersReached"]=30039]="MaximumNumberOfStickersReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfPruneRequestsHasBeenReached"]=30040]="MaximumNumberOfPruneRequestsHasBeenReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfGuildWidgetSettingsUpdatesHasBeenReached"]=30042]="MaximumNumberOfGuildWidgetSettingsUpdatesHasBeenReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfEditsToMessagesOlderThanOneHourReached"]=30046]="MaximumNumberOfEditsToMessagesOlderThanOneHourReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfPinnedThreadsInForumHasBeenReached"]=30047]="MaximumNumberOfPinnedThreadsInForumHasBeenReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfTagsInForumHasBeenReached"]=30048]="MaximumNumberOfTagsInForumHasBeenReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["BitrateIsTooHighForChannelOfThisType"]=30052]="BitrateIsTooHighForChannelOfThisType";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfPremiumEmojisReached"]=30056]="MaximumNumberOfPremiumEmojisReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfWebhooksPerGuildReached"]=30058]="MaximumNumberOfWebhooksPerGuildReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumNumberOfChannelPermissionOverwritesReached"]=30060]="MaximumNumberOfChannelPermissionOverwritesReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TheChannelsForThisGuildAreTooLarge"]=30061]="TheChannelsForThisGuildAreTooLarge";RESTJSONErrorCodes2[RESTJSONErrorCodes2["Unauthorized"]=40001]="Unauthorized";RESTJSONErrorCodes2[RESTJSONErrorCodes2["VerifyYourAccount"]=40002]="VerifyYourAccount";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OpeningDirectMessagesTooFast"]=40003]="OpeningDirectMessagesTooFast";RESTJSONErrorCodes2[RESTJSONErrorCodes2["SendMessagesHasBeenTemporarilyDisabled"]=40004]="SendMessagesHasBeenTemporarilyDisabled";RESTJSONErrorCodes2[RESTJSONErrorCodes2["RequestEntityTooLarge"]=40005]="RequestEntityTooLarge";RESTJSONErrorCodes2[RESTJSONErrorCodes2["FeatureTemporarilyDisabledServerSide"]=40006]="FeatureTemporarilyDisabledServerSide";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UserBannedFromThisGuild"]=40007]="UserBannedFromThisGuild";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ConnectionHasBeenRevoked"]=40012]="ConnectionHasBeenRevoked";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OnlyConsumableSKUsCanBeConsumed"]=40018]="OnlyConsumableSKUsCanBeConsumed";RESTJSONErrorCodes2[RESTJSONErrorCodes2["YouCanOnlyDeleteSandboxEntitlements"]=40019]="YouCanOnlyDeleteSandboxEntitlements";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TargetUserIsNotConnectedToVoice"]=40032]="TargetUserIsNotConnectedToVoice";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ThisMessageWasAlreadyCrossposted"]=40033]="ThisMessageWasAlreadyCrossposted";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ApplicationCommandWithThatNameAlreadyExists"]=40041]="ApplicationCommandWithThatNameAlreadyExists";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ApplicationInteractionFailedToSend"]=40043]="ApplicationInteractionFailedToSend";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotSendAMessageInAForumChannel"]=40058]="CannotSendAMessageInAForumChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InteractionHasAlreadyBeenAcknowledged"]=40060]="InteractionHasAlreadyBeenAcknowledged";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TagNamesMustBeUnique"]=40061]="TagNamesMustBeUnique";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ServiceResourceIsBeingRateLimited"]=40062]="ServiceResourceIsBeingRateLimited";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ThereAreNoTagsAvailableThatCanBeSetByNonModerators"]=40066]="ThereAreNoTagsAvailableThatCanBeSetByNonModerators";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TagRequiredToCreateAForumPostInThisChannel"]=40067]="TagRequiredToCreateAForumPostInThisChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["AnEntitlementHasAlreadyBeenGrantedForThisResource"]=40074]="AnEntitlementHasAlreadyBeenGrantedForThisResource";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ThisInteractionHasHitTheMaximumNumberOfFollowUpMessages"]=40094]="ThisInteractionHasHitTheMaximumNumberOfFollowUpMessages";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CloudflareIsBlockingYourRequest"]=40333]="CloudflareIsBlockingYourRequest";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MissingAccess"]=50001]="MissingAccess";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidAccountType"]=50002]="InvalidAccountType";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotExecuteActionOnDMChannel"]=50003]="CannotExecuteActionOnDMChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["GuildWidgetDisabled"]=50004]="GuildWidgetDisabled";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotEditMessageAuthoredByAnotherUser"]=50005]="CannotEditMessageAuthoredByAnotherUser";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotSendAnEmptyMessage"]=50006]="CannotSendAnEmptyMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotSendMessagesToThisUser"]=50007]="CannotSendMessagesToThisUser";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotSendMessagesInNonTextChannel"]=50008]="CannotSendMessagesInNonTextChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ChannelVerificationLevelTooHighForYouToGainAccess"]=50009]="ChannelVerificationLevelTooHighForYouToGainAccess";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OAuth2ApplicationDoesNotHaveBot"]=50010]="OAuth2ApplicationDoesNotHaveBot";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OAuth2ApplicationLimitReached"]=50011]="OAuth2ApplicationLimitReached";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidOAuth2State"]=50012]="InvalidOAuth2State";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MissingPermissions"]=50013]="MissingPermissions";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidToken"]=50014]="InvalidToken";RESTJSONErrorCodes2[RESTJSONErrorCodes2["NoteWasTooLong"]=50015]="NoteWasTooLong";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ProvidedTooFewOrTooManyMessagesToDelete"]=50016]="ProvidedTooFewOrTooManyMessagesToDelete";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidMFALevel"]=50017]="InvalidMFALevel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MessageCanOnlyBePinnedInTheChannelItWasSentIn"]=50019]="MessageCanOnlyBePinnedInTheChannelItWasSentIn";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InviteCodeInvalidOrTaken"]=50020]="InviteCodeInvalidOrTaken";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotExecuteActionOnSystemMessage"]=50021]="CannotExecuteActionOnSystemMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotExecuteActionOnThisChannelType"]=50024]="CannotExecuteActionOnThisChannelType";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidOAuth2AccessToken"]=50025]="InvalidOAuth2AccessToken";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MissingRequiredOAuth2Scope"]=50026]="MissingRequiredOAuth2Scope";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidWebhookToken"]=50027]="InvalidWebhookToken";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidRole"]=50028]="InvalidRole";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidRecipients"]=50033]="InvalidRecipients";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OneOfTheMessagesProvidedWasTooOldForBulkDelete"]=50034]="OneOfTheMessagesProvidedWasTooOldForBulkDelete";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidFormBodyOrContentType"]=50035]="InvalidFormBodyOrContentType";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InviteAcceptedToGuildWithoutTheBotBeingIn"]=50036]="InviteAcceptedToGuildWithoutTheBotBeingIn";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidActivityAction"]=50039]="InvalidActivityAction";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidAPIVersion"]=50041]="InvalidAPIVersion";RESTJSONErrorCodes2[RESTJSONErrorCodes2["FileUploadedExceedsMaximumSize"]=50045]="FileUploadedExceedsMaximumSize";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidFileUploaded"]=50046]="InvalidFileUploaded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotSelfRedeemThisGift"]=50054]="CannotSelfRedeemThisGift";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidGuild"]=50055]="InvalidGuild";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidSKU"]=50057]="InvalidSKU";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidRequestOrigin"]=50067]="InvalidRequestOrigin";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidMessageType"]=50068]="InvalidMessageType";RESTJSONErrorCodes2[RESTJSONErrorCodes2["PaymentSourceRequiredToRedeemGift"]=50070]="PaymentSourceRequiredToRedeemGift";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotModifyASystemWebhook"]=50073]="CannotModifyASystemWebhook";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotDeleteChannelRequiredForCommunityGuilds"]=50074]="CannotDeleteChannelRequiredForCommunityGuilds";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotEditStickersWithinMessage"]=50080]="CannotEditStickersWithinMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidStickerSent"]=50081]="InvalidStickerSent";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidActionOnArchivedThread"]=50083]="InvalidActionOnArchivedThread";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidThreadNotificationSettings"]=50084]="InvalidThreadNotificationSettings";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ParameterEarlierThanCreation"]=50085]="ParameterEarlierThanCreation";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CommunityServerChannelsMustBeTextChannels"]=50086]="CommunityServerChannelsMustBeTextChannels";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TheEntityTypeOfTheEventIsDifferentFromTheEntityYouAreTryingToStartTheEventFor"]=50091]="TheEntityTypeOfTheEventIsDifferentFromTheEntityYouAreTryingToStartTheEventFor";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ServerNotAvailableInYourLocation"]=50095]="ServerNotAvailableInYourLocation";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ServerNeedsMonetizationEnabledToPerformThisAction"]=50097]="ServerNeedsMonetizationEnabledToPerformThisAction";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ServerNeedsMoreBoostsToPerformThisAction"]=50101]="ServerNeedsMoreBoostsToPerformThisAction";RESTJSONErrorCodes2[RESTJSONErrorCodes2["RequestBodyContainsInvalidJSON"]=50109]="RequestBodyContainsInvalidJSON";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OwnerCannotBePendingMember"]=50131]="OwnerCannotBePendingMember";RESTJSONErrorCodes2[RESTJSONErrorCodes2["OwnershipCannotBeMovedToABotUser"]=50132]="OwnershipCannotBeMovedToABotUser";RESTJSONErrorCodes2[RESTJSONErrorCodes2["FailedToResizeAssetBelowTheMinimumSize"]=50138]="FailedToResizeAssetBelowTheMinimumSize";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotMixSubscriptionAndNonSubscriptionRolesForAnEmoji"]=50144]="CannotMixSubscriptionAndNonSubscriptionRolesForAnEmoji";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotConvertBetweenPremiumEmojiAndNormalEmoji"]=50145]="CannotConvertBetweenPremiumEmojiAndNormalEmoji";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UploadedFileNotFound"]=50146]="UploadedFileNotFound";RESTJSONErrorCodes2[RESTJSONErrorCodes2["VoiceMessagesDoNotSupportAdditionalContent"]=50159]="VoiceMessagesDoNotSupportAdditionalContent";RESTJSONErrorCodes2[RESTJSONErrorCodes2["VoiceMessagesMustHaveASingleAudioAttachment"]=50160]="VoiceMessagesMustHaveASingleAudioAttachment";RESTJSONErrorCodes2[RESTJSONErrorCodes2["VoiceMessagesMustHaveSupportingMetadata"]=50161]="VoiceMessagesMustHaveSupportingMetadata";RESTJSONErrorCodes2[RESTJSONErrorCodes2["VoiceMessagesCannotBeEdited"]=50162]="VoiceMessagesCannotBeEdited";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotDeleteGuildSubscriptionIntegration"]=50163]="CannotDeleteGuildSubscriptionIntegration";RESTJSONErrorCodes2[RESTJSONErrorCodes2["YouCannotSendVoiceMessagesInThisChannel"]=50173]="YouCannotSendVoiceMessagesInThisChannel";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TheUserAccountMustFirstBeVerified"]=50178]="TheUserAccountMustFirstBeVerified";RESTJSONErrorCodes2[RESTJSONErrorCodes2["YouDoNotHavePermissionToSendThisSticker"]=50600]="YouDoNotHavePermissionToSendThisSticker";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TwoFactorAuthenticationIsRequired"]=60003]="TwoFactorAuthenticationIsRequired";RESTJSONErrorCodes2[RESTJSONErrorCodes2["NoUsersWithDiscordTagExist"]=80004]="NoUsersWithDiscordTagExist";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ReactionWasBlocked"]=90001]="ReactionWasBlocked";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UserCannotUseBurstReactions"]=90002]="UserCannotUseBurstReactions";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ApplicationNotYetAvailable"]=110001]="ApplicationNotYetAvailable";RESTJSONErrorCodes2[RESTJSONErrorCodes2["APIResourceOverloaded"]=13e4]="APIResourceOverloaded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TheStageIsAlreadyOpen"]=150006]="TheStageIsAlreadyOpen";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotReplyWithoutPermissionToReadMessageHistory"]=160002]="CannotReplyWithoutPermissionToReadMessageHistory";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ThreadAlreadyCreatedForMessage"]=160004]="ThreadAlreadyCreatedForMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["ThreadLocked"]=160005]="ThreadLocked";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumActiveThreads"]=160006]="MaximumActiveThreads";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MaximumActiveAnnouncementThreads"]=160007]="MaximumActiveAnnouncementThreads";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidJSONForUploadedLottieFile"]=170001]="InvalidJSONForUploadedLottieFile";RESTJSONErrorCodes2[RESTJSONErrorCodes2["UploadedLottiesCannotContainRasterizedImages"]=170002]="UploadedLottiesCannotContainRasterizedImages";RESTJSONErrorCodes2[RESTJSONErrorCodes2["StickerMaximumFramerateExceeded"]=170003]="StickerMaximumFramerateExceeded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["StickerFrameCountExceedsMaximumOf1000Frames"]=170004]="StickerFrameCountExceedsMaximumOf1000Frames";RESTJSONErrorCodes2[RESTJSONErrorCodes2["LottieAnimationMaximumDimensionsExceeded"]=170005]="LottieAnimationMaximumDimensionsExceeded";RESTJSONErrorCodes2[RESTJSONErrorCodes2["StickerFramerateIsTooSmallOrTooLarge"]=170006]="StickerFramerateIsTooSmallOrTooLarge";RESTJSONErrorCodes2[RESTJSONErrorCodes2["StickerAnimationDurationExceedsMaximumOf5Seconds"]=170007]="StickerAnimationDurationExceedsMaximumOf5Seconds";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotUpdateAFinishedEvent"]=18e4]="CannotUpdateAFinishedEvent";RESTJSONErrorCodes2[RESTJSONErrorCodes2["FailedToCreateStageNeededForStageEvent"]=180002]="FailedToCreateStageNeededForStageEvent";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MessageWasBlockedByAutomaticModeration"]=2e5]="MessageWasBlockedByAutomaticModeration";RESTJSONErrorCodes2[RESTJSONErrorCodes2["TitleWasBlockedByAutomaticModeration"]=200001]="TitleWasBlockedByAutomaticModeration";RESTJSONErrorCodes2[RESTJSONErrorCodes2["WebhooksPostedToForumChannelsMustHaveAThreadNameOrThreadId"]=220001]="WebhooksPostedToForumChannelsMustHaveAThreadNameOrThreadId";RESTJSONErrorCodes2[RESTJSONErrorCodes2["WebhooksPostedToForumChannelsCannotHaveBothAThreadNameAndThreadId"]=220002]="WebhooksPostedToForumChannelsCannotHaveBothAThreadNameAndThreadId";RESTJSONErrorCodes2[RESTJSONErrorCodes2["WebhooksCanOnlyCreateThreadsInForumChannels"]=220003]="WebhooksCanOnlyCreateThreadsInForumChannels";RESTJSONErrorCodes2[RESTJSONErrorCodes2["WebhookServicesCannotBeUsedInForumChannels"]=220004]="WebhookServicesCannotBeUsedInForumChannels";RESTJSONErrorCodes2[RESTJSONErrorCodes2["MessageBlockedByHarmfulLinksFilter"]=24e4]="MessageBlockedByHarmfulLinksFilter";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotEnableOnboardingRequirementsAreNotMet"]=35e4]="CannotEnableOnboardingRequirementsAreNotMet";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotUpdateOnboardingWhileBelowRequirements"]=350001]="CannotUpdateOnboardingWhileBelowRequirements";RESTJSONErrorCodes2[RESTJSONErrorCodes2["FailedToBanUsers"]=5e5]="FailedToBanUsers";RESTJSONErrorCodes2[RESTJSONErrorCodes2["PollVotingBlocked"]=52e4]="PollVotingBlocked";RESTJSONErrorCodes2[RESTJSONErrorCodes2["PollExpired"]=520001]="PollExpired";RESTJSONErrorCodes2[RESTJSONErrorCodes2["InvalidChannelTypeForPollCreation"]=520002]="InvalidChannelTypeForPollCreation";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotEditAPollMessage"]=520003]="CannotEditAPollMessage";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotUseAnEmojiIncludedWithThePoll"]=520004]="CannotUseAnEmojiIncludedWithThePoll";RESTJSONErrorCodes2[RESTJSONErrorCodes2["CannotExpireANonPollMessage"]=520006]="CannotExpireANonPollMessage"})(RESTJSONErrorCodes||(exports2.RESTJSONErrorCodes=RESTJSONErrorCodes={}));var Locale;(function(Locale2){Locale2["Indonesian"]="id";Locale2["EnglishUS"]="en-US";Locale2["EnglishGB"]="en-GB";Locale2["Bulgarian"]="bg";Locale2["ChineseCN"]="zh-CN";Locale2["ChineseTW"]="zh-TW";Locale2["Croatian"]="hr";Locale2["Czech"]="cs";Locale2["Danish"]="da";Locale2["Dutch"]="nl";Locale2["Finnish"]="fi";Locale2["French"]="fr";Locale2["German"]="de";Locale2["Greek"]="el";Locale2["Hindi"]="hi";Locale2["Hungarian"]="hu";Locale2["Italian"]="it";Locale2["Japanese"]="ja";Locale2["Korean"]="ko";Locale2["Lithuanian"]="lt";Locale2["Norwegian"]="no";Locale2["Polish"]="pl";Locale2["PortugueseBR"]="pt-BR";Locale2["Romanian"]="ro";Locale2["Russian"]="ru";Locale2["SpanishES"]="es-ES";Locale2["SpanishLATAM"]="es-419";Locale2["Swedish"]="sv-SE";Locale2["Thai"]="th";Locale2["Turkish"]="tr";Locale2["Ukrainian"]="uk";Locale2["Vietnamese"]="vi"})(Locale||(exports2.Locale=Locale={}))}});var require_application2=__commonJS({"node_modules/discord-api-types/rest/v10/application.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_auditLog2=__commonJS({"node_modules/discord-api-types/rest/v10/auditLog.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_autoModeration2=__commonJS({"node_modules/discord-api-types/rest/v10/autoModeration.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_channel3=__commonJS({"node_modules/discord-api-types/rest/v10/channel.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.ReactionType=void 0;var ReactionType;(function(ReactionType2){ReactionType2[ReactionType2["Normal"]=0]="Normal";ReactionType2[ReactionType2["Super"]=1]="Super"})(ReactionType||(exports2.ReactionType=ReactionType={}))}});var require_emoji2=__commonJS({"node_modules/discord-api-types/rest/v10/emoji.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_gateway2=__commonJS({"node_modules/discord-api-types/rest/v10/gateway.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_guild2=__commonJS({"node_modules/discord-api-types/rest/v10/guild.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_guildScheduledEvent2=__commonJS({"node_modules/discord-api-types/rest/v10/guildScheduledEvent.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_interactions2=__commonJS({"node_modules/discord-api-types/rest/v10/interactions.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_invite2=__commonJS({"node_modules/discord-api-types/rest/v10/invite.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_oauth22=__commonJS({"node_modules/discord-api-types/rest/v10/oauth2.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_poll2=__commonJS({"node_modules/discord-api-types/rest/v10/poll.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_stageInstance2=__commonJS({"node_modules/discord-api-types/rest/v10/stageInstance.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_sticker2=__commonJS({"node_modules/discord-api-types/rest/v10/sticker.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_template2=__commonJS({"node_modules/discord-api-types/rest/v10/template.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_user3=__commonJS({"node_modules/discord-api-types/rest/v10/user.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_voice2=__commonJS({"node_modules/discord-api-types/rest/v10/voice.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_webhook2=__commonJS({"node_modules/discord-api-types/rest/v10/webhook.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true})}});var require_monetization2=__commonJS({"node_modules/discord-api-types/rest/v10/monetization.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.EntitlementOwnerType=void 0;var EntitlementOwnerType;(function(EntitlementOwnerType2){EntitlementOwnerType2[EntitlementOwnerType2["Guild"]=1]="Guild";EntitlementOwnerType2[EntitlementOwnerType2["User"]=2]="User"})(EntitlementOwnerType||(exports2.EntitlementOwnerType=EntitlementOwnerType={}))}});var require_v103=__commonJS({"node_modules/discord-api-types/rest/v10/index.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});exports2.OAuth2Routes=exports2.RouteBases=exports2.CDNRoutes=exports2.ImageFormat=exports2.StickerPackApplicationId=exports2.Routes=exports2.APIVersion=void 0;__exportStar2(require_common3(),exports2);__exportStar2(require_application2(),exports2);__exportStar2(require_auditLog2(),exports2);__exportStar2(require_autoModeration2(),exports2);__exportStar2(require_channel3(),exports2);__exportStar2(require_emoji2(),exports2);__exportStar2(require_gateway2(),exports2);__exportStar2(require_guild2(),exports2);__exportStar2(require_guildScheduledEvent2(),exports2);__exportStar2(require_interactions2(),exports2);__exportStar2(require_invite2(),exports2);__exportStar2(require_oauth22(),exports2);__exportStar2(require_poll2(),exports2);__exportStar2(require_stageInstance2(),exports2);__exportStar2(require_sticker2(),exports2);__exportStar2(require_template2(),exports2);__exportStar2(require_user3(),exports2);__exportStar2(require_voice2(),exports2);__exportStar2(require_webhook2(),exports2);__exportStar2(require_monetization2(),exports2);exports2.APIVersion="10";exports2.Routes={applicationRoleConnectionMetadata(applicationId){return`/applications/${applicationId}/role-connections/metadata`},guildAutoModerationRules(guildId){return`/guilds/${guildId}/auto-moderation/rules`},guildAutoModerationRule(guildId,ruleId){return`/guilds/${guildId}/auto-moderation/rules/${ruleId}`},guildAuditLog(guildId){return`/guilds/${guildId}/audit-logs`},channel(channelId){return`/channels/${channelId}`},channelMessages(channelId){return`/channels/${channelId}/messages`},channelMessage(channelId,messageId){return`/channels/${channelId}/messages/${messageId}`},channelMessageCrosspost(channelId,messageId){return`/channels/${channelId}/messages/${messageId}/crosspost`},channelMessageOwnReaction(channelId,messageId,emoji){return`/channels/${channelId}/messages/${messageId}/reactions/${emoji}/@me`},channelMessageUserReaction(channelId,messageId,emoji,userId){return`/channels/${channelId}/messages/${messageId}/reactions/${emoji}/${userId}`},channelMessageReaction(channelId,messageId,emoji){return`/channels/${channelId}/messages/${messageId}/reactions/${emoji}`},channelMessageAllReactions(channelId,messageId){return`/channels/${channelId}/messages/${messageId}/reactions`},channelBulkDelete(channelId){return`/channels/${channelId}/messages/bulk-delete`},channelPermission(channelId,overwriteId){return`/channels/${channelId}/permissions/${overwriteId}`},channelInvites(channelId){return`/channels/${channelId}/invites`},channelFollowers(channelId){return`/channels/${channelId}/followers`},channelTyping(channelId){return`/channels/${channelId}/typing`},channelPins(channelId){return`/channels/${channelId}/pins`},channelPin(channelId,messageId){return`/channels/${channelId}/pins/${messageId}`},channelRecipient(channelId,userId){return`/channels/${channelId}/recipients/${userId}`},guildEmojis(guildId){return`/guilds/${guildId}/emojis`},guildEmoji(guildId,emojiId){return`/guilds/${guildId}/emojis/${emojiId}`},guilds(){return"/guilds"},guild(guildId){return`/guilds/${guildId}`},guildPreview(guildId){return`/guilds/${guildId}/preview`},guildChannels(guildId){return`/guilds/${guildId}/channels`},guildMember(guildId,userId="@me"){return`/guilds/${guildId}/members/${userId}`},guildMembers(guildId){return`/guilds/${guildId}/members`},guildMembersSearch(guildId){return`/guilds/${guildId}/members/search`},guildCurrentMemberNickname(guildId){return`/guilds/${guildId}/members/@me/nick`},guildMemberRole(guildId,memberId,roleId){return`/guilds/${guildId}/members/${memberId}/roles/${roleId}`},guildMFA(guildId){return`/guilds/${guildId}/mfa`},guildBans(guildId){return`/guilds/${guildId}/bans`},guildBan(guildId,userId){return`/guilds/${guildId}/bans/${userId}`},guildRoles(guildId){return`/guilds/${guildId}/roles`},guildRole(guildId,roleId){return`/guilds/${guildId}/roles/${roleId}`},guildPrune(guildId){return`/guilds/${guildId}/prune`},guildVoiceRegions(guildId){return`/guilds/${guildId}/regions`},guildInvites(guildId){return`/guilds/${guildId}/invites`},guildIntegrations(guildId){return`/guilds/${guildId}/integrations`},guildIntegration(guildId,integrationId){return`/guilds/${guildId}/integrations/${integrationId}`},guildWidgetSettings(guildId){return`/guilds/${guildId}/widget`},guildWidgetJSON(guildId){return`/guilds/${guildId}/widget.json`},guildVanityUrl(guildId){return`/guilds/${guildId}/vanity-url`},guildWidgetImage(guildId){return`/guilds/${guildId}/widget.png`},invite(code){return`/invites/${code}`},template(code){return`/guilds/templates/${code}`},guildTemplates(guildId){return`/guilds/${guildId}/templates`},guildTemplate(guildId,code){return`/guilds/${guildId}/templates/${code}`},pollAnswerVoters(channelId,messageId,answerId){return`/channels/${channelId}/polls/${messageId}/answers/${answerId}`},expirePoll(channelId,messageId){return`/channels/${channelId}/polls/${messageId}/expire`},threads(parentId,messageId){const parts=["","channels",parentId];if(messageId)parts.push("messages",messageId);parts.push("threads");return parts.join("/")},guildActiveThreads(guildId){return`/guilds/${guildId}/threads/active`},channelThreads(channelId,archivedStatus){return`/channels/${channelId}/threads/archived/${archivedStatus}`},channelJoinedArchivedThreads(channelId){return`/channels/${channelId}/users/@me/threads/archived/private`},threadMembers(threadId,userId){const parts=["","channels",threadId,"thread-members"];if(userId)parts.push(userId);return parts.join("/")},user(userId="@me"){return`/users/${userId}`},userApplicationRoleConnection(applicationId){return`/users/@me/applications/${applicationId}/role-connection`},userGuilds(){return`/users/@me/guilds`},userGuildMember(guildId){return`/users/@me/guilds/${guildId}/member`},userGuild(guildId){return`/users/@me/guilds/${guildId}`},userChannels(){return`/users/@me/channels`},userConnections(){return`/users/@me/connections`},voiceRegions(){return`/voice/regions`},channelWebhooks(channelId){return`/channels/${channelId}/webhooks`},guildWebhooks(guildId){return`/guilds/${guildId}/webhooks`},webhook(webhookId,webhookToken){const parts=["","webhooks",webhookId];if(webhookToken)parts.push(webhookToken);return parts.join("/")},webhookMessage(webhookId,webhookToken,messageId="@original"){return`/webhooks/${webhookId}/${webhookToken}/messages/${messageId}`},webhookPlatform(webhookId,webhookToken,platform){return`/webhooks/${webhookId}/${webhookToken}/${platform}`},gateway(){return`/gateway`},gatewayBot(){return`/gateway/bot`},oauth2CurrentApplication(){return`/oauth2/applications/@me`},oauth2CurrentAuthorization(){return`/oauth2/@me`},oauth2Authorization(){return`/oauth2/authorize`},oauth2TokenExchange(){return`/oauth2/token`},oauth2TokenRevocation(){return`/oauth2/token/revoke`},applicationCommands(applicationId){return`/applications/${applicationId}/commands`},applicationCommand(applicationId,commandId){return`/applications/${applicationId}/commands/${commandId}`},applicationGuildCommands(applicationId,guildId){return`/applications/${applicationId}/guilds/${guildId}/commands`},applicationGuildCommand(applicationId,guildId,commandId){return`/applications/${applicationId}/guilds/${guildId}/commands/${commandId}`},interactionCallback(interactionId,interactionToken){return`/interactions/${interactionId}/${interactionToken}/callback`},guildMemberVerification(guildId){return`/guilds/${guildId}/member-verification`},guildVoiceState(guildId,userId="@me"){return`/guilds/${guildId}/voice-states/${userId}`},guildApplicationCommandsPermissions(applicationId,guildId){return`/applications/${applicationId}/guilds/${guildId}/commands/permissions`},applicationCommandPermissions(applicationId,guildId,commandId){return`/applications/${applicationId}/guilds/${guildId}/commands/${commandId}/permissions`},guildWelcomeScreen(guildId){return`/guilds/${guildId}/welcome-screen`},stageInstances(){return`/stage-instances`},stageInstance(channelId){return`/stage-instances/${channelId}`},sticker(stickerId){return`/stickers/${stickerId}`},stickerPacks(){return"/sticker-packs"},stickerPack(packId){return`/sticker-packs/${packId}`},nitroStickerPacks(){return"/sticker-packs"},guildStickers(guildId){return`/guilds/${guildId}/stickers`},guildSticker(guildId,stickerId){return`/guilds/${guildId}/stickers/${stickerId}`},guildScheduledEvents(guildId){return`/guilds/${guildId}/scheduled-events`},guildScheduledEvent(guildId,guildScheduledEventId){return`/guilds/${guildId}/scheduled-events/${guildScheduledEventId}`},guildScheduledEventUsers(guildId,guildScheduledEventId){return`/guilds/${guildId}/scheduled-events/${guildScheduledEventId}/users`},guildOnboarding(guildId){return`/guilds/${guildId}/onboarding`},currentApplication(){return"/applications/@me"},entitlements(applicationId){return`/applications/${applicationId}/entitlements`},entitlement(applicationId,entitlementId){return`/applications/${applicationId}/entitlements/${entitlementId}`},skus(applicationId){return`/applications/${applicationId}/skus`},guildBulkBan(guildId){return`/guilds/${guildId}/bulk-ban`},consumeEntitlement(applicationId,entitlementId){return`/applications/${applicationId}/entitlements/${entitlementId}/consume`},applicationEmojis(applicationId){return`/applications/${applicationId}/emojis`},applicationEmoji(applicationId,emojiId){return`/applications/${applicationId}/emojis/${emojiId}`},skuSubscriptions(skuId){return`/skus/${skuId}/subscriptions`},skuSubscription(skuId,subscriptionId){return`/skus/${skuId}/subscriptions/${subscriptionId}`}};exports2.StickerPackApplicationId="710982414301790216";var ImageFormat;(function(ImageFormat2){ImageFormat2["JPEG"]="jpeg";ImageFormat2["PNG"]="png";ImageFormat2["WebP"]="webp";ImageFormat2["GIF"]="gif";ImageFormat2["Lottie"]="json"})(ImageFormat||(exports2.ImageFormat=ImageFormat={}));exports2.CDNRoutes={emoji(emojiId,format2){return`/emojis/${emojiId}.${format2}`},guildIcon(guildId,guildIcon,format2){return`/icons/${guildId}/${guildIcon}.${format2}`},guildSplash(guildId,guildSplash,format2){return`/splashes/${guildId}/${guildSplash}.${format2}`},guildDiscoverySplash(guildId,guildDiscoverySplash,format2){return`/discovery-splashes/${guildId}/${guildDiscoverySplash}.${format2}`},guildBanner(guildId,guildBanner,format2){return`/banners/${guildId}/${guildBanner}.${format2}`},userBanner(userId,userBanner,format2){return`/banners/${userId}/${userBanner}.${format2}`},defaultUserAvatar(index){return`/embed/avatars/${index}.png`},userAvatar(userId,userAvatar,format2){return`/avatars/${userId}/${userAvatar}.${format2}`},guildMemberAvatar(guildId,userId,memberAvatar,format2){return`/guilds/${guildId}/users/${userId}/avatars/${memberAvatar}.${format2}`},userAvatarDecoration(userId,userAvatarDecoration){return`/avatar-decorations/${userId}/${userAvatarDecoration}.png`},avatarDecoration(avatarDecorationDataAsset){return`/avatar-decoration-presets/${avatarDecorationDataAsset}.png`},applicationIcon(applicationId,applicationIcon,format2){return`/app-icons/${applicationId}/${applicationIcon}.${format2}`},applicationCover(applicationId,applicationCoverImage,format2){return`/app-icons/${applicationId}/${applicationCoverImage}.${format2}`},applicationAsset(applicationId,applicationAssetId,format2){return`/app-assets/${applicationId}/${applicationAssetId}.${format2}`},achievementIcon(applicationId,achievementId,achievementIconHash,format2){return`/app-assets/${applicationId}/achievements/${achievementId}/icons/${achievementIconHash}.${format2}`},stickerPackBanner(stickerPackBannerAssetId,format2){return`/app-assets/${exports2.StickerPackApplicationId}/store/${stickerPackBannerAssetId}.${format2}`},storePageAsset(applicationId,assetId,format2=ImageFormat.PNG){return`/app-assets/${applicationId}/store/${assetId}.${format2}`},teamIcon(teamId,teamIcon,format2){return`/team-icons/${teamId}/${teamIcon}.${format2}`},sticker(stickerId,format2){return`/stickers/${stickerId}.${format2}`},roleIcon(roleId,roleIcon,format2){return`/role-icons/${roleId}/${roleIcon}.${format2}`},guildScheduledEventCover(guildScheduledEventId,guildScheduledEventCoverImage,format2){return`/guild-events/${guildScheduledEventId}/${guildScheduledEventCoverImage}.${format2}`},guildMemberBanner(guildId,userId,guildMemberBanner,format2){return`/guilds/${guildId}/users/${userId}/banners/${guildMemberBanner}.${format2}`}};exports2.RouteBases={api:`https://discord.com/api/v${exports2.APIVersion}`,cdn:"https://cdn.discordapp.com",media:"https://media.discordapp.net",invite:"https://discord.gg",template:"https://discord.new",gift:"https://discord.gift",scheduledEvent:"https://discord.com/events"};Object.freeze(exports2.RouteBases);exports2.OAuth2Routes={authorizationURL:`${exports2.RouteBases.api}${exports2.Routes.oauth2Authorization()}`,tokenURL:`${exports2.RouteBases.api}${exports2.Routes.oauth2TokenExchange()}`,tokenRevocationURL:`${exports2.RouteBases.api}${exports2.Routes.oauth2TokenRevocation()}`};Object.freeze(exports2.OAuth2Routes)}});var require_common4=__commonJS({"node_modules/discord-api-types/rpc/common.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.RPCCloseEventCodes=exports2.RPCErrorCodes=void 0;var RPCErrorCodes;(function(RPCErrorCodes2){RPCErrorCodes2[RPCErrorCodes2["UnknownError"]=1e3]="UnknownError";RPCErrorCodes2[RPCErrorCodes2["InvalidPayload"]=4e3]="InvalidPayload";RPCErrorCodes2[RPCErrorCodes2["InvalidCommand"]=4002]="InvalidCommand";RPCErrorCodes2[RPCErrorCodes2["InvalidGuild"]=4003]="InvalidGuild";RPCErrorCodes2[RPCErrorCodes2["InvalidEvent"]=4004]="InvalidEvent";RPCErrorCodes2[RPCErrorCodes2["InvalidChannel"]=4005]="InvalidChannel";RPCErrorCodes2[RPCErrorCodes2["InvalidPermissions"]=4006]="InvalidPermissions";RPCErrorCodes2[RPCErrorCodes2["InvalidClientId"]=4007]="InvalidClientId";RPCErrorCodes2[RPCErrorCodes2["InvalidOrigin"]=4008]="InvalidOrigin";RPCErrorCodes2[RPCErrorCodes2["InvalidToken"]=4009]="InvalidToken";RPCErrorCodes2[RPCErrorCodes2["InvalidUser"]=4010]="InvalidUser";RPCErrorCodes2[RPCErrorCodes2["OAuth2Error"]=5e3]="OAuth2Error";RPCErrorCodes2[RPCErrorCodes2["SelectChannelTimedOut"]=5001]="SelectChannelTimedOut";RPCErrorCodes2[RPCErrorCodes2["GetGuildTimedOut"]=5002]="GetGuildTimedOut";RPCErrorCodes2[RPCErrorCodes2["SelectVoiceForceRequired"]=5003]="SelectVoiceForceRequired";RPCErrorCodes2[RPCErrorCodes2["CaptureShortcutAlreadyListening"]=5004]="CaptureShortcutAlreadyListening"})(RPCErrorCodes||(exports2.RPCErrorCodes=RPCErrorCodes={}));var RPCCloseEventCodes;(function(RPCCloseEventCodes2){RPCCloseEventCodes2[RPCCloseEventCodes2["InvalidClientId"]=4e3]="InvalidClientId";RPCCloseEventCodes2[RPCCloseEventCodes2["InvalidOrigin"]=4001]="InvalidOrigin";RPCCloseEventCodes2[RPCCloseEventCodes2["RateLimited"]=4002]="RateLimited";RPCCloseEventCodes2[RPCCloseEventCodes2["TokenRevoked"]=4003]="TokenRevoked";RPCCloseEventCodes2[RPCCloseEventCodes2["InvalidVersion"]=4004]="InvalidVersion";RPCCloseEventCodes2[RPCCloseEventCodes2["InvalidEncoding"]=4005]="InvalidEncoding"})(RPCCloseEventCodes||(exports2.RPCCloseEventCodes=RPCCloseEventCodes={}))}});var require_v104=__commonJS({"node_modules/discord-api-types/rpc/v10.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});__exportStar2(require_common4(),exports2)}});var require_v105=__commonJS({"node_modules/discord-api-types/utils/v10.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.isDMInteraction=isDMInteraction;exports2.isGuildInteraction=isGuildInteraction;exports2.isApplicationCommandDMInteraction=isApplicationCommandDMInteraction;exports2.isApplicationCommandGuildInteraction=isApplicationCommandGuildInteraction;exports2.isMessageComponentDMInteraction=isMessageComponentDMInteraction;exports2.isMessageComponentGuildInteraction=isMessageComponentGuildInteraction;exports2.isLinkButton=isLinkButton;exports2.isInteractionButton=isInteractionButton;exports2.isMessageComponentInteraction=isMessageComponentInteraction;exports2.isMessageComponentButtonInteraction=isMessageComponentButtonInteraction;exports2.isMessageComponentSelectMenuInteraction=isMessageComponentSelectMenuInteraction;exports2.isChatInputApplicationCommandInteraction=isChatInputApplicationCommandInteraction;exports2.isContextMenuApplicationCommandInteraction=isContextMenuApplicationCommandInteraction;var index_1=require_v102();function isDMInteraction(interaction){return Reflect.has(interaction,"user")}function isGuildInteraction(interaction){return Reflect.has(interaction,"guild_id")}function isApplicationCommandDMInteraction(interaction){return isDMInteraction(interaction)}function isApplicationCommandGuildInteraction(interaction){return isGuildInteraction(interaction)}function isMessageComponentDMInteraction(interaction){return isDMInteraction(interaction)}function isMessageComponentGuildInteraction(interaction){return isGuildInteraction(interaction)}function isLinkButton(component){return component.style===index_1.ButtonStyle.Link}function isInteractionButton(component){return component.style!==index_1.ButtonStyle.Link}function isMessageComponentInteraction(interaction){return interaction.type===index_1.InteractionType.MessageComponent}function isMessageComponentButtonInteraction(interaction){return interaction.data.component_type===index_1.ComponentType.Button}function isMessageComponentSelectMenuInteraction(interaction){return[index_1.ComponentType.StringSelect,index_1.ComponentType.UserSelect,index_1.ComponentType.RoleSelect,index_1.ComponentType.MentionableSelect,index_1.ComponentType.ChannelSelect].includes(interaction.data.component_type)}function isChatInputApplicationCommandInteraction(interaction){return interaction.data.type===index_1.ApplicationCommandType.ChatInput}function isContextMenuApplicationCommandInteraction(interaction){return interaction.data.type===index_1.ApplicationCommandType.Message||interaction.data.type===index_1.ApplicationCommandType.User}}});var require_v106=__commonJS({"node_modules/discord-api-types/v10.js"(exports2){"use strict";var __createBinding2=exports2&&exports2.__createBinding||(Object.create?function(o,m,k,k2){if(k2===void 0)k2=k;var desc=Object.getOwnPropertyDescriptor(m,k);if(!desc||("get"in desc?!m.__esModule:desc.writable||desc.configurable)){desc={enumerable:true,get:function(){return m[k]}}}Object.defineProperty(o,k2,desc)}:function(o,m,k,k2){if(k2===void 0)k2=k;o[k2]=m[k]});var __exportStar2=exports2&&exports2.__exportStar||function(m,exports3){for(var p in m)if(p!=="default"&&!Object.prototype.hasOwnProperty.call(exports3,p))__createBinding2(exports3,m,p)};Object.defineProperty(exports2,"__esModule",{value:true});exports2.Utils=void 0;__exportStar2(require_v10(),exports2);__exportStar2(require_globals(),exports2);__exportStar2(require_v102(),exports2);__exportStar2(require_v103(),exports2);__exportStar2(require_v104(),exports2);exports2.Utils=require_v105()}});var require_symbols=__commonJS({"node_modules/undici/lib/core/symbols.js"(exports2,module2){module2.exports={kClose:Symbol("close"),kDestroy:Symbol("destroy"),kDispatch:Symbol("dispatch"),kUrl:Symbol("url"),kWriting:Symbol("writing"),kResuming:Symbol("resuming"),kQueue:Symbol("queue"),kConnect:Symbol("connect"),kConnecting:Symbol("connecting"),kHeadersList:Symbol("headers list"),kKeepAliveDefaultTimeout:Symbol("default keep alive timeout"),kKeepAliveMaxTimeout:Symbol("max keep alive timeout"),kKeepAliveTimeoutThreshold:Symbol("keep alive timeout threshold"),kKeepAliveTimeoutValue:Symbol("keep alive timeout"),kKeepAlive:Symbol("keep alive"),kHeadersTimeout:Symbol("headers timeout"),kBodyTimeout:Symbol("body timeout"),kServerName:Symbol("server name"),kLocalAddress:Symbol("local address"),kHost:Symbol("host"),kNoRef:Symbol("no ref"),kBodyUsed:Symbol("used"),kRunning:Symbol("running"),kBlocking:Symbol("blocking"),kPending:Symbol("pending"),kSize:Symbol("size"),kBusy:Symbol("busy"),kQueued:Symbol("queued"),kFree:Symbol("free"),kConnected:Symbol("connected"),kClosed:Symbol("closed"),kNeedDrain:Symbol("need drain"),kReset:Symbol("reset"),kDestroyed:Symbol.for("nodejs.stream.destroyed"),kMaxHeadersSize:Symbol("max headers size"),kRunningIdx:Symbol("running index"),kPendingIdx:Symbol("pending index"),kError:Symbol("error"),kClients:Symbol("clients"),kClient:Symbol("client"),kParser:Symbol("parser"),kOnDestroyed:Symbol("destroy callbacks"),kPipelining:Symbol("pipelining"),kSocket:Symbol("socket"),kHostHeader:Symbol("host header"),kConnector:Symbol("connector"),kStrictContentLength:Symbol("strict content length"),kMaxRedirections:Symbol("maxRedirections"),kMaxRequests:Symbol("maxRequestsPerClient"),kProxy:Symbol("proxy agent options"),kCounter:Symbol("socket request counter"),kInterceptors:Symbol("dispatch interceptors"),kMaxResponseSize:Symbol("max response size"),kHTTP2Session:Symbol("http2Session"),kHTTP2SessionState:Symbol("http2Session state"),kHTTP2BuildRequest:Symbol("http2 build request"),kHTTP1BuildRequest:Symbol("http1 build request"),kHTTP2CopyHeaders:Symbol("http2 copy headers"),kHTTPConnVersion:Symbol("http connection version"),kRetryHandlerDefaultRetry:Symbol("retry agent default retry"),kConstruct:Symbol("constructable")}}});var require_errors4=__commonJS({"node_modules/undici/lib/core/errors.js"(exports2,module2){"use strict";var UndiciError=class extends Error{constructor(message3){super(message3);this.name="UndiciError";this.code="UND_ERR"}};var ConnectTimeoutError=class _ConnectTimeoutError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_ConnectTimeoutError);this.name="ConnectTimeoutError";this.message=message3||"Connect Timeout Error";this.code="UND_ERR_CONNECT_TIMEOUT"}};var HeadersTimeoutError=class _HeadersTimeoutError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_HeadersTimeoutError);this.name="HeadersTimeoutError";this.message=message3||"Headers Timeout Error";this.code="UND_ERR_HEADERS_TIMEOUT"}};var HeadersOverflowError=class _HeadersOverflowError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_HeadersOverflowError);this.name="HeadersOverflowError";this.message=message3||"Headers Overflow Error";this.code="UND_ERR_HEADERS_OVERFLOW"}};var BodyTimeoutError=class _BodyTimeoutError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_BodyTimeoutError);this.name="BodyTimeoutError";this.message=message3||"Body Timeout Error";this.code="UND_ERR_BODY_TIMEOUT"}};var ResponseStatusCodeError=class _ResponseStatusCodeError extends UndiciError{constructor(message3,statusCode,headers,body){super(message3);Error.captureStackTrace(this,_ResponseStatusCodeError);this.name="ResponseStatusCodeError";this.message=message3||"Response Status Code Error";this.code="UND_ERR_RESPONSE_STATUS_CODE";this.body=body;this.status=statusCode;this.statusCode=statusCode;this.headers=headers}};var InvalidArgumentError=class _InvalidArgumentError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_InvalidArgumentError);this.name="InvalidArgumentError";this.message=message3||"Invalid Argument Error";this.code="UND_ERR_INVALID_ARG"}};var InvalidReturnValueError=class _InvalidReturnValueError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_InvalidReturnValueError);this.name="InvalidReturnValueError";this.message=message3||"Invalid Return Value Error";this.code="UND_ERR_INVALID_RETURN_VALUE"}};var RequestAbortedError=class _RequestAbortedError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_RequestAbortedError);this.name="AbortError";this.message=message3||"Request aborted";this.code="UND_ERR_ABORTED"}};var InformationalError=class _InformationalError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_InformationalError);this.name="InformationalError";this.message=message3||"Request information";this.code="UND_ERR_INFO"}};var RequestContentLengthMismatchError=class _RequestContentLengthMismatchError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_RequestContentLengthMismatchError);this.name="RequestContentLengthMismatchError";this.message=message3||"Request body length does not match content-length header";this.code="UND_ERR_REQ_CONTENT_LENGTH_MISMATCH"}};var ResponseContentLengthMismatchError=class _ResponseContentLengthMismatchError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_ResponseContentLengthMismatchError);this.name="ResponseContentLengthMismatchError";this.message=message3||"Response body length does not match content-length header";this.code="UND_ERR_RES_CONTENT_LENGTH_MISMATCH"}};var ClientDestroyedError=class _ClientDestroyedError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_ClientDestroyedError);this.name="ClientDestroyedError";this.message=message3||"The client is destroyed";this.code="UND_ERR_DESTROYED"}};var ClientClosedError=class _ClientClosedError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_ClientClosedError);this.name="ClientClosedError";this.message=message3||"The client is closed";this.code="UND_ERR_CLOSED"}};var SocketError=class _SocketError extends UndiciError{constructor(message3,socket){super(message3);Error.captureStackTrace(this,_SocketError);this.name="SocketError";this.message=message3||"Socket error";this.code="UND_ERR_SOCKET";this.socket=socket}};var NotSupportedError=class _NotSupportedError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_NotSupportedError);this.name="NotSupportedError";this.message=message3||"Not supported error";this.code="UND_ERR_NOT_SUPPORTED"}};var BalancedPoolMissingUpstreamError=class extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,NotSupportedError);this.name="MissingUpstreamError";this.message=message3||"No upstream has been added to the BalancedPool";this.code="UND_ERR_BPL_MISSING_UPSTREAM"}};var HTTPParserError=class _HTTPParserError extends Error{constructor(message3,code,data){super(message3);Error.captureStackTrace(this,_HTTPParserError);this.name="HTTPParserError";this.code=code?`HPE_${code}`:void 0;this.data=data?data.toString():void 0}};var ResponseExceededMaxSizeError=class _ResponseExceededMaxSizeError extends UndiciError{constructor(message3){super(message3);Error.captureStackTrace(this,_ResponseExceededMaxSizeError);this.name="ResponseExceededMaxSizeError";this.message=message3||"Response content exceeded max size";this.code="UND_ERR_RES_EXCEEDED_MAX_SIZE"}};var RequestRetryError=class _RequestRetryError extends UndiciError{constructor(message3,code,{headers,data}){super(message3);Error.captureStackTrace(this,_RequestRetryError);this.name="RequestRetryError";this.message=message3||"Request retry error";this.code="UND_ERR_REQ_RETRY";this.statusCode=code;this.data=data;this.headers=headers}};module2.exports={HTTPParserError,UndiciError,HeadersTimeoutError,HeadersOverflowError,BodyTimeoutError,RequestContentLengthMismatchError,ConnectTimeoutError,ResponseStatusCodeError,InvalidArgumentError,InvalidReturnValueError,RequestAbortedError,ClientDestroyedError,ClientClosedError,InformationalError,SocketError,NotSupportedError,ResponseContentLengthMismatchError,BalancedPoolMissingUpstreamError,ResponseExceededMaxSizeError,RequestRetryError}}});var require_constants=__commonJS({"node_modules/undici/lib/core/constants.js"(exports2,module2){"use strict";var headerNameLowerCasedRecord={};var wellknownHeaderNames=["Accept","Accept-Encoding","Accept-Language","Accept-Ranges","Access-Control-Allow-Credentials","Access-Control-Allow-Headers","Access-Control-Allow-Methods","Access-Control-Allow-Origin","Access-Control-Expose-Headers","Access-Control-Max-Age","Access-Control-Request-Headers","Access-Control-Request-Method","Age","Allow","Alt-Svc","Alt-Used","Authorization","Cache-Control","Clear-Site-Data","Connection","Content-Disposition","Content-Encoding","Content-Language","Content-Length","Content-Location","Content-Range","Content-Security-Policy","Content-Security-Policy-Report-Only","Content-Type","Cookie","Cross-Origin-Embedder-Policy","Cross-Origin-Opener-Policy","Cross-Origin-Resource-Policy","Date","Device-Memory","Downlink","ECT","ETag","Expect","Expect-CT","Expires","Forwarded","From","Host","If-Match","If-Modified-Since","If-None-Match","If-Range","If-Unmodified-Since","Keep-Alive","Last-Modified","Link","Location","Max-Forwards","Origin","Permissions-Policy","Pragma","Proxy-Authenticate","Proxy-Authorization","RTT","Range","Referer","Referrer-Policy","Refresh","Retry-After","Sec-WebSocket-Accept","Sec-WebSocket-Extensions","Sec-WebSocket-Key","Sec-WebSocket-Protocol","Sec-WebSocket-Version","Server","Server-Timing","Service-Worker-Allowed","Service-Worker-Navigation-Preload","Set-Cookie","SourceMap","Strict-Transport-Security","Supports-Loading-Mode","TE","Timing-Allow-Origin","Trailer","Transfer-Encoding","Upgrade","Upgrade-Insecure-Requests","User-Agent","Vary","Via","WWW-Authenticate","X-Content-Type-Options","X-DNS-Prefetch-Control","X-Frame-Options","X-Permitted-Cross-Domain-Policies","X-Powered-By","X-Requested-With","X-XSS-Protection"];for(let i=0;i<wellknownHeaderNames.length;++i){const key=wellknownHeaderNames[i];const lowerCasedKey=key.toLowerCase();headerNameLowerCasedRecord[key]=headerNameLowerCasedRecord[lowerCasedKey]=lowerCasedKey}Object.setPrototypeOf(headerNameLowerCasedRecord,null);module2.exports={wellknownHeaderNames,headerNameLowerCasedRecord}}});var require_util2=__commonJS({"node_modules/undici/lib/core/util.js"(exports2,module2){"use strict";var assert2=require("assert");var{kDestroyed,kBodyUsed}=require_symbols();var{IncomingMessage}=require("http");var stream3=require("stream");var net2=require("net");var{InvalidArgumentError}=require_errors4();var{Blob:Blob2}=require("buffer");var nodeUtil2=require("util");var{stringify}=require("querystring");var{headerNameLowerCasedRecord}=require_constants();var[nodeMajor,nodeMinor]=process.versions.node.split(".").map(v=>Number(v));function nop(){}function isStream(obj){return obj&&typeof obj==="object"&&typeof obj.pipe==="function"&&typeof obj.on==="function"}function isBlobLike(object){return Blob2&&object instanceof Blob2||object&&typeof object==="object"&&(typeof object.stream==="function"||typeof object.arrayBuffer==="function")&&/^(Blob|File)$/.test(object[Symbol.toStringTag])}function buildURL(url,queryParams){if(url.includes("?")||url.includes("#")){throw new Error('Query params cannot be passed when url already contains "?" or "#".')}const stringified=stringify(queryParams);if(stringified){url+="?"+stringified}return url}function parseURL(url){if(typeof url==="string"){url=new URL(url);if(!/^https?:/.test(url.origin||url.protocol)){throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.")}return url}if(!url||typeof url!=="object"){throw new InvalidArgumentError("Invalid URL: The URL argument must be a non-null object.")}if(!/^https?:/.test(url.origin||url.protocol)){throw new InvalidArgumentError("Invalid URL protocol: the URL must start with `http:` or `https:`.")}if(!(url instanceof URL)){if(url.port!=null&&url.port!==""&&!Number.isFinite(parseInt(url.port))){throw new InvalidArgumentError("Invalid URL: port must be a valid integer or a string representation of an integer.")}if(url.path!=null&&typeof url.path!=="string"){throw new InvalidArgumentError("Invalid URL path: the path must be a string or null/undefined.")}if(url.pathname!=null&&typeof url.pathname!=="string"){throw new InvalidArgumentError("Invalid URL pathname: the pathname must be a string or null/undefined.")}if(url.hostname!=null&&typeof url.hostname!=="string"){throw new InvalidArgumentError("Invalid URL hostname: the hostname must be a string or null/undefined.")}if(url.origin!=null&&typeof url.origin!=="string"){throw new InvalidArgumentError("Invalid URL origin: the origin must be a string or null/undefined.")}const port=url.port!=null?url.port:url.protocol==="https:"?443:80;let origin=url.origin!=null?url.origin:`${url.protocol}//${url.hostname}:${port}`;let path23=url.path!=null?url.path:`${url.pathname||""}${url.search||""}`;if(origin.endsWith("/")){origin=origin.substring(0,origin.length-1)}if(path23&&!path23.startsWith("/")){path23=`/${path23}`}url=new URL(origin+path23)}return url}function parseOrigin(url){url=parseURL(url);if(url.pathname!=="/"||url.search||url.hash){throw new InvalidArgumentError("invalid url")}return url}function getHostname(host){if(host[0]==="["){const idx2=host.indexOf("]");assert2(idx2!==-1);return host.substring(1,idx2)}const idx=host.indexOf(":");if(idx===-1)return host;return host.substring(0,idx)}function getServerName(host){if(!host){return null}assert2.strictEqual(typeof host,"string");const servername=getHostname(host);if(net2.isIP(servername)){return""}return servername}function deepClone(obj){return JSON.parse(JSON.stringify(obj))}function isAsyncIterable2(obj){return!!(obj!=null&&typeof obj[Symbol.asyncIterator]==="function")}function isIterable2(obj){return!!(obj!=null&&(typeof obj[Symbol.iterator]==="function"||typeof obj[Symbol.asyncIterator]==="function"))}function bodyLength(body){if(body==null){return 0}else if(isStream(body)){const state=body._readableState;return state&&state.objectMode===false&&state.ended===true&&Number.isFinite(state.length)?state.length:null}else if(isBlobLike(body)){return body.size!=null?body.size:null}else if(isBuffer2(body)){return body.byteLength}return null}function isDestroyed(stream4){return!stream4||!!(stream4.destroyed||stream4[kDestroyed])}function isReadableAborted(stream4){const state=stream4&&stream4._readableState;return isDestroyed(stream4)&&state&&!state.endEmitted}function destroy(stream4,err){if(stream4==null||!isStream(stream4)||isDestroyed(stream4)){return}if(typeof stream4.destroy==="function"){if(Object.getPrototypeOf(stream4).constructor===IncomingMessage){stream4.socket=null}stream4.destroy(err)}else if(err){process.nextTick((stream5,err2)=>{stream5.emit("error",err2)},stream4,err)}if(stream4.destroyed!==true){stream4[kDestroyed]=true}}var KEEPALIVE_TIMEOUT_EXPR=/timeout=(\d+)/;function parseKeepAliveTimeout(val){const m=val.toString().match(KEEPALIVE_TIMEOUT_EXPR);return m?parseInt(m[1],10)*1e3:null}function headerNameToString(value){return headerNameLowerCasedRecord[value]||value.toLowerCase()}function parseHeaders(headers,obj={}){if(!Array.isArray(headers))return headers;for(let i=0;i<headers.length;i+=2){const key=headers[i].toString().toLowerCase();let val=obj[key];if(!val){if(Array.isArray(headers[i+1])){obj[key]=headers[i+1].map(x=>x.toString("utf8"))}else{obj[key]=headers[i+1].toString("utf8")}}else{if(!Array.isArray(val)){val=[val];obj[key]=val}val.push(headers[i+1].toString("utf8"))}}if("content-length"in obj&&"content-disposition"in obj){obj["content-disposition"]=Buffer.from(obj["content-disposition"]).toString("latin1")}return obj}function parseRawHeaders(headers){const ret=[];let hasContentLength=false;let contentDispositionIdx=-1;for(let n=0;n<headers.length;n+=2){const key=headers[n+0].toString();const val=headers[n+1].toString("utf8");if(key.length===14&&(key==="content-length"||key.toLowerCase()==="content-length")){ret.push(key,val);hasContentLength=true}else if(key.length===19&&(key==="content-disposition"||key.toLowerCase()==="content-disposition")){contentDispositionIdx=ret.push(key,val)-1}else{ret.push(key,val)}}if(hasContentLength&&contentDispositionIdx!==-1){ret[contentDispositionIdx]=Buffer.from(ret[contentDispositionIdx]).toString("latin1")}return ret}function isBuffer2(buffer){return buffer instanceof Uint8Array||Buffer.isBuffer(buffer)}function validateHandler(handler,method2,upgrade){if(!handler||typeof handler!=="object"){throw new InvalidArgumentError("handler must be an object")}if(typeof handler.onConnect!=="function"){throw new InvalidArgumentError("invalid onConnect method")}if(typeof handler.onError!=="function"){throw new InvalidArgumentError("invalid onError method")}if(typeof handler.onBodySent!=="function"&&handler.onBodySent!==void 0){throw new InvalidArgumentError("invalid onBodySent method")}if(upgrade||method2==="CONNECT"){if(typeof handler.onUpgrade!=="function"){throw new InvalidArgumentError("invalid onUpgrade method")}}else{if(typeof handler.onHeaders!=="function"){throw new InvalidArgumentError("invalid onHeaders method")}if(typeof handler.onData!=="function"){throw new InvalidArgumentError("invalid onData method")}if(typeof handler.onComplete!=="function"){throw new InvalidArgumentError("invalid onComplete method")}}}function isDisturbed(body){return!!(body&&(stream3.isDisturbed?stream3.isDisturbed(body)||body[kBodyUsed]:body[kBodyUsed]||body.readableDidRead||body._readableState&&body._readableState.dataEmitted||isReadableAborted(body)))}function isErrored(body){return!!(body&&(stream3.isErrored?stream3.isErrored(body):/state: 'errored'/.test(nodeUtil2.inspect(body))))}function isReadable(body){return!!(body&&(stream3.isReadable?stream3.isReadable(body):/state: 'readable'/.test(nodeUtil2.inspect(body))))}function getSocketInfo(socket){return{localAddress:socket.localAddress,localPort:socket.localPort,remoteAddress:socket.remoteAddress,remotePort:socket.remotePort,remoteFamily:socket.remoteFamily,timeout:socket.timeout,bytesWritten:socket.bytesWritten,bytesRead:socket.bytesRead}}async function*convertIterableToBuffer(iterable){for await(const chunk2 of iterable){yield Buffer.isBuffer(chunk2)?chunk2:Buffer.from(chunk2)}}var ReadableStream2;function ReadableStreamFrom(iterable){if(!ReadableStream2){ReadableStream2=require("stream/web").ReadableStream}if(ReadableStream2.from){return ReadableStream2.from(convertIterableToBuffer(iterable))}let iterator;return new ReadableStream2({async start(){iterator=iterable[Symbol.asyncIterator]()},async pull(controller){const{done,value}=await iterator.next();if(done){queueMicrotask(()=>{controller.close()})}else{const buf=Buffer.isBuffer(value)?value:Buffer.from(value);controller.enqueue(new Uint8Array(buf))}return controller.desiredSize>0},async cancel(reason){await iterator.return()}},0)}function isFormDataLike(object){return object&&typeof object==="object"&&typeof object.append==="function"&&typeof object.delete==="function"&&typeof object.get==="function"&&typeof object.getAll==="function"&&typeof object.has==="function"&&typeof object.set==="function"&&object[Symbol.toStringTag]==="FormData"}function throwIfAborted(signal){if(!signal){return}if(typeof signal.throwIfAborted==="function"){signal.throwIfAborted()}else{if(signal.aborted){const err=new Error("The operation was aborted");err.name="AbortError";throw err}}}function addAbortListener(signal,listener){if("addEventListener"in signal){signal.addEventListener("abort",listener,{once:true});return()=>signal.removeEventListener("abort",listener)}signal.addListener("abort",listener);return()=>signal.removeListener("abort",listener)}var hasToWellFormed=!!String.prototype.toWellFormed;function toUSVString(val){if(hasToWellFormed){return`${val}`.toWellFormed()}else if(nodeUtil2.toUSVString){return nodeUtil2.toUSVString(val)}return`${val}`}function parseRangeHeader(range2){if(range2==null||range2==="")return{start:0,end:null,size:null};const m=range2?range2.match(/^bytes (\d+)-(\d+)\/(\d+)?$/):null;return m?{start:parseInt(m[1]),end:m[2]?parseInt(m[2]):null,size:m[3]?parseInt(m[3]):null}:null}var kEnumerableProperty=Object.create(null);kEnumerableProperty.enumerable=true;module2.exports={kEnumerableProperty,nop,isDisturbed,isErrored,isReadable,toUSVString,isReadableAborted,isBlobLike,parseOrigin,parseURL,getServerName,isStream,isIterable:isIterable2,isAsyncIterable:isAsyncIterable2,isDestroyed,headerNameToString,parseRawHeaders,parseHeaders,parseKeepAliveTimeout,destroy,bodyLength,deepClone,ReadableStreamFrom,isBuffer:isBuffer2,validateHandler,getSocketInfo,isFormDataLike,buildURL,throwIfAborted,addAbortListener,parseRangeHeader,nodeMajor,nodeMinor,nodeHasAutoSelectFamily:nodeMajor>18||nodeMajor===18&&nodeMinor>=13,safeHTTPMethods:["GET","HEAD","OPTIONS","TRACE"]}}});var require_timers=__commonJS({"node_modules/undici/lib/timers.js"(exports2,module2){"use strict";var fastNow=Date.now();var fastNowTimeout;var fastTimers=[];function onTimeout(){fastNow=Date.now();let len=fastTimers.length;let idx=0;while(idx<len){const timer2=fastTimers[idx];if(timer2.state===0){timer2.state=fastNow+timer2.delay}else if(timer2.state>0&&fastNow>=timer2.state){timer2.state=-1;timer2.callback(timer2.opaque)}if(timer2.state===-1){timer2.state=-2;if(idx!==len-1){fastTimers[idx]=fastTimers.pop()}else{fastTimers.pop()}len-=1}else{idx+=1}}if(fastTimers.length>0){refreshTimeout()}}function refreshTimeout(){if(fastNowTimeout&&fastNowTimeout.refresh){fastNowTimeout.refresh()}else{clearTimeout(fastNowTimeout);fastNowTimeout=setTimeout(onTimeout,1e3);if(fastNowTimeout.unref){fastNowTimeout.unref()}}}var Timeout=class{constructor(callback,delay4,opaque){this.callback=callback;this.delay=delay4;this.opaque=opaque;this.state=-2;this.refresh()}refresh(){if(this.state===-2){fastTimers.push(this);if(!fastNowTimeout||fastTimers.length===1){refreshTimeout()}}this.state=0}clear(){this.state=-1}};module2.exports={setTimeout(callback,delay4,opaque){return delay4<1e3?setTimeout(callback,delay4,opaque):new Timeout(callback,delay4,opaque)},clearTimeout(timeout){if(timeout instanceof Timeout){timeout.clear()}else{clearTimeout(timeout)}}}}});var require_sbmh=__commonJS({"node_modules/@fastify/busboy/deps/streamsearch/sbmh.js"(exports2,module2){"use strict";var EventEmitter3=require("node:events").EventEmitter;var inherits=require("node:util").inherits;function SBMH(needle){if(typeof needle==="string"){needle=Buffer.from(needle)}if(!Buffer.isBuffer(needle)){throw new TypeError("The needle has to be a String or a Buffer.")}const needleLength=needle.length;if(needleLength===0){throw new Error("The needle cannot be an empty String/Buffer.")}if(needleLength>256){throw new Error("The needle cannot have a length bigger than 256.")}this.maxMatches=Infinity;this.matches=0;this._occ=new Array(256).fill(needleLength);this._lookbehind_size=0;this._needle=needle;this._bufpos=0;this._lookbehind=Buffer.alloc(needleLength);for(var i=0;i<needleLength-1;++i){this._occ[needle[i]]=needleLength-1-i}}inherits(SBMH,EventEmitter3);SBMH.prototype.reset=function(){this._lookbehind_size=0;this.matches=0;this._bufpos=0};SBMH.prototype.push=function(chunk2,pos){if(!Buffer.isBuffer(chunk2)){chunk2=Buffer.from(chunk2,"binary")}const chlen=chunk2.length;this._bufpos=pos||0;let r;while(r!==chlen&&this.matches<this.maxMatches){r=this._sbmh_feed(chunk2)}return r};SBMH.prototype._sbmh_feed=function(data){const len=data.length;const needle=this._needle;const needleLength=needle.length;const lastNeedleChar=needle[needleLength-1];let pos=-this._lookbehind_size;let ch;if(pos<0){while(pos<0&&pos<=len-needleLength){ch=this._sbmh_lookup_char(data,pos+needleLength-1);if(ch===lastNeedleChar&&this._sbmh_memcmp(data,pos,needleLength-1)){this._lookbehind_size=0;++this.matches;this.emit("info",true);return this._bufpos=pos+needleLength}pos+=this._occ[ch]}if(pos<0){while(pos<0&&!this._sbmh_memcmp(data,pos,len-pos)){++pos}}if(pos>=0){this.emit("info",false,this._lookbehind,0,this._lookbehind_size);this._lookbehind_size=0}else{const bytesToCutOff=this._lookbehind_size+pos;if(bytesToCutOff>0){this.emit("info",false,this._lookbehind,0,bytesToCutOff)}this._lookbehind.copy(this._lookbehind,0,bytesToCutOff,this._lookbehind_size-bytesToCutOff);this._lookbehind_size-=bytesToCutOff;data.copy(this._lookbehind,this._lookbehind_size);this._lookbehind_size+=len;this._bufpos=len;return len}}pos+=(pos>=0)*this._bufpos;if(data.indexOf(needle,pos)!==-1){pos=data.indexOf(needle,pos);++this.matches;if(pos>0){this.emit("info",true,data,this._bufpos,pos)}else{this.emit("info",true)}return this._bufpos=pos+needleLength}else{pos=len-needleLength}while(pos<len&&(data[pos]!==needle[0]||Buffer.compare(data.subarray(pos,pos+len-pos),needle.subarray(0,len-pos))!==0)){++pos}if(pos<len){data.copy(this._lookbehind,0,pos,pos+(len-pos));this._lookbehind_size=len-pos}if(pos>0){this.emit("info",false,data,this._bufpos,pos<len?pos:len)}this._bufpos=len;return len};SBMH.prototype._sbmh_lookup_char=function(data,pos){return pos<0?this._lookbehind[this._lookbehind_size+pos]:data[pos]};SBMH.prototype._sbmh_memcmp=function(data,pos,len){for(var i=0;i<len;++i){if(this._sbmh_lookup_char(data,pos+i)!==this._needle[i]){return false}}return true};module2.exports=SBMH}});var require_PartStream=__commonJS({"node_modules/@fastify/busboy/deps/dicer/lib/PartStream.js"(exports2,module2){"use strict";var inherits=require("node:util").inherits;var ReadableStream2=require("node:stream").Readable;function PartStream(opts){ReadableStream2.call(this,opts)}inherits(PartStream,ReadableStream2);PartStream.prototype._read=function(n){};module2.exports=PartStream}});var require_getLimit=__commonJS({"node_modules/@fastify/busboy/lib/utils/getLimit.js"(exports2,module2){"use strict";module2.exports=function getLimit(limits,name,defaultLimit){if(!limits||limits[name]===void 0||limits[name]===null){return defaultLimit}if(typeof limits[name]!=="number"||isNaN(limits[name])){throw new TypeError("Limit "+name+" is not a valid number")}return limits[name]}}});var require_HeaderParser=__commonJS({"node_modules/@fastify/busboy/deps/dicer/lib/HeaderParser.js"(exports2,module2){"use strict";var EventEmitter3=require("node:events").EventEmitter;var inherits=require("node:util").inherits;var getLimit=require_getLimit();var StreamSearch=require_sbmh();var B_DCRLF=Buffer.from("\r\n\r\n");var RE_CRLF=/\r\n/g;var RE_HDR=/^([^:]+):[ \t]?([\x00-\xFF]+)?$/;function HeaderParser(cfg){EventEmitter3.call(this);cfg=cfg||{};const self2=this;this.nread=0;this.maxed=false;this.npairs=0;this.maxHeaderPairs=getLimit(cfg,"maxHeaderPairs",2e3);this.maxHeaderSize=getLimit(cfg,"maxHeaderSize",80*1024);this.buffer="";this.header={};this.finished=false;this.ss=new StreamSearch(B_DCRLF);this.ss.on("info",function(isMatch2,data,start,end){if(data&&!self2.maxed){if(self2.nread+end-start>=self2.maxHeaderSize){end=self2.maxHeaderSize-self2.nread+start;self2.nread=self2.maxHeaderSize;self2.maxed=true}else{self2.nread+=end-start}self2.buffer+=data.toString("binary",start,end)}if(isMatch2){self2._finish()}})}inherits(HeaderParser,EventEmitter3);HeaderParser.prototype.push=function(data){const r=this.ss.push(data);if(this.finished){return r}};HeaderParser.prototype.reset=function(){this.finished=false;this.buffer="";this.header={};this.ss.reset()};HeaderParser.prototype._finish=function(){if(this.buffer){this._parseHeader()}this.ss.matches=this.ss.maxMatches;const header2=this.header;this.header={};this.buffer="";this.finished=true;this.nread=this.npairs=0;this.maxed=false;this.emit("header",header2)};HeaderParser.prototype._parseHeader=function(){if(this.npairs===this.maxHeaderPairs){return}const lines=this.buffer.split(RE_CRLF);const len=lines.length;let m,h;for(var i=0;i<len;++i){if(lines[i].length===0){continue}if(lines[i][0]==="	"||lines[i][0]===" "){if(h){this.header[h][this.header[h].length-1]+=lines[i];continue}}const posColon=lines[i].indexOf(":");if(posColon===-1||posColon===0){return}m=RE_HDR.exec(lines[i]);h=m[1].toLowerCase();this.header[h]=this.header[h]||[];this.header[h].push(m[2]||"");if(++this.npairs===this.maxHeaderPairs){break}}};module2.exports=HeaderParser}});var require_Dicer=__commonJS({"node_modules/@fastify/busboy/deps/dicer/lib/Dicer.js"(exports2,module2){"use strict";var WritableStream=require("node:stream").Writable;var inherits=require("node:util").inherits;var StreamSearch=require_sbmh();var PartStream=require_PartStream();var HeaderParser=require_HeaderParser();var DASH=45;var B_ONEDASH=Buffer.from("-");var B_CRLF=Buffer.from("\r\n");var EMPTY_FN=function(){};function Dicer(cfg){if(!(this instanceof Dicer)){return new Dicer(cfg)}WritableStream.call(this,cfg);if(!cfg||!cfg.headerFirst&&typeof cfg.boundary!=="string"){throw new TypeError("Boundary required")}if(typeof cfg.boundary==="string"){this.setBoundary(cfg.boundary)}else{this._bparser=void 0}this._headerFirst=cfg.headerFirst;this._dashes=0;this._parts=0;this._finished=false;this._realFinish=false;this._isPreamble=true;this._justMatched=false;this._firstWrite=true;this._inHeader=true;this._part=void 0;this._cb=void 0;this._ignoreData=false;this._partOpts={highWaterMark:cfg.partHwm};this._pause=false;const self2=this;this._hparser=new HeaderParser(cfg);this._hparser.on("header",function(header2){self2._inHeader=false;self2._part.emit("header",header2)})}inherits(Dicer,WritableStream);Dicer.prototype.emit=function(ev){if(ev==="finish"&&!this._realFinish){if(!this._finished){const self2=this;process.nextTick(function(){self2.emit("error",new Error("Unexpected end of multipart data"));if(self2._part&&!self2._ignoreData){const type2=self2._isPreamble?"Preamble":"Part";self2._part.emit("error",new Error(type2+" terminated early due to unexpected end of multipart data"));self2._part.push(null);process.nextTick(function(){self2._realFinish=true;self2.emit("finish");self2._realFinish=false});return}self2._realFinish=true;self2.emit("finish");self2._realFinish=false})}}else{WritableStream.prototype.emit.apply(this,arguments)}};Dicer.prototype._write=function(data,encoding,cb){if(!this._hparser&&!this._bparser){return cb()}if(this._headerFirst&&this._isPreamble){if(!this._part){this._part=new PartStream(this._partOpts);if(this.listenerCount("preamble")!==0){this.emit("preamble",this._part)}else{this._ignore()}}const r=this._hparser.push(data);if(!this._inHeader&&r!==void 0&&r<data.length){data=data.slice(r)}else{return cb()}}if(this._firstWrite){this._bparser.push(B_CRLF);this._firstWrite=false}this._bparser.push(data);if(this._pause){this._cb=cb}else{cb()}};Dicer.prototype.reset=function(){this._part=void 0;this._bparser=void 0;this._hparser=void 0};Dicer.prototype.setBoundary=function(boundary){const self2=this;this._bparser=new StreamSearch("\r\n--"+boundary);this._bparser.on("info",function(isMatch2,data,start,end){self2._oninfo(isMatch2,data,start,end)})};Dicer.prototype._ignore=function(){if(this._part&&!this._ignoreData){this._ignoreData=true;this._part.on("error",EMPTY_FN);this._part.resume()}};Dicer.prototype._oninfo=function(isMatch2,data,start,end){let buf;const self2=this;let i=0;let r;let shouldWriteMore=true;if(!this._part&&this._justMatched&&data){while(this._dashes<2&&start+i<end){if(data[start+i]===DASH){++i;++this._dashes}else{if(this._dashes){buf=B_ONEDASH}this._dashes=0;break}}if(this._dashes===2){if(start+i<end&&this.listenerCount("trailer")!==0){this.emit("trailer",data.slice(start+i,end))}this.reset();this._finished=true;if(self2._parts===0){self2._realFinish=true;self2.emit("finish");self2._realFinish=false}}if(this._dashes){return}}if(this._justMatched){this._justMatched=false}if(!this._part){this._part=new PartStream(this._partOpts);this._part._read=function(n){self2._unpause()};if(this._isPreamble&&this.listenerCount("preamble")!==0){this.emit("preamble",this._part)}else if(this._isPreamble!==true&&this.listenerCount("part")!==0){this.emit("part",this._part)}else{this._ignore()}if(!this._isPreamble){this._inHeader=true}}if(data&&start<end&&!this._ignoreData){if(this._isPreamble||!this._inHeader){if(buf){shouldWriteMore=this._part.push(buf)}shouldWriteMore=this._part.push(data.slice(start,end));if(!shouldWriteMore){this._pause=true}}else if(!this._isPreamble&&this._inHeader){if(buf){this._hparser.push(buf)}r=this._hparser.push(data.slice(start,end));if(!this._inHeader&&r!==void 0&&r<end){this._oninfo(false,data,start+r,end)}}}if(isMatch2){this._hparser.reset();if(this._isPreamble){this._isPreamble=false}else{if(start!==end){++this._parts;this._part.on("end",function(){if(--self2._parts===0){if(self2._finished){self2._realFinish=true;self2.emit("finish");self2._realFinish=false}else{self2._unpause()}}})}}this._part.push(null);this._part=void 0;this._ignoreData=false;this._justMatched=true;this._dashes=0}};Dicer.prototype._unpause=function(){if(!this._pause){return}this._pause=false;if(this._cb){const cb=this._cb;this._cb=void 0;cb()}};module2.exports=Dicer}});var require_decodeText=__commonJS({"node_modules/@fastify/busboy/lib/utils/decodeText.js"(exports2,module2){"use strict";var utf8Decoder=new TextDecoder("utf-8");var textDecoders=new Map([["utf-8",utf8Decoder],["utf8",utf8Decoder]]);function getDecoder(charset){let lc;while(true){switch(charset){case"utf-8":case"utf8":return decoders.utf8;case"latin1":case"ascii":case"us-ascii":case"iso-8859-1":case"iso8859-1":case"iso88591":case"iso_8859-1":case"windows-1252":case"iso_8859-1:1987":case"cp1252":case"x-cp1252":return decoders.latin1;case"utf16le":case"utf-16le":case"ucs2":case"ucs-2":return decoders.utf16le;case"base64":return decoders.base64;default:if(lc===void 0){lc=true;charset=charset.toLowerCase();continue}return decoders.other.bind(charset)}}}var decoders={utf8:(data,sourceEncoding)=>{if(data.length===0){return""}if(typeof data==="string"){data=Buffer.from(data,sourceEncoding)}return data.utf8Slice(0,data.length)},latin1:(data,sourceEncoding)=>{if(data.length===0){return""}if(typeof data==="string"){return data}return data.latin1Slice(0,data.length)},utf16le:(data,sourceEncoding)=>{if(data.length===0){return""}if(typeof data==="string"){data=Buffer.from(data,sourceEncoding)}return data.ucs2Slice(0,data.length)},base64:(data,sourceEncoding)=>{if(data.length===0){return""}if(typeof data==="string"){data=Buffer.from(data,sourceEncoding)}return data.base64Slice(0,data.length)},other:(data,sourceEncoding)=>{if(data.length===0){return""}if(typeof data==="string"){data=Buffer.from(data,sourceEncoding)}if(textDecoders.has(exports2.toString())){try{return textDecoders.get(exports2).decode(data)}catch{}}return typeof data==="string"?data:data.toString()}};function decodeText(text,sourceEncoding,destEncoding){if(text){return getDecoder(destEncoding)(text,sourceEncoding)}return text}module2.exports=decodeText}});var require_parseParams=__commonJS({"node_modules/@fastify/busboy/lib/utils/parseParams.js"(exports2,module2){"use strict";var decodeText=require_decodeText();var RE_ENCODED=/%[a-fA-F0-9][a-fA-F0-9]/g;var EncodedLookup={"%00":"\0","%01":"","%02":"","%03":"","%04":"","%05":"","%06":"","%07":"\x07","%08":"\b","%09":"	","%0a":"\n","%0A":"\n","%0b":"\v","%0B":"\v","%0c":"\f","%0C":"\f","%0d":"\r","%0D":"\r","%0e":"","%0E":"","%0f":"","%0F":"","%10":"","%11":"","%12":"","%13":"","%14":"","%15":"","%16":"","%17":"","%18":"","%19":"","%1a":"","%1A":"","%1b":"\x1B","%1B":"\x1B","%1c":"","%1C":"","%1d":"","%1D":"","%1e":"","%1E":"","%1f":"","%1F":"","%20":" ","%21":"!","%22":'"',"%23":"#","%24":"$","%25":"%","%26":"&","%27":"'","%28":"(","%29":")","%2a":"*","%2A":"*","%2b":"+","%2B":"+","%2c":",","%2C":",","%2d":"-","%2D":"-","%2e":".","%2E":".","%2f":"/","%2F":"/","%30":"0","%31":"1","%32":"2","%33":"3","%34":"4","%35":"5","%36":"6","%37":"7","%38":"8","%39":"9","%3a":":","%3A":":","%3b":";","%3B":";","%3c":"<","%3C":"<","%3d":"=","%3D":"=","%3e":">","%3E":">","%3f":"?","%3F":"?","%40":"@","%41":"A","%42":"B","%43":"C","%44":"D","%45":"E","%46":"F","%47":"G","%48":"H","%49":"I","%4a":"J","%4A":"J","%4b":"K","%4B":"K","%4c":"L","%4C":"L","%4d":"M","%4D":"M","%4e":"N","%4E":"N","%4f":"O","%4F":"O","%50":"P","%51":"Q","%52":"R","%53":"S","%54":"T","%55":"U","%56":"V","%57":"W","%58":"X","%59":"Y","%5a":"Z","%5A":"Z","%5b":"[","%5B":"[","%5c":"\\","%5C":"\\","%5d":"]","%5D":"]","%5e":"^","%5E":"^","%5f":"_","%5F":"_","%60":"`","%61":"a","%62":"b","%63":"c","%64":"d","%65":"e","%66":"f","%67":"g","%68":"h","%69":"i","%6a":"j","%6A":"j","%6b":"k","%6B":"k","%6c":"l","%6C":"l","%6d":"m","%6D":"m","%6e":"n","%6E":"n","%6f":"o","%6F":"o","%70":"p","%71":"q","%72":"r","%73":"s","%74":"t","%75":"u","%76":"v","%77":"w","%78":"x","%79":"y","%7a":"z","%7A":"z","%7b":"{","%7B":"{","%7c":"|","%7C":"|","%7d":"}","%7D":"}","%7e":"~","%7E":"~","%7f":"","%7F":"","%80":"","%81":"","%82":"","%83":"","%84":"","%85":"","%86":"","%87":"","%88":"","%89":"","%8a":"","%8A":"","%8b":"","%8B":"","%8c":"","%8C":"","%8d":"","%8D":"","%8e":"","%8E":"","%8f":"","%8F":"","%90":"","%91":"","%92":"","%93":"","%94":"","%95":"","%96":"","%97":"","%98":"","%99":"","%9a":"","%9A":"","%9b":"","%9B":"","%9c":"","%9C":"","%9d":"","%9D":"","%9e":"","%9E":"","%9f":"","%9F":"","%a0":" ","%A0":" ","%a1":"¡","%A1":"¡","%a2":"¢","%A2":"¢","%a3":"£","%A3":"£","%a4":"¤","%A4":"¤","%a5":"¥","%A5":"¥","%a6":"¦","%A6":"¦","%a7":"§","%A7":"§","%a8":"¨","%A8":"¨","%a9":"©","%A9":"©","%aa":"ª","%Aa":"ª","%aA":"ª","%AA":"ª","%ab":"«","%Ab":"«","%aB":"«","%AB":"«","%ac":"¬","%Ac":"¬","%aC":"¬","%AC":"¬","%ad":"­","%Ad":"­","%aD":"­","%AD":"­","%ae":"®","%Ae":"®","%aE":"®","%AE":"®","%af":"¯","%Af":"¯","%aF":"¯","%AF":"¯","%b0":"°","%B0":"°","%b1":"±","%B1":"±","%b2":"²","%B2":"²","%b3":"³","%B3":"³","%b4":"´","%B4":"´","%b5":"µ","%B5":"µ","%b6":"¶","%B6":"¶","%b7":"·","%B7":"·","%b8":"¸","%B8":"¸","%b9":"¹","%B9":"¹","%ba":"º","%Ba":"º","%bA":"º","%BA":"º","%bb":"»","%Bb":"»","%bB":"»","%BB":"»","%bc":"¼","%Bc":"¼","%bC":"¼","%BC":"¼","%bd":"½","%Bd":"½","%bD":"½","%BD":"½","%be":"¾","%Be":"¾","%bE":"¾","%BE":"¾","%bf":"¿","%Bf":"¿","%bF":"¿","%BF":"¿","%c0":"À","%C0":"À","%c1":"Á","%C1":"Á","%c2":"Â","%C2":"Â","%c3":"Ã","%C3":"Ã","%c4":"Ä","%C4":"Ä","%c5":"Å","%C5":"Å","%c6":"Æ","%C6":"Æ","%c7":"Ç","%C7":"Ç","%c8":"È","%C8":"È","%c9":"É","%C9":"É","%ca":"Ê","%Ca":"Ê","%cA":"Ê","%CA":"Ê","%cb":"Ë","%Cb":"Ë","%cB":"Ë","%CB":"Ë","%cc":"Ì","%Cc":"Ì","%cC":"Ì","%CC":"Ì","%cd":"Í","%Cd":"Í","%cD":"Í","%CD":"Í","%ce":"Î","%Ce":"Î","%cE":"Î","%CE":"Î","%cf":"Ï","%Cf":"Ï","%cF":"Ï","%CF":"Ï","%d0":"Ð","%D0":"Ð","%d1":"Ñ","%D1":"Ñ","%d2":"Ò","%D2":"Ò","%d3":"Ó","%D3":"Ó","%d4":"Ô","%D4":"Ô","%d5":"Õ","%D5":"Õ","%d6":"Ö","%D6":"Ö","%d7":"×","%D7":"×","%d8":"Ø","%D8":"Ø","%d9":"Ù","%D9":"Ù","%da":"Ú","%Da":"Ú","%dA":"Ú","%DA":"Ú","%db":"Û","%Db":"Û","%dB":"Û","%DB":"Û","%dc":"Ü","%Dc":"Ü","%dC":"Ü","%DC":"Ü","%dd":"Ý","%Dd":"Ý","%dD":"Ý","%DD":"Ý","%de":"Þ","%De":"Þ","%dE":"Þ","%DE":"Þ","%df":"ß","%Df":"ß","%dF":"ß","%DF":"ß","%e0":"à","%E0":"à","%e1":"á","%E1":"á","%e2":"â","%E2":"â","%e3":"ã","%E3":"ã","%e4":"ä","%E4":"ä","%e5":"å","%E5":"å","%e6":"æ","%E6":"æ","%e7":"ç","%E7":"ç","%e8":"è","%E8":"è","%e9":"é","%E9":"é","%ea":"ê","%Ea":"ê","%eA":"ê","%EA":"ê","%eb":"ë","%Eb":"ë","%eB":"ë","%EB":"ë","%ec":"ì","%Ec":"ì","%eC":"ì","%EC":"ì","%ed":"í","%Ed":"í","%eD":"í","%ED":"í","%ee":"î","%Ee":"î","%eE":"î","%EE":"î","%ef":"ï","%Ef":"ï","%eF":"ï","%EF":"ï","%f0":"ð","%F0":"ð","%f1":"ñ","%F1":"ñ","%f2":"ò","%F2":"ò","%f3":"ó","%F3":"ó","%f4":"ô","%F4":"ô","%f5":"õ","%F5":"õ","%f6":"ö","%F6":"ö","%f7":"÷","%F7":"÷","%f8":"ø","%F8":"ø","%f9":"ù","%F9":"ù","%fa":"ú","%Fa":"ú","%fA":"ú","%FA":"ú","%fb":"û","%Fb":"û","%fB":"û","%FB":"û","%fc":"ü","%Fc":"ü","%fC":"ü","%FC":"ü","%fd":"ý","%Fd":"ý","%fD":"ý","%FD":"ý","%fe":"þ","%Fe":"þ","%fE":"þ","%FE":"þ","%ff":"ÿ","%Ff":"ÿ","%fF":"ÿ","%FF":"ÿ"};function encodedReplacer(match){return EncodedLookup[match]}var STATE_KEY=0;var STATE_VALUE=1;var STATE_CHARSET=2;var STATE_LANG=3;function parseParams(str2){const res=[];let state=STATE_KEY;let charset="";let inquote=false;let escaping=false;let p=0;let tmp="";const len=str2.length;for(var i=0;i<len;++i){const char=str2[i];if(char==="\\"&&inquote){if(escaping){escaping=false}else{escaping=true;continue}}else if(char==='"'){if(!escaping){if(inquote){inquote=false;state=STATE_KEY}else{inquote=true}continue}else{escaping=false}}else{if(escaping&&inquote){tmp+="\\"}escaping=false;if((state===STATE_CHARSET||state===STATE_LANG)&&char==="'"){if(state===STATE_CHARSET){state=STATE_LANG;charset=tmp.substring(1)}else{state=STATE_VALUE}tmp="";continue}else if(state===STATE_KEY&&(char==="*"||char==="=")&&res.length){state=char==="*"?STATE_CHARSET:STATE_VALUE;res[p]=[tmp,void 0];tmp="";continue}else if(!inquote&&char===";"){state=STATE_KEY;if(charset){if(tmp.length){tmp=decodeText(tmp.replace(RE_ENCODED,encodedReplacer),"binary",charset)}charset=""}else if(tmp.length){tmp=decodeText(tmp,"binary","utf8")}if(res[p]===void 0){res[p]=tmp}else{res[p][1]=tmp}tmp="";++p;continue}else if(!inquote&&(char===" "||char==="	")){continue}}tmp+=char}if(charset&&tmp.length){tmp=decodeText(tmp.replace(RE_ENCODED,encodedReplacer),"binary",charset)}else if(tmp){tmp=decodeText(tmp,"binary","utf8")}if(res[p]===void 0){if(tmp){res[p]=tmp}}else{res[p][1]=tmp}return res}module2.exports=parseParams}});var require_basename=__commonJS({"node_modules/@fastify/busboy/lib/utils/basename.js"(exports2,module2){"use strict";module2.exports=function basename2(path23){if(typeof path23!=="string"){return""}for(var i=path23.length-1;i>=0;--i){switch(path23.charCodeAt(i)){case 47:case 92:path23=path23.slice(i+1);return path23===".."||path23==="."?"":path23}}return path23===".."||path23==="."?"":path23}}});var require_multipart=__commonJS({"node_modules/@fastify/busboy/lib/types/multipart.js"(exports2,module2){"use strict";var{Readable}=require("node:stream");var{inherits}=require("node:util");var Dicer=require_Dicer();var parseParams=require_parseParams();var decodeText=require_decodeText();var basename2=require_basename();var getLimit=require_getLimit();var RE_BOUNDARY=/^boundary$/i;var RE_FIELD=/^form-data$/i;var RE_CHARSET=/^charset$/i;var RE_FILENAME=/^filename$/i;var RE_NAME=/^name$/i;Multipart.detect=/^multipart\/form-data/i;function Multipart(boy,cfg){let i;let len;const self2=this;let boundary;const limits=cfg.limits;const isPartAFile=cfg.isPartAFile||((fieldName,contentType,fileName)=>contentType==="application/octet-stream"||fileName!==void 0);const parsedConType=cfg.parsedConType||[];const defCharset=cfg.defCharset||"utf8";const preservePath=cfg.preservePath;const fileOpts={highWaterMark:cfg.fileHwm};for(i=0,len=parsedConType.length;i<len;++i){if(Array.isArray(parsedConType[i])&&RE_BOUNDARY.test(parsedConType[i][0])){boundary=parsedConType[i][1];break}}function checkFinished(){if(nends===0&&finished&&!boy._done){finished=false;self2.end()}}if(typeof boundary!=="string"){throw new Error("Multipart: Boundary not found")}const fieldSizeLimit=getLimit(limits,"fieldSize",1*1024*1024);const fileSizeLimit=getLimit(limits,"fileSize",Infinity);const filesLimit=getLimit(limits,"files",Infinity);const fieldsLimit=getLimit(limits,"fields",Infinity);const partsLimit=getLimit(limits,"parts",Infinity);const headerPairsLimit=getLimit(limits,"headerPairs",2e3);const headerSizeLimit=getLimit(limits,"headerSize",80*1024);let nfiles=0;let nfields=0;let nends=0;let curFile;let curField;let finished=false;this._needDrain=false;this._pause=false;this._cb=void 0;this._nparts=0;this._boy=boy;const parserCfg={boundary,maxHeaderPairs:headerPairsLimit,maxHeaderSize:headerSizeLimit,partHwm:fileOpts.highWaterMark,highWaterMark:cfg.highWaterMark};this.parser=new Dicer(parserCfg);this.parser.on("drain",function(){self2._needDrain=false;if(self2._cb&&!self2._pause){const cb=self2._cb;self2._cb=void 0;cb()}}).on("part",function onPart(part){if(++self2._nparts>partsLimit){self2.parser.removeListener("part",onPart);self2.parser.on("part",skipPart);boy.hitPartsLimit=true;boy.emit("partsLimit");return skipPart(part)}if(curField){const field=curField;field.emit("end");field.removeAllListeners("end")}part.on("header",function(header2){let contype;let fieldname;let parsed;let charset;let encoding;let filename;let nsize=0;if(header2["content-type"]){parsed=parseParams(header2["content-type"][0]);if(parsed[0]){contype=parsed[0].toLowerCase();for(i=0,len=parsed.length;i<len;++i){if(RE_CHARSET.test(parsed[i][0])){charset=parsed[i][1].toLowerCase();break}}}}if(contype===void 0){contype="text/plain"}if(charset===void 0){charset=defCharset}if(header2["content-disposition"]){parsed=parseParams(header2["content-disposition"][0]);if(!RE_FIELD.test(parsed[0])){return skipPart(part)}for(i=0,len=parsed.length;i<len;++i){if(RE_NAME.test(parsed[i][0])){fieldname=parsed[i][1]}else if(RE_FILENAME.test(parsed[i][0])){filename=parsed[i][1];if(!preservePath){filename=basename2(filename)}}}}else{return skipPart(part)}if(header2["content-transfer-encoding"]){encoding=header2["content-transfer-encoding"][0].toLowerCase()}else{encoding="7bit"}let onData,onEnd;if(isPartAFile(fieldname,contype,filename)){if(nfiles===filesLimit){if(!boy.hitFilesLimit){boy.hitFilesLimit=true;boy.emit("filesLimit")}return skipPart(part)}++nfiles;if(boy.listenerCount("file")===0){self2.parser._ignore();return}++nends;const file=new FileStream(fileOpts);curFile=file;file.on("end",function(){--nends;self2._pause=false;checkFinished();if(self2._cb&&!self2._needDrain){const cb=self2._cb;self2._cb=void 0;cb()}});file._read=function(n){if(!self2._pause){return}self2._pause=false;if(self2._cb&&!self2._needDrain){const cb=self2._cb;self2._cb=void 0;cb()}};boy.emit("file",fieldname,file,filename,encoding,contype);onData=function(data){if((nsize+=data.length)>fileSizeLimit){const extralen=fileSizeLimit-nsize+data.length;if(extralen>0){file.push(data.slice(0,extralen))}file.truncated=true;file.bytesRead=fileSizeLimit;part.removeAllListeners("data");file.emit("limit");return}else if(!file.push(data)){self2._pause=true}file.bytesRead=nsize};onEnd=function(){curFile=void 0;file.push(null)}}else{if(nfields===fieldsLimit){if(!boy.hitFieldsLimit){boy.hitFieldsLimit=true;boy.emit("fieldsLimit")}return skipPart(part)}++nfields;++nends;let buffer="";let truncated=false;curField=part;onData=function(data){if((nsize+=data.length)>fieldSizeLimit){const extralen=fieldSizeLimit-(nsize-data.length);buffer+=data.toString("binary",0,extralen);truncated=true;part.removeAllListeners("data")}else{buffer+=data.toString("binary")}};onEnd=function(){curField=void 0;if(buffer.length){buffer=decodeText(buffer,"binary",charset)}boy.emit("field",fieldname,buffer,false,truncated,encoding,contype);--nends;checkFinished()}}part._readableState.sync=false;part.on("data",onData);part.on("end",onEnd)}).on("error",function(err){if(curFile){curFile.emit("error",err)}})}).on("error",function(err){boy.emit("error",err)}).on("finish",function(){finished=true;checkFinished()})}Multipart.prototype.write=function(chunk2,cb){const r=this.parser.write(chunk2);if(r&&!this._pause){cb()}else{this._needDrain=!r;this._cb=cb}};Multipart.prototype.end=function(){const self2=this;if(self2.parser.writable){self2.parser.end()}else if(!self2._boy._done){process.nextTick(function(){self2._boy._done=true;self2._boy.emit("finish")})}};function skipPart(part){part.resume()}function FileStream(opts){Readable.call(this,opts);this.bytesRead=0;this.truncated=false}inherits(FileStream,Readable);FileStream.prototype._read=function(n){};module2.exports=Multipart}});var require_Decoder=__commonJS({"node_modules/@fastify/busboy/lib/utils/Decoder.js"(exports2,module2){"use strict";var RE_PLUS=/\+/g;var HEX=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];function Decoder(){this.buffer=void 0}Decoder.prototype.write=function(str2){str2=str2.replace(RE_PLUS," ");let res="";let i=0;let p=0;const len=str2.length;for(;i<len;++i){if(this.buffer!==void 0){if(!HEX[str2.charCodeAt(i)]){res+="%"+this.buffer;this.buffer=void 0;--i}else{this.buffer+=str2[i];++p;if(this.buffer.length===2){res+=String.fromCharCode(parseInt(this.buffer,16));this.buffer=void 0}}}else if(str2[i]==="%"){if(i>p){res+=str2.substring(p,i);p=i}this.buffer="";++p}}if(p<len&&this.buffer===void 0){res+=str2.substring(p)}return res};Decoder.prototype.reset=function(){this.buffer=void 0};module2.exports=Decoder}});var require_urlencoded=__commonJS({"node_modules/@fastify/busboy/lib/types/urlencoded.js"(exports2,module2){"use strict";var Decoder=require_Decoder();var decodeText=require_decodeText();var getLimit=require_getLimit();var RE_CHARSET=/^charset$/i;UrlEncoded.detect=/^application\/x-www-form-urlencoded/i;function UrlEncoded(boy,cfg){const limits=cfg.limits;const parsedConType=cfg.parsedConType;this.boy=boy;this.fieldSizeLimit=getLimit(limits,"fieldSize",1*1024*1024);this.fieldNameSizeLimit=getLimit(limits,"fieldNameSize",100);this.fieldsLimit=getLimit(limits,"fields",Infinity);let charset;for(var i=0,len=parsedConType.length;i<len;++i){if(Array.isArray(parsedConType[i])&&RE_CHARSET.test(parsedConType[i][0])){charset=parsedConType[i][1].toLowerCase();break}}if(charset===void 0){charset=cfg.defCharset||"utf8"}this.decoder=new Decoder;this.charset=charset;this._fields=0;this._state="key";this._checkingBytes=true;this._bytesKey=0;this._bytesVal=0;this._key="";this._val="";this._keyTrunc=false;this._valTrunc=false;this._hitLimit=false}UrlEncoded.prototype.write=function(data,cb){if(this._fields===this.fieldsLimit){if(!this.boy.hitFieldsLimit){this.boy.hitFieldsLimit=true;this.boy.emit("fieldsLimit")}return cb()}let idxeq;let idxamp;let i;let p=0;const len=data.length;while(p<len){if(this._state==="key"){idxeq=idxamp=void 0;for(i=p;i<len;++i){if(!this._checkingBytes){++p}if(data[i]===61){idxeq=i;break}else if(data[i]===38){idxamp=i;break}if(this._checkingBytes&&this._bytesKey===this.fieldNameSizeLimit){this._hitLimit=true;break}else if(this._checkingBytes){++this._bytesKey}}if(idxeq!==void 0){if(idxeq>p){this._key+=this.decoder.write(data.toString("binary",p,idxeq))}this._state="val";this._hitLimit=false;this._checkingBytes=true;this._val="";this._bytesVal=0;this._valTrunc=false;this.decoder.reset();p=idxeq+1}else if(idxamp!==void 0){++this._fields;let key;const keyTrunc=this._keyTrunc;if(idxamp>p){key=this._key+=this.decoder.write(data.toString("binary",p,idxamp))}else{key=this._key}this._hitLimit=false;this._checkingBytes=true;this._key="";this._bytesKey=0;this._keyTrunc=false;this.decoder.reset();if(key.length){this.boy.emit("field",decodeText(key,"binary",this.charset),"",keyTrunc,false)}p=idxamp+1;if(this._fields===this.fieldsLimit){return cb()}}else if(this._hitLimit){if(i>p){this._key+=this.decoder.write(data.toString("binary",p,i))}p=i;if((this._bytesKey=this._key.length)===this.fieldNameSizeLimit){this._checkingBytes=false;this._keyTrunc=true}}else{if(p<len){this._key+=this.decoder.write(data.toString("binary",p))}p=len}}else{idxamp=void 0;for(i=p;i<len;++i){if(!this._checkingBytes){++p}if(data[i]===38){idxamp=i;break}if(this._checkingBytes&&this._bytesVal===this.fieldSizeLimit){this._hitLimit=true;break}else if(this._checkingBytes){++this._bytesVal}}if(idxamp!==void 0){++this._fields;if(idxamp>p){this._val+=this.decoder.write(data.toString("binary",p,idxamp))}this.boy.emit("field",decodeText(this._key,"binary",this.charset),decodeText(this._val,"binary",this.charset),this._keyTrunc,this._valTrunc);this._state="key";this._hitLimit=false;this._checkingBytes=true;this._key="";this._bytesKey=0;this._keyTrunc=false;this.decoder.reset();p=idxamp+1;if(this._fields===this.fieldsLimit){return cb()}}else if(this._hitLimit){if(i>p){this._val+=this.decoder.write(data.toString("binary",p,i))}p=i;if(this._val===""&&this.fieldSizeLimit===0||(this._bytesVal=this._val.length)===this.fieldSizeLimit){this._checkingBytes=false;this._valTrunc=true}}else{if(p<len){this._val+=this.decoder.write(data.toString("binary",p))}p=len}}}cb()};UrlEncoded.prototype.end=function(){if(this.boy._done){return}if(this._state==="key"&&this._key.length>0){this.boy.emit("field",decodeText(this._key,"binary",this.charset),"",this._keyTrunc,false)}else if(this._state==="val"){this.boy.emit("field",decodeText(this._key,"binary",this.charset),decodeText(this._val,"binary",this.charset),this._keyTrunc,this._valTrunc)}this.boy._done=true;this.boy.emit("finish")};module2.exports=UrlEncoded}});var require_main2=__commonJS({"node_modules/@fastify/busboy/lib/main.js"(exports2,module2){"use strict";var WritableStream=require("node:stream").Writable;var{inherits}=require("node:util");var Dicer=require_Dicer();var MultipartParser=require_multipart();var UrlencodedParser=require_urlencoded();var parseParams=require_parseParams();function Busboy(opts){if(!(this instanceof Busboy)){return new Busboy(opts)}if(typeof opts!=="object"){throw new TypeError("Busboy expected an options-Object.")}if(typeof opts.headers!=="object"){throw new TypeError("Busboy expected an options-Object with headers-attribute.")}if(typeof opts.headers["content-type"]!=="string"){throw new TypeError("Missing Content-Type-header.")}const{headers,...streamOptions}=opts;this.opts={autoDestroy:false,...streamOptions};WritableStream.call(this,this.opts);this._done=false;this._parser=this.getParserByHeaders(headers);this._finished=false}inherits(Busboy,WritableStream);Busboy.prototype.emit=function(ev){var _a2;if(ev==="finish"){if(!this._done){(_a2=this._parser)==null?void 0:_a2.end();return}else if(this._finished){return}this._finished=true}WritableStream.prototype.emit.apply(this,arguments)};Busboy.prototype.getParserByHeaders=function(headers){const parsed=parseParams(headers["content-type"]);const cfg={defCharset:this.opts.defCharset,fileHwm:this.opts.fileHwm,headers,highWaterMark:this.opts.highWaterMark,isPartAFile:this.opts.isPartAFile,limits:this.opts.limits,parsedConType:parsed,preservePath:this.opts.preservePath};if(MultipartParser.detect.test(parsed[0])){return new MultipartParser(this,cfg)}if(UrlencodedParser.detect.test(parsed[0])){return new UrlencodedParser(this,cfg)}throw new Error("Unsupported Content-Type.")};Busboy.prototype._write=function(chunk2,encoding,cb){this._parser.write(chunk2,cb)};module2.exports=Busboy;module2.exports.default=Busboy;module2.exports.Busboy=Busboy;module2.exports.Dicer=Dicer}});var require_constants2=__commonJS({"node_modules/undici/lib/fetch/constants.js"(exports2,module2){"use strict";var{MessageChannel,receiveMessageOnPort}=require("worker_threads");var corsSafeListedMethods=["GET","HEAD","POST"];var corsSafeListedMethodsSet=new Set(corsSafeListedMethods);var nullBodyStatus=[101,204,205,304];var redirectStatus=[301,302,303,307,308];var redirectStatusSet=new Set(redirectStatus);var badPorts=["1","7","9","11","13","15","17","19","20","21","22","23","25","37","42","43","53","69","77","79","87","95","101","102","103","104","109","110","111","113","115","117","119","123","135","137","139","143","161","179","389","427","465","512","513","514","515","526","530","531","532","540","548","554","556","563","587","601","636","989","990","993","995","1719","1720","1723","2049","3659","4045","5060","5061","6000","6566","6665","6666","6667","6668","6669","6697","10080"];var badPortsSet=new Set(badPorts);var referrerPolicy=["","no-referrer","no-referrer-when-downgrade","same-origin","origin","strict-origin","origin-when-cross-origin","strict-origin-when-cross-origin","unsafe-url"];var referrerPolicySet=new Set(referrerPolicy);var requestRedirect=["follow","manual","error"];var safeMethods=["GET","HEAD","OPTIONS","TRACE"];var safeMethodsSet=new Set(safeMethods);var requestMode=["navigate","same-origin","no-cors","cors"];var requestCredentials=["omit","same-origin","include"];var requestCache=["default","no-store","reload","no-cache","force-cache","only-if-cached"];var requestBodyHeader=["content-encoding","content-language","content-location","content-type","content-length"];var requestDuplex=["half"];var forbiddenMethods=["CONNECT","TRACE","TRACK"];var forbiddenMethodsSet=new Set(forbiddenMethods);var subresource=["audio","audioworklet","font","image","manifest","paintworklet","script","style","track","video","xslt",""];var subresourceSet=new Set(subresource);var DOMException2=globalThis.DOMException??(()=>{try{atob("~")}catch(err){return Object.getPrototypeOf(err).constructor}})();var channel;var structuredClone2=globalThis.structuredClone??function structuredClone3(value,options=void 0){if(arguments.length===0){throw new TypeError("missing argument")}if(!channel){channel=new MessageChannel}channel.port1.unref();channel.port2.unref();channel.port1.postMessage(value,options==null?void 0:options.transfer);return receiveMessageOnPort(channel.port2).message};module2.exports={DOMException:DOMException2,structuredClone:structuredClone2,subresource,forbiddenMethods,requestBodyHeader,referrerPolicy,requestRedirect,requestMode,requestCredentials,requestCache,redirectStatus,corsSafeListedMethods,nullBodyStatus,safeMethods,badPorts,requestDuplex,subresourceSet,badPortsSet,redirectStatusSet,corsSafeListedMethodsSet,safeMethodsSet,forbiddenMethodsSet,referrerPolicySet}}});var require_global=__commonJS({"node_modules/undici/lib/fetch/global.js"(exports2,module2){"use strict";var globalOrigin=Symbol.for("undici.globalOrigin.1");function getGlobalOrigin(){return globalThis[globalOrigin]}function setGlobalOrigin(newOrigin){if(newOrigin===void 0){Object.defineProperty(globalThis,globalOrigin,{value:void 0,writable:true,enumerable:false,configurable:false});return}const parsedURL=new URL(newOrigin);if(parsedURL.protocol!=="http:"&&parsedURL.protocol!=="https:"){throw new TypeError(`Only http & https urls are allowed, received ${parsedURL.protocol}`)}Object.defineProperty(globalThis,globalOrigin,{value:parsedURL,writable:true,enumerable:false,configurable:false})}module2.exports={getGlobalOrigin,setGlobalOrigin}}});var require_util3=__commonJS({"node_modules/undici/lib/fetch/util.js"(exports2,module2){"use strict";var{redirectStatusSet,referrerPolicySet:referrerPolicyTokens,badPortsSet}=require_constants2();var{getGlobalOrigin}=require_global();var{performance:performance2}=require("perf_hooks");var{isBlobLike,toUSVString,ReadableStreamFrom}=require_util2();var assert2=require("assert");var{isUint8Array}=require("util/types");var supportedHashes=[];var crypto5;try{crypto5=require("crypto");const possibleRelevantHashes=["sha256","sha384","sha512"];supportedHashes=crypto5.getHashes().filter(hash=>possibleRelevantHashes.includes(hash))}catch{}function responseURL(response){const urlList=response.urlList;const length=urlList.length;return length===0?null:urlList[length-1].toString()}function responseLocationURL(response,requestFragment){if(!redirectStatusSet.has(response.status)){return null}let location=response.headersList.get("location");if(location!==null&&isValidHeaderValue(location)){location=new URL(location,responseURL(response))}if(location&&!location.hash){location.hash=requestFragment}return location}function requestCurrentURL(request){return request.urlList[request.urlList.length-1]}function requestBadPort(request){const url=requestCurrentURL(request);if(urlIsHttpHttpsScheme(url)&&badPortsSet.has(url.port)){return"blocked"}return"allowed"}function isErrorLike(object){var _a2,_b;return object instanceof Error||(((_a2=object==null?void 0:object.constructor)==null?void 0:_a2.name)==="Error"||((_b=object==null?void 0:object.constructor)==null?void 0:_b.name)==="DOMException")}function isValidReasonPhrase(statusText){for(let i=0;i<statusText.length;++i){const c=statusText.charCodeAt(i);if(!(c===9||c>=32&&c<=126||c>=128&&c<=255)){return false}}return true}function isTokenCharCode(c){switch(c){case 34:case 40:case 41:case 44:case 47:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 91:case 92:case 93:case 123:case 125:return false;default:return c>=33&&c<=126}}function isValidHTTPToken(characters){if(characters.length===0){return false}for(let i=0;i<characters.length;++i){if(!isTokenCharCode(characters.charCodeAt(i))){return false}}return true}function isValidHeaderName(potentialValue){return isValidHTTPToken(potentialValue)}function isValidHeaderValue(potentialValue){if(potentialValue.startsWith("	")||potentialValue.startsWith(" ")||potentialValue.endsWith("	")||potentialValue.endsWith(" ")){return false}if(potentialValue.includes("\0")||potentialValue.includes("\r")||potentialValue.includes("\n")){return false}return true}function setRequestReferrerPolicyOnRedirect(request,actualResponse){const{headersList}=actualResponse;const policyHeader=(headersList.get("referrer-policy")??"").split(",");let policy="";if(policyHeader.length>0){for(let i=policyHeader.length;i!==0;i--){const token2=policyHeader[i-1].trim();if(referrerPolicyTokens.has(token2)){policy=token2;break}}}if(policy!==""){request.referrerPolicy=policy}}function crossOriginResourcePolicyCheck(){return"allowed"}function corsCheck(){return"success"}function TAOCheck(){return"success"}function appendFetchMetadata(httpRequest){let header2=null;header2=httpRequest.mode;httpRequest.headersList.set("sec-fetch-mode",header2)}function appendRequestOriginHeader(request){let serializedOrigin=request.origin;if(request.responseTainting==="cors"||request.mode==="websocket"){if(serializedOrigin){request.headersList.append("origin",serializedOrigin)}}else if(request.method!=="GET"&&request.method!=="HEAD"){switch(request.referrerPolicy){case"no-referrer":serializedOrigin=null;break;case"no-referrer-when-downgrade":case"strict-origin":case"strict-origin-when-cross-origin":if(request.origin&&urlHasHttpsScheme(request.origin)&&!urlHasHttpsScheme(requestCurrentURL(request))){serializedOrigin=null}break;case"same-origin":if(!sameOrigin(request,requestCurrentURL(request))){serializedOrigin=null}break;default:}if(serializedOrigin){request.headersList.append("origin",serializedOrigin)}}}function coarsenedSharedCurrentTime(crossOriginIsolatedCapability){return performance2.now()}function createOpaqueTimingInfo(timingInfo){return{startTime:timingInfo.startTime??0,redirectStartTime:0,redirectEndTime:0,postRedirectStartTime:timingInfo.startTime??0,finalServiceWorkerStartTime:0,finalNetworkResponseStartTime:0,finalNetworkRequestStartTime:0,endTime:0,encodedBodySize:0,decodedBodySize:0,finalConnectionTimingInfo:null}}function makePolicyContainer(){return{referrerPolicy:"strict-origin-when-cross-origin"}}function clonePolicyContainer(policyContainer){return{referrerPolicy:policyContainer.referrerPolicy}}function determineRequestsReferrer(request){const policy=request.referrerPolicy;assert2(policy);let referrerSource=null;if(request.referrer==="client"){const globalOrigin=getGlobalOrigin();if(!globalOrigin||globalOrigin.origin==="null"){return"no-referrer"}referrerSource=new URL(globalOrigin)}else if(request.referrer instanceof URL){referrerSource=request.referrer}let referrerURL=stripURLForReferrer(referrerSource);const referrerOrigin=stripURLForReferrer(referrerSource,true);if(referrerURL.toString().length>4096){referrerURL=referrerOrigin}const areSameOrigin=sameOrigin(request,referrerURL);const isNonPotentiallyTrustWorthy=isURLPotentiallyTrustworthy(referrerURL)&&!isURLPotentiallyTrustworthy(request.url);switch(policy){case"origin":return referrerOrigin!=null?referrerOrigin:stripURLForReferrer(referrerSource,true);case"unsafe-url":return referrerURL;case"same-origin":return areSameOrigin?referrerOrigin:"no-referrer";case"origin-when-cross-origin":return areSameOrigin?referrerURL:referrerOrigin;case"strict-origin-when-cross-origin":{const currentURL=requestCurrentURL(request);if(sameOrigin(referrerURL,currentURL)){return referrerURL}if(isURLPotentiallyTrustworthy(referrerURL)&&!isURLPotentiallyTrustworthy(currentURL)){return"no-referrer"}return referrerOrigin}case"strict-origin":case"no-referrer-when-downgrade":default:return isNonPotentiallyTrustWorthy?"no-referrer":referrerOrigin}}function stripURLForReferrer(url,originOnly){assert2(url instanceof URL);if(url.protocol==="file:"||url.protocol==="about:"||url.protocol==="blank:"){return"no-referrer"}url.username="";url.password="";url.hash="";if(originOnly){url.pathname="";url.search=""}return url}function isURLPotentiallyTrustworthy(url){if(!(url instanceof URL)){return false}if(url.href==="about:blank"||url.href==="about:srcdoc"){return true}if(url.protocol==="data:")return true;if(url.protocol==="file:")return true;return isOriginPotentiallyTrustworthy(url.origin);function isOriginPotentiallyTrustworthy(origin){if(origin==null||origin==="null")return false;const originAsURL=new URL(origin);if(originAsURL.protocol==="https:"||originAsURL.protocol==="wss:"){return true}if(/^127(?:\.[0-9]+){0,2}\.[0-9]+$|^\[(?:0*:)*?:?0*1\]$/.test(originAsURL.hostname)||(originAsURL.hostname==="localhost"||originAsURL.hostname.includes("localhost."))||originAsURL.hostname.endsWith(".localhost")){return true}return false}}function bytesMatch(bytes8,metadataList){if(crypto5===void 0){return true}const parsedMetadata=parseMetadata(metadataList);if(parsedMetadata==="no metadata"){return true}if(parsedMetadata.length===0){return true}const strongest=getStrongestMetadata(parsedMetadata);const metadata=filterMetadataListByAlgorithm(parsedMetadata,strongest);for(const item of metadata){const algorithm=item.algo;const expectedValue=item.hash;let actualValue=crypto5.createHash(algorithm).update(bytes8).digest("base64");if(actualValue[actualValue.length-1]==="="){if(actualValue[actualValue.length-2]==="="){actualValue=actualValue.slice(0,-2)}else{actualValue=actualValue.slice(0,-1)}}if(compareBase64Mixed(actualValue,expectedValue)){return true}}return false}var parseHashWithOptions=/(?<algo>sha256|sha384|sha512)-((?<hash>[A-Za-z0-9+/]+|[A-Za-z0-9_-]+)={0,2}(?:\s|$)( +[!-~]*)?)?/i;function parseMetadata(metadata){const result2=[];let empty=true;for(const token2 of metadata.split(" ")){empty=false;const parsedToken=parseHashWithOptions.exec(token2);if(parsedToken===null||parsedToken.groups===void 0||parsedToken.groups.algo===void 0){continue}const algorithm=parsedToken.groups.algo.toLowerCase();if(supportedHashes.includes(algorithm)){result2.push(parsedToken.groups)}}if(empty===true){return"no metadata"}return result2}function getStrongestMetadata(metadataList){let algorithm=metadataList[0].algo;if(algorithm[3]==="5"){return algorithm}for(let i=1;i<metadataList.length;++i){const metadata=metadataList[i];if(metadata.algo[3]==="5"){algorithm="sha512";break}else if(algorithm[3]==="3"){continue}else if(metadata.algo[3]==="3"){algorithm="sha384"}}return algorithm}function filterMetadataListByAlgorithm(metadataList,algorithm){if(metadataList.length===1){return metadataList}let pos=0;for(let i=0;i<metadataList.length;++i){if(metadataList[i].algo===algorithm){metadataList[pos++]=metadataList[i]}}metadataList.length=pos;return metadataList}function compareBase64Mixed(actualValue,expectedValue){if(actualValue.length!==expectedValue.length){return false}for(let i=0;i<actualValue.length;++i){if(actualValue[i]!==expectedValue[i]){if(actualValue[i]==="+"&&expectedValue[i]==="-"||actualValue[i]==="/"&&expectedValue[i]==="_"){continue}return false}}return true}function tryUpgradeRequestToAPotentiallyTrustworthyURL(request){}function sameOrigin(A,B){if(A.origin===B.origin&&A.origin==="null"){return true}if(A.protocol===B.protocol&&A.hostname===B.hostname&&A.port===B.port){return true}return false}function createDeferredPromise(){let res;let rej;const promise=new Promise((resolve,reject2)=>{res=resolve;rej=reject2});return{promise,resolve:res,reject:rej}}function isAborted2(fetchParams){return fetchParams.controller.state==="aborted"}function isCancelled(fetchParams){return fetchParams.controller.state==="aborted"||fetchParams.controller.state==="terminated"}var normalizeMethodRecord={delete:"DELETE",DELETE:"DELETE",get:"GET",GET:"GET",head:"HEAD",HEAD:"HEAD",options:"OPTIONS",OPTIONS:"OPTIONS",post:"POST",POST:"POST",put:"PUT",PUT:"PUT"};Object.setPrototypeOf(normalizeMethodRecord,null);function normalizeMethod(method2){return normalizeMethodRecord[method2.toLowerCase()]??method2}function serializeJavascriptValueToJSONString(value){const result2=JSON.stringify(value);if(result2===void 0){throw new TypeError("Value is not JSON serializable")}assert2(typeof result2==="string");return result2}var esIteratorPrototype=Object.getPrototypeOf(Object.getPrototypeOf([][Symbol.iterator]()));function makeIterator(iterator,name,kind){const object={index:0,kind,target:iterator};const i={next(){if(Object.getPrototypeOf(this)!==i){throw new TypeError(`'next' called on an object that does not implement interface ${name} Iterator.`)}const{index,kind:kind2,target}=object;const values2=target();const len=values2.length;if(index>=len){return{value:void 0,done:true}}const pair=values2[index];object.index=index+1;return iteratorResult(pair,kind2)},[Symbol.toStringTag]:`${name} Iterator`};Object.setPrototypeOf(i,esIteratorPrototype);return Object.setPrototypeOf({},i)}function iteratorResult(pair,kind){let result2;switch(kind){case"key":{result2=pair[0];break}case"value":{result2=pair[1];break}case"key+value":{result2=pair;break}}return{value:result2,done:false}}async function fullyReadBody(body,processBody,processBodyError){const successSteps=processBody;const errorSteps=processBodyError;let reader;try{reader=body.stream.getReader()}catch(e){errorSteps(e);return}try{const result2=await readAllBytes(reader);successSteps(result2)}catch(e){errorSteps(e)}}var ReadableStream2=globalThis.ReadableStream;function isReadableStreamLike(stream3){if(!ReadableStream2){ReadableStream2=require("stream/web").ReadableStream}return stream3 instanceof ReadableStream2||stream3[Symbol.toStringTag]==="ReadableStream"&&typeof stream3.tee==="function"}var MAXIMUM_ARGUMENT_LENGTH=65535;function isomorphicDecode(input){if(input.length<MAXIMUM_ARGUMENT_LENGTH){return String.fromCharCode(...input)}return input.reduce((previous,current)=>previous+String.fromCharCode(current),"")}function readableStreamClose(controller){try{controller.close()}catch(err){if(!err.message.includes("Controller is already closed")){throw err}}}function isomorphicEncode(input){for(let i=0;i<input.length;i++){assert2(input.charCodeAt(i)<=255)}return input}async function readAllBytes(reader){const bytes8=[];let byteLength=0;while(true){const{done,value:chunk2}=await reader.read();if(done){return Buffer.concat(bytes8,byteLength)}if(!isUint8Array(chunk2)){throw new TypeError("Received non-Uint8Array chunk")}bytes8.push(chunk2);byteLength+=chunk2.length}}function urlIsLocal(url){assert2("protocol"in url);const protocol=url.protocol;return protocol==="about:"||protocol==="blob:"||protocol==="data:"}function urlHasHttpsScheme(url){if(typeof url==="string"){return url.startsWith("https:")}return url.protocol==="https:"}function urlIsHttpHttpsScheme(url){assert2("protocol"in url);const protocol=url.protocol;return protocol==="http:"||protocol==="https:"}var hasOwn2=Object.hasOwn||((dict,key)=>Object.prototype.hasOwnProperty.call(dict,key));module2.exports={isAborted:isAborted2,isCancelled,createDeferredPromise,ReadableStreamFrom,toUSVString,tryUpgradeRequestToAPotentiallyTrustworthyURL,coarsenedSharedCurrentTime,determineRequestsReferrer,makePolicyContainer,clonePolicyContainer,appendFetchMetadata,appendRequestOriginHeader,TAOCheck,corsCheck,crossOriginResourcePolicyCheck,createOpaqueTimingInfo,setRequestReferrerPolicyOnRedirect,isValidHTTPToken,requestBadPort,requestCurrentURL,responseURL,responseLocationURL,isBlobLike,isURLPotentiallyTrustworthy,isValidReasonPhrase,sameOrigin,normalizeMethod,serializeJavascriptValueToJSONString,makeIterator,isValidHeaderName,isValidHeaderValue,hasOwn:hasOwn2,isErrorLike,fullyReadBody,bytesMatch,isReadableStreamLike,readableStreamClose,isomorphicEncode,isomorphicDecode,urlIsLocal,urlHasHttpsScheme,urlIsHttpHttpsScheme,readAllBytes,normalizeMethodRecord,parseMetadata}}});var require_symbols2=__commonJS({"node_modules/undici/lib/fetch/symbols.js"(exports2,module2){"use strict";module2.exports={kUrl:Symbol("url"),kHeaders:Symbol("headers"),kSignal:Symbol("signal"),kState:Symbol("state"),kGuard:Symbol("guard"),kRealm:Symbol("realm")}}});var require_webidl=__commonJS({"node_modules/undici/lib/fetch/webidl.js"(exports2,module2){"use strict";var{types:types6}=require("util");var{hasOwn:hasOwn2,toUSVString}=require_util3();var webidl={};webidl.converters={};webidl.util={};webidl.errors={};webidl.errors.exception=function(message3){return new TypeError(`${message3.header}: ${message3.message}`)};webidl.errors.conversionFailed=function(context){const plural=context.types.length===1?"":" one of";const message3=`${context.argument} could not be converted to${plural}: ${context.types.join(", ")}.`;return webidl.errors.exception({header:context.prefix,message:message3})};webidl.errors.invalidArgument=function(context){return webidl.errors.exception({header:context.prefix,message:`"${context.value}" is an invalid ${context.type}.`})};webidl.brandCheck=function(V,I,opts=void 0){if((opts==null?void 0:opts.strict)!==false&&!(V instanceof I)){throw new TypeError("Illegal invocation")}else{return(V==null?void 0:V[Symbol.toStringTag])===I.prototype[Symbol.toStringTag]}};webidl.argumentLengthCheck=function({length},min3,ctx){if(length<min3){throw webidl.errors.exception({message:`${min3} argument${min3!==1?"s":""} required, but${length?" only":""} ${length} found.`,...ctx})}};webidl.illegalConstructor=function(){throw webidl.errors.exception({header:"TypeError",message:"Illegal constructor"})};webidl.util.Type=function(V){switch(typeof V){case"undefined":return"Undefined";case"boolean":return"Boolean";case"string":return"String";case"symbol":return"Symbol";case"number":return"Number";case"bigint":return"BigInt";case"function":case"object":{if(V===null){return"Null"}return"Object"}}};webidl.util.ConvertToInt=function(V,bitLength3,signedness,opts={}){let upperBound;let lowerBound;if(bitLength3===64){upperBound=Math.pow(2,53)-1;if(signedness==="unsigned"){lowerBound=0}else{lowerBound=Math.pow(-2,53)+1}}else if(signedness==="unsigned"){lowerBound=0;upperBound=Math.pow(2,bitLength3)-1}else{lowerBound=Math.pow(-2,bitLength3)-1;upperBound=Math.pow(2,bitLength3-1)-1}let x=Number(V);if(x===0){x=0}if(opts.enforceRange===true){if(Number.isNaN(x)||x===Number.POSITIVE_INFINITY||x===Number.NEGATIVE_INFINITY){throw webidl.errors.exception({header:"Integer conversion",message:`Could not convert ${V} to an integer.`})}x=webidl.util.IntegerPart(x);if(x<lowerBound||x>upperBound){throw webidl.errors.exception({header:"Integer conversion",message:`Value must be between ${lowerBound}-${upperBound}, got ${x}.`})}return x}if(!Number.isNaN(x)&&opts.clamp===true){x=Math.min(Math.max(x,lowerBound),upperBound);if(Math.floor(x)%2===0){x=Math.floor(x)}else{x=Math.ceil(x)}return x}if(Number.isNaN(x)||x===0&&Object.is(0,x)||x===Number.POSITIVE_INFINITY||x===Number.NEGATIVE_INFINITY){return 0}x=webidl.util.IntegerPart(x);x=x%Math.pow(2,bitLength3);if(signedness==="signed"&&x>=Math.pow(2,bitLength3)-1){return x-Math.pow(2,bitLength3)}return x};webidl.util.IntegerPart=function(n){const r=Math.floor(Math.abs(n));if(n<0){return-1*r}return r};webidl.sequenceConverter=function(converter){return V=>{var _a2;if(webidl.util.Type(V)!=="Object"){throw webidl.errors.exception({header:"Sequence",message:`Value of type ${webidl.util.Type(V)} is not an Object.`})}const method2=(_a2=V==null?void 0:V[Symbol.iterator])==null?void 0:_a2.call(V);const seq2=[];if(method2===void 0||typeof method2.next!=="function"){throw webidl.errors.exception({header:"Sequence",message:"Object is not an iterator."})}while(true){const{done,value}=method2.next();if(done){break}seq2.push(converter(value))}return seq2}};webidl.recordConverter=function(keyConverter,valueConverter){return O=>{if(webidl.util.Type(O)!=="Object"){throw webidl.errors.exception({header:"Record",message:`Value of type ${webidl.util.Type(O)} is not an Object.`})}const result2={};if(!types6.isProxy(O)){const keys3=Object.keys(O);for(const key of keys3){const typedKey=keyConverter(key);const typedValue=valueConverter(O[key]);result2[typedKey]=typedValue}return result2}const keys2=Reflect.ownKeys(O);for(const key of keys2){const desc=Reflect.getOwnPropertyDescriptor(O,key);if(desc==null?void 0:desc.enumerable){const typedKey=keyConverter(key);const typedValue=valueConverter(O[key]);result2[typedKey]=typedValue}}return result2}};webidl.interfaceConverter=function(i){return(V,opts={})=>{if(opts.strict!==false&&!(V instanceof i)){throw webidl.errors.exception({header:i.name,message:`Expected ${V} to be an instance of ${i.name}.`})}return V}};webidl.dictionaryConverter=function(converters){return dictionary=>{const type2=webidl.util.Type(dictionary);const dict={};if(type2==="Null"||type2==="Undefined"){return dict}else if(type2!=="Object"){throw webidl.errors.exception({header:"Dictionary",message:`Expected ${dictionary} to be one of: Null, Undefined, Object.`})}for(const options of converters){const{key,defaultValue,required,converter}=options;if(required===true){if(!hasOwn2(dictionary,key)){throw webidl.errors.exception({header:"Dictionary",message:`Missing required key "${key}".`})}}let value=dictionary[key];const hasDefault=hasOwn2(options,"defaultValue");if(hasDefault&&value!==null){value=value??defaultValue}if(required||hasDefault||value!==void 0){value=converter(value);if(options.allowedValues&&!options.allowedValues.includes(value)){throw webidl.errors.exception({header:"Dictionary",message:`${value} is not an accepted type. Expected one of ${options.allowedValues.join(", ")}.`})}dict[key]=value}}return dict}};webidl.nullableConverter=function(converter){return V=>{if(V===null){return V}return converter(V)}};webidl.converters.DOMString=function(V,opts={}){if(V===null&&opts.legacyNullToEmptyString){return""}if(typeof V==="symbol"){throw new TypeError("Could not convert argument of type symbol to string.")}return String(V)};webidl.converters.ByteString=function(V){const x=webidl.converters.DOMString(V);for(let index=0;index<x.length;index++){if(x.charCodeAt(index)>255){throw new TypeError(`Cannot convert argument to a ByteString because the character at index ${index} has a value of ${x.charCodeAt(index)} which is greater than 255.`)}}return x};webidl.converters.USVString=toUSVString;webidl.converters.boolean=function(V){const x=Boolean(V);return x};webidl.converters.any=function(V){return V};webidl.converters["long long"]=function(V){const x=webidl.util.ConvertToInt(V,64,"signed");return x};webidl.converters["unsigned long long"]=function(V){const x=webidl.util.ConvertToInt(V,64,"unsigned");return x};webidl.converters["unsigned long"]=function(V){const x=webidl.util.ConvertToInt(V,32,"unsigned");return x};webidl.converters["unsigned short"]=function(V,opts){const x=webidl.util.ConvertToInt(V,16,"unsigned",opts);return x};webidl.converters.ArrayBuffer=function(V,opts={}){if(webidl.util.Type(V)!=="Object"||!types6.isAnyArrayBuffer(V)){throw webidl.errors.conversionFailed({prefix:`${V}`,argument:`${V}`,types:["ArrayBuffer"]})}if(opts.allowShared===false&&types6.isSharedArrayBuffer(V)){throw webidl.errors.exception({header:"ArrayBuffer",message:"SharedArrayBuffer is not allowed."})}return V};webidl.converters.TypedArray=function(V,T,opts={}){if(webidl.util.Type(V)!=="Object"||!types6.isTypedArray(V)||V.constructor.name!==T.name){throw webidl.errors.conversionFailed({prefix:`${T.name}`,argument:`${V}`,types:[T.name]})}if(opts.allowShared===false&&types6.isSharedArrayBuffer(V.buffer)){throw webidl.errors.exception({header:"ArrayBuffer",message:"SharedArrayBuffer is not allowed."})}return V};webidl.converters.DataView=function(V,opts={}){if(webidl.util.Type(V)!=="Object"||!types6.isDataView(V)){throw webidl.errors.exception({header:"DataView",message:"Object is not a DataView."})}if(opts.allowShared===false&&types6.isSharedArrayBuffer(V.buffer)){throw webidl.errors.exception({header:"ArrayBuffer",message:"SharedArrayBuffer is not allowed."})}return V};webidl.converters.BufferSource=function(V,opts={}){if(types6.isAnyArrayBuffer(V)){return webidl.converters.ArrayBuffer(V,opts)}if(types6.isTypedArray(V)){return webidl.converters.TypedArray(V,V.constructor)}if(types6.isDataView(V)){return webidl.converters.DataView(V,opts)}throw new TypeError(`Could not convert ${V} to a BufferSource.`)};webidl.converters["sequence<ByteString>"]=webidl.sequenceConverter(webidl.converters.ByteString);webidl.converters["sequence<sequence<ByteString>>"]=webidl.sequenceConverter(webidl.converters["sequence<ByteString>"]);webidl.converters["record<ByteString, ByteString>"]=webidl.recordConverter(webidl.converters.ByteString,webidl.converters.ByteString);module2.exports={webidl}}});var require_dataURL=__commonJS({"node_modules/undici/lib/fetch/dataURL.js"(exports2,module2){var assert2=require("assert");var{atob:atob2}=require("buffer");var{isomorphicDecode}=require_util3();var encoder2=new TextEncoder;var HTTP_TOKEN_CODEPOINTS=/^[!#$%&'*+-.^_|~A-Za-z0-9]+$/;var HTTP_WHITESPACE_REGEX=/(\u000A|\u000D|\u0009|\u0020)/;var HTTP_QUOTED_STRING_TOKENS=/[\u0009|\u0020-\u007E|\u0080-\u00FF]/;function dataURLProcessor(dataURL){assert2(dataURL.protocol==="data:");let input=URLSerializer(dataURL,true);input=input.slice(5);const position={position:0};let mimeType=collectASequenceOfCodePointsFast(",",input,position);const mimeTypeLength=mimeType.length;mimeType=removeASCIIWhitespace(mimeType,true,true);if(position.position>=input.length){return"failure"}position.position++;const encodedBody=input.slice(mimeTypeLength+1);let body=stringPercentDecode(encodedBody);if(/;(\u0020){0,}base64$/i.test(mimeType)){const stringBody=isomorphicDecode(body);body=forgivingBase64(stringBody);if(body==="failure"){return"failure"}mimeType=mimeType.slice(0,-6);mimeType=mimeType.replace(/(\u0020)+$/,"");mimeType=mimeType.slice(0,-1)}if(mimeType.startsWith(";")){mimeType="text/plain"+mimeType}let mimeTypeRecord=parseMIMEType(mimeType);if(mimeTypeRecord==="failure"){mimeTypeRecord=parseMIMEType("text/plain;charset=US-ASCII")}return{mimeType:mimeTypeRecord,body}}function URLSerializer(url,excludeFragment=false){if(!excludeFragment){return url.href}const href=url.href;const hashLength=url.hash.length;return hashLength===0?href:href.substring(0,href.length-hashLength)}function collectASequenceOfCodePoints(condition,input,position){let result2="";while(position.position<input.length&&condition(input[position.position])){result2+=input[position.position];position.position++}return result2}function collectASequenceOfCodePointsFast(char,input,position){const idx=input.indexOf(char,position.position);const start=position.position;if(idx===-1){position.position=input.length;return input.slice(start)}position.position=idx;return input.slice(start,position.position)}function stringPercentDecode(input){const bytes8=encoder2.encode(input);return percentDecode(bytes8)}function percentDecode(input){const output=[];for(let i=0;i<input.length;i++){const byte=input[i];if(byte!==37){output.push(byte)}else if(byte===37&&!/^[0-9A-Fa-f]{2}$/i.test(String.fromCharCode(input[i+1],input[i+2]))){output.push(37)}else{const nextTwoBytes=String.fromCharCode(input[i+1],input[i+2]);const bytePoint=Number.parseInt(nextTwoBytes,16);output.push(bytePoint);i+=2}}return Uint8Array.from(output)}function parseMIMEType(input){input=removeHTTPWhitespace(input,true,true);const position={position:0};const type2=collectASequenceOfCodePointsFast("/",input,position);if(type2.length===0||!HTTP_TOKEN_CODEPOINTS.test(type2)){return"failure"}if(position.position>input.length){return"failure"}position.position++;let subtype=collectASequenceOfCodePointsFast(";",input,position);subtype=removeHTTPWhitespace(subtype,false,true);if(subtype.length===0||!HTTP_TOKEN_CODEPOINTS.test(subtype)){return"failure"}const typeLowercase=type2.toLowerCase();const subtypeLowercase=subtype.toLowerCase();const mimeType={type:typeLowercase,subtype:subtypeLowercase,parameters:new Map,essence:`${typeLowercase}/${subtypeLowercase}`};while(position.position<input.length){position.position++;collectASequenceOfCodePoints(char=>HTTP_WHITESPACE_REGEX.test(char),input,position);let parameterName=collectASequenceOfCodePoints(char=>char!==";"&&char!=="=",input,position);parameterName=parameterName.toLowerCase();if(position.position<input.length){if(input[position.position]===";"){continue}position.position++}if(position.position>input.length){break}let parameterValue=null;if(input[position.position]==='"'){parameterValue=collectAnHTTPQuotedString(input,position,true);collectASequenceOfCodePointsFast(";",input,position)}else{parameterValue=collectASequenceOfCodePointsFast(";",input,position);parameterValue=removeHTTPWhitespace(parameterValue,false,true);if(parameterValue.length===0){continue}}if(parameterName.length!==0&&HTTP_TOKEN_CODEPOINTS.test(parameterName)&&(parameterValue.length===0||HTTP_QUOTED_STRING_TOKENS.test(parameterValue))&&!mimeType.parameters.has(parameterName)){mimeType.parameters.set(parameterName,parameterValue)}}return mimeType}function forgivingBase64(data){data=data.replace(/[\u0009\u000A\u000C\u000D\u0020]/g,"");if(data.length%4===0){data=data.replace(/=?=$/,"")}if(data.length%4===1){return"failure"}if(/[^+/0-9A-Za-z]/.test(data)){return"failure"}const binary2=atob2(data);const bytes8=new Uint8Array(binary2.length);for(let byte=0;byte<binary2.length;byte++){bytes8[byte]=binary2.charCodeAt(byte)}return bytes8}function collectAnHTTPQuotedString(input,position,extractValue){const positionStart=position.position;let value="";assert2(input[position.position]==='"');position.position++;while(true){value+=collectASequenceOfCodePoints(char=>char!=='"'&&char!=="\\",input,position);if(position.position>=input.length){break}const quoteOrBackslash=input[position.position];position.position++;if(quoteOrBackslash==="\\"){if(position.position>=input.length){value+="\\";break}value+=input[position.position];position.position++}else{assert2(quoteOrBackslash==='"');break}}if(extractValue){return value}return input.slice(positionStart,position.position)}function serializeAMimeType(mimeType){assert2(mimeType!=="failure");const{parameters,essence}=mimeType;let serialization=essence;for(let[name,value]of parameters.entries()){serialization+=";";serialization+=name;serialization+="=";if(!HTTP_TOKEN_CODEPOINTS.test(value)){value=value.replace(/(\\|")/g,"\\$1");value='"'+value;value+='"'}serialization+=value}return serialization}function isHTTPWhiteSpace(char){return char==="\r"||char==="\n"||char==="	"||char===" "}function removeHTTPWhitespace(str2,leading=true,trailing=true){let lead=0;let trail=str2.length-1;if(leading){for(;lead<str2.length&&isHTTPWhiteSpace(str2[lead]);lead++);}if(trailing){for(;trail>0&&isHTTPWhiteSpace(str2[trail]);trail--);}return str2.slice(lead,trail+1)}function isASCIIWhitespace(char){return char==="\r"||char==="\n"||char==="	"||char==="\f"||char===" "}function removeASCIIWhitespace(str2,leading=true,trailing=true){let lead=0;let trail=str2.length-1;if(leading){for(;lead<str2.length&&isASCIIWhitespace(str2[lead]);lead++);}if(trailing){for(;trail>0&&isASCIIWhitespace(str2[trail]);trail--);}return str2.slice(lead,trail+1)}module2.exports={dataURLProcessor,URLSerializer,collectASequenceOfCodePoints,collectASequenceOfCodePointsFast,stringPercentDecode,parseMIMEType,collectAnHTTPQuotedString,serializeAMimeType}}});var require_file2=__commonJS({"node_modules/undici/lib/fetch/file.js"(exports2,module2){"use strict";var{Blob:Blob2,File:NativeFile}=require("buffer");var{types:types6}=require("util");var{kState}=require_symbols2();var{isBlobLike}=require_util3();var{webidl}=require_webidl();var{parseMIMEType,serializeAMimeType}=require_dataURL();var{kEnumerableProperty}=require_util2();var encoder2=new TextEncoder;var File2=class _File extends Blob2{constructor(fileBits,fileName,options={}){webidl.argumentLengthCheck(arguments,2,{header:"File constructor"});fileBits=webidl.converters["sequence<BlobPart>"](fileBits);fileName=webidl.converters.USVString(fileName);options=webidl.converters.FilePropertyBag(options);const n=fileName;let t=options.type;let d;substep:{if(t){t=parseMIMEType(t);if(t==="failure"){t="";break substep}t=serializeAMimeType(t).toLowerCase()}d=options.lastModified}super(processBlobParts(fileBits,options),{type:t});this[kState]={name:n,lastModified:d,type:t}}get name(){webidl.brandCheck(this,_File);return this[kState].name}get lastModified(){webidl.brandCheck(this,_File);return this[kState].lastModified}get type(){webidl.brandCheck(this,_File);return this[kState].type}};var FileLike=class _FileLike{constructor(blobLike,fileName,options={}){const n=fileName;const t=options.type;const d=options.lastModified??Date.now();this[kState]={blobLike,name:n,type:t,lastModified:d}}stream(...args2){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.stream(...args2)}arrayBuffer(...args2){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.arrayBuffer(...args2)}slice(...args2){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.slice(...args2)}text(...args2){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.text(...args2)}get size(){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.size}get type(){webidl.brandCheck(this,_FileLike);return this[kState].blobLike.type}get name(){webidl.brandCheck(this,_FileLike);return this[kState].name}get lastModified(){webidl.brandCheck(this,_FileLike);return this[kState].lastModified}get[Symbol.toStringTag](){return"File"}};Object.defineProperties(File2.prototype,{[Symbol.toStringTag]:{value:"File",configurable:true},name:kEnumerableProperty,lastModified:kEnumerableProperty});webidl.converters.Blob=webidl.interfaceConverter(Blob2);webidl.converters.BlobPart=function(V,opts){if(webidl.util.Type(V)==="Object"){if(isBlobLike(V)){return webidl.converters.Blob(V,{strict:false})}if(ArrayBuffer.isView(V)||types6.isAnyArrayBuffer(V)){return webidl.converters.BufferSource(V,opts)}}return webidl.converters.USVString(V,opts)};webidl.converters["sequence<BlobPart>"]=webidl.sequenceConverter(webidl.converters.BlobPart);webidl.converters.FilePropertyBag=webidl.dictionaryConverter([{key:"lastModified",converter:webidl.converters["long long"],get defaultValue(){return Date.now()}},{key:"type",converter:webidl.converters.DOMString,defaultValue:""},{key:"endings",converter:value=>{value=webidl.converters.DOMString(value);value=value.toLowerCase();if(value!=="native"){value="transparent"}return value},defaultValue:"transparent"}]);function processBlobParts(parts,options){const bytes8=[];for(const element of parts){if(typeof element==="string"){let s=element;if(options.endings==="native"){s=convertLineEndingsNative(s)}bytes8.push(encoder2.encode(s))}else if(types6.isAnyArrayBuffer(element)||types6.isTypedArray(element)){if(!element.buffer){bytes8.push(new Uint8Array(element))}else{bytes8.push(new Uint8Array(element.buffer,element.byteOffset,element.byteLength))}}else if(isBlobLike(element)){bytes8.push(element)}}return bytes8}function convertLineEndingsNative(s){let nativeLineEnding="\n";if(process.platform==="win32"){nativeLineEnding="\r\n"}return s.replace(/\r?\n/g,nativeLineEnding)}function isFileLike(object){return NativeFile&&object instanceof NativeFile||object instanceof File2||object&&(typeof object.stream==="function"||typeof object.arrayBuffer==="function")&&object[Symbol.toStringTag]==="File"}module2.exports={File:File2,FileLike,isFileLike}}});var require_formdata=__commonJS({"node_modules/undici/lib/fetch/formdata.js"(exports2,module2){"use strict";var{isBlobLike,toUSVString,makeIterator}=require_util3();var{kState}=require_symbols2();var{File:UndiciFile,FileLike,isFileLike}=require_file2();var{webidl}=require_webidl();var{Blob:Blob2,File:NativeFile}=require("buffer");var File2=NativeFile??UndiciFile;var FormData=class _FormData{constructor(form){if(form!==void 0){throw webidl.errors.conversionFailed({prefix:"FormData constructor",argument:"Argument 1",types:["undefined"]})}this[kState]=[]}append(name,value,filename=void 0){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,2,{header:"FormData.append"});if(arguments.length===3&&!isBlobLike(value)){throw new TypeError("Failed to execute 'append' on 'FormData': parameter 2 is not of type 'Blob'")}name=webidl.converters.USVString(name);value=isBlobLike(value)?webidl.converters.Blob(value,{strict:false}):webidl.converters.USVString(value);filename=arguments.length===3?webidl.converters.USVString(filename):void 0;const entry=makeEntry(name,value,filename);this[kState].push(entry)}delete(name){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,1,{header:"FormData.delete"});name=webidl.converters.USVString(name);this[kState]=this[kState].filter(entry=>entry.name!==name)}get(name){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,1,{header:"FormData.get"});name=webidl.converters.USVString(name);const idx=this[kState].findIndex(entry=>entry.name===name);if(idx===-1){return null}return this[kState][idx].value}getAll(name){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,1,{header:"FormData.getAll"});name=webidl.converters.USVString(name);return this[kState].filter(entry=>entry.name===name).map(entry=>entry.value)}has(name){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,1,{header:"FormData.has"});name=webidl.converters.USVString(name);return this[kState].findIndex(entry=>entry.name===name)!==-1}set(name,value,filename=void 0){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,2,{header:"FormData.set"});if(arguments.length===3&&!isBlobLike(value)){throw new TypeError("Failed to execute 'set' on 'FormData': parameter 2 is not of type 'Blob'")}name=webidl.converters.USVString(name);value=isBlobLike(value)?webidl.converters.Blob(value,{strict:false}):webidl.converters.USVString(value);filename=arguments.length===3?toUSVString(filename):void 0;const entry=makeEntry(name,value,filename);const idx=this[kState].findIndex(entry2=>entry2.name===name);if(idx!==-1){this[kState]=[...this[kState].slice(0,idx),entry,...this[kState].slice(idx+1).filter(entry2=>entry2.name!==name)]}else{this[kState].push(entry)}}entries(){webidl.brandCheck(this,_FormData);return makeIterator(()=>this[kState].map(pair=>[pair.name,pair.value]),"FormData","key+value")}keys(){webidl.brandCheck(this,_FormData);return makeIterator(()=>this[kState].map(pair=>[pair.name,pair.value]),"FormData","key")}values(){webidl.brandCheck(this,_FormData);return makeIterator(()=>this[kState].map(pair=>[pair.name,pair.value]),"FormData","value")}forEach(callbackFn,thisArg=globalThis){webidl.brandCheck(this,_FormData);webidl.argumentLengthCheck(arguments,1,{header:"FormData.forEach"});if(typeof callbackFn!=="function"){throw new TypeError("Failed to execute 'forEach' on 'FormData': parameter 1 is not of type 'Function'.")}for(const[key,value]of this){callbackFn.apply(thisArg,[value,key,this])}}};FormData.prototype[Symbol.iterator]=FormData.prototype.entries;Object.defineProperties(FormData.prototype,{[Symbol.toStringTag]:{value:"FormData",configurable:true}});function makeEntry(name,value,filename){name=Buffer.from(name).toString("utf8");if(typeof value==="string"){value=Buffer.from(value).toString("utf8")}else{if(!isFileLike(value)){value=value instanceof Blob2?new File2([value],"blob",{type:value.type}):new FileLike(value,"blob",{type:value.type})}if(filename!==void 0){const options={type:value.type,lastModified:value.lastModified};value=NativeFile&&value instanceof NativeFile||value instanceof UndiciFile?new File2([value],filename,options):new FileLike(value,filename,options)}}return{name,value}}module2.exports={FormData}}});var require_body=__commonJS({"node_modules/undici/lib/fetch/body.js"(exports2,module2){"use strict";var Busboy=require_main2();var util4=require_util2();var{ReadableStreamFrom,isBlobLike,isReadableStreamLike,readableStreamClose,createDeferredPromise,fullyReadBody}=require_util3();var{FormData}=require_formdata();var{kState}=require_symbols2();var{webidl}=require_webidl();var{DOMException:DOMException2,structuredClone:structuredClone2}=require_constants2();var{Blob:Blob2,File:NativeFile}=require("buffer");var{kBodyUsed}=require_symbols();var assert2=require("assert");var{isErrored}=require_util2();var{isUint8Array,isArrayBuffer:isArrayBuffer2}=require("util/types");var{File:UndiciFile}=require_file2();var{parseMIMEType,serializeAMimeType}=require_dataURL();var ReadableStream2=globalThis.ReadableStream;var File2=NativeFile??UndiciFile;var textEncoder=new TextEncoder;var textDecoder=new TextDecoder;function extractBody(object,keepalive=false){if(!ReadableStream2){ReadableStream2=require("stream/web").ReadableStream}let stream3=null;if(object instanceof ReadableStream2){stream3=object}else if(isBlobLike(object)){stream3=object.stream()}else{stream3=new ReadableStream2({async pull(controller){controller.enqueue(typeof source==="string"?textEncoder.encode(source):source);queueMicrotask(()=>readableStreamClose(controller))},start(){},type:void 0})}assert2(isReadableStreamLike(stream3));let action=null;let source=null;let length=null;let type2=null;if(typeof object==="string"){source=object;type2="text/plain;charset=UTF-8"}else if(object instanceof URLSearchParams){source=object.toString();type2="application/x-www-form-urlencoded;charset=UTF-8"}else if(isArrayBuffer2(object)){source=new Uint8Array(object.slice())}else if(ArrayBuffer.isView(object)){source=new Uint8Array(object.buffer.slice(object.byteOffset,object.byteOffset+object.byteLength))}else if(util4.isFormDataLike(object)){const boundary=`----formdata-undici-0${`${Math.floor(Math.random()*1e11)}`.padStart(11,"0")}`;const prefix=`--${boundary}\r
Content-Disposition: form-data`;const escape5=str2=>str2.replace(/\n/g,"%0A").replace(/\r/g,"%0D").replace(/"/g,"%22");const normalizeLinefeeds=value=>value.replace(/\r?\n|\r/g,"\r\n");const blobParts=[];const rn=new Uint8Array([13,10]);length=0;let hasUnknownSizeValue=false;for(const[name,value]of object){if(typeof value==="string"){const chunk3=textEncoder.encode(prefix+`; name="${escape5(normalizeLinefeeds(name))}"\r
\r
${normalizeLinefeeds(value)}\r
`);blobParts.push(chunk3);length+=chunk3.byteLength}else{const chunk3=textEncoder.encode(`${prefix}; name="${escape5(normalizeLinefeeds(name))}"`+(value.name?`; filename="${escape5(value.name)}"`:"")+`\r
Content-Type: ${value.type||"application/octet-stream"}\r
\r
`);blobParts.push(chunk3,value,rn);if(typeof value.size==="number"){length+=chunk3.byteLength+value.size+rn.byteLength}else{hasUnknownSizeValue=true}}}const chunk2=textEncoder.encode(`--${boundary}--`);blobParts.push(chunk2);length+=chunk2.byteLength;if(hasUnknownSizeValue){length=null}source=object;action=async function*(){for(const part of blobParts){if(part.stream){yield*part.stream()}else{yield part}}};type2="multipart/form-data; boundary="+boundary}else if(isBlobLike(object)){source=object;length=object.size;if(object.type){type2=object.type}}else if(typeof object[Symbol.asyncIterator]==="function"){if(keepalive){throw new TypeError("keepalive")}if(util4.isDisturbed(object)||object.locked){throw new TypeError("Response body object should not be disturbed or locked")}stream3=object instanceof ReadableStream2?object:ReadableStreamFrom(object)}if(typeof source==="string"||util4.isBuffer(source)){length=Buffer.byteLength(source)}if(action!=null){let iterator;stream3=new ReadableStream2({async start(){iterator=action(object)[Symbol.asyncIterator]()},async pull(controller){const{value,done}=await iterator.next();if(done){queueMicrotask(()=>{controller.close()})}else{if(!isErrored(stream3)){controller.enqueue(new Uint8Array(value))}}return controller.desiredSize>0},async cancel(reason){await iterator.return()},type:void 0})}const body={stream:stream3,source,length};return[body,type2]}function safelyExtractBody(object,keepalive=false){if(!ReadableStream2){ReadableStream2=require("stream/web").ReadableStream}if(object instanceof ReadableStream2){assert2(!util4.isDisturbed(object),"The body has already been consumed.");assert2(!object.locked,"The stream is locked.")}return extractBody(object,keepalive)}function cloneBody(body){const[out1,out2]=body.stream.tee();const out2Clone=structuredClone2(out2,{transfer:[out2]});const[,finalClone]=out2Clone.tee();body.stream=out1;return{stream:finalClone,length:body.length,source:body.source}}async function*consumeBody(body){if(body){if(isUint8Array(body)){yield body}else{const stream3=body.stream;if(util4.isDisturbed(stream3)){throw new TypeError("The body has already been consumed.")}if(stream3.locked){throw new TypeError("The stream is locked.")}stream3[kBodyUsed]=true;yield*stream3}}}function throwIfAborted(state){if(state.aborted){throw new DOMException2("The operation was aborted.","AbortError")}}function bodyMixinMethods(instance){const methods={blob(){return specConsumeBody(this,bytes8=>{let mimeType=bodyMimeType(this);if(mimeType==="failure"){mimeType=""}else if(mimeType){mimeType=serializeAMimeType(mimeType)}return new Blob2([bytes8],{type:mimeType})},instance)},arrayBuffer(){return specConsumeBody(this,bytes8=>{return new Uint8Array(bytes8).buffer},instance)},text(){return specConsumeBody(this,utf8DecodeBytes,instance)},json(){return specConsumeBody(this,parseJSONFromBytes,instance)},async formData(){webidl.brandCheck(this,instance);throwIfAborted(this[kState]);const contentType=this.headers.get("Content-Type");if(/multipart\/form-data/.test(contentType)){const headers={};for(const[key,value]of this.headers)headers[key.toLowerCase()]=value;const responseFormData=new FormData;let busboy;try{busboy=new Busboy({headers,preservePath:true})}catch(err){throw new DOMException2(`${err}`,"AbortError")}busboy.on("field",(name,value)=>{responseFormData.append(name,value)});busboy.on("file",(name,value,filename,encoding,mimeType)=>{const chunks=[];if(encoding==="base64"||encoding.toLowerCase()==="base64"){let base64chunk="";value.on("data",chunk2=>{base64chunk+=chunk2.toString().replace(/[\r\n]/gm,"");const end=base64chunk.length-base64chunk.length%4;chunks.push(Buffer.from(base64chunk.slice(0,end),"base64"));base64chunk=base64chunk.slice(end)});value.on("end",()=>{chunks.push(Buffer.from(base64chunk,"base64"));responseFormData.append(name,new File2(chunks,filename,{type:mimeType}))})}else{value.on("data",chunk2=>{chunks.push(chunk2)});value.on("end",()=>{responseFormData.append(name,new File2(chunks,filename,{type:mimeType}))})}});const busboyResolve=new Promise((resolve,reject2)=>{busboy.on("finish",resolve);busboy.on("error",err=>reject2(new TypeError(err)))});if(this.body!==null)for await(const chunk2 of consumeBody(this[kState].body))busboy.write(chunk2);busboy.end();await busboyResolve;return responseFormData}else if(/application\/x-www-form-urlencoded/.test(contentType)){let entries2;try{let text="";const streamingDecoder=new TextDecoder("utf-8",{ignoreBOM:true});for await(const chunk2 of consumeBody(this[kState].body)){if(!isUint8Array(chunk2)){throw new TypeError("Expected Uint8Array chunk")}text+=streamingDecoder.decode(chunk2,{stream:true})}text+=streamingDecoder.decode();entries2=new URLSearchParams(text)}catch(err){throw Object.assign(new TypeError,{cause:err})}const formData=new FormData;for(const[name,value]of entries2){formData.append(name,value)}return formData}else{await Promise.resolve();throwIfAborted(this[kState]);throw webidl.errors.exception({header:`${instance.name}.formData`,message:"Could not parse content as FormData."})}}};return methods}function mixinBody(prototype){Object.assign(prototype.prototype,bodyMixinMethods(prototype))}async function specConsumeBody(object,convertBytesToJSValue,instance){webidl.brandCheck(object,instance);throwIfAborted(object[kState]);if(bodyUnusable(object[kState].body)){throw new TypeError("Body is unusable")}const promise=createDeferredPromise();const errorSteps=error=>promise.reject(error);const successSteps=data=>{try{promise.resolve(convertBytesToJSValue(data))}catch(e){errorSteps(e)}};if(object[kState].body==null){successSteps(new Uint8Array);return promise.promise}await fullyReadBody(object[kState].body,successSteps,errorSteps);return promise.promise}function bodyUnusable(body){return body!=null&&(body.stream.locked||util4.isDisturbed(body.stream))}function utf8DecodeBytes(buffer){if(buffer.length===0){return""}if(buffer[0]===239&&buffer[1]===187&&buffer[2]===191){buffer=buffer.subarray(3)}const output=textDecoder.decode(buffer);return output}function parseJSONFromBytes(bytes8){return JSON.parse(utf8DecodeBytes(bytes8))}function bodyMimeType(object){const{headersList}=object[kState];const contentType=headersList.get("content-type");if(contentType===null){return"failure"}return parseMIMEType(contentType)}module2.exports={extractBody,safelyExtractBody,cloneBody,mixinBody}}});var require_request2=__commonJS({"node_modules/undici/lib/core/request.js"(exports2,module2){"use strict";var{InvalidArgumentError,NotSupportedError}=require_errors4();var assert2=require("assert");var{kHTTP2BuildRequest,kHTTP2CopyHeaders,kHTTP1BuildRequest}=require_symbols();var util4=require_util2();var tokenRegExp=/^[\^_`a-zA-Z\-0-9!#$%&'*+.|~]+$/;var headerCharRegex=/[^\t\x20-\x7e\x80-\xff]/;var invalidPathRegex=/[^\u0021-\u00ff]/;var kHandler=Symbol("handler");var channels={};var extractBody;try{const diagnosticsChannel=require("diagnostics_channel");channels.create=diagnosticsChannel.channel("undici:request:create");channels.bodySent=diagnosticsChannel.channel("undici:request:bodySent");channels.headers=diagnosticsChannel.channel("undici:request:headers");channels.trailers=diagnosticsChannel.channel("undici:request:trailers");channels.error=diagnosticsChannel.channel("undici:request:error")}catch{channels.create={hasSubscribers:false};channels.bodySent={hasSubscribers:false};channels.headers={hasSubscribers:false};channels.trailers={hasSubscribers:false};channels.error={hasSubscribers:false}}var Request2=class _Request{constructor(origin,{path:path23,method:method2,body,headers,query,idempotent,blocking,upgrade,headersTimeout,bodyTimeout,reset,throwOnError,expectContinue},handler){if(typeof path23!=="string"){throw new InvalidArgumentError("path must be a string")}else if(path23[0]!=="/"&&!(path23.startsWith("http://")||path23.startsWith("https://"))&&method2!=="CONNECT"){throw new InvalidArgumentError("path must be an absolute URL or start with a slash")}else if(invalidPathRegex.exec(path23)!==null){throw new InvalidArgumentError("invalid request path")}if(typeof method2!=="string"){throw new InvalidArgumentError("method must be a string")}else if(tokenRegExp.exec(method2)===null){throw new InvalidArgumentError("invalid request method")}if(upgrade&&typeof upgrade!=="string"){throw new InvalidArgumentError("upgrade must be a string")}if(headersTimeout!=null&&(!Number.isFinite(headersTimeout)||headersTimeout<0)){throw new InvalidArgumentError("invalid headersTimeout")}if(bodyTimeout!=null&&(!Number.isFinite(bodyTimeout)||bodyTimeout<0)){throw new InvalidArgumentError("invalid bodyTimeout")}if(reset!=null&&typeof reset!=="boolean"){throw new InvalidArgumentError("invalid reset")}if(expectContinue!=null&&typeof expectContinue!=="boolean"){throw new InvalidArgumentError("invalid expectContinue")}this.headersTimeout=headersTimeout;this.bodyTimeout=bodyTimeout;this.throwOnError=throwOnError===true;this.method=method2;this.abort=null;if(body==null){this.body=null}else if(util4.isStream(body)){this.body=body;const rState=this.body._readableState;if(!rState||!rState.autoDestroy){this.endHandler=function autoDestroy(){util4.destroy(this)};this.body.on("end",this.endHandler)}this.errorHandler=err=>{if(this.abort){this.abort(err)}else{this.error=err}};this.body.on("error",this.errorHandler)}else if(util4.isBuffer(body)){this.body=body.byteLength?body:null}else if(ArrayBuffer.isView(body)){this.body=body.buffer.byteLength?Buffer.from(body.buffer,body.byteOffset,body.byteLength):null}else if(body instanceof ArrayBuffer){this.body=body.byteLength?Buffer.from(body):null}else if(typeof body==="string"){this.body=body.length?Buffer.from(body):null}else if(util4.isFormDataLike(body)||util4.isIterable(body)||util4.isBlobLike(body)){this.body=body}else{throw new InvalidArgumentError("body must be a string, a Buffer, a Readable stream, an iterable, or an async iterable")}this.completed=false;this.aborted=false;this.upgrade=upgrade||null;this.path=query?util4.buildURL(path23,query):path23;this.origin=origin;this.idempotent=idempotent==null?method2==="HEAD"||method2==="GET":idempotent;this.blocking=blocking==null?false:blocking;this.reset=reset==null?null:reset;this.host=null;this.contentLength=null;this.contentType=null;this.headers="";this.expectContinue=expectContinue!=null?expectContinue:false;if(Array.isArray(headers)){if(headers.length%2!==0){throw new InvalidArgumentError("headers array must be even")}for(let i=0;i<headers.length;i+=2){processHeader(this,headers[i],headers[i+1])}}else if(headers&&typeof headers==="object"){const keys2=Object.keys(headers);for(let i=0;i<keys2.length;i++){const key=keys2[i];processHeader(this,key,headers[key])}}else if(headers!=null){throw new InvalidArgumentError("headers must be an object or an array")}if(util4.isFormDataLike(this.body)){if(util4.nodeMajor<16||util4.nodeMajor===16&&util4.nodeMinor<8){throw new InvalidArgumentError("Form-Data bodies are only supported in node v16.8 and newer.")}if(!extractBody){extractBody=require_body().extractBody}const[bodyStream,contentType]=extractBody(body);if(this.contentType==null){this.contentType=contentType;this.headers+=`content-type: ${contentType}\r
`}this.body=bodyStream.stream;this.contentLength=bodyStream.length}else if(util4.isBlobLike(body)&&this.contentType==null&&body.type){this.contentType=body.type;this.headers+=`content-type: ${body.type}\r
`}util4.validateHandler(handler,method2,upgrade);this.servername=util4.getServerName(this.host);this[kHandler]=handler;if(channels.create.hasSubscribers){channels.create.publish({request:this})}}onBodySent(chunk2){if(this[kHandler].onBodySent){try{return this[kHandler].onBodySent(chunk2)}catch(err){this.abort(err)}}}onRequestSent(){if(channels.bodySent.hasSubscribers){channels.bodySent.publish({request:this})}if(this[kHandler].onRequestSent){try{return this[kHandler].onRequestSent()}catch(err){this.abort(err)}}}onConnect(abort){assert2(!this.aborted);assert2(!this.completed);if(this.error){abort(this.error)}else{this.abort=abort;return this[kHandler].onConnect(abort)}}onHeaders(statusCode,headers,resume,statusText){assert2(!this.aborted);assert2(!this.completed);if(channels.headers.hasSubscribers){channels.headers.publish({request:this,response:{statusCode,headers,statusText}})}try{return this[kHandler].onHeaders(statusCode,headers,resume,statusText)}catch(err){this.abort(err)}}onData(chunk2){assert2(!this.aborted);assert2(!this.completed);try{return this[kHandler].onData(chunk2)}catch(err){this.abort(err);return false}}onUpgrade(statusCode,headers,socket){assert2(!this.aborted);assert2(!this.completed);return this[kHandler].onUpgrade(statusCode,headers,socket)}onComplete(trailers){this.onFinally();assert2(!this.aborted);this.completed=true;if(channels.trailers.hasSubscribers){channels.trailers.publish({request:this,trailers})}try{return this[kHandler].onComplete(trailers)}catch(err){this.onError(err)}}onError(error){this.onFinally();if(channels.error.hasSubscribers){channels.error.publish({request:this,error})}if(this.aborted){return}this.aborted=true;return this[kHandler].onError(error)}onFinally(){if(this.errorHandler){this.body.off("error",this.errorHandler);this.errorHandler=null}if(this.endHandler){this.body.off("end",this.endHandler);this.endHandler=null}}addHeader(key,value){processHeader(this,key,value);return this}static[kHTTP1BuildRequest](origin,opts,handler){return new _Request(origin,opts,handler)}static[kHTTP2BuildRequest](origin,opts,handler){const headers=opts.headers;opts={...opts,headers:null};const request=new _Request(origin,opts,handler);request.headers={};if(Array.isArray(headers)){if(headers.length%2!==0){throw new InvalidArgumentError("headers array must be even")}for(let i=0;i<headers.length;i+=2){processHeader(request,headers[i],headers[i+1],true)}}else if(headers&&typeof headers==="object"){const keys2=Object.keys(headers);for(let i=0;i<keys2.length;i++){const key=keys2[i];processHeader(request,key,headers[key],true)}}else if(headers!=null){throw new InvalidArgumentError("headers must be an object or an array")}return request}static[kHTTP2CopyHeaders](raw){const rawHeaders=raw.split("\r\n");const headers={};for(const header2 of rawHeaders){const[key,value]=header2.split(": ");if(value==null||value.length===0)continue;if(headers[key])headers[key]+=`,${value}`;else headers[key]=value}return headers}};function processHeaderValue(key,val,skipAppend){if(val&&typeof val==="object"){throw new InvalidArgumentError(`invalid ${key} header`)}val=val!=null?`${val}`:"";if(headerCharRegex.exec(val)!==null){throw new InvalidArgumentError(`invalid ${key} header`)}return skipAppend?val:`${key}: ${val}\r
`}function processHeader(request,key,val,skipAppend=false){if(val&&(typeof val==="object"&&!Array.isArray(val))){throw new InvalidArgumentError(`invalid ${key} header`)}else if(val===void 0){return}if(request.host===null&&key.length===4&&key.toLowerCase()==="host"){if(headerCharRegex.exec(val)!==null){throw new InvalidArgumentError(`invalid ${key} header`)}request.host=val}else if(request.contentLength===null&&key.length===14&&key.toLowerCase()==="content-length"){request.contentLength=parseInt(val,10);if(!Number.isFinite(request.contentLength)){throw new InvalidArgumentError("invalid content-length header")}}else if(request.contentType===null&&key.length===12&&key.toLowerCase()==="content-type"){request.contentType=val;if(skipAppend)request.headers[key]=processHeaderValue(key,val,skipAppend);else request.headers+=processHeaderValue(key,val)}else if(key.length===17&&key.toLowerCase()==="transfer-encoding"){throw new InvalidArgumentError("invalid transfer-encoding header")}else if(key.length===10&&key.toLowerCase()==="connection"){const value=typeof val==="string"?val.toLowerCase():null;if(value!=="close"&&value!=="keep-alive"){throw new InvalidArgumentError("invalid connection header")}else if(value==="close"){request.reset=true}}else if(key.length===10&&key.toLowerCase()==="keep-alive"){throw new InvalidArgumentError("invalid keep-alive header")}else if(key.length===7&&key.toLowerCase()==="upgrade"){throw new InvalidArgumentError("invalid upgrade header")}else if(key.length===6&&key.toLowerCase()==="expect"){throw new NotSupportedError("expect header not supported")}else if(tokenRegExp.exec(key)===null){throw new InvalidArgumentError("invalid header key")}else{if(Array.isArray(val)){for(let i=0;i<val.length;i++){if(skipAppend){if(request.headers[key])request.headers[key]+=`,${processHeaderValue(key,val[i],skipAppend)}`;else request.headers[key]=processHeaderValue(key,val[i],skipAppend)}else{request.headers+=processHeaderValue(key,val[i])}}}else{if(skipAppend)request.headers[key]=processHeaderValue(key,val,skipAppend);else request.headers+=processHeaderValue(key,val)}}}module2.exports=Request2}});var require_dispatcher=__commonJS({"node_modules/undici/lib/dispatcher.js"(exports2,module2){"use strict";var EventEmitter3=require("events");var Dispatcher=class extends EventEmitter3{dispatch(){throw new Error("not implemented")}close(){throw new Error("not implemented")}destroy(){throw new Error("not implemented")}};module2.exports=Dispatcher}});var require_dispatcher_base=__commonJS({"node_modules/undici/lib/dispatcher-base.js"(exports2,module2){"use strict";var Dispatcher=require_dispatcher();var{ClientDestroyedError,ClientClosedError,InvalidArgumentError}=require_errors4();var{kDestroy,kClose,kDispatch,kInterceptors}=require_symbols();var kDestroyed=Symbol("destroyed");var kClosed=Symbol("closed");var kOnDestroyed=Symbol("onDestroyed");var kOnClosed=Symbol("onClosed");var kInterceptedDispatch=Symbol("Intercepted Dispatch");var DispatcherBase=class extends Dispatcher{constructor(){super();this[kDestroyed]=false;this[kOnDestroyed]=null;this[kClosed]=false;this[kOnClosed]=[]}get destroyed(){return this[kDestroyed]}get closed(){return this[kClosed]}get interceptors(){return this[kInterceptors]}set interceptors(newInterceptors){if(newInterceptors){for(let i=newInterceptors.length-1;i>=0;i--){const interceptor=this[kInterceptors][i];if(typeof interceptor!=="function"){throw new InvalidArgumentError("interceptor must be an function")}}}this[kInterceptors]=newInterceptors}close(callback){if(callback===void 0){return new Promise((resolve,reject2)=>{this.close((err,data)=>{return err?reject2(err):resolve(data)})})}if(typeof callback!=="function"){throw new InvalidArgumentError("invalid callback")}if(this[kDestroyed]){queueMicrotask(()=>callback(new ClientDestroyedError,null));return}if(this[kClosed]){if(this[kOnClosed]){this[kOnClosed].push(callback)}else{queueMicrotask(()=>callback(null,null))}return}this[kClosed]=true;this[kOnClosed].push(callback);const onClosed=()=>{const callbacks=this[kOnClosed];this[kOnClosed]=null;for(let i=0;i<callbacks.length;i++){callbacks[i](null,null)}};this[kClose]().then(()=>this.destroy()).then(()=>{queueMicrotask(onClosed)})}destroy(err,callback){if(typeof err==="function"){callback=err;err=null}if(callback===void 0){return new Promise((resolve,reject2)=>{this.destroy(err,(err2,data)=>{return err2?reject2(err2):resolve(data)})})}if(typeof callback!=="function"){throw new InvalidArgumentError("invalid callback")}if(this[kDestroyed]){if(this[kOnDestroyed]){this[kOnDestroyed].push(callback)}else{queueMicrotask(()=>callback(null,null))}return}if(!err){err=new ClientDestroyedError}this[kDestroyed]=true;this[kOnDestroyed]=this[kOnDestroyed]||[];this[kOnDestroyed].push(callback);const onDestroyed=()=>{const callbacks=this[kOnDestroyed];this[kOnDestroyed]=null;for(let i=0;i<callbacks.length;i++){callbacks[i](null,null)}};this[kDestroy](err).then(()=>{queueMicrotask(onDestroyed)})}[kInterceptedDispatch](opts,handler){if(!this[kInterceptors]||this[kInterceptors].length===0){this[kInterceptedDispatch]=this[kDispatch];return this[kDispatch](opts,handler)}let dispatch=this[kDispatch].bind(this);for(let i=this[kInterceptors].length-1;i>=0;i--){dispatch=this[kInterceptors][i](dispatch)}this[kInterceptedDispatch]=dispatch;return dispatch(opts,handler)}dispatch(opts,handler){if(!handler||typeof handler!=="object"){throw new InvalidArgumentError("handler must be an object")}try{if(!opts||typeof opts!=="object"){throw new InvalidArgumentError("opts must be an object.")}if(this[kDestroyed]||this[kOnDestroyed]){throw new ClientDestroyedError}if(this[kClosed]){throw new ClientClosedError}return this[kInterceptedDispatch](opts,handler)}catch(err){if(typeof handler.onError!=="function"){throw new InvalidArgumentError("invalid onError method")}handler.onError(err);return false}}};module2.exports=DispatcherBase}});var require_connect=__commonJS({"node_modules/undici/lib/core/connect.js"(exports2,module2){"use strict";var net2=require("net");var assert2=require("assert");var util4=require_util2();var{InvalidArgumentError,ConnectTimeoutError}=require_errors4();var tls;var SessionCache;if(global.FinalizationRegistry&&!process.env.NODE_V8_COVERAGE){SessionCache=class WeakSessionCache{constructor(maxCachedSessions){this._maxCachedSessions=maxCachedSessions;this._sessionCache=new Map;this._sessionRegistry=new global.FinalizationRegistry(key=>{if(this._sessionCache.size<this._maxCachedSessions){return}const ref=this._sessionCache.get(key);if(ref!==void 0&&ref.deref()===void 0){this._sessionCache.delete(key)}})}get(sessionKey){const ref=this._sessionCache.get(sessionKey);return ref?ref.deref():null}set(sessionKey,session){if(this._maxCachedSessions===0){return}this._sessionCache.set(sessionKey,new WeakRef(session));this._sessionRegistry.register(session,sessionKey)}}}else{SessionCache=class SimpleSessionCache{constructor(maxCachedSessions){this._maxCachedSessions=maxCachedSessions;this._sessionCache=new Map}get(sessionKey){return this._sessionCache.get(sessionKey)}set(sessionKey,session){if(this._maxCachedSessions===0){return}if(this._sessionCache.size>=this._maxCachedSessions){const{value:oldestKey}=this._sessionCache.keys().next();this._sessionCache.delete(oldestKey)}this._sessionCache.set(sessionKey,session)}}}function buildConnector({allowH2,maxCachedSessions,socketPath,timeout,...opts}){if(maxCachedSessions!=null&&(!Number.isInteger(maxCachedSessions)||maxCachedSessions<0)){throw new InvalidArgumentError("maxCachedSessions must be a positive integer or zero")}const options={path:socketPath,...opts};const sessionCache=new SessionCache(maxCachedSessions==null?100:maxCachedSessions);timeout=timeout==null?1e4:timeout;allowH2=allowH2!=null?allowH2:false;return function connect({hostname,host,protocol,port,servername,localAddress,httpSocket},callback){let socket;if(protocol==="https:"){if(!tls){tls=require("tls")}servername=servername||options.servername||util4.getServerName(host)||null;const sessionKey=servername||hostname;const session=sessionCache.get(sessionKey)||null;assert2(sessionKey);socket=tls.connect({highWaterMark:16384,...options,servername,session,localAddress,ALPNProtocols:allowH2?["http/1.1","h2"]:["http/1.1"],socket:httpSocket,port:port||443,host:hostname});socket.on("session",function(session2){sessionCache.set(sessionKey,session2)})}else{assert2(!httpSocket,"httpSocket can only be sent on TLS update");socket=net2.connect({highWaterMark:64*1024,...options,localAddress,port:port||80,host:hostname})}if(options.keepAlive==null||options.keepAlive){const keepAliveInitialDelay=options.keepAliveInitialDelay===void 0?6e4:options.keepAliveInitialDelay;socket.setKeepAlive(true,keepAliveInitialDelay)}const cancelTimeout=setupTimeout(()=>onConnectTimeout(socket),timeout);socket.setNoDelay(true).once(protocol==="https:"?"secureConnect":"connect",function(){cancelTimeout();if(callback){const cb=callback;callback=null;cb(null,this)}}).on("error",function(err){cancelTimeout();if(callback){const cb=callback;callback=null;cb(err)}});return socket}}function setupTimeout(onConnectTimeout2,timeout){if(!timeout){return()=>{}}let s1=null;let s2=null;const timeoutId=setTimeout(()=>{s1=setImmediate(()=>{if(process.platform==="win32"){s2=setImmediate(()=>onConnectTimeout2())}else{onConnectTimeout2()}})},timeout);return()=>{clearTimeout(timeoutId);clearImmediate(s1);clearImmediate(s2)}}function onConnectTimeout(socket){util4.destroy(socket,new ConnectTimeoutError)}module2.exports=buildConnector}});var require_utils2=__commonJS({"node_modules/undici/lib/llhttp/utils.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.enumToMap=void 0;function enumToMap(obj){const res={};Object.keys(obj).forEach(key=>{const value=obj[key];if(typeof value==="number"){res[key]=value}});return res}exports2.enumToMap=enumToMap}});var require_constants3=__commonJS({"node_modules/undici/lib/llhttp/constants.js"(exports2){"use strict";Object.defineProperty(exports2,"__esModule",{value:true});exports2.SPECIAL_HEADERS=exports2.HEADER_STATE=exports2.MINOR=exports2.MAJOR=exports2.CONNECTION_TOKEN_CHARS=exports2.HEADER_CHARS=exports2.TOKEN=exports2.STRICT_TOKEN=exports2.HEX=exports2.URL_CHAR=exports2.STRICT_URL_CHAR=exports2.USERINFO_CHARS=exports2.MARK=exports2.ALPHANUM=exports2.NUM=exports2.HEX_MAP=exports2.NUM_MAP=exports2.ALPHA=exports2.FINISH=exports2.H_METHOD_MAP=exports2.METHOD_MAP=exports2.METHODS_RTSP=exports2.METHODS_ICE=exports2.METHODS_HTTP=exports2.METHODS=exports2.LENIENT_FLAGS=exports2.FLAGS=exports2.TYPE=exports2.ERROR=void 0;var utils_1=require_utils2();var ERROR;(function(ERROR2){ERROR2[ERROR2["OK"]=0]="OK";ERROR2[ERROR2["INTERNAL"]=1]="INTERNAL";ERROR2[ERROR2["STRICT"]=2]="STRICT";ERROR2[ERROR2["LF_EXPECTED"]=3]="LF_EXPECTED";ERROR2[ERROR2["UNEXPECTED_CONTENT_LENGTH"]=4]="UNEXPECTED_CONTENT_LENGTH";ERROR2[ERROR2["CLOSED_CONNECTION"]=5]="CLOSED_CONNECTION";ERROR2[ERROR2["INVALID_METHOD"]=6]="INVALID_METHOD";ERROR2[ERROR2["INVALID_URL"]=7]="INVALID_URL";ERROR2[ERROR2["INVALID_CONSTANT"]=8]="INVALID_CONSTANT";ERROR2[ERROR2["INVALID_VERSION"]=9]="INVALID_VERSION";ERROR2[ERROR2["INVALID_HEADER_TOKEN"]=10]="INVALID_HEADER_TOKEN";ERROR2[ERROR2["INVALID_CONTENT_LENGTH"]=11]="INVALID_CONTENT_LENGTH";ERROR2[ERROR2["INVALID_CHUNK_SIZE"]=12]="INVALID_CHUNK_SIZE";ERROR2[ERROR2["INVALID_STATUS"]=13]="INVALID_STATUS";ERROR2[ERROR2["INVALID_EOF_STATE"]=14]="INVALID_EOF_STATE";ERROR2[ERROR2["INVALID_TRANSFER_ENCODING"]=15]="INVALID_TRANSFER_ENCODING";ERROR2[ERROR2["CB_MESSAGE_BEGIN"]=16]="CB_MESSAGE_BEGIN";ERROR2[ERROR2["CB_HEADERS_COMPLETE"]=17]="CB_HEADERS_COMPLETE";ERROR2[ERROR2["CB_MESSAGE_COMPLETE"]=18]="CB_MESSAGE_COMPLETE";ERROR2[ERROR2["CB_CHUNK_HEADER"]=19]="CB_CHUNK_HEADER";ERROR2[ERROR2["CB_CHUNK_COMPLETE"]=20]="CB_CHUNK_COMPLETE";ERROR2[ERROR2["PAUSED"]=21]="PAUSED";ERROR2[ERROR2["PAUSED_UPGRADE"]=22]="PAUSED_UPGRADE";ERROR2[ERROR2["PAUSED_H2_UPGRADE"]=23]="PAUSED_H2_UPGRADE";ERROR2[ERROR2["USER"]=24]="USER"})(ERROR=exports2.ERROR||(exports2.ERROR={}));var TYPE;(function(TYPE2){TYPE2[TYPE2["BOTH"]=0]="BOTH";TYPE2[TYPE2["REQUEST"]=1]="REQUEST";TYPE2[TYPE2["RESPONSE"]=2]="RESPONSE"})(TYPE=exports2.TYPE||(exports2.TYPE={}));var FLAGS;(function(FLAGS2){FLAGS2[FLAGS2["CONNECTION_KEEP_ALIVE"]=1]="CONNECTION_KEEP_ALIVE";FLAGS2[FLAGS2["CONNECTION_CLOSE"]=2]="CONNECTION_CLOSE";FLAGS2[FLAGS2["CONNECTION_UPGRADE"]=4]="CONNECTION_UPGRADE";FLAGS2[FLAGS2["CHUNKED"]=8]="CHUNKED";FLAGS2[FLAGS2["UPGRADE"]=16]="UPGRADE";FLAGS2[FLAGS2["CONTENT_LENGTH"]=32]="CONTENT_LENGTH";FLAGS2[FLAGS2["SKIPBODY"]=64]="SKIPBODY";FLAGS2[FLAGS2["TRAILING"]=128]="TRAILING";FLAGS2[FLAGS2["TRANSFER_ENCODING"]=512]="TRANSFER_ENCODING"})(FLAGS=exports2.FLAGS||(exports2.FLAGS={}));var LENIENT_FLAGS;(function(LENIENT_FLAGS2){LENIENT_FLAGS2[LENIENT_FLAGS2["HEADERS"]=1]="HEADERS";LENIENT_FLAGS2[LENIENT_FLAGS2["CHUNKED_LENGTH"]=2]="CHUNKED_LENGTH";LENIENT_FLAGS2[LENIENT_FLAGS2["KEEP_ALIVE"]=4]="KEEP_ALIVE"})(LENIENT_FLAGS=exports2.LENIENT_FLAGS||(exports2.LENIENT_FLAGS={}));var METHODS;(function(METHODS2){METHODS2[METHODS2["DELETE"]=0]="DELETE";METHODS2[METHODS2["GET"]=1]="GET";METHODS2[METHODS2["HEAD"]=2]="HEAD";METHODS2[METHODS2["POST"]=3]="POST";METHODS2[METHODS2["PUT"]=4]="PUT";METHODS2[METHODS2["CONNECT"]=5]="CONNECT";METHODS2[METHODS2["OPTIONS"]=6]="OPTIONS";METHODS2[METHODS2["TRACE"]=7]="TRACE";METHODS2[METHODS2["COPY"]=8]="COPY";METHODS2[METHODS2["LOCK"]=9]="LOCK";METHODS2[METHODS2["MKCOL"]=10]="MKCOL";METHODS2[METHODS2["MOVE"]=11]="MOVE";METHODS2[METHODS2["PROPFIND"]=12]="PROPFIND";METHODS2[METHODS2["PROPPATCH"]=13]="PROPPATCH";METHODS2[METHODS2["SEARCH"]=14]="SEARCH";METHODS2[METHODS2["UNLOCK"]=15]="UNLOCK";METHODS2[METHODS2["BIND"]=16]="BIND";METHODS2[METHODS2["REBIND"]=17]="REBIND";METHODS2[METHODS2["UNBIND"]=18]="UNBIND";METHODS2[METHODS2["ACL"]=19]="ACL";METHODS2[METHODS2["REPORT"]=20]="REPORT";METHODS2[METHODS2["MKACTIVITY"]=21]="MKACTIVITY";METHODS2[METHODS2["CHECKOUT"]=22]="CHECKOUT";METHODS2[METHODS2["MERGE"]=23]="MERGE";METHODS2[METHODS2["M-SEARCH"]=24]="M-SEARCH";METHODS2[METHODS2["NOTIFY"]=25]="NOTIFY";METHODS2[METHODS2["SUBSCRIBE"]=26]="SUBSCRIBE";METHODS2[METHODS2["UNSUBSCRIBE"]=27]="UNSUBSCRIBE";METHODS2[METHODS2["PATCH"]=28]="PATCH";METHODS2[METHODS2["PURGE"]=29]="PURGE";METHODS2[METHODS2["MKCALENDAR"]=30]="MKCALENDAR";METHODS2[METHODS2["LINK"]=31]="LINK";METHODS2[METHODS2["UNLINK"]=32]="UNLINK";METHODS2[METHODS2["SOURCE"]=33]="SOURCE";METHODS2[METHODS2["PRI"]=34]="PRI";METHODS2[METHODS2["DESCRIBE"]=35]="DESCRIBE";METHODS2[METHODS2["ANNOUNCE"]=36]="ANNOUNCE";METHODS2[METHODS2["SETUP"]=37]="SETUP";METHODS2[METHODS2["PLAY"]=38]="PLAY";METHODS2[METHODS2["PAUSE"]=39]="PAUSE";METHODS2[METHODS2["TEARDOWN"]=40]="TEARDOWN";METHODS2[METHODS2["GET_PARAMETER"]=41]="GET_PARAMETER";METHODS2[METHODS2["SET_PARAMETER"]=42]="SET_PARAMETER";METHODS2[METHODS2["REDIRECT"]=43]="REDIRECT";METHODS2[METHODS2["RECORD"]=44]="RECORD";METHODS2[METHODS2["FLUSH"]=45]="FLUSH"})(METHODS=exports2.METHODS||(exports2.METHODS={}));exports2.METHODS_HTTP=[METHODS.DELETE,METHODS.GET,METHODS.HEAD,METHODS.POST,METHODS.PUT,METHODS.CONNECT,METHODS.OPTIONS,METHODS.TRACE,METHODS.COPY,METHODS.LOCK,METHODS.MKCOL,METHODS.MOVE,METHODS.PROPFIND,METHODS.PROPPATCH,METHODS.SEARCH,METHODS.UNLOCK,METHODS.BIND,METHODS.REBIND,METHODS.UNBIND,METHODS.ACL,METHODS.REPORT,METHODS.MKACTIVITY,METHODS.CHECKOUT,METHODS.MERGE,METHODS["M-SEARCH"],METHODS.NOTIFY,METHODS.SUBSCRIBE,METHODS.UNSUBSCRIBE,METHODS.PATCH,METHODS.PURGE,METHODS.MKCALENDAR,METHODS.LINK,METHODS.UNLINK,METHODS.PRI,METHODS.SOURCE];exports2.METHODS_ICE=[METHODS.SOURCE];exports2.METHODS_RTSP=[METHODS.OPTIONS,METHODS.DESCRIBE,METHODS.ANNOUNCE,METHODS.SETUP,METHODS.PLAY,METHODS.PAUSE,METHODS.TEARDOWN,METHODS.GET_PARAMETER,METHODS.SET_PARAMETER,METHODS.REDIRECT,METHODS.RECORD,METHODS.FLUSH,METHODS.GET,METHODS.POST];exports2.METHOD_MAP=utils_1.enumToMap(METHODS);exports2.H_METHOD_MAP={};Object.keys(exports2.METHOD_MAP).forEach(key=>{if(/^H/.test(key)){exports2.H_METHOD_MAP[key]=exports2.METHOD_MAP[key]}});var FINISH;(function(FINISH2){FINISH2[FINISH2["SAFE"]=0]="SAFE";FINISH2[FINISH2["SAFE_WITH_CB"]=1]="SAFE_WITH_CB";FINISH2[FINISH2["UNSAFE"]=2]="UNSAFE"})(FINISH=exports2.FINISH||(exports2.FINISH={}));exports2.ALPHA=[];for(let i="A".charCodeAt(0);i<="Z".charCodeAt(0);i++){exports2.ALPHA.push(String.fromCharCode(i));exports2.ALPHA.push(String.fromCharCode(i+32))}exports2.NUM_MAP={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9};exports2.HEX_MAP={0:0,1:1,2:2,3:3,4:4,5:5,6:6,7:7,8:8,9:9,A:10,B:11,C:12,D:13,E:14,F:15,a:10,b:11,c:12,d:13,e:14,f:15};exports2.NUM=["0","1","2","3","4","5","6","7","8","9"];exports2.ALPHANUM=exports2.ALPHA.concat(exports2.NUM);exports2.MARK=["-","_",".","!","~","*","'","(",")"];exports2.USERINFO_CHARS=exports2.ALPHANUM.concat(exports2.MARK).concat(["%",";",":","&","=","+","$",","]);exports2.STRICT_URL_CHAR=["!",'"',"$","%","&","'","(",")","*","+",",","-",".","/",":",";","<","=",">","@","[","\\","]","^","_","`","{","|","}","~"].concat(exports2.ALPHANUM);exports2.URL_CHAR=exports2.STRICT_URL_CHAR.concat(["	","\f"]);for(let i=128;i<=255;i++){exports2.URL_CHAR.push(i)}exports2.HEX=exports2.NUM.concat(["a","b","c","d","e","f","A","B","C","D","E","F"]);exports2.STRICT_TOKEN=["!","#","$","%","&","'","*","+","-",".","^","_","`","|","~"].concat(exports2.ALPHANUM);exports2.TOKEN=exports2.STRICT_TOKEN.concat([" "]);exports2.HEADER_CHARS=["	"];for(let i=32;i<=255;i++){if(i!==127){exports2.HEADER_CHARS.push(i)}}exports2.CONNECTION_TOKEN_CHARS=exports2.HEADER_CHARS.filter(c=>c!==44);exports2.MAJOR=exports2.NUM_MAP;exports2.MINOR=exports2.MAJOR;var HEADER_STATE;(function(HEADER_STATE2){HEADER_STATE2[HEADER_STATE2["GENERAL"]=0]="GENERAL";HEADER_STATE2[HEADER_STATE2["CONNECTION"]=1]="CONNECTION";HEADER_STATE2[HEADER_STATE2["CONTENT_LENGTH"]=2]="CONTENT_LENGTH";HEADER_STATE2[HEADER_STATE2["TRANSFER_ENCODING"]=3]="TRANSFER_ENCODING";HEADER_STATE2[HEADER_STATE2["UPGRADE"]=4]="UPGRADE";HEADER_STATE2[HEADER_STATE2["CONNECTION_KEEP_ALIVE"]=5]="CONNECTION_KEEP_ALIVE";HEADER_STATE2[HEADER_STATE2["CONNECTION_CLOSE"]=6]="CONNECTION_CLOSE";HEADER_STATE2[HEADER_STATE2["CONNECTION_UPGRADE"]=7]="CONNECTION_UPGRADE";HEADER_STATE2[HEADER_STATE2["TRANSFER_ENCODING_CHUNKED"]=8]="TRANSFER_ENCODING_CHUNKED"})(HEADER_STATE=exports2.HEADER_STATE||(exports2.HEADER_STATE={}));exports2.SPECIAL_HEADERS={"connection":HEADER_STATE.CONNECTION,"content-length":HEADER_STATE.CONTENT_LENGTH,"proxy-connection":HEADER_STATE.CONNECTION,"transfer-encoding":HEADER_STATE.TRANSFER_ENCODING,"upgrade":HEADER_STATE.UPGRADE}}});var require_RedirectHandler=__commonJS({"node_modules/undici/lib/handler/RedirectHandler.js"(exports2,module2){"use strict";var util4=require_util2();var{kBodyUsed}=require_symbols();var assert2=require("assert");var{InvalidArgumentError}=require_errors4();var EE=require("events");var redirectableStatusCodes=[300,301,302,303,307,308];var kBody=Symbol("body");var BodyAsyncIterable=class{constructor(body){this[kBody]=body;this[kBodyUsed]=false}async*[Symbol.asyncIterator](){assert2(!this[kBodyUsed],"disturbed");this[kBodyUsed]=true;yield*this[kBody]}};var RedirectHandler=class{constructor(dispatch,maxRedirections,opts,handler){if(maxRedirections!=null&&(!Number.isInteger(maxRedirections)||maxRedirections<0)){throw new InvalidArgumentError("maxRedirections must be a positive number")}util4.validateHandler(handler,opts.method,opts.upgrade);this.dispatch=dispatch;this.location=null;this.abort=null;this.opts={...opts,maxRedirections:0};this.maxRedirections=maxRedirections;this.handler=handler;this.history=[];if(util4.isStream(this.opts.body)){if(util4.bodyLength(this.opts.body)===0){this.opts.body.on("data",function(){assert2(false)})}if(typeof this.opts.body.readableDidRead!=="boolean"){this.opts.body[kBodyUsed]=false;EE.prototype.on.call(this.opts.body,"data",function(){this[kBodyUsed]=true})}}else if(this.opts.body&&typeof this.opts.body.pipeTo==="function"){this.opts.body=new BodyAsyncIterable(this.opts.body)}else if(this.opts.body&&typeof this.opts.body!=="string"&&!ArrayBuffer.isView(this.opts.body)&&util4.isIterable(this.opts.body)){this.opts.body=new BodyAsyncIterable(this.opts.body)}}onConnect(abort){this.abort=abort;this.handler.onConnect(abort,{history:this.history})}onUpgrade(statusCode,headers,socket){this.handler.onUpgrade(statusCode,headers,socket)}onError(error){this.handler.onError(error)}onHeaders(statusCode,headers,resume,statusText){this.location=this.history.length>=this.maxRedirections||util4.isDisturbed(this.opts.body)?null:parseLocation(statusCode,headers);if(this.opts.origin){this.history.push(new URL(this.opts.path,this.opts.origin))}if(!this.location){return this.handler.onHeaders(statusCode,headers,resume,statusText)}const{origin,pathname,search:search2}=util4.parseURL(new URL(this.location,this.opts.origin&&new URL(this.opts.path,this.opts.origin)));const path23=search2?`${pathname}${search2}`:pathname;this.opts.headers=cleanRequestHeaders(this.opts.headers,statusCode===303,this.opts.origin!==origin);this.opts.path=path23;this.opts.origin=origin;this.opts.maxRedirections=0;this.opts.query=null;if(statusCode===303&&this.opts.method!=="HEAD"){this.opts.method="GET";this.opts.body=null}}onData(chunk2){if(this.location){}else{return this.handler.onData(chunk2)}}onComplete(trailers){if(this.location){this.location=null;this.abort=null;this.dispatch(this.opts,this)}else{this.handler.onComplete(trailers)}}onBodySent(chunk2){if(this.handler.onBodySent){this.handler.onBodySent(chunk2)}}};function parseLocation(statusCode,headers){if(redirectableStatusCodes.indexOf(statusCode)===-1){return null}for(let i=0;i<headers.length;i+=2){if(headers[i].toString().toLowerCase()==="location"){return headers[i+1]}}}function shouldRemoveHeader(header2,removeContent,unknownOrigin){if(header2.length===4){return util4.headerNameToString(header2)==="host"}if(removeContent&&util4.headerNameToString(header2).startsWith("content-")){return true}if(unknownOrigin&&(header2.length===13||header2.length===6||header2.length===19)){const name=util4.headerNameToString(header2);return name==="authorization"||name==="cookie"||name==="proxy-authorization"}return false}function cleanRequestHeaders(headers,removeContent,unknownOrigin){const ret=[];if(Array.isArray(headers)){for(let i=0;i<headers.length;i+=2){if(!shouldRemoveHeader(headers[i],removeContent,unknownOrigin)){ret.push(headers[i],headers[i+1])}}}else if(headers&&typeof headers==="object"){for(const key of Object.keys(headers)){if(!shouldRemoveHeader(key,removeContent,unknownOrigin)){ret.push(key,headers[key])}}}else{assert2(headers==null,"headers must be an object or an array")}return ret}module2.exports=RedirectHandler}});var require_redirectInterceptor=__commonJS({"node_modules/undici/lib/interceptor/redirectInterceptor.js"(exports2,module2){"use strict";var RedirectHandler=require_RedirectHandler();function createRedirectInterceptor({maxRedirections:defaultMaxRedirections}){return dispatch=>{return function Intercept(opts,handler){const{maxRedirections=defaultMaxRedirections}=opts;if(!maxRedirections){return dispatch(opts,handler)}const redirectHandler=new RedirectHandler(dispatch,maxRedirections,opts,handler);opts={...opts,maxRedirections:0};return dispatch(opts,redirectHandler)}}}module2.exports=createRedirectInterceptor}});var require_llhttp_wasm=__commonJS({"node_modules/undici/lib/llhttp/llhttp-wasm.js"(exports2,module2){module2.exports="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"}});var require_llhttp_simd_wasm=__commonJS({"node_modules/undici/lib/llhttp/llhttp_simd-wasm.js"(exports2,module2){module2.exports="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"}});var require_client3=__commonJS({"node_modules/undici/lib/client.js"(exports2,module2){"use strict";var assert2=require("assert");var net2=require("net");var http3=require("http");var{pipeline}=require("stream");var util4=require_util2();var timers=require_timers();var Request2=require_request2();var DispatcherBase=require_dispatcher_base();var{RequestContentLengthMismatchError,ResponseContentLengthMismatchError,InvalidArgumentError,RequestAbortedError,HeadersTimeoutError,HeadersOverflowError,SocketError,InformationalError,BodyTimeoutError,HTTPParserError,ResponseExceededMaxSizeError,ClientDestroyedError}=require_errors4();var buildConnector=require_connect();var{kUrl,kReset,kServerName,kClient,kBusy,kParser,kConnect,kBlocking,kResuming,kRunning,kPending,kSize,kWriting,kQueue,kConnected,kConnecting,kNeedDrain,kNoRef,kKeepAliveDefaultTimeout,kHostHeader,kPendingIdx,kRunningIdx,kError,kPipelining,kSocket,kKeepAliveTimeoutValue,kMaxHeadersSize,kKeepAliveMaxTimeout,kKeepAliveTimeoutThreshold,kHeadersTimeout,kBodyTimeout,kStrictContentLength,kConnector,kMaxRedirections,kMaxRequests,kCounter,kClose,kDestroy,kDispatch,kInterceptors,kLocalAddress,kMaxResponseSize,kHTTPConnVersion,kHost,kHTTP2Session,kHTTP2SessionState,kHTTP2BuildRequest,kHTTP2CopyHeaders,kHTTP1BuildRequest}=require_symbols();var http22;try{http22=require("http2")}catch{http22={constants:{}}}var{constants:{HTTP2_HEADER_AUTHORITY,HTTP2_HEADER_METHOD,HTTP2_HEADER_PATH,HTTP2_HEADER_SCHEME,HTTP2_HEADER_CONTENT_LENGTH,HTTP2_HEADER_EXPECT,HTTP2_HEADER_STATUS}}=http22;var h2ExperimentalWarned=false;var FastBuffer=Buffer[Symbol.species];var kClosedResolve=Symbol("kClosedResolve");var channels={};try{const diagnosticsChannel=require("diagnostics_channel");channels.sendHeaders=diagnosticsChannel.channel("undici:client:sendHeaders");channels.beforeConnect=diagnosticsChannel.channel("undici:client:beforeConnect");channels.connectError=diagnosticsChannel.channel("undici:client:connectError");channels.connected=diagnosticsChannel.channel("undici:client:connected")}catch{channels.sendHeaders={hasSubscribers:false};channels.beforeConnect={hasSubscribers:false};channels.connectError={hasSubscribers:false};channels.connected={hasSubscribers:false}}var Client3=class extends DispatcherBase{constructor(url,{interceptors,maxHeaderSize,headersTimeout,socketTimeout,requestTimeout,connectTimeout,bodyTimeout,idleTimeout,keepAlive,keepAliveTimeout,maxKeepAliveTimeout,keepAliveMaxTimeout,keepAliveTimeoutThreshold,socketPath,pipelining,tls,strictContentLength,maxCachedSessions,maxRedirections,connect:connect2,maxRequestsPerClient,localAddress,maxResponseSize,autoSelectFamily,autoSelectFamilyAttemptTimeout,allowH2,maxConcurrentStreams}={}){super();if(keepAlive!==void 0){throw new InvalidArgumentError("unsupported keepAlive, use pipelining=0 instead")}if(socketTimeout!==void 0){throw new InvalidArgumentError("unsupported socketTimeout, use headersTimeout & bodyTimeout instead")}if(requestTimeout!==void 0){throw new InvalidArgumentError("unsupported requestTimeout, use headersTimeout & bodyTimeout instead")}if(idleTimeout!==void 0){throw new InvalidArgumentError("unsupported idleTimeout, use keepAliveTimeout instead")}if(maxKeepAliveTimeout!==void 0){throw new InvalidArgumentError("unsupported maxKeepAliveTimeout, use keepAliveMaxTimeout instead")}if(maxHeaderSize!=null&&!Number.isFinite(maxHeaderSize)){throw new InvalidArgumentError("invalid maxHeaderSize")}if(socketPath!=null&&typeof socketPath!=="string"){throw new InvalidArgumentError("invalid socketPath")}if(connectTimeout!=null&&(!Number.isFinite(connectTimeout)||connectTimeout<0)){throw new InvalidArgumentError("invalid connectTimeout")}if(keepAliveTimeout!=null&&(!Number.isFinite(keepAliveTimeout)||keepAliveTimeout<=0)){throw new InvalidArgumentError("invalid keepAliveTimeout")}if(keepAliveMaxTimeout!=null&&(!Number.isFinite(keepAliveMaxTimeout)||keepAliveMaxTimeout<=0)){throw new InvalidArgumentError("invalid keepAliveMaxTimeout")}if(keepAliveTimeoutThreshold!=null&&!Number.isFinite(keepAliveTimeoutThreshold)){throw new InvalidArgumentError("invalid keepAliveTimeoutThreshold")}if(headersTimeout!=null&&(!Number.isInteger(headersTimeout)||headersTimeout<0)){throw new InvalidArgumentError("headersTimeout must be a positive integer or zero")}if(bodyTimeout!=null&&(!Number.isInteger(bodyTimeout)||bodyTimeout<0)){throw new InvalidArgumentError("bodyTimeout must be a positive integer or zero")}if(connect2!=null&&typeof connect2!=="function"&&typeof connect2!=="object"){throw new InvalidArgumentError("connect must be a function or an object")}if(maxRedirections!=null&&(!Number.isInteger(maxRedirections)||maxRedirections<0)){throw new InvalidArgumentError("maxRedirections must be a positive number")}if(maxRequestsPerClient!=null&&(!Number.isInteger(maxRequestsPerClient)||maxRequestsPerClient<0)){throw new InvalidArgumentError("maxRequestsPerClient must be a positive number")}if(localAddress!=null&&(typeof localAddress!=="string"||net2.isIP(localAddress)===0)){throw new InvalidArgumentError("localAddress must be valid string IP address")}if(maxResponseSize!=null&&(!Number.isInteger(maxResponseSize)||maxResponseSize<-1)){throw new InvalidArgumentError("maxResponseSize must be a positive number")}if(autoSelectFamilyAttemptTimeout!=null&&(!Number.isInteger(autoSelectFamilyAttemptTimeout)||autoSelectFamilyAttemptTimeout<-1)){throw new InvalidArgumentError("autoSelectFamilyAttemptTimeout must be a positive number")}if(allowH2!=null&&typeof allowH2!=="boolean"){throw new InvalidArgumentError("allowH2 must be a valid boolean value")}if(maxConcurrentStreams!=null&&(typeof maxConcurrentStreams!=="number"||maxConcurrentStreams<1)){throw new InvalidArgumentError("maxConcurrentStreams must be a possitive integer, greater than 0")}if(typeof connect2!=="function"){connect2=buildConnector({...tls,maxCachedSessions,allowH2,socketPath,timeout:connectTimeout,...util4.nodeHasAutoSelectFamily&&autoSelectFamily?{autoSelectFamily,autoSelectFamilyAttemptTimeout}:void 0,...connect2})}this[kInterceptors]=interceptors&&interceptors.Client&&Array.isArray(interceptors.Client)?interceptors.Client:[createRedirectInterceptor({maxRedirections})];this[kUrl]=util4.parseOrigin(url);this[kConnector]=connect2;this[kSocket]=null;this[kPipelining]=pipelining!=null?pipelining:1;this[kMaxHeadersSize]=maxHeaderSize||http3.maxHeaderSize;this[kKeepAliveDefaultTimeout]=keepAliveTimeout==null?4e3:keepAliveTimeout;this[kKeepAliveMaxTimeout]=keepAliveMaxTimeout==null?6e5:keepAliveMaxTimeout;this[kKeepAliveTimeoutThreshold]=keepAliveTimeoutThreshold==null?1e3:keepAliveTimeoutThreshold;this[kKeepAliveTimeoutValue]=this[kKeepAliveDefaultTimeout];this[kServerName]=null;this[kLocalAddress]=localAddress!=null?localAddress:null;this[kResuming]=0;this[kNeedDrain]=0;this[kHostHeader]=`host: ${this[kUrl].hostname}${this[kUrl].port?`:${this[kUrl].port}`:""}\r
`;this[kBodyTimeout]=bodyTimeout!=null?bodyTimeout:3e5;this[kHeadersTimeout]=headersTimeout!=null?headersTimeout:3e5;this[kStrictContentLength]=strictContentLength==null?true:strictContentLength;this[kMaxRedirections]=maxRedirections;this[kMaxRequests]=maxRequestsPerClient;this[kClosedResolve]=null;this[kMaxResponseSize]=maxResponseSize>-1?maxResponseSize:-1;this[kHTTPConnVersion]="h1";this[kHTTP2Session]=null;this[kHTTP2SessionState]=!allowH2?null:{openStreams:0,maxConcurrentStreams:maxConcurrentStreams!=null?maxConcurrentStreams:100};this[kHost]=`${this[kUrl].hostname}${this[kUrl].port?`:${this[kUrl].port}`:""}`;this[kQueue]=[];this[kRunningIdx]=0;this[kPendingIdx]=0}get pipelining(){return this[kPipelining]}set pipelining(value){this[kPipelining]=value;resume(this,true)}get[kPending](){return this[kQueue].length-this[kPendingIdx]}get[kRunning](){return this[kPendingIdx]-this[kRunningIdx]}get[kSize](){return this[kQueue].length-this[kRunningIdx]}get[kConnected](){return!!this[kSocket]&&!this[kConnecting]&&!this[kSocket].destroyed}get[kBusy](){const socket=this[kSocket];return socket&&(socket[kReset]||socket[kWriting]||socket[kBlocking])||this[kSize]>=(this[kPipelining]||1)||this[kPending]>0}[kConnect](cb){connect(this);this.once("connect",cb)}[kDispatch](opts,handler){const origin=opts.origin||this[kUrl].origin;const request=this[kHTTPConnVersion]==="h2"?Request2[kHTTP2BuildRequest](origin,opts,handler):Request2[kHTTP1BuildRequest](origin,opts,handler);this[kQueue].push(request);if(this[kResuming]){}else if(util4.bodyLength(request.body)==null&&util4.isIterable(request.body)){this[kResuming]=1;process.nextTick(resume,this)}else{resume(this,true)}if(this[kResuming]&&this[kNeedDrain]!==2&&this[kBusy]){this[kNeedDrain]=2}return this[kNeedDrain]<2}async[kClose](){return new Promise(resolve=>{if(!this[kSize]){resolve(null)}else{this[kClosedResolve]=resolve}})}async[kDestroy](err){return new Promise(resolve=>{const requests=this[kQueue].splice(this[kPendingIdx]);for(let i=0;i<requests.length;i++){const request=requests[i];errorRequest(this,request,err)}const callback=()=>{if(this[kClosedResolve]){this[kClosedResolve]();this[kClosedResolve]=null}resolve()};if(this[kHTTP2Session]!=null){util4.destroy(this[kHTTP2Session],err);this[kHTTP2Session]=null;this[kHTTP2SessionState]=null}if(!this[kSocket]){queueMicrotask(callback)}else{util4.destroy(this[kSocket].on("close",callback),err)}resume(this)})}};function onHttp2SessionError(err){assert2(err.code!=="ERR_TLS_CERT_ALTNAME_INVALID");this[kSocket][kError]=err;onError(this[kClient],err)}function onHttp2FrameError(type2,code,id){const err=new InformationalError(`HTTP/2: "frameError" received - type ${type2}, code ${code}`);if(id===0){this[kSocket][kError]=err;onError(this[kClient],err)}}function onHttp2SessionEnd(){util4.destroy(this,new SocketError("other side closed"));util4.destroy(this[kSocket],new SocketError("other side closed"))}function onHTTP2GoAway(code){const client=this[kClient];const err=new InformationalError(`HTTP/2: "GOAWAY" frame received with code ${code}`);client[kSocket]=null;client[kHTTP2Session]=null;if(client.destroyed){assert2(this[kPending]===0);const requests=client[kQueue].splice(client[kRunningIdx]);for(let i=0;i<requests.length;i++){const request=requests[i];errorRequest(this,request,err)}}else if(client[kRunning]>0){const request=client[kQueue][client[kRunningIdx]];client[kQueue][client[kRunningIdx]++]=null;errorRequest(client,request,err)}client[kPendingIdx]=client[kRunningIdx];assert2(client[kRunning]===0);client.emit("disconnect",client[kUrl],[client],err);resume(client)}var constants3=require_constants3();var createRedirectInterceptor=require_redirectInterceptor();var EMPTY_BUF=Buffer.alloc(0);async function lazyllhttp(){const llhttpWasmData=process.env.JEST_WORKER_ID?require_llhttp_wasm():void 0;let mod3;try{mod3=await WebAssembly.compile(Buffer.from(require_llhttp_simd_wasm(),"base64"))}catch(e){mod3=await WebAssembly.compile(Buffer.from(llhttpWasmData||require_llhttp_wasm(),"base64"))}return await WebAssembly.instantiate(mod3,{env:{wasm_on_url:(p,at2,len)=>{return 0},wasm_on_status:(p,at2,len)=>{assert2.strictEqual(currentParser.ptr,p);const start=at2-currentBufferPtr+currentBufferRef.byteOffset;return currentParser.onStatus(new FastBuffer(currentBufferRef.buffer,start,len))||0},wasm_on_message_begin:p=>{assert2.strictEqual(currentParser.ptr,p);return currentParser.onMessageBegin()||0},wasm_on_header_field:(p,at2,len)=>{assert2.strictEqual(currentParser.ptr,p);const start=at2-currentBufferPtr+currentBufferRef.byteOffset;return currentParser.onHeaderField(new FastBuffer(currentBufferRef.buffer,start,len))||0},wasm_on_header_value:(p,at2,len)=>{assert2.strictEqual(currentParser.ptr,p);const start=at2-currentBufferPtr+currentBufferRef.byteOffset;return currentParser.onHeaderValue(new FastBuffer(currentBufferRef.buffer,start,len))||0},wasm_on_headers_complete:(p,statusCode,upgrade,shouldKeepAlive)=>{assert2.strictEqual(currentParser.ptr,p);return currentParser.onHeadersComplete(statusCode,Boolean(upgrade),Boolean(shouldKeepAlive))||0},wasm_on_body:(p,at2,len)=>{assert2.strictEqual(currentParser.ptr,p);const start=at2-currentBufferPtr+currentBufferRef.byteOffset;return currentParser.onBody(new FastBuffer(currentBufferRef.buffer,start,len))||0},wasm_on_message_complete:p=>{assert2.strictEqual(currentParser.ptr,p);return currentParser.onMessageComplete()||0}}})}var llhttpInstance=null;var llhttpPromise=lazyllhttp();llhttpPromise.catch();var currentParser=null;var currentBufferRef=null;var currentBufferSize=0;var currentBufferPtr=null;var TIMEOUT_HEADERS=1;var TIMEOUT_BODY=2;var TIMEOUT_IDLE=3;var Parser=class{constructor(client,socket,{exports:exports3}){assert2(Number.isFinite(client[kMaxHeadersSize])&&client[kMaxHeadersSize]>0);this.llhttp=exports3;this.ptr=this.llhttp.llhttp_alloc(constants3.TYPE.RESPONSE);this.client=client;this.socket=socket;this.timeout=null;this.timeoutValue=null;this.timeoutType=null;this.statusCode=null;this.statusText="";this.upgrade=false;this.headers=[];this.headersSize=0;this.headersMaxSize=client[kMaxHeadersSize];this.shouldKeepAlive=false;this.paused=false;this.resume=this.resume.bind(this);this.bytesRead=0;this.keepAlive="";this.contentLength="";this.connection="";this.maxResponseSize=client[kMaxResponseSize]}setTimeout(value,type2){this.timeoutType=type2;if(value!==this.timeoutValue){timers.clearTimeout(this.timeout);if(value){this.timeout=timers.setTimeout(onParserTimeout,value,this);if(this.timeout.unref){this.timeout.unref()}}else{this.timeout=null}this.timeoutValue=value}else if(this.timeout){if(this.timeout.refresh){this.timeout.refresh()}}}resume(){if(this.socket.destroyed||!this.paused){return}assert2(this.ptr!=null);assert2(currentParser==null);this.llhttp.llhttp_resume(this.ptr);assert2(this.timeoutType===TIMEOUT_BODY);if(this.timeout){if(this.timeout.refresh){this.timeout.refresh()}}this.paused=false;this.execute(this.socket.read()||EMPTY_BUF);this.readMore()}readMore(){while(!this.paused&&this.ptr){const chunk2=this.socket.read();if(chunk2===null){break}this.execute(chunk2)}}execute(data){assert2(this.ptr!=null);assert2(currentParser==null);assert2(!this.paused);const{socket,llhttp}=this;if(data.length>currentBufferSize){if(currentBufferPtr){llhttp.free(currentBufferPtr)}currentBufferSize=Math.ceil(data.length/4096)*4096;currentBufferPtr=llhttp.malloc(currentBufferSize)}new Uint8Array(llhttp.memory.buffer,currentBufferPtr,currentBufferSize).set(data);try{let ret;try{currentBufferRef=data;currentParser=this;ret=llhttp.llhttp_execute(this.ptr,currentBufferPtr,data.length)}catch(err){throw err}finally{currentParser=null;currentBufferRef=null}const offset=llhttp.llhttp_get_error_pos(this.ptr)-currentBufferPtr;if(ret===constants3.ERROR.PAUSED_UPGRADE){this.onUpgrade(data.slice(offset))}else if(ret===constants3.ERROR.PAUSED){this.paused=true;socket.unshift(data.slice(offset))}else if(ret!==constants3.ERROR.OK){const ptr=llhttp.llhttp_get_error_reason(this.ptr);let message3="";if(ptr){const len=new Uint8Array(llhttp.memory.buffer,ptr).indexOf(0);message3="Response does not match the HTTP/1.1 protocol ("+Buffer.from(llhttp.memory.buffer,ptr,len).toString()+")"}throw new HTTPParserError(message3,constants3.ERROR[ret],data.slice(offset))}}catch(err){util4.destroy(socket,err)}}destroy(){assert2(this.ptr!=null);assert2(currentParser==null);this.llhttp.llhttp_free(this.ptr);this.ptr=null;timers.clearTimeout(this.timeout);this.timeout=null;this.timeoutValue=null;this.timeoutType=null;this.paused=false}onStatus(buf){this.statusText=buf.toString()}onMessageBegin(){const{socket,client}=this;if(socket.destroyed){return-1}const request=client[kQueue][client[kRunningIdx]];if(!request){return-1}}onHeaderField(buf){const len=this.headers.length;if((len&1)===0){this.headers.push(buf)}else{this.headers[len-1]=Buffer.concat([this.headers[len-1],buf])}this.trackHeader(buf.length)}onHeaderValue(buf){let len=this.headers.length;if((len&1)===1){this.headers.push(buf);len+=1}else{this.headers[len-1]=Buffer.concat([this.headers[len-1],buf])}const key=this.headers[len-2];if(key.length===10&&key.toString().toLowerCase()==="keep-alive"){this.keepAlive+=buf.toString()}else if(key.length===10&&key.toString().toLowerCase()==="connection"){this.connection+=buf.toString()}else if(key.length===14&&key.toString().toLowerCase()==="content-length"){this.contentLength+=buf.toString()}this.trackHeader(buf.length)}trackHeader(len){this.headersSize+=len;if(this.headersSize>=this.headersMaxSize){util4.destroy(this.socket,new HeadersOverflowError)}}onUpgrade(head2){const{upgrade,client,socket,headers,statusCode}=this;assert2(upgrade);const request=client[kQueue][client[kRunningIdx]];assert2(request);assert2(!socket.destroyed);assert2(socket===client[kSocket]);assert2(!this.paused);assert2(request.upgrade||request.method==="CONNECT");this.statusCode=null;this.statusText="";this.shouldKeepAlive=null;assert2(this.headers.length%2===0);this.headers=[];this.headersSize=0;socket.unshift(head2);socket[kParser].destroy();socket[kParser]=null;socket[kClient]=null;socket[kError]=null;socket.removeListener("error",onSocketError).removeListener("readable",onSocketReadable).removeListener("end",onSocketEnd).removeListener("close",onSocketClose);client[kSocket]=null;client[kQueue][client[kRunningIdx]++]=null;client.emit("disconnect",client[kUrl],[client],new InformationalError("upgrade"));try{request.onUpgrade(statusCode,headers,socket)}catch(err){util4.destroy(socket,err)}resume(client)}onHeadersComplete(statusCode,upgrade,shouldKeepAlive){const{client,socket,headers,statusText}=this;if(socket.destroyed){return-1}const request=client[kQueue][client[kRunningIdx]];if(!request){return-1}assert2(!this.upgrade);assert2(this.statusCode<200);if(statusCode===100){util4.destroy(socket,new SocketError("bad response",util4.getSocketInfo(socket)));return-1}if(upgrade&&!request.upgrade){util4.destroy(socket,new SocketError("bad upgrade",util4.getSocketInfo(socket)));return-1}assert2.strictEqual(this.timeoutType,TIMEOUT_HEADERS);this.statusCode=statusCode;this.shouldKeepAlive=shouldKeepAlive||request.method==="HEAD"&&!socket[kReset]&&this.connection.toLowerCase()==="keep-alive";if(this.statusCode>=200){const bodyTimeout=request.bodyTimeout!=null?request.bodyTimeout:client[kBodyTimeout];this.setTimeout(bodyTimeout,TIMEOUT_BODY)}else if(this.timeout){if(this.timeout.refresh){this.timeout.refresh()}}if(request.method==="CONNECT"){assert2(client[kRunning]===1);this.upgrade=true;return 2}if(upgrade){assert2(client[kRunning]===1);this.upgrade=true;return 2}assert2(this.headers.length%2===0);this.headers=[];this.headersSize=0;if(this.shouldKeepAlive&&client[kPipelining]){const keepAliveTimeout=this.keepAlive?util4.parseKeepAliveTimeout(this.keepAlive):null;if(keepAliveTimeout!=null){const timeout=Math.min(keepAliveTimeout-client[kKeepAliveTimeoutThreshold],client[kKeepAliveMaxTimeout]);if(timeout<=0){socket[kReset]=true}else{client[kKeepAliveTimeoutValue]=timeout}}else{client[kKeepAliveTimeoutValue]=client[kKeepAliveDefaultTimeout]}}else{socket[kReset]=true}const pause=request.onHeaders(statusCode,headers,this.resume,statusText)===false;if(request.aborted){return-1}if(request.method==="HEAD"){return 1}if(statusCode<200){return 1}if(socket[kBlocking]){socket[kBlocking]=false;resume(client)}return pause?constants3.ERROR.PAUSED:0}onBody(buf){const{client,socket,statusCode,maxResponseSize}=this;if(socket.destroyed){return-1}const request=client[kQueue][client[kRunningIdx]];assert2(request);assert2.strictEqual(this.timeoutType,TIMEOUT_BODY);if(this.timeout){if(this.timeout.refresh){this.timeout.refresh()}}assert2(statusCode>=200);if(maxResponseSize>-1&&this.bytesRead+buf.length>maxResponseSize){util4.destroy(socket,new ResponseExceededMaxSizeError);return-1}this.bytesRead+=buf.length;if(request.onData(buf)===false){return constants3.ERROR.PAUSED}}onMessageComplete(){const{client,socket,statusCode,upgrade,headers,contentLength,bytesRead,shouldKeepAlive}=this;if(socket.destroyed&&(!statusCode||shouldKeepAlive)){return-1}if(upgrade){return}const request=client[kQueue][client[kRunningIdx]];assert2(request);assert2(statusCode>=100);this.statusCode=null;this.statusText="";this.bytesRead=0;this.contentLength="";this.keepAlive="";this.connection="";assert2(this.headers.length%2===0);this.headers=[];this.headersSize=0;if(statusCode<200){return}if(request.method!=="HEAD"&&contentLength&&bytesRead!==parseInt(contentLength,10)){util4.destroy(socket,new ResponseContentLengthMismatchError);return-1}request.onComplete(headers);client[kQueue][client[kRunningIdx]++]=null;if(socket[kWriting]){assert2.strictEqual(client[kRunning],0);util4.destroy(socket,new InformationalError("reset"));return constants3.ERROR.PAUSED}else if(!shouldKeepAlive){util4.destroy(socket,new InformationalError("reset"));return constants3.ERROR.PAUSED}else if(socket[kReset]&&client[kRunning]===0){util4.destroy(socket,new InformationalError("reset"));return constants3.ERROR.PAUSED}else if(client[kPipelining]===1){setImmediate(resume,client)}else{resume(client)}}};function onParserTimeout(parser){const{socket,timeoutType,client}=parser;if(timeoutType===TIMEOUT_HEADERS){if(!socket[kWriting]||socket.writableNeedDrain||client[kRunning]>1){assert2(!parser.paused,"cannot be paused while waiting for headers");util4.destroy(socket,new HeadersTimeoutError)}}else if(timeoutType===TIMEOUT_BODY){if(!parser.paused){util4.destroy(socket,new BodyTimeoutError)}}else if(timeoutType===TIMEOUT_IDLE){assert2(client[kRunning]===0&&client[kKeepAliveTimeoutValue]);util4.destroy(socket,new InformationalError("socket idle timeout"))}}function onSocketReadable(){const{[kParser]:parser}=this;if(parser){parser.readMore()}}function onSocketError(err){const{[kClient]:client,[kParser]:parser}=this;assert2(err.code!=="ERR_TLS_CERT_ALTNAME_INVALID");if(client[kHTTPConnVersion]!=="h2"){if(err.code==="ECONNRESET"&&parser.statusCode&&!parser.shouldKeepAlive){parser.onMessageComplete();return}}this[kError]=err;onError(this[kClient],err)}function onError(client,err){if(client[kRunning]===0&&err.code!=="UND_ERR_INFO"&&err.code!=="UND_ERR_SOCKET"){assert2(client[kPendingIdx]===client[kRunningIdx]);const requests=client[kQueue].splice(client[kRunningIdx]);for(let i=0;i<requests.length;i++){const request=requests[i];errorRequest(client,request,err)}assert2(client[kSize]===0)}}function onSocketEnd(){const{[kParser]:parser,[kClient]:client}=this;if(client[kHTTPConnVersion]!=="h2"){if(parser.statusCode&&!parser.shouldKeepAlive){parser.onMessageComplete();return}}util4.destroy(this,new SocketError("other side closed",util4.getSocketInfo(this)))}function onSocketClose(){const{[kClient]:client,[kParser]:parser}=this;if(client[kHTTPConnVersion]==="h1"&&parser){if(!this[kError]&&parser.statusCode&&!parser.shouldKeepAlive){parser.onMessageComplete()}this[kParser].destroy();this[kParser]=null}const err=this[kError]||new SocketError("closed",util4.getSocketInfo(this));client[kSocket]=null;if(client.destroyed){assert2(client[kPending]===0);const requests=client[kQueue].splice(client[kRunningIdx]);for(let i=0;i<requests.length;i++){const request=requests[i];errorRequest(client,request,err)}}else if(client[kRunning]>0&&err.code!=="UND_ERR_INFO"){const request=client[kQueue][client[kRunningIdx]];client[kQueue][client[kRunningIdx]++]=null;errorRequest(client,request,err)}client[kPendingIdx]=client[kRunningIdx];assert2(client[kRunning]===0);client.emit("disconnect",client[kUrl],[client],err);resume(client)}async function connect(client){assert2(!client[kConnecting]);assert2(!client[kSocket]);let{host,hostname,protocol,port}=client[kUrl];if(hostname[0]==="["){const idx=hostname.indexOf("]");assert2(idx!==-1);const ip=hostname.substring(1,idx);assert2(net2.isIP(ip));hostname=ip}client[kConnecting]=true;if(channels.beforeConnect.hasSubscribers){channels.beforeConnect.publish({connectParams:{host,hostname,protocol,port,servername:client[kServerName],localAddress:client[kLocalAddress]},connector:client[kConnector]})}try{const socket=await new Promise((resolve,reject2)=>{client[kConnector]({host,hostname,protocol,port,servername:client[kServerName],localAddress:client[kLocalAddress]},(err,socket2)=>{if(err){reject2(err)}else{resolve(socket2)}})});if(client.destroyed){util4.destroy(socket.on("error",()=>{}),new ClientDestroyedError);return}client[kConnecting]=false;assert2(socket);const isH2=socket.alpnProtocol==="h2";if(isH2){if(!h2ExperimentalWarned){h2ExperimentalWarned=true;process.emitWarning("H2 support is experimental, expect them to change at any time.",{code:"UNDICI-H2"})}const session=http22.connect(client[kUrl],{createConnection:()=>socket,peerMaxConcurrentStreams:client[kHTTP2SessionState].maxConcurrentStreams});client[kHTTPConnVersion]="h2";session[kClient]=client;session[kSocket]=socket;session.on("error",onHttp2SessionError);session.on("frameError",onHttp2FrameError);session.on("end",onHttp2SessionEnd);session.on("goaway",onHTTP2GoAway);session.on("close",onSocketClose);session.unref();client[kHTTP2Session]=session;socket[kHTTP2Session]=session}else{if(!llhttpInstance){llhttpInstance=await llhttpPromise;llhttpPromise=null}socket[kNoRef]=false;socket[kWriting]=false;socket[kReset]=false;socket[kBlocking]=false;socket[kParser]=new Parser(client,socket,llhttpInstance)}socket[kCounter]=0;socket[kMaxRequests]=client[kMaxRequests];socket[kClient]=client;socket[kError]=null;socket.on("error",onSocketError).on("readable",onSocketReadable).on("end",onSocketEnd).on("close",onSocketClose);client[kSocket]=socket;if(channels.connected.hasSubscribers){channels.connected.publish({connectParams:{host,hostname,protocol,port,servername:client[kServerName],localAddress:client[kLocalAddress]},connector:client[kConnector],socket})}client.emit("connect",client[kUrl],[client])}catch(err){if(client.destroyed){return}client[kConnecting]=false;if(channels.connectError.hasSubscribers){channels.connectError.publish({connectParams:{host,hostname,protocol,port,servername:client[kServerName],localAddress:client[kLocalAddress]},connector:client[kConnector],error:err})}if(err.code==="ERR_TLS_CERT_ALTNAME_INVALID"){assert2(client[kRunning]===0);while(client[kPending]>0&&client[kQueue][client[kPendingIdx]].servername===client[kServerName]){const request=client[kQueue][client[kPendingIdx]++];errorRequest(client,request,err)}}else{onError(client,err)}client.emit("connectionError",client[kUrl],[client],err)}resume(client)}function emitDrain(client){client[kNeedDrain]=0;client.emit("drain",client[kUrl],[client])}function resume(client,sync){if(client[kResuming]===2){return}client[kResuming]=2;_resume(client,sync);client[kResuming]=0;if(client[kRunningIdx]>256){client[kQueue].splice(0,client[kRunningIdx]);client[kPendingIdx]-=client[kRunningIdx];client[kRunningIdx]=0}}function _resume(client,sync){while(true){if(client.destroyed){assert2(client[kPending]===0);return}if(client[kClosedResolve]&&!client[kSize]){client[kClosedResolve]();client[kClosedResolve]=null;return}const socket=client[kSocket];if(socket&&!socket.destroyed&&socket.alpnProtocol!=="h2"){if(client[kSize]===0){if(!socket[kNoRef]&&socket.unref){socket.unref();socket[kNoRef]=true}}else if(socket[kNoRef]&&socket.ref){socket.ref();socket[kNoRef]=false}if(client[kSize]===0){if(socket[kParser].timeoutType!==TIMEOUT_IDLE){socket[kParser].setTimeout(client[kKeepAliveTimeoutValue],TIMEOUT_IDLE)}}else if(client[kRunning]>0&&socket[kParser].statusCode<200){if(socket[kParser].timeoutType!==TIMEOUT_HEADERS){const request2=client[kQueue][client[kRunningIdx]];const headersTimeout=request2.headersTimeout!=null?request2.headersTimeout:client[kHeadersTimeout];socket[kParser].setTimeout(headersTimeout,TIMEOUT_HEADERS)}}}if(client[kBusy]){client[kNeedDrain]=2}else if(client[kNeedDrain]===2){if(sync){client[kNeedDrain]=1;process.nextTick(emitDrain,client)}else{emitDrain(client)}continue}if(client[kPending]===0){return}if(client[kRunning]>=(client[kPipelining]||1)){return}const request=client[kQueue][client[kPendingIdx]];if(client[kUrl].protocol==="https:"&&client[kServerName]!==request.servername){if(client[kRunning]>0){return}client[kServerName]=request.servername;if(socket&&socket.servername!==request.servername){util4.destroy(socket,new InformationalError("servername changed"));return}}if(client[kConnecting]){return}if(!socket&&!client[kHTTP2Session]){connect(client);return}if(socket.destroyed||socket[kWriting]||socket[kReset]||socket[kBlocking]){return}if(client[kRunning]>0&&!request.idempotent){return}if(client[kRunning]>0&&(request.upgrade||request.method==="CONNECT")){return}if(client[kRunning]>0&&util4.bodyLength(request.body)!==0&&(util4.isStream(request.body)||util4.isAsyncIterable(request.body))){return}if(!request.aborted&&write2(client,request)){client[kPendingIdx]++}else{client[kQueue].splice(client[kPendingIdx],1)}}}function shouldSendContentLength(method2){return method2!=="GET"&&method2!=="HEAD"&&method2!=="OPTIONS"&&method2!=="TRACE"&&method2!=="CONNECT"}function write2(client,request){if(client[kHTTPConnVersion]==="h2"){writeH2(client,client[kHTTP2Session],request);return}const{body,method:method2,path:path23,host,upgrade,headers,blocking,reset}=request;const expectsPayload=method2==="PUT"||method2==="POST"||method2==="PATCH";if(body&&typeof body.read==="function"){body.read(0)}const bodyLength=util4.bodyLength(body);let contentLength=bodyLength;if(contentLength===null){contentLength=request.contentLength}if(contentLength===0&&!expectsPayload){contentLength=null}if(shouldSendContentLength(method2)&&contentLength>0&&request.contentLength!==null&&request.contentLength!==contentLength){if(client[kStrictContentLength]){errorRequest(client,request,new RequestContentLengthMismatchError);return false}process.emitWarning(new RequestContentLengthMismatchError)}const socket=client[kSocket];try{request.onConnect(err=>{if(request.aborted||request.completed){return}errorRequest(client,request,err||new RequestAbortedError);util4.destroy(socket,new InformationalError("aborted"))})}catch(err){errorRequest(client,request,err)}if(request.aborted){return false}if(method2==="HEAD"){socket[kReset]=true}if(upgrade||method2==="CONNECT"){socket[kReset]=true}if(reset!=null){socket[kReset]=reset}if(client[kMaxRequests]&&socket[kCounter]++>=client[kMaxRequests]){socket[kReset]=true}if(blocking){socket[kBlocking]=true}let header2=`${method2} ${path23} HTTP/1.1\r
`;if(typeof host==="string"){header2+=`host: ${host}\r
`}else{header2+=client[kHostHeader]}if(upgrade){header2+=`connection: upgrade\r
upgrade: ${upgrade}\r
`}else if(client[kPipelining]&&!socket[kReset]){header2+="connection: keep-alive\r\n"}else{header2+="connection: close\r\n"}if(headers){header2+=headers}if(channels.sendHeaders.hasSubscribers){channels.sendHeaders.publish({request,headers:header2,socket})}if(!body||bodyLength===0){if(contentLength===0){socket.write(`${header2}content-length: 0\r
\r
`,"latin1")}else{assert2(contentLength===null,"no body must not have content length");socket.write(`${header2}\r
`,"latin1")}request.onRequestSent()}else if(util4.isBuffer(body)){assert2(contentLength===body.byteLength,"buffer body must have content length");socket.cork();socket.write(`${header2}content-length: ${contentLength}\r
\r
`,"latin1");socket.write(body);socket.uncork();request.onBodySent(body);request.onRequestSent();if(!expectsPayload){socket[kReset]=true}}else if(util4.isBlobLike(body)){if(typeof body.stream==="function"){writeIterable({body:body.stream(),client,request,socket,contentLength,header:header2,expectsPayload})}else{writeBlob({body,client,request,socket,contentLength,header:header2,expectsPayload})}}else if(util4.isStream(body)){writeStream({body,client,request,socket,contentLength,header:header2,expectsPayload})}else if(util4.isIterable(body)){writeIterable({body,client,request,socket,contentLength,header:header2,expectsPayload})}else{assert2(false)}return true}function writeH2(client,session,request){const{body,method:method2,path:path23,host,upgrade,expectContinue,signal,headers:reqHeaders}=request;let headers;if(typeof reqHeaders==="string")headers=Request2[kHTTP2CopyHeaders](reqHeaders.trim());else headers=reqHeaders;if(upgrade){errorRequest(client,request,new Error("Upgrade not supported for H2"));return false}try{request.onConnect(err=>{if(request.aborted||request.completed){return}errorRequest(client,request,err||new RequestAbortedError)})}catch(err){errorRequest(client,request,err)}if(request.aborted){return false}let stream3;const h2State=client[kHTTP2SessionState];headers[HTTP2_HEADER_AUTHORITY]=host||client[kHost];headers[HTTP2_HEADER_METHOD]=method2;if(method2==="CONNECT"){session.ref();stream3=session.request(headers,{endStream:false,signal});if(stream3.id&&!stream3.pending){request.onUpgrade(null,null,stream3);++h2State.openStreams}else{stream3.once("ready",()=>{request.onUpgrade(null,null,stream3);++h2State.openStreams})}stream3.once("close",()=>{h2State.openStreams-=1;if(h2State.openStreams===0)session.unref()});return true}headers[HTTP2_HEADER_PATH]=path23;headers[HTTP2_HEADER_SCHEME]="https";const expectsPayload=method2==="PUT"||method2==="POST"||method2==="PATCH";if(body&&typeof body.read==="function"){body.read(0)}let contentLength=util4.bodyLength(body);if(contentLength==null){contentLength=request.contentLength}if(contentLength===0||!expectsPayload){contentLength=null}if(shouldSendContentLength(method2)&&contentLength>0&&request.contentLength!=null&&request.contentLength!==contentLength){if(client[kStrictContentLength]){errorRequest(client,request,new RequestContentLengthMismatchError);return false}process.emitWarning(new RequestContentLengthMismatchError)}if(contentLength!=null){assert2(body,"no body must not have content length");headers[HTTP2_HEADER_CONTENT_LENGTH]=`${contentLength}`}session.ref();const shouldEndStream=method2==="GET"||method2==="HEAD";if(expectContinue){headers[HTTP2_HEADER_EXPECT]="100-continue";stream3=session.request(headers,{endStream:shouldEndStream,signal});stream3.once("continue",writeBodyH2)}else{stream3=session.request(headers,{endStream:shouldEndStream,signal});writeBodyH2()}++h2State.openStreams;stream3.once("response",headers2=>{const{[HTTP2_HEADER_STATUS]:statusCode,...realHeaders}=headers2;if(request.onHeaders(Number(statusCode),realHeaders,stream3.resume.bind(stream3),"")===false){stream3.pause()}});stream3.once("end",()=>{request.onComplete([])});stream3.on("data",chunk2=>{if(request.onData(chunk2)===false){stream3.pause()}});stream3.once("close",()=>{h2State.openStreams-=1;if(h2State.openStreams===0){session.unref()}});stream3.once("error",function(err){if(client[kHTTP2Session]&&!client[kHTTP2Session].destroyed&&!this.closed&&!this.destroyed){h2State.streams-=1;util4.destroy(stream3,err)}});stream3.once("frameError",(type2,code)=>{const err=new InformationalError(`HTTP/2: "frameError" received - type ${type2}, code ${code}`);errorRequest(client,request,err);if(client[kHTTP2Session]&&!client[kHTTP2Session].destroyed&&!this.closed&&!this.destroyed){h2State.streams-=1;util4.destroy(stream3,err)}});return true;function writeBodyH2(){if(!body){request.onRequestSent()}else if(util4.isBuffer(body)){assert2(contentLength===body.byteLength,"buffer body must have content length");stream3.cork();stream3.write(body);stream3.uncork();stream3.end();request.onBodySent(body);request.onRequestSent()}else if(util4.isBlobLike(body)){if(typeof body.stream==="function"){writeIterable({client,request,contentLength,h2stream:stream3,expectsPayload,body:body.stream(),socket:client[kSocket],header:""})}else{writeBlob({body,client,request,contentLength,expectsPayload,h2stream:stream3,header:"",socket:client[kSocket]})}}else if(util4.isStream(body)){writeStream({body,client,request,contentLength,expectsPayload,socket:client[kSocket],h2stream:stream3,header:""})}else if(util4.isIterable(body)){writeIterable({body,client,request,contentLength,expectsPayload,header:"",h2stream:stream3,socket:client[kSocket]})}else{assert2(false)}}}function writeStream({h2stream,body,client,request,socket,contentLength,header:header2,expectsPayload}){assert2(contentLength!==0||client[kRunning]===0,"stream body cannot be pipelined");if(client[kHTTPConnVersion]==="h2"){let onPipeData=function(chunk2){request.onBodySent(chunk2)};const pipe=pipeline(body,h2stream,err=>{if(err){util4.destroy(body,err);util4.destroy(h2stream,err)}else{request.onRequestSent()}});pipe.on("data",onPipeData);pipe.once("end",()=>{pipe.removeListener("data",onPipeData);util4.destroy(pipe)});return}let finished=false;const writer=new AsyncWriter({socket,request,contentLength,client,expectsPayload,header:header2});const onData=function(chunk2){if(finished){return}try{if(!writer.write(chunk2)&&this.pause){this.pause()}}catch(err){util4.destroy(this,err)}};const onDrain=function(){if(finished){return}if(body.resume){body.resume()}};const onAbort=function(){if(finished){return}const err=new RequestAbortedError;queueMicrotask(()=>onFinished(err))};const onFinished=function(err){if(finished){return}finished=true;assert2(socket.destroyed||socket[kWriting]&&client[kRunning]<=1);socket.off("drain",onDrain).off("error",onFinished);body.removeListener("data",onData).removeListener("end",onFinished).removeListener("error",onFinished).removeListener("close",onAbort);if(!err){try{writer.end()}catch(er){err=er}}writer.destroy(err);if(err&&(err.code!=="UND_ERR_INFO"||err.message!=="reset")){util4.destroy(body,err)}else{util4.destroy(body)}};body.on("data",onData).on("end",onFinished).on("error",onFinished).on("close",onAbort);if(body.resume){body.resume()}socket.on("drain",onDrain).on("error",onFinished)}async function writeBlob({h2stream,body,client,request,socket,contentLength,header:header2,expectsPayload}){assert2(contentLength===body.size,"blob body must have content length");const isH2=client[kHTTPConnVersion]==="h2";try{if(contentLength!=null&&contentLength!==body.size){throw new RequestContentLengthMismatchError}const buffer=Buffer.from(await body.arrayBuffer());if(isH2){h2stream.cork();h2stream.write(buffer);h2stream.uncork()}else{socket.cork();socket.write(`${header2}content-length: ${contentLength}\r
\r
`,"latin1");socket.write(buffer);socket.uncork()}request.onBodySent(buffer);request.onRequestSent();if(!expectsPayload){socket[kReset]=true}resume(client)}catch(err){util4.destroy(isH2?h2stream:socket,err)}}async function writeIterable({h2stream,body,client,request,socket,contentLength,header:header2,expectsPayload}){assert2(contentLength!==0||client[kRunning]===0,"iterator body cannot be pipelined");let callback=null;function onDrain(){if(callback){const cb=callback;callback=null;cb()}}const waitForDrain=()=>new Promise((resolve,reject2)=>{assert2(callback===null);if(socket[kError]){reject2(socket[kError])}else{callback=resolve}});if(client[kHTTPConnVersion]==="h2"){h2stream.on("close",onDrain).on("drain",onDrain);try{for await(const chunk2 of body){if(socket[kError]){throw socket[kError]}const res=h2stream.write(chunk2);request.onBodySent(chunk2);if(!res){await waitForDrain()}}}catch(err){h2stream.destroy(err)}finally{request.onRequestSent();h2stream.end();h2stream.off("close",onDrain).off("drain",onDrain)}return}socket.on("close",onDrain).on("drain",onDrain);const writer=new AsyncWriter({socket,request,contentLength,client,expectsPayload,header:header2});try{for await(const chunk2 of body){if(socket[kError]){throw socket[kError]}if(!writer.write(chunk2)){await waitForDrain()}}writer.end()}catch(err){writer.destroy(err)}finally{socket.off("close",onDrain).off("drain",onDrain)}}var AsyncWriter=class{constructor({socket,request,contentLength,client,expectsPayload,header:header2}){this.socket=socket;this.request=request;this.contentLength=contentLength;this.client=client;this.bytesWritten=0;this.expectsPayload=expectsPayload;this.header=header2;socket[kWriting]=true}write(chunk2){const{socket,request,contentLength,client,bytesWritten,expectsPayload,header:header2}=this;if(socket[kError]){throw socket[kError]}if(socket.destroyed){return false}const len=Buffer.byteLength(chunk2);if(!len){return true}if(contentLength!==null&&bytesWritten+len>contentLength){if(client[kStrictContentLength]){throw new RequestContentLengthMismatchError}process.emitWarning(new RequestContentLengthMismatchError)}socket.cork();if(bytesWritten===0){if(!expectsPayload){socket[kReset]=true}if(contentLength===null){socket.write(`${header2}transfer-encoding: chunked\r
`,"latin1")}else{socket.write(`${header2}content-length: ${contentLength}\r
\r
`,"latin1")}}if(contentLength===null){socket.write(`\r
${len.toString(16)}\r
`,"latin1")}this.bytesWritten+=len;const ret=socket.write(chunk2);socket.uncork();request.onBodySent(chunk2);if(!ret){if(socket[kParser].timeout&&socket[kParser].timeoutType===TIMEOUT_HEADERS){if(socket[kParser].timeout.refresh){socket[kParser].timeout.refresh()}}}return ret}end(){const{socket,contentLength,client,bytesWritten,expectsPayload,header:header2,request}=this;request.onRequestSent();socket[kWriting]=false;if(socket[kError]){throw socket[kError]}if(socket.destroyed){return}if(bytesWritten===0){if(expectsPayload){socket.write(`${header2}content-length: 0\r
\r
`,"latin1")}else{socket.write(`${header2}\r
`,"latin1")}}else if(contentLength===null){socket.write("\r\n0\r\n\r\n","latin1")}if(contentLength!==null&&bytesWritten!==contentLength){if(client[kStrictContentLength]){throw new RequestContentLengthMismatchError}else{process.emitWarning(new RequestContentLengthMismatchError)}}if(socket[kParser].timeout&&socket[kParser].timeoutType===TIMEOUT_HEADERS){if(socket[kParser].timeout.refresh){socket[kParser].timeout.refresh()}}resume(client)}destroy(err){const{socket,client}=this;socket[kWriting]=false;if(err){assert2(client[kRunning]<=1,"pipeline should only contain this request");util4.destroy(socket,err)}}};function errorRequest(client,request,err){try{request.onError(err);assert2(request.aborted)}catch(err2){client.emit("error",err2)}}module2.exports=Client3}});var require_fixed_queue=__commonJS({"node_modules/undici/lib/node/fixed-queue.js"(exports2,module2){"use strict";var kSize=2048;var kMask=kSize-1;var FixedCircularBuffer=class{constructor(){this.bottom=0;this.top=0;this.list=new Array(kSize);this.next=null}isEmpty(){return this.top===this.bottom}isFull(){return(this.top+1&kMask)===this.bottom}push(data){this.list[this.top]=data;this.top=this.top+1&kMask}shift(){const nextItem=this.list[this.bottom];if(nextItem===void 0)return null;this.list[this.bottom]=void 0;this.bottom=this.bottom+1&kMask;return nextItem}};module2.exports=class FixedQueue{constructor(){this.head=this.tail=new FixedCircularBuffer}isEmpty(){return this.head.isEmpty()}push(data){if(this.head.isFull()){this.head=this.head.next=new FixedCircularBuffer}this.head.push(data)}shift(){const tail2=this.tail;const next=tail2.shift();if(tail2.isEmpty()&&tail2.next!==null){this.tail=tail2.next}return next}}}});var require_pool_stats=__commonJS({"node_modules/undici/lib/pool-stats.js"(exports2,module2){var{kFree,kConnected,kPending,kQueued,kRunning,kSize}=require_symbols();var kPool=Symbol("pool");var PoolStats=class{constructor(pool2){this[kPool]=pool2}get connected(){return this[kPool][kConnected]}get free(){return this[kPool][kFree]}get pending(){return this[kPool][kPending]}get queued(){return this[kPool][kQueued]}get running(){return this[kPool][kRunning]}get size(){return this[kPool][kSize]}};module2.exports=PoolStats}});var require_pool_base=__commonJS({"node_modules/undici/lib/pool-base.js"(exports2,module2){"use strict";var DispatcherBase=require_dispatcher_base();var FixedQueue=require_fixed_queue();var{kConnected,kSize,kRunning,kPending,kQueued,kBusy,kFree,kUrl,kClose,kDestroy,kDispatch}=require_symbols();var PoolStats=require_pool_stats();var kClients=Symbol("clients");var kNeedDrain=Symbol("needDrain");var kQueue=Symbol("queue");var kClosedResolve=Symbol("closed resolve");var kOnDrain=Symbol("onDrain");var kOnConnect=Symbol("onConnect");var kOnDisconnect=Symbol("onDisconnect");var kOnConnectionError=Symbol("onConnectionError");var kGetDispatcher=Symbol("get dispatcher");var kAddClient=Symbol("add client");var kRemoveClient=Symbol("remove client");var kStats=Symbol("stats");var PoolBase=class extends DispatcherBase{constructor(){super();this[kQueue]=new FixedQueue;this[kClients]=[];this[kQueued]=0;const pool2=this;this[kOnDrain]=function onDrain(origin,targets){const queue=pool2[kQueue];let needDrain=false;while(!needDrain){const item=queue.shift();if(!item){break}pool2[kQueued]--;needDrain=!this.dispatch(item.opts,item.handler)}this[kNeedDrain]=needDrain;if(!this[kNeedDrain]&&pool2[kNeedDrain]){pool2[kNeedDrain]=false;pool2.emit("drain",origin,[pool2,...targets])}if(pool2[kClosedResolve]&&queue.isEmpty()){Promise.all(pool2[kClients].map(c=>c.close())).then(pool2[kClosedResolve])}};this[kOnConnect]=(origin,targets)=>{pool2.emit("connect",origin,[pool2,...targets])};this[kOnDisconnect]=(origin,targets,err)=>{pool2.emit("disconnect",origin,[pool2,...targets],err)};this[kOnConnectionError]=(origin,targets,err)=>{pool2.emit("connectionError",origin,[pool2,...targets],err)};this[kStats]=new PoolStats(this)}get[kBusy](){return this[kNeedDrain]}get[kConnected](){return this[kClients].filter(client=>client[kConnected]).length}get[kFree](){return this[kClients].filter(client=>client[kConnected]&&!client[kNeedDrain]).length}get[kPending](){let ret=this[kQueued];for(const{[kPending]:pending}of this[kClients]){ret+=pending}return ret}get[kRunning](){let ret=0;for(const{[kRunning]:running}of this[kClients]){ret+=running}return ret}get[kSize](){let ret=this[kQueued];for(const{[kSize]:size2}of this[kClients]){ret+=size2}return ret}get stats(){return this[kStats]}async[kClose](){if(this[kQueue].isEmpty()){return Promise.all(this[kClients].map(c=>c.close()))}else{return new Promise(resolve=>{this[kClosedResolve]=resolve})}}async[kDestroy](err){while(true){const item=this[kQueue].shift();if(!item){break}item.handler.onError(err)}return Promise.all(this[kClients].map(c=>c.destroy(err)))}[kDispatch](opts,handler){const dispatcher=this[kGetDispatcher]();if(!dispatcher){this[kNeedDrain]=true;this[kQueue].push({opts,handler});this[kQueued]++}else if(!dispatcher.dispatch(opts,handler)){dispatcher[kNeedDrain]=true;this[kNeedDrain]=!this[kGetDispatcher]()}return!this[kNeedDrain]}[kAddClient](client){client.on("drain",this[kOnDrain]).on("connect",this[kOnConnect]).on("disconnect",this[kOnDisconnect]).on("connectionError",this[kOnConnectionError]);this[kClients].push(client);if(this[kNeedDrain]){process.nextTick(()=>{if(this[kNeedDrain]){this[kOnDrain](client[kUrl],[this,client])}})}return this}[kRemoveClient](client){client.close(()=>{const idx=this[kClients].indexOf(client);if(idx!==-1){this[kClients].splice(idx,1)}});this[kNeedDrain]=this[kClients].some(dispatcher=>!dispatcher[kNeedDrain]&&dispatcher.closed!==true&&dispatcher.destroyed!==true)}};module2.exports={PoolBase,kClients,kNeedDrain,kAddClient,kRemoveClient,kGetDispatcher}}});var require_pool=__commonJS({"node_modules/undici/lib/pool.js"(exports2,module2){"use strict";var{PoolBase,kClients,kNeedDrain,kAddClient,kGetDispatcher}=require_pool_base();var Client3=require_client3();var{InvalidArgumentError}=require_errors4();var util4=require_util2();var{kUrl,kInterceptors}=require_symbols();var buildConnector=require_connect();var kOptions=Symbol("options");var kConnections=Symbol("connections");var kFactory=Symbol("factory");function defaultFactory(origin,opts){return new Client3(origin,opts)}var Pool=class extends PoolBase{constructor(origin,{connections,factory=defaultFactory,connect,connectTimeout,tls,maxCachedSessions,socketPath,autoSelectFamily,autoSelectFamilyAttemptTimeout,allowH2,...options}={}){super();if(connections!=null&&(!Number.isFinite(connections)||connections<0)){throw new InvalidArgumentError("invalid connections")}if(typeof factory!=="function"){throw new InvalidArgumentError("factory must be a function.")}if(connect!=null&&typeof connect!=="function"&&typeof connect!=="object"){throw new InvalidArgumentError("connect must be a function or an object")}if(typeof connect!=="function"){connect=buildConnector({...tls,maxCachedSessions,allowH2,socketPath,timeout:connectTimeout,...util4.nodeHasAutoSelectFamily&&autoSelectFamily?{autoSelectFamily,autoSelectFamilyAttemptTimeout}:void 0,...connect})}this[kInterceptors]=options.interceptors&&options.interceptors.Pool&&Array.isArray(options.interceptors.Pool)?options.interceptors.Pool:[];this[kConnections]=connections||null;this[kUrl]=util4.parseOrigin(origin);this[kOptions]={...util4.deepClone(options),connect,allowH2};this[kOptions].interceptors=options.interceptors?{...options.interceptors}:void 0;this[kFactory]=factory}[kGetDispatcher](){let dispatcher=this[kClients].find(dispatcher2=>!dispatcher2[kNeedDrain]);if(dispatcher){return dispatcher}if(!this[kConnections]||this[kClients].length<this[kConnections]){dispatcher=this[kFactory](this[kUrl],this[kOptions]);this[kAddClient](dispatcher)}return dispatcher}};module2.exports=Pool}});var require_balanced_pool=__commonJS({"node_modules/undici/lib/balanced-pool.js"(exports2,module2){"use strict";var{BalancedPoolMissingUpstreamError,InvalidArgumentError}=require_errors4();var{PoolBase,kClients,kNeedDrain,kAddClient,kRemoveClient,kGetDispatcher}=require_pool_base();var Pool=require_pool();var{kUrl,kInterceptors}=require_symbols();var{parseOrigin}=require_util2();var kFactory=Symbol("factory");var kOptions=Symbol("options");var kGreatestCommonDivisor=Symbol("kGreatestCommonDivisor");var kCurrentWeight=Symbol("kCurrentWeight");var kIndex=Symbol("kIndex");var kWeight=Symbol("kWeight");var kMaxWeightPerServer=Symbol("kMaxWeightPerServer");var kErrorPenalty=Symbol("kErrorPenalty");function getGreatestCommonDivisor(a,b){if(b===0)return a;return getGreatestCommonDivisor(b,a%b)}function defaultFactory(origin,opts){return new Pool(origin,opts)}var BalancedPool=class extends PoolBase{constructor(upstreams=[],{factory=defaultFactory,...opts}={}){super();this[kOptions]=opts;this[kIndex]=-1;this[kCurrentWeight]=0;this[kMaxWeightPerServer]=this[kOptions].maxWeightPerServer||100;this[kErrorPenalty]=this[kOptions].errorPenalty||15;if(!Array.isArray(upstreams)){upstreams=[upstreams]}if(typeof factory!=="function"){throw new InvalidArgumentError("factory must be a function.")}this[kInterceptors]=opts.interceptors&&opts.interceptors.BalancedPool&&Array.isArray(opts.interceptors.BalancedPool)?opts.interceptors.BalancedPool:[];this[kFactory]=factory;for(const upstream of upstreams){this.addUpstream(upstream)}this._updateBalancedPoolStats()}addUpstream(upstream){const upstreamOrigin=parseOrigin(upstream).origin;if(this[kClients].find(pool3=>pool3[kUrl].origin===upstreamOrigin&&pool3.closed!==true&&pool3.destroyed!==true)){return this}const pool2=this[kFactory](upstreamOrigin,Object.assign({},this[kOptions]));this[kAddClient](pool2);pool2.on("connect",()=>{pool2[kWeight]=Math.min(this[kMaxWeightPerServer],pool2[kWeight]+this[kErrorPenalty])});pool2.on("connectionError",()=>{pool2[kWeight]=Math.max(1,pool2[kWeight]-this[kErrorPenalty]);this._updateBalancedPoolStats()});pool2.on("disconnect",(...args2)=>{const err=args2[2];if(err&&err.code==="UND_ERR_SOCKET"){pool2[kWeight]=Math.max(1,pool2[kWeight]-this[kErrorPenalty]);this._updateBalancedPoolStats()}});for(const client of this[kClients]){client[kWeight]=this[kMaxWeightPerServer]}this._updateBalancedPoolStats();return this}_updateBalancedPoolStats(){this[kGreatestCommonDivisor]=this[kClients].map(p=>p[kWeight]).reduce(getGreatestCommonDivisor,0)}removeUpstream(upstream){const upstreamOrigin=parseOrigin(upstream).origin;const pool2=this[kClients].find(pool3=>pool3[kUrl].origin===upstreamOrigin&&pool3.closed!==true&&pool3.destroyed!==true);if(pool2){this[kRemoveClient](pool2)}return this}get upstreams(){return this[kClients].filter(dispatcher=>dispatcher.closed!==true&&dispatcher.destroyed!==true).map(p=>p[kUrl].origin)}[kGetDispatcher](){if(this[kClients].length===0){throw new BalancedPoolMissingUpstreamError}const dispatcher=this[kClients].find(dispatcher2=>!dispatcher2[kNeedDrain]&&dispatcher2.closed!==true&&dispatcher2.destroyed!==true);if(!dispatcher){return}const allClientsBusy=this[kClients].map(pool2=>pool2[kNeedDrain]).reduce((a,b)=>a&&b,true);if(allClientsBusy){return}let counter=0;let maxWeightIndex=this[kClients].findIndex(pool2=>!pool2[kNeedDrain]);while(counter++<this[kClients].length){this[kIndex]=(this[kIndex]+1)%this[kClients].length;const pool2=this[kClients][this[kIndex]];if(pool2[kWeight]>this[kClients][maxWeightIndex][kWeight]&&!pool2[kNeedDrain]){maxWeightIndex=this[kIndex]}if(this[kIndex]===0){this[kCurrentWeight]=this[kCurrentWeight]-this[kGreatestCommonDivisor];if(this[kCurrentWeight]<=0){this[kCurrentWeight]=this[kMaxWeightPerServer]}}if(pool2[kWeight]>=this[kCurrentWeight]&&!pool2[kNeedDrain]){return pool2}}this[kCurrentWeight]=this[kClients][maxWeightIndex][kWeight];this[kIndex]=maxWeightIndex;return this[kClients][maxWeightIndex]}};module2.exports=BalancedPool}});var require_dispatcher_weakref=__commonJS({"node_modules/undici/lib/compat/dispatcher-weakref.js"(exports2,module2){"use strict";var{kConnected,kSize}=require_symbols();var CompatWeakRef=class{constructor(value){this.value=value}deref(){return this.value[kConnected]===0&&this.value[kSize]===0?void 0:this.value}};var CompatFinalizer=class{constructor(finalizer){this.finalizer=finalizer}register(dispatcher,key){if(dispatcher.on){dispatcher.on("disconnect",()=>{if(dispatcher[kConnected]===0&&dispatcher[kSize]===0){this.finalizer(key)}})}}};module2.exports=function(){if(process.env.NODE_V8_COVERAGE){return{WeakRef:CompatWeakRef,FinalizationRegistry:CompatFinalizer}}return{WeakRef:global.WeakRef||CompatWeakRef,FinalizationRegistry:global.FinalizationRegistry||CompatFinalizer}}}});var require_agent2=__commonJS({"node_modules/undici/lib/agent.js"(exports2,module2){"use strict";var{InvalidArgumentError}=require_errors4();var{kClients,kRunning,kClose,kDestroy,kDispatch,kInterceptors}=require_symbols();var DispatcherBase=require_dispatcher_base();var Pool=require_pool();var Client3=require_client3();var util4=require_util2();var createRedirectInterceptor=require_redirectInterceptor();var{WeakRef:WeakRef2,FinalizationRegistry:FinalizationRegistry2}=require_dispatcher_weakref()();var kOnConnect=Symbol("onConnect");var kOnDisconnect=Symbol("onDisconnect");var kOnConnectionError=Symbol("onConnectionError");var kMaxRedirections=Symbol("maxRedirections");var kOnDrain=Symbol("onDrain");var kFactory=Symbol("factory");var kFinalizer=Symbol("finalizer");var kOptions=Symbol("options");function defaultFactory(origin,opts){return opts&&opts.connections===1?new Client3(origin,opts):new Pool(origin,opts)}var Agent=class extends DispatcherBase{constructor({factory=defaultFactory,maxRedirections=0,connect,...options}={}){super();if(typeof factory!=="function"){throw new InvalidArgumentError("factory must be a function.")}if(connect!=null&&typeof connect!=="function"&&typeof connect!=="object"){throw new InvalidArgumentError("connect must be a function or an object")}if(!Number.isInteger(maxRedirections)||maxRedirections<0){throw new InvalidA